/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.routing;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.routing.Routing;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngineFactory;
import com.sun.electric.util.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeaOfGates {
    public static int seaOfGatesRoute() {
        return SeaOfGates.seaOfGatesRoute(SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
    }

    public static int seaOfGatesRoute(SeaOfGatesEngineFactory.SeaOfGatesEngineType version) {
        UserInterface ui = Job.getUserInterface();
        Cell cell = ui.needCurrentCell();
        if (cell == null) {
            return 0;
        }
        Netlist netList = cell.getNetlist();
        if (netList == null) {
            System.out.println("Sorry, a deadlock aborted routing (network information unavailable).  Please try again");
            return 0;
        }
        Set<Network> nets = null;
        boolean didSelection = false;
        EditWindow_ wnd = ui.getCurrentEditWindow_();
        if (wnd != null && (nets = wnd.getHighlightedNetworks()).size() > 0) {
            didSelection = true;
        }
        if (!didSelection) {
            nets = new HashSet<Network>();
            Iterator<Network> it = netList.getNetworks();
            while (it.hasNext()) {
                nets.add(it.next());
            }
        }
        TreeSet<Network> netsToRoute = new TreeSet<Network>(new TextUtils.NetworksByName());
        Iterator<ArcInst> it = cell.getArcs();
        while (it.hasNext()) {
            Network net;
            ArcInst ai = it.next();
            if (ai.getProto() != Generic.tech().unrouted_arc || !nets.contains(net = netList.getNetwork(ai, 0))) continue;
            netsToRoute.add(net);
        }
        if (netsToRoute.size() <= 0) {
            ui.showErrorMessage(didSelection ? "Must select one or more Unrouted Arcs" : "There are no Unrouted Arcs in this cell", "Routing Error");
            return 0;
        }
        return SeaOfGates.seaOfGatesRoute(netList, netsToRoute, null, version);
    }

    public static int seaOfGatesRoute(Cell cell, SeaOfGatesOptions prefs) {
        return SeaOfGates.seaOfGatesRoute(cell, prefs, SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
    }

    public static int seaOfGatesRoute(Cell cell, SeaOfGatesOptions prefs, SeaOfGatesEngineFactory.SeaOfGatesEngineType version) {
        Netlist netList = cell.getNetlist();
        TreeSet<Network> netsToRoute = new TreeSet<Network>(new TextUtils.NetworksByName());
        Iterator<ArcInst> it = cell.getArcs();
        while (it.hasNext()) {
            ArcInst ai = it.next();
            if (ai.getProto() != Generic.tech().unrouted_arc) continue;
            netsToRoute.add(netList.getNetwork(ai, 0));
        }
        return SeaOfGates.seaOfGatesRoute(netList, netsToRoute, prefs, version);
    }

    private static int seaOfGatesRoute(Netlist netList, Set<Network> netsToRoute, SeaOfGatesOptions prefs, SeaOfGatesEngineFactory.SeaOfGatesEngineType version) {
        Cell cell = netList.getCell();
        Map<Network, ArcInst[]> arcMap = null;
        if (cell.getView() != View.SCHEMATIC) {
            arcMap = netList.getArcInstsByNetwork();
        }
        ArrayList<NetsToRoute> orderedNetsToRoute = new ArrayList<NetsToRoute>();
        for (Network net : netsToRoute) {
            if (net.getNetlist() != netList) {
                throw new IllegalArgumentException("netList");
            }
            boolean isPwrGnd = false;
            Iterator<Export> it = net.getExports();
            while (it.hasNext()) {
                Export e = it.next();
                if (!e.isGround() && !e.isPower()) continue;
                isPwrGnd = true;
                break;
            }
            double length = 0.0;
            ArcInst[] arcsOnNet = null;
            if (arcMap != null) {
                arcsOnNet = arcMap.get(net);
            } else {
                ArrayList<ArcInst> arcList = new ArrayList<ArcInst>();
                Iterator<ArcInst> it2 = net.getArcs();
                while (it2.hasNext()) {
                    arcList.add(it2.next());
                }
                arcsOnNet = arcList.toArray(new ArcInst[0]);
            }
            for (ArcInst ai : arcsOnNet) {
                length += ai.getLambdaLength();
                PortProto headPort = ai.getHeadPortInst().getPortProto();
                PortProto tailPort = ai.getTailPortInst().getPortProto();
                if (!headPort.isGround() && !headPort.isPower() && !tailPort.isGround() && !tailPort.isPower()) continue;
                isPwrGnd = true;
            }
            NetsToRoute ntr = new NetsToRoute(net, length, isPwrGnd);
            orderedNetsToRoute.add(ntr);
        }
        Collections.sort(orderedNetsToRoute, new NetsToRouteByLength());
        ArrayList<ArcInst> arcsToRoute = new ArrayList<ArcInst>();
        block4: for (NetsToRoute ntr : orderedNetsToRoute) {
            ArcInst[] arcsOnNet = null;
            if (arcMap != null) {
                arcsOnNet = arcMap.get(ntr.net);
            } else {
                ArrayList<ArcInst> arcList = new ArrayList<ArcInst>();
                Iterator<ArcInst> it = ntr.net.getArcs();
                while (it.hasNext()) {
                    arcList.add(it.next());
                }
                arcsOnNet = arcList.toArray(new ArcInst[0]);
            }
            for (ArcInst ai : arcsOnNet) {
                if (ai.getProto() != Generic.tech().unrouted_arc) continue;
                arcsToRoute.add(ai);
                continue block4;
            }
        }
        if (prefs != null) {
            SeaOfGatesEngine router = SeaOfGatesEngineFactory.createSeaOfGatesEngine(version);
            return router.routeIt(Job.getRunningJob(), cell, arcsToRoute, prefs);
        }
        prefs = new SeaOfGatesOptions();
        prefs.getOptionsFromPreferences();
        new SeaOfGatesJob(cell, arcsToRoute, prefs, version);
        return 0;
    }

    public static class SeaOfGatesOptions
    implements Serializable {
        public boolean useParallelFromToRoutes = true;
        public boolean useParallelRoutes = false;
        public double maxArcWidth = 10.0;
        public int complexityLimit = 200000;
        public int numberOfThreads;
        public boolean useSpecificNumberOfThreads;
        private Map<Technology, Set<ArcProto>> preventUse = new HashMap<Technology, Set<ArcProto>>();
        private Map<Technology, Set<ArcProto>> favor = new HashMap<Technology, Set<ArcProto>>();

        public void getOptionsFromPreferences() {
            this.useParallelFromToRoutes = Routing.isSeaOfGatesUseParallelFromToRoutes();
            this.useParallelRoutes = Routing.isSeaOfGatesUseParallelRoutes();
            this.maxArcWidth = Routing.getSeaOfGatesMaxWidth();
            this.complexityLimit = Routing.getSeaOfGatesComplexityLimit();
            Iterator<Technology> it = Technology.getTechnologies();
            while (it.hasNext()) {
                Technology tech = it.next();
                Iterator<ArcProto> aIt = tech.getArcs();
                while (aIt.hasNext()) {
                    Set<ArcProto> arcNames;
                    ArcProto ap = aIt.next();
                    if (Routing.isSeaOfGatesFavor(ap)) {
                        arcNames = this.favor.get(tech);
                        if (arcNames == null) {
                            arcNames = new HashSet<ArcProto>();
                            this.favor.put(tech, arcNames);
                        }
                        arcNames.add(ap);
                    }
                    if (!Routing.isSeaOfGatesPrevent(ap)) continue;
                    arcNames = this.preventUse.get(tech);
                    if (arcNames == null) {
                        arcNames = new HashSet<ArcProto>();
                        this.preventUse.put(tech, arcNames);
                    }
                    arcNames.add(ap);
                }
            }
        }

        public boolean isPrevented(ArcProto ap) {
            Set<ArcProto> prefPrevent = this.preventUse.get(ap.getTechnology());
            return prefPrevent != null && prefPrevent.contains(ap);
        }

        public boolean isFavored(ArcProto ap) {
            Set<ArcProto> prefFavorites = this.favor.get(ap.getTechnology());
            return prefFavorites != null && prefFavorites.contains(ap);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SeaOfGatesJob
    extends Job {
        private Cell cell;
        private int[] arcIdsToRoute;
        private SeaOfGatesOptions prefs;
        private SeaOfGatesEngineFactory.SeaOfGatesEngineType version;

        protected SeaOfGatesJob(Cell cell, List<ArcInst> arcsToRoute, SeaOfGatesOptions prefs) {
            this(cell, arcsToRoute, prefs, SeaOfGatesEngineFactory.SeaOfGatesEngineType.defaultVersion);
        }

        protected SeaOfGatesJob(Cell cell, List<ArcInst> arcsToRoute, SeaOfGatesOptions prefs, SeaOfGatesEngineFactory.SeaOfGatesEngineType version) {
            super("Sea-Of-Gates Route", Routing.getRoutingTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.arcIdsToRoute = new int[arcsToRoute.size()];
            for (int i = 0; i < arcsToRoute.size(); ++i) {
                this.arcIdsToRoute[i] = arcsToRoute.get(i).getArcId();
            }
            this.prefs = prefs;
            this.version = version;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            SeaOfGatesEngine router = SeaOfGatesEngineFactory.createSeaOfGatesEngine(this.version);
            ArrayList<ArcInst> arcsToRoute = new ArrayList<ArcInst>();
            for (int arcId : this.arcIdsToRoute) {
                arcsToRoute.add(this.cell.getArcById(arcId));
            }
            router.routeIt(this, this.cell, arcsToRoute, this.prefs);
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NetsToRouteByLength
    implements Comparator<NetsToRoute> {
        @Override
        public int compare(NetsToRoute ntr1, NetsToRoute ntr2) {
            if (ntr1.isPwrGnd != ntr2.isPwrGnd) {
                if (ntr1.isPwrGnd) {
                    return -1;
                }
                return 1;
            }
            if (ntr1.length < ntr2.length) {
                return -1;
            }
            if (ntr1.length > ntr2.length) {
                return 1;
            }
            return 0;
        }
    }

    private static class NetsToRoute {
        private Network net;
        private double length;
        private boolean isPwrGnd;

        NetsToRoute(Network net, double length, boolean isPwrGnd) {
            this.net = net;
            this.length = length;
            this.isPwrGnd = isPwrGnd;
        }
    }
}

