/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag.scan;

import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.flag.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ScanChain {
    private final List<String> inNames;
    private final List<String> outNames;
    private final List<String> feedNames;

    private static void error(boolean cond, String msg) {
        Utils.error(cond, msg);
    }

    private void addNames(List<String> names, Name name) {
        if (name == null) {
            return;
        }
        for (int i = 0; i < name.busWidth(); ++i) {
            names.add(name.subname(i).toString());
        }
    }

    private boolean hasScanInput(NodeInst ni) {
        String portNm = this.inNames.get(0);
        PortInst pi = ni.findPortInst(portNm);
        return pi != null;
    }

    private boolean hasScanOutput(NodeInst ni) {
        String portNm = this.outNames.get(0);
        PortInst pi = ni.findPortInst(portNm);
        return pi != null;
    }

    private boolean hasScanFeedthrough(NodeInst ni) {
        if (this.feedNames.isEmpty()) {
            return false;
        }
        String portNm = this.feedNames.get(0);
        PortInst pi = ni.findPortInst(portNm);
        return pi != null;
    }

    public ScanChain(String in, String out, String feedthrough) {
        ScanChain.error(in == null, "ScanChain(): argument \"in\" may not be null");
        ScanChain.error(out == null, "ScanChain(): argument \"out\" may not be null");
        ScanChain.error(feedthrough == null, "ScanChain(): Argument \"feedthrough\" may not be null");
        Name inName = Name.findName(in);
        Name outName = Name.findName(out);
        Name feedName = feedthrough.length() != 0 ? Name.findName(feedthrough) : null;
        ScanChain.error(inName.busWidth() != outName.busWidth() || feedName != null && inName.busWidth() != feedName.busWidth(), "ScanChain(): bus widths don't match");
        ArrayList<String> inNames = new ArrayList<String>();
        ArrayList<String> outNames = new ArrayList<String>();
        ArrayList<String> feedNames = new ArrayList<String>();
        this.addNames(inNames, inName);
        this.addNames(outNames, outName);
        this.addNames(feedNames, feedName);
        this.inNames = Collections.unmodifiableList(inNames);
        this.outNames = Collections.unmodifiableList(outNames);
        this.feedNames = Collections.unmodifiableList(feedNames);
    }

    public List<String> getInputOrFeedNames(NodeInst ni) {
        if (this.hasScanInput(ni)) {
            return this.inNames;
        }
        if (this.hasScanFeedthrough(ni)) {
            return this.feedNames;
        }
        return null;
    }

    public List<String> getOutputOrFeedNames(NodeInst ni) {
        if (this.hasScanOutput(ni)) {
            return this.outNames;
        }
        if (this.hasScanFeedthrough(ni)) {
            return this.feedNames;
        }
        return null;
    }

    public List<String> getInputNames() {
        return this.inNames;
    }

    public List<String> getOutputNames() {
        return this.outNames;
    }

    public List<String> getFeedthroughNames() {
        return this.feedNames;
    }
}

