!function(){"use strict";const t=new CSSStyleSheet;t.replaceSync('/*\n * Copyright 2019 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\nbody {\n  margin: 0;\n  padding: 0;\n  font-size: 13px;\n  color: #222;\n}\n\nbody.platform-linux {\n  font-family: Roboto, Ubuntu, Arial, sans-serif;\n}\n\nbody.platform-mac {\n  color: rgb(48 57 66);\n  font-family: ".SFNSDisplay-Regular", "Helvetica Neue", "Lucida Grande", sans-serif;\n}\n\nbody.platform-windows {\n  font-family: "Segoe UI", Tahoma, sans-serif;\n}\n\n.fill {\n  position: absolute;\n  top: 0;\n  right: 0;\n  bottom: 0;\n  left: 0;\n}\n\n#canvas {\n  pointer-events: none;\n}\n\n.hidden {\n  display: none !important; /* stylelint-disable-line declaration-no-important */\n}\n');class e{viewportSize={width:800,height:600};viewportSizeForMediaQueries;deviceScaleFactor=1;emulationScaleFactor=1;pageScaleFactor=1;pageZoomFactor=1;scrollX=0;scrollY=0;style;canvas;canvasWidth=0;canvasHeight=0;platform;_window;_document;_context;_installed=!1;constructor(t,e=[]){this._window=t,this._document=t.document,Array.isArray(e)||(e=[e]),this.style=e}setCanvas(t){this.canvas=t,this._context=t.getContext("2d")}install(){for(const t of this.style)a(t);this._installed=!0}uninstall(){for(const t of this.style)document.adoptedStyleSheets=document.adoptedStyleSheets.filter((e=>e!==t));this._installed=!1}reset(t){t&&(this.viewportSize=t.viewportSize,this.viewportSizeForMediaQueries=t.viewportSizeForMediaQueries,this.deviceScaleFactor=t.deviceScaleFactor,this.pageScaleFactor=t.pageScaleFactor,this.pageZoomFactor=t.pageZoomFactor,this.emulationScaleFactor=t.emulationScaleFactor,this.scrollX=Math.round(t.scrollX),this.scrollY=Math.round(t.scrollY)),this.resetCanvas()}resetCanvas(){this.canvas&&this._context&&(this.canvas.width=this.deviceScaleFactor*this.viewportSize.width,this.canvas.height=this.deviceScaleFactor*this.viewportSize.height,this.canvas.style.width=this.viewportSize.width+"px",this.canvas.style.height=this.viewportSize.height+"px",this._context.scale(this.deviceScaleFactor,this.deviceScaleFactor),this.canvasWidth=this.viewportSize.width,this.canvasHeight=this.viewportSize.height)}setPlatform(t){this.platform=t,this.document.body.classList.add("platform-"+t),this._installed||this.install()}dispatch(t){this[t.shift()].apply(this,t)}eventHasCtrlOrMeta(t){return"mac"===this.platform?t.metaKey&&!t.ctrlKey:t.ctrlKey&&!t.metaKey}get context(){if(!this._context)throw new Error("Context object is missing");return this._context}get document(){if(!this._document)throw new Error("Document object is missing");return this._document}get window(){if(!this._window)throw new Error("Window object is missing");return this._window}get installed(){return this._installed}}function n(t,e,n){const o=i(e,n);return o.addEventListener("click",(function(t){t.stopPropagation()}),!1),t.appendChild(o),o}function o(t,e){const n=document.createTextNode(e);return t.appendChild(n),n}function i(t,e){const n=document.createElement(t);return e&&(n.className=e),n}function r(t,e){return t.length<=e?String(t):t.substr(0,e-1)+"…"}function s(t,e,n){return t<e?t=e:t>n&&(t=n),t}function a(t){document.adoptedStyleSheets=[...document.adoptedStyleSheets,t]}function l(t,e){const n=t[3];return[(1-n)*e[0]+n*t[0],(1-n)*e[1]+n*t[1],(1-n)*e[2]+n*t[2],n+e[3]*(1-n)]}function c([t,e,n]){const o=Math.max(t,e,n),i=Math.min(t,e,n),r=o-i;let s;return s=i===o?0:t===o?(1/6*(e-n)/r+1)%1:e===o?1/6*(n-t)/r+1/3:1/6*(t-e)/r+2/3,s}function d([t,e,n]){return.2126*(t<=.03928?t/12.92:Math.pow((t+.055)/1.055,2.4))+.7152*(e<=.03928?e/12.92:Math.pow((e+.055)/1.055,2.4))+.0722*(n<=.03928?n/12.92:Math.pow((n+.055)/1.055,2.4))}const h=2.4,p=.56,u=.57,g=.65,m=.62,f=.022,x=1.414,b=1.14,y=1.14,v=.027,w=.1,M=5e-4;function C([t,e,n]){return.2126729*Math.pow(t,h)+.7151522*Math.pow(e,h)+.072175*Math.pow(n,h)}function S(t,e){return function(t,e){if(t=L(t),e=L(e),Math.abs(t-e)<M)return 0;let n=0;e>t?(n=(Math.pow(e,p)-Math.pow(t,u))*b,n=n<w?0:n-v):(n=(Math.pow(e,g)-Math.pow(t,m))*y,n=n>-w?0:n+v);return 100*n}(C(l(t,e)),C(e))}function L(t){return t>f?t:t+Math.pow(f-t,x)}const k=[[12,-1,-1,-1,-1,100,90,80,-1,-1],[14,-1,-1,-1,100,90,80,60,60,-1],[16,-1,-1,100,90,80,60,55,50,50],[18,-1,-1,90,80,60,55,50,40,40],[24,-1,100,80,60,55,50,40,38,35],[30,-1,90,70,55,50,40,38,35,40],[36,-1,80,60,50,40,38,35,30,25],[48,100,70,55,40,38,35,30,25,20],[60,90,60,50,38,35,30,25,20,20],[72,80,55,40,35,30,25,20,20,20],[96,70,50,35,30,25,20,20,20,20],[120,60,40,30,25,20,20,20,20,20]];k.reverse();const A={largeFont:{aa:3,aaa:4.5},normalFont:{aa:4.5,aaa:7}};function H(t,e){return function(t,e){const n=72*parseFloat(t.replace("px",""))/96;return(isNaN(Number(e))?["bold","bolder"].includes(e):Number(e)>=600)?n>=14:n>=18}(t,e)?A.largeFont:A.normalFont}function E(t,e,n,o=1){n&&n.color&&(t.save(),t.translate(.5,.5),t.lineWidth=o,"dashed"===n.pattern&&t.setLineDash([3,3]),"dotted"===n.pattern&&t.setLineDash([2,2]),t.strokeStyle=n.color,t.stroke(e),t.restore())}function F(t,e,n,o,i){i&&(t.save(),i.fillColor&&(t.fillStyle=i.fillColor,t.fill(e)),i.hatchColor&&R(t,e,n,10,i.hatchColor,o,!1),t.restore())}function z(t,e,n){let o=0;function i(i){const r=[];for(let s=0;s<i;++s){const i=Math.round(t[o++]*n);e.maxX=Math.max(e.maxX,i),e.minX=Math.min(e.minX,i);const s=Math.round(t[o++]*n);e.maxY=Math.max(e.maxY,s),e.minY=Math.min(e.minY,s),e.leftmostXForY[s]=Math.min(e.leftmostXForY[s]||Number.MAX_VALUE,i),e.rightmostXForY[s]=Math.max(e.rightmostXForY[s]||Number.MIN_VALUE,i),e.topmostYForX[i]=Math.min(e.topmostYForX[i]||Number.MAX_VALUE,s),e.bottommostYForX[i]=Math.max(e.bottommostYForX[i]||Number.MIN_VALUE,s),e.allPoints.push({x:i,y:s}),r.push(i,s)}return r}const r=t.length,s=new Path2D;for(;o<r;)switch(t[o++]){case"M":s.moveTo.apply(s,i(1));break;case"L":s.lineTo.apply(s,i(1));break;case"C":s.bezierCurveTo.apply(s,i(3));break;case"Q":s.quadraticCurveTo.apply(s,i(2));break;case"Z":s.closePath()}return s}function X(){return{minX:Number.MAX_VALUE,minY:Number.MAX_VALUE,maxX:-Number.MAX_VALUE,maxY:-Number.MAX_VALUE,leftmostXForY:{},rightmostXForY:{},topmostYForX:{},bottommostYForX:{},allPoints:[]}}function Y(t,e){let n=new DOMPoint(t.x,t.y);return n=n.matrixTransform(e),{x:n.x,y:n.y}}const P=5,T=3;let I,B="";function R(t,e,n,o,i,r,s){if((t.canvas.width<n.maxX-n.minX||t.canvas.height<n.maxY-n.minY)&&(n={minX:0,maxX:t.canvas.width,minY:0,maxY:t.canvas.height,allPoints:[]}),!I||i!==B){B=i;const e=document.createElement("canvas");e.width=o,e.height=P+T;const n=e.getContext("2d");n.clearRect(0,0,e.width,e.height),n.rect(0,0,1,P),n.fillStyle=i,n.fill(),I=t.createPattern(e,"repeat")}t.save();const a=new DOMMatrix;I.setTransform(a.scale(s?-1:1,1).rotate(0,0,-45+r)),t.fillStyle=I,t.fill(e),t.restore()}function D(t,e,n,o){let i=["M",t.p1.x,t.p1.y,"L",t.p2.x,t.p2.y,"L",t.p3.x,t.p3.y,"L",t.p4.x,t.p4.y];for(const n of e)i=[...i,"L",n.p4.x,n.p4.y,"L",n.p3.x,n.p3.y,"L",n.p2.x,n.p2.y,"L",n.p1.x,n.p1.y,"L",n.p4.x,n.p4.y,"L",t.p4.x,t.p4.y];return i.push("Z"),z(i,n,o)}function N(t){return(t.match(/#(\w\w)(\w\w)(\w\w)(\w\w)/)||[]).slice(1).map((t=>parseInt(t,16)/255))}function W(t,e){if("rgb"===e){const[e,n,o,i]=t;return`rgb(${(255*e).toFixed()} ${(255*n).toFixed()} ${(255*o).toFixed()}${1===i?"":" / "+Math.round(100*i)/100})`}if("hsl"===e){const[e,n,o,i]=function([t,e,n,o]){const i=Math.max(t,e,n),r=Math.min(t,e,n),s=i-r,a=i+r,l=.5*a;let d;return d=0===l||1===l?0:l<=.5?s/a:s/(2-a),[c([t,e,n]),d,l,o]}(t);return`hsl(${Math.round(360*e)}deg ${Math.round(100*n)} ${Math.round(100*o)}${1===i?"":" / "+Math.round(100*(i??1))/100})`}if("hwb"===e){const[e,n,o,i]=function([t,e,n,o]){const i=c([t,e,n]),r=Math.max(t,e,n);return[i,Math.min(t,e,n),1-r,o]}(t);return`hwb(${Math.round(360*e)}deg ${Math.round(100*n)} ${Math.round(100*o)}${1===i?"":" / "+Math.round(100*(i??1))/100})`}throw new Error("NOT_REACHED")}function O(t,e,n,o,i,r,s){t.save();const a=z(e,r,s);return n&&(t.fillStyle=n,t.fill(a)),o&&("dashed"===i&&t.setLineDash([3,3]),"dotted"===i&&t.setLineDash([2,2]),t.lineWidth=2,t.strokeStyle=o,t.stroke(a)),t.restore(),a}const U={leftTop:"left-top",leftMid:"left-mid",leftBottom:"left-bottom",topLeft:"top-left",topMid:"top-mid",topRight:"top-right",rightTop:"right-top",rightMid:"right-mid",rightBottom:"right-bottom",bottomLeft:"bottom-left",bottomMid:"bottom-mid",bottomRight:"bottom-right"},G=3,K=20,$=20,V=3,_="#1A73E8",j="#121212";function q(t,e,o,i,r,s,a=new DOMMatrix){const l=`grid-${r.gridLayerCounter++}-labels`;let c=document.getElementById(l);if(!c){const t=document.getElementById("grid-label-container");if(!t)throw new Error("#grid-label-container is not found");c=n(t,"div"),c.id=l}const d=t.gridHighlightConfig&&t.gridHighlightConfig.rowLineColor?t.gridHighlightConfig.rowLineColor:_,h=mt(d);c.style.setProperty("--row-label-color",d),c.style.setProperty("--row-label-text-color",h);const p=t.gridHighlightConfig&&t.gridHighlightConfig.columnLineColor?t.gridHighlightConfig.columnLineColor:_,u=mt(p);c.style.setProperty("--column-label-color",p),c.style.setProperty("--column-label-text-color",u),c.innerText="";const g=n(c,"div","area-names"),m=n(c,"div","line-names"),f=n(c,"div","line-numbers"),x=n(c,"div","track-sizes"),b=function(t,e){const n=Math.round(e.maxX-e.minX),o=Math.round(e.maxY-e.minY),i={rows:{positive:{positions:[],hasFirst:!1,hasLast:!1},negative:{positions:[],hasFirst:!1,hasLast:!1}},columns:{positive:{positions:[],hasFirst:!1,hasLast:!1},negative:{positions:[],hasFirst:!1,hasLast:!1}},bounds:{minX:Math.round(e.minX),maxX:Math.round(e.maxX),minY:Math.round(e.minY),maxY:Math.round(e.maxY),allPoints:e.allPoints,width:n,height:o}};if(t.gridHighlightConfig&&t.gridHighlightConfig.showLineNames){const e=tt(t.rowLineNameOffsets||[]),n={positions:e.positions,names:e.names,hasFirst:!!e.positions.length&&J(e.positions).y===i.bounds.minY,hasLast:!!e.positions.length&&Z(e.positions).y===i.bounds.maxY};i.rows.positive=n;const o=tt(t.columnLineNameOffsets||[]),r={positions:o.positions,names:o.names,hasFirst:!!o.positions.length&&J(o.positions).x===i.bounds.minX,hasLast:!!o.positions.length&&Z(o.positions).x===i.bounds.maxX};i.columns.positive=r}else{const e=({x:t,y:e})=>({x:Math.round(t),y:Math.round(e)});t.positiveRowLineNumberPositions&&(i.rows.positive={positions:t.positiveRowLineNumberPositions.map(e),hasFirst:Math.round(J(t.positiveRowLineNumberPositions).y)===i.bounds.minY,hasLast:Math.round(Z(t.positiveRowLineNumberPositions).y)===i.bounds.maxY}),t.negativeRowLineNumberPositions&&(i.rows.negative={positions:t.negativeRowLineNumberPositions.map(e),hasFirst:Math.round(J(t.negativeRowLineNumberPositions).y)===i.bounds.minY,hasLast:Math.round(Z(t.negativeRowLineNumberPositions).y)===i.bounds.maxY}),t.positiveColumnLineNumberPositions&&(i.columns.positive={positions:t.positiveColumnLineNumberPositions.map(e),hasFirst:Math.round(J(t.positiveColumnLineNumberPositions).x)===i.bounds.minX,hasLast:Math.round(Z(t.positiveColumnLineNumberPositions).x)===i.bounds.maxX}),t.negativeColumnLineNumberPositions&&(i.columns.negative={positions:t.negativeColumnLineNumberPositions.map(e),hasFirst:Math.round(J(t.negativeColumnLineNumberPositions).x)===i.bounds.minX,hasLast:Math.round(Z(t.negativeColumnLineNumberPositions).x)===i.bounds.maxX})}return i}(t,e);t.gridHighlightConfig&&t.gridHighlightConfig.showLineNames?function(t,e,n,o,i=new DOMMatrix,r="horizontal-tb"){for(const[s,a]of e.columns.positive.positions.entries()){ct(ot(t,nt(e.columns.positive.names[s]),"column"),Y(a,i),e,r,n,o)}for(const[s,a]of e.rows.positive.positions.entries()){at(ot(t,nt(e.rows.positive.names[s]),"row"),Y(a,i),e,r,n,o)}}(m,b,i,s,a,t.writingMode):function(t,e,n,o,i=new DOMMatrix,r="horizontal-tb"){if(!e.columns.positive.names)for(const[s,a]of Q(e.columns.positive.positions,"x")){ct(ot(t,(s+1).toString(),"column"),Y(a,i),e,r,n,o)}if(!e.rows.positive.names)for(const[s,a]of Q(e.rows.positive.positions,"y")){at(ot(t,(s+1).toString(),"row"),Y(a,i),e,r,n,o)}for(const[s,a]of Q(e.columns.negative.positions,"x")){dt(ot(t,(-1*e.columns.negative.positions.length+s).toString(),"column"),Y(a,i),e,r,n,o)}for(const[s,a]of Q(e.rows.negative.positions,"y")){lt(ot(t,(-1*e.rows.negative.positions.length+s).toString(),"row"),Y(a,i),e,r,n,o)}}(f,b,i,s,a,t.writingMode),function(t,e,n=new DOMMatrix,o="horizontal-tb"){for(const{name:i,bounds:r}of e){const e=ot(t,i,"row"),{width:s,height:a}=pt(e,o),l=Y("vertical-rl"===o?r.allPoints[3]:r.allPoints[0],n),c=r.allPoints[1].x<r.allPoints[0].x,d=r.allPoints[3].y<r.allPoints[0].y;e.style.left=l.x-(c?s:0)+"px",e.style.top=l.y-(d?a:0)+"px"}}(g,o,a,t.writingMode),t.columnTrackSizes&&et(x,t.columnTrackSizes,"column",i,s,a,t.writingMode),t.rowTrackSizes&&et(x,t.rowTrackSizes,"row",i,s,a,t.writingMode)}function*Q(t,e){let n=null;for(const[o,i]of t.entries()){const r=0===o,s=o===t.length-1,a=Math.abs(i[e]-(n?n[e]:0))>$,l=!s&&Math.abs(t[t.length-1][e]-i[e])>$;(r||s||a&&l)&&(yield[o,i],n=i)}}const Z=t=>t[t.length-1],J=t=>t[0];function tt(t){const e=[],n=[];for(const{name:o,x:i,y:r}of t){const t=Math.round(i),s=Math.round(r),a=e.findIndex((({x:e,y:n})=>e===t&&n===s));a>-1?n[a].push(o):(e.push({x:t,y:s}),n.push([o]))}return{positions:e,names:n}}function et(t,e,n,o,i,r=new DOMMatrix,s="horizontal-tb"){const{main:a,cross:l}=rt(s),{crossSize:c}=st(s,o);for(const{x:o,y:d,computedSize:h,authoredSize:p}of e){const e=Y({x:o,y:d},r),u=h.toFixed(2),g=ot(t,`${p?p+"·":""}${`${u.endsWith(".00")?u.slice(0,-3):u}px`}`,n),m=pt(g,s);let f=e[a]-m.mainSize<K;"column"===n&&(f="vertical-rl"===s?c-e[l]-m.crossSize<K:e[l]-m.crossSize<K);let x=gt("column"===n?U.bottomMid:U.rightMid,s);x=ut(x,f),ht(g,x,e.x,e.y,m,i)}}function nt(t){const e=document.createElement("ul"),o=t.slice(0,V);for(const t of o)n(e,"li","line-name").textContent=t;return e}function ot(t,e,o){const i=n(t,"div"),r=n(i,"div","grid-label-content");return r.dataset.direction=o,"string"==typeof e?r.textContent=e:r.appendChild(e),r}function it(t,e,n){const[o,i,r,s]=t.allPoints;return"row"===e?"positive"===n?{start:o,end:s}:{start:i,end:r}:"positive"===n?{start:o,end:i}:{start:s,end:r}}function rt(t){return t.startsWith("vertical")?{main:"y",cross:"x"}:{main:"x",cross:"y"}}function st(t,e){return t.startsWith("vertical")?{mainSize:e.canvasHeight,crossSize:e.canvasWidth}:{mainSize:e.canvasWidth,crossSize:e.canvasHeight}}function at(t,e,n,o,i,r){const{start:s,end:a}=it(n.bounds,"row","positive"),{main:l,cross:c}=rt(o),{crossSize:d}=st(o,i),h=pt(t,o),p=e[c]===s[c]&&n.columns&&n.columns.positive.hasFirst,u=e[c]===a[c]&&n.columns&&n.columns.negative.hasFirst,g=e[c]<K,m=d-e[c]<K,f=e[l]-h.mainSize<K;f&&(p||u)&&t.classList.add("inner-shared-corner");let x=gt(U.rightMid,o);g||p?x=gt(U.rightTop,o):(m||u)&&(x=gt(U.rightBottom,o)),x=ut(x,f),ht(t,x,e.x,e.y,h,r)}function lt(t,e,n,o,i,r){const{start:s,end:a}=it(n.bounds,"row","negative"),{main:l,cross:c}=rt(o),{mainSize:d,crossSize:h}=st(o,i),p=pt(t,o),u=e[c]===s[c]&&n.columns&&n.columns.positive.hasLast,g=e[c]===a[c]&&n.columns&&n.columns.negative.hasLast,m=e[c]<K,f=h-e[c]<K,x=d-e[l]-p.mainSize<K;x&&(u||g)&&t.classList.add("inner-shared-corner");let b=gt(U.leftMid,o);m||u?b=gt(U.leftTop,o):(f||g)&&(b=gt(U.leftBottom,o)),b=ut(b,x),ht(t,b,e.x,e.y,p,r)}function ct(t,e,n,o,i,r){const{start:s,end:a}=it(n.bounds,"column","positive"),{main:l,cross:c}=rt(o),{mainSize:d,crossSize:h}=st(o,i),p=pt(t,o),u=e[l]===s[l]&&n.rows&&n.rows.positive.hasFirst,g=e[l]===a[l]&&n.rows&&n.rows.negative.hasFirst,m=e[l]<K,f=d-e[l]<K,x="vertical-rl"===o?h-e[c]-p.crossSize<K:e[c]-p.crossSize<K;x&&(u||g)&&t.classList.add("inner-shared-corner");let b=gt(U.bottomMid,o);m?b=gt(U.bottomLeft,o):f&&(b=gt(U.bottomRight,o)),b=ut(b,x),ht(t,b,e.x,e.y,p,r)}function dt(t,e,n,o,i,r){const{start:s,end:a}=it(n.bounds,"column","negative"),{main:l,cross:c}=rt(o),{mainSize:d,crossSize:h}=st(o,i),p=pt(t,o),u=e[l]===s[l]&&n.rows&&n.rows.positive.hasLast,g=e[l]===a[l]&&n.rows&&n.rows.negative.hasLast,m=e[l]<K,f=d-e[l]<K,x="vertical-rl"===o?e[c]-p.crossSize<K:h-e[c]-p.crossSize<K;x&&(u||g)&&t.classList.add("inner-shared-corner");let b=gt(U.topMid,o);m?b=gt(U.topLeft,o):f&&(b=gt(U.topRight,o)),b=ut(b,x),ht(t,b,e.x,e.y,p,r)}function ht(t,e,n,o,i,r){const{contentLeft:s,contentTop:a}=function(t,e,n,o,i,r){let s=0,a=0;switch(e*=r,n*=r,t){case U.leftTop:s=n,a=e+G;break;case U.leftMid:s=n-i/2,a=e+G;break;case U.leftBottom:s=n-i,a=e+G;break;case U.rightTop:s=n,a=e-G-o;break;case U.rightMid:s=n-i/2,a=e-G-o;break;case U.rightBottom:s=n-i,a=e-o-G;break;case U.topLeft:s=n+G,a=e;break;case U.topMid:s=n+G,a=e-o/2;break;case U.topRight:s=n+G,a=e-o;break;case U.bottomLeft:s=n-G-i,a=e;break;case U.bottomMid:s=n-G-i,a=e-o/2;break;case U.bottomRight:s=n-G-i,a=e-o}return{contentTop:s,contentLeft:a}}(e,n,o,i.width,i.height,r);t.classList.add(e),t.style.left=s+"px",t.style.top=a+"px"}function pt(t,e){const n=function(t){let e=t.getBoundingClientRect().width;e%2==1&&(e+=1,t.style.width=e+"px");return e}(t),o=t.getBoundingClientRect().height;return{width:n,height:o,mainSize:e.startsWith("vertical")?o:n,crossSize:e.startsWith("vertical")?n:o}}function ut(t,e){if(!e)return t;switch(t){case U.leftTop:return U.rightTop;case U.leftMid:return U.rightMid;case U.leftBottom:return U.rightBottom;case U.rightTop:return U.leftTop;case U.rightMid:return U.leftMid;case U.rightBottom:return U.leftBottom;case U.topLeft:return U.bottomLeft;case U.topMid:return U.bottomMid;case U.topRight:return U.bottomRight;case U.bottomLeft:return U.topLeft;case U.bottomMid:return U.topMid;case U.bottomRight:return U.topRight}return t}function gt(t,e){if("vertical-lr"===e)switch(t){case U.leftTop:return U.topLeft;case U.leftMid:return U.topMid;case U.leftBottom:return U.topRight;case U.topLeft:return U.leftTop;case U.topMid:return U.leftMid;case U.topRight:return U.leftBottom;case U.rightTop:return U.bottomRight;case U.rightMid:return U.bottomMid;case U.rightBottom:return U.bottomLeft;case U.bottomLeft:return U.rightTop;case U.bottomMid:return U.rightMid;case U.bottomRight:return U.rightBottom}if("vertical-rl"===e)switch(t){case U.leftTop:return U.topRight;case U.leftMid:return U.topMid;case U.leftBottom:return U.topLeft;case U.topLeft:return U.rightTop;case U.topMid:return U.rightMid;case U.topRight:return U.rightBottom;case U.rightTop:return U.bottomRight;case U.rightMid:return U.bottomMid;case U.rightBottom:return U.bottomLeft;case U.bottomLeft:return U.leftTop;case U.bottomMid:return U.leftMid;case U.bottomRight:return U.leftBottom}return t}function mt(t){let e=[];const n=N(t+"00");if(4===n.length)e=n.slice(0,3).map((t=>t));else{const n=t.match(/[0-9.]+/g);if(!n)return null;e=n.slice(0,3).map((t=>parseInt(t,10)/255))}return e.length?d(e)>.2?j:"white":null}function ft(t,e,n,o,i,r,s){const a=X(),l=z(t.gridBorder,a,r);e.save(),function(t,e,n){if("vertical-rl"!==t&&"vertical-lr"!==t)return;const o=e.allPoints[0],i=e.allPoints[3];n.translate(o.x,o.y),"vertical-rl"===t&&(n.rotate(90*Math.PI/180),n.translate(0,-1*(i.y-o.y)));"vertical-lr"===t&&(n.rotate(90*Math.PI/180),n.scale(1,-1));n.translate(-1*o.x,-1*o.y)}(t.writingMode,a,e),t.gridHighlightConfig.gridBackgroundColor&&(e.fillStyle=t.gridHighlightConfig.gridBackgroundColor,e.fill(l)),t.gridHighlightConfig.gridBorderColor&&(e.save(),e.translate(.5,.5),e.lineWidth=0,t.gridHighlightConfig.gridBorderDash&&e.setLineDash([3,3]),e.strokeStyle=t.gridHighlightConfig.gridBorderColor,e.stroke(l),e.restore());const c=xt(e,t,"row",r),d=xt(e,t,"column",r);yt(e,t.rowGaps,t.gridHighlightConfig.rowGapColor,t.gridHighlightConfig.rowHatchColor,t.rotationAngle,r,!0),yt(e,t.columnGaps,t.gridHighlightConfig.columnGapColor,t.gridHighlightConfig.columnHatchColor,t.rotationAngle,r,!1);const h=function(t,e,n,o){if(!e||!Object.keys(e).length)return[];t.save(),n&&(t.strokeStyle=n);t.lineWidth=2;const i=[];for(const n in e){const r=e[n],s=X(),a=z(r,s,o);t.stroke(a),i.push({name:n,bounds:s})}return t.restore(),i}(e,t.areaNames,t.gridHighlightConfig.areaBorderColor,r),p=e.getTransform();p.scaleSelf(1/n),e.restore(),t.gridHighlightConfig.showGridExtensionLines&&(c&&bt(e,c,t.gridHighlightConfig.rowLineColor,t.gridHighlightConfig.rowLineDash,p,o,i),d&&bt(e,d,t.gridHighlightConfig.columnLineColor,t.gridHighlightConfig.columnLineDash,p,o,i)),q(t,a,h,{canvasWidth:o,canvasHeight:i},s,r,p)}function xt(t,e,n,o){const i=e[`${n}s`],r=e.gridHighlightConfig[`${n}LineColor`],s=e.gridHighlightConfig[`${n}LineDash`];if(!r)return null;const a=X(),l=z(i,a,o);return t.save(),t.translate(.5,.5),s&&t.setLineDash([3,3]),t.lineWidth=0,t.strokeStyle=r,t.save(),t.stroke(l),t.restore(),t.restore(),a}function bt(t,e,n,o,i,r,s){t.save(),t.strokeStyle=n,t.lineWidth=1,t.translate(.5,.5),o&&t.setLineDash([3,3]);for(let n=0;n<e.allPoints.length;n+=2){let o,a,l=Y(e.allPoints[n],i),c=Y(e.allPoints[n+1],i);if(l.x===c.x)o={x:l.x,y:0},a={x:l.x,y:s},c.y<l.y&&([l,c]=[c,l]);else if(l.y===c.y)o={x:0,y:l.y},a={x:r,y:l.y},c.x<l.x&&([l,c]=[c,l]);else{const t=(c.y-l.y)/(c.x-l.x),e=(l.y*c.x-c.y*l.x)/(c.x-l.x);o={x:0,y:e},a={x:r,y:r*t+e},c.x<l.x&&([l,c]=[c,l])}t.beginPath(),t.moveTo(o.x,o.y),t.lineTo(l.x,l.y),t.moveTo(c.x,c.y),t.lineTo(a.x,a.y),t.stroke()}t.restore()}function yt(t,e,n,o,i,r,s){if(!n&&!o)return;t.save(),t.translate(.5,.5),t.lineWidth=0;const a=X(),l=z(e,a,r);n&&(t.fillStyle=n,t.fill(l)),o&&R(t,l,a,10,o,i,s),t.restore()}const vt=new CSSStyleSheet;vt.replaceSync("/*\n * Copyright 2021 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n@media (forced-colors: active) {\n  :root,\n  body {\n    background-color: transparent;\n    forced-color-adjust: none;\n  }\n}\n");const wt=new CSSStyleSheet;wt.replaceSync('/*\n * Copyright 2021 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\nbody {\n  --arrow-width: 15px;\n  --arrow-height: 8px;\n  --shadow-up: 5px;\n  --shadow-down: -5px;\n  --shadow-direction: var(--shadow-up);\n  --arrow-down: polygon(0 0, 100% 0, 50% 100%);\n  --arrow-up: polygon(50% 0, 0 100%, 100% 100%);\n}\n\n.px {\n  color: rgb(128 128 128);\n}\n\n#element-title {\n  position: absolute;\n  z-index: 10;\n}\n/* Material */\n\n.tooltip-content {\n  position: absolute;\n  user-select: none;\n  background-color: #fff;\n  padding: 5px 8px;\n  border: 1px solid #fff;\n  border-radius: 3px;\n  box-sizing: border-box;\n  min-width: 100px;\n  max-width: min(300px, 100% - 4px);\n  z-index: 2;\n  background-clip: padding-box;\n  will-change: transform;\n  text-rendering: optimizeLegibility;\n  pointer-events: none;\n  filter: drop-shadow(0 2px 4px rgb(0 0 0 / 35%));\n}\n\n.tooltip-content::after {\n  content: "";\n  background: #fff;\n  width: var(--arrow-width);\n  height: var(--arrow-height);\n  clip-path: var(--arrow);\n  position: absolute;\n  top: var(--arrow-top);\n  left: var(--arrow-left);\n  visibility: var(--arrow-visibility);\n}\n\n.element-info-section {\n  margin-top: 12px;\n  margin-bottom: 6px;\n}\n\n.section-name {\n  color: #333;\n  font-weight: 500;\n  font-size: 10px;\n  text-transform: uppercase;\n  letter-spacing: 0.05em;\n  line-height: 12px;\n}\n\n.element-info {\n  display: flex;\n  flex-direction: column;\n}\n\n.element-info-header {\n  display: flex;\n  align-items: center;\n}\n\n.element-info-body {\n  display: flex;\n  flex-direction: column;\n  padding-top: 2px;\n  margin-top: 2px;\n}\n\n.element-info-row {\n  display: flex;\n  line-height: 19px;\n}\n\n.separator-container {\n  display: flex;\n  align-items: center;\n  flex: auto;\n  margin-left: 7px;\n}\n\n.separator {\n  border-top: 1px solid #ddd;\n  width: 100%;\n}\n\n.element-info-name {\n  flex-shrink: 0;\n  color: #666;\n}\n\n.element-info-gap {\n  flex: auto;\n}\n\n.element-info-value-color {\n  display: flex;\n  color: rgb(48 57 66);\n  margin-left: 10px;\n  align-items: baseline;\n}\n\n.a11y-icon {\n  width: 16px;\n  height: 16px;\n  background-repeat: no-repeat;\n  display: inline-block;\n}\n\n.element-info-value-contrast {\n  display: flex;\n  align-items: center;\n  text-align: right;\n  color: rgb(48 57 66);\n  margin-left: 10px;\n}\n\n.element-info-value-contrast .a11y-icon {\n  margin-left: 8px;\n}\n\n.element-info-value-icon {\n  display: flex;\n  align-items: center;\n}\n\n.element-info-value-text {\n  text-align: right;\n  color: rgb(48 57 66);\n  margin-left: 10px;\n  align-items: baseline;\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n}\n\n.color-swatch {\n  display: flex;\n  margin-right: 2px;\n  width: 10px;\n  height: 10px;\n  background-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAwAAAAMCAIAAADZF8uwAAAAGUlEQVQYV2M4gwH+YwCGIasIUwhT25BVBADtzYNYrHvv4gAAAABJRU5ErkJggg==");\n  line-height: 10px;\n}\n\n.color-swatch-inner {\n  flex: auto;\n  border: 1px solid rgb(128 128 128 / 60%);\n}\n\n.element-layout-type {\n  margin-right: 10px;\n  width: 16px;\n  height: 16px;\n}\n\n.element-layout-type.grid {\n  background-image: url(\'data:image/svg+xml,<svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg"><rect x="2.5" y="2.5" width="4" height="4" stroke="%231A73E8"/><rect x="9.5" y="2.5" width="4" height="4" stroke="%231A73E8"/><rect x="9.5" y="9.5" width="4" height="4" stroke="%231A73E8"/><rect x="2.5" y="9.5" width="4" height="4" stroke="%231A73E8"/></svg>\');\n}\n\n.element-layout-type.flex {\n  background-image: url(\'data:image/svg+xml,<svg fill="none" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"><path fill-rule="evenodd" clip-rule="evenodd" d="M1 3.5h8v3H1v-3zm-1 0a1 1 0 011-1h8a1 1 0 011 1v3a1 1 0 01-1 1H1a1 1 0 01-1-1v-3zm12 0h3v3h-3v-3zm-1 0a1 1 0 011-1h3a1 1 0 011 1v3a1 1 0 01-1 1h-3a1 1 0 01-1-1v-3zm-7 6H1v3h3v-3zm-3-1a1 1 0 00-1 1v3a1 1 0 001 1h3a1 1 0 001-1v-3a1 1 0 00-1-1H1zm6 4v-3h8v3H7zm-1-3a1 1 0 011-1h8a1 1 0 011 1v3a1 1 0 01-1 1H7a1 1 0 01-1-1v-3z" fill="%231A73E8"/></svg>\');\n}\n\n.element-description {\n  flex: 1 1;\n  font-weight: bold;\n  word-wrap: break-word;\n  word-break: break-all;\n}\n\n.dimensions {\n  color: hsl(0deg 0% 45%);\n  text-align: right;\n  margin-left: 10px;\n}\n\n.material-node-width {\n  margin-right: 2px;\n}\n\n.material-node-height {\n  margin-left: 2px;\n}\n\n.material-tag-name {\n  /* Keep this in sync with inspectorSyntaxHighlight.css (--override-dom-tag-name-color) */\n  color: rgb(136 18 128);\n}\n\n.material-class-name,\n.material-node-id {\n  /* Keep this in sync with inspectorSyntaxHighlight.css (.webkit-html-attribute-value) */\n  color: rgb(26 26 166);\n}\n\n.contrast-text {\n  width: 16px;\n  height: 16px;\n  text-align: center;\n  line-height: 16px;\n  margin-right: 8px;\n  border: 1px solid rgb(0 0 0 / 10%);\n  padding: 0 1px;\n}\n\n.a11y-icon-not-ok {\n  background-image: url(\'data:image/svg+xml,<svg fill="none" viewBox="0 0 18 18" xmlns="http://www.w3.org/2000/svg"><path d="m9 1.5c-4.14 0-7.5 3.36-7.5 7.5s3.36 7.5 7.5 7.5 7.5-3.36 7.5-7.5-3.36-7.5-7.5-7.5zm0 13.5c-3.315 0-6-2.685-6-6 0-1.3875.4725-2.6625 1.2675-3.675l8.4075 8.4075c-1.0125.795-2.2875 1.2675-3.675 1.2675zm4.7325-2.325-8.4075-8.4075c1.0125-.795 2.2875-1.2675 3.675-1.2675 3.315 0 6 2.685 6 6 0 1.3875-.4725 2.6625-1.2675 3.675z" fill="%239e9e9e"/></svg>\');\n}\n\n.a11y-icon-warning {\n  background-image: url(\'data:image/svg+xml,<svg fill="none" viewBox="0 0 18 18" xmlns="http://www.w3.org/2000/svg"><path d="m8.25 11.25h1.5v1.5h-1.5zm0-6h1.5v4.5h-1.5zm.7425-3.75c-4.14 0-7.4925 3.36-7.4925 7.5s3.3525 7.5 7.4925 7.5c4.1475 0 7.5075-3.36 7.5075-7.5s-3.36-7.5-7.5075-7.5zm.0075 13.5c-3.315 0-6-2.685-6-6s2.685-6 6-6 6 2.685 6 6-2.685 6-6 6z" fill="%23e37400"/></svg>\');\n}\n\n.a11y-icon-ok {\n  background-image: url(\'data:image/svg+xml,<svg fill="none" viewBox="0 0 18 18" xmlns="http://www.w3.org/2000/svg"><path d="m9 1.5c-4.14 0-7.5 3.36-7.5 7.5s3.36 7.5 7.5 7.5 7.5-3.36 7.5-7.5-3.36-7.5-7.5-7.5zm0 13.5c-3.3075 0-6-2.6925-6-6s2.6925-6 6-6 6 2.6925 6 6-2.6925 6-6 6zm-1.5-4.35-1.95-1.95-1.05 1.05 3 3 6-6-1.05-1.05z" fill="%230ca40c"/></svg>\');\n}\n\n@media (forced-colors: active) {\n  :root,\n  body {\n    background-color: transparent;\n    forced-color-adjust: none;\n  }\n\n  .tooltip-content {\n    border-color: Highlight;\n    background-color: canvas;\n    color: text;\n    forced-color-adjust: none;\n  }\n\n  .tooltip-content::after {\n    background-color: Highlight;\n  }\n\n  .color-swatch-inner,\n  .contrast-text,\n  .separator {\n    border-color: Highlight;\n  }\n\n  .section-name {\n    color: Highlight;\n  }\n\n  .dimensions,\n  .element-info-name,\n  .element-info-value-color,\n  .element-info-value-contrast,\n  .element-info-value-icon,\n  .element-info-value-text,\n  .material-tag-name,\n  .material-class-name,\n  .material-node-id {\n    color: canvastext;\n  }\n}\n');const Mt=2,Ct=5,St=5,Lt=6,kt=11,At=2,Ht=1,Et=5;function Ft(t,e,n,o,i,r,s){const{baseSize:a,isHorizontalFlow:l}=t,c=Rt(e),d=l?{p1:c.p1,p2:Gt(c.p1,c.p2,a),p3:Gt(c.p4,c.p3,a),p4:c.p4}:{p1:c.p1,p2:c.p2,p3:Gt(c.p2,c.p3,a),p4:Gt(c.p1,c.p4,a)};!function(t,e,n,o,i){const r=t.flexItemHighlightConfig,s=X(),a=z((c=n,["M",c.p1.x,c.p1.y,"L",c.p2.x,c.p2.y,"L",c.p3.x,c.p3.y,"L",c.p4.x,c.p4.y,"Z"]),s,i),l=Math.atan2(e.p4.y-e.p1.y,e.p4.x-e.p1.x)+45*Math.PI/180;var c;F(o,a,s,l,r.baseSizeBox),E(o,a,r.baseSizeBorder)}(t,c,d,n,s),function(t,e,n,o,i){const{isHorizontalFlow:r}=t,s=t.flexItemHighlightConfig;if(!s.flexibilityArrow)return;const a=r?{x:(n.p2.x+n.p3.x)/2,y:(n.p2.y+n.p3.y)/2}:{x:(n.p4.x+n.p3.x)/2,y:(n.p4.y+n.p3.y)/2},l=r?{x:(e.p2.x+e.p3.x)/2,y:(e.p2.y+e.p3.y)/2}:{x:(e.p4.x+e.p3.x)/2,y:(e.p4.y+e.p3.y)/2};if(l.x===a.x&&l.y===a.y)return;const c=Bt([a,l]);if(E(o,z(c,X(),i),s.flexibilityArrow,Ht),!s.flexibilityArrow.color)return;const d=z(["M",l.x-Et,l.y-Et,"L",l.x,l.y,"L",l.x-Et,l.y+Et],X(),i),h=Math.atan2(l.y-a.y,l.x-a.x);o.save(),o.translate(l.x+.5,l.y+.5),o.rotate(h),o.translate(-l.x-.5,-l.y-.5),E(o,d,s.flexibilityArrow,Ht),o.restore()}(t,c,d,n,s)}function zt(t,e,n,o,i,r){const s=t.flexContainerHighlightConfig,a=X(),l=z(t.containerBorder,a,r),{isHorizontalFlow:c,isReverse:d,lines:h}=t;if(E(e,l,s.containerBorder),!h||!h.length)return;const p=function(t,e,n,o){const i=Rt(t),r=[];for(const t of e){if(!t.length)continue;let s=Rt(t[0].itemBorder);const a=[];for(const{itemBorder:e}of t){const t=Rt(e);s=s?Dt(s,t,n,o):t,a.push(t)}const l=1===e.length?i:Nt(s,i,n),c=a.map((t=>Nt(t,l,!n)));r.push({quad:l,items:a,extendedItems:c})}return r}(t.containerBorder,h,c,d);!function(t,e,n,o,i){const r=t.flexContainerHighlightConfig,s=o.map(((t,e)=>{const n=o[e+1]&&o[e+1].quad;return{path:i?Tt(t.quad,n):It(t.quad,n),items:t.extendedItems.map(((e,n)=>{const o=t.extendedItems[n+1]&&t.extendedItems[n+1];return i?It(e,o):Tt(e,o)}))}})),a=s.length>1;for(const{path:t,items:o}of s){for(const t of o)E(e,z(t,X(),n),r.itemSeparator);a&&E(e,z(t,X(),n),r.lineSeparator)}}(t,e,r,p,c),function(t,e,n,o,i){const{isHorizontalFlow:r}=t,{mainDistributedSpace:s,crossDistributedSpace:a,rowGapSpace:l,columnGapSpace:c}=t.flexContainerHighlightConfig,d=r?c:l,h=r?l:c,p=s&&Boolean(s.fillColor||s.hatchColor),u=i.length>1&&a&&Boolean(a.fillColor||a.hatchColor),g=d&&Boolean(d.fillColor||d.hatchColor),m=i.length>1&&h&&Boolean(h.fillColor||h.hatchColor),f=s&&a&&d&&h&&s.fillColor===a.fillColor&&s.hatchColor===a.hatchColor&&s.fillColor===d.fillColor&&s.hatchColor===d.hatchColor&&s.fillColor===h.fillColor&&s.hatchColor===h.hatchColor,x=Rt(o);if(f){return void Yt(x,i.map((t=>t.extendedItems)).flat().map((t=>t)),s,e,n)}const b=function(t,e){const{crossGap:n,mainGap:o,isHorizontalFlow:i,isReverse:r}=t,s=[],a=[];if(n&&e.length>1)for(let t=0,o=t+1;t<e.length-1;t++,o=t+1){const r=e[t].quad,s=e[o].quad;a.push(Pt(r,s,n,i))}for(const{extendedItems:t}of e){const e=[];if(o)for(let n=0,s=n+1;n<t.length-1;n++,s=n+1){const a=t[n],l=t[s];e.push(Pt(a,l,o,!i,r))}s.push(e)}return{mainGaps:s,crossGaps:a}}(t,i);if(u){Yt(x,[...i.map((t=>t.quad)),...m?b.crossGaps:[]],a,e,n)}if(p)for(const[t,o]of i.entries()){const i=[...o.extendedItems,...g?b.mainGaps[t]:[]];Yt(o.quad,i,s,e,n)}if(m)for(const t of b.crossGaps)Yt(t,[],h,e,n);if(g)for(const t of b.mainGaps)for(const o of t)Yt(o,[],d,e,n)}(t,e,r,t.containerBorder,p),function(t,e,n,o,i){o.forEach((({quad:o,items:r},s)=>{!function(t,e,n,o,i,r){const{alignItemsStyle:s,isHorizontalFlow:a}=t,{crossAlignment:l}=t.flexContainerHighlightConfig;if(!l||!l.color)return;const c=[];switch(s){case"flex-start":c.push([a?o.p1:o.p4,a?o.p2:o.p1]);break;case"flex-end":c.push([a?o.p3:o.p2,a?o.p4:o.p3]);break;case"center":a?(c.push([{x:(o.p1.x+o.p4.x)/2,y:(o.p1.y+o.p4.y)/2},{x:(o.p2.x+o.p3.x)/2,y:(o.p2.y+o.p3.y)/2}]),c.push([{x:(o.p2.x+o.p3.x)/2,y:(o.p2.y+o.p3.y)/2},{x:(o.p1.x+o.p4.x)/2,y:(o.p1.y+o.p4.y)/2}])):(c.push([{x:(o.p1.x+o.p2.x)/2,y:(o.p1.y+o.p2.y)/2},{x:(o.p3.x+o.p4.x)/2,y:(o.p3.y+o.p4.y)/2}]),c.push([{x:(o.p3.x+o.p4.x)/2,y:(o.p3.y+o.p4.y)/2},{x:(o.p1.x+o.p2.x)/2,y:(o.p1.y+o.p2.y)/2}]));break;case"stretch":case"normal":c.push([a?o.p1:o.p4,a?o.p2:o.p1]),c.push([a?o.p3:o.p2,a?o.p4:o.p3]);break;case"baseline":if(a){const t=i[0],e=Wt([t.p1,t.p2],[o.p2,o.p3]),n=Wt([t.p1,t.p2],[o.p1,o.p4]),s=r[0],a=Math.atan2(t.p4.y-t.p1.y,t.p4.x-t.p1.x);c.push([{x:e.x+s*Math.cos(a),y:e.y+s*Math.sin(a)},{x:n.x+s*Math.cos(a),y:n.y+s*Math.sin(a)}])}}for(const o of c){E(e,z(Bt(o),X(),n),l,Mt),Xt(t,e,n,o[0],o[1])}}(t,e,n,o,r,i[s])}))}(t,e,r,p,h.map((t=>t.map((t=>t.baseline)))))}function Xt(t,e,n,o,i){const{crossAlignment:r}=t.flexContainerHighlightConfig;if(!r||!r.color)return;const s=Math.atan2(i.y-o.y,i.x-o.x),a={x:-At*Math.cos(s-.5*Math.PI)+(o.x+i.x)/2,y:-At*Math.sin(s-.5*Math.PI)+(o.y+i.y)/2},l=z(["M",a.x,a.y,"L",a.x+kt/2,a.y+Lt,"L",a.x+St/2,a.y+Lt,"L",a.x+St/2,a.y+Lt+Ct,"L",a.x-St/2,a.y+Lt+Ct,"L",a.x-St/2,a.y+Lt,"L",a.x-kt/2,a.y+Lt,"Z"],X(),n);e.save(),e.translate(a.x,a.y),e.rotate(s),e.translate(-a.x,-a.y),e.fillStyle=r.color,e.fill(l),e.lineWidth=1,e.strokeStyle="white",e.stroke(l),e.restore()}function Yt(t,e,n,o,i){if(n){if(n.fillColor){const r=D(t,e,X(),i);o.fillStyle=n.fillColor,o.fill(r)}if(n.hatchColor){const r=180*Math.atan2(t.p2.y-t.p1.y,t.p2.x-t.p1.x)/Math.PI,s=X();R(o,D(t,e,s,i),s,10,n.hatchColor,r,!1)}}}function Pt(t,e,n,o,i){i&&([t,e]=[e,t]);const r=o?Math.atan2(t.p4.y-t.p1.y,t.p4.x-t.p1.x):Math.atan2(t.p2.y-t.p1.y,t.p2.x-t.p1.x),s=Ut(o?t.p4:t.p2,e.p1),a=s/2-n/2,l=s/2+n/2;return o?{p1:{x:Math.round(t.p4.x+a*Math.cos(r)),y:Math.round(t.p4.y+a*Math.sin(r))},p2:{x:Math.round(t.p3.x+a*Math.cos(r)),y:Math.round(t.p3.y+a*Math.sin(r))},p3:{x:Math.round(t.p3.x+l*Math.cos(r)),y:Math.round(t.p3.y+l*Math.sin(r))},p4:{x:Math.round(t.p4.x+l*Math.cos(r)),y:Math.round(t.p4.y+l*Math.sin(r))}}:{p1:{x:Math.round(t.p2.x+a*Math.cos(r)),y:Math.round(t.p2.y+a*Math.sin(r))},p2:{x:Math.round(t.p2.x+l*Math.cos(r)),y:Math.round(t.p2.y+l*Math.sin(r))},p3:{x:Math.round(t.p3.x+l*Math.cos(r)),y:Math.round(t.p3.y+l*Math.sin(r))},p4:{x:Math.round(t.p3.x+a*Math.cos(r)),y:Math.round(t.p3.y+a*Math.sin(r))}}}function Tt(t,e){const n=e&&t.p4.y===e.p1.y,o=["M",t.p1.x,t.p1.y,"L",t.p2.x,t.p2.y];return n?o:[...o,"M",t.p3.x,t.p3.y,"L",t.p4.x,t.p4.y]}function It(t,e){const n=e&&t.p2.x===e.p1.x,o=["M",t.p1.x,t.p1.y,"L",t.p4.x,t.p4.y];return n?o:[...o,"M",t.p3.x,t.p3.y,"L",t.p2.x,t.p2.y]}function Bt(t){return["M",t[0].x,t[0].y,"L",t[1].x,t[1].y]}function Rt(t){return{p1:{x:t[1],y:t[2]},p2:{x:t[4],y:t[5]},p3:{x:t[7],y:t[8]},p4:{x:t[10],y:t[11]}}}function Dt(t,e,n,o){o&&([t,e]=[e,t]);const i=n?[t.p1,t.p4]:[t.p1,t.p2],r=n?[e.p2,e.p3]:[e.p4,e.p3],s=n?[t.p1,t.p2]:[t.p1,t.p4],a=n?[t.p4,t.p3]:[t.p2,t.p3],l=n?[e.p1,e.p2]:[e.p1,e.p4],c=n?[e.p4,e.p3]:[e.p2,e.p3];let d,h,p,u;return n?(d=Wt(i,l),Ot(i,d)&&(d=t.p1),h=Wt(r,s),Ot(r,h)&&(h=e.p2),p=Wt(r,a),Ot(r,p)&&(p=e.p3),u=Wt(i,c),Ot(i,u)&&(u=t.p4)):(d=Wt(i,l),Ot(i,d)&&(d=t.p1),h=Wt(i,c),Ot(i,h)&&(h=t.p2),p=Wt(r,a),Ot(r,p)&&(p=e.p3),u=Wt(r,s),Ot(r,u)&&(u=e.p4)),{p1:d,p2:h,p3:p,p4:u}}function Nt(t,e,n){return{p1:n?Wt([e.p1,e.p4],[t.p1,t.p2]):Wt([e.p1,e.p2],[t.p1,t.p4]),p2:n?Wt([e.p2,e.p3],[t.p1,t.p2]):Wt([e.p1,e.p2],[t.p2,t.p3]),p3:n?Wt([e.p2,e.p3],[t.p3,t.p4]):Wt([e.p3,e.p4],[t.p2,t.p3]),p4:n?Wt([e.p1,e.p4],[t.p3,t.p4]):Wt([e.p3,e.p4],[t.p1,t.p4])}}function Wt([t,e],[n,o]){const i=((t.x*e.y-t.y*e.x)*(n.x-o.x)-(t.x-e.x)*(n.x*o.y-n.y*o.x))/((t.x-e.x)*(n.y-o.y)-(t.y-e.y)*(n.x-o.x)),r=((t.x*e.y-t.y*e.x)*(n.y-o.y)-(t.y-e.y)*(n.x*o.y-n.y*o.x))/((t.x-e.x)*(n.y-o.y)-(t.y-e.y)*(n.x-o.x));return{x:Object.is(i,-0)?0:i,y:Object.is(r,-0)?0:r}}function Ot([t,e],n){return!(t.x<e.x&&(n.x<t.x||n.x>e.x))&&(!(t.x>e.x&&(n.x>t.x||n.x<e.x))&&(!(t.y<e.y&&(n.y<t.y||n.y>e.y))&&(!(t.y>e.y&&(n.y>t.y||n.y<e.y))&&(n.y-t.y)*(e.x-t.x)==(e.y-t.y)*(n.x-t.x))))}function Ut(t,e){return Math.sqrt(Math.pow(e.x-t.x,2)+Math.pow(e.y-t.y,2))}function Gt(t,e,n){const o=(e.y-t.y)/(e.x-t.x),i=Math.atan(o);return{x:t.x+n*Math.cos(i),y:t.y+n*Math.sin(i)}}function Kt(t,e,n){const o=t.containerQueryContainerHighlightConfig,i=X();if(E(e,z(t.containerBorder,i,n),o.containerBorder,2),t.queryingDescendants)for(const i of t.queryingDescendants){const t=X();E(e,z(i.descendantBorder,t,n),o.descendantBorder)}}var $t=(t=>(t.WIDTH="width",t.HEIGHT="height",t.BIDIRECTION="bidirection",t))($t||{});const Vt=new Map([["width","ew-resize"],["height","ns-resize"],["bidirection","nwse-resize"]]);class _t{document;delegate;originX;originY;boundMousemove;boundMousedown;constructor(t,e){this.document=t,this.delegate=e,this.boundMousemove=this.onMousemove.bind(this),this.boundMousedown=this.onMousedown.bind(this)}install(){this.document.body.addEventListener("mousemove",this.boundMousemove),this.document.body.addEventListener("mousedown",this.boundMousedown)}uninstall(){this.document.body.removeEventListener("mousemove",this.boundMousemove),this.document.body.removeEventListener("mousedown",this.boundMousedown)}onMousemove(t){const e=this.delegate.getDraggable(t.clientX,t.clientY);this.document.body.style.cursor=e&&Vt.get(e.type)||"default"}onMousedown(t){const e=this.delegate.getDraggable(t.clientX,t.clientY);if(!e)return;const n=this.onDrag.bind(this,e);t.stopPropagation(),t.preventDefault(),void 0===e.initialWidth||"width"!==e.type&&"bidirection"!==e.type||(this.originX={coord:Math.round(t.clientX),value:e.initialWidth}),void 0===e.initialHeight||"height"!==e.type&&"bidirection"!==e.type||(this.originY={coord:Math.round(t.clientY),value:e.initialHeight}),this.document.body.removeEventListener("mousemove",this.boundMousemove),this.document.body.style.cursor=Vt.get(e.type)||"default";const o=t=>{t.stopPropagation(),t.preventDefault(),this.originX=void 0,this.originY=void 0,this.document.body.style.cursor="default",this.document.body.removeEventListener("mousemove",n),this.document.body.addEventListener("mousemove",this.boundMousemove)};this.document.body.addEventListener("mouseup",o,{once:!0}),window.addEventListener("mouseout",o,{once:!0}),this.document.body.addEventListener("mousemove",n)}onDrag(t,e){if(!this.originX&&!this.originY)return;let n,o;if(this.originX){const t=this.originX.coord-e.clientX;n=Math.round(this.originX.value-t)}if(this.originY){const t=this.originY.coord-e.clientY;o=Math.round(this.originY.value-t)}t.update({width:n,height:o})}}function jt(t,e){return"start"===e?{x:(t.minX+t.maxX)/2,y:t.minY}:"center"===e?{x:(t.minX+t.maxX)/2,y:(t.minY+t.maxY)/2}:"end"===e?{x:(t.minX+t.maxX)/2,y:t.maxY}:void 0}const qt=5,Qt="white",Zt=6,Jt="#4585f6",te=4;function ee(t,e,n){let o=0,i=!0;e.x===n.minX?(o=-.5*Math.PI,i=!1):e.x===n.maxX?(o=.5*Math.PI,i=!1):e.y===n.minY?(o=0,i=!1):e.y===n.maxY&&(o=Math.PI,i=!1);const r=o+(i?2*Math.PI:Math.PI);t.save(),t.beginPath(),t.lineWidth=qt,t.strokeStyle=Qt,t.arc(e.x,e.y,Zt,o,r),t.stroke(),t.fillStyle=Jt,t.arc(e.x,e.y,te,o,r),t.fill(),t.restore()}function ne(t,e,n){!function(t,e,n){O(e,t.paddingBox,t.scrollPaddingColor,void 0,void 0,X(),n),e.save(),e.globalCompositeOperation="destination-out",O(e,t.snapport,"white",void 0,void 0,X(),n),e.restore()}(t,e,n);const o=function(t,e,n){const o=[];for(const i of t.snapAreas){const r=X();O(e,i.path,t.scrollMarginColor,t.snapAreaBorder.color,t.snapAreaBorder.pattern,r,n),e.save(),e.globalCompositeOperation="destination-out",O(e,i.borderBox,"white",void 0,void 0,X(),n),e.restore(),o.push(r)}return o}(t,e,n);!function(t,e,n){O(e,t.snapport,void 0,t.snapportBorder.color,void 0,X(),n)}(t,e,n),function(t,e,n){for(let r=0;r<e.snapAreas.length;r++){const s=e.snapAreas[r],a=s.alignInline?(o=t[r],"start"===(i=s.alignInline)?{x:o.minX,y:(o.minY+o.maxY)/2}:"center"===i?{x:(o.minX+o.maxX)/2,y:(o.minY+o.maxY)/2}:"end"===i?{x:o.maxX,y:(o.minY+o.maxY)/2}:void 0):null,l=s.alignBlock?jt(t[r],s.alignBlock):null;a&&ee(n,a,t[r]),l&&ee(n,l,t[r])}var o,i}(o,t,e)}class oe extends e{gridLabelState={gridLayerCounter:0};gridLabels;draggableBorders=new Map;dragHandler;reset(t){super.reset(t),this.gridLabelState.gridLayerCounter=0,this.gridLabels.innerHTML=""}renderGridMarkup(){const t=this.document.createElement("div");t.id="grid-label-container",this.document.body.append(t),this.gridLabels=t}install(){this.document.body.classList.add("fill");const t=this.document.createElement("canvas");t.id="canvas",t.classList.add("fill"),this.document.body.append(t),this.renderGridMarkup(),this.setCanvas(t),super.install(),this.dragHandler?.install()}uninstall(){this.document.body.classList.remove("fill"),this.document.body.innerHTML="",this.draggableBorders=new Map,super.uninstall(),this.dragHandler?.uninstall()}drawGridHighlight(t){this.context.save(),ft(t,this.context,this.deviceScaleFactor,this.canvasWidth,this.canvasHeight,this.emulationScaleFactor,this.gridLabelState),this.context.restore()}drawFlexContainerHighlight(t){this.context.save(),zt(t,this.context,this.deviceScaleFactor,this.canvasWidth,this.canvasHeight,this.emulationScaleFactor),this.context.restore()}drawScrollSnapHighlight(t){this.context.save(),ne(t,this.context,this.emulationScaleFactor),this.context.restore()}drawContainerQueryHighlight(t){this.context.save(),Kt(t,this.context,this.emulationScaleFactor),this.context.restore()}drawIsolatedElementHighlight(t){var e;this.dragHandler||(this.dragHandler=new _t(this.document,(e=this,{getDraggable:(t,n)=>{const o=e.isPointInDraggablePath(t,n);if(o)return{type:o.type,initialWidth:o.initialWidth,initialHeight:o.initialHeight,id:o.highlightIndex,update:({width:t,height:e})=>{window.InspectorOverlayHost.send({highlightType:"isolatedElement",highlightIndex:o.highlightIndex,newWidth:`${t}px`,newHeight:`${e}px`,resizerType:o.type})}}}})),this.dragHandler.install()),this.context.save();const{widthPath:n,heightPath:o,bidirectionPath:i,currentWidth:r,currentHeight:s,highlightIndex:a}=function(t,e,n,o,i){const{currentX:r,currentY:s,currentWidth:a,currentHeight:l,highlightIndex:c}=t;e.save(),e.fillStyle=t.isolationModeHighlightConfig.maskColor,e.fillRect(0,0,n,o),e.clearRect(r,s,a,l),e.restore();const d=X(),h=z(t.widthResizerBorder,d,i);F(e,h,d,0,{fillColor:t.isolationModeHighlightConfig.resizerColor});const p=z(t.heightResizerBorder,d,i);F(e,p,d,0,{fillColor:t.isolationModeHighlightConfig.resizerColor});const u=z(t.bidirectionResizerBorder,d,i);return F(e,u,d,0,{fillColor:t.isolationModeHighlightConfig.resizerColor}),{widthPath:h,heightPath:p,bidirectionPath:u,currentWidth:a,currentHeight:l,highlightIndex:c}}(t,this.context,this.canvasWidth,this.canvasHeight,this.emulationScaleFactor);this.draggableBorders.set(a,{widthPath:n,heightPath:o,bidirectionPath:i,highlightIndex:a,initialWidth:r,initialHeight:s}),this.context.restore()}isPointInDraggablePath(t,e){for(const{widthPath:n,heightPath:o,bidirectionPath:i,highlightIndex:r,initialWidth:s,initialHeight:a}of this.draggableBorders.values()){if(this.context.isPointInPath(n,t,e))return{type:$t.WIDTH,highlightIndex:r,initialWidth:s};if(this.context.isPointInPath(o,t,e))return{type:$t.HEIGHT,highlightIndex:r,initialHeight:a};if(this.context.isPointInPath(i,t,e))return{type:$t.BIDIRECTION,highlightIndex:r,initialWidth:s,initialHeight:a}}}}function ie(t){return 0===t[3]}const re="rgba(0,0,0,0.2)",se="rgba(0,0,0,0.7)",ae="rgba(255, 255, 255, 0.8)";const le="rgba(128, 128, 128, 0.3)";const ce=new CSSStyleSheet;ce.replaceSync('/*\n * Copyright 2021 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\nbody {\n  background-color: rgb(0 0 0 / 31%);\n}\n\n.controls-line {\n  display: flex;\n  justify-content: center;\n  margin: 10px 0;\n}\n\n.message-box {\n  padding: 2px 4px;\n  display: flex;\n  align-items: center;\n  cursor: default;\n  overflow: hidden;\n}\n\n#paused-in-debugger {\n  white-space: nowrap;\n  text-overflow: ellipsis;\n  overflow: hidden;\n}\n\n.controls-line > * {\n  background-color: rgb(255 255 194);\n  border: 1px solid rgb(202 202 202);\n  height: 22px;\n  box-sizing: border-box;\n}\n\n.controls-line .button {\n  width: 26px;\n  margin-left: -1px;\n  margin-right: 0;\n  padding: 0;\n  flex-shrink: 0;\n  flex-grow: 0;\n  cursor: pointer;\n}\n\n.controls-line .button .glyph {\n  width: 100%;\n  height: 100%;\n  background-color: rgb(0 0 0 / 75%);\n  opacity: 80%;\n  -webkit-mask-repeat: no-repeat;\n  -webkit-mask-position: center;\n  position: relative;\n}\n\n.controls-line .button:active .glyph {\n  top: 1px;\n  left: 1px;\n}\n\n#resume-button .glyph {\n  -webkit-mask-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAA0AAAAKCAYAAABv7tTEAAAAAXNSR0IArs4c6QAAAFJJREFUKM+10bEJgGAMBeEPbR3BLRzEVdzEVRzELRzBVohVwEJ+iODBlQfhBeJhsmHU4C0KnFjQV6J0x1SNAhdWDJUoPTB3PvLLeaUhypM3n3sD/qc7lDrdpIEAAAAASUVORK5CYII=");\n  -webkit-mask-size: 13px 10px;\n  background-color: rgb(66 129 235);\n}\n\n#step-over-button .glyph {\n  -webkit-mask-image: url("data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABIAAAAKCAYAAAC5Sw6hAAAAAXNSR0IArs4c6QAAAOFJREFUKM+N0j8rhXEUB/DPcxW35CqhvIBrtqibkklhV8qkTHe4ZbdblcXgPVhuMdqUTUl5A2KRRCF5LGc4PT1P7qnfcr5/zu/8KdTHLFaxjHnc4RZXKI0QYxjgLQTVd42l/0wmg5iFX3iq5H6w22RS4DyRH7CB8cAXcBTGJT6xUmd0mEwuMdFQcA3fwXvGTAan8BrgPabTL9fRRyfx91PRMwyjGwcJ2EyCfsrfpPw2Pipz24NT/MZciiQYVshzOKnZ5Hturxt3k2MnCpS4SPkeHpPR8Sh3tYgttBoW9II2/AHiaEqvD2Fc0wAAAABJRU5ErkJggg==");\n  -webkit-mask-size: 18px 10px;\n}\n');const de=new CSSStyleSheet;de.replaceSync("/*\n * Copyright 2021 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\nbody {\n  cursor: crosshair;\n}\n\n#zone {\n  background-color: #0003;\n  border: 1px solid #fffd;\n  display: none;\n  position: absolute;\n}\n");let he=null,pe=null;function ue(){if(!he)throw new Error("Error calculating currentRect: no anchor was defined.");if(!pe)throw new Error("Error calculating currentRect: no position was defined.");return{x:Math.min(he.x,pe.x),y:Math.min(he.y,pe.y),width:Math.abs(he.x-pe.x),height:Math.abs(he.y-pe.y)}}function ge(){he=null,pe=null}const me=new CSSStyleSheet;me.replaceSync("/*\n * Copyright 2021 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n:root {\n  --border-radius: 4px;\n}\n\n.source-order-label-container {\n  display: block;\n  min-width: 20px;\n  position: absolute;\n  text-align: center;\n  align-items: center;\n  background-color: #fff;\n  font-family: Menlo, Consolas, monospace;\n  font-size: 12px;\n  font-weight: bold;\n  padding: 2px;\n  border: 1.5px solid;\n}\n\n.top-corner {\n  border-bottom-right-radius: var(--border-radius);\n}\n\n.bottom-corner {\n  border-top-right-radius: var(--border-radius);\n}\n\n.above-element {\n  border-top-right-radius: var(--border-radius);\n  border-top-left-radius: var(--border-radius);\n}\n\n.below-element {\n  border-bottom-right-radius: var(--border-radius);\n  border-bottom-left-radius: var(--border-radius);\n}\n\n.above-element-wider {\n  border-top-right-radius: var(--border-radius);\n  border-top-left-radius: var(--border-radius);\n  border-bottom-right-radius: var(--border-radius);\n}\n\n.below-element-wider {\n  border-bottom-right-radius: var(--border-radius);\n  border-bottom-left-radius: var(--border-radius);\n  border-top-right-radius: var(--border-radius);\n}\n\n.bottom-corner-wider {\n  border-top-right-radius: var(--border-radius);\n  border-bottom-right-radius: var(--border-radius);\n}\n\n.bottom-corner-taller {\n  border-top-right-radius: var(--border-radius);\n  border-top-left-radius: var(--border-radius);\n}\n\n.bottom-corner-wider-taller {\n  border-top-left-radius: var(--border-radius);\n  border-top-right-radius: var(--border-radius);\n  border-bottom-right-radius: var(--border-radius);\n}\n");const fe=300,xe={topCorner:"top-corner",aboveElement:"above-element",belowElement:"below-element",aboveElementWider:"above-element-wider",belowElementWider:"below-element-wider",bottomCornerWider:"bottom-corner-wider",bottomCornerTaller:"bottom-corner-taller",bottomCornerWiderTaller:"bottom-corner-wider-taller"};function be(t){return t%1?t.toFixed(2):String(t)}a(t);const ye=new CSSStyleSheet;ye.replaceSync('\n/* Grid row and column labels */\n.grid-label-content {\n  position: absolute;\n  -webkit-user-select: none;\n  padding: 2px;\n  font-family: Menlo, monospace;\n  font-size: 10px;\n  min-width: 17px;\n  min-height: 15px;\n  border-radius: 2px;\n  box-sizing: border-box;\n  z-index: 1;\n  background-clip: padding-box;\n  pointer-events: none;\n  text-align: center;\n  display: flex;\n  justify-content: center;\n  align-items: center;\n}\n\n.grid-label-content[data-direction=row] {\n  background-color: var(--row-label-color, #1A73E8);\n  color: var(--row-label-text-color, #121212);\n}\n\n.grid-label-content[data-direction=column] {\n  background-color: var(--column-label-color, #1A73E8);\n  color: var(--column-label-text-color,#121212);\n}\n\n.line-names ul,\n.line-names .line-name {\n  margin: 0;\n  padding: 0;\n  list-style: none;\n}\n\n.line-names .line-name {\n  max-width: 100px;\n  white-space: nowrap;\n  overflow: hidden;\n  text-overflow: ellipsis;\n}\n\n.line-names .grid-label-content,\n.line-numbers .grid-label-content,\n.track-sizes .grid-label-content {\n  border: 1px solid white;\n  --inner-corner-avoid-distance: 15px;\n}\n\n.grid-label-content.top-left.inner-shared-corner,\n.grid-label-content.top-right.inner-shared-corner {\n  transform: translateY(var(--inner-corner-avoid-distance));\n}\n\n.grid-label-content.bottom-left.inner-shared-corner,\n.grid-label-content.bottom-right.inner-shared-corner {\n  transform: translateY(calc(var(--inner-corner-avoid-distance) * -1));\n}\n\n.grid-label-content.left-top.inner-shared-corner,\n.grid-label-content.left-bottom.inner-shared-corner {\n  transform: translateX(var(--inner-corner-avoid-distance));\n}\n\n.grid-label-content.right-top.inner-shared-corner,\n.grid-label-content.right-bottom.inner-shared-corner {\n  transform: translateX(calc(var(--inner-corner-avoid-distance) * -1));\n}\n\n.line-names .grid-label-content::before,\n.line-numbers .grid-label-content::before,\n.track-sizes .grid-label-content::before {\n  position: absolute;\n  z-index: 1;\n  pointer-events: none;\n  content: "";\n  width: 3px;\n  height: 3px;\n  border: 1px solid white;\n  border-width: 0 1px 1px 0;\n}\n\n.line-names .grid-label-content[data-direction=row]::before,\n.line-numbers .grid-label-content[data-direction=row]::before,\n.track-sizes .grid-label-content[data-direction=row]::before {\n  background: var(--row-label-color, #1A73E8);\n}\n\n.line-names .grid-label-content[data-direction=column]::before,\n.line-numbers .grid-label-content[data-direction=column]::before,\n.track-sizes .grid-label-content[data-direction=column]::before {\n  background: var(--column-label-color, #1A73E8);\n}\n\n.grid-label-content.bottom-mid::before {\n  transform: translateY(-1px) rotate(45deg);\n  top: 100%;\n}\n\n.grid-label-content.top-mid::before {\n  transform: translateY(-3px) rotate(-135deg);\n  top: 0%;\n}\n\n.grid-label-content.left-mid::before {\n  transform: translateX(-3px) rotate(135deg);\n  left: 0%\n}\n\n.grid-label-content.right-mid::before {\n  transform: translateX(3px) rotate(-45deg);\n  right: 0%;\n}\n\n.grid-label-content.right-top::before {\n  transform: translateX(3px) translateY(-1px) rotate(-90deg) skewY(30deg);\n  right: 0%;\n  top: 0%;\n}\n\n.grid-label-content.right-bottom::before {\n  transform: translateX(3px) translateY(-3px) skewX(30deg);\n  right: 0%;\n  top: 100%;\n}\n\n.grid-label-content.bottom-right::before {\n  transform:  translateX(1px) translateY(-1px) skewY(30deg);\n  right: 0%;\n  top: 100%;\n}\n\n.grid-label-content.bottom-left::before {\n  transform:  translateX(-1px) translateY(-1px) rotate(90deg) skewX(30deg);\n  left: 0%;\n  top: 100%;\n}\n\n.grid-label-content.left-top::before {\n  transform: translateX(-3px) translateY(-1px) rotate(180deg) skewX(30deg);\n  left: 0%;\n  top: 0%;\n}\n\n.grid-label-content.left-bottom::before {\n  transform: translateX(-3px) translateY(-3px) rotate(90deg) skewY(30deg);\n  left: 0%;\n  top: 100%;\n}\n\n.grid-label-content.top-right::before {\n  transform:  translateX(1px) translateY(-3px) rotate(-90deg) skewX(30deg);\n  right: 0%;\n  top: 0%;\n}\n\n.grid-label-content.top-left::before {\n  transform:  translateX(-1px) translateY(-3px) rotate(180deg) skewY(30deg);\n  left: 0%;\n  top: 0%;\n}\n\n@media (forced-colors: active) {\n  .grid-label-content {\n      border-color: Highlight;\n      background-color: Canvas;\n      color: Text;\n      forced-color-adjust: none;\n  }\n  .grid-label-content::before {\n    background-color: Canvas;\n    border-color: Highlight;\n  }\n}');const ve=new class extends e{tooltip;persistentOverlay;gridLabelState={gridLayerCounter:0};reset(t){super.reset(t),this.tooltip.innerHTML="",this.gridLabelState.gridLayerCounter=0,this.persistentOverlay&&this.persistentOverlay.reset(t)}install(){this.document.body.classList.add("fill");const t=this.document.createElement("canvas");t.id="canvas",t.classList.add("fill"),this.document.body.append(t);const e=this.document.createElement("div");e.id="tooltip-container",this.document.body.append(e),this.tooltip=e,this.persistentOverlay=new oe(this.window),this.persistentOverlay.renderGridMarkup(),this.persistentOverlay.setCanvas(t),this.setCanvas(t),super.install()}uninstall(){this.document.body.classList.remove("fill"),this.document.body.innerHTML="",super.uninstall()}drawHighlight(t){this.context.save();const e=X();let a=null,c=null;for(let n=t.paths.slice();n.length;){const t=n.pop();t&&(this.context.save(),O(this.context,t.path,t.fillColor,t.outlineColor,void 0,e,this.emulationScaleFactor),n.length&&(this.context.globalCompositeOperation="destination-out",O(this.context,n[n.length-1].path,"red",void 0,void 0,e,this.emulationScaleFactor)),this.context.restore(),"content"===t.name&&(a=t.path),"border"===t.name&&(c=t.path))}this.context.restore(),this.context.save();const h=Boolean(t.paths.length&&t.showRulers&&e.minX<20&&e.maxX+20<this.canvasWidth),p=Boolean(t.paths.length&&t.showRulers&&e.minY<20&&e.maxY+20<this.canvasHeight);if(t.showRulers&&this.drawAxis(this.context,h,p),t.paths.length&&(t.showExtensionLines&&function(t,e,n,o,i,r,s,a){t.save();const l=s,c=a;t.strokeStyle=i||le,t.lineWidth=1,t.translate(.5,.5),r&&t.setLineDash([3,3]);if(n)for(const n in e.rightmostXForY)t.beginPath(),t.moveTo(l,Number(n)),t.lineTo(e.rightmostXForY[n],Number(n)),t.stroke();else for(const n in e.leftmostXForY)t.beginPath(),t.moveTo(0,Number(n)),t.lineTo(e.leftmostXForY[n],Number(n)),t.stroke();if(o)for(const n in e.bottommostYForX)t.beginPath(),t.moveTo(Number(n),c),t.lineTo(Number(n),e.topmostYForX[n]),t.stroke();else for(const n in e.topmostYForX)t.beginPath(),t.moveTo(Number(n),0),t.lineTo(Number(n),e.topmostYForX[n]),t.stroke();t.restore()}(this.context,e,h,p,void 0,!1,this.canvasWidth,this.canvasHeight),t.elementInfo&&function(t,e,a,c,h){const p=document.getElementById("tooltip-container");if(!p)throw new Error("#tooltip-container is not found");p.innerHTML="";const u=n(p,"div"),g=n(u,"div","tooltip-content"),m=function(t,e){const s=i("div","element-info"),a=n(s,"div","element-info-header"),c=function(t){if(t.layoutObjectName&&t.layoutObjectName.endsWith("Grid"))return"grid";if(t.layoutObjectName&&"LayoutNGFlexibleBox"===t.layoutObjectName)return"flex";return null}(t);c&&n(a,"div",`element-layout-type ${c}`);const h=n(a,"div","element-description monospace");n(h,"span","material-tag-name").textContent=t.tagName;const p=n(h,"span","material-node-id"),u=80;p.textContent=t.idValue?"#"+r(t.idValue,u):"",p.classList.toggle("hidden",!t.idValue);const g=n(h,"span","material-class-name");p.textContent.length<u&&(g.textContent=r(t.className||"",u-p.textContent.length));g.classList.toggle("hidden",!t.className);const m=n(a,"div","dimensions");n(m,"span","material-node-width").textContent=String(Math.round(100*t.nodeWidth)/100),o(m,"×"),n(m,"span","material-node-height").textContent=String(Math.round(100*t.nodeHeight)/100);const f=t.style||{};let x;t.isLockedAncestor&&T("Showing content-visibility ancestor","");t.isLocked&&T("Descendants are skipped due to content-visibility","");const b=f.color,y=f["color-unclamped-rgba"];b&&y&&!ie(y)&&I("Color",f["color-css-text"]??b,f["color-css-text"]?"original":e);const v=f["font-family"],w=f["font-size"];v&&"0px"!==w&&T("Font",`${w} ${v}`);const M=f["background-color"],C=f["background-color-unclamped-rgba"];M&&C&&!ie(C)&&I("Background",f["background-color-css-text"]??M,f["background-color-css-text"]?"original":e);const L=f.margin;L&&"0px"!==L&&T("Margin",L);const A=f.padding;A&&"0px"!==A&&T("Padding",A);const E=t.contrast?t.contrast.backgroundColorUnclampedRgba:null,F=y&&!ie(y)&&E&&!ie(E);t.showAccessibilityInfo&&(X("Accessibility"),F&&f["color-unclamped-rgba"]&&t.contrast&&B(f["color-unclamped-rgba"],t.contrast),T("Name",t.accessibleName),T("Role",t.accessibleRole),P("Keyboard-focusable",t.isKeyboardFocusable?"a11y-icon a11y-icon-ok":"a11y-icon a11y-icon-not-ok"));function z(){x||(x=n(s,"div","element-info-body"))}function X(t){z();const e=n(x,"div","element-info-row element-info-section");n(e,"div","section-name").textContent=t,n(n(e,"div","separator-container"),"div","separator")}function Y(t,e,o){z();const i=n(x,"div","element-info-row");e&&i.classList.add(e);return n(i,"div","element-info-name").textContent=t,n(i,"div","element-info-gap"),n(i,"div",o||"")}function P(t,e){n(Y(t,"","element-info-value-icon"),"div",e)}function T(t,e){o(Y(t,"","element-info-value-text"),e)}function I(t,e,i){const r=Y(t,"","element-info-value-color"),s=n(r,"div","color-swatch");n(s,"div","color-swatch-inner").style.backgroundColor=e,o(r,function(t,e){return"rgb"===e||"hsl"===e||"hwb"===e?W(N(t),e):t.endsWith("FF")?t.substr(0,7):t}(e,i))}function B(t,e){const o=t.slice(),i=e.backgroundColorUnclampedRgba.slice();o[3]*=e.textOpacity;const r=Y("Contrast","","element-info-value-contrast"),s=n(r,"div","contrast-text");s.style.color=W(o,"rgb"),s.style.backgroundColor=e.backgroundColorCssText,s.textContent="Aa";const a=n(r,"span");if("apca"===e.contrastAlgorithm){const t=S(o,i),s=function(t,e){const n=parseFloat(t.replace("px","")),o=parseFloat(e);for(const[t,...e]of k)if(n>=t)for(const[t,n]of[900,800,700,600,500,400,300,200,100].entries())if(o>=n){const n=e[e.length-1-t];return-1===n?null:n}return null}(e.fontSize,e.fontWeight);a.textContent=String(Math.floor(100*t)/100)+"%",n(r,"div",null===s||Math.abs(t)<s?"a11y-icon a11y-icon-warning":"a11y-icon a11y-icon-ok")}else if("aa"===e.contrastAlgorithm||"aaa"===e.contrastAlgorithm){const t=function(t,e){const n=d(l(t,e)),o=d(e);return(Math.max(n,o)+.05)/(Math.min(n,o)+.05)}(o,i),s=H(e.fontSize,e.fontWeight)[e.contrastAlgorithm];a.textContent=String(Math.floor(100*t)/100),n(r,"div",t<s?"a11y-icon a11y-icon-warning":"a11y-icon a11y-icon-ok")}}return s}(t,e);g.appendChild(m);const f=g.offsetWidth,x=g.offsetHeight,b=8,y=2,v=2*b,w=b+2,M=y+w,C=c-y-w-v,L=a.maxX-a.minX<v+2*w;let A;if(L)A=.5*(a.minX+a.maxX)-b;else{const t=a.minX+w,e=a.maxX-w-v;A=t>M&&t<C?t:s(M,t,e)}const E=A<M||A>C;let F=A-w;F=s(F,y,c-f-y);let z=a.minY-b-x,X=!0;z<0?(z=Math.min(h-x,a.maxY+b),X=!1):a.minY>h&&(z=h-b-x);const Y=F>=a.minX&&F+f<=a.maxX&&z>=a.minY&&z+x<=a.maxY,P=F<a.maxX&&F+f>a.minX&&z<a.maxY&&z+x>a.minY;if(P&&!Y)return void(g.style.display="none");if(g.style.top=z+"px",g.style.left=F+"px",g.style.setProperty("--arrow-visibility",E||Y?"hidden":"visible"),E)return;g.style.setProperty("--arrow",X?"var(--arrow-down)":"var(--arrow-up)"),g.style.setProperty("--shadow-direction",X?"var(--shadow-up)":"var(--shadow-down)"),g.style.setProperty("--arrow-top",(X?x-1:-b)+"px"),g.style.setProperty("--arrow-left",A-F+"px")}(t.elementInfo,t.colorFormat,e,this.canvasWidth,this.canvasHeight)),t.gridInfo)for(const e of t.gridInfo)ft(e,this.context,this.deviceScaleFactor,this.canvasWidth,this.canvasHeight,this.emulationScaleFactor,this.gridLabelState);if(t.flexInfo)for(const e of t.flexInfo)zt(e,this.context,this.deviceScaleFactor,this.canvasWidth,this.canvasHeight,this.emulationScaleFactor);if(t.containerQueryInfo)for(const e of t.containerQueryInfo)Kt(e,this.context,this.emulationScaleFactor);const u=t.flexInfo?.length&&t.flexInfo.some((t=>Object.keys(t.flexContainerHighlightConfig).length>0));if(t.flexItemInfo&&!u)for(const e of t.flexItemInfo){const t="content"===e.boxSizing?a:c;t&&Ft(e,t,this.context,this.deviceScaleFactor,this.canvasWidth,this.canvasHeight,this.emulationScaleFactor)}return this.context.restore(),{bounds:e}}drawGridHighlight(t){this.persistentOverlay&&this.persistentOverlay.drawGridHighlight(t)}drawFlexContainerHighlight(t){this.persistentOverlay&&this.persistentOverlay.drawFlexContainerHighlight(t)}drawScrollSnapHighlight(t){this.persistentOverlay?.drawScrollSnapHighlight(t)}drawContainerQueryHighlight(t){this.persistentOverlay?.drawContainerQueryHighlight(t)}drawIsolatedElementHighlight(t){this.persistentOverlay?.drawIsolatedElementHighlight(t)}drawAxis(t,e,n){t.save();const o=this.pageZoomFactor*this.pageScaleFactor*this.emulationScaleFactor,i=this.scrollX*this.pageScaleFactor,r=this.scrollY*this.pageScaleFactor;function s(t){return Math.round(t*o)}function a(t){return Math.round(t/o)}const l=this.canvasWidth/o,c=this.canvasHeight/o,d=50;t.save(),t.fillStyle=ae,n?t.fillRect(0,s(c)-15,s(l),s(c)):t.fillRect(0,0,s(l),15),t.globalCompositeOperation="destination-out",t.fillStyle="red",e?t.fillRect(s(l)-15,0,s(l),s(c)):t.fillRect(0,0,15,s(c)),t.restore(),t.fillStyle=ae,e?t.fillRect(s(l)-15,0,s(l),s(c)):t.fillRect(0,0,15,s(c)),t.lineWidth=1,t.strokeStyle=se,t.fillStyle=se;{t.save(),t.translate(-i,.5-r);const o=c+a(r);for(let n=100;n<o;n+=100)t.save(),t.translate(i,s(n)),t.rotate(-Math.PI/2),t.fillText(String(n),2,e?s(l)-7:13),t.restore();t.translate(.5,-.5);const d=l+a(i);for(let e=100;e<d;e+=100)t.save(),t.fillText(String(e),s(e)+2,n?r+s(c)-7:r+13),t.restore();t.restore()}{t.save(),e&&(t.translate(s(l),0),t.scale(-1,1)),t.translate(-i,.5-r);const n=c+a(r);for(let e=d;e<n;e+=d){t.beginPath(),t.moveTo(i,s(e));const n=e%100?5:8;t.lineTo(i+n,s(e)),t.stroke()}t.strokeStyle=re;for(let e=5;e<n;e+=5)e%d&&(t.beginPath(),t.moveTo(i,s(e)),t.lineTo(i+5,s(e)),t.stroke());t.restore()}{t.save(),n&&(t.translate(0,s(c)),t.scale(1,-1)),t.translate(.5-i,-r);const e=l+a(i);for(let n=d;n<e;n+=d){t.beginPath(),t.moveTo(s(n),r);const e=n%100?5:8;t.lineTo(s(n),r+e),t.stroke()}t.strokeStyle=re;for(let n=5;n<e;n+=5)n%d&&(t.beginPath(),t.moveTo(s(n),r),t.lineTo(s(n),r+5),t.stroke());t.restore()}t.restore()}}(window,[wt,ye]),we=new oe(window,[vt,ye]),Me=new class extends e{drawDistances({distanceInfo:t}){if(!t)return;const e=(n=function(t){const e=t.style;return n(e)?t.border:o(e)?t.padding:t.content;function n(t){const e=["top","right","bottom","left"];for(const n of e){const e=t[`border-${n}-width`],o=t[`border-${n}-style`],i=t[`border-${n}-color`];if("0px"!==e&&"none"!==o&&!i.endsWith("00"))return!0}const n=t["outline-width"],o=t["outline-style"],i=t["outline-color"];return"0px"!==n&&"none"!==o&&!i.endsWith("00")||"none"!==t["box-shadow"]}function o(t){const e=t["background-color"],n=t["background-image"];return!e.startsWith("#FFFFFF")&&!e.endsWith("00")||"none"!==n}}(t),{x:n[0],y:n[1],w:n[4]-n[0],h:n[5]-n[1]});var n;this.context.save(),this.context.strokeStyle="#ccc";for(const e of t.boxes)this.context.strokeRect(e[0],e[1],e[2],e[3]);this.context.strokeStyle="#f00",this.context.lineWidth=1,this.context.rect(e.x-.5,e.y-.5,e.w+1,e.h+1),this.context.stroke(),this.context.restore()}install(){this.document.body.classList.add("fill");const t=this.document.createElement("canvas");t.id="canvas",t.classList.add("fill"),this.document.body.append(t),this.setCanvas(t),super.install()}uninstall(){this.document.body.classList.remove("fill"),this.document.body.innerHTML="",super.uninstall()}}(window),Ce=new class extends e{container;constructor(t,e=[]){super(t,e),this.onKeyDown=this.onKeyDown.bind(this)}onKeyDown(t){"F8"===t.key||this.eventHasCtrlOrMeta(t)&&"\\"===t.key?this.window.InspectorOverlayHost.send("resume"):("F10"===t.key||this.eventHasCtrlOrMeta(t)&&"'"===t.key)&&this.window.InspectorOverlayHost.send("stepOver")}install(){const t=this.document.createElement("div");t.classList.add("controls-line");const e=this.document.createElement("div");e.classList.add("message-box");const n=this.document.createElement("div");n.id="paused-in-debugger",this.container=n,e.append(n),t.append(e);const o=this.document.createElement("div");o.id="resume-button",o.title="Resume script execution (F8).",o.classList.add("button");const i=this.document.createElement("div");i.classList.add("glyph"),o.append(i),t.append(o);const r=this.document.createElement("div");r.id="step-over-button",r.title="Step over next function call (F10).",r.classList.add("button");const s=this.document.createElement("div");s.classList.add("glyph"),r.append(s),t.append(r),this.document.body.append(t),this.document.addEventListener("keydown",this.onKeyDown),o.addEventListener("click",(()=>this.window.InspectorOverlayHost.send("resume"))),r.addEventListener("click",(()=>this.window.InspectorOverlayHost.send("stepOver"))),super.install()}uninstall(){this.document.body.innerHTML="",this.document.removeEventListener("keydown",this.onKeyDown),super.uninstall()}drawPausedInDebuggerMessage(t){this.container.textContent=t}}(window,ce),Se=new class extends e{zone;constructor(t,e=[]){super(t,e),this.onMouseDown=this.onMouseDown.bind(this),this.onMouseUp=this.onMouseUp.bind(this),this.onMouseMove=this.onMouseMove.bind(this),this.onKeyDown=this.onKeyDown.bind(this)}install(){const t=this.document.documentElement;t.addEventListener("mousedown",this.onMouseDown,!0),t.addEventListener("mouseup",this.onMouseUp,!0),t.addEventListener("mousemove",this.onMouseMove,!0),t.addEventListener("keydown",this.onKeyDown,!0);const e=this.document.createElement("div");e.id="zone",this.document.body.append(e),this.zone=e,super.install()}uninstall(){this.document.body.innerHTML="";const t=this.document.documentElement;t.removeEventListener("mousedown",this.onMouseDown,!0),t.removeEventListener("mouseup",this.onMouseUp,!0),t.removeEventListener("mousemove",this.onMouseMove,!0),t.removeEventListener("keydown",this.onKeyDown,!0),super.uninstall()}onMouseDown(t){he={x:t.pageX,y:t.pageY},pe=he,this.updateZone(),t.stopPropagation(),t.preventDefault()}onMouseUp(t){if(he&&pe){const t=ue();t.width>=5&&t.height>=5&&this.window.InspectorOverlayHost.send(t)}ge(),this.updateZone(),t.stopPropagation(),t.preventDefault()}onMouseMove(t){he&&1===t.buttons?pe={x:t.pageX,y:t.pageY}:he=null,this.updateZone(),t.stopPropagation(),t.preventDefault()}onKeyDown(t){he&&"Escape"===t.key&&(ge(),this.updateZone(),t.stopPropagation(),t.preventDefault())}updateZone(){const t=this.zone;if(!pe||!he)return void(t.style.display="none");t.style.display="block";const e=ue();t.style.left=e.x+"px",t.style.top=e.y+"px",t.style.width=e.width+"px",t.style.height=e.height+"px"}}(window,de),Le={distances:Me,highlight:ve,persistent:we,paused:Ce,screenshot:Se,sourceOrder:new class extends e{sourceOrderContainer;reset(t){super.reset(t),this.sourceOrderContainer.textContent=""}install(){this.document.body.classList.add("fill");const t=this.document.createElement("canvas");t.id="canvas",t.classList.add("fill"),this.document.body.append(t);const e=this.document.createElement("div");e.id="source-order-container",this.document.body.append(e),this.sourceOrderContainer=e,this.setCanvas(t),super.install()}uninstall(){this.document.body.classList.remove("fill"),this.document.body.innerHTML="",super.uninstall()}drawSourceOrder(t){const e=t.sourceOrder||0,n=t.paths.slice().pop();if(!n)throw new Error("No path provided");this.context.save();const o=X(),i=n.outlineColor;return this.context.save(),function(t,e,n,o,i,r){t.save();const s=z(e,i,r);n&&(t.strokeStyle=n,t.lineWidth=2,o||t.setLineDash([3,3]),t.stroke(s));t.restore()}(this.context,n.path,i,Boolean(e),o,this.emulationScaleFactor),this.context.restore(),this.context.save(),Boolean(e)&&this.drawSourceOrderLabel(e,i,o),this.context.restore(),{bounds:o}}drawSourceOrderLabel(t,e,o){const i=this.sourceOrderContainer,r=i.children,s=n(i,"div","source-order-label-container");s.style.color=e,s.textContent=String(t);const a=s.offsetHeight,l=function(t,e,n,o,i){let r;const s=t.minX+n>t.maxX,a=t.minY+e>t.maxY;if(!s&&!a||o.length>=fe)return xe.topCorner;let l=!1;for(let i=0;i<o.length;i++){const r=o[i],s=r.getBoundingClientRect();if(""===r.style.top&&""===r.style.left)continue;const a=t.minY-e<=s.top+s.height&&t.minY-e>=s.top,c=t.minY<=s.top+s.height&&t.minY>=s.top,d=t.minX>=s.left&&t.minX<=s.left+s.width,h=t.minX+n>=s.left&&t.minX+n<=s.left+s.width;if((d||h)&&(a||c)){l=!0;break}}t.minY-e>0&&!l?(r=xe.aboveElement,s&&(r=xe.aboveElementWider)):t.maxY+e<i?(r=xe.belowElement,s&&(r=xe.belowElementWider)):r=s&&a?xe.bottomCornerWiderTaller:s?xe.bottomCornerWider:xe.bottomCornerTaller;return r}(o,a,s.offsetWidth,r,this.canvasHeight),c=function(t,e,n){let o=0;switch(t){case xe.topCorner:o=e.minY;break;case xe.aboveElement:case xe.aboveElementWider:o=e.minY-n;break;case xe.belowElement:case xe.belowElementWider:o=e.maxY;break;case xe.bottomCornerWider:case xe.bottomCornerTaller:case xe.bottomCornerWiderTaller:o=e.maxY-n}return{contentTop:o,contentLeft:e.minX}}(l,o,a);s.classList.add(l),s.style.top=c.contentTop+"px",s.style.left=c.contentLeft+"px"}}(window,me),viewportSize:new class extends e{install(){this.document.body.classList.add("fill");const t=this.document.createElement("canvas");t.id="canvas",t.classList.add("fill"),this.document.body.append(t),this.setCanvas(t),super.install()}uninstall(){this.document.body.classList.remove("fill"),this.document.body.innerHTML="",super.uninstall()}drawViewSize(){const t=this.viewportSizeForMediaQueries||this.viewportSize,e=`${be(t.width)}px × ${be(t.height)}px`,n=this.canvasWidth||0;this.context.save(),this.context.font=`14px ${this.window.getComputedStyle(document.body).fontFamily}`;const o=this.context.measureText(e).width;this.context.fillStyle="rgba(255 255 255 / 0.8)",this.context.fillRect(n-o-12,0,n,25),this.context.fillStyle="rgba(0 0 0 / 0.7)",this.context.fillText(e,n-o-6,18),this.context.restore()}}(window)};let ke,Ae;window.dispatch=t=>{const e=t[0];if("setOverlay"===e){const e=t[1];ke&&ke.uninstall(),ke=Le[e],ke.setPlatform(Ae),ke.installed||ke.install()}else"setPlatform"===e?Ae=t[1]:"drawingFinished"===e||ke.dispatch(t)}}();
