/*
 * Copyright (c) 2007, 2015, 2022 -2022 Apple Inc. All rights reserved.
 * Copyright (c) 2013 Google Inc. All rights reserved.
 * Copyright (c) 2014, 2015, 2016, 2019, 2022, 2024 Apple Inc. All rights reserved.
 * Copyright (c) 2014, 2017 -2017 Apple Inc. All rights reserved.
 * Copyright (c) 2015 Andy VanWagoner <andy@vanwagoner.family>.
 * Copyright (c) 2015 Jordan Harband. All rights reserved.
 * Copyright (c) 2015, 2016 -2016 Apple Inc. All rights reserved.
 * Copyright (c) 2015, 2016 -2016 Yusuke Suzuki <utatane.tea@gmail.com>.
 * Copyright (c) 2015, 2016, 2017 Yusuke Suzuki <utatane.tea@gmail.com>.
 * Copyright (c) 2016 Caitlin Potter <caitp@igalia.com>.
 * Copyright (c) 2016 Yusuke Suzuki <utatane.tea@gmail.com>
 * Copyright (c) 2016, 2017 -2017 Yusuke Suzuki <utatane.tea@gmail.com>.
 * Copyright (c) 2016, 2017, 2018 Oleksandr Skachkov <gskachkov@gmail.com>.
 * Copyright (c) 2016, 2018 -2018 Apple Inc. All rights reserved.
 * Copyright (c) 2016, 2019 -2019 Apple Inc. All rights reserved.
 * Copyright (c) 2016, 2024 -2024 Apple Inc. All rights reserved.
 * Copyright (c) 2017 Caio Lima <ticaiolima@gmail.com>.
 * Copyright (c) 2018 Yusuke Suzuki <yusukesuzuki@slowstart.org>.
 * Copyright (c) 2019 Alexey Shvayka <shvaikalesh@gmail.com>.
 * Copyright (c) 2021 Igalia S.L.
 * Copyright (c) 2022 Jarred Sumner. All rights reserved.
 * Copyright (c) 2023 Devin Rousso <webkit@devinrousso.com>.
 * Copyright (c) 2024, 2025 Sosuke Suzuki <aosukeke@gmail.com>.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 * 
 */

// DO NOT EDIT THIS FILE. It is automatically generated from JavaScript files for
// builtins by the script: Source/JavaScriptCore/Scripts/generate-js-builtins.py

#pragma once

namespace JSC {
class FunctionExecutable;
class VM;

enum class ConstructAbility : uint8_t;
enum class ConstructorKind : uint8_t;
enum class ImplementationVisibility : uint8_t;
enum class InlineAttribute : uint8_t;
}

namespace JSC {

extern const char s_JSCCombinedCode[];

extern const unsigned s_JSCCombinedCodeLength;

/* ArrayConstructor */
extern constinit const char* const s_arrayConstructorOfCode;
extern constinit const int s_arrayConstructorOfCodeLength;
extern constinit const JSC::ConstructAbility s_arrayConstructorOfCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayConstructorOfCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayConstructorOfCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayConstructorOfCodeInlineAttribute;
extern constinit const char* const s_arrayConstructorFromCode;
extern constinit const int s_arrayConstructorFromCodeLength;
extern constinit const JSC::ConstructAbility s_arrayConstructorFromCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayConstructorFromCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayConstructorFromCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayConstructorFromCodeInlineAttribute;
extern constinit const char* const s_arrayConstructorIsArrayCode;
extern constinit const int s_arrayConstructorIsArrayCodeLength;
extern constinit const JSC::ConstructAbility s_arrayConstructorIsArrayCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayConstructorIsArrayCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayConstructorIsArrayCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayConstructorIsArrayCodeInlineAttribute;
extern constinit const char* const s_arrayConstructorDefaultAsyncFromAsyncIteratorCode;
extern constinit const int s_arrayConstructorDefaultAsyncFromAsyncIteratorCodeLength;
extern constinit const JSC::ConstructAbility s_arrayConstructorDefaultAsyncFromAsyncIteratorCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayConstructorDefaultAsyncFromAsyncIteratorCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayConstructorDefaultAsyncFromAsyncIteratorCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayConstructorDefaultAsyncFromAsyncIteratorCodeInlineAttribute;
extern constinit const char* const s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCode;
extern constinit const int s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCodeLength;
extern constinit const JSC::ConstructAbility s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCodeInlineAttribute;
extern constinit const char* const s_arrayConstructorFromAsyncCode;
extern constinit const int s_arrayConstructorFromAsyncCodeLength;
extern constinit const JSC::ConstructAbility s_arrayConstructorFromAsyncCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayConstructorFromAsyncCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayConstructorFromAsyncCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayConstructorFromAsyncCodeInlineAttribute;

#define JSC_FOREACH_ARRAYCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(of, arrayConstructorOf, 0) \
    macro(from, arrayConstructorFrom, 1) \
    macro(isArray, arrayConstructorIsArray, 1) \
    macro(defaultAsyncFromAsyncIterator, arrayConstructorDefaultAsyncFromAsyncIterator, 3) \
    macro(defaultAsyncFromAsyncArrayLike, arrayConstructorDefaultAsyncFromAsyncArrayLike, 3) \
    macro(fromAsync, arrayConstructorFromAsync, 1) \

/* ArrayIteratorPrototype */
extern constinit const char* const s_arrayIteratorPrototypeNextCode;
extern constinit const int s_arrayIteratorPrototypeNextCodeLength;
extern constinit const JSC::ConstructAbility s_arrayIteratorPrototypeNextCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayIteratorPrototypeNextCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayIteratorPrototypeNextCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayIteratorPrototypeNextCodeInlineAttribute;
extern constinit const char* const s_arrayIteratorPrototypeArrayIteratorNextHelperCode;
extern constinit const int s_arrayIteratorPrototypeArrayIteratorNextHelperCodeLength;
extern constinit const JSC::ConstructAbility s_arrayIteratorPrototypeArrayIteratorNextHelperCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayIteratorPrototypeArrayIteratorNextHelperCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayIteratorPrototypeArrayIteratorNextHelperCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayIteratorPrototypeArrayIteratorNextHelperCodeInlineAttribute;

#define JSC_FOREACH_ARRAYITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, arrayIteratorPrototypeNext, 0) \
    macro(arrayIteratorNextHelper, arrayIteratorPrototypeArrayIteratorNextHelper, 2) \

/* ArrayPrototype */
extern constinit const char* const s_arrayPrototypeReduceCode;
extern constinit const int s_arrayPrototypeReduceCodeLength;
extern constinit const JSC::ConstructAbility s_arrayPrototypeReduceCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayPrototypeReduceCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayPrototypeReduceCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayPrototypeReduceCodeInlineAttribute;
extern constinit const char* const s_arrayPrototypeReduceRightCode;
extern constinit const int s_arrayPrototypeReduceRightCodeLength;
extern constinit const JSC::ConstructAbility s_arrayPrototypeReduceRightCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayPrototypeReduceRightCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayPrototypeReduceRightCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayPrototypeReduceRightCodeInlineAttribute;
extern constinit const char* const s_arrayPrototypeEveryCode;
extern constinit const int s_arrayPrototypeEveryCodeLength;
extern constinit const JSC::ConstructAbility s_arrayPrototypeEveryCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayPrototypeEveryCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayPrototypeEveryCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayPrototypeEveryCodeInlineAttribute;
extern constinit const char* const s_arrayPrototypeForEachCode;
extern constinit const int s_arrayPrototypeForEachCodeLength;
extern constinit const JSC::ConstructAbility s_arrayPrototypeForEachCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayPrototypeForEachCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayPrototypeForEachCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayPrototypeForEachCodeInlineAttribute;
extern constinit const char* const s_arrayPrototypeFilterCode;
extern constinit const int s_arrayPrototypeFilterCodeLength;
extern constinit const JSC::ConstructAbility s_arrayPrototypeFilterCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayPrototypeFilterCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayPrototypeFilterCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayPrototypeFilterCodeInlineAttribute;
extern constinit const char* const s_arrayPrototypeMapCode;
extern constinit const int s_arrayPrototypeMapCodeLength;
extern constinit const JSC::ConstructAbility s_arrayPrototypeMapCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayPrototypeMapCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayPrototypeMapCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayPrototypeMapCodeInlineAttribute;
extern constinit const char* const s_arrayPrototypeSomeCode;
extern constinit const int s_arrayPrototypeSomeCodeLength;
extern constinit const JSC::ConstructAbility s_arrayPrototypeSomeCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayPrototypeSomeCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayPrototypeSomeCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayPrototypeSomeCodeInlineAttribute;
extern constinit const char* const s_arrayPrototypeFindCode;
extern constinit const int s_arrayPrototypeFindCodeLength;
extern constinit const JSC::ConstructAbility s_arrayPrototypeFindCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayPrototypeFindCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayPrototypeFindCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayPrototypeFindCodeInlineAttribute;
extern constinit const char* const s_arrayPrototypeFindLastCode;
extern constinit const int s_arrayPrototypeFindLastCodeLength;
extern constinit const JSC::ConstructAbility s_arrayPrototypeFindLastCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayPrototypeFindLastCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayPrototypeFindLastCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayPrototypeFindLastCodeInlineAttribute;
extern constinit const char* const s_arrayPrototypeFindIndexCode;
extern constinit const int s_arrayPrototypeFindIndexCodeLength;
extern constinit const JSC::ConstructAbility s_arrayPrototypeFindIndexCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayPrototypeFindIndexCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayPrototypeFindIndexCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayPrototypeFindIndexCodeInlineAttribute;
extern constinit const char* const s_arrayPrototypeFindLastIndexCode;
extern constinit const int s_arrayPrototypeFindLastIndexCodeLength;
extern constinit const JSC::ConstructAbility s_arrayPrototypeFindLastIndexCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayPrototypeFindLastIndexCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayPrototypeFindLastIndexCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayPrototypeFindLastIndexCodeInlineAttribute;
extern constinit const char* const s_arrayPrototypeFlatIntoArrayCode;
extern constinit const int s_arrayPrototypeFlatIntoArrayCodeLength;
extern constinit const JSC::ConstructAbility s_arrayPrototypeFlatIntoArrayCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayPrototypeFlatIntoArrayCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayPrototypeFlatIntoArrayCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayPrototypeFlatIntoArrayCodeInlineAttribute;
extern constinit const char* const s_arrayPrototypeFlatCode;
extern constinit const int s_arrayPrototypeFlatCodeLength;
extern constinit const JSC::ConstructAbility s_arrayPrototypeFlatCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayPrototypeFlatCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayPrototypeFlatCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayPrototypeFlatCodeInlineAttribute;
extern constinit const char* const s_arrayPrototypeFlatIntoArrayWithCallbackCode;
extern constinit const int s_arrayPrototypeFlatIntoArrayWithCallbackCodeLength;
extern constinit const JSC::ConstructAbility s_arrayPrototypeFlatIntoArrayWithCallbackCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayPrototypeFlatIntoArrayWithCallbackCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayPrototypeFlatIntoArrayWithCallbackCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayPrototypeFlatIntoArrayWithCallbackCodeInlineAttribute;
extern constinit const char* const s_arrayPrototypeFlatMapCode;
extern constinit const int s_arrayPrototypeFlatMapCodeLength;
extern constinit const JSC::ConstructAbility s_arrayPrototypeFlatMapCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayPrototypeFlatMapCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayPrototypeFlatMapCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayPrototypeFlatMapCodeInlineAttribute;
extern constinit const char* const s_arrayPrototypeAtCode;
extern constinit const int s_arrayPrototypeAtCodeLength;
extern constinit const JSC::ConstructAbility s_arrayPrototypeAtCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_arrayPrototypeAtCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_arrayPrototypeAtCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_arrayPrototypeAtCodeInlineAttribute;

#define JSC_FOREACH_ARRAYPROTOTYPE_BUILTIN_DATA(macro) \
    macro(reduce, arrayPrototypeReduce, 1) \
    macro(reduceRight, arrayPrototypeReduceRight, 1) \
    macro(every, arrayPrototypeEvery, 1) \
    macro(forEach, arrayPrototypeForEach, 1) \
    macro(filter, arrayPrototypeFilter, 1) \
    macro(map, arrayPrototypeMap, 1) \
    macro(some, arrayPrototypeSome, 1) \
    macro(find, arrayPrototypeFind, 1) \
    macro(findLast, arrayPrototypeFindLast, 1) \
    macro(findIndex, arrayPrototypeFindIndex, 1) \
    macro(findLastIndex, arrayPrototypeFindLastIndex, 1) \
    macro(flatIntoArray, arrayPrototypeFlatIntoArray, 5) \
    macro(flat, arrayPrototypeFlat, 0) \
    macro(flatIntoArrayWithCallback, arrayPrototypeFlatIntoArrayWithCallback, 6) \
    macro(flatMap, arrayPrototypeFlatMap, 1) \
    macro(at, arrayPrototypeAt, 1) \

/* AsyncFromSyncIteratorPrototype */
extern constinit const char* const s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCode;
extern constinit const int s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCodeLength;
extern constinit const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCodeInlineAttribute;
extern constinit const char* const s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCode;
extern constinit const int s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCodeLength;
extern constinit const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCodeInlineAttribute;
extern constinit const char* const s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCode;
extern constinit const int s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCodeLength;
extern constinit const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCodeInlineAttribute;
extern constinit const char* const s_asyncFromSyncIteratorPrototypeNextCode;
extern constinit const int s_asyncFromSyncIteratorPrototypeNextCodeLength;
extern constinit const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeNextCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeNextCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeNextCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncFromSyncIteratorPrototypeNextCodeInlineAttribute;
extern constinit const char* const s_asyncFromSyncIteratorPrototypeReturnCode;
extern constinit const int s_asyncFromSyncIteratorPrototypeReturnCodeLength;
extern constinit const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeReturnCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeReturnCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeReturnCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncFromSyncIteratorPrototypeReturnCodeInlineAttribute;
extern constinit const char* const s_asyncFromSyncIteratorPrototypeThrowCode;
extern constinit const int s_asyncFromSyncIteratorPrototypeThrowCodeLength;
extern constinit const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeThrowCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeThrowCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeThrowCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncFromSyncIteratorPrototypeThrowCodeInlineAttribute;
extern constinit const char* const s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCode;
extern constinit const int s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCodeLength;
extern constinit const JSC::ConstructAbility s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCodeInlineAttribute;

#define JSC_FOREACH_ASYNCFROMSYNCITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(asyncFromSyncIteratorOnRejected, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejected, 2) \
    macro(asyncFromSyncIteratorOnFulfilledContinue, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinue, 2) \
    macro(asyncFromSyncIteratorOnFulfilledDone, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDone, 2) \
    macro(next, asyncFromSyncIteratorPrototypeNext, 1) \
    macro(return, asyncFromSyncIteratorPrototypeReturn, 1) \
    macro(throw, asyncFromSyncIteratorPrototypeThrow, 1) \
    macro(createAsyncFromSyncIterator, asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIterator, 2) \

/* AsyncFunctionPrototype */
extern constinit const char* const s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCode;
extern constinit const int s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCodeLength;
extern constinit const JSC::ConstructAbility s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCodeInlineAttribute;
extern constinit const char* const s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCode;
extern constinit const int s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCodeLength;
extern constinit const JSC::ConstructAbility s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCodeInlineAttribute;
extern constinit const char* const s_asyncFunctionPrototypeAsyncFunctionResumeCode;
extern constinit const int s_asyncFunctionPrototypeAsyncFunctionResumeCodeLength;
extern constinit const JSC::ConstructAbility s_asyncFunctionPrototypeAsyncFunctionResumeCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncFunctionPrototypeAsyncFunctionResumeCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncFunctionPrototypeAsyncFunctionResumeCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncFunctionPrototypeAsyncFunctionResumeCodeInlineAttribute;

#define JSC_FOREACH_ASYNCFUNCTIONPROTOTYPE_BUILTIN_DATA(macro) \
    macro(asyncFunctionResumeOnFulfilled, asyncFunctionPrototypeAsyncFunctionResumeOnFulfilled, 2) \
    macro(asyncFunctionResumeOnRejected, asyncFunctionPrototypeAsyncFunctionResumeOnRejected, 2) \
    macro(asyncFunctionResume, asyncFunctionPrototypeAsyncFunctionResume, 3) \

/* AsyncGeneratorPrototype */
extern constinit const char* const s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCode;
extern constinit const int s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCode;
extern constinit const int s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCode;
extern constinit const int s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeIsExecutionStateCode;
extern constinit const int s_asyncGeneratorPrototypeIsExecutionStateCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeIsExecutionStateCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeIsExecutionStateCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeIsExecutionStateCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeIsExecutionStateCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeIsSuspendYieldStateCode;
extern constinit const int s_asyncGeneratorPrototypeIsSuspendYieldStateCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeIsSuspendYieldStateCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeIsSuspendYieldStateCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeIsSuspendYieldStateCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeIsSuspendYieldStateCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeAsyncGeneratorRejectCode;
extern constinit const int s_asyncGeneratorPrototypeAsyncGeneratorRejectCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorRejectCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorRejectCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorRejectCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorRejectCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeAsyncGeneratorResolveCode;
extern constinit const int s_asyncGeneratorPrototypeAsyncGeneratorResolveCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorResolveCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorResolveCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorResolveCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorResolveCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCode;
extern constinit const int s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCode;
extern constinit const int s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeAsyncGeneratorYieldCode;
extern constinit const int s_asyncGeneratorPrototypeAsyncGeneratorYieldCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorYieldCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorYieldCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorYieldCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorYieldCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeAwaitValueCode;
extern constinit const int s_asyncGeneratorPrototypeAwaitValueCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeAwaitValueCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeAwaitValueCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAwaitValueCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeAwaitValueCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCode;
extern constinit const int s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCode;
extern constinit const int s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCode;
extern constinit const int s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCode;
extern constinit const int s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCode;
extern constinit const int s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCode;
extern constinit const int s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCode;
extern constinit const int s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeNextCode;
extern constinit const int s_asyncGeneratorPrototypeNextCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeNextCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeNextCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeNextCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeNextCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeReturnCode;
extern constinit const int s_asyncGeneratorPrototypeReturnCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeReturnCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeReturnCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeReturnCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeReturnCodeInlineAttribute;
extern constinit const char* const s_asyncGeneratorPrototypeThrowCode;
extern constinit const int s_asyncGeneratorPrototypeThrowCodeLength;
extern constinit const JSC::ConstructAbility s_asyncGeneratorPrototypeThrowCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncGeneratorPrototypeThrowCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncGeneratorPrototypeThrowCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncGeneratorPrototypeThrowCodeInlineAttribute;

#define JSC_FOREACH_ASYNCGENERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(asyncGeneratorQueueIsEmpty, asyncGeneratorPrototypeAsyncGeneratorQueueIsEmpty, 1) \
    macro(asyncGeneratorQueueEnqueue, asyncGeneratorPrototypeAsyncGeneratorQueueEnqueue, 2) \
    macro(asyncGeneratorQueueDequeue, asyncGeneratorPrototypeAsyncGeneratorQueueDequeue, 1) \
    macro(isExecutionState, asyncGeneratorPrototypeIsExecutionState, 1) \
    macro(isSuspendYieldState, asyncGeneratorPrototypeIsSuspendYieldState, 1) \
    macro(asyncGeneratorReject, asyncGeneratorPrototypeAsyncGeneratorReject, 2) \
    macro(asyncGeneratorResolve, asyncGeneratorPrototypeAsyncGeneratorResolve, 3) \
    macro(asyncGeneratorYieldAwaited, asyncGeneratorPrototypeAsyncGeneratorYieldAwaited, 2) \
    macro(asyncGeneratorYieldOnRejected, asyncGeneratorPrototypeAsyncGeneratorYieldOnRejected, 2) \
    macro(asyncGeneratorYield, asyncGeneratorPrototypeAsyncGeneratorYield, 3) \
    macro(awaitValue, asyncGeneratorPrototypeAwaitValue, 3) \
    macro(doAsyncGeneratorBodyCallOnFulfilledNormal, asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormal, 2) \
    macro(doAsyncGeneratorBodyCallOnFulfilledReturn, asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturn, 2) \
    macro(doAsyncGeneratorBodyCall, asyncGeneratorPrototypeDoAsyncGeneratorBodyCall, 3) \
    macro(asyncGeneratorResumeNextOnFulfilled, asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilled, 2) \
    macro(asyncGeneratorResumeNextOnRejected, asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejected, 2) \
    macro(asyncGeneratorResumeNext, asyncGeneratorPrototypeAsyncGeneratorResumeNext, 1) \
    macro(asyncGeneratorEnqueue, asyncGeneratorPrototypeAsyncGeneratorEnqueue, 3) \
    macro(next, asyncGeneratorPrototypeNext, 1) \
    macro(return, asyncGeneratorPrototypeReturn, 1) \
    macro(throw, asyncGeneratorPrototypeThrow, 1) \

/* AsyncIteratorPrototype */
extern constinit const char* const s_asyncIteratorPrototypeAsyncDisposeCode;
extern constinit const int s_asyncIteratorPrototypeAsyncDisposeCodeLength;
extern constinit const JSC::ConstructAbility s_asyncIteratorPrototypeAsyncDisposeCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_asyncIteratorPrototypeAsyncDisposeCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_asyncIteratorPrototypeAsyncDisposeCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_asyncIteratorPrototypeAsyncDisposeCodeInlineAttribute;

#define JSC_FOREACH_ASYNCITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(asyncDispose, asyncIteratorPrototypeAsyncDispose, 0) \

/* DisposableStackPrototype */
extern constinit const char* const s_disposableStackPrototypeCreateSyncDisposableResourceCode;
extern constinit const int s_disposableStackPrototypeCreateSyncDisposableResourceCodeLength;
extern constinit const JSC::ConstructAbility s_disposableStackPrototypeCreateSyncDisposableResourceCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_disposableStackPrototypeCreateSyncDisposableResourceCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_disposableStackPrototypeCreateSyncDisposableResourceCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_disposableStackPrototypeCreateSyncDisposableResourceCodeInlineAttribute;
extern constinit const char* const s_disposableStackPrototypeAddSyncDisposableResourceCode;
extern constinit const int s_disposableStackPrototypeAddSyncDisposableResourceCodeLength;
extern constinit const JSC::ConstructAbility s_disposableStackPrototypeAddSyncDisposableResourceCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_disposableStackPrototypeAddSyncDisposableResourceCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_disposableStackPrototypeAddSyncDisposableResourceCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_disposableStackPrototypeAddSyncDisposableResourceCodeInlineAttribute;
extern constinit const char* const s_disposableStackPrototypeAdoptCode;
extern constinit const int s_disposableStackPrototypeAdoptCodeLength;
extern constinit const JSC::ConstructAbility s_disposableStackPrototypeAdoptCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_disposableStackPrototypeAdoptCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_disposableStackPrototypeAdoptCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_disposableStackPrototypeAdoptCodeInlineAttribute;
extern constinit const char* const s_disposableStackPrototypeDeferMethodCode;
extern constinit const int s_disposableStackPrototypeDeferMethodCodeLength;
extern constinit const JSC::ConstructAbility s_disposableStackPrototypeDeferMethodCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_disposableStackPrototypeDeferMethodCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_disposableStackPrototypeDeferMethodCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_disposableStackPrototypeDeferMethodCodeInlineAttribute;
extern constinit const char* const s_disposableStackPrototypeDisposeCode;
extern constinit const int s_disposableStackPrototypeDisposeCodeLength;
extern constinit const JSC::ConstructAbility s_disposableStackPrototypeDisposeCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_disposableStackPrototypeDisposeCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_disposableStackPrototypeDisposeCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_disposableStackPrototypeDisposeCodeInlineAttribute;
extern constinit const char* const s_disposableStackPrototypeMoveCode;
extern constinit const int s_disposableStackPrototypeMoveCodeLength;
extern constinit const JSC::ConstructAbility s_disposableStackPrototypeMoveCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_disposableStackPrototypeMoveCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_disposableStackPrototypeMoveCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_disposableStackPrototypeMoveCodeInlineAttribute;
extern constinit const char* const s_disposableStackPrototypeUseCode;
extern constinit const int s_disposableStackPrototypeUseCodeLength;
extern constinit const JSC::ConstructAbility s_disposableStackPrototypeUseCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_disposableStackPrototypeUseCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_disposableStackPrototypeUseCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_disposableStackPrototypeUseCodeInlineAttribute;

#define JSC_FOREACH_DISPOSABLESTACKPROTOTYPE_BUILTIN_DATA(macro) \
    macro(createSyncDisposableResource, disposableStackPrototypeCreateSyncDisposableResource, 1) \
    macro(addSyncDisposableResource, disposableStackPrototypeAddSyncDisposableResource, 2) \
    macro(adopt, disposableStackPrototypeAdopt, 2) \
    macro(deferMethod, disposableStackPrototypeDeferMethod, 1) \
    macro(dispose, disposableStackPrototypeDispose, 0) \
    macro(move, disposableStackPrototypeMove, 0) \
    macro(use, disposableStackPrototypeUse, 1) \

/* FunctionPrototype */
extern constinit const char* const s_functionPrototypeCallCode;
extern constinit const int s_functionPrototypeCallCodeLength;
extern constinit const JSC::ConstructAbility s_functionPrototypeCallCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_functionPrototypeCallCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_functionPrototypeCallCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_functionPrototypeCallCodeInlineAttribute;
extern constinit const char* const s_functionPrototypeApplyCode;
extern constinit const int s_functionPrototypeApplyCodeLength;
extern constinit const JSC::ConstructAbility s_functionPrototypeApplyCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_functionPrototypeApplyCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_functionPrototypeApplyCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_functionPrototypeApplyCodeInlineAttribute;
extern constinit const char* const s_functionPrototypeSymbolHasInstanceCode;
extern constinit const int s_functionPrototypeSymbolHasInstanceCodeLength;
extern constinit const JSC::ConstructAbility s_functionPrototypeSymbolHasInstanceCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_functionPrototypeSymbolHasInstanceCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_functionPrototypeSymbolHasInstanceCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_functionPrototypeSymbolHasInstanceCodeInlineAttribute;

#define JSC_FOREACH_FUNCTIONPROTOTYPE_BUILTIN_DATA(macro) \
    macro(call, functionPrototypeCall, 1) \
    macro(apply, functionPrototypeApply, 2) \
    macro(symbolHasInstance, functionPrototypeSymbolHasInstance, 1) \

/* GeneratorPrototype */
extern constinit const char* const s_generatorPrototypeGeneratorResumeCode;
extern constinit const int s_generatorPrototypeGeneratorResumeCodeLength;
extern constinit const JSC::ConstructAbility s_generatorPrototypeGeneratorResumeCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_generatorPrototypeGeneratorResumeCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_generatorPrototypeGeneratorResumeCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_generatorPrototypeGeneratorResumeCodeInlineAttribute;
extern constinit const char* const s_generatorPrototypeNextCode;
extern constinit const int s_generatorPrototypeNextCodeLength;
extern constinit const JSC::ConstructAbility s_generatorPrototypeNextCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_generatorPrototypeNextCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_generatorPrototypeNextCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_generatorPrototypeNextCodeInlineAttribute;
extern constinit const char* const s_generatorPrototypeReturnCode;
extern constinit const int s_generatorPrototypeReturnCodeLength;
extern constinit const JSC::ConstructAbility s_generatorPrototypeReturnCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_generatorPrototypeReturnCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_generatorPrototypeReturnCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_generatorPrototypeReturnCodeInlineAttribute;
extern constinit const char* const s_generatorPrototypeThrowCode;
extern constinit const int s_generatorPrototypeThrowCodeLength;
extern constinit const JSC::ConstructAbility s_generatorPrototypeThrowCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_generatorPrototypeThrowCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_generatorPrototypeThrowCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_generatorPrototypeThrowCodeInlineAttribute;

#define JSC_FOREACH_GENERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(generatorResume, generatorPrototypeGeneratorResume, 4) \
    macro(next, generatorPrototypeNext, 1) \
    macro(return, generatorPrototypeReturn, 1) \
    macro(throw, generatorPrototypeThrow, 1) \

/* GlobalOperations */
extern constinit const char* const s_globalOperationsSpeciesConstructorCode;
extern constinit const int s_globalOperationsSpeciesConstructorCodeLength;
extern constinit const JSC::ConstructAbility s_globalOperationsSpeciesConstructorCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_globalOperationsSpeciesConstructorCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_globalOperationsSpeciesConstructorCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_globalOperationsSpeciesConstructorCodeInlineAttribute;

#define JSC_FOREACH_GLOBALOPERATIONS_BUILTIN_DATA(macro) \
    macro(speciesConstructor, globalOperationsSpeciesConstructor, 2) \

/* InternalPromiseConstructor */
extern constinit const char* const s_internalPromiseConstructorInternalAllCode;
extern constinit const int s_internalPromiseConstructorInternalAllCodeLength;
extern constinit const JSC::ConstructAbility s_internalPromiseConstructorInternalAllCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_internalPromiseConstructorInternalAllCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_internalPromiseConstructorInternalAllCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_internalPromiseConstructorInternalAllCodeInlineAttribute;

#define JSC_FOREACH_INTERNALPROMISECONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(internalAll, internalPromiseConstructorInternalAll, 1) \

/* IteratorHelpers */
extern constinit const char* const s_iteratorHelpersPerformIterationCode;
extern constinit const int s_iteratorHelpersPerformIterationCodeLength;
extern constinit const JSC::ConstructAbility s_iteratorHelpersPerformIterationCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_iteratorHelpersPerformIterationCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_iteratorHelpersPerformIterationCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_iteratorHelpersPerformIterationCodeInlineAttribute;
extern constinit const char* const s_iteratorHelpersWrappedIteratorCode;
extern constinit const int s_iteratorHelpersWrappedIteratorCodeLength;
extern constinit const JSC::ConstructAbility s_iteratorHelpersWrappedIteratorCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_iteratorHelpersWrappedIteratorCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_iteratorHelpersWrappedIteratorCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_iteratorHelpersWrappedIteratorCodeInlineAttribute;
extern constinit const char* const s_iteratorHelpersBuiltinSetIterableCode;
extern constinit const int s_iteratorHelpersBuiltinSetIterableCodeLength;
extern constinit const JSC::ConstructAbility s_iteratorHelpersBuiltinSetIterableCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_iteratorHelpersBuiltinSetIterableCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_iteratorHelpersBuiltinSetIterableCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_iteratorHelpersBuiltinSetIterableCodeInlineAttribute;
extern constinit const char* const s_iteratorHelpersBuiltinMapIterableCode;
extern constinit const int s_iteratorHelpersBuiltinMapIterableCodeLength;
extern constinit const JSC::ConstructAbility s_iteratorHelpersBuiltinMapIterableCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_iteratorHelpersBuiltinMapIterableCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_iteratorHelpersBuiltinMapIterableCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_iteratorHelpersBuiltinMapIterableCodeInlineAttribute;

#define JSC_FOREACH_ITERATORHELPERS_BUILTIN_DATA(macro) \
    macro(performIteration, iteratorHelpersPerformIteration, 1) \
    macro(wrappedIterator, iteratorHelpersWrappedIterator, 1) \
    macro(builtinSetIterable, iteratorHelpersBuiltinSetIterable, 1) \
    macro(builtinMapIterable, iteratorHelpersBuiltinMapIterable, 1) \

/* JSIteratorConstructor */
extern constinit const char* const s_jsIteratorConstructorGetIteratorFlattenableCode;
extern constinit const int s_jsIteratorConstructorGetIteratorFlattenableCodeLength;
extern constinit const JSC::ConstructAbility s_jsIteratorConstructorGetIteratorFlattenableCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_jsIteratorConstructorGetIteratorFlattenableCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_jsIteratorConstructorGetIteratorFlattenableCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_jsIteratorConstructorGetIteratorFlattenableCodeInlineAttribute;
extern constinit const char* const s_jsIteratorConstructorFromCode;
extern constinit const int s_jsIteratorConstructorFromCodeLength;
extern constinit const JSC::ConstructAbility s_jsIteratorConstructorFromCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_jsIteratorConstructorFromCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_jsIteratorConstructorFromCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_jsIteratorConstructorFromCodeInlineAttribute;
extern constinit const char* const s_jsIteratorConstructorConcatCode;
extern constinit const int s_jsIteratorConstructorConcatCodeLength;
extern constinit const JSC::ConstructAbility s_jsIteratorConstructorConcatCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_jsIteratorConstructorConcatCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_jsIteratorConstructorConcatCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_jsIteratorConstructorConcatCodeInlineAttribute;

#define JSC_FOREACH_JSITERATORCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(getIteratorFlattenable, jsIteratorConstructorGetIteratorFlattenable, 2) \
    macro(from, jsIteratorConstructorFrom, 1) \
    macro(concat, jsIteratorConstructorConcat, 0) \

/* JSIteratorHelperPrototype */
extern constinit const char* const s_jsIteratorHelperPrototypeNextCode;
extern constinit const int s_jsIteratorHelperPrototypeNextCodeLength;
extern constinit const JSC::ConstructAbility s_jsIteratorHelperPrototypeNextCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_jsIteratorHelperPrototypeNextCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_jsIteratorHelperPrototypeNextCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_jsIteratorHelperPrototypeNextCodeInlineAttribute;
extern constinit const char* const s_jsIteratorHelperPrototypeReturnCode;
extern constinit const int s_jsIteratorHelperPrototypeReturnCodeLength;
extern constinit const JSC::ConstructAbility s_jsIteratorHelperPrototypeReturnCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_jsIteratorHelperPrototypeReturnCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_jsIteratorHelperPrototypeReturnCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_jsIteratorHelperPrototypeReturnCodeInlineAttribute;

#define JSC_FOREACH_JSITERATORHELPERPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, jsIteratorHelperPrototypeNext, 0) \
    macro(return, jsIteratorHelperPrototypeReturn, 0) \

/* JSIteratorPrototype */
extern constinit const char* const s_jsIteratorPrototypeMapCode;
extern constinit const int s_jsIteratorPrototypeMapCodeLength;
extern constinit const JSC::ConstructAbility s_jsIteratorPrototypeMapCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_jsIteratorPrototypeMapCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_jsIteratorPrototypeMapCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_jsIteratorPrototypeMapCodeInlineAttribute;
extern constinit const char* const s_jsIteratorPrototypeFilterCode;
extern constinit const int s_jsIteratorPrototypeFilterCodeLength;
extern constinit const JSC::ConstructAbility s_jsIteratorPrototypeFilterCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_jsIteratorPrototypeFilterCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_jsIteratorPrototypeFilterCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_jsIteratorPrototypeFilterCodeInlineAttribute;
extern constinit const char* const s_jsIteratorPrototypeTakeCode;
extern constinit const int s_jsIteratorPrototypeTakeCodeLength;
extern constinit const JSC::ConstructAbility s_jsIteratorPrototypeTakeCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_jsIteratorPrototypeTakeCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_jsIteratorPrototypeTakeCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_jsIteratorPrototypeTakeCodeInlineAttribute;
extern constinit const char* const s_jsIteratorPrototypeDropCode;
extern constinit const int s_jsIteratorPrototypeDropCodeLength;
extern constinit const JSC::ConstructAbility s_jsIteratorPrototypeDropCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_jsIteratorPrototypeDropCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_jsIteratorPrototypeDropCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_jsIteratorPrototypeDropCodeInlineAttribute;
extern constinit const char* const s_jsIteratorPrototypeFlatMapCode;
extern constinit const int s_jsIteratorPrototypeFlatMapCodeLength;
extern constinit const JSC::ConstructAbility s_jsIteratorPrototypeFlatMapCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_jsIteratorPrototypeFlatMapCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_jsIteratorPrototypeFlatMapCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_jsIteratorPrototypeFlatMapCodeInlineAttribute;
extern constinit const char* const s_jsIteratorPrototypeSomeCode;
extern constinit const int s_jsIteratorPrototypeSomeCodeLength;
extern constinit const JSC::ConstructAbility s_jsIteratorPrototypeSomeCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_jsIteratorPrototypeSomeCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_jsIteratorPrototypeSomeCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_jsIteratorPrototypeSomeCodeInlineAttribute;
extern constinit const char* const s_jsIteratorPrototypeEveryCode;
extern constinit const int s_jsIteratorPrototypeEveryCodeLength;
extern constinit const JSC::ConstructAbility s_jsIteratorPrototypeEveryCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_jsIteratorPrototypeEveryCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_jsIteratorPrototypeEveryCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_jsIteratorPrototypeEveryCodeInlineAttribute;
extern constinit const char* const s_jsIteratorPrototypeFindCode;
extern constinit const int s_jsIteratorPrototypeFindCodeLength;
extern constinit const JSC::ConstructAbility s_jsIteratorPrototypeFindCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_jsIteratorPrototypeFindCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_jsIteratorPrototypeFindCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_jsIteratorPrototypeFindCodeInlineAttribute;
extern constinit const char* const s_jsIteratorPrototypeReduceCode;
extern constinit const int s_jsIteratorPrototypeReduceCodeLength;
extern constinit const JSC::ConstructAbility s_jsIteratorPrototypeReduceCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_jsIteratorPrototypeReduceCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_jsIteratorPrototypeReduceCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_jsIteratorPrototypeReduceCodeInlineAttribute;
extern constinit const char* const s_jsIteratorPrototypeChunksCode;
extern constinit const int s_jsIteratorPrototypeChunksCodeLength;
extern constinit const JSC::ConstructAbility s_jsIteratorPrototypeChunksCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_jsIteratorPrototypeChunksCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_jsIteratorPrototypeChunksCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_jsIteratorPrototypeChunksCodeInlineAttribute;
extern constinit const char* const s_jsIteratorPrototypeWindowsCode;
extern constinit const int s_jsIteratorPrototypeWindowsCodeLength;
extern constinit const JSC::ConstructAbility s_jsIteratorPrototypeWindowsCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_jsIteratorPrototypeWindowsCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_jsIteratorPrototypeWindowsCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_jsIteratorPrototypeWindowsCodeInlineAttribute;
extern constinit const char* const s_jsIteratorPrototypeDisposeCode;
extern constinit const int s_jsIteratorPrototypeDisposeCodeLength;
extern constinit const JSC::ConstructAbility s_jsIteratorPrototypeDisposeCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_jsIteratorPrototypeDisposeCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_jsIteratorPrototypeDisposeCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_jsIteratorPrototypeDisposeCodeInlineAttribute;

#define JSC_FOREACH_JSITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(map, jsIteratorPrototypeMap, 1) \
    macro(filter, jsIteratorPrototypeFilter, 1) \
    macro(take, jsIteratorPrototypeTake, 1) \
    macro(drop, jsIteratorPrototypeDrop, 1) \
    macro(flatMap, jsIteratorPrototypeFlatMap, 1) \
    macro(some, jsIteratorPrototypeSome, 1) \
    macro(every, jsIteratorPrototypeEvery, 1) \
    macro(find, jsIteratorPrototypeFind, 1) \
    macro(reduce, jsIteratorPrototypeReduce, 1) \
    macro(chunks, jsIteratorPrototypeChunks, 1) \
    macro(windows, jsIteratorPrototypeWindows, 1) \
    macro(dispose, jsIteratorPrototypeDispose, 0) \

/* MapConstructor */
extern constinit const char* const s_mapConstructorGroupByCode;
extern constinit const int s_mapConstructorGroupByCodeLength;
extern constinit const JSC::ConstructAbility s_mapConstructorGroupByCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_mapConstructorGroupByCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_mapConstructorGroupByCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_mapConstructorGroupByCodeInlineAttribute;

#define JSC_FOREACH_MAPCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(groupBy, mapConstructorGroupBy, 2) \

/* MapIteratorPrototype */
extern constinit const char* const s_mapIteratorPrototypeNextCode;
extern constinit const int s_mapIteratorPrototypeNextCodeLength;
extern constinit const JSC::ConstructAbility s_mapIteratorPrototypeNextCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_mapIteratorPrototypeNextCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_mapIteratorPrototypeNextCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_mapIteratorPrototypeNextCodeInlineAttribute;

#define JSC_FOREACH_MAPITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, mapIteratorPrototypeNext, 0) \

/* MapPrototype */
extern constinit const char* const s_mapPrototypeForEachCode;
extern constinit const int s_mapPrototypeForEachCodeLength;
extern constinit const JSC::ConstructAbility s_mapPrototypeForEachCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_mapPrototypeForEachCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_mapPrototypeForEachCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_mapPrototypeForEachCodeInlineAttribute;

#define JSC_FOREACH_MAPPROTOTYPE_BUILTIN_DATA(macro) \
    macro(forEach, mapPrototypeForEach, 1) \

/* ModuleLoader */
extern constinit const char* const s_moduleLoaderSetStateToMaxCode;
extern constinit const int s_moduleLoaderSetStateToMaxCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderSetStateToMaxCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderSetStateToMaxCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderSetStateToMaxCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderSetStateToMaxCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderNewRegistryEntryCode;
extern constinit const int s_moduleLoaderNewRegistryEntryCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderNewRegistryEntryCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderNewRegistryEntryCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderNewRegistryEntryCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderNewRegistryEntryCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderEnsureRegisteredCode;
extern constinit const int s_moduleLoaderEnsureRegisteredCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderEnsureRegisteredCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderEnsureRegisteredCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderEnsureRegisteredCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderEnsureRegisteredCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderForceFulfillPromiseCode;
extern constinit const int s_moduleLoaderForceFulfillPromiseCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderForceFulfillPromiseCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderForceFulfillPromiseCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderForceFulfillPromiseCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderForceFulfillPromiseCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderFulfillFetchCode;
extern constinit const int s_moduleLoaderFulfillFetchCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderFulfillFetchCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderFulfillFetchCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderFulfillFetchCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderFulfillFetchCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderRequestFetchCode;
extern constinit const int s_moduleLoaderRequestFetchCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderRequestFetchCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderRequestFetchCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderRequestFetchCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderRequestFetchCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderRequestInstantiateCode;
extern constinit const int s_moduleLoaderRequestInstantiateCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderRequestInstantiateCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderRequestInstantiateCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderRequestInstantiateCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderRequestInstantiateCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderCacheSatisfyCode;
extern constinit const int s_moduleLoaderCacheSatisfyCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderCacheSatisfyCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderCacheSatisfyCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderCacheSatisfyCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderCacheSatisfyCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderCacheSatisfyAndReturnCode;
extern constinit const int s_moduleLoaderCacheSatisfyAndReturnCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderCacheSatisfyAndReturnCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderCacheSatisfyAndReturnCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderCacheSatisfyAndReturnCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderCacheSatisfyAndReturnCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderRequestSatisfyCode;
extern constinit const int s_moduleLoaderRequestSatisfyCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderRequestSatisfyCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderRequestSatisfyCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderRequestSatisfyCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderRequestSatisfyCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderRequestSatisfyUtilCode;
extern constinit const int s_moduleLoaderRequestSatisfyUtilCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderRequestSatisfyUtilCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderRequestSatisfyUtilCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderRequestSatisfyUtilCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderRequestSatisfyUtilCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderLinkCode;
extern constinit const int s_moduleLoaderLinkCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderLinkCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderLinkCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderLinkCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderLinkCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderModuleEvaluationCode;
extern constinit const int s_moduleLoaderModuleEvaluationCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderModuleEvaluationCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderModuleEvaluationCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderModuleEvaluationCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderModuleEvaluationCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderAsyncModuleEvaluationCode;
extern constinit const int s_moduleLoaderAsyncModuleEvaluationCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderAsyncModuleEvaluationCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderAsyncModuleEvaluationCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderAsyncModuleEvaluationCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderAsyncModuleEvaluationCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderProvideFetchCode;
extern constinit const int s_moduleLoaderProvideFetchCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderProvideFetchCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderProvideFetchCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderProvideFetchCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderProvideFetchCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderLoadModuleCode;
extern constinit const int s_moduleLoaderLoadModuleCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderLoadModuleCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderLoadModuleCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderLoadModuleCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderLoadModuleCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderLinkAndEvaluateModuleCode;
extern constinit const int s_moduleLoaderLinkAndEvaluateModuleCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderLinkAndEvaluateModuleCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderLinkAndEvaluateModuleCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderLinkAndEvaluateModuleCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderLinkAndEvaluateModuleCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderLoadAndEvaluateModuleCode;
extern constinit const int s_moduleLoaderLoadAndEvaluateModuleCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderLoadAndEvaluateModuleCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderLoadAndEvaluateModuleCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderLoadAndEvaluateModuleCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderLoadAndEvaluateModuleCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderRequestImportModuleCode;
extern constinit const int s_moduleLoaderRequestImportModuleCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderRequestImportModuleCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderRequestImportModuleCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderRequestImportModuleCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderRequestImportModuleCodeInlineAttribute;
extern constinit const char* const s_moduleLoaderDependencyKeysIfEvaluatedCode;
extern constinit const int s_moduleLoaderDependencyKeysIfEvaluatedCodeLength;
extern constinit const JSC::ConstructAbility s_moduleLoaderDependencyKeysIfEvaluatedCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_moduleLoaderDependencyKeysIfEvaluatedCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_moduleLoaderDependencyKeysIfEvaluatedCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_moduleLoaderDependencyKeysIfEvaluatedCodeInlineAttribute;

#define JSC_FOREACH_MODULELOADER_BUILTIN_DATA(macro) \
    macro(setStateToMax, moduleLoaderSetStateToMax, 2) \
    macro(newRegistryEntry, moduleLoaderNewRegistryEntry, 1) \
    macro(ensureRegistered, moduleLoaderEnsureRegistered, 1) \
    macro(forceFulfillPromise, moduleLoaderForceFulfillPromise, 2) \
    macro(fulfillFetch, moduleLoaderFulfillFetch, 2) \
    macro(requestFetch, moduleLoaderRequestFetch, 3) \
    macro(requestInstantiate, moduleLoaderRequestInstantiate, 3) \
    macro(cacheSatisfy, moduleLoaderCacheSatisfy, 1) \
    macro(cacheSatisfyAndReturn, moduleLoaderCacheSatisfyAndReturn, 3) \
    macro(requestSatisfy, moduleLoaderRequestSatisfy, 4) \
    macro(requestSatisfyUtil, moduleLoaderRequestSatisfyUtil, 5) \
    macro(link, moduleLoaderLink, 2) \
    macro(moduleEvaluation, moduleLoaderModuleEvaluation, 2) \
    macro(asyncModuleEvaluation, moduleLoaderAsyncModuleEvaluation, 3) \
    macro(provideFetch, moduleLoaderProvideFetch, 2) \
    macro(loadModule, moduleLoaderLoadModule, 3) \
    macro(linkAndEvaluateModule, moduleLoaderLinkAndEvaluateModule, 2) \
    macro(loadAndEvaluateModule, moduleLoaderLoadAndEvaluateModule, 3) \
    macro(requestImportModule, moduleLoaderRequestImportModule, 4) \
    macro(dependencyKeysIfEvaluated, moduleLoaderDependencyKeysIfEvaluated, 1) \

/* ObjectConstructor */
extern constinit const char* const s_objectConstructorFromEntriesCode;
extern constinit const int s_objectConstructorFromEntriesCodeLength;
extern constinit const JSC::ConstructAbility s_objectConstructorFromEntriesCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_objectConstructorFromEntriesCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_objectConstructorFromEntriesCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_objectConstructorFromEntriesCodeInlineAttribute;
extern constinit const char* const s_objectConstructorGroupByCode;
extern constinit const int s_objectConstructorGroupByCodeLength;
extern constinit const JSC::ConstructAbility s_objectConstructorGroupByCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_objectConstructorGroupByCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_objectConstructorGroupByCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_objectConstructorGroupByCodeInlineAttribute;

#define JSC_FOREACH_OBJECTCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(fromEntries, objectConstructorFromEntries, 1) \
    macro(groupBy, objectConstructorGroupBy, 2) \

/* PromiseConstructor */
extern constinit const char* const s_promiseConstructorPromiseAllSlowCode;
extern constinit const int s_promiseConstructorPromiseAllSlowCodeLength;
extern constinit const JSC::ConstructAbility s_promiseConstructorPromiseAllSlowCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseConstructorPromiseAllSlowCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseConstructorPromiseAllSlowCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseConstructorPromiseAllSlowCodeInlineAttribute;
extern constinit const char* const s_promiseConstructorPromiseOnRejectedWithContextCode;
extern constinit const int s_promiseConstructorPromiseOnRejectedWithContextCodeLength;
extern constinit const JSC::ConstructAbility s_promiseConstructorPromiseOnRejectedWithContextCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseConstructorPromiseOnRejectedWithContextCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseConstructorPromiseOnRejectedWithContextCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseConstructorPromiseOnRejectedWithContextCodeInlineAttribute;
extern constinit const char* const s_promiseConstructorPromiseAllOnFulfilledCode;
extern constinit const int s_promiseConstructorPromiseAllOnFulfilledCodeLength;
extern constinit const JSC::ConstructAbility s_promiseConstructorPromiseAllOnFulfilledCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseConstructorPromiseAllOnFulfilledCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseConstructorPromiseAllOnFulfilledCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseConstructorPromiseAllOnFulfilledCodeInlineAttribute;
extern constinit const char* const s_promiseConstructorPromiseNewOnRejectedCode;
extern constinit const int s_promiseConstructorPromiseNewOnRejectedCodeLength;
extern constinit const JSC::ConstructAbility s_promiseConstructorPromiseNewOnRejectedCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseConstructorPromiseNewOnRejectedCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseConstructorPromiseNewOnRejectedCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseConstructorPromiseNewOnRejectedCodeInlineAttribute;
extern constinit const char* const s_promiseConstructorPromiseAllNewResolveElementCode;
extern constinit const int s_promiseConstructorPromiseAllNewResolveElementCodeLength;
extern constinit const JSC::ConstructAbility s_promiseConstructorPromiseAllNewResolveElementCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseConstructorPromiseAllNewResolveElementCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseConstructorPromiseAllNewResolveElementCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseConstructorPromiseAllNewResolveElementCodeInlineAttribute;
extern constinit const char* const s_promiseConstructorAllCode;
extern constinit const int s_promiseConstructorAllCodeLength;
extern constinit const JSC::ConstructAbility s_promiseConstructorAllCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseConstructorAllCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseConstructorAllCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseConstructorAllCodeInlineAttribute;
extern constinit const char* const s_promiseConstructorAllSettledCode;
extern constinit const int s_promiseConstructorAllSettledCodeLength;
extern constinit const JSC::ConstructAbility s_promiseConstructorAllSettledCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseConstructorAllSettledCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseConstructorAllSettledCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseConstructorAllSettledCodeInlineAttribute;
extern constinit const char* const s_promiseConstructorAnyCode;
extern constinit const int s_promiseConstructorAnyCodeLength;
extern constinit const JSC::ConstructAbility s_promiseConstructorAnyCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseConstructorAnyCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseConstructorAnyCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseConstructorAnyCodeInlineAttribute;
extern constinit const char* const s_promiseConstructorRaceCode;
extern constinit const int s_promiseConstructorRaceCodeLength;
extern constinit const JSC::ConstructAbility s_promiseConstructorRaceCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseConstructorRaceCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseConstructorRaceCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseConstructorRaceCodeInlineAttribute;
extern constinit const char* const s_promiseConstructorRejectCode;
extern constinit const int s_promiseConstructorRejectCodeLength;
extern constinit const JSC::ConstructAbility s_promiseConstructorRejectCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseConstructorRejectCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseConstructorRejectCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseConstructorRejectCodeInlineAttribute;
extern constinit const char* const s_promiseConstructorResolveCode;
extern constinit const int s_promiseConstructorResolveCodeLength;
extern constinit const JSC::ConstructAbility s_promiseConstructorResolveCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseConstructorResolveCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseConstructorResolveCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseConstructorResolveCodeInlineAttribute;
extern constinit const char* const s_promiseConstructorTryCode;
extern constinit const int s_promiseConstructorTryCodeLength;
extern constinit const JSC::ConstructAbility s_promiseConstructorTryCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseConstructorTryCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseConstructorTryCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseConstructorTryCodeInlineAttribute;
extern constinit const char* const s_promiseConstructorWithResolversCode;
extern constinit const int s_promiseConstructorWithResolversCodeLength;
extern constinit const JSC::ConstructAbility s_promiseConstructorWithResolversCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseConstructorWithResolversCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseConstructorWithResolversCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseConstructorWithResolversCodeInlineAttribute;
extern constinit const char* const s_promiseConstructorPromiseConstructorCode;
extern constinit const int s_promiseConstructorPromiseConstructorCodeLength;
extern constinit const JSC::ConstructAbility s_promiseConstructorPromiseConstructorCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseConstructorPromiseConstructorCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseConstructorPromiseConstructorCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseConstructorPromiseConstructorCodeInlineAttribute;
extern constinit const char* const s_promiseConstructorInternalPromiseConstructorCode;
extern constinit const int s_promiseConstructorInternalPromiseConstructorCodeLength;
extern constinit const JSC::ConstructAbility s_promiseConstructorInternalPromiseConstructorCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseConstructorInternalPromiseConstructorCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseConstructorInternalPromiseConstructorCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseConstructorInternalPromiseConstructorCodeInlineAttribute;

#define JSC_FOREACH_PROMISECONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(promiseAllSlow, promiseConstructorPromiseAllSlow, 1) \
    macro(promiseOnRejectedWithContext, promiseConstructorPromiseOnRejectedWithContext, 2) \
    macro(promiseAllOnFulfilled, promiseConstructorPromiseAllOnFulfilled, 2) \
    macro(promiseNewOnRejected, promiseConstructorPromiseNewOnRejected, 1) \
    macro(promiseAllNewResolveElement, promiseConstructorPromiseAllNewResolveElement, 2) \
    macro(all, promiseConstructorAll, 1) \
    macro(allSettled, promiseConstructorAllSettled, 1) \
    macro(any, promiseConstructorAny, 1) \
    macro(race, promiseConstructorRace, 1) \
    macro(reject, promiseConstructorReject, 1) \
    macro(resolve, promiseConstructorResolve, 1) \
    macro(try, promiseConstructorTry, 1) \
    macro(withResolvers, promiseConstructorWithResolvers, 0) \
    macro(Promise, promiseConstructorPromiseConstructor, 1) \
    macro(InternalPromise, promiseConstructorInternalPromiseConstructor, 1) \

/* PromiseOperations */
extern constinit const char* const s_promiseOperationsPushNewPromiseReactionCode;
extern constinit const int s_promiseOperationsPushNewPromiseReactionCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsPushNewPromiseReactionCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsPushNewPromiseReactionCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsPushNewPromiseReactionCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsPushNewPromiseReactionCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsNewPromiseCapabilitySlowCode;
extern constinit const int s_promiseOperationsNewPromiseCapabilitySlowCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsNewPromiseCapabilitySlowCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsNewPromiseCapabilitySlowCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsNewPromiseCapabilitySlowCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsNewPromiseCapabilitySlowCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsNewPromiseCapabilityCode;
extern constinit const int s_promiseOperationsNewPromiseCapabilityCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsNewPromiseCapabilityCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsNewPromiseCapabilityCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsNewPromiseCapabilityCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsNewPromiseCapabilityCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsPromiseResolveCode;
extern constinit const int s_promiseOperationsPromiseResolveCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsPromiseResolveCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsPromiseResolveCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsPromiseResolveCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsPromiseResolveCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsPromiseResolveSlowCode;
extern constinit const int s_promiseOperationsPromiseResolveSlowCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsPromiseResolveSlowCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsPromiseResolveSlowCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsPromiseResolveSlowCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsPromiseResolveSlowCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsPromiseRejectSlowCode;
extern constinit const int s_promiseOperationsPromiseRejectSlowCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsPromiseRejectSlowCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsPromiseRejectSlowCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsPromiseRejectSlowCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsPromiseRejectSlowCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsNewHandledRejectedPromiseCode;
extern constinit const int s_promiseOperationsNewHandledRejectedPromiseCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsNewHandledRejectedPromiseCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsNewHandledRejectedPromiseCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsNewHandledRejectedPromiseCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsNewHandledRejectedPromiseCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsTriggerPromiseReactionsCode;
extern constinit const int s_promiseOperationsTriggerPromiseReactionsCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsTriggerPromiseReactionsCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsTriggerPromiseReactionsCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsTriggerPromiseReactionsCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsTriggerPromiseReactionsCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsResolvePromiseCode;
extern constinit const int s_promiseOperationsResolvePromiseCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsResolvePromiseCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsResolvePromiseCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsResolvePromiseCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsResolvePromiseCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsRejectPromiseCode;
extern constinit const int s_promiseOperationsRejectPromiseCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsRejectPromiseCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsRejectPromiseCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsRejectPromiseCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsRejectPromiseCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsFulfillPromiseCode;
extern constinit const int s_promiseOperationsFulfillPromiseCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsFulfillPromiseCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsFulfillPromiseCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsFulfillPromiseCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsFulfillPromiseCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCode;
extern constinit const int s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCode;
extern constinit const int s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCode;
extern constinit const int s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsCreateResolvingFunctionsCode;
extern constinit const int s_promiseOperationsCreateResolvingFunctionsCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsCreateResolvingFunctionsCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsCreateResolvingFunctionsCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsCreateResolvingFunctionsCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsCreateResolvingFunctionsCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsPromiseReactionJobWithoutPromiseCode;
extern constinit const int s_promiseOperationsPromiseReactionJobWithoutPromiseCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsPromiseReactionJobWithoutPromiseCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsPromiseReactionJobWithoutPromiseCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsPromiseReactionJobWithoutPromiseCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsPromiseReactionJobWithoutPromiseCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsResolveWithoutPromiseCode;
extern constinit const int s_promiseOperationsResolveWithoutPromiseCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsResolveWithoutPromiseCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsResolveWithoutPromiseCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsResolveWithoutPromiseCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsResolveWithoutPromiseCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsRejectWithoutPromiseCode;
extern constinit const int s_promiseOperationsRejectWithoutPromiseCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsRejectWithoutPromiseCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsRejectWithoutPromiseCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsRejectWithoutPromiseCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsRejectWithoutPromiseCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsFulfillWithoutPromiseCode;
extern constinit const int s_promiseOperationsFulfillWithoutPromiseCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsFulfillWithoutPromiseCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsFulfillWithoutPromiseCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsFulfillWithoutPromiseCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsFulfillWithoutPromiseCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCode;
extern constinit const int s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCode;
extern constinit const int s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsPromiseReactionJobCode;
extern constinit const int s_promiseOperationsPromiseReactionJobCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsPromiseReactionJobCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsPromiseReactionJobCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsPromiseReactionJobCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsPromiseReactionJobCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsPromiseResolveThenableJobFastCode;
extern constinit const int s_promiseOperationsPromiseResolveThenableJobFastCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsPromiseResolveThenableJobFastCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsPromiseResolveThenableJobFastCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsPromiseResolveThenableJobFastCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsPromiseResolveThenableJobFastCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCode;
extern constinit const int s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsPromiseResolveThenableJobCode;
extern constinit const int s_promiseOperationsPromiseResolveThenableJobCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsPromiseResolveThenableJobCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsPromiseResolveThenableJobCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsPromiseResolveThenableJobCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsPromiseResolveThenableJobCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCode;
extern constinit const int s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsPromiseEmptyOnFulfilledCode;
extern constinit const int s_promiseOperationsPromiseEmptyOnFulfilledCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsPromiseEmptyOnFulfilledCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsPromiseEmptyOnFulfilledCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsPromiseEmptyOnFulfilledCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsPromiseEmptyOnFulfilledCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsPromiseEmptyOnRejectedCode;
extern constinit const int s_promiseOperationsPromiseEmptyOnRejectedCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsPromiseEmptyOnRejectedCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsPromiseEmptyOnRejectedCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsPromiseEmptyOnRejectedCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsPromiseEmptyOnRejectedCodeInlineAttribute;
extern constinit const char* const s_promiseOperationsPerformPromiseThenCode;
extern constinit const int s_promiseOperationsPerformPromiseThenCodeLength;
extern constinit const JSC::ConstructAbility s_promiseOperationsPerformPromiseThenCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promiseOperationsPerformPromiseThenCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promiseOperationsPerformPromiseThenCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promiseOperationsPerformPromiseThenCodeInlineAttribute;

#define JSC_FOREACH_PROMISEOPERATIONS_BUILTIN_DATA(macro) \
    macro(pushNewPromiseReaction, promiseOperationsPushNewPromiseReaction, 6) \
    macro(newPromiseCapabilitySlow, promiseOperationsNewPromiseCapabilitySlow, 1) \
    macro(newPromiseCapability, promiseOperationsNewPromiseCapability, 1) \
    macro(promiseResolve, promiseOperationsPromiseResolve, 2) \
    macro(promiseResolveSlow, promiseOperationsPromiseResolveSlow, 2) \
    macro(promiseRejectSlow, promiseOperationsPromiseRejectSlow, 2) \
    macro(newHandledRejectedPromise, promiseOperationsNewHandledRejectedPromise, 1) \
    macro(triggerPromiseReactions, promiseOperationsTriggerPromiseReactions, 3) \
    macro(resolvePromise, promiseOperationsResolvePromise, 2) \
    macro(rejectPromise, promiseOperationsRejectPromise, 2) \
    macro(fulfillPromise, promiseOperationsFulfillPromise, 2) \
    macro(resolvePromiseWithFirstResolvingFunctionCallCheck, promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheck, 2) \
    macro(fulfillPromiseWithFirstResolvingFunctionCallCheck, promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheck, 2) \
    macro(rejectPromiseWithFirstResolvingFunctionCallCheck, promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheck, 2) \
    macro(createResolvingFunctions, promiseOperationsCreateResolvingFunctions, 1) \
    macro(promiseReactionJobWithoutPromise, promiseOperationsPromiseReactionJobWithoutPromise, 3) \
    macro(resolveWithoutPromise, promiseOperationsResolveWithoutPromise, 4) \
    macro(rejectWithoutPromise, promiseOperationsRejectWithoutPromise, 4) \
    macro(fulfillWithoutPromise, promiseOperationsFulfillWithoutPromise, 4) \
    macro(resolveWithoutPromiseForAsyncAwait, promiseOperationsResolveWithoutPromiseForAsyncAwait, 4) \
    macro(createResolvingFunctionsWithoutPromise, promiseOperationsCreateResolvingFunctionsWithoutPromise, 3) \
    macro(promiseReactionJob, promiseOperationsPromiseReactionJob, 4) \
    macro(promiseResolveThenableJobFast, promiseOperationsPromiseResolveThenableJobFast, 2) \
    macro(promiseResolveThenableJobWithoutPromiseFast, promiseOperationsPromiseResolveThenableJobWithoutPromiseFast, 4) \
    macro(promiseResolveThenableJob, promiseOperationsPromiseResolveThenableJob, 3) \
    macro(promiseResolveThenableJobWithDerivedPromise, promiseOperationsPromiseResolveThenableJobWithDerivedPromise, 3) \
    macro(promiseEmptyOnFulfilled, promiseOperationsPromiseEmptyOnFulfilled, 1) \
    macro(promiseEmptyOnRejected, promiseOperationsPromiseEmptyOnRejected, 1) \
    macro(performPromiseThen, promiseOperationsPerformPromiseThen, 5) \

/* PromisePrototype */
extern constinit const char* const s_promisePrototypeCatchCode;
extern constinit const int s_promisePrototypeCatchCodeLength;
extern constinit const JSC::ConstructAbility s_promisePrototypeCatchCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promisePrototypeCatchCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promisePrototypeCatchCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promisePrototypeCatchCodeInlineAttribute;
extern constinit const char* const s_promisePrototypeThenCode;
extern constinit const int s_promisePrototypeThenCodeLength;
extern constinit const JSC::ConstructAbility s_promisePrototypeThenCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promisePrototypeThenCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promisePrototypeThenCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promisePrototypeThenCodeInlineAttribute;
extern constinit const char* const s_promisePrototypeFinallyCode;
extern constinit const int s_promisePrototypeFinallyCodeLength;
extern constinit const JSC::ConstructAbility s_promisePrototypeFinallyCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_promisePrototypeFinallyCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_promisePrototypeFinallyCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_promisePrototypeFinallyCodeInlineAttribute;

#define JSC_FOREACH_PROMISEPROTOTYPE_BUILTIN_DATA(macro) \
    macro(catch, promisePrototypeCatch, 1) \
    macro(then, promisePrototypeThen, 2) \
    macro(finally, promisePrototypeFinally, 1) \

/* ProxyHelpers */
extern constinit const char* const s_proxyHelpersPerformProxyObjectHasCode;
extern constinit const int s_proxyHelpersPerformProxyObjectHasCodeLength;
extern constinit const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectHasCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectHasCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectHasCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_proxyHelpersPerformProxyObjectHasCodeInlineAttribute;
extern constinit const char* const s_proxyHelpersPerformProxyObjectHasByValCode;
extern constinit const int s_proxyHelpersPerformProxyObjectHasByValCodeLength;
extern constinit const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectHasByValCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectHasByValCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectHasByValCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_proxyHelpersPerformProxyObjectHasByValCodeInlineAttribute;
extern constinit const char* const s_proxyHelpersPerformProxyObjectGetCode;
extern constinit const int s_proxyHelpersPerformProxyObjectGetCodeLength;
extern constinit const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectGetCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectGetCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectGetCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_proxyHelpersPerformProxyObjectGetCodeInlineAttribute;
extern constinit const char* const s_proxyHelpersPerformProxyObjectGetByValCode;
extern constinit const int s_proxyHelpersPerformProxyObjectGetByValCodeLength;
extern constinit const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectGetByValCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectGetByValCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectGetByValCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_proxyHelpersPerformProxyObjectGetByValCodeInlineAttribute;
extern constinit const char* const s_proxyHelpersPerformProxyObjectSetSloppyCode;
extern constinit const int s_proxyHelpersPerformProxyObjectSetSloppyCodeLength;
extern constinit const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectSetSloppyCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectSetSloppyCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectSetSloppyCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_proxyHelpersPerformProxyObjectSetSloppyCodeInlineAttribute;
extern constinit const char* const s_proxyHelpersPerformProxyObjectSetStrictCode;
extern constinit const int s_proxyHelpersPerformProxyObjectSetStrictCodeLength;
extern constinit const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectSetStrictCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectSetStrictCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectSetStrictCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_proxyHelpersPerformProxyObjectSetStrictCodeInlineAttribute;
extern constinit const char* const s_proxyHelpersPerformProxyObjectSetByValSloppyCode;
extern constinit const int s_proxyHelpersPerformProxyObjectSetByValSloppyCodeLength;
extern constinit const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectSetByValSloppyCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectSetByValSloppyCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectSetByValSloppyCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_proxyHelpersPerformProxyObjectSetByValSloppyCodeInlineAttribute;
extern constinit const char* const s_proxyHelpersPerformProxyObjectSetByValStrictCode;
extern constinit const int s_proxyHelpersPerformProxyObjectSetByValStrictCodeLength;
extern constinit const JSC::ConstructAbility s_proxyHelpersPerformProxyObjectSetByValStrictCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_proxyHelpersPerformProxyObjectSetByValStrictCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_proxyHelpersPerformProxyObjectSetByValStrictCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_proxyHelpersPerformProxyObjectSetByValStrictCodeInlineAttribute;

#define JSC_FOREACH_PROXYHELPERS_BUILTIN_DATA(macro) \
    macro(performProxyObjectHas, proxyHelpersPerformProxyObjectHas, 1) \
    macro(performProxyObjectHasByVal, proxyHelpersPerformProxyObjectHasByVal, 1) \
    macro(performProxyObjectGet, proxyHelpersPerformProxyObjectGet, 2) \
    macro(performProxyObjectGetByVal, proxyHelpersPerformProxyObjectGetByVal, 2) \
    macro(performProxyObjectSetSloppy, proxyHelpersPerformProxyObjectSetSloppy, 3) \
    macro(performProxyObjectSetStrict, proxyHelpersPerformProxyObjectSetStrict, 3) \
    macro(performProxyObjectSetByValSloppy, proxyHelpersPerformProxyObjectSetByValSloppy, 3) \
    macro(performProxyObjectSetByValStrict, proxyHelpersPerformProxyObjectSetByValStrict, 3) \

/* ReflectObject */
extern constinit const char* const s_reflectObjectApplyCode;
extern constinit const int s_reflectObjectApplyCodeLength;
extern constinit const JSC::ConstructAbility s_reflectObjectApplyCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_reflectObjectApplyCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_reflectObjectApplyCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_reflectObjectApplyCodeInlineAttribute;
extern constinit const char* const s_reflectObjectDeletePropertyCode;
extern constinit const int s_reflectObjectDeletePropertyCodeLength;
extern constinit const JSC::ConstructAbility s_reflectObjectDeletePropertyCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_reflectObjectDeletePropertyCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_reflectObjectDeletePropertyCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_reflectObjectDeletePropertyCodeInlineAttribute;
extern constinit const char* const s_reflectObjectGetCode;
extern constinit const int s_reflectObjectGetCodeLength;
extern constinit const JSC::ConstructAbility s_reflectObjectGetCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_reflectObjectGetCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_reflectObjectGetCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_reflectObjectGetCodeInlineAttribute;
extern constinit const char* const s_reflectObjectHasCode;
extern constinit const int s_reflectObjectHasCodeLength;
extern constinit const JSC::ConstructAbility s_reflectObjectHasCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_reflectObjectHasCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_reflectObjectHasCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_reflectObjectHasCodeInlineAttribute;

#define JSC_FOREACH_REFLECTOBJECT_BUILTIN_DATA(macro) \
    macro(apply, reflectObjectApply, 3) \
    macro(deleteProperty, reflectObjectDeleteProperty, 2) \
    macro(get, reflectObjectGet, 2) \
    macro(has, reflectObjectHas, 2) \

/* RegExpPrototype */
extern constinit const char* const s_regExpPrototypeAdvanceStringIndexCode;
extern constinit const int s_regExpPrototypeAdvanceStringIndexCodeLength;
extern constinit const JSC::ConstructAbility s_regExpPrototypeAdvanceStringIndexCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_regExpPrototypeAdvanceStringIndexCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_regExpPrototypeAdvanceStringIndexCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_regExpPrototypeAdvanceStringIndexCodeInlineAttribute;
extern constinit const char* const s_regExpPrototypeRegExpExecCode;
extern constinit const int s_regExpPrototypeRegExpExecCodeLength;
extern constinit const JSC::ConstructAbility s_regExpPrototypeRegExpExecCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_regExpPrototypeRegExpExecCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_regExpPrototypeRegExpExecCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_regExpPrototypeRegExpExecCodeInlineAttribute;
extern constinit const char* const s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCode;
extern constinit const int s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCodeLength;
extern constinit const JSC::ConstructAbility s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCodeInlineAttribute;
extern constinit const char* const s_regExpPrototypeMatchSlowCode;
extern constinit const int s_regExpPrototypeMatchSlowCodeLength;
extern constinit const JSC::ConstructAbility s_regExpPrototypeMatchSlowCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_regExpPrototypeMatchSlowCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_regExpPrototypeMatchSlowCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_regExpPrototypeMatchSlowCodeInlineAttribute;
extern constinit const char* const s_regExpPrototypeMatchCode;
extern constinit const int s_regExpPrototypeMatchCodeLength;
extern constinit const JSC::ConstructAbility s_regExpPrototypeMatchCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_regExpPrototypeMatchCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_regExpPrototypeMatchCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_regExpPrototypeMatchCodeInlineAttribute;
extern constinit const char* const s_regExpPrototypeMatchAllCode;
extern constinit const int s_regExpPrototypeMatchAllCodeLength;
extern constinit const JSC::ConstructAbility s_regExpPrototypeMatchAllCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_regExpPrototypeMatchAllCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_regExpPrototypeMatchAllCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_regExpPrototypeMatchAllCodeInlineAttribute;
extern constinit const char* const s_regExpPrototypeGetSubstitutionCode;
extern constinit const int s_regExpPrototypeGetSubstitutionCodeLength;
extern constinit const JSC::ConstructAbility s_regExpPrototypeGetSubstitutionCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_regExpPrototypeGetSubstitutionCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_regExpPrototypeGetSubstitutionCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_regExpPrototypeGetSubstitutionCodeInlineAttribute;
extern constinit const char* const s_regExpPrototypeReplaceCode;
extern constinit const int s_regExpPrototypeReplaceCodeLength;
extern constinit const JSC::ConstructAbility s_regExpPrototypeReplaceCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_regExpPrototypeReplaceCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_regExpPrototypeReplaceCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_regExpPrototypeReplaceCodeInlineAttribute;
extern constinit const char* const s_regExpPrototypeSearchCode;
extern constinit const int s_regExpPrototypeSearchCodeLength;
extern constinit const JSC::ConstructAbility s_regExpPrototypeSearchCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_regExpPrototypeSearchCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_regExpPrototypeSearchCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_regExpPrototypeSearchCodeInlineAttribute;
extern constinit const char* const s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCode;
extern constinit const int s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCodeLength;
extern constinit const JSC::ConstructAbility s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCodeInlineAttribute;
extern constinit const char* const s_regExpPrototypeSplitCode;
extern constinit const int s_regExpPrototypeSplitCodeLength;
extern constinit const JSC::ConstructAbility s_regExpPrototypeSplitCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_regExpPrototypeSplitCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_regExpPrototypeSplitCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_regExpPrototypeSplitCodeInlineAttribute;

#define JSC_FOREACH_REGEXPPROTOTYPE_BUILTIN_DATA(macro) \
    macro(advanceStringIndex, regExpPrototypeAdvanceStringIndex, 3) \
    macro(regExpExec, regExpPrototypeRegExpExec, 2) \
    macro(hasObservableSideEffectsForRegExpMatch, regExpPrototypeHasObservableSideEffectsForRegExpMatch, 1) \
    macro(matchSlow, regExpPrototypeMatchSlow, 2) \
    macro(match, regExpPrototypeMatch, 1) \
    macro(matchAll, regExpPrototypeMatchAll, 1) \
    macro(getSubstitution, regExpPrototypeGetSubstitution, 6) \
    macro(replace, regExpPrototypeReplace, 2) \
    macro(search, regExpPrototypeSearch, 1) \
    macro(hasObservableSideEffectsForRegExpSplit, regExpPrototypeHasObservableSideEffectsForRegExpSplit, 1) \
    macro(split, regExpPrototypeSplit, 2) \

/* RegExpStringIteratorPrototype */
extern constinit const char* const s_regExpStringIteratorPrototypeNextCode;
extern constinit const int s_regExpStringIteratorPrototypeNextCodeLength;
extern constinit const JSC::ConstructAbility s_regExpStringIteratorPrototypeNextCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_regExpStringIteratorPrototypeNextCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_regExpStringIteratorPrototypeNextCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_regExpStringIteratorPrototypeNextCodeInlineAttribute;

#define JSC_FOREACH_REGEXPSTRINGITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, regExpStringIteratorPrototypeNext, 0) \

/* SetIteratorPrototype */
extern constinit const char* const s_setIteratorPrototypeNextCode;
extern constinit const int s_setIteratorPrototypeNextCodeLength;
extern constinit const JSC::ConstructAbility s_setIteratorPrototypeNextCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_setIteratorPrototypeNextCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_setIteratorPrototypeNextCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_setIteratorPrototypeNextCodeInlineAttribute;

#define JSC_FOREACH_SETITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, setIteratorPrototypeNext, 0) \

/* SetPrototype */
extern constinit const char* const s_setPrototypeForEachCode;
extern constinit const int s_setPrototypeForEachCodeLength;
extern constinit const JSC::ConstructAbility s_setPrototypeForEachCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_setPrototypeForEachCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_setPrototypeForEachCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_setPrototypeForEachCodeInlineAttribute;
extern constinit const char* const s_setPrototypeGetSetSizeAsIntCode;
extern constinit const int s_setPrototypeGetSetSizeAsIntCodeLength;
extern constinit const JSC::ConstructAbility s_setPrototypeGetSetSizeAsIntCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_setPrototypeGetSetSizeAsIntCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_setPrototypeGetSetSizeAsIntCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_setPrototypeGetSetSizeAsIntCodeInlineAttribute;
extern constinit const char* const s_setPrototypeUnionCode;
extern constinit const int s_setPrototypeUnionCodeLength;
extern constinit const JSC::ConstructAbility s_setPrototypeUnionCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_setPrototypeUnionCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_setPrototypeUnionCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_setPrototypeUnionCodeInlineAttribute;
extern constinit const char* const s_setPrototypeIntersectionCode;
extern constinit const int s_setPrototypeIntersectionCodeLength;
extern constinit const JSC::ConstructAbility s_setPrototypeIntersectionCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_setPrototypeIntersectionCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_setPrototypeIntersectionCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_setPrototypeIntersectionCodeInlineAttribute;
extern constinit const char* const s_setPrototypeDifferenceCode;
extern constinit const int s_setPrototypeDifferenceCodeLength;
extern constinit const JSC::ConstructAbility s_setPrototypeDifferenceCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_setPrototypeDifferenceCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_setPrototypeDifferenceCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_setPrototypeDifferenceCodeInlineAttribute;
extern constinit const char* const s_setPrototypeSymmetricDifferenceCode;
extern constinit const int s_setPrototypeSymmetricDifferenceCodeLength;
extern constinit const JSC::ConstructAbility s_setPrototypeSymmetricDifferenceCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_setPrototypeSymmetricDifferenceCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_setPrototypeSymmetricDifferenceCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_setPrototypeSymmetricDifferenceCodeInlineAttribute;
extern constinit const char* const s_setPrototypeIsSubsetOfCode;
extern constinit const int s_setPrototypeIsSubsetOfCodeLength;
extern constinit const JSC::ConstructAbility s_setPrototypeIsSubsetOfCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_setPrototypeIsSubsetOfCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_setPrototypeIsSubsetOfCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_setPrototypeIsSubsetOfCodeInlineAttribute;
extern constinit const char* const s_setPrototypeIsSupersetOfCode;
extern constinit const int s_setPrototypeIsSupersetOfCodeLength;
extern constinit const JSC::ConstructAbility s_setPrototypeIsSupersetOfCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_setPrototypeIsSupersetOfCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_setPrototypeIsSupersetOfCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_setPrototypeIsSupersetOfCodeInlineAttribute;
extern constinit const char* const s_setPrototypeIsDisjointFromCode;
extern constinit const int s_setPrototypeIsDisjointFromCodeLength;
extern constinit const JSC::ConstructAbility s_setPrototypeIsDisjointFromCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_setPrototypeIsDisjointFromCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_setPrototypeIsDisjointFromCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_setPrototypeIsDisjointFromCodeInlineAttribute;

#define JSC_FOREACH_SETPROTOTYPE_BUILTIN_DATA(macro) \
    macro(forEach, setPrototypeForEach, 1) \
    macro(getSetSizeAsInt, setPrototypeGetSetSizeAsInt, 1) \
    macro(union, setPrototypeUnion, 1) \
    macro(intersection, setPrototypeIntersection, 1) \
    macro(difference, setPrototypeDifference, 1) \
    macro(symmetricDifference, setPrototypeSymmetricDifference, 1) \
    macro(isSubsetOf, setPrototypeIsSubsetOf, 1) \
    macro(isSupersetOf, setPrototypeIsSupersetOf, 1) \
    macro(isDisjointFrom, setPrototypeIsDisjointFrom, 1) \

/* ShadowRealmPrototype */
extern constinit const char* const s_shadowRealmPrototypeWrapRemoteValueCode;
extern constinit const int s_shadowRealmPrototypeWrapRemoteValueCodeLength;
extern constinit const JSC::ConstructAbility s_shadowRealmPrototypeWrapRemoteValueCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_shadowRealmPrototypeWrapRemoteValueCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_shadowRealmPrototypeWrapRemoteValueCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_shadowRealmPrototypeWrapRemoteValueCodeInlineAttribute;
extern constinit const char* const s_shadowRealmPrototypeEvaluateCode;
extern constinit const int s_shadowRealmPrototypeEvaluateCodeLength;
extern constinit const JSC::ConstructAbility s_shadowRealmPrototypeEvaluateCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_shadowRealmPrototypeEvaluateCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_shadowRealmPrototypeEvaluateCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_shadowRealmPrototypeEvaluateCodeInlineAttribute;
extern constinit const char* const s_shadowRealmPrototypeCrossRealmThrowCode;
extern constinit const int s_shadowRealmPrototypeCrossRealmThrowCodeLength;
extern constinit const JSC::ConstructAbility s_shadowRealmPrototypeCrossRealmThrowCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_shadowRealmPrototypeCrossRealmThrowCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_shadowRealmPrototypeCrossRealmThrowCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_shadowRealmPrototypeCrossRealmThrowCodeInlineAttribute;
extern constinit const char* const s_shadowRealmPrototypeImportValueCode;
extern constinit const int s_shadowRealmPrototypeImportValueCodeLength;
extern constinit const JSC::ConstructAbility s_shadowRealmPrototypeImportValueCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_shadowRealmPrototypeImportValueCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_shadowRealmPrototypeImportValueCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_shadowRealmPrototypeImportValueCodeInlineAttribute;

#define JSC_FOREACH_SHADOWREALMPROTOTYPE_BUILTIN_DATA(macro) \
    macro(wrapRemoteValue, shadowRealmPrototypeWrapRemoteValue, 3) \
    macro(evaluate, shadowRealmPrototypeEvaluate, 1) \
    macro(crossRealmThrow, shadowRealmPrototypeCrossRealmThrow, 1) \
    macro(importValue, shadowRealmPrototypeImportValue, 2) \

/* StringConstructor */
extern constinit const char* const s_stringConstructorRawCode;
extern constinit const int s_stringConstructorRawCodeLength;
extern constinit const JSC::ConstructAbility s_stringConstructorRawCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringConstructorRawCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringConstructorRawCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringConstructorRawCodeInlineAttribute;

#define JSC_FOREACH_STRINGCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(raw, stringConstructorRaw, 1) \

/* StringIteratorPrototype */
extern constinit const char* const s_stringIteratorPrototypeNextCode;
extern constinit const int s_stringIteratorPrototypeNextCodeLength;
extern constinit const JSC::ConstructAbility s_stringIteratorPrototypeNextCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringIteratorPrototypeNextCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringIteratorPrototypeNextCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringIteratorPrototypeNextCodeInlineAttribute;

#define JSC_FOREACH_STRINGITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, stringIteratorPrototypeNext, 0) \

/* StringPrototype */
extern constinit const char* const s_stringPrototypeMatchCode;
extern constinit const int s_stringPrototypeMatchCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeMatchCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeMatchCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeMatchCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeMatchCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeMatchAllCode;
extern constinit const int s_stringPrototypeMatchAllCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeMatchAllCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeMatchAllCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeMatchAllCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeMatchAllCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeRepeatSlowPathCode;
extern constinit const int s_stringPrototypeRepeatSlowPathCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeRepeatSlowPathCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeRepeatSlowPathCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeRepeatSlowPathCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeRepeatSlowPathCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeRepeatCharactersSlowPathCode;
extern constinit const int s_stringPrototypeRepeatCharactersSlowPathCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeRepeatCharactersSlowPathCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeRepeatCharactersSlowPathCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeRepeatCharactersSlowPathCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeRepeatCharactersSlowPathCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeRepeatCode;
extern constinit const int s_stringPrototypeRepeatCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeRepeatCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeRepeatCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeRepeatCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeRepeatCodeInlineAttribute;
extern constinit const char* const s_stringPrototypePadStartCode;
extern constinit const int s_stringPrototypePadStartCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypePadStartCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypePadStartCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypePadStartCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypePadStartCodeInlineAttribute;
extern constinit const char* const s_stringPrototypePadEndCode;
extern constinit const int s_stringPrototypePadEndCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypePadEndCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypePadEndCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypePadEndCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypePadEndCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeHasObservableSideEffectsForStringReplaceCode;
extern constinit const int s_stringPrototypeHasObservableSideEffectsForStringReplaceCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeHasObservableSideEffectsForStringReplaceCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeHasObservableSideEffectsForStringReplaceCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeHasObservableSideEffectsForStringReplaceCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeHasObservableSideEffectsForStringReplaceCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeReplaceCode;
extern constinit const int s_stringPrototypeReplaceCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeReplaceCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeReplaceCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeReplaceCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeReplaceCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeReplaceAllCode;
extern constinit const int s_stringPrototypeReplaceAllCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeReplaceAllCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeReplaceAllCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeReplaceAllCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeReplaceAllCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeSearchCode;
extern constinit const int s_stringPrototypeSearchCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeSearchCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeSearchCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeSearchCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeSearchCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeSplitCode;
extern constinit const int s_stringPrototypeSplitCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeSplitCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeSplitCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeSplitCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeSplitCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeStringConcatSlowPathCode;
extern constinit const int s_stringPrototypeStringConcatSlowPathCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeStringConcatSlowPathCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeStringConcatSlowPathCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeStringConcatSlowPathCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeStringConcatSlowPathCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeConcatCode;
extern constinit const int s_stringPrototypeConcatCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeConcatCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeConcatCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeConcatCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeConcatCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeCreateHTMLCode;
extern constinit const int s_stringPrototypeCreateHTMLCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeCreateHTMLCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeCreateHTMLCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeCreateHTMLCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeCreateHTMLCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeAnchorCode;
extern constinit const int s_stringPrototypeAnchorCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeAnchorCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeAnchorCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeAnchorCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeAnchorCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeBigCode;
extern constinit const int s_stringPrototypeBigCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeBigCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeBigCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeBigCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeBigCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeBlinkCode;
extern constinit const int s_stringPrototypeBlinkCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeBlinkCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeBlinkCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeBlinkCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeBlinkCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeBoldCode;
extern constinit const int s_stringPrototypeBoldCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeBoldCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeBoldCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeBoldCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeBoldCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeFixedCode;
extern constinit const int s_stringPrototypeFixedCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeFixedCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeFixedCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeFixedCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeFixedCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeFontcolorCode;
extern constinit const int s_stringPrototypeFontcolorCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeFontcolorCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeFontcolorCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeFontcolorCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeFontcolorCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeFontsizeCode;
extern constinit const int s_stringPrototypeFontsizeCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeFontsizeCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeFontsizeCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeFontsizeCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeFontsizeCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeItalicsCode;
extern constinit const int s_stringPrototypeItalicsCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeItalicsCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeItalicsCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeItalicsCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeItalicsCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeLinkCode;
extern constinit const int s_stringPrototypeLinkCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeLinkCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeLinkCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeLinkCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeLinkCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeSmallCode;
extern constinit const int s_stringPrototypeSmallCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeSmallCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeSmallCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeSmallCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeSmallCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeStrikeCode;
extern constinit const int s_stringPrototypeStrikeCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeStrikeCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeStrikeCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeStrikeCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeStrikeCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeSubCode;
extern constinit const int s_stringPrototypeSubCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeSubCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeSubCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeSubCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeSubCodeInlineAttribute;
extern constinit const char* const s_stringPrototypeSupCode;
extern constinit const int s_stringPrototypeSupCodeLength;
extern constinit const JSC::ConstructAbility s_stringPrototypeSupCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_stringPrototypeSupCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_stringPrototypeSupCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_stringPrototypeSupCodeInlineAttribute;

#define JSC_FOREACH_STRINGPROTOTYPE_BUILTIN_DATA(macro) \
    macro(match, stringPrototypeMatch, 1) \
    macro(matchAll, stringPrototypeMatchAll, 1) \
    macro(repeatSlowPath, stringPrototypeRepeatSlowPath, 2) \
    macro(repeatCharactersSlowPath, stringPrototypeRepeatCharactersSlowPath, 2) \
    macro(repeat, stringPrototypeRepeat, 1) \
    macro(padStart, stringPrototypePadStart, 1) \
    macro(padEnd, stringPrototypePadEnd, 1) \
    macro(hasObservableSideEffectsForStringReplace, stringPrototypeHasObservableSideEffectsForStringReplace, 2) \
    macro(replace, stringPrototypeReplace, 2) \
    macro(replaceAll, stringPrototypeReplaceAll, 2) \
    macro(search, stringPrototypeSearch, 1) \
    macro(split, stringPrototypeSplit, 2) \
    macro(stringConcatSlowPath, stringPrototypeStringConcatSlowPath, 0) \
    macro(concat, stringPrototypeConcat, 1) \
    macro(createHTML, stringPrototypeCreateHTML, 5) \
    macro(anchor, stringPrototypeAnchor, 1) \
    macro(big, stringPrototypeBig, 0) \
    macro(blink, stringPrototypeBlink, 0) \
    macro(bold, stringPrototypeBold, 0) \
    macro(fixed, stringPrototypeFixed, 0) \
    macro(fontcolor, stringPrototypeFontcolor, 1) \
    macro(fontsize, stringPrototypeFontsize, 1) \
    macro(italics, stringPrototypeItalics, 0) \
    macro(link, stringPrototypeLink, 1) \
    macro(small, stringPrototypeSmall, 0) \
    macro(strike, stringPrototypeStrike, 0) \
    macro(sub, stringPrototypeSub, 0) \
    macro(sup, stringPrototypeSup, 0) \

/* TypedArrayConstructor */
extern constinit const char* const s_typedArrayConstructorOfCode;
extern constinit const int s_typedArrayConstructorOfCodeLength;
extern constinit const JSC::ConstructAbility s_typedArrayConstructorOfCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_typedArrayConstructorOfCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_typedArrayConstructorOfCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_typedArrayConstructorOfCodeInlineAttribute;
extern constinit const char* const s_typedArrayConstructorFromCode;
extern constinit const int s_typedArrayConstructorFromCodeLength;
extern constinit const JSC::ConstructAbility s_typedArrayConstructorFromCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_typedArrayConstructorFromCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_typedArrayConstructorFromCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_typedArrayConstructorFromCodeInlineAttribute;

#define JSC_FOREACH_TYPEDARRAYCONSTRUCTOR_BUILTIN_DATA(macro) \
    macro(of, typedArrayConstructorOf, 0) \
    macro(from, typedArrayConstructorFrom, 1) \

/* TypedArrayPrototype */
extern constinit const char* const s_typedArrayPrototypeTypedArraySpeciesConstructorCode;
extern constinit const int s_typedArrayPrototypeTypedArraySpeciesConstructorCodeLength;
extern constinit const JSC::ConstructAbility s_typedArrayPrototypeTypedArraySpeciesConstructorCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_typedArrayPrototypeTypedArraySpeciesConstructorCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_typedArrayPrototypeTypedArraySpeciesConstructorCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_typedArrayPrototypeTypedArraySpeciesConstructorCodeInlineAttribute;
extern constinit const char* const s_typedArrayPrototypeReduceCode;
extern constinit const int s_typedArrayPrototypeReduceCodeLength;
extern constinit const JSC::ConstructAbility s_typedArrayPrototypeReduceCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_typedArrayPrototypeReduceCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_typedArrayPrototypeReduceCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_typedArrayPrototypeReduceCodeInlineAttribute;
extern constinit const char* const s_typedArrayPrototypeReduceRightCode;
extern constinit const int s_typedArrayPrototypeReduceRightCodeLength;
extern constinit const JSC::ConstructAbility s_typedArrayPrototypeReduceRightCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_typedArrayPrototypeReduceRightCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_typedArrayPrototypeReduceRightCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_typedArrayPrototypeReduceRightCodeInlineAttribute;
extern constinit const char* const s_typedArrayPrototypeMapCode;
extern constinit const int s_typedArrayPrototypeMapCodeLength;
extern constinit const JSC::ConstructAbility s_typedArrayPrototypeMapCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_typedArrayPrototypeMapCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_typedArrayPrototypeMapCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_typedArrayPrototypeMapCodeInlineAttribute;
extern constinit const char* const s_typedArrayPrototypeFilterCode;
extern constinit const int s_typedArrayPrototypeFilterCodeLength;
extern constinit const JSC::ConstructAbility s_typedArrayPrototypeFilterCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_typedArrayPrototypeFilterCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_typedArrayPrototypeFilterCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_typedArrayPrototypeFilterCodeInlineAttribute;
extern constinit const char* const s_typedArrayPrototypeToLocaleStringCode;
extern constinit const int s_typedArrayPrototypeToLocaleStringCodeLength;
extern constinit const JSC::ConstructAbility s_typedArrayPrototypeToLocaleStringCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_typedArrayPrototypeToLocaleStringCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_typedArrayPrototypeToLocaleStringCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_typedArrayPrototypeToLocaleStringCodeInlineAttribute;
extern constinit const char* const s_typedArrayPrototypeAtCode;
extern constinit const int s_typedArrayPrototypeAtCodeLength;
extern constinit const JSC::ConstructAbility s_typedArrayPrototypeAtCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_typedArrayPrototypeAtCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_typedArrayPrototypeAtCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_typedArrayPrototypeAtCodeInlineAttribute;

#define JSC_FOREACH_TYPEDARRAYPROTOTYPE_BUILTIN_DATA(macro) \
    macro(typedArraySpeciesConstructor, typedArrayPrototypeTypedArraySpeciesConstructor, 1) \
    macro(reduce, typedArrayPrototypeReduce, 1) \
    macro(reduceRight, typedArrayPrototypeReduceRight, 1) \
    macro(map, typedArrayPrototypeMap, 1) \
    macro(filter, typedArrayPrototypeFilter, 1) \
    macro(toLocaleString, typedArrayPrototypeToLocaleString, 0) \
    macro(at, typedArrayPrototypeAt, 1) \

/* WebAssembly */
extern constinit const char* const s_webAssemblyCompileStreamingCode;
extern constinit const int s_webAssemblyCompileStreamingCodeLength;
extern constinit const JSC::ConstructAbility s_webAssemblyCompileStreamingCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_webAssemblyCompileStreamingCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_webAssemblyCompileStreamingCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_webAssemblyCompileStreamingCodeInlineAttribute;
extern constinit const char* const s_webAssemblyInstantiateStreamingCode;
extern constinit const int s_webAssemblyInstantiateStreamingCodeLength;
extern constinit const JSC::ConstructAbility s_webAssemblyInstantiateStreamingCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_webAssemblyInstantiateStreamingCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_webAssemblyInstantiateStreamingCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_webAssemblyInstantiateStreamingCodeInlineAttribute;

#define JSC_FOREACH_WEBASSEMBLY_BUILTIN_DATA(macro) \
    macro(compileStreaming, webAssemblyCompileStreaming, 1) \
    macro(instantiateStreaming, webAssemblyInstantiateStreaming, 1) \

/* WrapForValidIteratorPrototype */
extern constinit const char* const s_wrapForValidIteratorPrototypeNextCode;
extern constinit const int s_wrapForValidIteratorPrototypeNextCodeLength;
extern constinit const JSC::ConstructAbility s_wrapForValidIteratorPrototypeNextCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_wrapForValidIteratorPrototypeNextCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_wrapForValidIteratorPrototypeNextCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_wrapForValidIteratorPrototypeNextCodeInlineAttribute;
extern constinit const char* const s_wrapForValidIteratorPrototypeReturnCode;
extern constinit const int s_wrapForValidIteratorPrototypeReturnCodeLength;
extern constinit const JSC::ConstructAbility s_wrapForValidIteratorPrototypeReturnCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_wrapForValidIteratorPrototypeReturnCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_wrapForValidIteratorPrototypeReturnCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_wrapForValidIteratorPrototypeReturnCodeInlineAttribute;

#define JSC_FOREACH_WRAPFORVALIDITERATORPROTOTYPE_BUILTIN_DATA(macro) \
    macro(next, wrapForValidIteratorPrototypeNext, 0) \
    macro(return, wrapForValidIteratorPrototypeReturn, 0) \

/* InjectedScriptSource */
extern constinit const char* const s_injectedScriptSourceCreateObjectWithoutPrototypeCode;
extern constinit const int s_injectedScriptSourceCreateObjectWithoutPrototypeCodeLength;
extern constinit const JSC::ConstructAbility s_injectedScriptSourceCreateObjectWithoutPrototypeCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_injectedScriptSourceCreateObjectWithoutPrototypeCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_injectedScriptSourceCreateObjectWithoutPrototypeCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_injectedScriptSourceCreateObjectWithoutPrototypeCodeInlineAttribute;
extern constinit const char* const s_injectedScriptSourceCreateArrayWithoutPrototypeCode;
extern constinit const int s_injectedScriptSourceCreateArrayWithoutPrototypeCodeLength;
extern constinit const JSC::ConstructAbility s_injectedScriptSourceCreateArrayWithoutPrototypeCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_injectedScriptSourceCreateArrayWithoutPrototypeCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_injectedScriptSourceCreateArrayWithoutPrototypeCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_injectedScriptSourceCreateArrayWithoutPrototypeCodeInlineAttribute;
extern constinit const char* const s_injectedScriptSourceCreateInspectorInjectedScriptCode;
extern constinit const int s_injectedScriptSourceCreateInspectorInjectedScriptCodeLength;
extern constinit const JSC::ConstructAbility s_injectedScriptSourceCreateInspectorInjectedScriptCodeConstructAbility;
extern constinit const JSC::ConstructorKind s_injectedScriptSourceCreateInspectorInjectedScriptCodeConstructorKind;
extern constinit const JSC::ImplementationVisibility s_injectedScriptSourceCreateInspectorInjectedScriptCodeImplementationVisibility;
extern constinit const JSC::InlineAttribute s_injectedScriptSourceCreateInspectorInjectedScriptCodeInlineAttribute;

#define JSC_FOREACH_INJECTEDSCRIPTSOURCE_BUILTIN_DATA(macro) \
    macro(createObjectWithoutPrototype, injectedScriptSourceCreateObjectWithoutPrototype, 0) \
    macro(createArrayWithoutPrototype, injectedScriptSourceCreateArrayWithoutPrototype, 0) \
    macro(createInspectorInjectedScript, injectedScriptSourceCreateInspectorInjectedScript, 3) \

#define JSC_FOREACH_BUILTIN_CODE(macro) \
    macro(promiseConstructorInternalPromiseConstructorCode, InternalPromise, ASCIILiteral(), s_promiseConstructorInternalPromiseConstructorCodeLength) \
    macro(promiseConstructorPromiseConstructorCode, Promise, ASCIILiteral(), s_promiseConstructorPromiseConstructorCodeLength) \
    macro(disposableStackPrototypeAddSyncDisposableResourceCode, addSyncDisposableResource, ASCIILiteral(), s_disposableStackPrototypeAddSyncDisposableResourceCodeLength) \
    macro(disposableStackPrototypeAdoptCode, adopt, ASCIILiteral(), s_disposableStackPrototypeAdoptCodeLength) \
    macro(regExpPrototypeAdvanceStringIndexCode, advanceStringIndex, ASCIILiteral(), s_regExpPrototypeAdvanceStringIndexCodeLength) \
    macro(promiseConstructorAllCode, all, ASCIILiteral(), s_promiseConstructorAllCodeLength) \
    macro(promiseConstructorAllSettledCode, allSettled, ASCIILiteral(), s_promiseConstructorAllSettledCodeLength) \
    macro(stringPrototypeAnchorCode, anchor, ASCIILiteral(), s_stringPrototypeAnchorCodeLength) \
    macro(promiseConstructorAnyCode, any, ASCIILiteral(), s_promiseConstructorAnyCodeLength) \
    macro(functionPrototypeApplyCode, apply, ASCIILiteral(), s_functionPrototypeApplyCodeLength) \
    macro(reflectObjectApplyCode, apply, ASCIILiteral(), s_reflectObjectApplyCodeLength) \
    macro(arrayIteratorPrototypeArrayIteratorNextHelperCode, arrayIteratorNextHelper, ASCIILiteral(), s_arrayIteratorPrototypeArrayIteratorNextHelperCodeLength) \
    macro(asyncIteratorPrototypeAsyncDisposeCode, asyncDispose, "[Symbol.asyncDispose]"_s, s_asyncIteratorPrototypeAsyncDisposeCodeLength) \
    macro(asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCode, asyncFromSyncIteratorOnFulfilledContinue, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinueCodeLength) \
    macro(asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCode, asyncFromSyncIteratorOnFulfilledDone, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDoneCodeLength) \
    macro(asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCode, asyncFromSyncIteratorOnRejected, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejectedCodeLength) \
    macro(asyncFunctionPrototypeAsyncFunctionResumeCode, asyncFunctionResume, ASCIILiteral(), s_asyncFunctionPrototypeAsyncFunctionResumeCodeLength) \
    macro(asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCode, asyncFunctionResumeOnFulfilled, ASCIILiteral(), s_asyncFunctionPrototypeAsyncFunctionResumeOnFulfilledCodeLength) \
    macro(asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCode, asyncFunctionResumeOnRejected, ASCIILiteral(), s_asyncFunctionPrototypeAsyncFunctionResumeOnRejectedCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorEnqueueCode, asyncGeneratorEnqueue, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorEnqueueCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCode, asyncGeneratorQueueDequeue, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorQueueDequeueCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCode, asyncGeneratorQueueEnqueue, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorQueueEnqueueCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCode, asyncGeneratorQueueIsEmpty, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorQueueIsEmptyCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorRejectCode, asyncGeneratorReject, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorRejectCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorResolveCode, asyncGeneratorResolve, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorResolveCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorResumeNextCode, asyncGeneratorResumeNext, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorResumeNextCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCode, asyncGeneratorResumeNextOnFulfilled, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilledCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCode, asyncGeneratorResumeNextOnRejected, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejectedCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorYieldCode, asyncGeneratorYield, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorYieldCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCode, asyncGeneratorYieldAwaited, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorYieldAwaitedCodeLength) \
    macro(asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCode, asyncGeneratorYieldOnRejected, ASCIILiteral(), s_asyncGeneratorPrototypeAsyncGeneratorYieldOnRejectedCodeLength) \
    macro(moduleLoaderAsyncModuleEvaluationCode, asyncModuleEvaluation, ASCIILiteral(), s_moduleLoaderAsyncModuleEvaluationCodeLength) \
    macro(arrayPrototypeAtCode, at, ASCIILiteral(), s_arrayPrototypeAtCodeLength) \
    macro(typedArrayPrototypeAtCode, at, ASCIILiteral(), s_typedArrayPrototypeAtCodeLength) \
    macro(asyncGeneratorPrototypeAwaitValueCode, awaitValue, ASCIILiteral(), s_asyncGeneratorPrototypeAwaitValueCodeLength) \
    macro(stringPrototypeBigCode, big, ASCIILiteral(), s_stringPrototypeBigCodeLength) \
    macro(stringPrototypeBlinkCode, blink, ASCIILiteral(), s_stringPrototypeBlinkCodeLength) \
    macro(stringPrototypeBoldCode, bold, ASCIILiteral(), s_stringPrototypeBoldCodeLength) \
    macro(iteratorHelpersBuiltinMapIterableCode, builtinMapIterable, ASCIILiteral(), s_iteratorHelpersBuiltinMapIterableCodeLength) \
    macro(iteratorHelpersBuiltinSetIterableCode, builtinSetIterable, ASCIILiteral(), s_iteratorHelpersBuiltinSetIterableCodeLength) \
    macro(moduleLoaderCacheSatisfyCode, cacheSatisfy, ASCIILiteral(), s_moduleLoaderCacheSatisfyCodeLength) \
    macro(moduleLoaderCacheSatisfyAndReturnCode, cacheSatisfyAndReturn, ASCIILiteral(), s_moduleLoaderCacheSatisfyAndReturnCodeLength) \
    macro(functionPrototypeCallCode, call, ASCIILiteral(), s_functionPrototypeCallCodeLength) \
    macro(promisePrototypeCatchCode, catch, ASCIILiteral(), s_promisePrototypeCatchCodeLength) \
    macro(jsIteratorPrototypeChunksCode, chunks, ASCIILiteral(), s_jsIteratorPrototypeChunksCodeLength) \
    macro(webAssemblyCompileStreamingCode, compileStreaming, ASCIILiteral(), s_webAssemblyCompileStreamingCodeLength) \
    macro(jsIteratorConstructorConcatCode, concat, ASCIILiteral(), s_jsIteratorConstructorConcatCodeLength) \
    macro(stringPrototypeConcatCode, concat, ASCIILiteral(), s_stringPrototypeConcatCodeLength) \
    macro(injectedScriptSourceCreateArrayWithoutPrototypeCode, createArrayWithoutPrototype, ASCIILiteral(), s_injectedScriptSourceCreateArrayWithoutPrototypeCodeLength) \
    macro(asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCode, createAsyncFromSyncIterator, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIteratorCodeLength) \
    macro(stringPrototypeCreateHTMLCode, createHTML, ASCIILiteral(), s_stringPrototypeCreateHTMLCodeLength) \
    macro(injectedScriptSourceCreateInspectorInjectedScriptCode, createInspectorInjectedScript, ASCIILiteral(), s_injectedScriptSourceCreateInspectorInjectedScriptCodeLength) \
    macro(injectedScriptSourceCreateObjectWithoutPrototypeCode, createObjectWithoutPrototype, ASCIILiteral(), s_injectedScriptSourceCreateObjectWithoutPrototypeCodeLength) \
    macro(promiseOperationsCreateResolvingFunctionsCode, createResolvingFunctions, ASCIILiteral(), s_promiseOperationsCreateResolvingFunctionsCodeLength) \
    macro(promiseOperationsCreateResolvingFunctionsWithoutPromiseCode, createResolvingFunctionsWithoutPromise, ASCIILiteral(), s_promiseOperationsCreateResolvingFunctionsWithoutPromiseCodeLength) \
    macro(disposableStackPrototypeCreateSyncDisposableResourceCode, createSyncDisposableResource, ASCIILiteral(), s_disposableStackPrototypeCreateSyncDisposableResourceCodeLength) \
    macro(shadowRealmPrototypeCrossRealmThrowCode, crossRealmThrow, ASCIILiteral(), s_shadowRealmPrototypeCrossRealmThrowCodeLength) \
    macro(arrayConstructorDefaultAsyncFromAsyncArrayLikeCode, defaultAsyncFromAsyncArrayLike, ASCIILiteral(), s_arrayConstructorDefaultAsyncFromAsyncArrayLikeCodeLength) \
    macro(arrayConstructorDefaultAsyncFromAsyncIteratorCode, defaultAsyncFromAsyncIterator, ASCIILiteral(), s_arrayConstructorDefaultAsyncFromAsyncIteratorCodeLength) \
    macro(disposableStackPrototypeDeferMethodCode, deferMethod, "defer"_s, s_disposableStackPrototypeDeferMethodCodeLength) \
    macro(reflectObjectDeletePropertyCode, deleteProperty, ASCIILiteral(), s_reflectObjectDeletePropertyCodeLength) \
    macro(moduleLoaderDependencyKeysIfEvaluatedCode, dependencyKeysIfEvaluated, ASCIILiteral(), s_moduleLoaderDependencyKeysIfEvaluatedCodeLength) \
    macro(setPrototypeDifferenceCode, difference, ASCIILiteral(), s_setPrototypeDifferenceCodeLength) \
    macro(disposableStackPrototypeDisposeCode, dispose, ASCIILiteral(), s_disposableStackPrototypeDisposeCodeLength) \
    macro(jsIteratorPrototypeDisposeCode, dispose, "[Symbol.dispose]"_s, s_jsIteratorPrototypeDisposeCodeLength) \
    macro(asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCode, doAsyncGeneratorBodyCall, ASCIILiteral(), s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallCodeLength) \
    macro(asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCode, doAsyncGeneratorBodyCallOnFulfilledNormal, ASCIILiteral(), s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormalCodeLength) \
    macro(asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCode, doAsyncGeneratorBodyCallOnFulfilledReturn, ASCIILiteral(), s_asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturnCodeLength) \
    macro(jsIteratorPrototypeDropCode, drop, ASCIILiteral(), s_jsIteratorPrototypeDropCodeLength) \
    macro(moduleLoaderEnsureRegisteredCode, ensureRegistered, ASCIILiteral(), s_moduleLoaderEnsureRegisteredCodeLength) \
    macro(shadowRealmPrototypeEvaluateCode, evaluate, ASCIILiteral(), s_shadowRealmPrototypeEvaluateCodeLength) \
    macro(arrayPrototypeEveryCode, every, ASCIILiteral(), s_arrayPrototypeEveryCodeLength) \
    macro(jsIteratorPrototypeEveryCode, every, ASCIILiteral(), s_jsIteratorPrototypeEveryCodeLength) \
    macro(arrayPrototypeFilterCode, filter, ASCIILiteral(), s_arrayPrototypeFilterCodeLength) \
    macro(jsIteratorPrototypeFilterCode, filter, ASCIILiteral(), s_jsIteratorPrototypeFilterCodeLength) \
    macro(typedArrayPrototypeFilterCode, filter, ASCIILiteral(), s_typedArrayPrototypeFilterCodeLength) \
    macro(promisePrototypeFinallyCode, finally, ASCIILiteral(), s_promisePrototypeFinallyCodeLength) \
    macro(arrayPrototypeFindCode, find, ASCIILiteral(), s_arrayPrototypeFindCodeLength) \
    macro(jsIteratorPrototypeFindCode, find, ASCIILiteral(), s_jsIteratorPrototypeFindCodeLength) \
    macro(arrayPrototypeFindIndexCode, findIndex, ASCIILiteral(), s_arrayPrototypeFindIndexCodeLength) \
    macro(arrayPrototypeFindLastCode, findLast, ASCIILiteral(), s_arrayPrototypeFindLastCodeLength) \
    macro(arrayPrototypeFindLastIndexCode, findLastIndex, ASCIILiteral(), s_arrayPrototypeFindLastIndexCodeLength) \
    macro(stringPrototypeFixedCode, fixed, ASCIILiteral(), s_stringPrototypeFixedCodeLength) \
    macro(arrayPrototypeFlatCode, flat, ASCIILiteral(), s_arrayPrototypeFlatCodeLength) \
    macro(arrayPrototypeFlatIntoArrayCode, flatIntoArray, ASCIILiteral(), s_arrayPrototypeFlatIntoArrayCodeLength) \
    macro(arrayPrototypeFlatIntoArrayWithCallbackCode, flatIntoArrayWithCallback, ASCIILiteral(), s_arrayPrototypeFlatIntoArrayWithCallbackCodeLength) \
    macro(arrayPrototypeFlatMapCode, flatMap, ASCIILiteral(), s_arrayPrototypeFlatMapCodeLength) \
    macro(jsIteratorPrototypeFlatMapCode, flatMap, ASCIILiteral(), s_jsIteratorPrototypeFlatMapCodeLength) \
    macro(stringPrototypeFontcolorCode, fontcolor, ASCIILiteral(), s_stringPrototypeFontcolorCodeLength) \
    macro(stringPrototypeFontsizeCode, fontsize, ASCIILiteral(), s_stringPrototypeFontsizeCodeLength) \
    macro(arrayPrototypeForEachCode, forEach, ASCIILiteral(), s_arrayPrototypeForEachCodeLength) \
    macro(mapPrototypeForEachCode, forEach, ASCIILiteral(), s_mapPrototypeForEachCodeLength) \
    macro(setPrototypeForEachCode, forEach, ASCIILiteral(), s_setPrototypeForEachCodeLength) \
    macro(moduleLoaderForceFulfillPromiseCode, forceFulfillPromise, ASCIILiteral(), s_moduleLoaderForceFulfillPromiseCodeLength) \
    macro(arrayConstructorFromCode, from, ASCIILiteral(), s_arrayConstructorFromCodeLength) \
    macro(jsIteratorConstructorFromCode, from, ASCIILiteral(), s_jsIteratorConstructorFromCodeLength) \
    macro(typedArrayConstructorFromCode, from, ASCIILiteral(), s_typedArrayConstructorFromCodeLength) \
    macro(arrayConstructorFromAsyncCode, fromAsync, ASCIILiteral(), s_arrayConstructorFromAsyncCodeLength) \
    macro(objectConstructorFromEntriesCode, fromEntries, ASCIILiteral(), s_objectConstructorFromEntriesCodeLength) \
    macro(moduleLoaderFulfillFetchCode, fulfillFetch, ASCIILiteral(), s_moduleLoaderFulfillFetchCodeLength) \
    macro(promiseOperationsFulfillPromiseCode, fulfillPromise, ASCIILiteral(), s_promiseOperationsFulfillPromiseCodeLength) \
    macro(promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCode, fulfillPromiseWithFirstResolvingFunctionCallCheck, ASCIILiteral(), s_promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheckCodeLength) \
    macro(promiseOperationsFulfillWithoutPromiseCode, fulfillWithoutPromise, ASCIILiteral(), s_promiseOperationsFulfillWithoutPromiseCodeLength) \
    macro(generatorPrototypeGeneratorResumeCode, generatorResume, ASCIILiteral(), s_generatorPrototypeGeneratorResumeCodeLength) \
    macro(reflectObjectGetCode, get, ASCIILiteral(), s_reflectObjectGetCodeLength) \
    macro(jsIteratorConstructorGetIteratorFlattenableCode, getIteratorFlattenable, ASCIILiteral(), s_jsIteratorConstructorGetIteratorFlattenableCodeLength) \
    macro(setPrototypeGetSetSizeAsIntCode, getSetSizeAsInt, ASCIILiteral(), s_setPrototypeGetSetSizeAsIntCodeLength) \
    macro(regExpPrototypeGetSubstitutionCode, getSubstitution, ASCIILiteral(), s_regExpPrototypeGetSubstitutionCodeLength) \
    macro(mapConstructorGroupByCode, groupBy, ASCIILiteral(), s_mapConstructorGroupByCodeLength) \
    macro(objectConstructorGroupByCode, groupBy, ASCIILiteral(), s_objectConstructorGroupByCodeLength) \
    macro(reflectObjectHasCode, has, ASCIILiteral(), s_reflectObjectHasCodeLength) \
    macro(regExpPrototypeHasObservableSideEffectsForRegExpMatchCode, hasObservableSideEffectsForRegExpMatch, ASCIILiteral(), s_regExpPrototypeHasObservableSideEffectsForRegExpMatchCodeLength) \
    macro(regExpPrototypeHasObservableSideEffectsForRegExpSplitCode, hasObservableSideEffectsForRegExpSplit, ASCIILiteral(), s_regExpPrototypeHasObservableSideEffectsForRegExpSplitCodeLength) \
    macro(stringPrototypeHasObservableSideEffectsForStringReplaceCode, hasObservableSideEffectsForStringReplace, ASCIILiteral(), s_stringPrototypeHasObservableSideEffectsForStringReplaceCodeLength) \
    macro(shadowRealmPrototypeImportValueCode, importValue, ASCIILiteral(), s_shadowRealmPrototypeImportValueCodeLength) \
    macro(webAssemblyInstantiateStreamingCode, instantiateStreaming, ASCIILiteral(), s_webAssemblyInstantiateStreamingCodeLength) \
    macro(internalPromiseConstructorInternalAllCode, internalAll, ASCIILiteral(), s_internalPromiseConstructorInternalAllCodeLength) \
    macro(setPrototypeIntersectionCode, intersection, ASCIILiteral(), s_setPrototypeIntersectionCodeLength) \
    macro(arrayConstructorIsArrayCode, isArray, ASCIILiteral(), s_arrayConstructorIsArrayCodeLength) \
    macro(setPrototypeIsDisjointFromCode, isDisjointFrom, ASCIILiteral(), s_setPrototypeIsDisjointFromCodeLength) \
    macro(asyncGeneratorPrototypeIsExecutionStateCode, isExecutionState, ASCIILiteral(), s_asyncGeneratorPrototypeIsExecutionStateCodeLength) \
    macro(setPrototypeIsSubsetOfCode, isSubsetOf, ASCIILiteral(), s_setPrototypeIsSubsetOfCodeLength) \
    macro(setPrototypeIsSupersetOfCode, isSupersetOf, ASCIILiteral(), s_setPrototypeIsSupersetOfCodeLength) \
    macro(asyncGeneratorPrototypeIsSuspendYieldStateCode, isSuspendYieldState, ASCIILiteral(), s_asyncGeneratorPrototypeIsSuspendYieldStateCodeLength) \
    macro(stringPrototypeItalicsCode, italics, ASCIILiteral(), s_stringPrototypeItalicsCodeLength) \
    macro(moduleLoaderLinkCode, link, ASCIILiteral(), s_moduleLoaderLinkCodeLength) \
    macro(stringPrototypeLinkCode, link, ASCIILiteral(), s_stringPrototypeLinkCodeLength) \
    macro(moduleLoaderLinkAndEvaluateModuleCode, linkAndEvaluateModule, ASCIILiteral(), s_moduleLoaderLinkAndEvaluateModuleCodeLength) \
    macro(moduleLoaderLoadAndEvaluateModuleCode, loadAndEvaluateModule, ASCIILiteral(), s_moduleLoaderLoadAndEvaluateModuleCodeLength) \
    macro(moduleLoaderLoadModuleCode, loadModule, ASCIILiteral(), s_moduleLoaderLoadModuleCodeLength) \
    macro(arrayPrototypeMapCode, map, ASCIILiteral(), s_arrayPrototypeMapCodeLength) \
    macro(jsIteratorPrototypeMapCode, map, ASCIILiteral(), s_jsIteratorPrototypeMapCodeLength) \
    macro(typedArrayPrototypeMapCode, map, ASCIILiteral(), s_typedArrayPrototypeMapCodeLength) \
    macro(regExpPrototypeMatchCode, match, "[Symbol.match]"_s, s_regExpPrototypeMatchCodeLength) \
    macro(stringPrototypeMatchCode, match, ASCIILiteral(), s_stringPrototypeMatchCodeLength) \
    macro(regExpPrototypeMatchAllCode, matchAll, "[Symbol.matchAll]"_s, s_regExpPrototypeMatchAllCodeLength) \
    macro(stringPrototypeMatchAllCode, matchAll, ASCIILiteral(), s_stringPrototypeMatchAllCodeLength) \
    macro(regExpPrototypeMatchSlowCode, matchSlow, ASCIILiteral(), s_regExpPrototypeMatchSlowCodeLength) \
    macro(moduleLoaderModuleEvaluationCode, moduleEvaluation, ASCIILiteral(), s_moduleLoaderModuleEvaluationCodeLength) \
    macro(disposableStackPrototypeMoveCode, move, ASCIILiteral(), s_disposableStackPrototypeMoveCodeLength) \
    macro(promiseOperationsNewHandledRejectedPromiseCode, newHandledRejectedPromise, ASCIILiteral(), s_promiseOperationsNewHandledRejectedPromiseCodeLength) \
    macro(promiseOperationsNewPromiseCapabilityCode, newPromiseCapability, ASCIILiteral(), s_promiseOperationsNewPromiseCapabilityCodeLength) \
    macro(promiseOperationsNewPromiseCapabilitySlowCode, newPromiseCapabilitySlow, ASCIILiteral(), s_promiseOperationsNewPromiseCapabilitySlowCodeLength) \
    macro(moduleLoaderNewRegistryEntryCode, newRegistryEntry, ASCIILiteral(), s_moduleLoaderNewRegistryEntryCodeLength) \
    macro(arrayIteratorPrototypeNextCode, next, ASCIILiteral(), s_arrayIteratorPrototypeNextCodeLength) \
    macro(asyncFromSyncIteratorPrototypeNextCode, next, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeNextCodeLength) \
    macro(asyncGeneratorPrototypeNextCode, next, ASCIILiteral(), s_asyncGeneratorPrototypeNextCodeLength) \
    macro(generatorPrototypeNextCode, next, ASCIILiteral(), s_generatorPrototypeNextCodeLength) \
    macro(jsIteratorHelperPrototypeNextCode, next, ASCIILiteral(), s_jsIteratorHelperPrototypeNextCodeLength) \
    macro(mapIteratorPrototypeNextCode, next, ASCIILiteral(), s_mapIteratorPrototypeNextCodeLength) \
    macro(regExpStringIteratorPrototypeNextCode, next, ASCIILiteral(), s_regExpStringIteratorPrototypeNextCodeLength) \
    macro(setIteratorPrototypeNextCode, next, ASCIILiteral(), s_setIteratorPrototypeNextCodeLength) \
    macro(stringIteratorPrototypeNextCode, next, ASCIILiteral(), s_stringIteratorPrototypeNextCodeLength) \
    macro(wrapForValidIteratorPrototypeNextCode, next, ASCIILiteral(), s_wrapForValidIteratorPrototypeNextCodeLength) \
    macro(arrayConstructorOfCode, of, ASCIILiteral(), s_arrayConstructorOfCodeLength) \
    macro(typedArrayConstructorOfCode, of, ASCIILiteral(), s_typedArrayConstructorOfCodeLength) \
    macro(stringPrototypePadEndCode, padEnd, ASCIILiteral(), s_stringPrototypePadEndCodeLength) \
    macro(stringPrototypePadStartCode, padStart, ASCIILiteral(), s_stringPrototypePadStartCodeLength) \
    macro(iteratorHelpersPerformIterationCode, performIteration, ASCIILiteral(), s_iteratorHelpersPerformIterationCodeLength) \
    macro(promiseOperationsPerformPromiseThenCode, performPromiseThen, ASCIILiteral(), s_promiseOperationsPerformPromiseThenCodeLength) \
    macro(proxyHelpersPerformProxyObjectGetCode, performProxyObjectGet, ASCIILiteral(), s_proxyHelpersPerformProxyObjectGetCodeLength) \
    macro(proxyHelpersPerformProxyObjectGetByValCode, performProxyObjectGetByVal, ASCIILiteral(), s_proxyHelpersPerformProxyObjectGetByValCodeLength) \
    macro(proxyHelpersPerformProxyObjectHasCode, performProxyObjectHas, ASCIILiteral(), s_proxyHelpersPerformProxyObjectHasCodeLength) \
    macro(proxyHelpersPerformProxyObjectHasByValCode, performProxyObjectHasByVal, ASCIILiteral(), s_proxyHelpersPerformProxyObjectHasByValCodeLength) \
    macro(proxyHelpersPerformProxyObjectSetByValSloppyCode, performProxyObjectSetByValSloppy, ASCIILiteral(), s_proxyHelpersPerformProxyObjectSetByValSloppyCodeLength) \
    macro(proxyHelpersPerformProxyObjectSetByValStrictCode, performProxyObjectSetByValStrict, ASCIILiteral(), s_proxyHelpersPerformProxyObjectSetByValStrictCodeLength) \
    macro(proxyHelpersPerformProxyObjectSetSloppyCode, performProxyObjectSetSloppy, ASCIILiteral(), s_proxyHelpersPerformProxyObjectSetSloppyCodeLength) \
    macro(proxyHelpersPerformProxyObjectSetStrictCode, performProxyObjectSetStrict, ASCIILiteral(), s_proxyHelpersPerformProxyObjectSetStrictCodeLength) \
    macro(promiseConstructorPromiseAllNewResolveElementCode, promiseAllNewResolveElement, ASCIILiteral(), s_promiseConstructorPromiseAllNewResolveElementCodeLength) \
    macro(promiseConstructorPromiseAllOnFulfilledCode, promiseAllOnFulfilled, ASCIILiteral(), s_promiseConstructorPromiseAllOnFulfilledCodeLength) \
    macro(promiseConstructorPromiseAllSlowCode, promiseAllSlow, ASCIILiteral(), s_promiseConstructorPromiseAllSlowCodeLength) \
    macro(promiseOperationsPromiseEmptyOnFulfilledCode, promiseEmptyOnFulfilled, ASCIILiteral(), s_promiseOperationsPromiseEmptyOnFulfilledCodeLength) \
    macro(promiseOperationsPromiseEmptyOnRejectedCode, promiseEmptyOnRejected, ASCIILiteral(), s_promiseOperationsPromiseEmptyOnRejectedCodeLength) \
    macro(promiseConstructorPromiseNewOnRejectedCode, promiseNewOnRejected, ASCIILiteral(), s_promiseConstructorPromiseNewOnRejectedCodeLength) \
    macro(promiseConstructorPromiseOnRejectedWithContextCode, promiseOnRejectedWithContext, ASCIILiteral(), s_promiseConstructorPromiseOnRejectedWithContextCodeLength) \
    macro(promiseOperationsPromiseReactionJobCode, promiseReactionJob, ASCIILiteral(), s_promiseOperationsPromiseReactionJobCodeLength) \
    macro(promiseOperationsPromiseReactionJobWithoutPromiseCode, promiseReactionJobWithoutPromise, ASCIILiteral(), s_promiseOperationsPromiseReactionJobWithoutPromiseCodeLength) \
    macro(promiseOperationsPromiseRejectSlowCode, promiseRejectSlow, ASCIILiteral(), s_promiseOperationsPromiseRejectSlowCodeLength) \
    macro(promiseOperationsPromiseResolveCode, promiseResolve, ASCIILiteral(), s_promiseOperationsPromiseResolveCodeLength) \
    macro(promiseOperationsPromiseResolveSlowCode, promiseResolveSlow, ASCIILiteral(), s_promiseOperationsPromiseResolveSlowCodeLength) \
    macro(promiseOperationsPromiseResolveThenableJobCode, promiseResolveThenableJob, ASCIILiteral(), s_promiseOperationsPromiseResolveThenableJobCodeLength) \
    macro(promiseOperationsPromiseResolveThenableJobFastCode, promiseResolveThenableJobFast, ASCIILiteral(), s_promiseOperationsPromiseResolveThenableJobFastCodeLength) \
    macro(promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCode, promiseResolveThenableJobWithDerivedPromise, ASCIILiteral(), s_promiseOperationsPromiseResolveThenableJobWithDerivedPromiseCodeLength) \
    macro(promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCode, promiseResolveThenableJobWithoutPromiseFast, ASCIILiteral(), s_promiseOperationsPromiseResolveThenableJobWithoutPromiseFastCodeLength) \
    macro(moduleLoaderProvideFetchCode, provideFetch, ASCIILiteral(), s_moduleLoaderProvideFetchCodeLength) \
    macro(promiseOperationsPushNewPromiseReactionCode, pushNewPromiseReaction, ASCIILiteral(), s_promiseOperationsPushNewPromiseReactionCodeLength) \
    macro(promiseConstructorRaceCode, race, ASCIILiteral(), s_promiseConstructorRaceCodeLength) \
    macro(stringConstructorRawCode, raw, ASCIILiteral(), s_stringConstructorRawCodeLength) \
    macro(arrayPrototypeReduceCode, reduce, ASCIILiteral(), s_arrayPrototypeReduceCodeLength) \
    macro(jsIteratorPrototypeReduceCode, reduce, ASCIILiteral(), s_jsIteratorPrototypeReduceCodeLength) \
    macro(typedArrayPrototypeReduceCode, reduce, ASCIILiteral(), s_typedArrayPrototypeReduceCodeLength) \
    macro(arrayPrototypeReduceRightCode, reduceRight, ASCIILiteral(), s_arrayPrototypeReduceRightCodeLength) \
    macro(typedArrayPrototypeReduceRightCode, reduceRight, ASCIILiteral(), s_typedArrayPrototypeReduceRightCodeLength) \
    macro(regExpPrototypeRegExpExecCode, regExpExec, ASCIILiteral(), s_regExpPrototypeRegExpExecCodeLength) \
    macro(promiseConstructorRejectCode, reject, ASCIILiteral(), s_promiseConstructorRejectCodeLength) \
    macro(promiseOperationsRejectPromiseCode, rejectPromise, ASCIILiteral(), s_promiseOperationsRejectPromiseCodeLength) \
    macro(promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCode, rejectPromiseWithFirstResolvingFunctionCallCheck, ASCIILiteral(), s_promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheckCodeLength) \
    macro(promiseOperationsRejectWithoutPromiseCode, rejectWithoutPromise, ASCIILiteral(), s_promiseOperationsRejectWithoutPromiseCodeLength) \
    macro(stringPrototypeRepeatCode, repeat, ASCIILiteral(), s_stringPrototypeRepeatCodeLength) \
    macro(stringPrototypeRepeatCharactersSlowPathCode, repeatCharactersSlowPath, ASCIILiteral(), s_stringPrototypeRepeatCharactersSlowPathCodeLength) \
    macro(stringPrototypeRepeatSlowPathCode, repeatSlowPath, ASCIILiteral(), s_stringPrototypeRepeatSlowPathCodeLength) \
    macro(regExpPrototypeReplaceCode, replace, "[Symbol.replace]"_s, s_regExpPrototypeReplaceCodeLength) \
    macro(stringPrototypeReplaceCode, replace, ASCIILiteral(), s_stringPrototypeReplaceCodeLength) \
    macro(stringPrototypeReplaceAllCode, replaceAll, ASCIILiteral(), s_stringPrototypeReplaceAllCodeLength) \
    macro(moduleLoaderRequestFetchCode, requestFetch, ASCIILiteral(), s_moduleLoaderRequestFetchCodeLength) \
    macro(moduleLoaderRequestImportModuleCode, requestImportModule, ASCIILiteral(), s_moduleLoaderRequestImportModuleCodeLength) \
    macro(moduleLoaderRequestInstantiateCode, requestInstantiate, ASCIILiteral(), s_moduleLoaderRequestInstantiateCodeLength) \
    macro(moduleLoaderRequestSatisfyCode, requestSatisfy, ASCIILiteral(), s_moduleLoaderRequestSatisfyCodeLength) \
    macro(moduleLoaderRequestSatisfyUtilCode, requestSatisfyUtil, ASCIILiteral(), s_moduleLoaderRequestSatisfyUtilCodeLength) \
    macro(promiseConstructorResolveCode, resolve, ASCIILiteral(), s_promiseConstructorResolveCodeLength) \
    macro(promiseOperationsResolvePromiseCode, resolvePromise, ASCIILiteral(), s_promiseOperationsResolvePromiseCodeLength) \
    macro(promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCode, resolvePromiseWithFirstResolvingFunctionCallCheck, ASCIILiteral(), s_promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheckCodeLength) \
    macro(promiseOperationsResolveWithoutPromiseCode, resolveWithoutPromise, ASCIILiteral(), s_promiseOperationsResolveWithoutPromiseCodeLength) \
    macro(promiseOperationsResolveWithoutPromiseForAsyncAwaitCode, resolveWithoutPromiseForAsyncAwait, ASCIILiteral(), s_promiseOperationsResolveWithoutPromiseForAsyncAwaitCodeLength) \
    macro(asyncFromSyncIteratorPrototypeReturnCode, return, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeReturnCodeLength) \
    macro(asyncGeneratorPrototypeReturnCode, return, ASCIILiteral(), s_asyncGeneratorPrototypeReturnCodeLength) \
    macro(generatorPrototypeReturnCode, return, ASCIILiteral(), s_generatorPrototypeReturnCodeLength) \
    macro(jsIteratorHelperPrototypeReturnCode, return, ASCIILiteral(), s_jsIteratorHelperPrototypeReturnCodeLength) \
    macro(wrapForValidIteratorPrototypeReturnCode, return, ASCIILiteral(), s_wrapForValidIteratorPrototypeReturnCodeLength) \
    macro(regExpPrototypeSearchCode, search, "[Symbol.search]"_s, s_regExpPrototypeSearchCodeLength) \
    macro(stringPrototypeSearchCode, search, ASCIILiteral(), s_stringPrototypeSearchCodeLength) \
    macro(moduleLoaderSetStateToMaxCode, setStateToMax, ASCIILiteral(), s_moduleLoaderSetStateToMaxCodeLength) \
    macro(stringPrototypeSmallCode, small, ASCIILiteral(), s_stringPrototypeSmallCodeLength) \
    macro(arrayPrototypeSomeCode, some, ASCIILiteral(), s_arrayPrototypeSomeCodeLength) \
    macro(jsIteratorPrototypeSomeCode, some, ASCIILiteral(), s_jsIteratorPrototypeSomeCodeLength) \
    macro(globalOperationsSpeciesConstructorCode, speciesConstructor, ASCIILiteral(), s_globalOperationsSpeciesConstructorCodeLength) \
    macro(regExpPrototypeSplitCode, split, "[Symbol.split]"_s, s_regExpPrototypeSplitCodeLength) \
    macro(stringPrototypeSplitCode, split, ASCIILiteral(), s_stringPrototypeSplitCodeLength) \
    macro(stringPrototypeStrikeCode, strike, ASCIILiteral(), s_stringPrototypeStrikeCodeLength) \
    macro(stringPrototypeStringConcatSlowPathCode, stringConcatSlowPath, ASCIILiteral(), s_stringPrototypeStringConcatSlowPathCodeLength) \
    macro(stringPrototypeSubCode, sub, ASCIILiteral(), s_stringPrototypeSubCodeLength) \
    macro(stringPrototypeSupCode, sup, ASCIILiteral(), s_stringPrototypeSupCodeLength) \
    macro(functionPrototypeSymbolHasInstanceCode, symbolHasInstance, "[Symbol.hasInstance]"_s, s_functionPrototypeSymbolHasInstanceCodeLength) \
    macro(setPrototypeSymmetricDifferenceCode, symmetricDifference, ASCIILiteral(), s_setPrototypeSymmetricDifferenceCodeLength) \
    macro(jsIteratorPrototypeTakeCode, take, ASCIILiteral(), s_jsIteratorPrototypeTakeCodeLength) \
    macro(promisePrototypeThenCode, then, ASCIILiteral(), s_promisePrototypeThenCodeLength) \
    macro(asyncFromSyncIteratorPrototypeThrowCode, throw, ASCIILiteral(), s_asyncFromSyncIteratorPrototypeThrowCodeLength) \
    macro(asyncGeneratorPrototypeThrowCode, throw, ASCIILiteral(), s_asyncGeneratorPrototypeThrowCodeLength) \
    macro(generatorPrototypeThrowCode, throw, ASCIILiteral(), s_generatorPrototypeThrowCodeLength) \
    macro(typedArrayPrototypeToLocaleStringCode, toLocaleString, ASCIILiteral(), s_typedArrayPrototypeToLocaleStringCodeLength) \
    macro(promiseOperationsTriggerPromiseReactionsCode, triggerPromiseReactions, ASCIILiteral(), s_promiseOperationsTriggerPromiseReactionsCodeLength) \
    macro(promiseConstructorTryCode, try, ASCIILiteral(), s_promiseConstructorTryCodeLength) \
    macro(typedArrayPrototypeTypedArraySpeciesConstructorCode, typedArraySpeciesConstructor, ASCIILiteral(), s_typedArrayPrototypeTypedArraySpeciesConstructorCodeLength) \
    macro(setPrototypeUnionCode, union, ASCIILiteral(), s_setPrototypeUnionCodeLength) \
    macro(disposableStackPrototypeUseCode, use, ASCIILiteral(), s_disposableStackPrototypeUseCodeLength) \
    macro(jsIteratorPrototypeWindowsCode, windows, ASCIILiteral(), s_jsIteratorPrototypeWindowsCodeLength) \
    macro(promiseConstructorWithResolversCode, withResolvers, ASCIILiteral(), s_promiseConstructorWithResolversCodeLength) \
    macro(shadowRealmPrototypeWrapRemoteValueCode, wrapRemoteValue, ASCIILiteral(), s_shadowRealmPrototypeWrapRemoteValueCodeLength) \
    macro(iteratorHelpersWrappedIteratorCode, wrappedIterator, ASCIILiteral(), s_iteratorHelpersWrappedIteratorCodeLength) \

#define JSC_FOREACH_BUILTIN_FUNCTION_NAME(macro) \
    macro(InternalPromise) \
    macro(Promise) \
    macro(addSyncDisposableResource) \
    macro(adopt) \
    macro(advanceStringIndex) \
    macro(all) \
    macro(allSettled) \
    macro(anchor) \
    macro(any) \
    macro(apply) \
    macro(arrayIteratorNextHelper) \
    macro(asyncDispose) \
    macro(asyncFromSyncIteratorOnFulfilledContinue) \
    macro(asyncFromSyncIteratorOnFulfilledDone) \
    macro(asyncFromSyncIteratorOnRejected) \
    macro(asyncFunctionResume) \
    macro(asyncFunctionResumeOnFulfilled) \
    macro(asyncFunctionResumeOnRejected) \
    macro(asyncGeneratorEnqueue) \
    macro(asyncGeneratorQueueDequeue) \
    macro(asyncGeneratorQueueEnqueue) \
    macro(asyncGeneratorQueueIsEmpty) \
    macro(asyncGeneratorReject) \
    macro(asyncGeneratorResolve) \
    macro(asyncGeneratorResumeNext) \
    macro(asyncGeneratorResumeNextOnFulfilled) \
    macro(asyncGeneratorResumeNextOnRejected) \
    macro(asyncGeneratorYield) \
    macro(asyncGeneratorYieldAwaited) \
    macro(asyncGeneratorYieldOnRejected) \
    macro(asyncModuleEvaluation) \
    macro(at) \
    macro(awaitValue) \
    macro(big) \
    macro(blink) \
    macro(bold) \
    macro(builtinMapIterable) \
    macro(builtinSetIterable) \
    macro(cacheSatisfy) \
    macro(cacheSatisfyAndReturn) \
    macro(call) \
    macro(catch) \
    macro(chunks) \
    macro(compileStreaming) \
    macro(concat) \
    macro(createArrayWithoutPrototype) \
    macro(createAsyncFromSyncIterator) \
    macro(createHTML) \
    macro(createInspectorInjectedScript) \
    macro(createObjectWithoutPrototype) \
    macro(createResolvingFunctions) \
    macro(createResolvingFunctionsWithoutPromise) \
    macro(createSyncDisposableResource) \
    macro(crossRealmThrow) \
    macro(defaultAsyncFromAsyncArrayLike) \
    macro(defaultAsyncFromAsyncIterator) \
    macro(deferMethod) \
    macro(deleteProperty) \
    macro(dependencyKeysIfEvaluated) \
    macro(difference) \
    macro(dispose) \
    macro(doAsyncGeneratorBodyCall) \
    macro(doAsyncGeneratorBodyCallOnFulfilledNormal) \
    macro(doAsyncGeneratorBodyCallOnFulfilledReturn) \
    macro(drop) \
    macro(ensureRegistered) \
    macro(evaluate) \
    macro(every) \
    macro(filter) \
    macro(finally) \
    macro(find) \
    macro(findIndex) \
    macro(findLast) \
    macro(findLastIndex) \
    macro(fixed) \
    macro(flat) \
    macro(flatIntoArray) \
    macro(flatIntoArrayWithCallback) \
    macro(flatMap) \
    macro(fontcolor) \
    macro(fontsize) \
    macro(forEach) \
    macro(forceFulfillPromise) \
    macro(from) \
    macro(fromAsync) \
    macro(fromEntries) \
    macro(fulfillFetch) \
    macro(fulfillPromise) \
    macro(fulfillPromiseWithFirstResolvingFunctionCallCheck) \
    macro(fulfillWithoutPromise) \
    macro(generatorResume) \
    macro(get) \
    macro(getIteratorFlattenable) \
    macro(getSetSizeAsInt) \
    macro(getSubstitution) \
    macro(groupBy) \
    macro(has) \
    macro(hasObservableSideEffectsForRegExpMatch) \
    macro(hasObservableSideEffectsForRegExpSplit) \
    macro(hasObservableSideEffectsForStringReplace) \
    macro(importValue) \
    macro(instantiateStreaming) \
    macro(internalAll) \
    macro(intersection) \
    macro(isArray) \
    macro(isDisjointFrom) \
    macro(isExecutionState) \
    macro(isSubsetOf) \
    macro(isSupersetOf) \
    macro(isSuspendYieldState) \
    macro(italics) \
    macro(link) \
    macro(linkAndEvaluateModule) \
    macro(loadAndEvaluateModule) \
    macro(loadModule) \
    macro(map) \
    macro(match) \
    macro(matchAll) \
    macro(matchSlow) \
    macro(moduleEvaluation) \
    macro(move) \
    macro(newHandledRejectedPromise) \
    macro(newPromiseCapability) \
    macro(newPromiseCapabilitySlow) \
    macro(newRegistryEntry) \
    macro(next) \
    macro(of) \
    macro(padEnd) \
    macro(padStart) \
    macro(performIteration) \
    macro(performPromiseThen) \
    macro(performProxyObjectGet) \
    macro(performProxyObjectGetByVal) \
    macro(performProxyObjectHas) \
    macro(performProxyObjectHasByVal) \
    macro(performProxyObjectSetByValSloppy) \
    macro(performProxyObjectSetByValStrict) \
    macro(performProxyObjectSetSloppy) \
    macro(performProxyObjectSetStrict) \
    macro(promiseAllNewResolveElement) \
    macro(promiseAllOnFulfilled) \
    macro(promiseAllSlow) \
    macro(promiseEmptyOnFulfilled) \
    macro(promiseEmptyOnRejected) \
    macro(promiseNewOnRejected) \
    macro(promiseOnRejectedWithContext) \
    macro(promiseReactionJob) \
    macro(promiseReactionJobWithoutPromise) \
    macro(promiseRejectSlow) \
    macro(promiseResolve) \
    macro(promiseResolveSlow) \
    macro(promiseResolveThenableJob) \
    macro(promiseResolveThenableJobFast) \
    macro(promiseResolveThenableJobWithDerivedPromise) \
    macro(promiseResolveThenableJobWithoutPromiseFast) \
    macro(provideFetch) \
    macro(pushNewPromiseReaction) \
    macro(race) \
    macro(raw) \
    macro(reduce) \
    macro(reduceRight) \
    macro(regExpExec) \
    macro(reject) \
    macro(rejectPromise) \
    macro(rejectPromiseWithFirstResolvingFunctionCallCheck) \
    macro(rejectWithoutPromise) \
    macro(repeat) \
    macro(repeatCharactersSlowPath) \
    macro(repeatSlowPath) \
    macro(replace) \
    macro(replaceAll) \
    macro(requestFetch) \
    macro(requestImportModule) \
    macro(requestInstantiate) \
    macro(requestSatisfy) \
    macro(requestSatisfyUtil) \
    macro(resolve) \
    macro(resolvePromise) \
    macro(resolvePromiseWithFirstResolvingFunctionCallCheck) \
    macro(resolveWithoutPromise) \
    macro(resolveWithoutPromiseForAsyncAwait) \
    macro(return) \
    macro(search) \
    macro(setStateToMax) \
    macro(small) \
    macro(some) \
    macro(speciesConstructor) \
    macro(split) \
    macro(strike) \
    macro(stringConcatSlowPath) \
    macro(sub) \
    macro(sup) \
    macro(symbolHasInstance) \
    macro(symmetricDifference) \
    macro(take) \
    macro(then) \
    macro(throw) \
    macro(toLocaleString) \
    macro(triggerPromiseReactions) \
    macro(try) \
    macro(typedArraySpeciesConstructor) \
    macro(union) \
    macro(use) \
    macro(windows) \
    macro(withResolvers) \
    macro(wrapRemoteValue) \
    macro(wrappedIterator) \

#define JSC_FOREACH_BUILTIN_LINK_TIME_CONSTANT(macro) \
    macro(addSyncDisposableResource, disposableStackPrototypeAddSyncDisposableResource) \
    macro(advanceStringIndex, regExpPrototypeAdvanceStringIndex) \
    macro(arrayIteratorNextHelper, arrayIteratorPrototypeArrayIteratorNextHelper) \
    macro(asyncFromSyncIteratorOnFulfilledContinue, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledContinue) \
    macro(asyncFromSyncIteratorOnFulfilledDone, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnFulfilledDone) \
    macro(asyncFromSyncIteratorOnRejected, asyncFromSyncIteratorPrototypeAsyncFromSyncIteratorOnRejected) \
    macro(asyncFunctionResume, asyncFunctionPrototypeAsyncFunctionResume) \
    macro(asyncFunctionResumeOnFulfilled, asyncFunctionPrototypeAsyncFunctionResumeOnFulfilled) \
    macro(asyncFunctionResumeOnRejected, asyncFunctionPrototypeAsyncFunctionResumeOnRejected) \
    macro(asyncGeneratorEnqueue, asyncGeneratorPrototypeAsyncGeneratorEnqueue) \
    macro(asyncGeneratorQueueDequeue, asyncGeneratorPrototypeAsyncGeneratorQueueDequeue) \
    macro(asyncGeneratorQueueEnqueue, asyncGeneratorPrototypeAsyncGeneratorQueueEnqueue) \
    macro(asyncGeneratorQueueIsEmpty, asyncGeneratorPrototypeAsyncGeneratorQueueIsEmpty) \
    macro(asyncGeneratorReject, asyncGeneratorPrototypeAsyncGeneratorReject) \
    macro(asyncGeneratorResolve, asyncGeneratorPrototypeAsyncGeneratorResolve) \
    macro(asyncGeneratorResumeNext, asyncGeneratorPrototypeAsyncGeneratorResumeNext) \
    macro(asyncGeneratorResumeNextOnFulfilled, asyncGeneratorPrototypeAsyncGeneratorResumeNextOnFulfilled) \
    macro(asyncGeneratorResumeNextOnRejected, asyncGeneratorPrototypeAsyncGeneratorResumeNextOnRejected) \
    macro(asyncGeneratorYield, asyncGeneratorPrototypeAsyncGeneratorYield) \
    macro(asyncGeneratorYieldAwaited, asyncGeneratorPrototypeAsyncGeneratorYieldAwaited) \
    macro(asyncGeneratorYieldOnRejected, asyncGeneratorPrototypeAsyncGeneratorYieldOnRejected) \
    macro(awaitValue, asyncGeneratorPrototypeAwaitValue) \
    macro(builtinMapIterable, iteratorHelpersBuiltinMapIterable) \
    macro(builtinSetIterable, iteratorHelpersBuiltinSetIterable) \
    macro(cacheSatisfy, moduleLoaderCacheSatisfy) \
    macro(cacheSatisfyAndReturn, moduleLoaderCacheSatisfyAndReturn) \
    macro(createArrayWithoutPrototype, injectedScriptSourceCreateArrayWithoutPrototype) \
    macro(createAsyncFromSyncIterator, asyncFromSyncIteratorPrototypeCreateAsyncFromSyncIterator) \
    macro(createHTML, stringPrototypeCreateHTML) \
    macro(createInspectorInjectedScript, injectedScriptSourceCreateInspectorInjectedScript) \
    macro(createObjectWithoutPrototype, injectedScriptSourceCreateObjectWithoutPrototype) \
    macro(createResolvingFunctions, promiseOperationsCreateResolvingFunctions) \
    macro(createResolvingFunctionsWithoutPromise, promiseOperationsCreateResolvingFunctionsWithoutPromise) \
    macro(createSyncDisposableResource, disposableStackPrototypeCreateSyncDisposableResource) \
    macro(crossRealmThrow, shadowRealmPrototypeCrossRealmThrow) \
    macro(defaultAsyncFromAsyncArrayLike, arrayConstructorDefaultAsyncFromAsyncArrayLike) \
    macro(defaultAsyncFromAsyncIterator, arrayConstructorDefaultAsyncFromAsyncIterator) \
    macro(doAsyncGeneratorBodyCall, asyncGeneratorPrototypeDoAsyncGeneratorBodyCall) \
    macro(doAsyncGeneratorBodyCallOnFulfilledNormal, asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledNormal) \
    macro(doAsyncGeneratorBodyCallOnFulfilledReturn, asyncGeneratorPrototypeDoAsyncGeneratorBodyCallOnFulfilledReturn) \
    macro(flatIntoArray, arrayPrototypeFlatIntoArray) \
    macro(flatIntoArrayWithCallback, arrayPrototypeFlatIntoArrayWithCallback) \
    macro(forceFulfillPromise, moduleLoaderForceFulfillPromise) \
    macro(fulfillFetch, moduleLoaderFulfillFetch) \
    macro(fulfillPromise, promiseOperationsFulfillPromise) \
    macro(fulfillPromiseWithFirstResolvingFunctionCallCheck, promiseOperationsFulfillPromiseWithFirstResolvingFunctionCallCheck) \
    macro(fulfillWithoutPromise, promiseOperationsFulfillWithoutPromise) \
    macro(generatorResume, generatorPrototypeGeneratorResume) \
    macro(getIteratorFlattenable, jsIteratorConstructorGetIteratorFlattenable) \
    macro(getSetSizeAsInt, setPrototypeGetSetSizeAsInt) \
    macro(getSubstitution, regExpPrototypeGetSubstitution) \
    macro(hasObservableSideEffectsForRegExpMatch, regExpPrototypeHasObservableSideEffectsForRegExpMatch) \
    macro(hasObservableSideEffectsForRegExpSplit, regExpPrototypeHasObservableSideEffectsForRegExpSplit) \
    macro(hasObservableSideEffectsForStringReplace, stringPrototypeHasObservableSideEffectsForStringReplace) \
    macro(isExecutionState, asyncGeneratorPrototypeIsExecutionState) \
    macro(isSuspendYieldState, asyncGeneratorPrototypeIsSuspendYieldState) \
    macro(matchSlow, regExpPrototypeMatchSlow) \
    macro(newHandledRejectedPromise, promiseOperationsNewHandledRejectedPromise) \
    macro(newPromiseCapability, promiseOperationsNewPromiseCapability) \
    macro(newPromiseCapabilitySlow, promiseOperationsNewPromiseCapabilitySlow) \
    macro(newRegistryEntry, moduleLoaderNewRegistryEntry) \
    macro(performIteration, iteratorHelpersPerformIteration) \
    macro(performPromiseThen, promiseOperationsPerformPromiseThen) \
    macro(performProxyObjectGet, proxyHelpersPerformProxyObjectGet) \
    macro(performProxyObjectGetByVal, proxyHelpersPerformProxyObjectGetByVal) \
    macro(performProxyObjectHas, proxyHelpersPerformProxyObjectHas) \
    macro(performProxyObjectHasByVal, proxyHelpersPerformProxyObjectHasByVal) \
    macro(performProxyObjectSetByValSloppy, proxyHelpersPerformProxyObjectSetByValSloppy) \
    macro(performProxyObjectSetByValStrict, proxyHelpersPerformProxyObjectSetByValStrict) \
    macro(performProxyObjectSetSloppy, proxyHelpersPerformProxyObjectSetSloppy) \
    macro(performProxyObjectSetStrict, proxyHelpersPerformProxyObjectSetStrict) \
    macro(promiseAllNewResolveElement, promiseConstructorPromiseAllNewResolveElement) \
    macro(promiseAllOnFulfilled, promiseConstructorPromiseAllOnFulfilled) \
    macro(promiseAllSlow, promiseConstructorPromiseAllSlow) \
    macro(promiseEmptyOnFulfilled, promiseOperationsPromiseEmptyOnFulfilled) \
    macro(promiseEmptyOnRejected, promiseOperationsPromiseEmptyOnRejected) \
    macro(promiseNewOnRejected, promiseConstructorPromiseNewOnRejected) \
    macro(promiseOnRejectedWithContext, promiseConstructorPromiseOnRejectedWithContext) \
    macro(promiseReactionJob, promiseOperationsPromiseReactionJob) \
    macro(promiseReactionJobWithoutPromise, promiseOperationsPromiseReactionJobWithoutPromise) \
    macro(promiseRejectSlow, promiseOperationsPromiseRejectSlow) \
    macro(promiseResolve, promiseOperationsPromiseResolve) \
    macro(promiseResolveSlow, promiseOperationsPromiseResolveSlow) \
    macro(promiseResolveThenableJob, promiseOperationsPromiseResolveThenableJob) \
    macro(promiseResolveThenableJobFast, promiseOperationsPromiseResolveThenableJobFast) \
    macro(promiseResolveThenableJobWithDerivedPromise, promiseOperationsPromiseResolveThenableJobWithDerivedPromise) \
    macro(promiseResolveThenableJobWithoutPromiseFast, promiseOperationsPromiseResolveThenableJobWithoutPromiseFast) \
    macro(pushNewPromiseReaction, promiseOperationsPushNewPromiseReaction) \
    macro(regExpExec, regExpPrototypeRegExpExec) \
    macro(rejectPromise, promiseOperationsRejectPromise) \
    macro(rejectPromiseWithFirstResolvingFunctionCallCheck, promiseOperationsRejectPromiseWithFirstResolvingFunctionCallCheck) \
    macro(rejectWithoutPromise, promiseOperationsRejectWithoutPromise) \
    macro(repeatCharactersSlowPath, stringPrototypeRepeatCharactersSlowPath) \
    macro(repeatSlowPath, stringPrototypeRepeatSlowPath) \
    macro(resolvePromise, promiseOperationsResolvePromise) \
    macro(resolvePromiseWithFirstResolvingFunctionCallCheck, promiseOperationsResolvePromiseWithFirstResolvingFunctionCallCheck) \
    macro(resolveWithoutPromise, promiseOperationsResolveWithoutPromise) \
    macro(resolveWithoutPromiseForAsyncAwait, promiseOperationsResolveWithoutPromiseForAsyncAwait) \
    macro(setStateToMax, moduleLoaderSetStateToMax) \
    macro(speciesConstructor, globalOperationsSpeciesConstructor) \
    macro(stringConcatSlowPath, stringPrototypeStringConcatSlowPath) \
    macro(triggerPromiseReactions, promiseOperationsTriggerPromiseReactions) \
    macro(typedArraySpeciesConstructor, typedArrayPrototypeTypedArraySpeciesConstructor) \
    macro(wrapRemoteValue, shadowRealmPrototypeWrapRemoteValue) \
    macro(wrappedIterator, iteratorHelpersWrappedIterator) \

#define DECLARE_BUILTIN_GENERATOR(codeName, functionName, overriddenName, argumentCount) \
    JSC::FunctionExecutable* codeName##Generator(JSC::VM&);

JSC_FOREACH_BUILTIN_CODE(DECLARE_BUILTIN_GENERATOR)
#undef DECLARE_BUILTIN_GENERATOR

} // namespace JSC
