(function(){'use strict';const style=new CSSStyleSheet();style.replaceSync("body {\n  cursor: crosshair;\n}\n\n#zone {\n  background-color: #0003;\n  border: 1px solid #fffd;\n  display: none;\n  position: absolute;\n}\n");class Overlay{constructor(window,style=[]){this.viewportSize={width:800,height:600};this.deviceScaleFactor=1;this.emulationScaleFactor=1;this.pageScaleFactor=1;this.pageZoomFactor=1;this.scrollX=0;this.scrollY=0;this.canvasWidth=0;this.canvasHeight=0;this._window=window;this._document=window.document;if(!Array.isArray(style)){style=[style];}
this.style=style;}
setCanvas(canvas){this.canvas=canvas;this._context=canvas.getContext('2d');}
reset(resetData){if(resetData){this.viewportSize=resetData.viewportSize;this.deviceScaleFactor=resetData.deviceScaleFactor;this.pageScaleFactor=resetData.pageScaleFactor;this.pageZoomFactor=resetData.pageZoomFactor;this.emulationScaleFactor=resetData.emulationScaleFactor;this.scrollX=Math.round(resetData.scrollX);this.scrollY=Math.round(resetData.scrollY);}
this.resetCanvas();}
resetCanvas(){if(!this.canvas||!this._context){return;}
this.canvas.width=this.deviceScaleFactor*this.viewportSize.width;this.canvas.height=this.deviceScaleFactor*this.viewportSize.height;this.canvas.style.width=this.viewportSize.width+'px';this.canvas.style.height=this.viewportSize.height+'px';this._context.scale(this.deviceScaleFactor,this.deviceScaleFactor);this.canvasWidth=this.viewportSize.width;this.canvasHeight=this.viewportSize.height;}
setPlatform(platform){for(const style of this.style){adoptStyleSheet(style);}
this.platform=platform;this.document.body.classList.add('platform-'+platform);}
dispatch(message){const functionName=message.shift();this[functionName].apply(this,message);}
eventHasCtrlOrMeta(event){return this.platform==='mac'?(event.metaKey&&!event.ctrlKey):(event.ctrlKey&&!event.metaKey);}
get context(){if(!this._context){throw new Error('Context object is missing');}
return this._context;}
get document(){if(!this._document){throw new Error('Document object is missing');}
return this._document;}
get window(){if(!this._window){throw new Error('Window object is missing');}
return this._window;}}
function adoptStyleSheet(styleSheet){document.adoptedStyleSheets=[...document.adoptedStyleSheets,styleSheet];}
let anchor=null;let position=null;class ScreenshotOverlay extends Overlay{setPlatform(platform){super.setPlatform(platform);this.document.body.onload=this.loaded.bind(this);const zone=this.document.createElement('div');zone.id='zone';this.document.body.append(zone);this.zone=zone;}
loaded(){this.document.documentElement.addEventListener('mousedown',event=>{anchor={x:event.pageX,y:event.pageY};position=anchor;this.updateZone();event.stopPropagation();event.preventDefault();},true);this.document.documentElement.addEventListener('mouseup',event=>{if(anchor&&position){const rect=currentRect();if(rect.width>=5&&rect.height>=5){this.window.InspectorOverlayHost.send(JSON.stringify(rect));}}
cancel();this.updateZone();event.stopPropagation();event.preventDefault();},true);this.document.documentElement.addEventListener('mousemove',event=>{if(anchor&&event.buttons===1){position={x:event.pageX,y:event.pageY};}
else{anchor=null;}
this.updateZone();event.stopPropagation();event.preventDefault();},true);this.document.documentElement.addEventListener('keydown',event=>{if(anchor&&event.key==='Escape'){cancel();this.updateZone();event.stopPropagation();event.preventDefault();}},true);}
updateZone(){const zone=this.zone;if(!position||!anchor){zone.style.display='none';return;}
zone.style.display='block';const rect=currentRect();zone.style.left=rect.x+'px';zone.style.top=rect.y+'px';zone.style.width=rect.width+'px';zone.style.height=rect.height+'px';}}
function currentRect(){return{x:Math.min(anchor.x,position.x),y:Math.min(anchor.y,position.y),width:Math.abs(anchor.x-position.x),height:Math.abs(anchor.y-position.y),};}
function cancel(){anchor=null;position=null;}
const overlay=new ScreenshotOverlay(window,style);window.dispatch=message=>{overlay.dispatch(message);};}());