(function(){'use strict';const style=new CSSStyleSheet();style.replaceSync(":root {\n  --border-radius: 4px;\n}\n\n.source-order-label-container {\n  display: block;\n  min-width: 20px;\n  position: absolute;\n  text-align: center;\n  align-items: center;\n  background-color: white;\n  font-family: Menlo, Consolas, monospace;\n  font-size: 12px;\n  font-weight: bold;\n  padding: 2px;\n  border: 1.5px solid;\n}\n\n.top-corner {\n  border-bottom-right-radius: var(--border-radius);\n}\n\n.bottom-corner {\n  border-top-right-radius: var(--border-radius);\n}\n\n.above-element {\n  border-top-right-radius: var(--border-radius);\n  border-top-left-radius: var(--border-radius);\n}\n\n.below-element {\n  border-bottom-right-radius: var(--border-radius);\n  border-bottom-left-radius: var(--border-radius);\n}\n\n.above-element-wider {\n  border-top-right-radius: var(--border-radius);\n  border-top-left-radius: var(--border-radius);\n  border-bottom-right-radius: var(--border-radius);\n}\n\n.below-element-wider {\n  border-bottom-right-radius: var(--border-radius);\n  border-bottom-left-radius: var(--border-radius);\n  border-top-right-radius: var(--border-radius);\n}\n\n.bottom-corner-wider {\n  border-top-right-radius: var(--border-radius);\n  border-bottom-right-radius: var(--border-radius);\n}\n\n.bottom-corner-taller {\n  border-top-right-radius: var(--border-radius);\n  border-top-left-radius: var(--border-radius);\n}\n\n.bottom-corner-wider-taller {\n  border-top-left-radius: var(--border-radius);\n  border-top-right-radius: var(--border-radius);\n  border-bottom-right-radius: var(--border-radius);\n}\n");class Overlay{constructor(window,style=[]){this.viewportSize={width:800,height:600};this.deviceScaleFactor=1;this.emulationScaleFactor=1;this.pageScaleFactor=1;this.pageZoomFactor=1;this.scrollX=0;this.scrollY=0;this.canvasWidth=0;this.canvasHeight=0;this._window=window;this._document=window.document;if(!Array.isArray(style)){style=[style];}
this.style=style;}
setCanvas(canvas){this.canvas=canvas;this._context=canvas.getContext('2d');}
reset(resetData){if(resetData){this.viewportSize=resetData.viewportSize;this.deviceScaleFactor=resetData.deviceScaleFactor;this.pageScaleFactor=resetData.pageScaleFactor;this.pageZoomFactor=resetData.pageZoomFactor;this.emulationScaleFactor=resetData.emulationScaleFactor;this.scrollX=Math.round(resetData.scrollX);this.scrollY=Math.round(resetData.scrollY);}
this.resetCanvas();}
resetCanvas(){if(!this.canvas||!this._context){return;}
this.canvas.width=this.deviceScaleFactor*this.viewportSize.width;this.canvas.height=this.deviceScaleFactor*this.viewportSize.height;this.canvas.style.width=this.viewportSize.width+'px';this.canvas.style.height=this.viewportSize.height+'px';this._context.scale(this.deviceScaleFactor,this.deviceScaleFactor);this.canvasWidth=this.viewportSize.width;this.canvasHeight=this.viewportSize.height;}
setPlatform(platform){for(const style of this.style){adoptStyleSheet(style);}
this.platform=platform;this.document.body.classList.add('platform-'+platform);}
dispatch(message){const functionName=message.shift();this[functionName].apply(this,message);}
eventHasCtrlOrMeta(event){return this.platform==='mac'?(event.metaKey&&!event.ctrlKey):(event.ctrlKey&&!event.metaKey);}
get context(){if(!this._context){throw new Error('Context object is missing');}
return this._context;}
get document(){if(!this._document){throw new Error('Document object is missing');}
return this._document;}
get window(){if(!this._window){throw new Error('Window object is missing');}
return this._window;}}
function createChild(parent,tagName,className){const element=createElement(tagName,className);element.addEventListener('click',function(e){e.stopPropagation();},false);parent.appendChild(element);return element;}
function createElement(tagName,className){const element=document.createElement(tagName);if(className){element.className=className;}
return element;}
function adoptStyleSheet(styleSheet){document.adoptedStyleSheets=[...document.adoptedStyleSheets,styleSheet];}
function buildPath(commands,bounds,emulationScaleFactor){let commandsIndex=0;function extractPoints(count){const points=[];for(let i=0;i<count;++i){const x=Math.round(commands[commandsIndex++]*emulationScaleFactor);bounds.maxX=Math.max(bounds.maxX,x);bounds.minX=Math.min(bounds.minX,x);const y=Math.round(commands[commandsIndex++]*emulationScaleFactor);bounds.maxY=Math.max(bounds.maxY,y);bounds.minY=Math.min(bounds.minY,y);bounds.leftmostXForY[y]=Math.min(bounds.leftmostXForY[y]||Number.MAX_VALUE,x);bounds.rightmostXForY[y]=Math.max(bounds.rightmostXForY[y]||Number.MIN_VALUE,x);bounds.topmostYForX[x]=Math.min(bounds.topmostYForX[x]||Number.MAX_VALUE,y);bounds.bottommostYForX[x]=Math.max(bounds.bottommostYForX[x]||Number.MIN_VALUE,y);bounds.allPoints.push({x,y});points.push(x,y);}
return points;}
const commandsLength=commands.length;const path=new Path2D();while(commandsIndex<commandsLength){switch(commands[commandsIndex++]){case'M':path.moveTo.apply(path,extractPoints(1));break;case'L':path.lineTo.apply(path,extractPoints(1));break;case'C':path.bezierCurveTo.apply(path,extractPoints(3));break;case'Q':path.quadraticCurveTo.apply(path,extractPoints(2));break;case'Z':path.closePath();break;}}
return path;}
function emptyBounds(){const bounds={minX:Number.MAX_VALUE,minY:Number.MAX_VALUE,maxX:Number.MIN_VALUE,maxY:Number.MIN_VALUE,leftmostXForY:{},rightmostXForY:{},topmostYForX:{},bottommostYForX:{},allPoints:[],};return bounds;}
class SourceOrderOverlay extends Overlay{constructor(){super(...arguments);this.sourceOrderContainer=document.createElement('div');}
reset(resetData){super.reset(resetData);if(this.sourceOrderContainer){this.sourceOrderContainer.textContent='';}}
setPlatform(platform){super.setPlatform(platform);this.document.body.classList.add('fill');const canvas=this.document.createElement('canvas');canvas.id='canvas';canvas.classList.add('fill');this.document.body.append(canvas);const sourceOrderContainer=this.document.createElement('div');sourceOrderContainer.id='source-order-container';this.document.body.append(sourceOrderContainer);this.sourceOrderContainer=sourceOrderContainer;this.setCanvas(canvas);}
drawSourceOrder(highlight){const sourceOrder=highlight.sourceOrder||0;const path=highlight.paths.slice().pop();if(!path){throw new Error('No path provided');}
this.context.save();const bounds=emptyBounds();const outlineColor=path.outlineColor;this.context.save();_drawPath(this.context,path.path,outlineColor,!!sourceOrder,bounds,this.emulationScaleFactor);this.context.restore();this.context.save();if(!!sourceOrder){this._drawSourceOrderLabel(sourceOrder,outlineColor,bounds);}
this.context.restore();return{bounds:bounds};}
_drawSourceOrderLabel(sourceOrder,color,bounds){const sourceOrderContainer=this.sourceOrderContainer;const otherLabels=sourceOrderContainer.children;const labelContainer=createChild(sourceOrderContainer,'div','source-order-label-container');labelContainer.style.color=color;labelContainer.textContent=String(sourceOrder);const labelHeight=labelContainer.offsetHeight;const labelWidth=labelContainer.offsetWidth;const labelType=_getLabelType(bounds,labelHeight,labelWidth,otherLabels,this.canvasHeight);const labelPosition=_getPositionFromLabelType(labelType,bounds,labelHeight);labelContainer.classList.add(labelType);labelContainer.style.top=labelPosition.contentTop+'px';labelContainer.style.left=labelPosition.contentLeft+'px';}}
const MAX_CHILD_ELEMENTS_THRESHOLD=300;const LabelTypes={topCorner:'top-corner',aboveElement:'above-element',belowElement:'below-element',aboveElementWider:'above-element-wider',belowElementWider:'below-element-wider',bottomCornerWider:'bottom-corner-wider',bottomCornerTaller:'bottom-corner-taller',bottomCornerWiderTaller:'bottom-corner-wider-taller',};function _getPositionFromLabelType(positionType,bounds,labelHeight){let contentTop=0;switch(positionType){case LabelTypes.topCorner:contentTop=bounds.minY;break;case LabelTypes.aboveElement:case LabelTypes.aboveElementWider:contentTop=bounds.minY-labelHeight;break;case LabelTypes.belowElement:case LabelTypes.belowElementWider:contentTop=bounds.maxY;break;case LabelTypes.bottomCornerWider:case LabelTypes.bottomCornerTaller:case LabelTypes.bottomCornerWiderTaller:contentTop=bounds.maxY-labelHeight;break;}
return{contentTop,contentLeft:bounds.minX,};}
function _getLabelType(bounds,labelHeight,labelWidth,otherLabels,canvasHeight){let labelType;const widerThanElement=bounds.minX+labelWidth>bounds.maxX;const tallerThanElement=bounds.minY+labelHeight>bounds.maxY;if((!widerThanElement&&!tallerThanElement)||otherLabels.length>=MAX_CHILD_ELEMENTS_THRESHOLD){return LabelTypes.topCorner;}
let overlaps=false;for(let i=0;i<otherLabels.length;i++){const currentLabel=otherLabels[i];const rect=currentLabel.getBoundingClientRect();if(currentLabel.style.top===''&&currentLabel.style.left===''){continue;}
const topOverlaps=bounds.minY-labelHeight<=rect.top+rect.height&&bounds.minY-labelHeight>=rect.top;const bottomOverlaps=bounds.minY<=rect.top+rect.height&&bounds.minY>=rect.top;const leftOverlaps=bounds.minX>=rect.left&&bounds.minX<=rect.left+rect.width;const rightOverlaps=bounds.minX+labelWidth>=rect.left&&bounds.minX+labelWidth<=rect.left+rect.width;const sideOverlaps=leftOverlaps||rightOverlaps;if(sideOverlaps&&(topOverlaps||bottomOverlaps)){overlaps=true;break;}}
if(bounds.minY-labelHeight>0&&!overlaps){labelType=LabelTypes.aboveElement;if(widerThanElement){labelType=LabelTypes.aboveElementWider;}}
else if(bounds.maxY+labelHeight<canvasHeight){labelType=LabelTypes.belowElement;if(widerThanElement){labelType=LabelTypes.belowElementWider;}}
else{if(widerThanElement&&tallerThanElement){labelType=LabelTypes.bottomCornerWiderTaller;}
else if(widerThanElement){labelType=LabelTypes.bottomCornerWider;}
else{labelType=LabelTypes.bottomCornerTaller;}}
return labelType;}
function _drawPath(context,commands,outlineColor,isChild,bounds,emulationScaleFactor){context.save();const path=buildPath(commands,bounds,emulationScaleFactor);if(outlineColor){context.strokeStyle=outlineColor;context.lineWidth=2;if(!isChild){context.setLineDash([3,3]);}
context.stroke(path);}
context.restore();return path;}
const overlay=new SourceOrderOverlay(window,style);window.dispatch=message=>{overlay.dispatch(message);};}());