import qbs 1.0
import qbs.File
import qbs.FileInfo
import qbs.Environment

Project {
    Product {
        name: "KSyntaxHighlighting"

        Export {
            Depends { name: "qtc" }
            Depends {
                name: "Qt.KSyntaxHighlighting"
                condition: qtc.preferSystemSyntaxHighlighting
                required: false
            }
            Depends {
                name: "KSyntaxHighlighting_bundled"
                required: !qtc.preferSystemSyntaxHighlighting
            }
        }
    }

    QtcLibrary {
        name: "KSyntaxHighlighting_bundled"
        condition: !qtc.preferSystemSyntaxHighlighting || !Qt.KSyntaxHighlighting.present

        cpp.defines: base.concat("KSYNTAXHIGHLIGHTING_LIBRARY")
        cpp.includePaths: [
            product.sourceDirectory + "/src/lib/",
            product.sourceDirectory + "/autogenerated/src/lib/",
            product.sourceDirectory + "/autogenerated/"
        ]

        Depends { name: "Qt.gui" }
        Depends { name: "Qt.network" }
        Depends {
            name: "Qt.KSyntaxHighlighting"
            condition: qtc.preferSystemSyntaxHighlighting
            required: false
        }

        Group {
            name: "lib"
            prefix: "src/lib/"
            files: [
                "*.h",
                "*.cpp"
            ]
        }

        Group {
            name: "KSyntaxHighlighting data"
            qbs.install: true
            qbs.installDir: qtc.ide_data_path + "/generic-highlighter/"
            qbs.installSourceBase: project.ide_source_tree + "/src/libs/3rdparty/syntax-highlighting/data/"
            prefix: project.ide_source_tree + "/src/libs/3rdparty/syntax-highlighting/data/"
            files: [
                "syntax/**/*"
            ]
        }

        Group {
            name: "autogenerated lib"
            prefix: "autogenerated/src/lib/"
            files: [
                "*.h",
                "*.cpp"
            ]
        }

        Group {
            name: "theme data"
            prefix: "data/themes/"
            files: [ "theme-data.qrc" ]
        }

        Export {
            Depends { name: "cpp" }
            cpp.includePaths: [
                exportingProduct.sourceDirectory + "/src/lib/",
                exportingProduct.sourceDirectory + "/autogenerated/src/lib/",
            ]
        }
    }
}
