/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.io;

import edu.cornell.med.icb.util.ICBStringUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import org.apache.commons.lang.StringUtils;

public final class TSVReader
implements Closeable {
    private final BufferedReader bufferedReader;
    private String currentLine;
    private static final char ESCAPE_CHAR_DEFAULT = '\\';
    private String[] currentTokens;
    private int currentTokenIndex;
    private final char delimiter;
    private String commentPrefix;
    private Character escapeChar = Character.valueOf('\\');
    private boolean unescapeResults = true;

    public TSVReader(Reader reader) {
        this(reader, '\t');
    }

    public TSVReader(Reader reader, char delimiterVal) {
        this.bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        this.delimiter = delimiterVal;
        this.commentPrefix = "#";
    }

    public TSVReader setCommentPrefix(String commentPrefixVal) {
        this.commentPrefix = StringUtils.isBlank((String)commentPrefixVal) ? null : commentPrefixVal.trim();
        return this;
    }

    public String getCommentPrefix() {
        return this.commentPrefix;
    }

    public TSVReader setEscapeChar(Character escapeCharVal) {
        this.escapeChar = escapeCharVal;
        return this;
    }

    public Character getEscapeChar() {
        return this.escapeChar;
    }

    public TSVReader setUnescapeResults(boolean unescapeResultsVal) {
        this.unescapeResults = unescapeResultsVal;
        return this;
    }

    public boolean getUnescapeResults() {
        return this.unescapeResults;
    }

    public boolean hasNext() throws IOException {
        if (this.currentLine != null) {
            return true;
        }
        this.currentLine = this.bufferedReader.readLine();
        if (this.currentLine == null) {
            this.currentTokens = null;
            return false;
        }
        return true;
    }

    public boolean isCommentLine() {
        return !StringUtils.isBlank((String)this.commentPrefix) && this.currentLine.startsWith(this.commentPrefix);
    }

    public void skip() {
        this.currentTokenIndex = 0;
        this.currentLine = null;
    }

    public void next() {
        this.currentTokens = ICBStringUtils.split(this.currentLine, this.delimiter, this.escapeChar);
        if (this.unescapeResults) {
            this.currentTokens = ICBStringUtils.unescape(this.currentTokens, this.escapeChar);
        }
        this.currentTokenIndex = 0;
        this.currentLine = null;
    }

    public int getInt() {
        this.ensureNextField();
        return Integer.parseInt(this.currentTokens[this.currentTokenIndex++]);
    }

    public long getLong() {
        this.ensureNextField();
        return Long.parseLong(this.currentTokens[this.currentTokenIndex++]);
    }

    public float getFloat() {
        this.ensureNextField();
        return Float.parseFloat(this.currentTokens[this.currentTokenIndex++]);
    }

    public double getDouble() {
        this.ensureNextField();
        return Double.parseDouble(this.currentTokens[this.currentTokenIndex++]);
    }

    public String getString() {
        this.ensureNextField();
        return this.currentTokens[this.currentTokenIndex++];
    }

    private void ensureNextField() {
        if (this.currentTokens == null || this.currentTokenIndex >= this.currentTokens.length) {
            throw new NoSuchElementException();
        }
    }

    public int numTokens() {
        return this.currentTokens.length;
    }

    public boolean isEmptyLine() {
        return StringUtils.isBlank((String)this.currentLine);
    }

    @Override
    public void close() throws IOException {
        this.bufferedReader.close();
        this.currentLine = null;
        this.currentTokens = null;
    }
}

