/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.plus.internal.model.people.PersonEntity;
import com.google.android.gms.plus.model.people.Person;
import java.util.ArrayList;
import java.util.List;

public final class PlusShare {
    public static final String EXTRA_CONTENT_URL = "com.google.android.apps.plus.CONTENT_URL";
    public static final String EXTRA_CONTENT_DEEP_LINK_ID = "com.google.android.apps.plus.CONTENT_DEEP_LINK_ID";
    public static final String EXTRA_CONTENT_DEEP_LINK_METADATA = "com.google.android.apps.plus.CONTENT_DEEP_LINK_METADATA";
    public static final String KEY_CONTENT_DEEP_LINK_METADATA_TITLE = "title";
    public static final String KEY_CONTENT_DEEP_LINK_METADATA_DESCRIPTION = "description";
    public static final String KEY_CONTENT_DEEP_LINK_METADATA_THUMBNAIL_URL = "thumbnailUrl";
    public static final String EXTRA_IS_INTERACTIVE_POST = "com.google.android.apps.plus.GOOGLE_INTERACTIVE_POST";
    public static final String EXTRA_CALL_TO_ACTION = "com.google.android.apps.plus.CALL_TO_ACTION";
    public static final String KEY_CALL_TO_ACTION_LABEL = "label";
    public static final String KEY_CALL_TO_ACTION_URL = "url";
    public static final String KEY_CALL_TO_ACTION_DEEP_LINK_ID = "deepLinkId";
    public static final String EXTRA_SENDER_ID = "com.google.android.apps.plus.SENDER_ID";
    public static final String PARAM_CONTENT_DEEP_LINK_ID = "deep_link_id";

    @Deprecated
    protected PlusShare() {
        throw new AssertionError();
    }

    public static String getDeepLinkId(Intent intent) {
        String string2 = null;
        if (intent != null && intent.getData() != null) {
            string2 = intent.getData().getQueryParameter(PARAM_CONTENT_DEEP_LINK_ID);
        }
        return string2;
    }

    public static Bundle zza(String string2, String string3, Uri uri) {
        Bundle bundle = new Bundle();
        bundle.putString(KEY_CONTENT_DEEP_LINK_METADATA_TITLE, string2);
        bundle.putString(KEY_CONTENT_DEEP_LINK_METADATA_DESCRIPTION, string3);
        if (uri != null) {
            bundle.putString(KEY_CONTENT_DEEP_LINK_METADATA_THUMBNAIL_URL, uri.toString());
        }
        return bundle;
    }

    public static Person createPerson(String id2, String displayName) {
        if (TextUtils.isEmpty((CharSequence)id2)) {
            throw new IllegalArgumentException("MinimalPerson ID must not be empty.");
        }
        if (TextUtils.isEmpty((CharSequence)displayName)) {
            throw new IllegalArgumentException("Display name must not be empty.");
        }
        return new PersonEntity(displayName, id2, null, 0, null);
    }

    protected static boolean zzdU(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            Log.e((String)"GooglePlusPlatform", (String)"The provided deep-link ID is empty.");
            return false;
        }
        if (string2.contains(" ")) {
            Log.e((String)"GooglePlusPlatform", (String)"Spaces are not allowed in deep-link IDs.");
            return false;
        }
        return true;
    }

    public static class Builder {
        private final Context mContext;
        private final Intent mIntent;
        private boolean zzaHj;
        private ArrayList<Uri> zzaHk;

        public Builder(Context context) {
            this.mContext = context;
            this.mIntent = new Intent().setAction("android.intent.action.SEND");
        }

        public Builder(Activity launchingActivity) {
            this.mContext = launchingActivity;
            this.mIntent = new Intent().setAction("android.intent.action.SEND");
            this.mIntent.addFlags(524288);
            if (launchingActivity != null && launchingActivity.getComponentName() != null) {
                this.zzaHj = true;
            }
        }

        public Builder setType(String mimeType) {
            this.mIntent.setType(mimeType);
            return this;
        }

        public Builder setRecipients(Person user, List<Person> recipientList) {
            int n;
            this.mIntent.putExtra(PlusShare.EXTRA_SENDER_ID, user != null ? user.getId() : "0");
            int n2 = n = recipientList != null ? recipientList.size() : 0;
            if (n == 0) {
                this.mIntent.removeExtra("com.google.android.apps.plus.RECIPIENT_IDS");
                this.mIntent.removeExtra("com.google.android.apps.plus.RECIPIENT_DISPLAY_NAMES");
                return this;
            }
            ArrayList<String> arrayList = new ArrayList<String>(n);
            ArrayList<String> arrayList2 = new ArrayList<String>(n);
            for (Person person : recipientList) {
                arrayList.add(person.getId());
                arrayList2.add(person.getDisplayName());
            }
            this.mIntent.putStringArrayListExtra("com.google.android.apps.plus.RECIPIENT_IDS", arrayList);
            this.mIntent.putStringArrayListExtra("com.google.android.apps.plus.RECIPIENT_DISPLAY_NAMES", arrayList2);
            return this;
        }

        public Builder setText(CharSequence text) {
            this.mIntent.putExtra("android.intent.extra.TEXT", text);
            return this;
        }

        public Builder setStream(Uri streamUri) {
            this.zzaHk = null;
            this.mIntent.putExtra("android.intent.extra.STREAM", (Parcelable)streamUri);
            return this;
        }

        public Builder addStream(Uri streamUri) {
            Uri uri = (Uri)this.mIntent.getParcelableExtra("android.intent.extra.STREAM");
            if (uri == null) {
                return this.setStream(streamUri);
            }
            if (this.zzaHk == null) {
                this.zzaHk = new ArrayList();
            }
            this.zzaHk.add(uri);
            this.zzaHk.add(streamUri);
            return this;
        }

        public Builder setContentUrl(Uri uri) {
            String string2 = null;
            if (uri != null) {
                string2 = uri.toString();
            }
            if (TextUtils.isEmpty(string2)) {
                this.mIntent.removeExtra(PlusShare.EXTRA_CONTENT_URL);
            } else {
                this.mIntent.putExtra(PlusShare.EXTRA_CONTENT_URL, string2);
            }
            return this;
        }

        public Builder setContentDeepLinkId(String deepLinkId) {
            return this.setContentDeepLinkId(deepLinkId, null, null, null);
        }

        public Builder setContentDeepLinkId(String deepLinkId, String title, String description, Uri thumbnailUri) {
            zzu.zzb(this.zzaHj, (Object)"Must include the launching activity with PlusShare.Builder constructor before setting deep links");
            zzu.zzb(!TextUtils.isEmpty((CharSequence)deepLinkId), (Object)"The deepLinkId parameter is required.");
            Bundle bundle = PlusShare.zza(title, description, thumbnailUri);
            this.mIntent.putExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_ID, deepLinkId);
            this.mIntent.putExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_METADATA, bundle);
            this.mIntent.setType("text/plain");
            return this;
        }

        public Builder addCallToAction(String label, Uri uri, String deepLinkId) {
            zzu.zza(this.zzaHj, (Object)"Must include the launching activity with PlusShare.Builder constructor before setting call-to-action");
            zzu.zzb(uri != null && !TextUtils.isEmpty((CharSequence)uri.toString()), (Object)"Must provide a call to action URL");
            Bundle bundle = new Bundle();
            if (!TextUtils.isEmpty((CharSequence)label)) {
                bundle.putString(PlusShare.KEY_CALL_TO_ACTION_LABEL, label);
            }
            bundle.putString(PlusShare.KEY_CALL_TO_ACTION_URL, uri.toString());
            if (!TextUtils.isEmpty((CharSequence)deepLinkId)) {
                zzu.zza(PlusShare.zzdU(deepLinkId), (Object)"The specified deep-link ID was malformed.");
                bundle.putString(PlusShare.KEY_CALL_TO_ACTION_DEEP_LINK_ID, deepLinkId);
            }
            this.mIntent.putExtra(PlusShare.EXTRA_CALL_TO_ACTION, bundle);
            this.mIntent.putExtra(PlusShare.EXTRA_IS_INTERACTIVE_POST, true);
            this.mIntent.setType("text/plain");
            return this;
        }

        public Intent getIntent() {
            boolean bl = this.zzaHk != null && this.zzaHk.size() > 1;
            boolean bl2 = "android.intent.action.SEND_MULTIPLE".equals(this.mIntent.getAction());
            boolean bl3 = this.mIntent.getBooleanExtra(PlusShare.EXTRA_IS_INTERACTIVE_POST, false);
            zzu.zza(!bl || !bl3, (Object)"Call-to-action buttons are only available for URLs.");
            zzu.zza(!bl3 || this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_URL), (Object)"The content URL is required for interactive posts.");
            zzu.zza(!bl3 || this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_URL) || this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_ID), (Object)"Must set content URL or content deep-link ID to use a call-to-action button.");
            if (this.mIntent.hasExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_ID)) {
                zzu.zza(PlusShare.zzdU(this.mIntent.getStringExtra(PlusShare.EXTRA_CONTENT_DEEP_LINK_ID)), (Object)"The specified deep-link ID was malformed.");
            }
            if (!bl && bl2) {
                this.mIntent.setAction("android.intent.action.SEND");
                if (this.zzaHk != null && !this.zzaHk.isEmpty()) {
                    this.mIntent.putExtra("android.intent.extra.STREAM", (Parcelable)this.zzaHk.get(0));
                } else {
                    this.mIntent.removeExtra("android.intent.extra.STREAM");
                }
                this.zzaHk = null;
            }
            if (bl && !bl2) {
                this.mIntent.setAction("android.intent.action.SEND_MULTIPLE");
                if (this.zzaHk != null && !this.zzaHk.isEmpty()) {
                    this.mIntent.putParcelableArrayListExtra("android.intent.extra.STREAM", this.zzaHk);
                } else {
                    this.mIntent.removeExtra("android.intent.extra.STREAM");
                }
            }
            if ("com.google.android.gms.plus.action.SHARE_INTERNAL_GOOGLE".equals(this.mIntent.getAction())) {
                this.mIntent.setPackage("com.google.android.gms");
                return this.mIntent;
            }
            if (!this.mIntent.hasExtra("android.intent.extra.STREAM")) {
                this.mIntent.setAction("com.google.android.gms.plus.action.SHARE_GOOGLE");
                this.mIntent.setPackage("com.google.android.gms");
                return this.mIntent;
            }
            this.mIntent.setPackage("com.google.android.apps.plus");
            return this.mIntent;
        }
    }
}

