/* Rawkey -> ARCH_KEY translation table  Chris Young
  This maps Amiga rawkey codes to their Archimedes equvalents,
  by position.  If any of the keys do not match your keymap,
  they should be modified within RISC OS - it is not the job
  of ArcEm to translate keys.
*/


arch_key_id amirawkey[] = {
ARCH_KEY_grave,
ARCH_KEY_1,
ARCH_KEY_2,
ARCH_KEY_3,
ARCH_KEY_4,
ARCH_KEY_5,
ARCH_KEY_6,
ARCH_KEY_7,
ARCH_KEY_8,
ARCH_KEY_9,
ARCH_KEY_0,
ARCH_KEY_minus,
ARCH_KEY_equal,
ARCH_KEY_backslash,
-1, // 0E
ARCH_KEY_kp_0,
ARCH_KEY_q,
ARCH_KEY_w,
ARCH_KEY_e,
ARCH_KEY_r,
ARCH_KEY_t,
ARCH_KEY_y,
ARCH_KEY_u,
ARCH_KEY_i,
ARCH_KEY_o,
ARCH_KEY_p,
ARCH_KEY_bracket_l,
ARCH_KEY_bracket_r,
-1, // 1C
ARCH_KEY_kp_1,
ARCH_KEY_kp_2,
ARCH_KEY_kp_3,
ARCH_KEY_a,
ARCH_KEY_s,
ARCH_KEY_d,
ARCH_KEY_f,
ARCH_KEY_g,
ARCH_KEY_h,
ARCH_KEY_j,
ARCH_KEY_k,
ARCH_KEY_l,
ARCH_KEY_semicolon,
ARCH_KEY_apostrophe,
ARCH_KEY_sterling,
-1, // 2C
ARCH_KEY_kp_4,
ARCH_KEY_kp_5,
ARCH_KEY_kp_6,
ARCH_KEY_backslash,
ARCH_KEY_z,
ARCH_KEY_x,
ARCH_KEY_c,
ARCH_KEY_v,
ARCH_KEY_b,
ARCH_KEY_n,
ARCH_KEY_m,
ARCH_KEY_comma,
ARCH_KEY_period,
ARCH_KEY_slash,
-1, // 3B (Brazil ABNT keyboard only)
ARCH_KEY_kp_decimal,
ARCH_KEY_kp_7,
ARCH_KEY_kp_8,
ARCH_KEY_kp_9,
ARCH_KEY_space, //40
ARCH_KEY_backspace,
ARCH_KEY_tab,
ARCH_KEY_kp_enter,
ARCH_KEY_return,
ARCH_KEY_escape,
ARCH_KEY_delete,
ARCH_KEY_insert,
ARCH_KEY_page_up,
ARCH_KEY_page_down,
ARCH_KEY_kp_minus,
ARCH_KEY_f11,
ARCH_KEY_up,
ARCH_KEY_down,
ARCH_KEY_right,
ARCH_KEY_left,
ARCH_KEY_f1,
ARCH_KEY_f2,
ARCH_KEY_f3,
ARCH_KEY_f4,
ARCH_KEY_f5,
ARCH_KEY_f6,
ARCH_KEY_f7,
ARCH_KEY_f8,
ARCH_KEY_f9,
ARCH_KEY_f10,
ARCH_KEY_num_lock,
ARCH_KEY_kp_slash,
ARCH_KEY_kp_star,
ARCH_KEY_kp_hash,
ARCH_KEY_kp_plus,
ARCH_KEY_scroll_lock, // HELP - mapped to scroll lock on PC keyboards
ARCH_KEY_shift_l,
ARCH_KEY_shift_r,
ARCH_KEY_caps_lock,
ARCH_KEY_control_l, // also control_r
ARCH_KEY_alt_l,
ARCH_KEY_alt_r,
-1, // lamiga
-1, // ramiga
-1, // 68
-1, // 69
-1, // 6A
ARCH_KEY_control_r, // menu 6B
-1, // 6C (Brazil ABNT keyboard only)
ARCH_KEY_print,
ARCH_KEY_break,
ARCH_KEY_f12,
ARCH_KEY_home,
ARCH_KEY_copy, // actually end
};
