10 PRINT "PROGRAM FILE 133: CHI-SQUARE UNIFORMITY TEST FOR"
15 PRINT "        RND FUNCTION."
20 PRINT "    ANSI STANDARD 8.4"
30 PRINT
40 PRINT "SECTION 133.1: CHI-SQUARE UNIFORMITY TEST FOR"
50 PRINT "        RND FUNCTION."
55 PRINT
60 PRINT "THIS PROGRAM RUNS A SERIES OF 60 EXPERIMENTS OF 1040 SAMPLES"
70 PRINT "TO DETERMINE IF THE RANDOM NUMBERS ARE EQUALLY DISTRIBUTED"
80 PRINT "AMONG 21 EQUAL-SIZE INTERVALS BETWEEN 0 AND 1.  CHI-SQUARE"
90 PRINT "IS COMPUTED AND DISPLAYED FOR EACH OF THESE EXPERIMENTS."
100 PRINT "EACH CHI-SQUARE RESULT IS CATEGORIZED ACCORDING TO THE"
110 PRINT "PERCENTILE RANGE INTO WHICH ITS VALUE FALLS:"
120 PRINT
130 PRINT "CATEGORY     % RANGE                CATEGORY    % RANGE"
140 PRINT "    1          0-1                      6        50-75"
150 PRINT "    2          1-5                      7        75-90"
160 PRINT "    3          5-10                     8        90-95"
170 PRINT "    4         10-25                     9        95-99"
180 PRINT "    5         25-50                    10        99-100"
190 PRINT
200 PRINT "THESE CATEGORICAL RESULTS ARE THEN EVALUATED AGAIN USING"
210 PRINT "CHI-SQUARE (THE FIRST AND LAST THREE CATEGORIES ARE EACH"
220 PRINT "CONSOLIDATED INTO ONE), AND IF THE DISTRIBUTION AMONG"
230 PRINT "CATEGORIES IS SUFFICIENTLY IMPROBABLE (TOP OR BOTTOM 5%),"
240 PRINT "THE TEST FAILS."
250 PRINT
260 PRINT "                    BEGIN TEST"
270 PRINT
280 REM SET #TRIALS PER EXPERIMENT
290 LET P1=1050
300 DIM Y(21)
310 PRINT "EXPERIMENT","CHI-SQUARE","CATEGORY"
320 PRINT
330 REM PERFORM 60 EXPERIMENTS OF 1050 SAMPLES EACH
340 REM OF PSEUDO-RANDOM NUMBERS THEN COMPUTE
350 REM AND TEST CHI-SQ STATISTIC FOR EACH EXPERIMENT.
360 REM BELOW ARE CHI-SQ VALUES FOR 20 DEGREES OF FREEDOM FOR
370 REM PERCENTAGES 1,5,10,25,50,75,90,95,99, AND 100
380 LET L(1)=8.26040
390 LET L(2)=10.8508
400 LET L(3)=12.4426
410 LET L(4)=15.4518
420 LET L(5)=19.3374
430 LET L(6)=23.8277
440 LET L(7)=28.4120
450 LET L(8)=31.4104
460 LET L(9)=37.5662
470 LET L(10)=1E38
480 REM ZERO OUT CATEGORY COUNTS
490 FOR C=1 TO 10
500 LET Z(C)=0
510 NEXT C
520 REM DO 60 EXPERIMENTS, SO EXPECTED NUMBER FOR EACH GLOBAL
530 REM CATEGORY IS >= 5
540 FOR E=1 TO 60
550 REM INITIALIZE OBSERVED COUNTS AT 0 FOR A PARTITION OF THE
560 REM UNIT INTERVAL INTO 21 CELLS
570 FOR I = 1 TO 21
580 LET Y(I) = 0
590 NEXT I
600 REM OBTAIN FREQUENCY COUNTS FOR 1050 RANDOM NUMBERS
610 FOR I=1 TO P1
620 LET X = RND
630 LET R = INT(21*X) + 1
640 LET Y(R) = Y(R) + 1
650 NEXT I
660 REM COMPUTE CHI-SQ STATISTIC FOR EACH EXPERIMENT
670 LET S = 0
680 FOR I = 1 TO 21
690 LET S = S + (21*Y(I)*Y(I))
700 NEXT I
710 LET V1=(S/P1) - P1
720 REM TEST CHI-SQ STATISTIC FOR EACH EXPERIMENT
730 FOR C=1 TO 10
740 IF V1<L(C) THEN 760
750 NEXT C
760 LET Z(C)=Z(C)+1
770 REM PRINT EVALUATION
780 PRINT E,V1,C
790 NEXT E
800 PRINT
810 PRINT
820 PRINT
830 PRINT "SUMMARY EVALUATION STATISTICS"
840 PRINT
850 PRINT ,"ACTUAL","EXPECTED"
860 PRINT "CATEGORY","COUNT","COUNT"
870 LET T5=60
880 LET T(1)=.01*T5
890 LET T(2)=.04*T5
900 LET T(3)=.05*T5
910 LET T(4)=.15*T5
920 LET T(5)=.25*T5
930 LET T(6)=.25*T5
940 LET T(7)=.15*T5
950 LET T(8)=.05*T5
960 LET T(9)=.04*T5
970 LET T(10)=.01*T5
980 FOR C=1 TO 10
990 PRINT C,Z(C),T(C)
1000 NEXT C
1010 PRINT
1020 LET Y(1)=Z(1)+Z(2)+Z(3)
1030 LET Y(2)=Z(4)
1040 LET Y(3)=Z(5)
1050 LET Y(4)=Z(6)
1060 LET Y(5)=Z(7)
1070 LET Y(6)=Z(8)+Z(9)+Z(10)
1080 REM DO CHI-SQ ON CHI-SQ STATS FROM PRIMARY DATA - EXPECT
1090 REM DISTRIBUTION OF:
1100 REM  6 = 60*(.01+.04+.05)
1110 REM  9 = 60*.15
1120 REM 15 = 60*.25
1130 REM 15 = 60*.25
1140 REM  9 = 60*.15
1150 REM  6 = 60*(.05+.04+.01)
1160 LET F(1)=.1
1170 LET F(2)=.15
1180 LET F(3)=.25
1190 LET F(4)=.25
1200 LET F(5)=.15
1210 LET F(6)=.1
1220 LET S=0
1230 FOR I=1 TO 6
1240 LET W=(Y(I)*Y(I))/F(I)
1250 LET S=S+W
1260 NEXT I
1270 LET V1=(S/60)-60
1280 REM FOR 5 D.F., CHI-SQ CUTOFFS FOR EXTREMES OF 5% ARE 1.145476
1290 REM AND 11.0705
1300 PRINT
1310 PRINT "WILL CONSOLIDATE CATEGORIES 1-3 AND 8-10, SO THAT"
1320 PRINT "EXPECTED VALUE IN EACH IS >= 5, AS REQUIRED BY"
1330 PRINT "CHI-SQUARE TEST."
1340 PRINT
1350 PRINT "FOR FIVE D.F., SHOULD HAVE 1.145476 <= CHI-SQ <= 11.0705"
1360 PRINT "(5% TAIL AT EACH END.)"
1370 PRINT
1380 PRINT "ACTUAL CHI-SQ = ";V1
1390 PRINT
1400 IF V1<1.145476 THEN 1440
1410 IF V1>11.0705 THEN 1440
1420 PRINT " ***  TEST PASSED  *** "
1430 GOTO 1450
1440 PRINT " ***  TEST FAILED  *** "
1450 PRINT
1460 PRINT "                    END TEST"
1470 PRINT
1480 PRINT "END PROGRAM 133"
1490 END
