/*
 * Decompiled with CFR 0.152.
 */
package org.benf.cfr.reader.bytecode.analysis.types;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.benf.cfr.reader.bytecode.analysis.parse.Expression;
import org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression;
import org.benf.cfr.reader.bytecode.analysis.parse.lvalue.LocalVariable;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.SSAIdent;
import org.benf.cfr.reader.bytecode.analysis.parse.utils.SSAIdentifierFactory;
import org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer;
import org.benf.cfr.reader.bytecode.analysis.types.FormalTypeParameter;
import org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder;
import org.benf.cfr.reader.bytecode.analysis.types.JavaArrayTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaGenericBaseInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.JavaWildcardTypeInstance;
import org.benf.cfr.reader.bytecode.analysis.types.MethodPrototypeAnnotationsHelper;
import org.benf.cfr.reader.bytecode.analysis.types.RawJavaType;
import org.benf.cfr.reader.bytecode.analysis.types.TypeConstants;
import org.benf.cfr.reader.bytecode.analysis.types.discovery.InferredJavaType;
import org.benf.cfr.reader.bytecode.analysis.variables.Ident;
import org.benf.cfr.reader.bytecode.analysis.variables.Slot;
import org.benf.cfr.reader.bytecode.analysis.variables.VariableNamer;
import org.benf.cfr.reader.entities.ClassFile;
import org.benf.cfr.reader.entities.Method;
import org.benf.cfr.reader.state.TypeUsageCollector;
import org.benf.cfr.reader.util.ConfusedCFRException;
import org.benf.cfr.reader.util.DecompilerComment;
import org.benf.cfr.reader.util.DecompilerComments;
import org.benf.cfr.reader.util.ListFactory;
import org.benf.cfr.reader.util.MapFactory;
import org.benf.cfr.reader.util.SetFactory;
import org.benf.cfr.reader.util.StringUtils;
import org.benf.cfr.reader.util.TypeUsageCollectable;
import org.benf.cfr.reader.util.annotation.Nullable;
import org.benf.cfr.reader.util.output.Dumper;

public class MethodPrototype
implements TypeUsageCollectable {
    private final List<FormalTypeParameter> formalTypeParameters;
    private final List<JavaTypeInstance> args;
    private final Set<Integer> hidden = SetFactory.newSet();
    private boolean innerOuterThis = false;
    private JavaTypeInstance result;
    private final VariableNamer variableNamer;
    private final boolean instanceMethod;
    private final boolean varargs;
    private final String name;
    @Nullable
    private String fixedName;
    private final ClassFile classFile;
    private final List<Slot> syntheticArgs = ListFactory.newList();
    private transient List<LocalVariable> parameterLValues = null;

    public MethodPrototype(ClassFile classFile, JavaTypeInstance classType, String name, boolean instanceMethod, Method.MethodConstructor constructorFlag, List<FormalTypeParameter> formalTypeParameters, List<JavaTypeInstance> args, JavaTypeInstance result, boolean varargs, VariableNamer variableNamer, boolean synthetic) {
        this.formalTypeParameters = formalTypeParameters;
        this.instanceMethod = instanceMethod;
        if (constructorFlag.equals((Object)Method.MethodConstructor.ENUM_CONSTRUCTOR) && !synthetic) {
            List args2 = ListFactory.newList();
            args2.add(TypeConstants.STRING);
            args2.add(RawJavaType.INT);
            args2.addAll(args);
            this.hide(0);
            this.hide(1);
            args = args2;
        }
        this.args = args;
        JavaTypeInstance resultType = "<init>".equals(name) ? (classFile == null ? classType : null) : result;
        this.result = resultType;
        this.varargs = varargs;
        this.variableNamer = variableNamer;
        this.name = name;
        this.fixedName = null;
        this.classFile = classFile;
    }

    public void unbreakEnumConstructor() {
        this.args.remove(0);
        this.args.remove(0);
    }

    @Override
    public void collectTypeUsages(TypeUsageCollector collector) {
        collector.collect(this.result);
        collector.collect(this.args);
        collector.collectFrom(this.formalTypeParameters);
    }

    public void hide(int x) {
        this.hidden.add(x);
    }

    public void setInnerOuterThis() {
        this.innerOuterThis = true;
    }

    public boolean isHiddenArg(int x) {
        return this.hidden.contains(x);
    }

    public boolean isInnerOuterThis() {
        return this.innerOuterThis;
    }

    public void dumpDeclarationSignature(Dumper d, String methName, Method.MethodConstructor isConstructor, MethodPrototypeAnnotationsHelper annotationsHelper) {
        if (this.formalTypeParameters != null) {
            d.print('<');
            boolean first = true;
            for (FormalTypeParameter formalTypeParameter : this.formalTypeParameters) {
                first = StringUtils.comma(first, d);
                d.dump(formalTypeParameter);
            }
            d.print("> ");
        }
        if (!isConstructor.isConstructor()) {
            d.dump(this.result).print(" ");
        }
        d.identifier(methName).print("(");
        List<LocalVariable> parameterLValues = this.getComputedParameters();
        int argssize = this.args.size();
        if (parameterLValues.size() != this.args.size()) {
            boolean x = true;
        }
        boolean first = true;
        for (int i = 0; i < argssize; ++i) {
            JavaTypeInstance arg = this.args.get(i);
            if (this.hidden.contains(i)) continue;
            first = StringUtils.comma(first, d);
            LocalVariable param = parameterLValues.get(i);
            if (param.isFinal()) {
                d.print("final ");
            }
            annotationsHelper.addAnnotationTextForParameterInto(i, d);
            if (this.varargs && i == argssize - 1) {
                if (!(arg instanceof JavaArrayTypeInstance)) {
                    throw new ConfusedCFRException("VARARGS method doesn't have an array as last arg!!");
                }
                ((JavaArrayTypeInstance)arg).toVarargString(d);
            } else {
                d.dump(arg);
            }
            d.print(" ").dump(param.getName());
        }
        d.print(")");
    }

    public boolean parametersComputed() {
        return this.parameterLValues != null;
    }

    public List<LocalVariable> getComputedParameters() {
        if (this.parameterLValues == null) {
            throw new IllegalStateException("Parameters not created");
        }
        return this.parameterLValues;
    }

    public void setSyntheticConstructorParameters(Method.MethodConstructor constructorFlag, DecompilerComments comments, Map<Integer, JavaTypeInstance> synthetics) {
        this.syntheticArgs.clear();
        int offset = 0;
        switch (constructorFlag) {
            case ENUM_CONSTRUCTOR: {
                offset = 3;
                break;
            }
            default: {
                if (!this.isInstanceMethod()) break;
                offset = 1;
            }
        }
        List<Slot> tmp = ListFactory.newList();
        for (Map.Entry<Integer, JavaTypeInstance> entry : synthetics.entrySet()) {
            tmp.add(new Slot(entry.getValue(), entry.getKey()));
        }
        if (!tmp.isEmpty()) {
            Slot test = tmp.get(0);
            if (offset != test.getIdx()) {
                List replacements = ListFactory.newList();
                for (Slot synthetic : tmp) {
                    JavaTypeInstance type = synthetic.getJavaTypeInstance();
                    Slot replacement = new Slot(type, offset);
                    offset += type.getStackType().getComputationCategory();
                    replacements.add(replacement);
                }
                this.syntheticArgs.addAll(replacements);
                comments.addComment(DecompilerComment.PARAMETER_CORRUPTION);
            } else {
                this.syntheticArgs.addAll(tmp);
            }
        }
    }

    public Map<Slot, SSAIdent> collectInitialSlotUsage(Method.MethodConstructor constructorFlag, SSAIdentifierFactory<Slot> ssaIdentifierFactory) {
        Map<Slot, SSAIdent> res = MapFactory.newLinkedMap();
        int offset = 0;
        switch (constructorFlag) {
            default: 
        }
        if (this.instanceMethod) {
            Slot tgt = new Slot(this.classFile.getClassType(), 0);
            res.put(tgt, ssaIdentifierFactory.getIdent(tgt));
            offset = 1;
        }
        if (!this.syntheticArgs.isEmpty()) {
            for (Slot synthetic : this.syntheticArgs) {
                if (offset != synthetic.getIdx()) {
                    throw new IllegalStateException("Synthetic arg - offset is " + offset + ", but got " + synthetic.getIdx());
                }
                res.put(synthetic, ssaIdentifierFactory.getIdent(synthetic));
                offset += synthetic.getJavaTypeInstance().getStackType().getComputationCategory();
            }
        }
        for (JavaTypeInstance arg : this.args) {
            Slot tgt = new Slot(arg, offset);
            res.put(tgt, ssaIdentifierFactory.getIdent(tgt));
            offset += arg.getStackType().getComputationCategory();
        }
        return res;
    }

    public List<LocalVariable> computeParameters(Method.MethodConstructor constructorFlag, Map<Integer, Ident> slotToIdentMap) {
        if (this.parameterLValues != null) {
            return this.parameterLValues;
        }
        this.parameterLValues = ListFactory.newList();
        int offset = 0;
        if (this.instanceMethod) {
            this.variableNamer.forceName(slotToIdentMap.get(0), 0L, "this");
            offset = 1;
        }
        if (constructorFlag != Method.MethodConstructor.ENUM_CONSTRUCTOR) {
            for (Slot synthetic : this.syntheticArgs) {
                JavaTypeInstance typeInstance = synthetic.getJavaTypeInstance();
                this.parameterLValues.add(new LocalVariable(offset, slotToIdentMap.get(synthetic.getIdx()), this.variableNamer, 0, new InferredJavaType(typeInstance, InferredJavaType.Source.FIELD, true)));
                offset += typeInstance.getStackType().getComputationCategory();
            }
        }
        for (JavaTypeInstance arg : this.args) {
            Ident ident = slotToIdentMap.get(offset);
            this.parameterLValues.add(new LocalVariable(offset, ident, this.variableNamer, 0, new InferredJavaType(arg, InferredJavaType.Source.FIELD, true)));
            offset += arg.getStackType().getComputationCategory();
        }
        return this.parameterLValues;
    }

    public JavaTypeInstance getReturnType() {
        return this.result;
    }

    public String getName() {
        return this.name;
    }

    public String getFixedName() {
        return this.fixedName != null ? this.fixedName : this.name;
    }

    public boolean hasNameBeenFixed() {
        return this.fixedName != null;
    }

    public void setFixedName(String name) {
        this.fixedName = name;
    }

    public boolean hasFormalTypeParameters() {
        return this.formalTypeParameters != null && !this.formalTypeParameters.isEmpty();
    }

    public List<JavaTypeInstance> getExplicitGenericUsage(GenericTypeBinder binder) {
        List<JavaTypeInstance> types = ListFactory.newList();
        for (FormalTypeParameter parameter : this.formalTypeParameters) {
            JavaTypeInstance type = binder.getBindingFor(parameter);
            if (type == null) {
                return null;
            }
            types.add(type);
        }
        return types;
    }

    public JavaTypeInstance getClassType() {
        if (this.classFile == null) {
            return null;
        }
        return this.classFile.getClassType();
    }

    public JavaTypeInstance getReturnType(JavaTypeInstance thisTypeInstance, List<Expression> invokingArgs) {
        if (this.classFile == null) {
            return this.result;
        }
        if (this.result == null) {
            if ("<init>".equals(this.getName())) {
                this.result = this.classFile.getClassSignature().getThisGeneralTypeClass(this.classFile.getClassType(), this.classFile.getConstantPool());
            } else {
                throw new IllegalStateException();
            }
        }
        if (this.hasFormalTypeParameters() || this.classFile.hasFormalTypeParameters()) {
            JavaGenericRefTypeInstance genericRefTypeInstance = null;
            if (thisTypeInstance instanceof JavaGenericRefTypeInstance) {
                genericRefTypeInstance = (JavaGenericRefTypeInstance)thisTypeInstance;
            }
            JavaTypeInstance boundResult = this.getResultBoundAccordingly(this.result, genericRefTypeInstance, invokingArgs);
            return boundResult;
        }
        return this.result;
    }

    public List<JavaTypeInstance> getArgs() {
        return this.args;
    }

    public int getVisibleArgCount() {
        return this.args.size() - this.hidden.size();
    }

    public boolean isInstanceMethod() {
        return this.instanceMethod;
    }

    public Expression getAppropriatelyCastedArgument(Expression expression, int argidx) {
        RawJavaType providedRawJavaType;
        JavaTypeInstance type = this.args.get(argidx);
        if (type.isComplexType()) {
            return expression;
        }
        RawJavaType expectedRawJavaType = type.getRawTypeOfSimpleType();
        if (expectedRawJavaType.compareAllPriorityTo(providedRawJavaType = expression.getInferredJavaType().getRawType()) == 0) {
            return expression;
        }
        return new CastExpression(new InferredJavaType(expectedRawJavaType, InferredJavaType.Source.EXPRESSION, true), expression);
    }

    public Dumper dumpAppropriatelyCastedArgumentString(Expression expression, int argidx, Dumper d) {
        return expression.dump(d);
    }

    public void tightenArgs(Expression object, List<Expression> expressions) {
        if (expressions.size() != this.args.size()) {
            throw new ConfusedCFRException("expr arg size mismatch");
        }
        if (object != null && this.classFile != null && !"<init>".equals(this.name)) {
            object.getInferredJavaType().noteUseAs(this.classFile.getClassType());
        }
        int length = this.args.size();
        for (int x = 0; x < length; ++x) {
            Expression expression = expressions.get(x);
            JavaTypeInstance type = this.args.get(x);
            expression.getInferredJavaType().useAsWithoutCasting(type);
        }
        GenericTypeBinder genericTypeBinder = null;
        if (object != null && object.getInferredJavaType().getJavaTypeInstance() instanceof JavaGenericBaseInstance) {
            JavaGenericRefTypeInstance boundInstance;
            JavaTypeInstance objectType = object.getInferredJavaType().getJavaTypeInstance();
            List<JavaTypeInstance> invokingTypes = ListFactory.newList();
            for (Expression invokingArg : expressions) {
                invokingTypes.add(invokingArg.getInferredJavaType().getJavaTypeInstance());
            }
            JavaGenericRefTypeInstance javaGenericRefTypeInstance = boundInstance = objectType instanceof JavaGenericRefTypeInstance ? (JavaGenericRefTypeInstance)objectType : null;
            if (this.classFile != null) {
                genericTypeBinder = GenericTypeBinder.bind(this.formalTypeParameters, this.classFile.getClassSignature(), this.args, boundInstance, invokingTypes);
            }
        }
        for (int x = 0; x < length; ++x) {
            Expression expression = expressions.get(x);
            JavaTypeInstance type = this.args.get(x);
            JavaTypeInstance exprType = expression.getInferredJavaType().getJavaTypeInstance();
            if (MethodPrototype.isGenericArg(exprType)) continue;
            if (genericTypeBinder != null) {
                type = genericTypeBinder.getBindingFor(type);
            }
            if (MethodPrototype.isGenericArg(type)) continue;
            expressions.set(x, new CastExpression(new InferredJavaType(type, InferredJavaType.Source.FUNCTION, true), expression));
        }
    }

    private static boolean isGenericArg(JavaTypeInstance arg) {
        return (arg = arg.getArrayStrippedType()) instanceof JavaGenericBaseInstance;
    }

    public String getComparableString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append('(');
        for (JavaTypeInstance arg : this.args) {
            sb.append(arg.getRawName()).append(" ");
        }
        sb.append(')');
        return sb.toString();
    }

    public String toString() {
        return this.getComparableString();
    }

    public boolean equalsGeneric(MethodPrototype other) {
        GenericTypeBinder genericTypeBinder = GenericTypeBinder.createEmpty();
        return this.equalsGeneric(other, genericTypeBinder);
    }

    public boolean equalsGeneric(MethodPrototype other, GenericTypeBinder genericTypeBinder) {
        JavaTypeInstance deGenerifiedResOther;
        JavaTypeInstance deGenerifiedRes;
        List<FormalTypeParameter> otherTypeParameters = other.formalTypeParameters;
        List<JavaTypeInstance> otherArgs = other.args;
        if (otherArgs.size() != this.args.size()) {
            return false;
        }
        JavaTypeInstance otherRes = other.getReturnType();
        JavaTypeInstance res = this.getReturnType();
        if (res != null && otherRes != null && !(deGenerifiedRes = res.getDeGenerifiedType()).equals(deGenerifiedResOther = otherRes.getDeGenerifiedType())) {
            if (res instanceof JavaGenericBaseInstance) {
                if (!((JavaGenericBaseInstance)res).tryFindBinding(otherRes, genericTypeBinder)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        for (int x = 0; x < this.args.size(); ++x) {
            JavaTypeInstance deGenerifiedRhs;
            JavaTypeInstance lhs = this.args.get(x);
            JavaTypeInstance rhs = otherArgs.get(x);
            JavaTypeInstance deGenerifiedLhs = lhs.getDeGenerifiedType();
            if (deGenerifiedLhs.equals(deGenerifiedRhs = rhs.getDeGenerifiedType())) continue;
            if (lhs instanceof JavaGenericBaseInstance) {
                if (((JavaGenericBaseInstance)lhs).tryFindBinding(rhs, genericTypeBinder)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public GenericTypeBinder getTypeBinderForTypes(List<JavaTypeInstance> invokingArgTypes) {
        if (this.classFile == null) {
            return null;
        }
        if (invokingArgTypes.size() != this.args.size()) {
            return null;
        }
        GenericTypeBinder genericTypeBinder = GenericTypeBinder.bind(this.formalTypeParameters, this.classFile.getClassSignature(), this.args, null, invokingArgTypes);
        return genericTypeBinder;
    }

    public GenericTypeBinder getTypeBinderFor(List<Expression> invokingArgs) {
        List<JavaTypeInstance> invokingTypes = ListFactory.newList();
        for (Expression invokingArg : invokingArgs) {
            invokingTypes.add(invokingArg.getInferredJavaType().getJavaTypeInstance());
        }
        return this.getTypeBinderForTypes(invokingTypes);
    }

    private JavaTypeInstance getResultBoundAccordingly(JavaTypeInstance result, JavaGenericRefTypeInstance boundInstance, List<Expression> invokingArgs) {
        if (result instanceof JavaArrayTypeInstance) {
            JavaArrayTypeInstance arrayTypeInstance = (JavaArrayTypeInstance)result;
            JavaTypeInstance stripped = result.getArrayStrippedType();
            JavaTypeInstance tmp = this.getResultBoundAccordinglyInner(stripped, boundInstance, invokingArgs);
            if (tmp == stripped) {
                return result;
            }
            return new JavaArrayTypeInstance(arrayTypeInstance.getNumArrayDimensions(), tmp);
        }
        return this.getResultBoundAccordinglyInner(result, boundInstance, invokingArgs);
    }

    private JavaTypeInstance getResultBoundAccordinglyInner(JavaTypeInstance result, JavaGenericRefTypeInstance boundInstance, List<Expression> invokingArgs) {
        if (!(result instanceof JavaGenericBaseInstance)) {
            return result;
        }
        List<JavaTypeInstance> invokingTypes = ListFactory.newList();
        for (Expression invokingArg : invokingArgs) {
            invokingTypes.add(invokingArg.getInferredJavaType().getJavaTypeInstance());
        }
        GenericTypeBinder genericTypeBinder = GenericTypeBinder.bind(this.formalTypeParameters, this.classFile.getClassSignature(), this.args, boundInstance, invokingTypes);
        if (genericTypeBinder == null) {
            return result;
        }
        JavaGenericBaseInstance genericResult = (JavaGenericBaseInstance)result;
        JavaTypeInstance boundResultInstance = genericResult.getBoundInstance(genericTypeBinder);
        if (boundResultInstance instanceof JavaWildcardTypeInstance) {
            boundResultInstance = ((JavaWildcardTypeInstance)boundResultInstance).getUnderlyingType();
        }
        return boundResultInstance;
    }

    public boolean isVarArgs() {
        return this.varargs;
    }

    public boolean equalsMatch(MethodPrototype other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!this.name.equals(other.name)) {
            return false;
        }
        List<JavaTypeInstance> otherArgs = other.getArgs();
        if (!((Object)this.args).equals(otherArgs)) {
            return false;
        }
        if (this.result != null && other.result != null && !this.result.equals(other.result)) {
            BindingSuperContainer otherBindingSupers = other.result.getBindingSupers();
            if (otherBindingSupers == null) {
                return false;
            }
            return otherBindingSupers.containsBase(this.result);
        }
        return true;
    }
}

