// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.34.2
// 	protoc        v4.25.3
// source: google/identity/accesscontextmanager/v1/service_perimeter.proto

package accesscontextmanagerpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies the type of the Perimeter. There are two types: regular and
// bridge. Regular Service Perimeter contains resources, access levels, and
// restricted services. Every resource can be in at most ONE
// regular Service Perimeter.
//
// In addition to being in a regular service perimeter, a resource can also
// be in zero or more perimeter bridges.  A perimeter bridge only contains
// resources.  Cross project operations are permitted if all effected
// resources share some perimeter (whether bridge or regular). Perimeter
// Bridge does not contain access levels or services: those are governed
// entirely by the regular perimeter that resource is in.
//
// Perimeter Bridges are typically useful when building more complex toplogies
// with many independent perimeters that need to share some data with a common
// perimeter, but should not be able to share data among themselves.
type ServicePerimeter_PerimeterType int32

const (
	// Regular Perimeter.
	ServicePerimeter_PERIMETER_TYPE_REGULAR ServicePerimeter_PerimeterType = 0
	// Perimeter Bridge.
	ServicePerimeter_PERIMETER_TYPE_BRIDGE ServicePerimeter_PerimeterType = 1
)

// Enum value maps for ServicePerimeter_PerimeterType.
var (
	ServicePerimeter_PerimeterType_name = map[int32]string{
		0: "PERIMETER_TYPE_REGULAR",
		1: "PERIMETER_TYPE_BRIDGE",
	}
	ServicePerimeter_PerimeterType_value = map[string]int32{
		"PERIMETER_TYPE_REGULAR": 0,
		"PERIMETER_TYPE_BRIDGE":  1,
	}
)

func (x ServicePerimeter_PerimeterType) Enum() *ServicePerimeter_PerimeterType {
	p := new(ServicePerimeter_PerimeterType)
	*p = x
	return p
}

func (x ServicePerimeter_PerimeterType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServicePerimeter_PerimeterType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_identity_accesscontextmanager_v1_service_perimeter_proto_enumTypes[0].Descriptor()
}

func (ServicePerimeter_PerimeterType) Type() protoreflect.EnumType {
	return &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_enumTypes[0]
}

func (x ServicePerimeter_PerimeterType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServicePerimeter_PerimeterType.Descriptor instead.
func (ServicePerimeter_PerimeterType) EnumDescriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescGZIP(), []int{0, 0}
}

// Specifies the types of identities that are allowed access in either
// [IngressFrom]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom]
// or [EgressFrom]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom]
// rules.
type ServicePerimeterConfig_IdentityType int32

const (
	// No blanket identity group specified.
	ServicePerimeterConfig_IDENTITY_TYPE_UNSPECIFIED ServicePerimeterConfig_IdentityType = 0
	// Authorize access from all identities outside the perimeter.
	ServicePerimeterConfig_ANY_IDENTITY ServicePerimeterConfig_IdentityType = 1
	// Authorize access from all human users outside the perimeter.
	ServicePerimeterConfig_ANY_USER_ACCOUNT ServicePerimeterConfig_IdentityType = 2
	// Authorize access from all service accounts outside the perimeter.
	ServicePerimeterConfig_ANY_SERVICE_ACCOUNT ServicePerimeterConfig_IdentityType = 3
)

// Enum value maps for ServicePerimeterConfig_IdentityType.
var (
	ServicePerimeterConfig_IdentityType_name = map[int32]string{
		0: "IDENTITY_TYPE_UNSPECIFIED",
		1: "ANY_IDENTITY",
		2: "ANY_USER_ACCOUNT",
		3: "ANY_SERVICE_ACCOUNT",
	}
	ServicePerimeterConfig_IdentityType_value = map[string]int32{
		"IDENTITY_TYPE_UNSPECIFIED": 0,
		"ANY_IDENTITY":              1,
		"ANY_USER_ACCOUNT":          2,
		"ANY_SERVICE_ACCOUNT":       3,
	}
)

func (x ServicePerimeterConfig_IdentityType) Enum() *ServicePerimeterConfig_IdentityType {
	p := new(ServicePerimeterConfig_IdentityType)
	*p = x
	return p
}

func (x ServicePerimeterConfig_IdentityType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ServicePerimeterConfig_IdentityType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_identity_accesscontextmanager_v1_service_perimeter_proto_enumTypes[1].Descriptor()
}

func (ServicePerimeterConfig_IdentityType) Type() protoreflect.EnumType {
	return &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_enumTypes[1]
}

func (x ServicePerimeterConfig_IdentityType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ServicePerimeterConfig_IdentityType.Descriptor instead.
func (ServicePerimeterConfig_IdentityType) EnumDescriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescGZIP(), []int{1, 0}
}

// `ServicePerimeter` describes a set of Google Cloud resources which can freely
// import and export data amongst themselves, but not export outside of the
// `ServicePerimeter`. If a request with a source within this `ServicePerimeter`
// has a target outside of the `ServicePerimeter`, the request will be blocked.
// Otherwise the request is allowed. There are two types of Service Perimeter -
// Regular and Bridge. Regular Service Perimeters cannot overlap, a single
// Google Cloud project can only belong to a single regular Service Perimeter.
// Service Perimeter Bridges can contain only Google Cloud projects as members,
// a single Google Cloud project may belong to multiple Service Perimeter
// Bridges.
type ServicePerimeter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name for the ServicePerimeter.  The `short_name`
	// component must begin with a letter and only include alphanumeric and '_'.
	// Format:
	// `accessPolicies/{access_policy}/servicePerimeters/{service_perimeter}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Human readable title. Must be unique within the Policy.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Description of the `ServicePerimeter` and its use. Does not affect
	// behavior.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Time the `ServicePerimeter` was created in UTC.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time the `ServicePerimeter` was updated in UTC.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Perimeter type indicator. A single project is
	// allowed to be a member of single regular perimeter, but multiple service
	// perimeter bridges. A project cannot be a included in a perimeter bridge
	// without being included in regular perimeter. For perimeter bridges,
	// the restricted service list as well as access level lists must be
	// empty.
	PerimeterType ServicePerimeter_PerimeterType `protobuf:"varint,6,opt,name=perimeter_type,json=perimeterType,proto3,enum=google.identity.accesscontextmanager.v1.ServicePerimeter_PerimeterType" json:"perimeter_type,omitempty"`
	// Current ServicePerimeter configuration. Specifies sets of resources,
	// restricted services and access levels that determine perimeter
	// content and boundaries.
	Status *ServicePerimeterConfig `protobuf:"bytes,7,opt,name=status,proto3" json:"status,omitempty"`
	// Proposed (or dry run) ServicePerimeter configuration. This configuration
	// allows to specify and test ServicePerimeter configuration without enforcing
	// actual access restrictions. Only allowed to be set when the
	// "use_explicit_dry_run_spec" flag is set.
	Spec *ServicePerimeterConfig `protobuf:"bytes,8,opt,name=spec,proto3" json:"spec,omitempty"`
	// Use explicit dry run spec flag. Ordinarily, a dry-run spec implicitly
	// exists  for all Service Perimeters, and that spec is identical to the
	// status for those Service Perimeters. When this flag is set, it inhibits the
	// generation of the implicit spec, thereby allowing the user to explicitly
	// provide a configuration ("spec") to use in a dry-run version of the Service
	// Perimeter. This allows the user to test changes to the enforced config
	// ("status") without actually enforcing them. This testing is done through
	// analyzing the differences between currently enforced and suggested
	// restrictions. use_explicit_dry_run_spec must bet set to True if any of the
	// fields in the spec are set to non-default values.
	UseExplicitDryRunSpec bool `protobuf:"varint,9,opt,name=use_explicit_dry_run_spec,json=useExplicitDryRunSpec,proto3" json:"use_explicit_dry_run_spec,omitempty"`
}

func (x *ServicePerimeter) Reset() {
	*x = ServicePerimeter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServicePerimeter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServicePerimeter) ProtoMessage() {}

func (x *ServicePerimeter) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServicePerimeter.ProtoReflect.Descriptor instead.
func (*ServicePerimeter) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescGZIP(), []int{0}
}

func (x *ServicePerimeter) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ServicePerimeter) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *ServicePerimeter) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ServicePerimeter) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ServicePerimeter) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *ServicePerimeter) GetPerimeterType() ServicePerimeter_PerimeterType {
	if x != nil {
		return x.PerimeterType
	}
	return ServicePerimeter_PERIMETER_TYPE_REGULAR
}

func (x *ServicePerimeter) GetStatus() *ServicePerimeterConfig {
	if x != nil {
		return x.Status
	}
	return nil
}

func (x *ServicePerimeter) GetSpec() *ServicePerimeterConfig {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *ServicePerimeter) GetUseExplicitDryRunSpec() bool {
	if x != nil {
		return x.UseExplicitDryRunSpec
	}
	return false
}

// `ServicePerimeterConfig` specifies a set of Google Cloud resources that
// describe specific Service Perimeter configuration.
type ServicePerimeterConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of Google Cloud resources that are inside of the service perimeter.
	// Currently only projects are allowed. Format: `projects/{project_number}`
	Resources []string `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty"`
	// A list of `AccessLevel` resource names that allow resources within the
	// `ServicePerimeter` to be accessed from the internet. `AccessLevels` listed
	// must be in the same policy as this `ServicePerimeter`. Referencing a
	// nonexistent `AccessLevel` is a syntax error. If no `AccessLevel` names are
	// listed, resources within the perimeter can only be accessed via Google
	// Cloud calls with request origins within the perimeter. Example:
	// `"accessPolicies/MY_POLICY/accessLevels/MY_LEVEL"`.
	// For Service Perimeter Bridge, must be empty.
	AccessLevels []string `protobuf:"bytes,2,rep,name=access_levels,json=accessLevels,proto3" json:"access_levels,omitempty"`
	// Google Cloud services that are subject to the Service Perimeter
	// restrictions. For example, if `storage.googleapis.com` is specified, access
	// to the storage buckets inside the perimeter must meet the perimeter's
	// access restrictions.
	RestrictedServices []string `protobuf:"bytes,4,rep,name=restricted_services,json=restrictedServices,proto3" json:"restricted_services,omitempty"`
	// Configuration for APIs allowed within Perimeter.
	VpcAccessibleServices *ServicePerimeterConfig_VpcAccessibleServices `protobuf:"bytes,10,opt,name=vpc_accessible_services,json=vpcAccessibleServices,proto3" json:"vpc_accessible_services,omitempty"`
	// List of [IngressPolicies]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
	// to apply to the perimeter. A perimeter may have multiple [IngressPolicies]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy],
	// each of which is evaluated separately. Access is granted if any [Ingress
	// Policy]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
	// grants it. Must be empty for a perimeter bridge.
	IngressPolicies []*ServicePerimeterConfig_IngressPolicy `protobuf:"bytes,8,rep,name=ingress_policies,json=ingressPolicies,proto3" json:"ingress_policies,omitempty"`
	// List of [EgressPolicies]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
	// to apply to the perimeter. A perimeter may have multiple [EgressPolicies]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy],
	// each of which is evaluated separately. Access is granted if any
	// [EgressPolicy]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
	// grants it. Must be empty for a perimeter bridge.
	EgressPolicies []*ServicePerimeterConfig_EgressPolicy `protobuf:"bytes,9,rep,name=egress_policies,json=egressPolicies,proto3" json:"egress_policies,omitempty"`
}

func (x *ServicePerimeterConfig) Reset() {
	*x = ServicePerimeterConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServicePerimeterConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServicePerimeterConfig) ProtoMessage() {}

func (x *ServicePerimeterConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServicePerimeterConfig.ProtoReflect.Descriptor instead.
func (*ServicePerimeterConfig) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescGZIP(), []int{1}
}

func (x *ServicePerimeterConfig) GetResources() []string {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *ServicePerimeterConfig) GetAccessLevels() []string {
	if x != nil {
		return x.AccessLevels
	}
	return nil
}

func (x *ServicePerimeterConfig) GetRestrictedServices() []string {
	if x != nil {
		return x.RestrictedServices
	}
	return nil
}

func (x *ServicePerimeterConfig) GetVpcAccessibleServices() *ServicePerimeterConfig_VpcAccessibleServices {
	if x != nil {
		return x.VpcAccessibleServices
	}
	return nil
}

func (x *ServicePerimeterConfig) GetIngressPolicies() []*ServicePerimeterConfig_IngressPolicy {
	if x != nil {
		return x.IngressPolicies
	}
	return nil
}

func (x *ServicePerimeterConfig) GetEgressPolicies() []*ServicePerimeterConfig_EgressPolicy {
	if x != nil {
		return x.EgressPolicies
	}
	return nil
}

// Specifies how APIs are allowed to communicate within the Service
// Perimeter.
type ServicePerimeterConfig_VpcAccessibleServices struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Whether to restrict API calls within the Service Perimeter to the list of
	// APIs specified in 'allowed_services'.
	EnableRestriction bool `protobuf:"varint,1,opt,name=enable_restriction,json=enableRestriction,proto3" json:"enable_restriction,omitempty"`
	// The list of APIs usable within the Service Perimeter. Must be empty
	// unless 'enable_restriction' is True. You can specify a list of individual
	// services, as well as include the 'RESTRICTED-SERVICES' value, which
	// automatically includes all of the services protected by the perimeter.
	AllowedServices []string `protobuf:"bytes,2,rep,name=allowed_services,json=allowedServices,proto3" json:"allowed_services,omitempty"`
}

func (x *ServicePerimeterConfig_VpcAccessibleServices) Reset() {
	*x = ServicePerimeterConfig_VpcAccessibleServices{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServicePerimeterConfig_VpcAccessibleServices) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServicePerimeterConfig_VpcAccessibleServices) ProtoMessage() {}

func (x *ServicePerimeterConfig_VpcAccessibleServices) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServicePerimeterConfig_VpcAccessibleServices.ProtoReflect.Descriptor instead.
func (*ServicePerimeterConfig_VpcAccessibleServices) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescGZIP(), []int{1, 0}
}

func (x *ServicePerimeterConfig_VpcAccessibleServices) GetEnableRestriction() bool {
	if x != nil {
		return x.EnableRestriction
	}
	return false
}

func (x *ServicePerimeterConfig_VpcAccessibleServices) GetAllowedServices() []string {
	if x != nil {
		return x.AllowedServices
	}
	return nil
}

// An allowed method or permission of a service specified in [ApiOperation]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation].
type ServicePerimeterConfig_MethodSelector struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The API method name or Cloud IAM permission name to allow.
	//
	// Types that are assignable to Kind:
	//
	//	*ServicePerimeterConfig_MethodSelector_Method
	//	*ServicePerimeterConfig_MethodSelector_Permission
	Kind isServicePerimeterConfig_MethodSelector_Kind `protobuf_oneof:"kind"`
}

func (x *ServicePerimeterConfig_MethodSelector) Reset() {
	*x = ServicePerimeterConfig_MethodSelector{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServicePerimeterConfig_MethodSelector) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServicePerimeterConfig_MethodSelector) ProtoMessage() {}

func (x *ServicePerimeterConfig_MethodSelector) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServicePerimeterConfig_MethodSelector.ProtoReflect.Descriptor instead.
func (*ServicePerimeterConfig_MethodSelector) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescGZIP(), []int{1, 1}
}

func (m *ServicePerimeterConfig_MethodSelector) GetKind() isServicePerimeterConfig_MethodSelector_Kind {
	if m != nil {
		return m.Kind
	}
	return nil
}

func (x *ServicePerimeterConfig_MethodSelector) GetMethod() string {
	if x, ok := x.GetKind().(*ServicePerimeterConfig_MethodSelector_Method); ok {
		return x.Method
	}
	return ""
}

func (x *ServicePerimeterConfig_MethodSelector) GetPermission() string {
	if x, ok := x.GetKind().(*ServicePerimeterConfig_MethodSelector_Permission); ok {
		return x.Permission
	}
	return ""
}

type isServicePerimeterConfig_MethodSelector_Kind interface {
	isServicePerimeterConfig_MethodSelector_Kind()
}

type ServicePerimeterConfig_MethodSelector_Method struct {
	// Value for `method` should be a valid method name for the corresponding
	// `service_name` in [ApiOperation]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation].
	// If `*` used as value for `method`, then ALL methods and permissions are
	// allowed.
	Method string `protobuf:"bytes,1,opt,name=method,proto3,oneof"`
}

type ServicePerimeterConfig_MethodSelector_Permission struct {
	// Value for `permission` should be a valid Cloud IAM permission for the
	// corresponding `service_name` in [ApiOperation]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation].
	Permission string `protobuf:"bytes,2,opt,name=permission,proto3,oneof"`
}

func (*ServicePerimeterConfig_MethodSelector_Method) isServicePerimeterConfig_MethodSelector_Kind() {}

func (*ServicePerimeterConfig_MethodSelector_Permission) isServicePerimeterConfig_MethodSelector_Kind() {
}

// Identification for an API Operation.
type ServicePerimeterConfig_ApiOperation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the API whose methods or permissions the [IngressPolicy]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
	// or [EgressPolicy]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
	// want to allow. A single [ApiOperation]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation]
	// with `service_name` field set to `*` will allow all methods AND
	// permissions for all services.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// API methods or permissions to allow. Method or permission must belong to
	// the service specified by `service_name` field. A single [MethodSelector]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector]
	// entry with `*` specified for the `method` field will allow all methods
	// AND permissions for the service specified in `service_name`.
	MethodSelectors []*ServicePerimeterConfig_MethodSelector `protobuf:"bytes,2,rep,name=method_selectors,json=methodSelectors,proto3" json:"method_selectors,omitempty"`
}

func (x *ServicePerimeterConfig_ApiOperation) Reset() {
	*x = ServicePerimeterConfig_ApiOperation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServicePerimeterConfig_ApiOperation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServicePerimeterConfig_ApiOperation) ProtoMessage() {}

func (x *ServicePerimeterConfig_ApiOperation) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServicePerimeterConfig_ApiOperation.ProtoReflect.Descriptor instead.
func (*ServicePerimeterConfig_ApiOperation) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescGZIP(), []int{1, 2}
}

func (x *ServicePerimeterConfig_ApiOperation) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *ServicePerimeterConfig_ApiOperation) GetMethodSelectors() []*ServicePerimeterConfig_MethodSelector {
	if x != nil {
		return x.MethodSelectors
	}
	return nil
}

// The source that [IngressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
// authorizes access from.
type ServicePerimeterConfig_IngressSource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Allowed ingress source. It can be one of [AccessLevel]
	// [google.identity.accesscontextmanager.v1.AccessLevel] or Google
	// Cloud resource.
	//
	// Types that are assignable to Source:
	//
	//	*ServicePerimeterConfig_IngressSource_AccessLevel
	//	*ServicePerimeterConfig_IngressSource_Resource
	Source isServicePerimeterConfig_IngressSource_Source `protobuf_oneof:"source"`
}

func (x *ServicePerimeterConfig_IngressSource) Reset() {
	*x = ServicePerimeterConfig_IngressSource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServicePerimeterConfig_IngressSource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServicePerimeterConfig_IngressSource) ProtoMessage() {}

func (x *ServicePerimeterConfig_IngressSource) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServicePerimeterConfig_IngressSource.ProtoReflect.Descriptor instead.
func (*ServicePerimeterConfig_IngressSource) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescGZIP(), []int{1, 3}
}

func (m *ServicePerimeterConfig_IngressSource) GetSource() isServicePerimeterConfig_IngressSource_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (x *ServicePerimeterConfig_IngressSource) GetAccessLevel() string {
	if x, ok := x.GetSource().(*ServicePerimeterConfig_IngressSource_AccessLevel); ok {
		return x.AccessLevel
	}
	return ""
}

func (x *ServicePerimeterConfig_IngressSource) GetResource() string {
	if x, ok := x.GetSource().(*ServicePerimeterConfig_IngressSource_Resource); ok {
		return x.Resource
	}
	return ""
}

type isServicePerimeterConfig_IngressSource_Source interface {
	isServicePerimeterConfig_IngressSource_Source()
}

type ServicePerimeterConfig_IngressSource_AccessLevel struct {
	// An [AccessLevel]
	// [google.identity.accesscontextmanager.v1.AccessLevel] resource
	// name that allow resources within the [ServicePerimeters]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] to be
	// accessed from the internet. [AccessLevels]
	// [google.identity.accesscontextmanager.v1.AccessLevel] listed must
	// be in the same policy as this [ServicePerimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter].
	// Referencing a nonexistent [AccessLevel]
	// [google.identity.accesscontextmanager.v1.AccessLevel] will cause
	// an error. If no [AccessLevel]
	// [google.identity.accesscontextmanager.v1.AccessLevel] names are
	// listed, resources within the perimeter can only be accessed via Google
	// Cloud calls with request origins within the perimeter. Example:
	// `accessPolicies/MY_POLICY/accessLevels/MY_LEVEL`. If a single `*` is
	// specified for `access_level`, then all [IngressSources]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource]
	// will be allowed.
	AccessLevel string `protobuf:"bytes,1,opt,name=access_level,json=accessLevel,proto3,oneof"`
}

type ServicePerimeterConfig_IngressSource_Resource struct {
	// A Google Cloud resource that is allowed to ingress the perimeter.
	// Requests from these resources will be allowed to access perimeter data.
	// Currently only projects are allowed.
	// Format: `projects/{project_number}`
	// The project may be in any Google Cloud organization, not just the
	// organization that the perimeter is defined in. `*` is not allowed, the
	// case of allowing all Google Cloud resources only is not supported.
	Resource string `protobuf:"bytes,2,opt,name=resource,proto3,oneof"`
}

func (*ServicePerimeterConfig_IngressSource_AccessLevel) isServicePerimeterConfig_IngressSource_Source() {
}

func (*ServicePerimeterConfig_IngressSource_Resource) isServicePerimeterConfig_IngressSource_Source() {
}

// Defines the conditions under which an [IngressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
// matches a request. Conditions are based on information about the source of
// the request. The request must satisfy what is defined in `sources` AND
// identity related fields in order to match.
type ServicePerimeterConfig_IngressFrom struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Sources that this [IngressPolicy]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
	// authorizes access from.
	Sources []*ServicePerimeterConfig_IngressSource `protobuf:"bytes,1,rep,name=sources,proto3" json:"sources,omitempty"`
	// A list of identities that are allowed access through this ingress
	// policy. Should be in the format of email address. The email address
	// should represent individual user or service account only.
	Identities []string `protobuf:"bytes,2,rep,name=identities,proto3" json:"identities,omitempty"`
	// Specifies the type of identities that are allowed access from outside the
	// perimeter. If left unspecified, then members of `identities` field will
	// be allowed access.
	IdentityType ServicePerimeterConfig_IdentityType `protobuf:"varint,3,opt,name=identity_type,json=identityType,proto3,enum=google.identity.accesscontextmanager.v1.ServicePerimeterConfig_IdentityType" json:"identity_type,omitempty"`
}

func (x *ServicePerimeterConfig_IngressFrom) Reset() {
	*x = ServicePerimeterConfig_IngressFrom{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServicePerimeterConfig_IngressFrom) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServicePerimeterConfig_IngressFrom) ProtoMessage() {}

func (x *ServicePerimeterConfig_IngressFrom) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServicePerimeterConfig_IngressFrom.ProtoReflect.Descriptor instead.
func (*ServicePerimeterConfig_IngressFrom) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescGZIP(), []int{1, 4}
}

func (x *ServicePerimeterConfig_IngressFrom) GetSources() []*ServicePerimeterConfig_IngressSource {
	if x != nil {
		return x.Sources
	}
	return nil
}

func (x *ServicePerimeterConfig_IngressFrom) GetIdentities() []string {
	if x != nil {
		return x.Identities
	}
	return nil
}

func (x *ServicePerimeterConfig_IngressFrom) GetIdentityType() ServicePerimeterConfig_IdentityType {
	if x != nil {
		return x.IdentityType
	}
	return ServicePerimeterConfig_IDENTITY_TYPE_UNSPECIFIED
}

// Defines the conditions under which an [IngressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
// matches a request. Conditions are based on information about the
// [ApiOperation]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation]
// intended to be performed on the target resource of the request. The request
// must satisfy what is defined in `operations` AND `resources` in order to
// match.
type ServicePerimeterConfig_IngressTo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of [ApiOperations]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation]
	// allowed to be performed by the sources specified in corresponding
	// [IngressFrom]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom]
	// in this [ServicePerimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter].
	Operations []*ServicePerimeterConfig_ApiOperation `protobuf:"bytes,1,rep,name=operations,proto3" json:"operations,omitempty"`
	// A list of resources, currently only projects in the form
	// `projects/<projectnumber>`, protected by this [ServicePerimeter]
	// [google.identity.accesscontextmanager.v1.ServicePerimeter] that are
	// allowed to be accessed by sources defined in the corresponding
	// [IngressFrom]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom].
	// If a single `*` is specified, then access to all resources inside the
	// perimeter are allowed.
	Resources []string `protobuf:"bytes,2,rep,name=resources,proto3" json:"resources,omitempty"`
}

func (x *ServicePerimeterConfig_IngressTo) Reset() {
	*x = ServicePerimeterConfig_IngressTo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServicePerimeterConfig_IngressTo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServicePerimeterConfig_IngressTo) ProtoMessage() {}

func (x *ServicePerimeterConfig_IngressTo) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServicePerimeterConfig_IngressTo.ProtoReflect.Descriptor instead.
func (*ServicePerimeterConfig_IngressTo) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescGZIP(), []int{1, 5}
}

func (x *ServicePerimeterConfig_IngressTo) GetOperations() []*ServicePerimeterConfig_ApiOperation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ServicePerimeterConfig_IngressTo) GetResources() []string {
	if x != nil {
		return x.Resources
	}
	return nil
}

// Policy for ingress into [ServicePerimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter].
//
// [IngressPolicies]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
// match requests based on `ingress_from` and `ingress_to` stanzas.  For an
// ingress policy to match, both the `ingress_from` and `ingress_to` stanzas
// must be matched. If an [IngressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
// matches a request, the request is allowed through the perimeter boundary
// from outside the perimeter.
//
// For example, access from the internet can be allowed either
// based on an [AccessLevel]
// [google.identity.accesscontextmanager.v1.AccessLevel] or, for traffic
// hosted on Google Cloud, the project of the source network. For access from
// private networks, using the project of the hosting network is required.
//
// Individual ingress policies can be limited by restricting which
// services and/or actions they match using the `ingress_to` field.
type ServicePerimeterConfig_IngressPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines the conditions on the source of a request causing this
	// [IngressPolicy]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
	// to apply.
	IngressFrom *ServicePerimeterConfig_IngressFrom `protobuf:"bytes,1,opt,name=ingress_from,json=ingressFrom,proto3" json:"ingress_from,omitempty"`
	// Defines the conditions on the [ApiOperation]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation]
	// and request destination that cause this [IngressPolicy]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
	// to apply.
	IngressTo *ServicePerimeterConfig_IngressTo `protobuf:"bytes,2,opt,name=ingress_to,json=ingressTo,proto3" json:"ingress_to,omitempty"`
}

func (x *ServicePerimeterConfig_IngressPolicy) Reset() {
	*x = ServicePerimeterConfig_IngressPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServicePerimeterConfig_IngressPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServicePerimeterConfig_IngressPolicy) ProtoMessage() {}

func (x *ServicePerimeterConfig_IngressPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServicePerimeterConfig_IngressPolicy.ProtoReflect.Descriptor instead.
func (*ServicePerimeterConfig_IngressPolicy) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescGZIP(), []int{1, 6}
}

func (x *ServicePerimeterConfig_IngressPolicy) GetIngressFrom() *ServicePerimeterConfig_IngressFrom {
	if x != nil {
		return x.IngressFrom
	}
	return nil
}

func (x *ServicePerimeterConfig_IngressPolicy) GetIngressTo() *ServicePerimeterConfig_IngressTo {
	if x != nil {
		return x.IngressTo
	}
	return nil
}

// Defines the conditions under which an [EgressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
// matches a request. Conditions based on information about the source of the
// request. Note that if the destination of the request is also protected by a
// [ServicePerimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter], then that
// [ServicePerimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] must have
// an [IngressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
// which allows access in order for this request to succeed.
type ServicePerimeterConfig_EgressFrom struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of identities that are allowed access through this [EgressPolicy].
	// Should be in the format of email address. The email address should
	// represent individual user or service account only.
	Identities []string `protobuf:"bytes,1,rep,name=identities,proto3" json:"identities,omitempty"`
	// Specifies the type of identities that are allowed access to outside the
	// perimeter. If left unspecified, then members of `identities` field will
	// be allowed access.
	IdentityType ServicePerimeterConfig_IdentityType `protobuf:"varint,2,opt,name=identity_type,json=identityType,proto3,enum=google.identity.accesscontextmanager.v1.ServicePerimeterConfig_IdentityType" json:"identity_type,omitempty"`
}

func (x *ServicePerimeterConfig_EgressFrom) Reset() {
	*x = ServicePerimeterConfig_EgressFrom{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServicePerimeterConfig_EgressFrom) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServicePerimeterConfig_EgressFrom) ProtoMessage() {}

func (x *ServicePerimeterConfig_EgressFrom) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServicePerimeterConfig_EgressFrom.ProtoReflect.Descriptor instead.
func (*ServicePerimeterConfig_EgressFrom) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescGZIP(), []int{1, 7}
}

func (x *ServicePerimeterConfig_EgressFrom) GetIdentities() []string {
	if x != nil {
		return x.Identities
	}
	return nil
}

func (x *ServicePerimeterConfig_EgressFrom) GetIdentityType() ServicePerimeterConfig_IdentityType {
	if x != nil {
		return x.IdentityType
	}
	return ServicePerimeterConfig_IDENTITY_TYPE_UNSPECIFIED
}

// Defines the conditions under which an [EgressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
// matches a request. Conditions are based on information about the
// [ApiOperation]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation]
// intended to be performed on the `resources` specified. Note that if the
// destination of the request is also protected by a [ServicePerimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter], then that
// [ServicePerimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] must have
// an [IngressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy]
// which allows access in order for this request to succeed. The request must
// match `operations` AND `resources` fields in order to be allowed egress out
// of the perimeter.
type ServicePerimeterConfig_EgressTo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of resources, currently only projects in the form
	// `projects/<projectnumber>`, that are allowed to be accessed by sources
	// defined in the corresponding [EgressFrom]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom].
	// A request matches if it contains a resource in this list.  If `*` is
	// specified for `resources`, then this [EgressTo]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo]
	// rule will authorize access to all resources outside the perimeter.
	Resources []string `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty"`
	// A list of [ApiOperations]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation]
	// allowed to be performed by the sources specified in the corresponding
	// [EgressFrom]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom].
	// A request matches if it uses an operation/service in this list.
	Operations []*ServicePerimeterConfig_ApiOperation `protobuf:"bytes,2,rep,name=operations,proto3" json:"operations,omitempty"`
	// A list of external resources that are allowed to be accessed. Only AWS
	// and Azure resources are supported. For Amazon S3, the supported format is
	// s3://BUCKET_NAME. For Azure Storage, the supported format is
	// azure://myaccount.blob.core.windows.net/CONTAINER_NAME. A request matches
	// if it contains an external resource in this list (Example:
	// s3://bucket/path). Currently '*' is not allowed.
	ExternalResources []string `protobuf:"bytes,3,rep,name=external_resources,json=externalResources,proto3" json:"external_resources,omitempty"`
}

func (x *ServicePerimeterConfig_EgressTo) Reset() {
	*x = ServicePerimeterConfig_EgressTo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServicePerimeterConfig_EgressTo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServicePerimeterConfig_EgressTo) ProtoMessage() {}

func (x *ServicePerimeterConfig_EgressTo) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServicePerimeterConfig_EgressTo.ProtoReflect.Descriptor instead.
func (*ServicePerimeterConfig_EgressTo) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescGZIP(), []int{1, 8}
}

func (x *ServicePerimeterConfig_EgressTo) GetResources() []string {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (x *ServicePerimeterConfig_EgressTo) GetOperations() []*ServicePerimeterConfig_ApiOperation {
	if x != nil {
		return x.Operations
	}
	return nil
}

func (x *ServicePerimeterConfig_EgressTo) GetExternalResources() []string {
	if x != nil {
		return x.ExternalResources
	}
	return nil
}

// Policy for egress from perimeter.
//
// [EgressPolicies]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
// match requests based on `egress_from` and `egress_to` stanzas.  For an
// [EgressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
// to match, both `egress_from` and `egress_to` stanzas must be matched. If an
// [EgressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
// matches a request, the request is allowed to span the [ServicePerimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] boundary.
// For example, an [EgressPolicy]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
// can be used to allow VMs on networks within the [ServicePerimeter]
// [google.identity.accesscontextmanager.v1.ServicePerimeter] to access a
// defined set of projects outside the perimeter in certain contexts (e.g. to
// read data from a Cloud Storage bucket or query against a BigQuery dataset).
//
// [EgressPolicies]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
// are concerned with the *resources* that a request relates as well as the
// API services and API actions being used.  They do not related to the
// direction of data movement.  More detailed documentation for this concept
// can be found in the descriptions of [EgressFrom]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom]
// and [EgressTo]
// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo].
type ServicePerimeterConfig_EgressPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Defines conditions on the source of a request causing this [EgressPolicy]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
	// to apply.
	EgressFrom *ServicePerimeterConfig_EgressFrom `protobuf:"bytes,1,opt,name=egress_from,json=egressFrom,proto3" json:"egress_from,omitempty"`
	// Defines the conditions on the [ApiOperation]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation]
	// and destination resources that cause this [EgressPolicy]
	// [google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy]
	// to apply.
	EgressTo *ServicePerimeterConfig_EgressTo `protobuf:"bytes,2,opt,name=egress_to,json=egressTo,proto3" json:"egress_to,omitempty"`
}

func (x *ServicePerimeterConfig_EgressPolicy) Reset() {
	*x = ServicePerimeterConfig_EgressPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ServicePerimeterConfig_EgressPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ServicePerimeterConfig_EgressPolicy) ProtoMessage() {}

func (x *ServicePerimeterConfig_EgressPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ServicePerimeterConfig_EgressPolicy.ProtoReflect.Descriptor instead.
func (*ServicePerimeterConfig_EgressPolicy) Descriptor() ([]byte, []int) {
	return file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescGZIP(), []int{1, 9}
}

func (x *ServicePerimeterConfig_EgressPolicy) GetEgressFrom() *ServicePerimeterConfig_EgressFrom {
	if x != nil {
		return x.EgressFrom
	}
	return nil
}

func (x *ServicePerimeterConfig_EgressPolicy) GetEgressTo() *ServicePerimeterConfig_EgressTo {
	if x != nil {
		return x.EgressTo
	}
	return nil
}

var File_google_identity_accesscontextmanager_v1_service_perimeter_proto protoreflect.FileDescriptor

var file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDesc = []byte{
	0x0a, 0x3f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf9, 0x05, 0x0a, 0x10, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x12, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x14, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x6e, 0x0a, 0x0e, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x2e, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x54, 0x79,
	0x70, 0x65, 0x52, 0x0d, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x57, 0x0a, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x06, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x53, 0x0a, 0x04, 0x73, 0x70,
	0x65, 0x63, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x04, 0x73, 0x70, 0x65, 0x63, 0x12,
	0x38, 0x0a, 0x19, 0x75, 0x73, 0x65, 0x5f, 0x65, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x5f,
	0x64, 0x72, 0x79, 0x5f, 0x72, 0x75, 0x6e, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x09, 0x20, 0x01,
	0x28, 0x08, 0x52, 0x15, 0x75, 0x73, 0x65, 0x45, 0x78, 0x70, 0x6c, 0x69, 0x63, 0x69, 0x74, 0x44,
	0x72, 0x79, 0x52, 0x75, 0x6e, 0x53, 0x70, 0x65, 0x63, 0x22, 0x46, 0x0a, 0x0d, 0x50, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x16, 0x50, 0x45,
	0x52, 0x49, 0x4d, 0x45, 0x54, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x52, 0x45, 0x47,
	0x55, 0x4c, 0x41, 0x52, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x50, 0x45, 0x52, 0x49, 0x4d, 0x45,
	0x54, 0x45, 0x52, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x42, 0x52, 0x49, 0x44, 0x47, 0x45, 0x10,
	0x01, 0x3a, 0x7f, 0xea, 0x41, 0x7c, 0x0a, 0x34, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x12, 0x44, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x7d, 0x2f, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x2f, 0x7b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x7d, 0x22, 0xb4, 0x12, 0x0a, 0x16, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65,
	0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x1c, 0x0a,
	0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x0c, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x73,
	0x12, 0x2f, 0x0a, 0x13, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x5f, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x72,
	0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x65, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x12, 0x8d, 0x01, 0x0a, 0x17, 0x76, 0x70, 0x63, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x69, 0x62, 0x6c, 0x65, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x55, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x56, 0x70, 0x63, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69, 0x62,
	0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x52, 0x15, 0x76, 0x70, 0x63, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x12, 0x78, 0x0a, 0x10, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x6e, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0f, 0x69, 0x6e, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x75, 0x0a, 0x0f, 0x65,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x09,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x0e, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x1a, 0x71, 0x0a, 0x15, 0x56, 0x70, 0x63, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69,
	0x62, 0x6c, 0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x65,
	0x6e, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52, 0x11, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x52,
	0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x29, 0x0a, 0x10, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x65, 0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x1a, 0x54, 0x0a, 0x0e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x53,
	0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x12, 0x18, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x12, 0x20, 0x0a, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x42, 0x06, 0x0a, 0x04, 0x6b, 0x69, 0x6e, 0x64, 0x1a, 0xac, 0x01, 0x0a, 0x0c,
	0x41, 0x70, 0x69, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12,
	0x79, 0x0a, 0x10, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x52, 0x0f, 0x6d, 0x65, 0x74, 0x68, 0x6f,
	0x64, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x1a, 0x5c, 0x0a, 0x0d, 0x49, 0x6e,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x23, 0x0a, 0x0c, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x00, 0x52, 0x0b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4c, 0x65, 0x76, 0x65, 0x6c,
	0x12, 0x1c, 0x0a, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x42, 0x08,
	0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x1a, 0x89, 0x02, 0x0a, 0x0b, 0x49, 0x6e, 0x67,
	0x72, 0x65, 0x73, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x12, 0x67, 0x0a, 0x07, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d,
	0x65, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x07, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x12, 0x1e, 0x0a, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65,
	0x73, 0x12, 0x71, 0x0a, 0x0d, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79,
	0x54, 0x79, 0x70, 0x65, 0x1a, 0x97, 0x01, 0x0a, 0x09, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x54, 0x6f, 0x12, 0x6c, 0x0a, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x70, 0x69, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x1a, 0xe9,
	0x01, 0x0a, 0x0d, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x6e, 0x0a, 0x0c, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x66, 0x72, 0x6f, 0x6d,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x46,
	0x72, 0x6f, 0x6d, 0x52, 0x0b, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x46, 0x72, 0x6f, 0x6d,
	0x12, 0x68, 0x0a, 0x0a, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x6f, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x49, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x43,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x49, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x52,
	0x09, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x1a, 0x9f, 0x01, 0x0a, 0x0a, 0x45,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x12, 0x1e, 0x0a, 0x0a, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x71, 0x0a, 0x0d, 0x69, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c,
	0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x1a, 0xc5, 0x01, 0x0a,
	0x08, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x12, 0x1c, 0x0a, 0x09, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x6c, 0x0a, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72,
	0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x41, 0x70, 0x69,
	0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0a, 0x6f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2d, 0x0a, 0x12, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
	0x6c, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x11, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x73, 0x1a, 0xe2, 0x01, 0x0a, 0x0c, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x6b, 0x0a, 0x0b, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f,
	0x66, 0x72, 0x6f, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x45, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x46, 0x72, 0x6f, 0x6d, 0x52, 0x0a, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x46, 0x72,
	0x6f, 0x6d, 0x12, 0x65, 0x0a, 0x09, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x6f, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x45, 0x67, 0x72, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x52,
	0x08, 0x65, 0x67, 0x72, 0x65, 0x73, 0x73, 0x54, 0x6f, 0x22, 0x6e, 0x0a, 0x0c, 0x49, 0x64, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x49, 0x44, 0x45,
	0x4e, 0x54, 0x49, 0x54, 0x59, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x10, 0x0a, 0x0c, 0x41, 0x4e, 0x59, 0x5f,
	0x49, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x4e,
	0x59, 0x5f, 0x55, 0x53, 0x45, 0x52, 0x5f, 0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x02,
	0x12, 0x17, 0x0a, 0x13, 0x41, 0x4e, 0x59, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x49, 0x43, 0x45, 0x5f,
	0x41, 0x43, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x10, 0x03, 0x42, 0xac, 0x02, 0x0a, 0x2b, 0x63, 0x6f,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x79, 0x2e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x15, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x50, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x5c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x31, 0x2f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x70, 0x62, 0x3b, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x70, 0x62,
	0xa2, 0x02, 0x04, 0x47, 0x41, 0x43, 0x4d, 0xaa, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x56,
	0x31, 0xca, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x49, 0x64, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x79, 0x5c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78,
	0x74, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x2a, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x49, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x79, 0x3a, 0x3a,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescOnce sync.Once
	file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescData = file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDesc
)

func file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescGZIP() []byte {
	file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescOnce.Do(func() {
		file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescData)
	})
	return file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDescData
}

var file_google_identity_accesscontextmanager_v1_service_perimeter_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_identity_accesscontextmanager_v1_service_perimeter_proto_goTypes = []any{
	(ServicePerimeter_PerimeterType)(0),                  // 0: google.identity.accesscontextmanager.v1.ServicePerimeter.PerimeterType
	(ServicePerimeterConfig_IdentityType)(0),             // 1: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IdentityType
	(*ServicePerimeter)(nil),                             // 2: google.identity.accesscontextmanager.v1.ServicePerimeter
	(*ServicePerimeterConfig)(nil),                       // 3: google.identity.accesscontextmanager.v1.ServicePerimeterConfig
	(*ServicePerimeterConfig_VpcAccessibleServices)(nil), // 4: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices
	(*ServicePerimeterConfig_MethodSelector)(nil),        // 5: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector
	(*ServicePerimeterConfig_ApiOperation)(nil),          // 6: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation
	(*ServicePerimeterConfig_IngressSource)(nil),         // 7: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource
	(*ServicePerimeterConfig_IngressFrom)(nil),           // 8: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom
	(*ServicePerimeterConfig_IngressTo)(nil),             // 9: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo
	(*ServicePerimeterConfig_IngressPolicy)(nil),         // 10: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy
	(*ServicePerimeterConfig_EgressFrom)(nil),            // 11: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom
	(*ServicePerimeterConfig_EgressTo)(nil),              // 12: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo
	(*ServicePerimeterConfig_EgressPolicy)(nil),          // 13: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy
	(*timestamppb.Timestamp)(nil),                        // 14: google.protobuf.Timestamp
}
var file_google_identity_accesscontextmanager_v1_service_perimeter_proto_depIdxs = []int32{
	14, // 0: google.identity.accesscontextmanager.v1.ServicePerimeter.create_time:type_name -> google.protobuf.Timestamp
	14, // 1: google.identity.accesscontextmanager.v1.ServicePerimeter.update_time:type_name -> google.protobuf.Timestamp
	0,  // 2: google.identity.accesscontextmanager.v1.ServicePerimeter.perimeter_type:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeter.PerimeterType
	3,  // 3: google.identity.accesscontextmanager.v1.ServicePerimeter.status:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeterConfig
	3,  // 4: google.identity.accesscontextmanager.v1.ServicePerimeter.spec:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeterConfig
	4,  // 5: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.vpc_accessible_services:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeterConfig.VpcAccessibleServices
	10, // 6: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ingress_policies:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy
	13, // 7: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.egress_policies:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy
	5,  // 8: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation.method_selectors:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeterConfig.MethodSelector
	7,  // 9: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom.sources:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressSource
	1,  // 10: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom.identity_type:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IdentityType
	6,  // 11: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo.operations:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation
	8,  // 12: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy.ingress_from:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressFrom
	9,  // 13: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressPolicy.ingress_to:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IngressTo
	1,  // 14: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom.identity_type:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeterConfig.IdentityType
	6,  // 15: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo.operations:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeterConfig.ApiOperation
	11, // 16: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy.egress_from:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressFrom
	12, // 17: google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressPolicy.egress_to:type_name -> google.identity.accesscontextmanager.v1.ServicePerimeterConfig.EgressTo
	18, // [18:18] is the sub-list for method output_type
	18, // [18:18] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_google_identity_accesscontextmanager_v1_service_perimeter_proto_init() }
func file_google_identity_accesscontextmanager_v1_service_perimeter_proto_init() {
	if File_google_identity_accesscontextmanager_v1_service_perimeter_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[0].Exporter = func(v any, i int) any {
			switch v := v.(*ServicePerimeter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[1].Exporter = func(v any, i int) any {
			switch v := v.(*ServicePerimeterConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[2].Exporter = func(v any, i int) any {
			switch v := v.(*ServicePerimeterConfig_VpcAccessibleServices); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[3].Exporter = func(v any, i int) any {
			switch v := v.(*ServicePerimeterConfig_MethodSelector); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[4].Exporter = func(v any, i int) any {
			switch v := v.(*ServicePerimeterConfig_ApiOperation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[5].Exporter = func(v any, i int) any {
			switch v := v.(*ServicePerimeterConfig_IngressSource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[6].Exporter = func(v any, i int) any {
			switch v := v.(*ServicePerimeterConfig_IngressFrom); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[7].Exporter = func(v any, i int) any {
			switch v := v.(*ServicePerimeterConfig_IngressTo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[8].Exporter = func(v any, i int) any {
			switch v := v.(*ServicePerimeterConfig_IngressPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[9].Exporter = func(v any, i int) any {
			switch v := v.(*ServicePerimeterConfig_EgressFrom); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[10].Exporter = func(v any, i int) any {
			switch v := v.(*ServicePerimeterConfig_EgressTo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[11].Exporter = func(v any, i int) any {
			switch v := v.(*ServicePerimeterConfig_EgressPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[3].OneofWrappers = []any{
		(*ServicePerimeterConfig_MethodSelector_Method)(nil),
		(*ServicePerimeterConfig_MethodSelector_Permission)(nil),
	}
	file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes[5].OneofWrappers = []any{
		(*ServicePerimeterConfig_IngressSource_AccessLevel)(nil),
		(*ServicePerimeterConfig_IngressSource_Resource)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_identity_accesscontextmanager_v1_service_perimeter_proto_goTypes,
		DependencyIndexes: file_google_identity_accesscontextmanager_v1_service_perimeter_proto_depIdxs,
		EnumInfos:         file_google_identity_accesscontextmanager_v1_service_perimeter_proto_enumTypes,
		MessageInfos:      file_google_identity_accesscontextmanager_v1_service_perimeter_proto_msgTypes,
	}.Build()
	File_google_identity_accesscontextmanager_v1_service_perimeter_proto = out.File
	file_google_identity_accesscontextmanager_v1_service_perimeter_proto_rawDesc = nil
	file_google_identity_accesscontextmanager_v1_service_perimeter_proto_goTypes = nil
	file_google_identity_accesscontextmanager_v1_service_perimeter_proto_depIdxs = nil
}
