// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.21.5
// source: google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto

package agentendpointpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A request message to receive task notifications.
type ReceiveTaskNotificationRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. This is the Compute Engine instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken string `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	// Required. The version of the agent making the request.
	AgentVersion string `protobuf:"bytes,2,opt,name=agent_version,json=agentVersion,proto3" json:"agent_version,omitempty"`
}

func (x *ReceiveTaskNotificationRequest) Reset() {
	*x = ReceiveTaskNotificationRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReceiveTaskNotificationRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReceiveTaskNotificationRequest) ProtoMessage() {}

func (x *ReceiveTaskNotificationRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReceiveTaskNotificationRequest.ProtoReflect.Descriptor instead.
func (*ReceiveTaskNotificationRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescGZIP(), []int{0}
}

func (x *ReceiveTaskNotificationRequest) GetInstanceIdToken() string {
	if x != nil {
		return x.InstanceIdToken
	}
	return ""
}

func (x *ReceiveTaskNotificationRequest) GetAgentVersion() string {
	if x != nil {
		return x.AgentVersion
	}
	return ""
}

// The streaming rpc message that will notify the agent when it has a task
// it needs to perform on the instance.
type ReceiveTaskNotificationResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReceiveTaskNotificationResponse) Reset() {
	*x = ReceiveTaskNotificationResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReceiveTaskNotificationResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReceiveTaskNotificationResponse) ProtoMessage() {}

func (x *ReceiveTaskNotificationResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReceiveTaskNotificationResponse.ProtoReflect.Descriptor instead.
func (*ReceiveTaskNotificationResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescGZIP(), []int{1}
}

// A request message for signaling the start of a task execution.
type StartNextTaskRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. This is the Compute Engine instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken string `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
}

func (x *StartNextTaskRequest) Reset() {
	*x = StartNextTaskRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartNextTaskRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartNextTaskRequest) ProtoMessage() {}

func (x *StartNextTaskRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartNextTaskRequest.ProtoReflect.Descriptor instead.
func (*StartNextTaskRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescGZIP(), []int{2}
}

func (x *StartNextTaskRequest) GetInstanceIdToken() string {
	if x != nil {
		return x.InstanceIdToken
	}
	return ""
}

// A response message that contains the details of the task to work on.
type StartNextTaskResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The details of the task that should be worked on.  Can be empty if there
	// is no new task to work on.
	Task *Task `protobuf:"bytes,1,opt,name=task,proto3" json:"task,omitempty"`
}

func (x *StartNextTaskResponse) Reset() {
	*x = StartNextTaskResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StartNextTaskResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StartNextTaskResponse) ProtoMessage() {}

func (x *StartNextTaskResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StartNextTaskResponse.ProtoReflect.Descriptor instead.
func (*StartNextTaskResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescGZIP(), []int{3}
}

func (x *StartNextTaskResponse) GetTask() *Task {
	if x != nil {
		return x.Task
	}
	return nil
}

// A request message for reporting the progress of current task.
type ReportTaskProgressRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. This is the Compute Engine instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken string `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	// Required. Unique identifier of the task this applies to.
	TaskId string `protobuf:"bytes,2,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// Required. The type of task to report progress on.
	//
	// Progress must include the appropriate message based on this enum as
	// specified below:
	// APPLY_PATCHES = ApplyPatchesTaskProgress
	// EXEC_STEP = Progress not supported for this type.
	// APPLY_CONFIG_TASK = ApplyConfigTaskProgress
	TaskType TaskType `protobuf:"varint,3,opt,name=task_type,json=taskType,proto3,enum=google.cloud.osconfig.agentendpoint.v1.TaskType" json:"task_type,omitempty"`
	// Intermediate progress of the current task.
	//
	// Types that are assignable to Progress:
	//
	//	*ReportTaskProgressRequest_ApplyPatchesTaskProgress
	//	*ReportTaskProgressRequest_ExecStepTaskProgress
	//	*ReportTaskProgressRequest_ApplyConfigTaskProgress
	Progress isReportTaskProgressRequest_Progress `protobuf_oneof:"progress"`
}

func (x *ReportTaskProgressRequest) Reset() {
	*x = ReportTaskProgressRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportTaskProgressRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportTaskProgressRequest) ProtoMessage() {}

func (x *ReportTaskProgressRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportTaskProgressRequest.ProtoReflect.Descriptor instead.
func (*ReportTaskProgressRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescGZIP(), []int{4}
}

func (x *ReportTaskProgressRequest) GetInstanceIdToken() string {
	if x != nil {
		return x.InstanceIdToken
	}
	return ""
}

func (x *ReportTaskProgressRequest) GetTaskId() string {
	if x != nil {
		return x.TaskId
	}
	return ""
}

func (x *ReportTaskProgressRequest) GetTaskType() TaskType {
	if x != nil {
		return x.TaskType
	}
	return TaskType_TASK_TYPE_UNSPECIFIED
}

func (m *ReportTaskProgressRequest) GetProgress() isReportTaskProgressRequest_Progress {
	if m != nil {
		return m.Progress
	}
	return nil
}

func (x *ReportTaskProgressRequest) GetApplyPatchesTaskProgress() *ApplyPatchesTaskProgress {
	if x, ok := x.GetProgress().(*ReportTaskProgressRequest_ApplyPatchesTaskProgress); ok {
		return x.ApplyPatchesTaskProgress
	}
	return nil
}

func (x *ReportTaskProgressRequest) GetExecStepTaskProgress() *ExecStepTaskProgress {
	if x, ok := x.GetProgress().(*ReportTaskProgressRequest_ExecStepTaskProgress); ok {
		return x.ExecStepTaskProgress
	}
	return nil
}

func (x *ReportTaskProgressRequest) GetApplyConfigTaskProgress() *ApplyConfigTaskProgress {
	if x, ok := x.GetProgress().(*ReportTaskProgressRequest_ApplyConfigTaskProgress); ok {
		return x.ApplyConfigTaskProgress
	}
	return nil
}

type isReportTaskProgressRequest_Progress interface {
	isReportTaskProgressRequest_Progress()
}

type ReportTaskProgressRequest_ApplyPatchesTaskProgress struct {
	// Details about the progress of the apply patches task.
	ApplyPatchesTaskProgress *ApplyPatchesTaskProgress `protobuf:"bytes,4,opt,name=apply_patches_task_progress,json=applyPatchesTaskProgress,proto3,oneof"`
}

type ReportTaskProgressRequest_ExecStepTaskProgress struct {
	// Details about the progress of the exec step task.
	ExecStepTaskProgress *ExecStepTaskProgress `protobuf:"bytes,5,opt,name=exec_step_task_progress,json=execStepTaskProgress,proto3,oneof"`
}

type ReportTaskProgressRequest_ApplyConfigTaskProgress struct {
	// Details about the progress of the apply config task.
	ApplyConfigTaskProgress *ApplyConfigTaskProgress `protobuf:"bytes,6,opt,name=apply_config_task_progress,json=applyConfigTaskProgress,proto3,oneof"`
}

func (*ReportTaskProgressRequest_ApplyPatchesTaskProgress) isReportTaskProgressRequest_Progress() {}

func (*ReportTaskProgressRequest_ExecStepTaskProgress) isReportTaskProgressRequest_Progress() {}

func (*ReportTaskProgressRequest_ApplyConfigTaskProgress) isReportTaskProgressRequest_Progress() {}

// The response message after the agent reported the current task progress.
type ReportTaskProgressResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Instructs agent to continue or not.
	TaskDirective TaskDirective `protobuf:"varint,1,opt,name=task_directive,json=taskDirective,proto3,enum=google.cloud.osconfig.agentendpoint.v1.TaskDirective" json:"task_directive,omitempty"`
}

func (x *ReportTaskProgressResponse) Reset() {
	*x = ReportTaskProgressResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportTaskProgressResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportTaskProgressResponse) ProtoMessage() {}

func (x *ReportTaskProgressResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportTaskProgressResponse.ProtoReflect.Descriptor instead.
func (*ReportTaskProgressResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescGZIP(), []int{5}
}

func (x *ReportTaskProgressResponse) GetTaskDirective() TaskDirective {
	if x != nil {
		return x.TaskDirective
	}
	return TaskDirective_TASK_DIRECTIVE_UNSPECIFIED
}

// A request message for signaling the completion of a task execution.
type ReportTaskCompleteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. This is the Compute Engine instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken string `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	// Required. Unique identifier of the task this applies to.
	TaskId string `protobuf:"bytes,2,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// Required. The type of task to report completed.
	//
	// Output must include the appropriate message based on this enum as
	// specified below:
	// APPLY_PATCHES = ApplyPatchesTaskOutput
	// EXEC_STEP = ExecStepTaskOutput
	// APPLY_CONFIG_TASK = ApplyConfigTaskOutput
	TaskType TaskType `protobuf:"varint,3,opt,name=task_type,json=taskType,proto3,enum=google.cloud.osconfig.agentendpoint.v1.TaskType" json:"task_type,omitempty"`
	// Descriptive error message if the task execution ended in error.
	ErrorMessage string `protobuf:"bytes,4,opt,name=error_message,json=errorMessage,proto3" json:"error_message,omitempty"`
	// Final output details of the current task.
	//
	// Types that are assignable to Output:
	//
	//	*ReportTaskCompleteRequest_ApplyPatchesTaskOutput
	//	*ReportTaskCompleteRequest_ExecStepTaskOutput
	//	*ReportTaskCompleteRequest_ApplyConfigTaskOutput
	Output isReportTaskCompleteRequest_Output `protobuf_oneof:"output"`
}

func (x *ReportTaskCompleteRequest) Reset() {
	*x = ReportTaskCompleteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportTaskCompleteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportTaskCompleteRequest) ProtoMessage() {}

func (x *ReportTaskCompleteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportTaskCompleteRequest.ProtoReflect.Descriptor instead.
func (*ReportTaskCompleteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescGZIP(), []int{6}
}

func (x *ReportTaskCompleteRequest) GetInstanceIdToken() string {
	if x != nil {
		return x.InstanceIdToken
	}
	return ""
}

func (x *ReportTaskCompleteRequest) GetTaskId() string {
	if x != nil {
		return x.TaskId
	}
	return ""
}

func (x *ReportTaskCompleteRequest) GetTaskType() TaskType {
	if x != nil {
		return x.TaskType
	}
	return TaskType_TASK_TYPE_UNSPECIFIED
}

func (x *ReportTaskCompleteRequest) GetErrorMessage() string {
	if x != nil {
		return x.ErrorMessage
	}
	return ""
}

func (m *ReportTaskCompleteRequest) GetOutput() isReportTaskCompleteRequest_Output {
	if m != nil {
		return m.Output
	}
	return nil
}

func (x *ReportTaskCompleteRequest) GetApplyPatchesTaskOutput() *ApplyPatchesTaskOutput {
	if x, ok := x.GetOutput().(*ReportTaskCompleteRequest_ApplyPatchesTaskOutput); ok {
		return x.ApplyPatchesTaskOutput
	}
	return nil
}

func (x *ReportTaskCompleteRequest) GetExecStepTaskOutput() *ExecStepTaskOutput {
	if x, ok := x.GetOutput().(*ReportTaskCompleteRequest_ExecStepTaskOutput); ok {
		return x.ExecStepTaskOutput
	}
	return nil
}

func (x *ReportTaskCompleteRequest) GetApplyConfigTaskOutput() *ApplyConfigTaskOutput {
	if x, ok := x.GetOutput().(*ReportTaskCompleteRequest_ApplyConfigTaskOutput); ok {
		return x.ApplyConfigTaskOutput
	}
	return nil
}

type isReportTaskCompleteRequest_Output interface {
	isReportTaskCompleteRequest_Output()
}

type ReportTaskCompleteRequest_ApplyPatchesTaskOutput struct {
	// Final output details of the apply patches task;
	ApplyPatchesTaskOutput *ApplyPatchesTaskOutput `protobuf:"bytes,5,opt,name=apply_patches_task_output,json=applyPatchesTaskOutput,proto3,oneof"`
}

type ReportTaskCompleteRequest_ExecStepTaskOutput struct {
	// Final output details of the exec step task;
	ExecStepTaskOutput *ExecStepTaskOutput `protobuf:"bytes,6,opt,name=exec_step_task_output,json=execStepTaskOutput,proto3,oneof"`
}

type ReportTaskCompleteRequest_ApplyConfigTaskOutput struct {
	// Final output details of the apply config task;
	ApplyConfigTaskOutput *ApplyConfigTaskOutput `protobuf:"bytes,7,opt,name=apply_config_task_output,json=applyConfigTaskOutput,proto3,oneof"`
}

func (*ReportTaskCompleteRequest_ApplyPatchesTaskOutput) isReportTaskCompleteRequest_Output() {}

func (*ReportTaskCompleteRequest_ExecStepTaskOutput) isReportTaskCompleteRequest_Output() {}

func (*ReportTaskCompleteRequest_ApplyConfigTaskOutput) isReportTaskCompleteRequest_Output() {}

// The response message after the agent signaled the current task complete.
type ReportTaskCompleteResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *ReportTaskCompleteResponse) Reset() {
	*x = ReportTaskCompleteResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportTaskCompleteResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportTaskCompleteResponse) ProtoMessage() {}

func (x *ReportTaskCompleteResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportTaskCompleteResponse.ProtoReflect.Descriptor instead.
func (*ReportTaskCompleteResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescGZIP(), []int{7}
}

// The request message for registering the agent.
type RegisterAgentRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. This is the Compute Engine instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken string `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	// Required. The version of the agent.
	AgentVersion string `protobuf:"bytes,2,opt,name=agent_version,json=agentVersion,proto3" json:"agent_version,omitempty"`
	// Required. The capabilities supported by the agent. Supported values are:
	// PATCH_GA
	// GUEST_POLICY_BETA
	// CONFIG_V1
	SupportedCapabilities []string `protobuf:"bytes,3,rep,name=supported_capabilities,json=supportedCapabilities,proto3" json:"supported_capabilities,omitempty"`
	// The operating system long name.
	// For example 'Debian GNU/Linux 9' or 'Microsoft Window Server 2019
	// Datacenter'.
	OsLongName string `protobuf:"bytes,4,opt,name=os_long_name,json=osLongName,proto3" json:"os_long_name,omitempty"`
	// The operating system short name.
	// For example, 'windows' or 'debian'.
	OsShortName string `protobuf:"bytes,5,opt,name=os_short_name,json=osShortName,proto3" json:"os_short_name,omitempty"`
	// The version of the operating system.
	OsVersion string `protobuf:"bytes,6,opt,name=os_version,json=osVersion,proto3" json:"os_version,omitempty"`
	// The system architecture of the operating system.
	OsArchitecture string `protobuf:"bytes,7,opt,name=os_architecture,json=osArchitecture,proto3" json:"os_architecture,omitempty"`
}

func (x *RegisterAgentRequest) Reset() {
	*x = RegisterAgentRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterAgentRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterAgentRequest) ProtoMessage() {}

func (x *RegisterAgentRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterAgentRequest.ProtoReflect.Descriptor instead.
func (*RegisterAgentRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescGZIP(), []int{8}
}

func (x *RegisterAgentRequest) GetInstanceIdToken() string {
	if x != nil {
		return x.InstanceIdToken
	}
	return ""
}

func (x *RegisterAgentRequest) GetAgentVersion() string {
	if x != nil {
		return x.AgentVersion
	}
	return ""
}

func (x *RegisterAgentRequest) GetSupportedCapabilities() []string {
	if x != nil {
		return x.SupportedCapabilities
	}
	return nil
}

func (x *RegisterAgentRequest) GetOsLongName() string {
	if x != nil {
		return x.OsLongName
	}
	return ""
}

func (x *RegisterAgentRequest) GetOsShortName() string {
	if x != nil {
		return x.OsShortName
	}
	return ""
}

func (x *RegisterAgentRequest) GetOsVersion() string {
	if x != nil {
		return x.OsVersion
	}
	return ""
}

func (x *RegisterAgentRequest) GetOsArchitecture() string {
	if x != nil {
		return x.OsArchitecture
	}
	return ""
}

// The response message after the agent registered.
type RegisterAgentResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *RegisterAgentResponse) Reset() {
	*x = RegisterAgentResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RegisterAgentResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterAgentResponse) ProtoMessage() {}

func (x *RegisterAgentResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterAgentResponse.ProtoReflect.Descriptor instead.
func (*RegisterAgentResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescGZIP(), []int{9}
}

// The request message for having the agent report inventory.
type ReportInventoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. This is the Compute Engine instance identity token described in
	// https://cloud.google.com/compute/docs/instances/verifying-instance-identity
	// where the audience is 'osconfig.googleapis.com' and the format is 'full'.
	InstanceIdToken string `protobuf:"bytes,1,opt,name=instance_id_token,json=instanceIdToken,proto3" json:"instance_id_token,omitempty"`
	// Required. This is a client created checksum that should be generated based on the
	// contents of the reported inventory.  This will be used by the service to
	// determine if it has the latest version of inventory.
	InventoryChecksum string `protobuf:"bytes,2,opt,name=inventory_checksum,json=inventoryChecksum,proto3" json:"inventory_checksum,omitempty"`
	// Optional. This is the details of the inventory.  Should only be provided if the
	// inventory has changed since the last report, or if instructed by the
	// service to provide full inventory.
	Inventory *Inventory `protobuf:"bytes,3,opt,name=inventory,proto3" json:"inventory,omitempty"`
}

func (x *ReportInventoryRequest) Reset() {
	*x = ReportInventoryRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportInventoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportInventoryRequest) ProtoMessage() {}

func (x *ReportInventoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportInventoryRequest.ProtoReflect.Descriptor instead.
func (*ReportInventoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescGZIP(), []int{10}
}

func (x *ReportInventoryRequest) GetInstanceIdToken() string {
	if x != nil {
		return x.InstanceIdToken
	}
	return ""
}

func (x *ReportInventoryRequest) GetInventoryChecksum() string {
	if x != nil {
		return x.InventoryChecksum
	}
	return ""
}

func (x *ReportInventoryRequest) GetInventory() *Inventory {
	if x != nil {
		return x.Inventory
	}
	return nil
}

// The response message after the agent has reported inventory.
type ReportInventoryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If true, the full inventory should be reported back to the server.
	ReportFullInventory bool `protobuf:"varint,1,opt,name=report_full_inventory,json=reportFullInventory,proto3" json:"report_full_inventory,omitempty"`
}

func (x *ReportInventoryResponse) Reset() {
	*x = ReportInventoryResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportInventoryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportInventoryResponse) ProtoMessage() {}

func (x *ReportInventoryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportInventoryResponse.ProtoReflect.Descriptor instead.
func (*ReportInventoryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescGZIP(), []int{11}
}

func (x *ReportInventoryResponse) GetReportFullInventory() bool {
	if x != nil {
		return x.ReportFullInventory
	}
	return false
}

var File_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto protoreflect.FileDescriptor

var file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDesc = []byte{
	0x0a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x26, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x74,
	0x61, 0x73, 0x6b, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x7b, 0x0a, 0x1e, 0x52, 0x65,
	0x63, 0x65, 0x69, 0x76, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2f, 0x0a, 0x11,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x28, 0x0a,
	0x0d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x22, 0x21, 0x0a, 0x1f, 0x52, 0x65, 0x63, 0x65, 0x69,
	0x76, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x47, 0x0a, 0x14, 0x53, 0x74,
	0x61, 0x72, 0x74, 0x4e, 0x65, 0x78, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69,
	0x64, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x22, 0x59, 0x0a, 0x15, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4e, 0x65, 0x78, 0x74,
	0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x40, 0x0a, 0x04,
	0x74, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x04, 0x74, 0x61, 0x73, 0x6b, 0x22, 0xc5,
	0x04, 0x0a, 0x19, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f,
	0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2f, 0x0a, 0x11,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1c, 0x0a,
	0x07, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x06, 0x74, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x52, 0x0a, 0x09, 0x74,
	0x61, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x61, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x81, 0x01, 0x0a, 0x1b, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x5f, 0x70, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x73, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x70, 0x70, 0x6c, 0x79, 0x50, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x54, 0x61, 0x73, 0x6b, 0x50,
	0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x48, 0x00, 0x52, 0x18, 0x61, 0x70, 0x70, 0x6c, 0x79,
	0x50, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72,
	0x65, 0x73, 0x73, 0x12, 0x75, 0x0a, 0x17, 0x65, 0x78, 0x65, 0x63, 0x5f, 0x73, 0x74, 0x65, 0x70,
	0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x65, 0x63, 0x53, 0x74, 0x65, 0x70, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x48, 0x00, 0x52, 0x14, 0x65, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70, 0x54, 0x61,
	0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x7e, 0x0a, 0x1a, 0x61, 0x70,
	0x70, 0x6c, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f,
	0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x48,
	0x00, 0x52, 0x17, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x54, 0x61,
	0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x42, 0x0a, 0x0a, 0x08, 0x70, 0x72,
	0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x22, 0x7a, 0x0a, 0x1a, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5c, 0x0a, 0x0e, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x52, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x22, 0xd5, 0x04, 0x0a, 0x19, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x73,
	0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x2f, 0x0a, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x54, 0x6f, 0x6b, 0x65,
	0x6e, 0x12, 0x1c, 0x0a, 0x07, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x74, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12,
	0x52, 0x0a, 0x09, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b,
	0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x61, 0x73, 0x6b, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x0d, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73,
	0x73, 0x61, 0x67, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x65, 0x72, 0x72, 0x6f,
	0x72, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x7b, 0x0a, 0x19, 0x61, 0x70, 0x70, 0x6c,
	0x79, 0x5f, 0x70, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x6f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x50, 0x61, 0x74, 0x63, 0x68, 0x65,
	0x73, 0x54, 0x61, 0x73, 0x6b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x16, 0x61,
	0x70, 0x70, 0x6c, 0x79, 0x50, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x54, 0x61, 0x73, 0x6b, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x6f, 0x0a, 0x15, 0x65, 0x78, 0x65, 0x63, 0x5f, 0x73, 0x74,
	0x65, 0x70, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x65, 0x63, 0x53, 0x74, 0x65, 0x70, 0x54, 0x61, 0x73, 0x6b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x48, 0x00, 0x52, 0x12, 0x65, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70, 0x54, 0x61, 0x73, 0x6b,
	0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x78, 0x0a, 0x18, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x6f, 0x75, 0x74, 0x70,
	0x75, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x54, 0x61, 0x73,
	0x6b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x48, 0x00, 0x52, 0x15, 0x61, 0x70, 0x70, 0x6c, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x54, 0x61, 0x73, 0x6b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74,
	0x42, 0x08, 0x0a, 0x06, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x22, 0x1c, 0x0a, 0x1a, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xbb, 0x02, 0x0a, 0x14, 0x52, 0x65, 0x67,
	0x69, 0x73, 0x74, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x2f, 0x0a, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x28, 0x0a, 0x0d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a, 0x16,
	0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69,
	0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x15, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x43, 0x61, 0x70, 0x61,
	0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0x20, 0x0a, 0x0c, 0x6f, 0x73, 0x5f, 0x6c,
	0x6f, 0x6e, 0x67, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x6f, 0x73, 0x4c, 0x6f, 0x6e, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0d, 0x6f, 0x73,
	0x5f, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0b, 0x6f, 0x73, 0x53, 0x68, 0x6f, 0x72, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x6f, 0x73, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x6f, 0x73, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a,
	0x0f, 0x6f, 0x73, 0x5f, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x6f, 0x73, 0x41, 0x72, 0x63, 0x68, 0x69, 0x74,
	0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x22, 0x17, 0x0a, 0x15, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74,
	0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0xd3, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74,
	0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x2f, 0x0a, 0x11, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x69, 0x6e, 0x73, 0x74,
	0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x32, 0x0a, 0x12, 0x69,
	0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75,
	0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x69, 0x6e,
	0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x12,
	0x54, 0x0a, 0x09, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x76, 0x65,
	0x6e, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x69, 0x6e, 0x76, 0x65,
	0x6e, 0x74, 0x6f, 0x72, 0x79, 0x22, 0x4d, 0x0a, 0x17, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x49,
	0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x32, 0x0a, 0x15, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x66, 0x75, 0x6c, 0x6c, 0x5f,
	0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x13, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x46, 0x75, 0x6c, 0x6c, 0x49, 0x6e, 0x76, 0x65, 0x6e,
	0x74, 0x6f, 0x72, 0x79, 0x32, 0xd6, 0x09, 0x0a, 0x14, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x45, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xd0, 0x01,
	0x0a, 0x17, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x4e, 0x6f, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x4e, 0x6f,
	0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x63, 0x65, 0x69,
	0x76, 0x65, 0x54, 0x61, 0x73, 0x6b, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x22, 0xda, 0x41, 0x1f, 0x69,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x2c, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x30, 0x01,
	0x12, 0xa2, 0x01, 0x0a, 0x0d, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4e, 0x65, 0x78, 0x74, 0x54, 0x61,
	0x73, 0x6b, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x72,
	0x74, 0x4e, 0x65, 0x78, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x4e,
	0x65, 0x78, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x14, 0xda, 0x41, 0x11, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0xc3, 0x01, 0x0a, 0x12, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74,
	0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69,
	0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x73, 0x6b,
	0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54,
	0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0x26, 0xda, 0x41, 0x23, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x5f, 0x69, 0x64, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x2c, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69,
	0x64, 0x2c, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x12, 0xd1, 0x01, 0x0a, 0x12,
	0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x65, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f,
	0x72, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x61, 0x73, 0x6b, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x34, 0xda, 0x41, 0x31, 0x69, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x2c,
	0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x2c, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x74, 0x79, 0x70,
	0x65, 0x2c, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12,
	0xc7, 0x01, 0x0a, 0x0d, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e,
	0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73,
	0x74, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65,
	0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x39,
	0xda, 0x41, 0x36, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x2c, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x2c, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x70,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x12, 0xc5, 0x01, 0x0a, 0x0f, 0x52, 0x65,
	0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x3e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x76,
	0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x49, 0x6e, 0x76,
	0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x31,
	0xda, 0x41, 0x2e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x2c, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x63,
	0x68, 0x65, 0x63, 0x6b, 0x73, 0x75, 0x6d, 0x2c, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x6f, 0x72,
	0x79, 0x1a, 0x1a, 0xca, 0x41, 0x17, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x42, 0x97, 0x01,
	0x0a, 0x2a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x12, 0x41, 0x67,
	0x65, 0x6e, 0x74, 0x45, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x53, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e,
	0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x3b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescOnce sync.Once
	file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescData = file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDesc
)

func file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescGZIP() []byte {
	file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescOnce.Do(func() {
		file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescData)
	})
	return file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDescData
}

var file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_goTypes = []interface{}{
	(*ReceiveTaskNotificationRequest)(nil),  // 0: google.cloud.osconfig.agentendpoint.v1.ReceiveTaskNotificationRequest
	(*ReceiveTaskNotificationResponse)(nil), // 1: google.cloud.osconfig.agentendpoint.v1.ReceiveTaskNotificationResponse
	(*StartNextTaskRequest)(nil),            // 2: google.cloud.osconfig.agentendpoint.v1.StartNextTaskRequest
	(*StartNextTaskResponse)(nil),           // 3: google.cloud.osconfig.agentendpoint.v1.StartNextTaskResponse
	(*ReportTaskProgressRequest)(nil),       // 4: google.cloud.osconfig.agentendpoint.v1.ReportTaskProgressRequest
	(*ReportTaskProgressResponse)(nil),      // 5: google.cloud.osconfig.agentendpoint.v1.ReportTaskProgressResponse
	(*ReportTaskCompleteRequest)(nil),       // 6: google.cloud.osconfig.agentendpoint.v1.ReportTaskCompleteRequest
	(*ReportTaskCompleteResponse)(nil),      // 7: google.cloud.osconfig.agentendpoint.v1.ReportTaskCompleteResponse
	(*RegisterAgentRequest)(nil),            // 8: google.cloud.osconfig.agentendpoint.v1.RegisterAgentRequest
	(*RegisterAgentResponse)(nil),           // 9: google.cloud.osconfig.agentendpoint.v1.RegisterAgentResponse
	(*ReportInventoryRequest)(nil),          // 10: google.cloud.osconfig.agentendpoint.v1.ReportInventoryRequest
	(*ReportInventoryResponse)(nil),         // 11: google.cloud.osconfig.agentendpoint.v1.ReportInventoryResponse
	(*Task)(nil),                            // 12: google.cloud.osconfig.agentendpoint.v1.Task
	(TaskType)(0),                           // 13: google.cloud.osconfig.agentendpoint.v1.TaskType
	(*ApplyPatchesTaskProgress)(nil),        // 14: google.cloud.osconfig.agentendpoint.v1.ApplyPatchesTaskProgress
	(*ExecStepTaskProgress)(nil),            // 15: google.cloud.osconfig.agentendpoint.v1.ExecStepTaskProgress
	(*ApplyConfigTaskProgress)(nil),         // 16: google.cloud.osconfig.agentendpoint.v1.ApplyConfigTaskProgress
	(TaskDirective)(0),                      // 17: google.cloud.osconfig.agentendpoint.v1.TaskDirective
	(*ApplyPatchesTaskOutput)(nil),          // 18: google.cloud.osconfig.agentendpoint.v1.ApplyPatchesTaskOutput
	(*ExecStepTaskOutput)(nil),              // 19: google.cloud.osconfig.agentendpoint.v1.ExecStepTaskOutput
	(*ApplyConfigTaskOutput)(nil),           // 20: google.cloud.osconfig.agentendpoint.v1.ApplyConfigTaskOutput
	(*Inventory)(nil),                       // 21: google.cloud.osconfig.agentendpoint.v1.Inventory
}
var file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_depIdxs = []int32{
	12, // 0: google.cloud.osconfig.agentendpoint.v1.StartNextTaskResponse.task:type_name -> google.cloud.osconfig.agentendpoint.v1.Task
	13, // 1: google.cloud.osconfig.agentendpoint.v1.ReportTaskProgressRequest.task_type:type_name -> google.cloud.osconfig.agentendpoint.v1.TaskType
	14, // 2: google.cloud.osconfig.agentendpoint.v1.ReportTaskProgressRequest.apply_patches_task_progress:type_name -> google.cloud.osconfig.agentendpoint.v1.ApplyPatchesTaskProgress
	15, // 3: google.cloud.osconfig.agentendpoint.v1.ReportTaskProgressRequest.exec_step_task_progress:type_name -> google.cloud.osconfig.agentendpoint.v1.ExecStepTaskProgress
	16, // 4: google.cloud.osconfig.agentendpoint.v1.ReportTaskProgressRequest.apply_config_task_progress:type_name -> google.cloud.osconfig.agentendpoint.v1.ApplyConfigTaskProgress
	17, // 5: google.cloud.osconfig.agentendpoint.v1.ReportTaskProgressResponse.task_directive:type_name -> google.cloud.osconfig.agentendpoint.v1.TaskDirective
	13, // 6: google.cloud.osconfig.agentendpoint.v1.ReportTaskCompleteRequest.task_type:type_name -> google.cloud.osconfig.agentendpoint.v1.TaskType
	18, // 7: google.cloud.osconfig.agentendpoint.v1.ReportTaskCompleteRequest.apply_patches_task_output:type_name -> google.cloud.osconfig.agentendpoint.v1.ApplyPatchesTaskOutput
	19, // 8: google.cloud.osconfig.agentendpoint.v1.ReportTaskCompleteRequest.exec_step_task_output:type_name -> google.cloud.osconfig.agentendpoint.v1.ExecStepTaskOutput
	20, // 9: google.cloud.osconfig.agentendpoint.v1.ReportTaskCompleteRequest.apply_config_task_output:type_name -> google.cloud.osconfig.agentendpoint.v1.ApplyConfigTaskOutput
	21, // 10: google.cloud.osconfig.agentendpoint.v1.ReportInventoryRequest.inventory:type_name -> google.cloud.osconfig.agentendpoint.v1.Inventory
	0,  // 11: google.cloud.osconfig.agentendpoint.v1.AgentEndpointService.ReceiveTaskNotification:input_type -> google.cloud.osconfig.agentendpoint.v1.ReceiveTaskNotificationRequest
	2,  // 12: google.cloud.osconfig.agentendpoint.v1.AgentEndpointService.StartNextTask:input_type -> google.cloud.osconfig.agentendpoint.v1.StartNextTaskRequest
	4,  // 13: google.cloud.osconfig.agentendpoint.v1.AgentEndpointService.ReportTaskProgress:input_type -> google.cloud.osconfig.agentendpoint.v1.ReportTaskProgressRequest
	6,  // 14: google.cloud.osconfig.agentendpoint.v1.AgentEndpointService.ReportTaskComplete:input_type -> google.cloud.osconfig.agentendpoint.v1.ReportTaskCompleteRequest
	8,  // 15: google.cloud.osconfig.agentendpoint.v1.AgentEndpointService.RegisterAgent:input_type -> google.cloud.osconfig.agentendpoint.v1.RegisterAgentRequest
	10, // 16: google.cloud.osconfig.agentendpoint.v1.AgentEndpointService.ReportInventory:input_type -> google.cloud.osconfig.agentendpoint.v1.ReportInventoryRequest
	1,  // 17: google.cloud.osconfig.agentendpoint.v1.AgentEndpointService.ReceiveTaskNotification:output_type -> google.cloud.osconfig.agentendpoint.v1.ReceiveTaskNotificationResponse
	3,  // 18: google.cloud.osconfig.agentendpoint.v1.AgentEndpointService.StartNextTask:output_type -> google.cloud.osconfig.agentendpoint.v1.StartNextTaskResponse
	5,  // 19: google.cloud.osconfig.agentendpoint.v1.AgentEndpointService.ReportTaskProgress:output_type -> google.cloud.osconfig.agentendpoint.v1.ReportTaskProgressResponse
	7,  // 20: google.cloud.osconfig.agentendpoint.v1.AgentEndpointService.ReportTaskComplete:output_type -> google.cloud.osconfig.agentendpoint.v1.ReportTaskCompleteResponse
	9,  // 21: google.cloud.osconfig.agentendpoint.v1.AgentEndpointService.RegisterAgent:output_type -> google.cloud.osconfig.agentendpoint.v1.RegisterAgentResponse
	11, // 22: google.cloud.osconfig.agentendpoint.v1.AgentEndpointService.ReportInventory:output_type -> google.cloud.osconfig.agentendpoint.v1.ReportInventoryResponse
	17, // [17:23] is the sub-list for method output_type
	11, // [11:17] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_init() }
func file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_init() {
	if File_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto != nil {
		return
	}
	file_google_cloud_osconfig_agentendpoint_v1_inventory_proto_init()
	file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReceiveTaskNotificationRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReceiveTaskNotificationResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartNextTaskRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StartNextTaskResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportTaskProgressRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportTaskProgressResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportTaskCompleteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportTaskCompleteResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterAgentRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RegisterAgentResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportInventoryRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportInventoryResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*ReportTaskProgressRequest_ApplyPatchesTaskProgress)(nil),
		(*ReportTaskProgressRequest_ExecStepTaskProgress)(nil),
		(*ReportTaskProgressRequest_ApplyConfigTaskProgress)(nil),
	}
	file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes[6].OneofWrappers = []interface{}{
		(*ReportTaskCompleteRequest_ApplyPatchesTaskOutput)(nil),
		(*ReportTaskCompleteRequest_ExecStepTaskOutput)(nil),
		(*ReportTaskCompleteRequest_ApplyConfigTaskOutput)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_goTypes,
		DependencyIndexes: file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_depIdxs,
		MessageInfos:      file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_msgTypes,
	}.Build()
	File_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto = out.File
	file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_rawDesc = nil
	file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_goTypes = nil
	file_google_cloud_osconfig_agentendpoint_v1_agentendpoint_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// AgentEndpointServiceClient is the client API for AgentEndpointService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type AgentEndpointServiceClient interface {
	// Stream established by client to receive Task notifications.
	ReceiveTaskNotification(ctx context.Context, in *ReceiveTaskNotificationRequest, opts ...grpc.CallOption) (AgentEndpointService_ReceiveTaskNotificationClient, error)
	// Signals the start of a task execution and returns the task info.
	StartNextTask(ctx context.Context, in *StartNextTaskRequest, opts ...grpc.CallOption) (*StartNextTaskResponse, error)
	// Signals an intermediary progress checkpoint in task execution.
	ReportTaskProgress(ctx context.Context, in *ReportTaskProgressRequest, opts ...grpc.CallOption) (*ReportTaskProgressResponse, error)
	// Signals that the task execution is complete and optionally returns the next
	// task.
	ReportTaskComplete(ctx context.Context, in *ReportTaskCompleteRequest, opts ...grpc.CallOption) (*ReportTaskCompleteResponse, error)
	// Registers the agent running on the VM.
	RegisterAgent(ctx context.Context, in *RegisterAgentRequest, opts ...grpc.CallOption) (*RegisterAgentResponse, error)
	// Reports the VMs current inventory.
	ReportInventory(ctx context.Context, in *ReportInventoryRequest, opts ...grpc.CallOption) (*ReportInventoryResponse, error)
}

type agentEndpointServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAgentEndpointServiceClient(cc grpc.ClientConnInterface) AgentEndpointServiceClient {
	return &agentEndpointServiceClient{cc}
}

func (c *agentEndpointServiceClient) ReceiveTaskNotification(ctx context.Context, in *ReceiveTaskNotificationRequest, opts ...grpc.CallOption) (AgentEndpointService_ReceiveTaskNotificationClient, error) {
	stream, err := c.cc.NewStream(ctx, &_AgentEndpointService_serviceDesc.Streams[0], "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/ReceiveTaskNotification", opts...)
	if err != nil {
		return nil, err
	}
	x := &agentEndpointServiceReceiveTaskNotificationClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type AgentEndpointService_ReceiveTaskNotificationClient interface {
	Recv() (*ReceiveTaskNotificationResponse, error)
	grpc.ClientStream
}

type agentEndpointServiceReceiveTaskNotificationClient struct {
	grpc.ClientStream
}

func (x *agentEndpointServiceReceiveTaskNotificationClient) Recv() (*ReceiveTaskNotificationResponse, error) {
	m := new(ReceiveTaskNotificationResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *agentEndpointServiceClient) StartNextTask(ctx context.Context, in *StartNextTaskRequest, opts ...grpc.CallOption) (*StartNextTaskResponse, error) {
	out := new(StartNextTaskResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/StartNextTask", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentEndpointServiceClient) ReportTaskProgress(ctx context.Context, in *ReportTaskProgressRequest, opts ...grpc.CallOption) (*ReportTaskProgressResponse, error) {
	out := new(ReportTaskProgressResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/ReportTaskProgress", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentEndpointServiceClient) ReportTaskComplete(ctx context.Context, in *ReportTaskCompleteRequest, opts ...grpc.CallOption) (*ReportTaskCompleteResponse, error) {
	out := new(ReportTaskCompleteResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/ReportTaskComplete", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentEndpointServiceClient) RegisterAgent(ctx context.Context, in *RegisterAgentRequest, opts ...grpc.CallOption) (*RegisterAgentResponse, error) {
	out := new(RegisterAgentResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/RegisterAgent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *agentEndpointServiceClient) ReportInventory(ctx context.Context, in *ReportInventoryRequest, opts ...grpc.CallOption) (*ReportInventoryResponse, error) {
	out := new(ReportInventoryResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/ReportInventory", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AgentEndpointServiceServer is the server API for AgentEndpointService service.
type AgentEndpointServiceServer interface {
	// Stream established by client to receive Task notifications.
	ReceiveTaskNotification(*ReceiveTaskNotificationRequest, AgentEndpointService_ReceiveTaskNotificationServer) error
	// Signals the start of a task execution and returns the task info.
	StartNextTask(context.Context, *StartNextTaskRequest) (*StartNextTaskResponse, error)
	// Signals an intermediary progress checkpoint in task execution.
	ReportTaskProgress(context.Context, *ReportTaskProgressRequest) (*ReportTaskProgressResponse, error)
	// Signals that the task execution is complete and optionally returns the next
	// task.
	ReportTaskComplete(context.Context, *ReportTaskCompleteRequest) (*ReportTaskCompleteResponse, error)
	// Registers the agent running on the VM.
	RegisterAgent(context.Context, *RegisterAgentRequest) (*RegisterAgentResponse, error)
	// Reports the VMs current inventory.
	ReportInventory(context.Context, *ReportInventoryRequest) (*ReportInventoryResponse, error)
}

// UnimplementedAgentEndpointServiceServer can be embedded to have forward compatible implementations.
type UnimplementedAgentEndpointServiceServer struct {
}

func (*UnimplementedAgentEndpointServiceServer) ReceiveTaskNotification(*ReceiveTaskNotificationRequest, AgentEndpointService_ReceiveTaskNotificationServer) error {
	return status.Errorf(codes.Unimplemented, "method ReceiveTaskNotification not implemented")
}
func (*UnimplementedAgentEndpointServiceServer) StartNextTask(context.Context, *StartNextTaskRequest) (*StartNextTaskResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartNextTask not implemented")
}
func (*UnimplementedAgentEndpointServiceServer) ReportTaskProgress(context.Context, *ReportTaskProgressRequest) (*ReportTaskProgressResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportTaskProgress not implemented")
}
func (*UnimplementedAgentEndpointServiceServer) ReportTaskComplete(context.Context, *ReportTaskCompleteRequest) (*ReportTaskCompleteResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportTaskComplete not implemented")
}
func (*UnimplementedAgentEndpointServiceServer) RegisterAgent(context.Context, *RegisterAgentRequest) (*RegisterAgentResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RegisterAgent not implemented")
}
func (*UnimplementedAgentEndpointServiceServer) ReportInventory(context.Context, *ReportInventoryRequest) (*ReportInventoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportInventory not implemented")
}

func RegisterAgentEndpointServiceServer(s *grpc.Server, srv AgentEndpointServiceServer) {
	s.RegisterService(&_AgentEndpointService_serviceDesc, srv)
}

func _AgentEndpointService_ReceiveTaskNotification_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ReceiveTaskNotificationRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(AgentEndpointServiceServer).ReceiveTaskNotification(m, &agentEndpointServiceReceiveTaskNotificationServer{stream})
}

type AgentEndpointService_ReceiveTaskNotificationServer interface {
	Send(*ReceiveTaskNotificationResponse) error
	grpc.ServerStream
}

type agentEndpointServiceReceiveTaskNotificationServer struct {
	grpc.ServerStream
}

func (x *agentEndpointServiceReceiveTaskNotificationServer) Send(m *ReceiveTaskNotificationResponse) error {
	return x.ServerStream.SendMsg(m)
}

func _AgentEndpointService_StartNextTask_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartNextTaskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).StartNextTask(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/StartNextTask",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).StartNextTask(ctx, req.(*StartNextTaskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AgentEndpointService_ReportTaskProgress_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportTaskProgressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).ReportTaskProgress(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/ReportTaskProgress",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).ReportTaskProgress(ctx, req.(*ReportTaskProgressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AgentEndpointService_ReportTaskComplete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportTaskCompleteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).ReportTaskComplete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/ReportTaskComplete",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).ReportTaskComplete(ctx, req.(*ReportTaskCompleteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AgentEndpointService_RegisterAgent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RegisterAgentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).RegisterAgent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/RegisterAgent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).RegisterAgent(ctx, req.(*RegisterAgentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AgentEndpointService_ReportInventory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportInventoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AgentEndpointServiceServer).ReportInventory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.osconfig.agentendpoint.v1.AgentEndpointService/ReportInventory",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AgentEndpointServiceServer).ReportInventory(ctx, req.(*ReportInventoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _AgentEndpointService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.osconfig.agentendpoint.v1.AgentEndpointService",
	HandlerType: (*AgentEndpointServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "StartNextTask",
			Handler:    _AgentEndpointService_StartNextTask_Handler,
		},
		{
			MethodName: "ReportTaskProgress",
			Handler:    _AgentEndpointService_ReportTaskProgress_Handler,
		},
		{
			MethodName: "ReportTaskComplete",
			Handler:    _AgentEndpointService_ReportTaskComplete_Handler,
		},
		{
			MethodName: "RegisterAgent",
			Handler:    _AgentEndpointService_RegisterAgent_Handler,
		},
		{
			MethodName: "ReportInventory",
			Handler:    _AgentEndpointService_ReportInventory_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "ReceiveTaskNotification",
			Handler:       _AgentEndpointService_ReceiveTaskNotification_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/cloud/osconfig/agentendpoint/v1/agentendpoint.proto",
}
