// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.23.2
// source: google/cloud/video/stitcher/v1/sessions.proto

package stitcherpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Defines the ordering policy during manifest generation.
type ManifestOptions_OrderPolicy int32

const (
	// Ordering policy is not specified.
	ManifestOptions_ORDER_POLICY_UNSPECIFIED ManifestOptions_OrderPolicy = 0
	// Order by ascending.
	ManifestOptions_ASCENDING ManifestOptions_OrderPolicy = 1
	// Order by descending.
	ManifestOptions_DESCENDING ManifestOptions_OrderPolicy = 2
)

// Enum value maps for ManifestOptions_OrderPolicy.
var (
	ManifestOptions_OrderPolicy_name = map[int32]string{
		0: "ORDER_POLICY_UNSPECIFIED",
		1: "ASCENDING",
		2: "DESCENDING",
	}
	ManifestOptions_OrderPolicy_value = map[string]int32{
		"ORDER_POLICY_UNSPECIFIED": 0,
		"ASCENDING":                1,
		"DESCENDING":               2,
	}
)

func (x ManifestOptions_OrderPolicy) Enum() *ManifestOptions_OrderPolicy {
	p := new(ManifestOptions_OrderPolicy)
	*p = x
	return p
}

func (x ManifestOptions_OrderPolicy) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ManifestOptions_OrderPolicy) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_video_stitcher_v1_sessions_proto_enumTypes[0].Descriptor()
}

func (ManifestOptions_OrderPolicy) Type() protoreflect.EnumType {
	return &file_google_cloud_video_stitcher_v1_sessions_proto_enumTypes[0]
}

func (x ManifestOptions_OrderPolicy) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ManifestOptions_OrderPolicy.Descriptor instead.
func (ManifestOptions_OrderPolicy) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_sessions_proto_rawDescGZIP(), []int{6, 0}
}

// Metadata for a VOD session. The session expires 4 hours after its creation.
type VodSession struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the VOD session, in the form of
	// `projects/{project_number}/locations/{location}/vodSessions/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Metadata of what was stitched into the content.
	Interstitials *Interstitials `protobuf:"bytes,2,opt,name=interstitials,proto3" json:"interstitials,omitempty"`
	// Output only. The playback URI of the stitched content.
	PlayUri string `protobuf:"bytes,4,opt,name=play_uri,json=playUri,proto3" json:"play_uri,omitempty"`
	// Required. URI of the media to stitch.
	SourceUri string `protobuf:"bytes,5,opt,name=source_uri,json=sourceUri,proto3" json:"source_uri,omitempty"`
	// Required. Ad tag URI.
	AdTagUri string `protobuf:"bytes,6,opt,name=ad_tag_uri,json=adTagUri,proto3" json:"ad_tag_uri,omitempty"`
	// Key value pairs for ad tag macro replacement. If the
	// specified ad tag URI has macros, this field provides the mapping
	// to the value that will replace the macro in the ad tag URI.
	// Macros are designated by square brackets.
	// For example:
	//
	//   Ad tag URI: `"https://doubleclick.google.com/ad/1?geo_id=[geoId]"`
	//
	//   Ad tag macro map: `{"geoId": "123"}`
	//
	//   Fully qualified ad tag:
	//   `"`https://doubleclick.google.com/ad/1?geo_id=123"`
	AdTagMacroMap map[string]string `protobuf:"bytes,7,rep,name=ad_tag_macro_map,json=adTagMacroMap,proto3" json:"ad_tag_macro_map,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Additional options that affect the output of the manifest.
	ManifestOptions *ManifestOptions `protobuf:"bytes,9,opt,name=manifest_options,json=manifestOptions,proto3" json:"manifest_options,omitempty"`
	// Output only. The generated ID of the VodSession's source media.
	AssetId string `protobuf:"bytes,10,opt,name=asset_id,json=assetId,proto3" json:"asset_id,omitempty"`
	// Required. Determines how the ad should be tracked.
	AdTracking AdTracking `protobuf:"varint,11,opt,name=ad_tracking,json=adTracking,proto3,enum=google.cloud.video.stitcher.v1.AdTracking" json:"ad_tracking,omitempty"`
	// This field should be set with appropriate values if GAM is being used for
	// ads.
	GamSettings *VodSession_GamSettings `protobuf:"bytes,13,opt,name=gam_settings,json=gamSettings,proto3" json:"gam_settings,omitempty"`
}

func (x *VodSession) Reset() {
	*x = VodSession{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VodSession) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VodSession) ProtoMessage() {}

func (x *VodSession) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VodSession.ProtoReflect.Descriptor instead.
func (*VodSession) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_sessions_proto_rawDescGZIP(), []int{0}
}

func (x *VodSession) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VodSession) GetInterstitials() *Interstitials {
	if x != nil {
		return x.Interstitials
	}
	return nil
}

func (x *VodSession) GetPlayUri() string {
	if x != nil {
		return x.PlayUri
	}
	return ""
}

func (x *VodSession) GetSourceUri() string {
	if x != nil {
		return x.SourceUri
	}
	return ""
}

func (x *VodSession) GetAdTagUri() string {
	if x != nil {
		return x.AdTagUri
	}
	return ""
}

func (x *VodSession) GetAdTagMacroMap() map[string]string {
	if x != nil {
		return x.AdTagMacroMap
	}
	return nil
}

func (x *VodSession) GetManifestOptions() *ManifestOptions {
	if x != nil {
		return x.ManifestOptions
	}
	return nil
}

func (x *VodSession) GetAssetId() string {
	if x != nil {
		return x.AssetId
	}
	return ""
}

func (x *VodSession) GetAdTracking() AdTracking {
	if x != nil {
		return x.AdTracking
	}
	return AdTracking_AD_TRACKING_UNSPECIFIED
}

func (x *VodSession) GetGamSettings() *VodSession_GamSettings {
	if x != nil {
		return x.GamSettings
	}
	return nil
}

// Describes what was stitched into a VOD session's manifest.
type Interstitials struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of ad breaks ordered by time.
	AdBreaks []*VodSessionAdBreak `protobuf:"bytes,1,rep,name=ad_breaks,json=adBreaks,proto3" json:"ad_breaks,omitempty"`
	// Information related to the content of the VOD session.
	SessionContent *VodSessionContent `protobuf:"bytes,2,opt,name=session_content,json=sessionContent,proto3" json:"session_content,omitempty"`
}

func (x *Interstitials) Reset() {
	*x = Interstitials{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Interstitials) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Interstitials) ProtoMessage() {}

func (x *Interstitials) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Interstitials.ProtoReflect.Descriptor instead.
func (*Interstitials) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_sessions_proto_rawDescGZIP(), []int{1}
}

func (x *Interstitials) GetAdBreaks() []*VodSessionAdBreak {
	if x != nil {
		return x.AdBreaks
	}
	return nil
}

func (x *Interstitials) GetSessionContent() *VodSessionContent {
	if x != nil {
		return x.SessionContent
	}
	return nil
}

// Metadata for an inserted ad in a VOD session.
type VodSessionAd struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Duration in seconds of the ad.
	Duration *durationpb.Duration `protobuf:"bytes,1,opt,name=duration,proto3" json:"duration,omitempty"`
	// Metadata of companion ads associated with the ad.
	CompanionAds *CompanionAds `protobuf:"bytes,2,opt,name=companion_ads,json=companionAds,proto3" json:"companion_ads,omitempty"`
	// The list of progress tracking events for the ad break. These can be of
	// the following IAB types: `MUTE`, `UNMUTE`, `PAUSE`, `CLICK`,
	// `CLICK_THROUGH`, `REWIND`, `RESUME`, `ERROR`, `FULLSCREEN`,
	// `EXIT_FULLSCREEN`, `EXPAND`, `COLLAPSE`, `ACCEPT_INVITATION_LINEAR`,
	// `CLOSE_LINEAR`, `SKIP`.
	ActivityEvents []*Event `protobuf:"bytes,3,rep,name=activity_events,json=activityEvents,proto3" json:"activity_events,omitempty"`
}

func (x *VodSessionAd) Reset() {
	*x = VodSessionAd{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VodSessionAd) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VodSessionAd) ProtoMessage() {}

func (x *VodSessionAd) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VodSessionAd.ProtoReflect.Descriptor instead.
func (*VodSessionAd) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_sessions_proto_rawDescGZIP(), []int{2}
}

func (x *VodSessionAd) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

func (x *VodSessionAd) GetCompanionAds() *CompanionAds {
	if x != nil {
		return x.CompanionAds
	}
	return nil
}

func (x *VodSessionAd) GetActivityEvents() []*Event {
	if x != nil {
		return x.ActivityEvents
	}
	return nil
}

// Metadata for the entire stitched content in a VOD session.
type VodSessionContent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The total duration in seconds of the content including the ads stitched
	// in.
	Duration *durationpb.Duration `protobuf:"bytes,1,opt,name=duration,proto3" json:"duration,omitempty"`
}

func (x *VodSessionContent) Reset() {
	*x = VodSessionContent{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VodSessionContent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VodSessionContent) ProtoMessage() {}

func (x *VodSessionContent) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VodSessionContent.ProtoReflect.Descriptor instead.
func (*VodSessionContent) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_sessions_proto_rawDescGZIP(), []int{3}
}

func (x *VodSessionContent) GetDuration() *durationpb.Duration {
	if x != nil {
		return x.Duration
	}
	return nil
}

// Metadata for an inserted ad break.
type VodSessionAdBreak struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of events that are expected to be triggered, ordered by time.
	ProgressEvents []*ProgressEvent `protobuf:"bytes,1,rep,name=progress_events,json=progressEvents,proto3" json:"progress_events,omitempty"`
	// Ordered list of ads stitched into the ad break.
	Ads []*VodSessionAd `protobuf:"bytes,2,rep,name=ads,proto3" json:"ads,omitempty"`
	// Ad break end time in seconds relative to the start of the VOD asset.
	EndTimeOffset *durationpb.Duration `protobuf:"bytes,3,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	// Ad break start time in seconds relative to the start of the VOD asset.
	StartTimeOffset *durationpb.Duration `protobuf:"bytes,4,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
}

func (x *VodSessionAdBreak) Reset() {
	*x = VodSessionAdBreak{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VodSessionAdBreak) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VodSessionAdBreak) ProtoMessage() {}

func (x *VodSessionAdBreak) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VodSessionAdBreak.ProtoReflect.Descriptor instead.
func (*VodSessionAdBreak) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_sessions_proto_rawDescGZIP(), []int{4}
}

func (x *VodSessionAdBreak) GetProgressEvents() []*ProgressEvent {
	if x != nil {
		return x.ProgressEvents
	}
	return nil
}

func (x *VodSessionAdBreak) GetAds() []*VodSessionAd {
	if x != nil {
		return x.Ads
	}
	return nil
}

func (x *VodSessionAdBreak) GetEndTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.EndTimeOffset
	}
	return nil
}

func (x *VodSessionAdBreak) GetStartTimeOffset() *durationpb.Duration {
	if x != nil {
		return x.StartTimeOffset
	}
	return nil
}

// Metadata for a live session. The session expires 5 minutes after the client
// stops fetching the session's playlists.
type LiveSession struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The name of the live session, in the form of
	// `projects/{project}/locations/{location}/liveSessions/{id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The URI to play the live session's ad-stitched stream.
	PlayUri string `protobuf:"bytes,2,opt,name=play_uri,json=playUri,proto3" json:"play_uri,omitempty"`
	// Key value pairs for ad tag macro replacement. If the
	// specified ad tag URI has macros, this field provides the mapping
	// to the value that will replace the macro in the ad tag URI.
	// Macros are designated by square brackets.
	//
	// For example:
	//
	//   Ad tag URI: "https://doubleclick.google.com/ad/1?geo_id=[geoId]"
	//
	//   Ad tag macros: `{"geoId": "123"}`
	//
	//   Fully qualified ad tag:
	//   `"https://doubleclick.google.com/ad/1?geo_id=123"`
	AdTagMacros map[string]string `protobuf:"bytes,6,rep,name=ad_tag_macros,json=adTagMacros,proto3" json:"ad_tag_macros,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Additional options that affect the output of the manifest.
	ManifestOptions *ManifestOptions `protobuf:"bytes,10,opt,name=manifest_options,json=manifestOptions,proto3" json:"manifest_options,omitempty"`
	// This field should be set with appropriate values if GAM is being used for
	// ads.
	GamSettings *LiveSession_GamSettings `protobuf:"bytes,15,opt,name=gam_settings,json=gamSettings,proto3" json:"gam_settings,omitempty"`
	// Required. The resource name of the live config for this session, in the
	// form of `projects/{project}/locations/{location}/liveConfigs/{id}`.
	LiveConfig string `protobuf:"bytes,16,opt,name=live_config,json=liveConfig,proto3" json:"live_config,omitempty"`
}

func (x *LiveSession) Reset() {
	*x = LiveSession{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LiveSession) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LiveSession) ProtoMessage() {}

func (x *LiveSession) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LiveSession.ProtoReflect.Descriptor instead.
func (*LiveSession) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_sessions_proto_rawDescGZIP(), []int{5}
}

func (x *LiveSession) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *LiveSession) GetPlayUri() string {
	if x != nil {
		return x.PlayUri
	}
	return ""
}

func (x *LiveSession) GetAdTagMacros() map[string]string {
	if x != nil {
		return x.AdTagMacros
	}
	return nil
}

func (x *LiveSession) GetManifestOptions() *ManifestOptions {
	if x != nil {
		return x.ManifestOptions
	}
	return nil
}

func (x *LiveSession) GetGamSettings() *LiveSession_GamSettings {
	if x != nil {
		return x.GamSettings
	}
	return nil
}

func (x *LiveSession) GetLiveConfig() string {
	if x != nil {
		return x.LiveConfig
	}
	return ""
}

// Options for manifest generation.
type ManifestOptions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If specified, the output manifest will only return renditions matching the
	// specified filters.
	IncludeRenditions []*RenditionFilter `protobuf:"bytes,1,rep,name=include_renditions,json=includeRenditions,proto3" json:"include_renditions,omitempty"`
	// If specified, the output manifest will orders the video and muxed
	// renditions by bitrate according to the ordering policy.
	BitrateOrder ManifestOptions_OrderPolicy `protobuf:"varint,2,opt,name=bitrate_order,json=bitrateOrder,proto3,enum=google.cloud.video.stitcher.v1.ManifestOptions_OrderPolicy" json:"bitrate_order,omitempty"`
}

func (x *ManifestOptions) Reset() {
	*x = ManifestOptions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ManifestOptions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManifestOptions) ProtoMessage() {}

func (x *ManifestOptions) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManifestOptions.ProtoReflect.Descriptor instead.
func (*ManifestOptions) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_sessions_proto_rawDescGZIP(), []int{6}
}

func (x *ManifestOptions) GetIncludeRenditions() []*RenditionFilter {
	if x != nil {
		return x.IncludeRenditions
	}
	return nil
}

func (x *ManifestOptions) GetBitrateOrder() ManifestOptions_OrderPolicy {
	if x != nil {
		return x.BitrateOrder
	}
	return ManifestOptions_ORDER_POLICY_UNSPECIFIED
}

// Filters for a video or muxed redition.
type RenditionFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Bitrate in bits per second for the rendition. If set, only renditions with
	// the exact bitrate will match.
	BitrateBps int32 `protobuf:"varint,1,opt,name=bitrate_bps,json=bitrateBps,proto3" json:"bitrate_bps,omitempty"`
	// Codecs for the rendition. If set, only renditions with the exact value
	// will match.
	Codecs string `protobuf:"bytes,2,opt,name=codecs,proto3" json:"codecs,omitempty"`
}

func (x *RenditionFilter) Reset() {
	*x = RenditionFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *RenditionFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RenditionFilter) ProtoMessage() {}

func (x *RenditionFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RenditionFilter.ProtoReflect.Descriptor instead.
func (*RenditionFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_sessions_proto_rawDescGZIP(), []int{7}
}

func (x *RenditionFilter) GetBitrateBps() int32 {
	if x != nil {
		return x.BitrateBps
	}
	return 0
}

func (x *RenditionFilter) GetCodecs() string {
	if x != nil {
		return x.Codecs
	}
	return ""
}

// Defines fields related to Google Ad Manager (GAM). This should be set if
// GAM is being used for ads.
type VodSession_GamSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Ad Manager network code.
	NetworkCode string `protobuf:"bytes,1,opt,name=network_code,json=networkCode,proto3" json:"network_code,omitempty"`
	// Required. The stream ID generated by Ad Manager.
	StreamId string `protobuf:"bytes,2,opt,name=stream_id,json=streamId,proto3" json:"stream_id,omitempty"`
}

func (x *VodSession_GamSettings) Reset() {
	*x = VodSession_GamSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VodSession_GamSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VodSession_GamSettings) ProtoMessage() {}

func (x *VodSession_GamSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VodSession_GamSettings.ProtoReflect.Descriptor instead.
func (*VodSession_GamSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_sessions_proto_rawDescGZIP(), []int{0, 0}
}

func (x *VodSession_GamSettings) GetNetworkCode() string {
	if x != nil {
		return x.NetworkCode
	}
	return ""
}

func (x *VodSession_GamSettings) GetStreamId() string {
	if x != nil {
		return x.StreamId
	}
	return ""
}

// Defines fields related to Google Ad Manager (GAM). This should be set if
// GAM is being used for ads.
type LiveSession_GamSettings struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The stream ID generated by Ad Manager.
	StreamId string `protobuf:"bytes,1,opt,name=stream_id,json=streamId,proto3" json:"stream_id,omitempty"`
}

func (x *LiveSession_GamSettings) Reset() {
	*x = LiveSession_GamSettings{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LiveSession_GamSettings) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LiveSession_GamSettings) ProtoMessage() {}

func (x *LiveSession_GamSettings) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LiveSession_GamSettings.ProtoReflect.Descriptor instead.
func (*LiveSession_GamSettings) Descriptor() ([]byte, []int) {
	return file_google_cloud_video_stitcher_v1_sessions_proto_rawDescGZIP(), []int{5, 0}
}

func (x *LiveSession_GamSettings) GetStreamId() string {
	if x != nil {
		return x.StreamId
	}
	return ""
}

var File_google_cloud_video_stitcher_v1_sessions_proto protoreflect.FileDescriptor

var file_google_cloud_video_stitcher_v1_sessions_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76, 0x31,
	0x2f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x1a,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f,
	0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x70,
	0x61, 0x6e, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2b, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74,
	0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x83, 0x07, 0x0a,
	0x0a, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x17, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x12, 0x58, 0x0a, 0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x74, 0x69,
	0x74, 0x69, 0x61, 0x6c, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f,
	0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6e, 0x74,
	0x65, 0x72, 0x73, 0x74, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x74, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x73, 0x12, 0x1e,
	0x0a, 0x08, 0x70, 0x6c, 0x61, 0x79, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x70, 0x6c, 0x61, 0x79, 0x55, 0x72, 0x69, 0x12, 0x22,
	0x0a, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55,
	0x72, 0x69, 0x12, 0x21, 0x0a, 0x0a, 0x61, 0x64, 0x5f, 0x74, 0x61, 0x67, 0x5f, 0x75, 0x72, 0x69,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x61, 0x64, 0x54,
	0x61, 0x67, 0x55, 0x72, 0x69, 0x12, 0x66, 0x0a, 0x10, 0x61, 0x64, 0x5f, 0x74, 0x61, 0x67, 0x5f,
	0x6d, 0x61, 0x63, 0x72, 0x6f, 0x5f, 0x6d, 0x61, 0x70, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x64, 0x54, 0x61,
	0x67, 0x4d, 0x61, 0x63, 0x72, 0x6f, 0x4d, 0x61, 0x70, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d,
	0x61, 0x64, 0x54, 0x61, 0x67, 0x4d, 0x61, 0x63, 0x72, 0x6f, 0x4d, 0x61, 0x70, 0x12, 0x5a, 0x0a,
	0x10, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73,
	0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0f, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65,
	0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x1e, 0x0a, 0x08, 0x61, 0x73, 0x73,
	0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x07, 0x61, 0x73, 0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x50, 0x0a, 0x0b, 0x61, 0x64, 0x5f,
	0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69,
	0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x64, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x61, 0x64, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x12, 0x59, 0x0a, 0x0c, 0x67,
	0x61, 0x6d, 0x5f, 0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x36, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x61,
	0x6d, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0b, 0x67, 0x61, 0x6d, 0x53, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x1a, 0x57, 0x0a, 0x0b, 0x47, 0x61, 0x6d, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x26, 0x0a, 0x0c, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x43, 0x6f, 0x64, 0x65, 0x12, 0x20, 0x0a,
	0x09, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x49, 0x64, 0x1a,
	0x40, 0x0a, 0x12, 0x41, 0x64, 0x54, 0x61, 0x67, 0x4d, 0x61, 0x63, 0x72, 0x6f, 0x4d, 0x61, 0x70,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38,
	0x01, 0x3a, 0x6f, 0xea, 0x41, 0x6c, 0x0a, 0x27, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x41, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x76, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x76, 0x6f, 0x64, 0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x7d, 0x22, 0xbb, 0x01, 0x0a, 0x0d, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x74, 0x69, 0x74,
	0x69, 0x61, 0x6c, 0x73, 0x12, 0x4e, 0x0a, 0x09, 0x61, 0x64, 0x5f, 0x62, 0x72, 0x65, 0x61, 0x6b,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69,
	0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x41, 0x64, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x52, 0x08, 0x61, 0x64, 0x42, 0x72,
	0x65, 0x61, 0x6b, 0x73, 0x12, 0x5a, 0x0a, 0x0f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64,
	0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x52, 0x0e, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x22, 0xe8, 0x01, 0x0a, 0x0c, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x41,
	0x64, 0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08,
	0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x51, 0x0a, 0x0d, 0x63, 0x6f, 0x6d, 0x70,
	0x61, 0x6e, 0x69, 0x6f, 0x6e, 0x5f, 0x61, 0x64, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x69, 0x6f, 0x6e, 0x41, 0x64, 0x73, 0x52, 0x0c, 0x63,
	0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x69, 0x6f, 0x6e, 0x41, 0x64, 0x73, 0x12, 0x4e, 0x0a, 0x0f, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x0e, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x69, 0x74, 0x79, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x4a, 0x0a, 0x11, 0x56,
	0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x12, 0x35, 0x0a, 0x08, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xb5, 0x02, 0x0a, 0x11, 0x56, 0x6f, 0x64, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x64, 0x42, 0x72, 0x65, 0x61, 0x6b, 0x12, 0x56, 0x0a,
	0x0f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73,
	0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74,
	0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x0e, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x3e, 0x0a, 0x03, 0x61, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x56, 0x6f, 0x64, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x41, 0x64,
	0x52, 0x03, 0x61, 0x64, 0x73, 0x12, 0x41, 0x0a, 0x0f, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x65, 0x6e, 0x64, 0x54, 0x69,
	0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x45, 0x0a, 0x11, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22,
	0x97, 0x05, 0x0a, 0x0b, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x70, 0x6c, 0x61, 0x79,
	0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x07, 0x70, 0x6c, 0x61, 0x79, 0x55, 0x72, 0x69, 0x12, 0x60, 0x0a, 0x0d, 0x61, 0x64, 0x5f, 0x74,
	0x61, 0x67, 0x5f, 0x6d, 0x61, 0x63, 0x72, 0x6f, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76,
	0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x41, 0x64, 0x54,
	0x61, 0x67, 0x4d, 0x61, 0x63, 0x72, 0x6f, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0b, 0x61,
	0x64, 0x54, 0x61, 0x67, 0x4d, 0x61, 0x63, 0x72, 0x6f, 0x73, 0x12, 0x5a, 0x0a, 0x10, 0x6d, 0x61,
	0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x5f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x0f, 0x6d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x4f,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5a, 0x0a, 0x0c, 0x67, 0x61, 0x6d, 0x5f, 0x73, 0x65,
	0x74, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69,
	0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x47, 0x61, 0x6d, 0x53, 0x65, 0x74,
	0x74, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x0b, 0x67, 0x61, 0x6d, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e,
	0x67, 0x73, 0x12, 0x50, 0x0a, 0x0b, 0x6c, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a,
	0x27, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69,
	0x76, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0a, 0x6c, 0x69, 0x76, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x1a, 0x2f, 0x0a, 0x0b, 0x47, 0x61, 0x6d, 0x53, 0x65, 0x74, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x20, 0x0a, 0x09, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x73, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x49, 0x64, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x64, 0x54, 0x61, 0x67, 0x4d, 0x61,
	0x63, 0x72, 0x6f, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0x72, 0xea, 0x41, 0x6f, 0x0a, 0x28, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x69, 0x76, 0x65, 0x53, 0x65, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x43, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x69,
	0x76, 0x65, 0x53, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x69, 0x76, 0x65,
	0x5f, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x7d, 0x22, 0x9f, 0x02, 0x0a, 0x0f, 0x4d, 0x61,
	0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x5e, 0x0a,
	0x12, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x72, 0x65, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73,
	0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x6e, 0x64, 0x69,
	0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x52, 0x11, 0x69, 0x6e, 0x63, 0x6c,
	0x75, 0x64, 0x65, 0x52, 0x65, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x60, 0x0a,
	0x0d, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x69, 0x66, 0x65, 0x73, 0x74, 0x4f, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x52, 0x0c, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x22,
	0x4a, 0x0a, 0x0b, 0x4f, 0x72, 0x64, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x1c,
	0x0a, 0x18, 0x4f, 0x52, 0x44, 0x45, 0x52, 0x5f, 0x50, 0x4f, 0x4c, 0x49, 0x43, 0x59, 0x5f, 0x55,
	0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09,
	0x41, 0x53, 0x43, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x44,
	0x45, 0x53, 0x43, 0x45, 0x4e, 0x44, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x22, 0x4a, 0x0a, 0x0f, 0x52,
	0x65, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1f,
	0x0a, 0x0b, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x5f, 0x62, 0x70, 0x73, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x0a, 0x62, 0x69, 0x74, 0x72, 0x61, 0x74, 0x65, 0x42, 0x70, 0x73, 0x12,
	0x16, 0x0a, 0x06, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x63, 0x6f, 0x64, 0x65, 0x63, 0x73, 0x42, 0x75, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x76, 0x69, 0x64, 0x65,
	0x6f, 0x2e, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x0d, 0x53,
	0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68,
	0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65,
	0x72, 0x70, 0x62, 0x3b, 0x73, 0x74, 0x69, 0x74, 0x63, 0x68, 0x65, 0x72, 0x70, 0x62, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_video_stitcher_v1_sessions_proto_rawDescOnce sync.Once
	file_google_cloud_video_stitcher_v1_sessions_proto_rawDescData = file_google_cloud_video_stitcher_v1_sessions_proto_rawDesc
)

func file_google_cloud_video_stitcher_v1_sessions_proto_rawDescGZIP() []byte {
	file_google_cloud_video_stitcher_v1_sessions_proto_rawDescOnce.Do(func() {
		file_google_cloud_video_stitcher_v1_sessions_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_video_stitcher_v1_sessions_proto_rawDescData)
	})
	return file_google_cloud_video_stitcher_v1_sessions_proto_rawDescData
}

var file_google_cloud_video_stitcher_v1_sessions_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_video_stitcher_v1_sessions_proto_goTypes = []interface{}{
	(ManifestOptions_OrderPolicy)(0), // 0: google.cloud.video.stitcher.v1.ManifestOptions.OrderPolicy
	(*VodSession)(nil),               // 1: google.cloud.video.stitcher.v1.VodSession
	(*Interstitials)(nil),            // 2: google.cloud.video.stitcher.v1.Interstitials
	(*VodSessionAd)(nil),             // 3: google.cloud.video.stitcher.v1.VodSessionAd
	(*VodSessionContent)(nil),        // 4: google.cloud.video.stitcher.v1.VodSessionContent
	(*VodSessionAdBreak)(nil),        // 5: google.cloud.video.stitcher.v1.VodSessionAdBreak
	(*LiveSession)(nil),              // 6: google.cloud.video.stitcher.v1.LiveSession
	(*ManifestOptions)(nil),          // 7: google.cloud.video.stitcher.v1.ManifestOptions
	(*RenditionFilter)(nil),          // 8: google.cloud.video.stitcher.v1.RenditionFilter
	(*VodSession_GamSettings)(nil),   // 9: google.cloud.video.stitcher.v1.VodSession.GamSettings
	nil,                              // 10: google.cloud.video.stitcher.v1.VodSession.AdTagMacroMapEntry
	(*LiveSession_GamSettings)(nil),  // 11: google.cloud.video.stitcher.v1.LiveSession.GamSettings
	nil,                              // 12: google.cloud.video.stitcher.v1.LiveSession.AdTagMacrosEntry
	(AdTracking)(0),                  // 13: google.cloud.video.stitcher.v1.AdTracking
	(*durationpb.Duration)(nil),      // 14: google.protobuf.Duration
	(*CompanionAds)(nil),             // 15: google.cloud.video.stitcher.v1.CompanionAds
	(*Event)(nil),                    // 16: google.cloud.video.stitcher.v1.Event
	(*ProgressEvent)(nil),            // 17: google.cloud.video.stitcher.v1.ProgressEvent
}
var file_google_cloud_video_stitcher_v1_sessions_proto_depIdxs = []int32{
	2,  // 0: google.cloud.video.stitcher.v1.VodSession.interstitials:type_name -> google.cloud.video.stitcher.v1.Interstitials
	10, // 1: google.cloud.video.stitcher.v1.VodSession.ad_tag_macro_map:type_name -> google.cloud.video.stitcher.v1.VodSession.AdTagMacroMapEntry
	7,  // 2: google.cloud.video.stitcher.v1.VodSession.manifest_options:type_name -> google.cloud.video.stitcher.v1.ManifestOptions
	13, // 3: google.cloud.video.stitcher.v1.VodSession.ad_tracking:type_name -> google.cloud.video.stitcher.v1.AdTracking
	9,  // 4: google.cloud.video.stitcher.v1.VodSession.gam_settings:type_name -> google.cloud.video.stitcher.v1.VodSession.GamSettings
	5,  // 5: google.cloud.video.stitcher.v1.Interstitials.ad_breaks:type_name -> google.cloud.video.stitcher.v1.VodSessionAdBreak
	4,  // 6: google.cloud.video.stitcher.v1.Interstitials.session_content:type_name -> google.cloud.video.stitcher.v1.VodSessionContent
	14, // 7: google.cloud.video.stitcher.v1.VodSessionAd.duration:type_name -> google.protobuf.Duration
	15, // 8: google.cloud.video.stitcher.v1.VodSessionAd.companion_ads:type_name -> google.cloud.video.stitcher.v1.CompanionAds
	16, // 9: google.cloud.video.stitcher.v1.VodSessionAd.activity_events:type_name -> google.cloud.video.stitcher.v1.Event
	14, // 10: google.cloud.video.stitcher.v1.VodSessionContent.duration:type_name -> google.protobuf.Duration
	17, // 11: google.cloud.video.stitcher.v1.VodSessionAdBreak.progress_events:type_name -> google.cloud.video.stitcher.v1.ProgressEvent
	3,  // 12: google.cloud.video.stitcher.v1.VodSessionAdBreak.ads:type_name -> google.cloud.video.stitcher.v1.VodSessionAd
	14, // 13: google.cloud.video.stitcher.v1.VodSessionAdBreak.end_time_offset:type_name -> google.protobuf.Duration
	14, // 14: google.cloud.video.stitcher.v1.VodSessionAdBreak.start_time_offset:type_name -> google.protobuf.Duration
	12, // 15: google.cloud.video.stitcher.v1.LiveSession.ad_tag_macros:type_name -> google.cloud.video.stitcher.v1.LiveSession.AdTagMacrosEntry
	7,  // 16: google.cloud.video.stitcher.v1.LiveSession.manifest_options:type_name -> google.cloud.video.stitcher.v1.ManifestOptions
	11, // 17: google.cloud.video.stitcher.v1.LiveSession.gam_settings:type_name -> google.cloud.video.stitcher.v1.LiveSession.GamSettings
	8,  // 18: google.cloud.video.stitcher.v1.ManifestOptions.include_renditions:type_name -> google.cloud.video.stitcher.v1.RenditionFilter
	0,  // 19: google.cloud.video.stitcher.v1.ManifestOptions.bitrate_order:type_name -> google.cloud.video.stitcher.v1.ManifestOptions.OrderPolicy
	20, // [20:20] is the sub-list for method output_type
	20, // [20:20] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_google_cloud_video_stitcher_v1_sessions_proto_init() }
func file_google_cloud_video_stitcher_v1_sessions_proto_init() {
	if File_google_cloud_video_stitcher_v1_sessions_proto != nil {
		return
	}
	file_google_cloud_video_stitcher_v1_companions_proto_init()
	file_google_cloud_video_stitcher_v1_events_proto_init()
	file_google_cloud_video_stitcher_v1_live_configs_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VodSession); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Interstitials); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VodSessionAd); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VodSessionContent); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VodSessionAdBreak); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LiveSession); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ManifestOptions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*RenditionFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VodSession_GamSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LiveSession_GamSettings); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_video_stitcher_v1_sessions_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_video_stitcher_v1_sessions_proto_goTypes,
		DependencyIndexes: file_google_cloud_video_stitcher_v1_sessions_proto_depIdxs,
		EnumInfos:         file_google_cloud_video_stitcher_v1_sessions_proto_enumTypes,
		MessageInfos:      file_google_cloud_video_stitcher_v1_sessions_proto_msgTypes,
	}.Build()
	File_google_cloud_video_stitcher_v1_sessions_proto = out.File
	file_google_cloud_video_stitcher_v1_sessions_proto_rawDesc = nil
	file_google_cloud_video_stitcher_v1_sessions_proto_goTypes = nil
	file_google_cloud_video_stitcher_v1_sessions_proto_depIdxs = nil
}
