/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.diylc.appframework.miscutils.ConfigurationManager;
import org.diylc.common.IPlugInPort;
import org.diylc.common.ITask;
import org.diylc.common.PropertyWrapper;
import org.diylc.core.ExpansionMode;
import org.diylc.core.IDIYComponent;
import org.diylc.core.IView;
import org.diylc.core.Theme;
import org.diylc.images.IconLoader;
import org.diylc.presenter.Presenter;
import org.diylc.swing.ISwingUI;
import org.diylc.swing.gui.DialogFactory;
import org.diylc.swing.gui.editor.PropertyEditorDialog;
import org.diylc.swing.plugins.edit.ComponentTransferable;
import org.diylc.swing.plugins.file.BomDialog;
import org.diylc.swing.plugins.file.FileFilterEnum;
import org.diylc.swingframework.IDrawingProvider;
import org.diylc.swingframework.export.DrawingExporter;
import org.diylc.utils.BomEntry;
import org.diylc.utils.BomMaker;

public class ActionFactory {
    private static final Logger LOG = Logger.getLogger(ActionFactory.class);
    private static ActionFactory instance;

    public static ActionFactory getInstance() {
        if (instance == null) {
            instance = new ActionFactory();
        }
        return instance;
    }

    private ActionFactory() {
    }

    public NewAction createNewAction(IPlugInPort iPlugInPort) {
        return new NewAction(iPlugInPort);
    }

    public OpenAction createOpenAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
        return new OpenAction(iPlugInPort, iSwingUI);
    }

    public ImportAction createImportAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
        return new ImportAction(iPlugInPort, iSwingUI);
    }

    public SaveAction createSaveAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
        return new SaveAction(iPlugInPort, iSwingUI);
    }

    public SaveAsAction createSaveAsAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
        return new SaveAsAction(iPlugInPort, iSwingUI);
    }

    public CreateBomAction createBomAction(IPlugInPort iPlugInPort) {
        return new CreateBomAction(iPlugInPort);
    }

    public ExportPDFAction createExportPDFAction(IDrawingProvider iDrawingProvider, ISwingUI iSwingUI) {
        return new ExportPDFAction(iDrawingProvider, iSwingUI);
    }

    public ExportPNGAction createExportPNGAction(IDrawingProvider iDrawingProvider, ISwingUI iSwingUI) {
        return new ExportPNGAction(iDrawingProvider, iSwingUI);
    }

    public PrintAction createPrintAction(IDrawingProvider iDrawingProvider) {
        return new PrintAction(iDrawingProvider);
    }

    public ExitAction createExitAction(IPlugInPort iPlugInPort) {
        return new ExitAction(iPlugInPort);
    }

    public CutAction createCutAction(IPlugInPort iPlugInPort, Clipboard clipboard, ClipboardOwner clipboardOwner) {
        return new CutAction(iPlugInPort, clipboard, clipboardOwner);
    }

    public CopyAction createCopyAction(IPlugInPort iPlugInPort, Clipboard clipboard, ClipboardOwner clipboardOwner) {
        return new CopyAction(iPlugInPort, clipboard, clipboardOwner);
    }

    public PasteAction createPasteAction(IPlugInPort iPlugInPort, Clipboard clipboard) {
        return new PasteAction(iPlugInPort, clipboard);
    }

    public SelectAllAction createSelectAllAction(IPlugInPort iPlugInPort) {
        return new SelectAllAction(iPlugInPort);
    }

    public GroupAction createGroupAction(IPlugInPort iPlugInPort) {
        return new GroupAction(iPlugInPort);
    }

    public UngroupAction createUngroupAction(IPlugInPort iPlugInPort) {
        return new UngroupAction(iPlugInPort);
    }

    public EditProjectAction createEditProjectAction(IPlugInPort iPlugInPort) {
        return new EditProjectAction(iPlugInPort);
    }

    public EditSelectionAction createEditSelectionAction(IPlugInPort iPlugInPort) {
        return new EditSelectionAction(iPlugInPort);
    }

    public DeleteSelectionAction createDeleteSelectionAction(IPlugInPort iPlugInPort) {
        return new DeleteSelectionAction(iPlugInPort);
    }

    public SaveAsTemplateAction createSaveAsTemplateAction(IPlugInPort iPlugInPort) {
        return new SaveAsTemplateAction(iPlugInPort);
    }

    public ExpandSelectionAction createExpandSelectionAction(IPlugInPort iPlugInPort, ExpansionMode expansionMode) {
        return new ExpandSelectionAction(iPlugInPort, expansionMode);
    }

    public RotateSelectionAction createRotateSelectionAction(IPlugInPort iPlugInPort, int n) {
        return new RotateSelectionAction(iPlugInPort, n);
    }

    public SendToBackAction createSendToBackAction(IPlugInPort iPlugInPort) {
        return new SendToBackAction(iPlugInPort);
    }

    public BringToFrontAction createBringToFrontAction(IPlugInPort iPlugInPort) {
        return new BringToFrontAction(iPlugInPort);
    }

    public ConfigAction createConfigAction(IPlugInPort iPlugInPort, String string, String string2, boolean bl) {
        return new ConfigAction(iPlugInPort, string, string2, bl);
    }

    public ThemeAction createThemeAction(IPlugInPort iPlugInPort, Theme theme) {
        return new ThemeAction(iPlugInPort, theme);
    }

    public RenumberAction createRenumberAction(IPlugInPort iPlugInPort, boolean bl) {
        return new RenumberAction(iPlugInPort, bl);
    }

    private static List<IDIYComponent<?>> cloneComponents(List<IDIYComponent<?>> list) {
        ArrayList arrayList = new ArrayList(list.size());
        for (IDIYComponent<?> iDIYComponent : list) {
            try {
                arrayList.add(iDIYComponent.clone());
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new RuntimeException(cloneNotSupportedException);
            }
        }
        return arrayList;
    }

    public static class RenumberAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private boolean xAxisFirst;

        public RenumberAction(IPlugInPort iPlugInPort, boolean bl) {
            this.plugInPort = iPlugInPort;
            this.xAxisFirst = bl;
            this.putValue("Name", bl ? "X Axis First" : "Y Axis First");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)(this.getValue("Name") + " triggered"));
            this.plugInPort.renumberSelectedComponents(this.xAxisFirst);
        }
    }

    public static class ThemeAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private Theme theme;

        public ThemeAction(IPlugInPort iPlugInPort, Theme theme) {
            this.plugInPort = iPlugInPort;
            this.theme = theme;
            this.putValue("Name", theme.getName());
            this.putValue("org.diylc.radioButtonGroup", "theme");
            this.putValue("SwingSelectedKey", iPlugInPort.getSelectedTheme().getName().equals(theme.getName()));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)(this.getValue("Name") + " triggered"));
            this.plugInPort.setSelectedTheme(this.theme);
        }
    }

    public static class ConfigAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private String configKey;

        public ConfigAction(IPlugInPort iPlugInPort, String string, String string2, boolean bl) {
            this.plugInPort = iPlugInPort;
            this.configKey = string2;
            this.putValue("Name", string);
            this.putValue("org.diylc.checkBoxMenuItem", true);
            this.putValue("SwingSelectedKey", ConfigurationManager.getInstance().readBoolean(string2, bl));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)(this.getValue("Name") + " triggered"));
            ConfigurationManager.getInstance().writeValue(this.configKey, this.getValue("SwingSelectedKey"));
            this.plugInPort.refresh();
        }
    }

    public static class BringToFrontAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public BringToFrontAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Bring Forward");
            this.putValue("SmallIcon", IconLoader.Front.getIcon());
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 8));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Bring to Front triggered");
            this.plugInPort.bringSelectionToFront();
        }
    }

    public static class SendToBackAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public SendToBackAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Send Backward");
            this.putValue("SmallIcon", IconLoader.Back.getIcon());
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 8));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Send to Back triggered");
            this.plugInPort.sendSelectionToBack();
        }
    }

    public static class RotateSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private int direction;

        public RotateSelectionAction(IPlugInPort iPlugInPort, int n) {
            this.plugInPort = iPlugInPort;
            this.direction = n;
            if (n > 0) {
                this.putValue("Name", "Rotate Clockwise");
                this.putValue("SmallIcon", IconLoader.RotateCW.getIcon());
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 8));
            } else {
                this.putValue("Name", "Rotate Counterclockwise");
                this.putValue("SmallIcon", IconLoader.RotateCCW.getIcon());
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 8));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)("Rotate Selection triggered: " + this.direction));
            this.plugInPort.rotateSelection(this.direction);
        }
    }

    public static class ExpandSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private ExpansionMode expansionMode;

        public ExpandSelectionAction(IPlugInPort iPlugInPort, ExpansionMode expansionMode) {
            this.plugInPort = iPlugInPort;
            this.expansionMode = expansionMode;
            switch (expansionMode) {
                case ALL: {
                    this.putValue("Name", "All Connected");
                    break;
                }
                case IMMEDIATE: {
                    this.putValue("Name", "Immediate Only");
                    break;
                }
                case SAME_TYPE: {
                    this.putValue("Name", "Same Type Only");
                    break;
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)("Expand Selection triggered: " + (Object)((Object)this.expansionMode)));
            this.plugInPort.expandSelection(this.expansionMode);
        }
    }

    public static class SaveAsTemplateAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public SaveAsTemplateAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Save as Template");
            this.putValue("SmallIcon", IconLoader.BriefcaseAdd.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Save as template triggered");
            String string = JOptionPane.showInputDialog(null, "Template name:", "Save as Template", -1);
            if (string != null && !string.trim().isEmpty()) {
                this.plugInPort.saveSelectedComponentAsTemplate(string);
            }
        }
    }

    public static class DeleteSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public DeleteSelectionAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Delete Selection");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(127, 0));
            this.putValue("SmallIcon", IconLoader.Delete.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Delete Selection triggered");
            this.plugInPort.deleteSelectedComponents();
        }
    }

    public static class EditSelectionAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public EditSelectionAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Edit Selection");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 2));
            this.putValue("SmallIcon", IconLoader.EditComponent.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Edit Selection triggered");
            List<PropertyWrapper> list = this.plugInPort.getMutualSelectionProperties();
            if (list == null || list.isEmpty()) {
                LOG.info((Object)"Nothing to edit");
                return;
            }
            this.plugInPort.editSelection();
        }
    }

    public static class EditProjectAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public EditProjectAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Edit Project");
            this.putValue("SmallIcon", IconLoader.DocumentEdit.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Edit Project triggered");
            List<PropertyWrapper> list = this.plugInPort.getProjectProperties();
            PropertyEditorDialog propertyEditorDialog = DialogFactory.getInstance().createPropertyEditorDialog(list, "Edit Project");
            propertyEditorDialog.setVisible(true);
            if ("OK".equals(propertyEditorDialog.getSelectedButtonCaption())) {
                this.plugInPort.applyPropertiesToProject(list);
            }
            for (PropertyWrapper propertyWrapper : propertyEditorDialog.getDefaultedProperties()) {
                if (propertyWrapper.getValue() == null) continue;
                this.plugInPort.setProjectDefaultPropertyValue(propertyWrapper.getName(), propertyWrapper.getValue());
            }
        }
    }

    public static class UngroupAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public UngroupAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Ungroup Selection");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(85, 2));
            this.putValue("SmallIcon", IconLoader.Ungroup.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Ungroup Selection triggered");
            this.plugInPort.ungroupSelectedComponents();
        }
    }

    public static class GroupAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public GroupAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Group Selection");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(71, 2));
            this.putValue("SmallIcon", IconLoader.Group.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Group Selection triggered");
            this.plugInPort.groupSelectedComponents();
        }
    }

    public static class SelectAllAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public SelectAllAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Select All");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 2));
            this.putValue("SmallIcon", IconLoader.Selection.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Select All triggered");
            this.plugInPort.selectAll(0);
        }
    }

    public static class PasteAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private Clipboard clipboard;

        public PasteAction(IPlugInPort iPlugInPort, Clipboard clipboard) {
            this.plugInPort = iPlugInPort;
            this.clipboard = clipboard;
            this.putValue("Name", "Paste");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, 2));
            this.putValue("SmallIcon", IconLoader.Paste.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Paste triggered");
            try {
                List list = (List)this.clipboard.getData(ComponentTransferable.listFlavor);
                this.plugInPort.pasteComponents(ActionFactory.cloneComponents(list));
            }
            catch (Exception exception) {
                LOG.error((Object)"Coule not paste.", (Throwable)exception);
            }
        }
    }

    public static class CopyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private Clipboard clipboard;
        private ClipboardOwner clipboardOwner;

        public CopyAction(IPlugInPort iPlugInPort, Clipboard clipboard, ClipboardOwner clipboardOwner) {
            this.plugInPort = iPlugInPort;
            this.clipboard = clipboard;
            this.clipboardOwner = clipboardOwner;
            this.putValue("Name", "Copy");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, 2));
            this.putValue("SmallIcon", IconLoader.Copy.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Copy triggered");
            this.clipboard.setContents(new ComponentTransferable(ActionFactory.cloneComponents(this.plugInPort.getSelectedComponents())), this.clipboardOwner);
        }
    }

    public static class CutAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private Clipboard clipboard;
        private ClipboardOwner clipboardOwner;

        public CutAction(IPlugInPort iPlugInPort, Clipboard clipboard, ClipboardOwner clipboardOwner) {
            this.plugInPort = iPlugInPort;
            this.clipboard = clipboard;
            this.clipboardOwner = clipboardOwner;
            this.putValue("Name", "Cut");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 2));
            this.putValue("SmallIcon", IconLoader.Cut.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"Cut triggered");
            this.clipboard.setContents(new ComponentTransferable(ActionFactory.cloneComponents(this.plugInPort.getSelectedComponents())), this.clipboardOwner);
            this.plugInPort.deleteSelectedComponents();
        }
    }

    public static class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public ExitAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Exit");
            this.putValue("SmallIcon", IconLoader.Exit.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"ExitAction triggered");
            if (this.plugInPort.allowFileAction()) {
                System.exit(0);
            }
        }
    }

    public static class PrintAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IDrawingProvider drawingProvider;

        public PrintAction(IDrawingProvider iDrawingProvider) {
            this.drawingProvider = iDrawingProvider;
            this.putValue("Name", "Print...");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 2));
            this.putValue("SmallIcon", IconLoader.Print.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"PrintAction triggered");
            try {
                DrawingExporter.getInstance().print(this.drawingProvider);
            }
            catch (PrinterException printerException) {
                printerException.printStackTrace();
            }
        }
    }

    public static class ExportPNGAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IDrawingProvider drawingProvider;
        private ISwingUI swingUI;

        public ExportPNGAction(IDrawingProvider iDrawingProvider, ISwingUI iSwingUI) {
            this.drawingProvider = iDrawingProvider;
            this.swingUI = iSwingUI;
            this.putValue("Name", "Export to PNG");
            this.putValue("SmallIcon", IconLoader.Image.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"ExportPNGAction triggered");
            final File file = DialogFactory.getInstance().showSaveDialog(FileFilterEnum.PNG.getFilter(), null, FileFilterEnum.PNG.getExtensions()[0], null);
            if (file != null) {
                this.swingUI.executeBackgroundTask(new ITask<Void>(){

                    @Override
                    public Void doInBackground() throws Exception {
                        LOG.debug((Object)("Exporting to " + file.getAbsolutePath()));
                        DrawingExporter.getInstance().exportPNG(ExportPNGAction.this.drawingProvider, file);
                        return null;
                    }

                    @Override
                    public void complete(Void void_) {
                    }

                    @Override
                    public void failed(Exception exception) {
                        ExportPNGAction.this.swingUI.showMessage("Could not export to PNG. " + exception.getMessage(), "Error", 0);
                    }
                });
            }
        }
    }

    public static class ExportPDFAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IDrawingProvider drawingProvider;
        private ISwingUI swingUI;

        public ExportPDFAction(IDrawingProvider iDrawingProvider, ISwingUI iSwingUI) {
            this.drawingProvider = iDrawingProvider;
            this.swingUI = iSwingUI;
            this.putValue("Name", "Export to PDF");
            this.putValue("SmallIcon", IconLoader.PDF.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"ExportPDFAction triggered");
            final File file = DialogFactory.getInstance().showSaveDialog(FileFilterEnum.PDF.getFilter(), null, FileFilterEnum.PDF.getExtensions()[0], null);
            if (file != null) {
                this.swingUI.executeBackgroundTask(new ITask<Void>(){

                    @Override
                    public Void doInBackground() throws Exception {
                        LOG.debug((Object)("Exporting to " + file.getAbsolutePath()));
                        DrawingExporter.getInstance().exportPDF(ExportPDFAction.this.drawingProvider, file);
                        return null;
                    }

                    @Override
                    public void complete(Void void_) {
                    }

                    @Override
                    public void failed(Exception exception) {
                        ExportPDFAction.this.swingUI.showMessage("Could not export to PDF. " + exception.getMessage(), "Error", 0);
                    }
                });
            }
        }
    }

    public static class CreateBomAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public CreateBomAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "Create B.O.M.");
            this.putValue("SmallIcon", IconLoader.BOM.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"CreateBomAction triggered");
            List<BomEntry> list = BomMaker.getInstance().createBom(this.plugInPort.getCurrentProject().getComponents());
            BomDialog bomDialog = DialogFactory.getInstance().createBomDialog(list);
            bomDialog.setVisible(true);
        }
    }

    public static class SaveAsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private ISwingUI swingUI;

        public SaveAsAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
            this.plugInPort = iPlugInPort;
            this.swingUI = iSwingUI;
            this.putValue("Name", "Save As");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 3));
            this.putValue("SmallIcon", IconLoader.DiskBlue.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"SaveAsAction triggered");
            final File file = DialogFactory.getInstance().showSaveDialog(FileFilterEnum.DIY.getFilter(), null, FileFilterEnum.DIY.getExtensions()[0], null);
            if (file != null) {
                this.swingUI.executeBackgroundTask(new ITask<Void>(){

                    @Override
                    public Void doInBackground() throws Exception {
                        LOG.debug((Object)("Saving to " + file.getAbsolutePath()));
                        SaveAsAction.this.plugInPort.saveProjectToFile(file.getAbsolutePath(), false);
                        return null;
                    }

                    @Override
                    public void complete(Void void_) {
                    }

                    @Override
                    public void failed(Exception exception) {
                        SaveAsAction.this.swingUI.showMessage("Could not save to file. " + exception.getMessage(), "Error", 0);
                    }
                });
            }
        }
    }

    public static class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private ISwingUI swingUI;

        public SaveAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
            this.plugInPort = iPlugInPort;
            this.swingUI = iSwingUI;
            this.putValue("Name", "Save");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
            this.putValue("SmallIcon", IconLoader.DiskBlue.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"SaveAction triggered");
            if (this.plugInPort.getCurrentFileName() == null) {
                final File file = DialogFactory.getInstance().showSaveDialog(FileFilterEnum.DIY.getFilter(), null, FileFilterEnum.DIY.getExtensions()[0], null);
                if (file != null) {
                    this.swingUI.executeBackgroundTask(new ITask<Void>(){

                        @Override
                        public Void doInBackground() throws Exception {
                            LOG.debug((Object)("Saving to " + file.getAbsolutePath()));
                            SaveAction.this.plugInPort.saveProjectToFile(file.getAbsolutePath(), false);
                            return null;
                        }

                        @Override
                        public void complete(Void void_) {
                        }

                        @Override
                        public void failed(Exception exception) {
                            SaveAction.this.swingUI.showMessage("Could not save to file. " + exception.getMessage(), "Error", 0);
                        }
                    });
                }
            } else {
                this.swingUI.executeBackgroundTask(new ITask<Void>(){

                    @Override
                    public Void doInBackground() throws Exception {
                        LOG.debug((Object)("Saving to " + SaveAction.this.plugInPort.getCurrentFileName()));
                        SaveAction.this.plugInPort.saveProjectToFile(SaveAction.this.plugInPort.getCurrentFileName(), false);
                        return null;
                    }

                    @Override
                    public void complete(Void void_) {
                    }

                    @Override
                    public void failed(Exception exception) {
                        SaveAction.this.swingUI.showMessage("Could not save to file. " + exception.getMessage(), "Error", 0);
                    }
                });
            }
        }
    }

    public static class ImportAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private ISwingUI swingUI;
        private Presenter presenter;

        public ImportAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
            this.plugInPort = iPlugInPort;
            this.swingUI = iSwingUI;
            this.presenter = new Presenter(new IView(){

                @Override
                public int showConfirmDialog(String string, String string2, int n, int n2) {
                    return JOptionPane.showConfirmDialog(null, string, string2, n, n2);
                }

                @Override
                public void showMessage(String string, String string2, int n) {
                    JOptionPane.showMessageDialog(null, string, string2, n);
                }

                @Override
                public File promptFileSave() {
                    return null;
                }

                @Override
                public boolean editProperties(List<PropertyWrapper> list, Set<PropertyWrapper> set) {
                    return false;
                }
            });
            this.putValue("Name", "Import");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, 2));
            this.putValue("SmallIcon", IconLoader.ElementInto.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"ImportAction triggered");
            final File file = DialogFactory.getInstance().showOpenDialog(FileFilterEnum.DIY.getFilter(), null, FileFilterEnum.DIY.getExtensions()[0], null);
            if (file != null) {
                this.swingUI.executeBackgroundTask(new ITask<Void>(){

                    @Override
                    public Void doInBackground() throws Exception {
                        LOG.debug((Object)("Opening from " + file.getAbsolutePath()));
                        ImportAction.this.presenter.loadProjectFromFile(file.getAbsolutePath());
                        ImportAction.this.plugInPort.pasteComponents(ImportAction.this.presenter.getCurrentProject().getComponents());
                        ImportAction.this.presenter.selectAll(0);
                        ImportAction.this.presenter.deleteSelectedComponents();
                        return null;
                    }

                    @Override
                    public void complete(Void void_) {
                    }

                    @Override
                    public void failed(Exception exception) {
                        ImportAction.this.swingUI.showMessage("Could not open file. " + exception.getMessage(), "Error", 0);
                    }
                });
            }
        }
    }

    public static class OpenAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;
        private ISwingUI swingUI;

        public OpenAction(IPlugInPort iPlugInPort, ISwingUI iSwingUI) {
            this.plugInPort = iPlugInPort;
            this.swingUI = iSwingUI;
            this.putValue("Name", "Open");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
            this.putValue("SmallIcon", IconLoader.FolderOut.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"OpenAction triggered");
            if (!this.plugInPort.allowFileAction()) {
                return;
            }
            final File file = DialogFactory.getInstance().showOpenDialog(FileFilterEnum.DIY.getFilter(), null, FileFilterEnum.DIY.getExtensions()[0], null);
            if (file != null) {
                this.swingUI.executeBackgroundTask(new ITask<Void>(){

                    @Override
                    public Void doInBackground() throws Exception {
                        LOG.debug((Object)("Opening from " + file.getAbsolutePath()));
                        OpenAction.this.plugInPort.loadProjectFromFile(file.getAbsolutePath());
                        return null;
                    }

                    @Override
                    public void complete(Void void_) {
                    }

                    @Override
                    public void failed(Exception exception) {
                        OpenAction.this.swingUI.showMessage("Could not open file. " + exception.getMessage(), "Error", 0);
                    }
                });
            }
        }
    }

    public static class NewAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private IPlugInPort plugInPort;

        public NewAction(IPlugInPort iPlugInPort) {
            this.plugInPort = iPlugInPort;
            this.putValue("Name", "New");
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 2));
            this.putValue("SmallIcon", IconLoader.DocumentPlainYellow.getIcon());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            LOG.info((Object)"NewAction triggered");
            if (!this.plugInPort.allowFileAction()) {
                return;
            }
            this.plugInPort.createNewProject();
            List<PropertyWrapper> list = this.plugInPort.getProjectProperties();
            PropertyEditorDialog propertyEditorDialog = DialogFactory.getInstance().createPropertyEditorDialog(list, "Edit Project");
            propertyEditorDialog.setVisible(true);
            if ("OK".equals(propertyEditorDialog.getSelectedButtonCaption())) {
                this.plugInPort.applyPropertiesToProject(list);
            }
            for (PropertyWrapper propertyWrapper : propertyEditorDialog.getDefaultedProperties()) {
                if (propertyWrapper.getValue() == null) continue;
                this.plugInPort.setProjectDefaultPropertyValue(propertyWrapper.getName(), propertyWrapper.getValue());
            }
        }
    }
}

