/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.args4j.spi;

import ch.systemsx.cisd.args4j.CmdLineException;
import ch.systemsx.cisd.args4j.Option;
import ch.systemsx.cisd.args4j.spi.Messages;
import ch.systemsx.cisd.args4j.spi.OptionHandler;
import ch.systemsx.cisd.args4j.spi.Parameters;
import ch.systemsx.cisd.args4j.spi.Setter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumOptionHandler<T extends Enum<T>>
extends OptionHandler {
    private final Setter<? super T> setter;
    private final Class<T> enumType;

    public EnumOptionHandler(Option option, Setter<? super T> setter, Class<T> enumType) {
        super(option);
        this.setter = setter;
        this.enumType = enumType;
    }

    @Override
    public int parseArguments(Parameters params) throws CmdLineException {
        this.set(params.getParameter(0));
        return 1;
    }

    @Override
    public void set(String value) throws CmdLineException {
        T enumValue = this.getEnumOption(value);
        if (enumValue == null) {
            throw new CmdLineException(Messages.ILLEGAL_OPERAND.format(this.getName(), value));
        }
        this.set(enumValue);
    }

    private T getEnumOption(String s) {
        Enum[] enumArray = (Enum[])this.enumType.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum o = enumArray[n2];
            if (o.name().equalsIgnoreCase(s)) {
                return (T)o;
            }
            ++n2;
        }
        return null;
    }

    protected void set(T value) throws CmdLineException {
        this.setter.addValue(value);
    }

    @Override
    public String getDefaultMetaVariable() {
        String n = this.enumType.getName();
        int idx = n.lastIndexOf(46);
        if (idx >= 0) {
            n = n.substring(idx + 1);
        }
        return n.toUpperCase();
    }
}

