/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.docking.event;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JTabbedPane;
import org.flexdock.docking.Dockable;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.drag.DragManager;

public class TabbedDragListener
extends MouseAdapter
implements MouseMotionListener {
    private DragManager dragListener;

    public void mouseDragged(MouseEvent me) {
        if (this.dragListener != null) {
            this.dragListener.mouseDragged(me);
        }
    }

    public void mouseReleased(MouseEvent me) {
        if (this.dragListener != null) {
            this.dragListener.mouseReleased(me);
        }
        this.dragListener = null;
    }

    public void mousePressed(MouseEvent me) {
        if (!(me.getSource() instanceof JTabbedPane)) {
            this.dragListener = null;
            return;
        }
        JTabbedPane pane = (JTabbedPane)me.getSource();
        Point p = me.getPoint();
        int tabIndex = pane.indexAtLocation(p.x, p.y);
        if (tabIndex == -1) {
            this.dragListener = null;
            return;
        }
        Dockable dockable = DockingManager.getDockable(pane.getComponentAt(tabIndex));
        this.dragListener = DockingManager.getDragListener(dockable);
        if (this.dragListener != null) {
            this.dragListener.mousePressed(me);
        }
    }

    public void mouseMoved(MouseEvent me) {
    }
}

