// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package policy

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/preview/resources/mgmt/2020-09-01-preview/policy"
)

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type AliasPathAttributes = original.AliasPathAttributes

const (
	AliasPathAttributesModifiable AliasPathAttributes = original.AliasPathAttributesModifiable
	AliasPathAttributesNone       AliasPathAttributes = original.AliasPathAttributesNone
)

type AliasPathTokenType = original.AliasPathTokenType

const (
	AliasPathTokenTypeAny          AliasPathTokenType = original.AliasPathTokenTypeAny
	AliasPathTokenTypeArray        AliasPathTokenType = original.AliasPathTokenTypeArray
	AliasPathTokenTypeBoolean      AliasPathTokenType = original.AliasPathTokenTypeBoolean
	AliasPathTokenTypeInteger      AliasPathTokenType = original.AliasPathTokenTypeInteger
	AliasPathTokenTypeNotSpecified AliasPathTokenType = original.AliasPathTokenTypeNotSpecified
	AliasPathTokenTypeNumber       AliasPathTokenType = original.AliasPathTokenTypeNumber
	AliasPathTokenTypeObject       AliasPathTokenType = original.AliasPathTokenTypeObject
	AliasPathTokenTypeString       AliasPathTokenType = original.AliasPathTokenTypeString
)

type AliasPatternType = original.AliasPatternType

const (
	AliasPatternTypeExtract      AliasPatternType = original.AliasPatternTypeExtract
	AliasPatternTypeNotSpecified AliasPatternType = original.AliasPatternTypeNotSpecified
)

type AliasType = original.AliasType

const (
	AliasTypeMask         AliasType = original.AliasTypeMask
	AliasTypeNotSpecified AliasType = original.AliasTypeNotSpecified
	AliasTypePlainText    AliasType = original.AliasTypePlainText
)

type CreatedByType = original.CreatedByType

const (
	CreatedByTypeApplication     CreatedByType = original.CreatedByTypeApplication
	CreatedByTypeKey             CreatedByType = original.CreatedByTypeKey
	CreatedByTypeManagedIdentity CreatedByType = original.CreatedByTypeManagedIdentity
	CreatedByTypeUser            CreatedByType = original.CreatedByTypeUser
)

type EnforcementMode = original.EnforcementMode

const (
	EnforcementModeDefault      EnforcementMode = original.EnforcementModeDefault
	EnforcementModeDoNotEnforce EnforcementMode = original.EnforcementModeDoNotEnforce
)

type ExemptionCategory = original.ExemptionCategory

const (
	ExemptionCategoryMitigated ExemptionCategory = original.ExemptionCategoryMitigated
	ExemptionCategoryWaiver    ExemptionCategory = original.ExemptionCategoryWaiver
)

type ParameterType = original.ParameterType

const (
	ParameterTypeArray    ParameterType = original.ParameterTypeArray
	ParameterTypeBoolean  ParameterType = original.ParameterTypeBoolean
	ParameterTypeDateTime ParameterType = original.ParameterTypeDateTime
	ParameterTypeFloat    ParameterType = original.ParameterTypeFloat
	ParameterTypeInteger  ParameterType = original.ParameterTypeInteger
	ParameterTypeObject   ParameterType = original.ParameterTypeObject
	ParameterTypeString   ParameterType = original.ParameterTypeString
)

type ResourceIdentityType = original.ResourceIdentityType

const (
	ResourceIdentityTypeNone           ResourceIdentityType = original.ResourceIdentityTypeNone
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = original.ResourceIdentityTypeSystemAssigned
)

type Type = original.Type

const (
	TypeBuiltIn      Type = original.TypeBuiltIn
	TypeCustom       Type = original.TypeCustom
	TypeNotSpecified Type = original.TypeNotSpecified
	TypeStatic       Type = original.TypeStatic
)

type Alias = original.Alias
type AliasPath = original.AliasPath
type AliasPathMetadata = original.AliasPathMetadata
type AliasPattern = original.AliasPattern
type Assignment = original.Assignment
type AssignmentListResult = original.AssignmentListResult
type AssignmentListResultIterator = original.AssignmentListResultIterator
type AssignmentListResultPage = original.AssignmentListResultPage
type AssignmentProperties = original.AssignmentProperties
type AssignmentsClient = original.AssignmentsClient
type BaseClient = original.BaseClient
type CloudError = original.CloudError
type DataEffect = original.DataEffect
type DataManifestCustomResourceFunctionDefinition = original.DataManifestCustomResourceFunctionDefinition
type DataManifestResourceFunctionsDefinition = original.DataManifestResourceFunctionsDefinition
type DataPolicyManifest = original.DataPolicyManifest
type DataPolicyManifestListResult = original.DataPolicyManifestListResult
type DataPolicyManifestListResultIterator = original.DataPolicyManifestListResultIterator
type DataPolicyManifestListResultPage = original.DataPolicyManifestListResultPage
type DataPolicyManifestProperties = original.DataPolicyManifestProperties
type DataPolicyManifestsClient = original.DataPolicyManifestsClient
type Definition = original.Definition
type DefinitionGroup = original.DefinitionGroup
type DefinitionListResult = original.DefinitionListResult
type DefinitionListResultIterator = original.DefinitionListResultIterator
type DefinitionListResultPage = original.DefinitionListResultPage
type DefinitionProperties = original.DefinitionProperties
type DefinitionReference = original.DefinitionReference
type DefinitionsClient = original.DefinitionsClient
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorResponse = original.ErrorResponse
type Exemption = original.Exemption
type ExemptionListResult = original.ExemptionListResult
type ExemptionListResultIterator = original.ExemptionListResultIterator
type ExemptionListResultPage = original.ExemptionListResultPage
type ExemptionProperties = original.ExemptionProperties
type ExemptionsClient = original.ExemptionsClient
type Identity = original.Identity
type NonComplianceMessage = original.NonComplianceMessage
type ParameterDefinitionsValue = original.ParameterDefinitionsValue
type ParameterDefinitionsValueMetadata = original.ParameterDefinitionsValueMetadata
type ParameterValuesValue = original.ParameterValuesValue
type ResourceTypeAliases = original.ResourceTypeAliases
type SetDefinition = original.SetDefinition
type SetDefinitionListResult = original.SetDefinitionListResult
type SetDefinitionListResultIterator = original.SetDefinitionListResultIterator
type SetDefinitionListResultPage = original.SetDefinitionListResultPage
type SetDefinitionProperties = original.SetDefinitionProperties
type SetDefinitionsClient = original.SetDefinitionsClient
type SystemData = original.SystemData

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAssignmentListResultIterator(page AssignmentListResultPage) AssignmentListResultIterator {
	return original.NewAssignmentListResultIterator(page)
}
func NewAssignmentListResultPage(cur AssignmentListResult, getNextPage func(context.Context, AssignmentListResult) (AssignmentListResult, error)) AssignmentListResultPage {
	return original.NewAssignmentListResultPage(cur, getNextPage)
}
func NewAssignmentsClient(subscriptionID string) AssignmentsClient {
	return original.NewAssignmentsClient(subscriptionID)
}
func NewAssignmentsClientWithBaseURI(baseURI string, subscriptionID string) AssignmentsClient {
	return original.NewAssignmentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDataPolicyManifestListResultIterator(page DataPolicyManifestListResultPage) DataPolicyManifestListResultIterator {
	return original.NewDataPolicyManifestListResultIterator(page)
}
func NewDataPolicyManifestListResultPage(cur DataPolicyManifestListResult, getNextPage func(context.Context, DataPolicyManifestListResult) (DataPolicyManifestListResult, error)) DataPolicyManifestListResultPage {
	return original.NewDataPolicyManifestListResultPage(cur, getNextPage)
}
func NewDataPolicyManifestsClient(subscriptionID string) DataPolicyManifestsClient {
	return original.NewDataPolicyManifestsClient(subscriptionID)
}
func NewDataPolicyManifestsClientWithBaseURI(baseURI string, subscriptionID string) DataPolicyManifestsClient {
	return original.NewDataPolicyManifestsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDefinitionListResultIterator(page DefinitionListResultPage) DefinitionListResultIterator {
	return original.NewDefinitionListResultIterator(page)
}
func NewDefinitionListResultPage(cur DefinitionListResult, getNextPage func(context.Context, DefinitionListResult) (DefinitionListResult, error)) DefinitionListResultPage {
	return original.NewDefinitionListResultPage(cur, getNextPage)
}
func NewDefinitionsClient(subscriptionID string) DefinitionsClient {
	return original.NewDefinitionsClient(subscriptionID)
}
func NewDefinitionsClientWithBaseURI(baseURI string, subscriptionID string) DefinitionsClient {
	return original.NewDefinitionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewExemptionListResultIterator(page ExemptionListResultPage) ExemptionListResultIterator {
	return original.NewExemptionListResultIterator(page)
}
func NewExemptionListResultPage(cur ExemptionListResult, getNextPage func(context.Context, ExemptionListResult) (ExemptionListResult, error)) ExemptionListResultPage {
	return original.NewExemptionListResultPage(cur, getNextPage)
}
func NewExemptionsClient(subscriptionID string) ExemptionsClient {
	return original.NewExemptionsClient(subscriptionID)
}
func NewExemptionsClientWithBaseURI(baseURI string, subscriptionID string) ExemptionsClient {
	return original.NewExemptionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSetDefinitionListResultIterator(page SetDefinitionListResultPage) SetDefinitionListResultIterator {
	return original.NewSetDefinitionListResultIterator(page)
}
func NewSetDefinitionListResultPage(cur SetDefinitionListResult, getNextPage func(context.Context, SetDefinitionListResult) (SetDefinitionListResult, error)) SetDefinitionListResultPage {
	return original.NewSetDefinitionListResultPage(cur, getNextPage)
}
func NewSetDefinitionsClient(subscriptionID string) SetDefinitionsClient {
	return original.NewSetDefinitionsClient(subscriptionID)
}
func NewSetDefinitionsClientWithBaseURI(baseURI string, subscriptionID string) SetDefinitionsClient {
	return original.NewSetDefinitionsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAliasPathAttributesValues() []AliasPathAttributes {
	return original.PossibleAliasPathAttributesValues()
}
func PossibleAliasPathTokenTypeValues() []AliasPathTokenType {
	return original.PossibleAliasPathTokenTypeValues()
}
func PossibleAliasPatternTypeValues() []AliasPatternType {
	return original.PossibleAliasPatternTypeValues()
}
func PossibleAliasTypeValues() []AliasType {
	return original.PossibleAliasTypeValues()
}
func PossibleCreatedByTypeValues() []CreatedByType {
	return original.PossibleCreatedByTypeValues()
}
func PossibleEnforcementModeValues() []EnforcementMode {
	return original.PossibleEnforcementModeValues()
}
func PossibleExemptionCategoryValues() []ExemptionCategory {
	return original.PossibleExemptionCategoryValues()
}
func PossibleParameterTypeValues() []ParameterType {
	return original.PossibleParameterTypeValues()
}
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return original.PossibleResourceIdentityTypeValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
