package compute

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccessLevel enumerates the values for access level.
type AccessLevel string

const (
	// None ...
	None AccessLevel = "None"
	// Read ...
	Read AccessLevel = "Read"
	// Write ...
	Write AccessLevel = "Write"
)

// PossibleAccessLevelValues returns an array of possible values for the AccessLevel const type.
func PossibleAccessLevelValues() []AccessLevel {
	return []AccessLevel{None, Read, Write}
}

// AggregatedReplicationState enumerates the values for aggregated replication state.
type AggregatedReplicationState string

const (
	// Completed ...
	Completed AggregatedReplicationState = "Completed"
	// Failed ...
	Failed AggregatedReplicationState = "Failed"
	// InProgress ...
	InProgress AggregatedReplicationState = "InProgress"
	// Unknown ...
	Unknown AggregatedReplicationState = "Unknown"
)

// PossibleAggregatedReplicationStateValues returns an array of possible values for the AggregatedReplicationState const type.
func PossibleAggregatedReplicationStateValues() []AggregatedReplicationState {
	return []AggregatedReplicationState{Completed, Failed, InProgress, Unknown}
}

// Architecture enumerates the values for architecture.
type Architecture string

const (
	// Arm64 ...
	Arm64 Architecture = "Arm64"
	// X64 ...
	X64 Architecture = "x64"
)

// PossibleArchitectureValues returns an array of possible values for the Architecture const type.
func PossibleArchitectureValues() []Architecture {
	return []Architecture{Arm64, X64}
}

// ArchitectureTypes enumerates the values for architecture types.
type ArchitectureTypes string

const (
	// ArchitectureTypesArm64 ...
	ArchitectureTypesArm64 ArchitectureTypes = "Arm64"
	// ArchitectureTypesX64 ...
	ArchitectureTypesX64 ArchitectureTypes = "x64"
)

// PossibleArchitectureTypesValues returns an array of possible values for the ArchitectureTypes const type.
func PossibleArchitectureTypesValues() []ArchitectureTypes {
	return []ArchitectureTypes{ArchitectureTypesArm64, ArchitectureTypesX64}
}

// AvailabilitySetSkuTypes enumerates the values for availability set sku types.
type AvailabilitySetSkuTypes string

const (
	// Aligned ...
	Aligned AvailabilitySetSkuTypes = "Aligned"
	// Classic ...
	Classic AvailabilitySetSkuTypes = "Classic"
)

// PossibleAvailabilitySetSkuTypesValues returns an array of possible values for the AvailabilitySetSkuTypes const type.
func PossibleAvailabilitySetSkuTypesValues() []AvailabilitySetSkuTypes {
	return []AvailabilitySetSkuTypes{Aligned, Classic}
}

// CachingTypes enumerates the values for caching types.
type CachingTypes string

const (
	// CachingTypesNone ...
	CachingTypesNone CachingTypes = "None"
	// CachingTypesReadOnly ...
	CachingTypesReadOnly CachingTypes = "ReadOnly"
	// CachingTypesReadWrite ...
	CachingTypesReadWrite CachingTypes = "ReadWrite"
)

// PossibleCachingTypesValues returns an array of possible values for the CachingTypes const type.
func PossibleCachingTypesValues() []CachingTypes {
	return []CachingTypes{CachingTypesNone, CachingTypesReadOnly, CachingTypesReadWrite}
}

// CapacityReservationGroupInstanceViewTypes enumerates the values for capacity reservation group instance view
// types.
type CapacityReservationGroupInstanceViewTypes string

const (
	// InstanceView ...
	InstanceView CapacityReservationGroupInstanceViewTypes = "instanceView"
)

// PossibleCapacityReservationGroupInstanceViewTypesValues returns an array of possible values for the CapacityReservationGroupInstanceViewTypes const type.
func PossibleCapacityReservationGroupInstanceViewTypesValues() []CapacityReservationGroupInstanceViewTypes {
	return []CapacityReservationGroupInstanceViewTypes{InstanceView}
}

// CapacityReservationInstanceViewTypes enumerates the values for capacity reservation instance view types.
type CapacityReservationInstanceViewTypes string

const (
	// CapacityReservationInstanceViewTypesInstanceView ...
	CapacityReservationInstanceViewTypesInstanceView CapacityReservationInstanceViewTypes = "instanceView"
)

// PossibleCapacityReservationInstanceViewTypesValues returns an array of possible values for the CapacityReservationInstanceViewTypes const type.
func PossibleCapacityReservationInstanceViewTypesValues() []CapacityReservationInstanceViewTypes {
	return []CapacityReservationInstanceViewTypes{CapacityReservationInstanceViewTypesInstanceView}
}

// CloudServiceSlotType enumerates the values for cloud service slot type.
type CloudServiceSlotType string

const (
	// Production ...
	Production CloudServiceSlotType = "Production"
	// Staging ...
	Staging CloudServiceSlotType = "Staging"
)

// PossibleCloudServiceSlotTypeValues returns an array of possible values for the CloudServiceSlotType const type.
func PossibleCloudServiceSlotTypeValues() []CloudServiceSlotType {
	return []CloudServiceSlotType{Production, Staging}
}

// CloudServiceUpgradeMode enumerates the values for cloud service upgrade mode.
type CloudServiceUpgradeMode string

const (
	// Auto ...
	Auto CloudServiceUpgradeMode = "Auto"
	// Manual ...
	Manual CloudServiceUpgradeMode = "Manual"
	// Simultaneous ...
	Simultaneous CloudServiceUpgradeMode = "Simultaneous"
)

// PossibleCloudServiceUpgradeModeValues returns an array of possible values for the CloudServiceUpgradeMode const type.
func PossibleCloudServiceUpgradeModeValues() []CloudServiceUpgradeMode {
	return []CloudServiceUpgradeMode{Auto, Manual, Simultaneous}
}

// ComponentNames enumerates the values for component names.
type ComponentNames string

const (
	// MicrosoftWindowsShellSetup ...
	MicrosoftWindowsShellSetup ComponentNames = "Microsoft-Windows-Shell-Setup"
)

// PossibleComponentNamesValues returns an array of possible values for the ComponentNames const type.
func PossibleComponentNamesValues() []ComponentNames {
	return []ComponentNames{MicrosoftWindowsShellSetup}
}

// ConfidentialVMEncryptionType enumerates the values for confidential vm encryption type.
type ConfidentialVMEncryptionType string

const (
	// EncryptedVMGuestStateOnlyWithPmk ...
	EncryptedVMGuestStateOnlyWithPmk ConfidentialVMEncryptionType = "EncryptedVMGuestStateOnlyWithPmk"
	// EncryptedWithCmk ...
	EncryptedWithCmk ConfidentialVMEncryptionType = "EncryptedWithCmk"
	// EncryptedWithPmk ...
	EncryptedWithPmk ConfidentialVMEncryptionType = "EncryptedWithPmk"
)

// PossibleConfidentialVMEncryptionTypeValues returns an array of possible values for the ConfidentialVMEncryptionType const type.
func PossibleConfidentialVMEncryptionTypeValues() []ConfidentialVMEncryptionType {
	return []ConfidentialVMEncryptionType{EncryptedVMGuestStateOnlyWithPmk, EncryptedWithCmk, EncryptedWithPmk}
}

// ConsistencyModeTypes enumerates the values for consistency mode types.
type ConsistencyModeTypes string

const (
	// ApplicationConsistent ...
	ApplicationConsistent ConsistencyModeTypes = "ApplicationConsistent"
	// CrashConsistent ...
	CrashConsistent ConsistencyModeTypes = "CrashConsistent"
	// FileSystemConsistent ...
	FileSystemConsistent ConsistencyModeTypes = "FileSystemConsistent"
)

// PossibleConsistencyModeTypesValues returns an array of possible values for the ConsistencyModeTypes const type.
func PossibleConsistencyModeTypesValues() []ConsistencyModeTypes {
	return []ConsistencyModeTypes{ApplicationConsistent, CrashConsistent, FileSystemConsistent}
}

// DataAccessAuthMode enumerates the values for data access auth mode.
type DataAccessAuthMode string

const (
	// DataAccessAuthModeAzureActiveDirectory When export/upload URL is used, the system checks if the user has
	// an identity in Azure Active Directory and has necessary permissions to export/upload the data. Please
	// refer to aka.ms/DisksAzureADAuth.
	DataAccessAuthModeAzureActiveDirectory DataAccessAuthMode = "AzureActiveDirectory"
	// DataAccessAuthModeNone No additional authentication would be performed when accessing export/upload URL.
	DataAccessAuthModeNone DataAccessAuthMode = "None"
)

// PossibleDataAccessAuthModeValues returns an array of possible values for the DataAccessAuthMode const type.
func PossibleDataAccessAuthModeValues() []DataAccessAuthMode {
	return []DataAccessAuthMode{DataAccessAuthModeAzureActiveDirectory, DataAccessAuthModeNone}
}

// DedicatedHostLicenseTypes enumerates the values for dedicated host license types.
type DedicatedHostLicenseTypes string

const (
	// DedicatedHostLicenseTypesNone ...
	DedicatedHostLicenseTypesNone DedicatedHostLicenseTypes = "None"
	// DedicatedHostLicenseTypesWindowsServerHybrid ...
	DedicatedHostLicenseTypesWindowsServerHybrid DedicatedHostLicenseTypes = "Windows_Server_Hybrid"
	// DedicatedHostLicenseTypesWindowsServerPerpetual ...
	DedicatedHostLicenseTypesWindowsServerPerpetual DedicatedHostLicenseTypes = "Windows_Server_Perpetual"
)

// PossibleDedicatedHostLicenseTypesValues returns an array of possible values for the DedicatedHostLicenseTypes const type.
func PossibleDedicatedHostLicenseTypesValues() []DedicatedHostLicenseTypes {
	return []DedicatedHostLicenseTypes{DedicatedHostLicenseTypesNone, DedicatedHostLicenseTypesWindowsServerHybrid, DedicatedHostLicenseTypesWindowsServerPerpetual}
}

// DeleteOptions enumerates the values for delete options.
type DeleteOptions string

const (
	// Delete ...
	Delete DeleteOptions = "Delete"
	// Detach ...
	Detach DeleteOptions = "Detach"
)

// PossibleDeleteOptionsValues returns an array of possible values for the DeleteOptions const type.
func PossibleDeleteOptionsValues() []DeleteOptions {
	return []DeleteOptions{Delete, Detach}
}

// DiffDiskOptions enumerates the values for diff disk options.
type DiffDiskOptions string

const (
	// Local ...
	Local DiffDiskOptions = "Local"
)

// PossibleDiffDiskOptionsValues returns an array of possible values for the DiffDiskOptions const type.
func PossibleDiffDiskOptionsValues() []DiffDiskOptions {
	return []DiffDiskOptions{Local}
}

// DiffDiskPlacement enumerates the values for diff disk placement.
type DiffDiskPlacement string

const (
	// CacheDisk ...
	CacheDisk DiffDiskPlacement = "CacheDisk"
	// ResourceDisk ...
	ResourceDisk DiffDiskPlacement = "ResourceDisk"
)

// PossibleDiffDiskPlacementValues returns an array of possible values for the DiffDiskPlacement const type.
func PossibleDiffDiskPlacementValues() []DiffDiskPlacement {
	return []DiffDiskPlacement{CacheDisk, ResourceDisk}
}

// DiskControllerTypes enumerates the values for disk controller types.
type DiskControllerTypes string

const (
	// NVMe ...
	NVMe DiskControllerTypes = "NVMe"
	// SCSI ...
	SCSI DiskControllerTypes = "SCSI"
)

// PossibleDiskControllerTypesValues returns an array of possible values for the DiskControllerTypes const type.
func PossibleDiskControllerTypesValues() []DiskControllerTypes {
	return []DiskControllerTypes{NVMe, SCSI}
}

// DiskCreateOption enumerates the values for disk create option.
type DiskCreateOption string

const (
	// Attach Disk will be attached to a VM.
	Attach DiskCreateOption = "Attach"
	// Copy Create a new disk or snapshot by copying from a disk or snapshot specified by the given
	// sourceResourceId.
	Copy DiskCreateOption = "Copy"
	// CopyStart Create a new disk by using a deep copy process, where the resource creation is considered
	// complete only after all data has been copied from the source.
	CopyStart DiskCreateOption = "CopyStart"
	// Empty Create an empty data disk of a size given by diskSizeGB.
	Empty DiskCreateOption = "Empty"
	// FromImage Create a new disk from a platform image specified by the given imageReference or
	// galleryImageReference.
	FromImage DiskCreateOption = "FromImage"
	// Import Create a disk by importing from a blob specified by a sourceUri in a storage account specified by
	// storageAccountId.
	Import DiskCreateOption = "Import"
	// ImportSecure Similar to Import create option. Create a new Trusted Launch VM or Confidential VM
	// supported disk by importing additional blob for VM guest state specified by securityDataUri in storage
	// account specified by storageAccountId
	ImportSecure DiskCreateOption = "ImportSecure"
	// Restore Create a new disk by copying from a backup recovery point.
	Restore DiskCreateOption = "Restore"
	// Upload Create a new disk by obtaining a write token and using it to directly upload the contents of the
	// disk.
	Upload DiskCreateOption = "Upload"
	// UploadPreparedSecure Similar to Upload create option. Create a new Trusted Launch VM or Confidential VM
	// supported disk and upload using write token in both disk and VM guest state
	UploadPreparedSecure DiskCreateOption = "UploadPreparedSecure"
)

// PossibleDiskCreateOptionValues returns an array of possible values for the DiskCreateOption const type.
func PossibleDiskCreateOptionValues() []DiskCreateOption {
	return []DiskCreateOption{Attach, Copy, CopyStart, Empty, FromImage, Import, ImportSecure, Restore, Upload, UploadPreparedSecure}
}

// DiskCreateOptionTypes enumerates the values for disk create option types.
type DiskCreateOptionTypes string

const (
	// DiskCreateOptionTypesAttach ...
	DiskCreateOptionTypesAttach DiskCreateOptionTypes = "Attach"
	// DiskCreateOptionTypesEmpty ...
	DiskCreateOptionTypesEmpty DiskCreateOptionTypes = "Empty"
	// DiskCreateOptionTypesFromImage ...
	DiskCreateOptionTypesFromImage DiskCreateOptionTypes = "FromImage"
)

// PossibleDiskCreateOptionTypesValues returns an array of possible values for the DiskCreateOptionTypes const type.
func PossibleDiskCreateOptionTypesValues() []DiskCreateOptionTypes {
	return []DiskCreateOptionTypes{DiskCreateOptionTypesAttach, DiskCreateOptionTypesEmpty, DiskCreateOptionTypesFromImage}
}

// DiskDeleteOptionTypes enumerates the values for disk delete option types.
type DiskDeleteOptionTypes string

const (
	// DiskDeleteOptionTypesDelete ...
	DiskDeleteOptionTypesDelete DiskDeleteOptionTypes = "Delete"
	// DiskDeleteOptionTypesDetach ...
	DiskDeleteOptionTypesDetach DiskDeleteOptionTypes = "Detach"
)

// PossibleDiskDeleteOptionTypesValues returns an array of possible values for the DiskDeleteOptionTypes const type.
func PossibleDiskDeleteOptionTypesValues() []DiskDeleteOptionTypes {
	return []DiskDeleteOptionTypes{DiskDeleteOptionTypesDelete, DiskDeleteOptionTypesDetach}
}

// DiskDetachOptionTypes enumerates the values for disk detach option types.
type DiskDetachOptionTypes string

const (
	// ForceDetach ...
	ForceDetach DiskDetachOptionTypes = "ForceDetach"
)

// PossibleDiskDetachOptionTypesValues returns an array of possible values for the DiskDetachOptionTypes const type.
func PossibleDiskDetachOptionTypesValues() []DiskDetachOptionTypes {
	return []DiskDetachOptionTypes{ForceDetach}
}

// DiskEncryptionSetIdentityType enumerates the values for disk encryption set identity type.
type DiskEncryptionSetIdentityType string

const (
	// DiskEncryptionSetIdentityTypeNone ...
	DiskEncryptionSetIdentityTypeNone DiskEncryptionSetIdentityType = "None"
	// DiskEncryptionSetIdentityTypeSystemAssigned ...
	DiskEncryptionSetIdentityTypeSystemAssigned DiskEncryptionSetIdentityType = "SystemAssigned"
	// DiskEncryptionSetIdentityTypeSystemAssignedUserAssigned ...
	DiskEncryptionSetIdentityTypeSystemAssignedUserAssigned DiskEncryptionSetIdentityType = "SystemAssigned, UserAssigned"
	// DiskEncryptionSetIdentityTypeUserAssigned ...
	DiskEncryptionSetIdentityTypeUserAssigned DiskEncryptionSetIdentityType = "UserAssigned"
)

// PossibleDiskEncryptionSetIdentityTypeValues returns an array of possible values for the DiskEncryptionSetIdentityType const type.
func PossibleDiskEncryptionSetIdentityTypeValues() []DiskEncryptionSetIdentityType {
	return []DiskEncryptionSetIdentityType{DiskEncryptionSetIdentityTypeNone, DiskEncryptionSetIdentityTypeSystemAssigned, DiskEncryptionSetIdentityTypeSystemAssignedUserAssigned, DiskEncryptionSetIdentityTypeUserAssigned}
}

// DiskEncryptionSetType enumerates the values for disk encryption set type.
type DiskEncryptionSetType string

const (
	// ConfidentialVMEncryptedWithCustomerKey Confidential VM supported disk and VM guest state would be
	// encrypted with customer managed key.
	ConfidentialVMEncryptedWithCustomerKey DiskEncryptionSetType = "ConfidentialVmEncryptedWithCustomerKey"
	// EncryptionAtRestWithCustomerKey Resource using diskEncryptionSet would be encrypted at rest with
	// Customer managed key that can be changed and revoked by a customer.
	EncryptionAtRestWithCustomerKey DiskEncryptionSetType = "EncryptionAtRestWithCustomerKey"
	// EncryptionAtRestWithPlatformAndCustomerKeys Resource using diskEncryptionSet would be encrypted at rest
	// with two layers of encryption. One of the keys is Customer managed and the other key is Platform
	// managed.
	EncryptionAtRestWithPlatformAndCustomerKeys DiskEncryptionSetType = "EncryptionAtRestWithPlatformAndCustomerKeys"
)

// PossibleDiskEncryptionSetTypeValues returns an array of possible values for the DiskEncryptionSetType const type.
func PossibleDiskEncryptionSetTypeValues() []DiskEncryptionSetType {
	return []DiskEncryptionSetType{ConfidentialVMEncryptedWithCustomerKey, EncryptionAtRestWithCustomerKey, EncryptionAtRestWithPlatformAndCustomerKeys}
}

// DiskSecurityTypes enumerates the values for disk security types.
type DiskSecurityTypes string

const (
	// ConfidentialVMDiskEncryptedWithCustomerKey Indicates Confidential VM disk with both OS disk and VM guest
	// state encrypted with a customer managed key
	ConfidentialVMDiskEncryptedWithCustomerKey DiskSecurityTypes = "ConfidentialVM_DiskEncryptedWithCustomerKey"
	// ConfidentialVMDiskEncryptedWithPlatformKey Indicates Confidential VM disk with both OS disk and VM guest
	// state encrypted with a platform managed key
	ConfidentialVMDiskEncryptedWithPlatformKey DiskSecurityTypes = "ConfidentialVM_DiskEncryptedWithPlatformKey"
	// ConfidentialVMVMGuestStateOnlyEncryptedWithPlatformKey Indicates Confidential VM disk with only VM guest
	// state encrypted
	ConfidentialVMVMGuestStateOnlyEncryptedWithPlatformKey DiskSecurityTypes = "ConfidentialVM_VMGuestStateOnlyEncryptedWithPlatformKey"
	// TrustedLaunch Trusted Launch provides security features such as secure boot and virtual Trusted Platform
	// Module (vTPM)
	TrustedLaunch DiskSecurityTypes = "TrustedLaunch"
)

// PossibleDiskSecurityTypesValues returns an array of possible values for the DiskSecurityTypes const type.
func PossibleDiskSecurityTypesValues() []DiskSecurityTypes {
	return []DiskSecurityTypes{ConfidentialVMDiskEncryptedWithCustomerKey, ConfidentialVMDiskEncryptedWithPlatformKey, ConfidentialVMVMGuestStateOnlyEncryptedWithPlatformKey, TrustedLaunch}
}

// DiskState enumerates the values for disk state.
type DiskState string

const (
	// ActiveSAS The disk currently has an Active SAS Uri associated with it.
	ActiveSAS DiskState = "ActiveSAS"
	// ActiveSASFrozen The disk is attached to a VM in hibernated state and has an active SAS URI associated
	// with it.
	ActiveSASFrozen DiskState = "ActiveSASFrozen"
	// ActiveUpload A disk is created for upload and a write token has been issued for uploading to it.
	ActiveUpload DiskState = "ActiveUpload"
	// Attached The disk is currently attached to a running VM.
	Attached DiskState = "Attached"
	// Frozen The disk is attached to a VM which is in hibernated state.
	Frozen DiskState = "Frozen"
	// ReadyToUpload A disk is ready to be created by upload by requesting a write token.
	ReadyToUpload DiskState = "ReadyToUpload"
	// Reserved The disk is attached to a stopped-deallocated VM.
	Reserved DiskState = "Reserved"
	// Unattached The disk is not being used and can be attached to a VM.
	Unattached DiskState = "Unattached"
)

// PossibleDiskStateValues returns an array of possible values for the DiskState const type.
func PossibleDiskStateValues() []DiskState {
	return []DiskState{ActiveSAS, ActiveSASFrozen, ActiveUpload, Attached, Frozen, ReadyToUpload, Reserved, Unattached}
}

// DiskStorageAccountTypes enumerates the values for disk storage account types.
type DiskStorageAccountTypes string

const (
	// PremiumLRS Premium SSD locally redundant storage. Best for production and performance sensitive
	// workloads.
	PremiumLRS DiskStorageAccountTypes = "Premium_LRS"
	// PremiumV2LRS Premium SSD v2 locally redundant storage. Best for production and performance-sensitive
	// workloads that consistently require low latency and high IOPS and throughput.
	PremiumV2LRS DiskStorageAccountTypes = "PremiumV2_LRS"
	// PremiumZRS Premium SSD zone redundant storage. Best for the production workloads that need storage
	// resiliency against zone failures.
	PremiumZRS DiskStorageAccountTypes = "Premium_ZRS"
	// StandardLRS Standard HDD locally redundant storage. Best for backup, non-critical, and infrequent
	// access.
	StandardLRS DiskStorageAccountTypes = "Standard_LRS"
	// StandardSSDLRS Standard SSD locally redundant storage. Best for web servers, lightly used enterprise
	// applications and dev/test.
	StandardSSDLRS DiskStorageAccountTypes = "StandardSSD_LRS"
	// StandardSSDZRS Standard SSD zone redundant storage. Best for web servers, lightly used enterprise
	// applications and dev/test that need storage resiliency against zone failures.
	StandardSSDZRS DiskStorageAccountTypes = "StandardSSD_ZRS"
	// UltraSSDLRS Ultra SSD locally redundant storage. Best for IO-intensive workloads such as SAP HANA, top
	// tier databases (for example, SQL, Oracle), and other transaction-heavy workloads.
	UltraSSDLRS DiskStorageAccountTypes = "UltraSSD_LRS"
)

// PossibleDiskStorageAccountTypesValues returns an array of possible values for the DiskStorageAccountTypes const type.
func PossibleDiskStorageAccountTypesValues() []DiskStorageAccountTypes {
	return []DiskStorageAccountTypes{PremiumLRS, PremiumV2LRS, PremiumZRS, StandardLRS, StandardSSDLRS, StandardSSDZRS, UltraSSDLRS}
}

// EncryptionType enumerates the values for encryption type.
type EncryptionType string

const (
	// EncryptionTypeEncryptionAtRestWithCustomerKey Disk is encrypted at rest with Customer managed key that
	// can be changed and revoked by a customer.
	EncryptionTypeEncryptionAtRestWithCustomerKey EncryptionType = "EncryptionAtRestWithCustomerKey"
	// EncryptionTypeEncryptionAtRestWithPlatformAndCustomerKeys Disk is encrypted at rest with 2 layers of
	// encryption. One of the keys is Customer managed and the other key is Platform managed.
	EncryptionTypeEncryptionAtRestWithPlatformAndCustomerKeys EncryptionType = "EncryptionAtRestWithPlatformAndCustomerKeys"
	// EncryptionTypeEncryptionAtRestWithPlatformKey Disk is encrypted at rest with Platform managed key. It is
	// the default encryption type. This is not a valid encryption type for disk encryption sets.
	EncryptionTypeEncryptionAtRestWithPlatformKey EncryptionType = "EncryptionAtRestWithPlatformKey"
)

// PossibleEncryptionTypeValues returns an array of possible values for the EncryptionType const type.
func PossibleEncryptionTypeValues() []EncryptionType {
	return []EncryptionType{EncryptionTypeEncryptionAtRestWithCustomerKey, EncryptionTypeEncryptionAtRestWithPlatformAndCustomerKeys, EncryptionTypeEncryptionAtRestWithPlatformKey}
}

// ExecutionState enumerates the values for execution state.
type ExecutionState string

const (
	// ExecutionStateCanceled ...
	ExecutionStateCanceled ExecutionState = "Canceled"
	// ExecutionStateFailed ...
	ExecutionStateFailed ExecutionState = "Failed"
	// ExecutionStatePending ...
	ExecutionStatePending ExecutionState = "Pending"
	// ExecutionStateRunning ...
	ExecutionStateRunning ExecutionState = "Running"
	// ExecutionStateSucceeded ...
	ExecutionStateSucceeded ExecutionState = "Succeeded"
	// ExecutionStateTimedOut ...
	ExecutionStateTimedOut ExecutionState = "TimedOut"
	// ExecutionStateUnknown ...
	ExecutionStateUnknown ExecutionState = "Unknown"
)

// PossibleExecutionStateValues returns an array of possible values for the ExecutionState const type.
func PossibleExecutionStateValues() []ExecutionState {
	return []ExecutionState{ExecutionStateCanceled, ExecutionStateFailed, ExecutionStatePending, ExecutionStateRunning, ExecutionStateSucceeded, ExecutionStateTimedOut, ExecutionStateUnknown}
}

// ExpandTypesForGetCapacityReservationGroups enumerates the values for expand types for get capacity
// reservation groups.
type ExpandTypesForGetCapacityReservationGroups string

const (
	// VirtualMachineScaleSetVMsref ...
	VirtualMachineScaleSetVMsref ExpandTypesForGetCapacityReservationGroups = "virtualMachineScaleSetVMs/$ref"
	// VirtualMachinesref ...
	VirtualMachinesref ExpandTypesForGetCapacityReservationGroups = "virtualMachines/$ref"
)

// PossibleExpandTypesForGetCapacityReservationGroupsValues returns an array of possible values for the ExpandTypesForGetCapacityReservationGroups const type.
func PossibleExpandTypesForGetCapacityReservationGroupsValues() []ExpandTypesForGetCapacityReservationGroups {
	return []ExpandTypesForGetCapacityReservationGroups{VirtualMachineScaleSetVMsref, VirtualMachinesref}
}

// ExpandTypesForGetVMScaleSets enumerates the values for expand types for get vm scale sets.
type ExpandTypesForGetVMScaleSets string

const (
	// UserData ...
	UserData ExpandTypesForGetVMScaleSets = "userData"
)

// PossibleExpandTypesForGetVMScaleSetsValues returns an array of possible values for the ExpandTypesForGetVMScaleSets const type.
func PossibleExpandTypesForGetVMScaleSetsValues() []ExpandTypesForGetVMScaleSets {
	return []ExpandTypesForGetVMScaleSets{UserData}
}

// ExtendedLocationType enumerates the values for extended location type.
type ExtendedLocationType string

const (
	// EdgeZone ...
	EdgeZone ExtendedLocationType = "EdgeZone"
)

// PossibleExtendedLocationTypeValues returns an array of possible values for the ExtendedLocationType const type.
func PossibleExtendedLocationTypeValues() []ExtendedLocationType {
	return []ExtendedLocationType{EdgeZone}
}

// ExtendedLocationTypes enumerates the values for extended location types.
type ExtendedLocationTypes string

const (
	// ExtendedLocationTypesEdgeZone ...
	ExtendedLocationTypesEdgeZone ExtendedLocationTypes = "EdgeZone"
)

// PossibleExtendedLocationTypesValues returns an array of possible values for the ExtendedLocationTypes const type.
func PossibleExtendedLocationTypesValues() []ExtendedLocationTypes {
	return []ExtendedLocationTypes{ExtendedLocationTypesEdgeZone}
}

// GalleryApplicationCustomActionParameterType enumerates the values for gallery application custom action
// parameter type.
type GalleryApplicationCustomActionParameterType string

const (
	// ConfigurationDataBlob ...
	ConfigurationDataBlob GalleryApplicationCustomActionParameterType = "ConfigurationDataBlob"
	// LogOutputBlob ...
	LogOutputBlob GalleryApplicationCustomActionParameterType = "LogOutputBlob"
	// String ...
	String GalleryApplicationCustomActionParameterType = "String"
)

// PossibleGalleryApplicationCustomActionParameterTypeValues returns an array of possible values for the GalleryApplicationCustomActionParameterType const type.
func PossibleGalleryApplicationCustomActionParameterTypeValues() []GalleryApplicationCustomActionParameterType {
	return []GalleryApplicationCustomActionParameterType{ConfigurationDataBlob, LogOutputBlob, String}
}

// GalleryExpandParams enumerates the values for gallery expand params.
type GalleryExpandParams string

const (
	// SharingProfileGroups ...
	SharingProfileGroups GalleryExpandParams = "SharingProfile/Groups"
)

// PossibleGalleryExpandParamsValues returns an array of possible values for the GalleryExpandParams const type.
func PossibleGalleryExpandParamsValues() []GalleryExpandParams {
	return []GalleryExpandParams{SharingProfileGroups}
}

// GalleryExtendedLocationType enumerates the values for gallery extended location type.
type GalleryExtendedLocationType string

const (
	// GalleryExtendedLocationTypeEdgeZone ...
	GalleryExtendedLocationTypeEdgeZone GalleryExtendedLocationType = "EdgeZone"
	// GalleryExtendedLocationTypeUnknown ...
	GalleryExtendedLocationTypeUnknown GalleryExtendedLocationType = "Unknown"
)

// PossibleGalleryExtendedLocationTypeValues returns an array of possible values for the GalleryExtendedLocationType const type.
func PossibleGalleryExtendedLocationTypeValues() []GalleryExtendedLocationType {
	return []GalleryExtendedLocationType{GalleryExtendedLocationTypeEdgeZone, GalleryExtendedLocationTypeUnknown}
}

// GalleryProvisioningState enumerates the values for gallery provisioning state.
type GalleryProvisioningState string

const (
	// GalleryProvisioningStateCreating ...
	GalleryProvisioningStateCreating GalleryProvisioningState = "Creating"
	// GalleryProvisioningStateDeleting ...
	GalleryProvisioningStateDeleting GalleryProvisioningState = "Deleting"
	// GalleryProvisioningStateFailed ...
	GalleryProvisioningStateFailed GalleryProvisioningState = "Failed"
	// GalleryProvisioningStateMigrating ...
	GalleryProvisioningStateMigrating GalleryProvisioningState = "Migrating"
	// GalleryProvisioningStateSucceeded ...
	GalleryProvisioningStateSucceeded GalleryProvisioningState = "Succeeded"
	// GalleryProvisioningStateUpdating ...
	GalleryProvisioningStateUpdating GalleryProvisioningState = "Updating"
)

// PossibleGalleryProvisioningStateValues returns an array of possible values for the GalleryProvisioningState const type.
func PossibleGalleryProvisioningStateValues() []GalleryProvisioningState {
	return []GalleryProvisioningState{GalleryProvisioningStateCreating, GalleryProvisioningStateDeleting, GalleryProvisioningStateFailed, GalleryProvisioningStateMigrating, GalleryProvisioningStateSucceeded, GalleryProvisioningStateUpdating}
}

// GallerySharingPermissionTypes enumerates the values for gallery sharing permission types.
type GallerySharingPermissionTypes string

const (
	// Community ...
	Community GallerySharingPermissionTypes = "Community"
	// Groups ...
	Groups GallerySharingPermissionTypes = "Groups"
	// Private ...
	Private GallerySharingPermissionTypes = "Private"
)

// PossibleGallerySharingPermissionTypesValues returns an array of possible values for the GallerySharingPermissionTypes const type.
func PossibleGallerySharingPermissionTypesValues() []GallerySharingPermissionTypes {
	return []GallerySharingPermissionTypes{Community, Groups, Private}
}

// HostCaching enumerates the values for host caching.
type HostCaching string

const (
	// HostCachingNone ...
	HostCachingNone HostCaching = "None"
	// HostCachingReadOnly ...
	HostCachingReadOnly HostCaching = "ReadOnly"
	// HostCachingReadWrite ...
	HostCachingReadWrite HostCaching = "ReadWrite"
)

// PossibleHostCachingValues returns an array of possible values for the HostCaching const type.
func PossibleHostCachingValues() []HostCaching {
	return []HostCaching{HostCachingNone, HostCachingReadOnly, HostCachingReadWrite}
}

// HyperVGeneration enumerates the values for hyper v generation.
type HyperVGeneration string

const (
	// V1 ...
	V1 HyperVGeneration = "V1"
	// V2 ...
	V2 HyperVGeneration = "V2"
)

// PossibleHyperVGenerationValues returns an array of possible values for the HyperVGeneration const type.
func PossibleHyperVGenerationValues() []HyperVGeneration {
	return []HyperVGeneration{V1, V2}
}

// HyperVGenerationType enumerates the values for hyper v generation type.
type HyperVGenerationType string

const (
	// HyperVGenerationTypeV1 ...
	HyperVGenerationTypeV1 HyperVGenerationType = "V1"
	// HyperVGenerationTypeV2 ...
	HyperVGenerationTypeV2 HyperVGenerationType = "V2"
)

// PossibleHyperVGenerationTypeValues returns an array of possible values for the HyperVGenerationType const type.
func PossibleHyperVGenerationTypeValues() []HyperVGenerationType {
	return []HyperVGenerationType{HyperVGenerationTypeV1, HyperVGenerationTypeV2}
}

// HyperVGenerationTypes enumerates the values for hyper v generation types.
type HyperVGenerationTypes string

const (
	// HyperVGenerationTypesV1 ...
	HyperVGenerationTypesV1 HyperVGenerationTypes = "V1"
	// HyperVGenerationTypesV2 ...
	HyperVGenerationTypesV2 HyperVGenerationTypes = "V2"
)

// PossibleHyperVGenerationTypesValues returns an array of possible values for the HyperVGenerationTypes const type.
func PossibleHyperVGenerationTypesValues() []HyperVGenerationTypes {
	return []HyperVGenerationTypes{HyperVGenerationTypesV1, HyperVGenerationTypesV2}
}

// InstanceViewTypes enumerates the values for instance view types.
type InstanceViewTypes string

const (
	// InstanceViewTypesInstanceView ...
	InstanceViewTypesInstanceView InstanceViewTypes = "instanceView"
	// InstanceViewTypesUserData ...
	InstanceViewTypesUserData InstanceViewTypes = "userData"
)

// PossibleInstanceViewTypesValues returns an array of possible values for the InstanceViewTypes const type.
func PossibleInstanceViewTypesValues() []InstanceViewTypes {
	return []InstanceViewTypes{InstanceViewTypesInstanceView, InstanceViewTypesUserData}
}

// IntervalInMins enumerates the values for interval in mins.
type IntervalInMins string

const (
	// FiveMins ...
	FiveMins IntervalInMins = "FiveMins"
	// SixtyMins ...
	SixtyMins IntervalInMins = "SixtyMins"
	// ThirtyMins ...
	ThirtyMins IntervalInMins = "ThirtyMins"
	// ThreeMins ...
	ThreeMins IntervalInMins = "ThreeMins"
)

// PossibleIntervalInMinsValues returns an array of possible values for the IntervalInMins const type.
func PossibleIntervalInMinsValues() []IntervalInMins {
	return []IntervalInMins{FiveMins, SixtyMins, ThirtyMins, ThreeMins}
}

// IPVersion enumerates the values for ip version.
type IPVersion string

const (
	// IPv4 ...
	IPv4 IPVersion = "IPv4"
	// IPv6 ...
	IPv6 IPVersion = "IPv6"
)

// PossibleIPVersionValues returns an array of possible values for the IPVersion const type.
func PossibleIPVersionValues() []IPVersion {
	return []IPVersion{IPv4, IPv6}
}

// IPVersions enumerates the values for ip versions.
type IPVersions string

const (
	// IPVersionsIPv4 ...
	IPVersionsIPv4 IPVersions = "IPv4"
	// IPVersionsIPv6 ...
	IPVersionsIPv6 IPVersions = "IPv6"
)

// PossibleIPVersionsValues returns an array of possible values for the IPVersions const type.
func PossibleIPVersionsValues() []IPVersions {
	return []IPVersions{IPVersionsIPv4, IPVersionsIPv6}
}

// LinuxPatchAssessmentMode enumerates the values for linux patch assessment mode.
type LinuxPatchAssessmentMode string

const (
	// AutomaticByPlatform ...
	AutomaticByPlatform LinuxPatchAssessmentMode = "AutomaticByPlatform"
	// ImageDefault ...
	ImageDefault LinuxPatchAssessmentMode = "ImageDefault"
)

// PossibleLinuxPatchAssessmentModeValues returns an array of possible values for the LinuxPatchAssessmentMode const type.
func PossibleLinuxPatchAssessmentModeValues() []LinuxPatchAssessmentMode {
	return []LinuxPatchAssessmentMode{AutomaticByPlatform, ImageDefault}
}

// LinuxVMGuestPatchAutomaticByPlatformRebootSetting enumerates the values for linux vm guest patch automatic
// by platform reboot setting.
type LinuxVMGuestPatchAutomaticByPlatformRebootSetting string

const (
	// LinuxVMGuestPatchAutomaticByPlatformRebootSettingAlways ...
	LinuxVMGuestPatchAutomaticByPlatformRebootSettingAlways LinuxVMGuestPatchAutomaticByPlatformRebootSetting = "Always"
	// LinuxVMGuestPatchAutomaticByPlatformRebootSettingIfRequired ...
	LinuxVMGuestPatchAutomaticByPlatformRebootSettingIfRequired LinuxVMGuestPatchAutomaticByPlatformRebootSetting = "IfRequired"
	// LinuxVMGuestPatchAutomaticByPlatformRebootSettingNever ...
	LinuxVMGuestPatchAutomaticByPlatformRebootSettingNever LinuxVMGuestPatchAutomaticByPlatformRebootSetting = "Never"
	// LinuxVMGuestPatchAutomaticByPlatformRebootSettingUnknown ...
	LinuxVMGuestPatchAutomaticByPlatformRebootSettingUnknown LinuxVMGuestPatchAutomaticByPlatformRebootSetting = "Unknown"
)

// PossibleLinuxVMGuestPatchAutomaticByPlatformRebootSettingValues returns an array of possible values for the LinuxVMGuestPatchAutomaticByPlatformRebootSetting const type.
func PossibleLinuxVMGuestPatchAutomaticByPlatformRebootSettingValues() []LinuxVMGuestPatchAutomaticByPlatformRebootSetting {
	return []LinuxVMGuestPatchAutomaticByPlatformRebootSetting{LinuxVMGuestPatchAutomaticByPlatformRebootSettingAlways, LinuxVMGuestPatchAutomaticByPlatformRebootSettingIfRequired, LinuxVMGuestPatchAutomaticByPlatformRebootSettingNever, LinuxVMGuestPatchAutomaticByPlatformRebootSettingUnknown}
}

// LinuxVMGuestPatchMode enumerates the values for linux vm guest patch mode.
type LinuxVMGuestPatchMode string

const (
	// LinuxVMGuestPatchModeAutomaticByPlatform ...
	LinuxVMGuestPatchModeAutomaticByPlatform LinuxVMGuestPatchMode = "AutomaticByPlatform"
	// LinuxVMGuestPatchModeImageDefault ...
	LinuxVMGuestPatchModeImageDefault LinuxVMGuestPatchMode = "ImageDefault"
)

// PossibleLinuxVMGuestPatchModeValues returns an array of possible values for the LinuxVMGuestPatchMode const type.
func PossibleLinuxVMGuestPatchModeValues() []LinuxVMGuestPatchMode {
	return []LinuxVMGuestPatchMode{LinuxVMGuestPatchModeAutomaticByPlatform, LinuxVMGuestPatchModeImageDefault}
}

// MaintenanceOperationResultCodeTypes enumerates the values for maintenance operation result code types.
type MaintenanceOperationResultCodeTypes string

const (
	// MaintenanceOperationResultCodeTypesMaintenanceAborted ...
	MaintenanceOperationResultCodeTypesMaintenanceAborted MaintenanceOperationResultCodeTypes = "MaintenanceAborted"
	// MaintenanceOperationResultCodeTypesMaintenanceCompleted ...
	MaintenanceOperationResultCodeTypesMaintenanceCompleted MaintenanceOperationResultCodeTypes = "MaintenanceCompleted"
	// MaintenanceOperationResultCodeTypesNone ...
	MaintenanceOperationResultCodeTypesNone MaintenanceOperationResultCodeTypes = "None"
	// MaintenanceOperationResultCodeTypesRetryLater ...
	MaintenanceOperationResultCodeTypesRetryLater MaintenanceOperationResultCodeTypes = "RetryLater"
)

// PossibleMaintenanceOperationResultCodeTypesValues returns an array of possible values for the MaintenanceOperationResultCodeTypes const type.
func PossibleMaintenanceOperationResultCodeTypesValues() []MaintenanceOperationResultCodeTypes {
	return []MaintenanceOperationResultCodeTypes{MaintenanceOperationResultCodeTypesMaintenanceAborted, MaintenanceOperationResultCodeTypesMaintenanceCompleted, MaintenanceOperationResultCodeTypesNone, MaintenanceOperationResultCodeTypesRetryLater}
}

// NetworkAccessPolicy enumerates the values for network access policy.
type NetworkAccessPolicy string

const (
	// AllowAll The disk can be exported or uploaded to from any network.
	AllowAll NetworkAccessPolicy = "AllowAll"
	// AllowPrivate The disk can be exported or uploaded to using a DiskAccess resource's private endpoints.
	AllowPrivate NetworkAccessPolicy = "AllowPrivate"
	// DenyAll The disk cannot be exported.
	DenyAll NetworkAccessPolicy = "DenyAll"
)

// PossibleNetworkAccessPolicyValues returns an array of possible values for the NetworkAccessPolicy const type.
func PossibleNetworkAccessPolicyValues() []NetworkAccessPolicy {
	return []NetworkAccessPolicy{AllowAll, AllowPrivate, DenyAll}
}

// NetworkAPIVersion enumerates the values for network api version.
type NetworkAPIVersion string

const (
	// TwoZeroTwoZeroHyphenMinusOneOneHyphenMinusZeroOne ...
	TwoZeroTwoZeroHyphenMinusOneOneHyphenMinusZeroOne NetworkAPIVersion = "2020-11-01"
)

// PossibleNetworkAPIVersionValues returns an array of possible values for the NetworkAPIVersion const type.
func PossibleNetworkAPIVersionValues() []NetworkAPIVersion {
	return []NetworkAPIVersion{TwoZeroTwoZeroHyphenMinusOneOneHyphenMinusZeroOne}
}

// OperatingSystemStateTypes enumerates the values for operating system state types.
type OperatingSystemStateTypes string

const (
	// Generalized Generalized image. Needs to be provisioned during deployment time.
	Generalized OperatingSystemStateTypes = "Generalized"
	// Specialized Specialized image. Contains already provisioned OS Disk.
	Specialized OperatingSystemStateTypes = "Specialized"
)

// PossibleOperatingSystemStateTypesValues returns an array of possible values for the OperatingSystemStateTypes const type.
func PossibleOperatingSystemStateTypesValues() []OperatingSystemStateTypes {
	return []OperatingSystemStateTypes{Generalized, Specialized}
}

// OperatingSystemType enumerates the values for operating system type.
type OperatingSystemType string

const (
	// Linux ...
	Linux OperatingSystemType = "Linux"
	// Windows ...
	Windows OperatingSystemType = "Windows"
)

// PossibleOperatingSystemTypeValues returns an array of possible values for the OperatingSystemType const type.
func PossibleOperatingSystemTypeValues() []OperatingSystemType {
	return []OperatingSystemType{Linux, Windows}
}

// OperatingSystemTypes enumerates the values for operating system types.
type OperatingSystemTypes string

const (
	// OperatingSystemTypesLinux ...
	OperatingSystemTypesLinux OperatingSystemTypes = "Linux"
	// OperatingSystemTypesWindows ...
	OperatingSystemTypesWindows OperatingSystemTypes = "Windows"
)

// PossibleOperatingSystemTypesValues returns an array of possible values for the OperatingSystemTypes const type.
func PossibleOperatingSystemTypesValues() []OperatingSystemTypes {
	return []OperatingSystemTypes{OperatingSystemTypesLinux, OperatingSystemTypesWindows}
}

// OrchestrationMode enumerates the values for orchestration mode.
type OrchestrationMode string

const (
	// Flexible ...
	Flexible OrchestrationMode = "Flexible"
	// Uniform ...
	Uniform OrchestrationMode = "Uniform"
)

// PossibleOrchestrationModeValues returns an array of possible values for the OrchestrationMode const type.
func PossibleOrchestrationModeValues() []OrchestrationMode {
	return []OrchestrationMode{Flexible, Uniform}
}

// OrchestrationServiceNames enumerates the values for orchestration service names.
type OrchestrationServiceNames string

const (
	// AutomaticRepairs ...
	AutomaticRepairs OrchestrationServiceNames = "AutomaticRepairs"
)

// PossibleOrchestrationServiceNamesValues returns an array of possible values for the OrchestrationServiceNames const type.
func PossibleOrchestrationServiceNamesValues() []OrchestrationServiceNames {
	return []OrchestrationServiceNames{AutomaticRepairs}
}

// OrchestrationServiceState enumerates the values for orchestration service state.
type OrchestrationServiceState string

const (
	// NotRunning ...
	NotRunning OrchestrationServiceState = "NotRunning"
	// Running ...
	Running OrchestrationServiceState = "Running"
	// Suspended ...
	Suspended OrchestrationServiceState = "Suspended"
)

// PossibleOrchestrationServiceStateValues returns an array of possible values for the OrchestrationServiceState const type.
func PossibleOrchestrationServiceStateValues() []OrchestrationServiceState {
	return []OrchestrationServiceState{NotRunning, Running, Suspended}
}

// OrchestrationServiceStateAction enumerates the values for orchestration service state action.
type OrchestrationServiceStateAction string

const (
	// Resume ...
	Resume OrchestrationServiceStateAction = "Resume"
	// Suspend ...
	Suspend OrchestrationServiceStateAction = "Suspend"
)

// PossibleOrchestrationServiceStateActionValues returns an array of possible values for the OrchestrationServiceStateAction const type.
func PossibleOrchestrationServiceStateActionValues() []OrchestrationServiceStateAction {
	return []OrchestrationServiceStateAction{Resume, Suspend}
}

// PassNames enumerates the values for pass names.
type PassNames string

const (
	// OobeSystem ...
	OobeSystem PassNames = "OobeSystem"
)

// PossiblePassNamesValues returns an array of possible values for the PassNames const type.
func PossiblePassNamesValues() []PassNames {
	return []PassNames{OobeSystem}
}

// PatchAssessmentState enumerates the values for patch assessment state.
type PatchAssessmentState string

const (
	// PatchAssessmentStateAvailable ...
	PatchAssessmentStateAvailable PatchAssessmentState = "Available"
	// PatchAssessmentStateUnknown ...
	PatchAssessmentStateUnknown PatchAssessmentState = "Unknown"
)

// PossiblePatchAssessmentStateValues returns an array of possible values for the PatchAssessmentState const type.
func PossiblePatchAssessmentStateValues() []PatchAssessmentState {
	return []PatchAssessmentState{PatchAssessmentStateAvailable, PatchAssessmentStateUnknown}
}

// PatchInstallationState enumerates the values for patch installation state.
type PatchInstallationState string

const (
	// PatchInstallationStateExcluded ...
	PatchInstallationStateExcluded PatchInstallationState = "Excluded"
	// PatchInstallationStateFailed ...
	PatchInstallationStateFailed PatchInstallationState = "Failed"
	// PatchInstallationStateInstalled ...
	PatchInstallationStateInstalled PatchInstallationState = "Installed"
	// PatchInstallationStateNotSelected ...
	PatchInstallationStateNotSelected PatchInstallationState = "NotSelected"
	// PatchInstallationStatePending ...
	PatchInstallationStatePending PatchInstallationState = "Pending"
	// PatchInstallationStateUnknown ...
	PatchInstallationStateUnknown PatchInstallationState = "Unknown"
)

// PossiblePatchInstallationStateValues returns an array of possible values for the PatchInstallationState const type.
func PossiblePatchInstallationStateValues() []PatchInstallationState {
	return []PatchInstallationState{PatchInstallationStateExcluded, PatchInstallationStateFailed, PatchInstallationStateInstalled, PatchInstallationStateNotSelected, PatchInstallationStatePending, PatchInstallationStateUnknown}
}

// PatchOperationStatus enumerates the values for patch operation status.
type PatchOperationStatus string

const (
	// PatchOperationStatusCompletedWithWarnings ...
	PatchOperationStatusCompletedWithWarnings PatchOperationStatus = "CompletedWithWarnings"
	// PatchOperationStatusFailed ...
	PatchOperationStatusFailed PatchOperationStatus = "Failed"
	// PatchOperationStatusInProgress ...
	PatchOperationStatusInProgress PatchOperationStatus = "InProgress"
	// PatchOperationStatusSucceeded ...
	PatchOperationStatusSucceeded PatchOperationStatus = "Succeeded"
	// PatchOperationStatusUnknown ...
	PatchOperationStatusUnknown PatchOperationStatus = "Unknown"
)

// PossiblePatchOperationStatusValues returns an array of possible values for the PatchOperationStatus const type.
func PossiblePatchOperationStatusValues() []PatchOperationStatus {
	return []PatchOperationStatus{PatchOperationStatusCompletedWithWarnings, PatchOperationStatusFailed, PatchOperationStatusInProgress, PatchOperationStatusSucceeded, PatchOperationStatusUnknown}
}

// PolicyViolationCategory enumerates the values for policy violation category.
type PolicyViolationCategory string

const (
	// CopyrightValidation ...
	CopyrightValidation PolicyViolationCategory = "CopyrightValidation"
	// ImageFlaggedUnsafe ...
	ImageFlaggedUnsafe PolicyViolationCategory = "ImageFlaggedUnsafe"
	// IPTheft ...
	IPTheft PolicyViolationCategory = "IpTheft"
	// Other ...
	Other PolicyViolationCategory = "Other"
)

// PossiblePolicyViolationCategoryValues returns an array of possible values for the PolicyViolationCategory const type.
func PossiblePolicyViolationCategoryValues() []PolicyViolationCategory {
	return []PolicyViolationCategory{CopyrightValidation, ImageFlaggedUnsafe, IPTheft, Other}
}

// PrivateEndpointConnectionProvisioningState enumerates the values for private endpoint connection
// provisioning state.
type PrivateEndpointConnectionProvisioningState string

const (
	// PrivateEndpointConnectionProvisioningStateCreating ...
	PrivateEndpointConnectionProvisioningStateCreating PrivateEndpointConnectionProvisioningState = "Creating"
	// PrivateEndpointConnectionProvisioningStateDeleting ...
	PrivateEndpointConnectionProvisioningStateDeleting PrivateEndpointConnectionProvisioningState = "Deleting"
	// PrivateEndpointConnectionProvisioningStateFailed ...
	PrivateEndpointConnectionProvisioningStateFailed PrivateEndpointConnectionProvisioningState = "Failed"
	// PrivateEndpointConnectionProvisioningStateSucceeded ...
	PrivateEndpointConnectionProvisioningStateSucceeded PrivateEndpointConnectionProvisioningState = "Succeeded"
)

// PossiblePrivateEndpointConnectionProvisioningStateValues returns an array of possible values for the PrivateEndpointConnectionProvisioningState const type.
func PossiblePrivateEndpointConnectionProvisioningStateValues() []PrivateEndpointConnectionProvisioningState {
	return []PrivateEndpointConnectionProvisioningState{PrivateEndpointConnectionProvisioningStateCreating, PrivateEndpointConnectionProvisioningStateDeleting, PrivateEndpointConnectionProvisioningStateFailed, PrivateEndpointConnectionProvisioningStateSucceeded}
}

// PrivateEndpointServiceConnectionStatus enumerates the values for private endpoint service connection status.
type PrivateEndpointServiceConnectionStatus string

const (
	// Approved ...
	Approved PrivateEndpointServiceConnectionStatus = "Approved"
	// Pending ...
	Pending PrivateEndpointServiceConnectionStatus = "Pending"
	// Rejected ...
	Rejected PrivateEndpointServiceConnectionStatus = "Rejected"
)

// PossiblePrivateEndpointServiceConnectionStatusValues returns an array of possible values for the PrivateEndpointServiceConnectionStatus const type.
func PossiblePrivateEndpointServiceConnectionStatusValues() []PrivateEndpointServiceConnectionStatus {
	return []PrivateEndpointServiceConnectionStatus{Approved, Pending, Rejected}
}

// ProtocolTypes enumerates the values for protocol types.
type ProtocolTypes string

const (
	// HTTP ...
	HTTP ProtocolTypes = "Http"
	// HTTPS ...
	HTTPS ProtocolTypes = "Https"
)

// PossibleProtocolTypesValues returns an array of possible values for the ProtocolTypes const type.
func PossibleProtocolTypesValues() []ProtocolTypes {
	return []ProtocolTypes{HTTP, HTTPS}
}

// ProximityPlacementGroupType enumerates the values for proximity placement group type.
type ProximityPlacementGroupType string

const (
	// Standard ...
	Standard ProximityPlacementGroupType = "Standard"
	// Ultra ...
	Ultra ProximityPlacementGroupType = "Ultra"
)

// PossibleProximityPlacementGroupTypeValues returns an array of possible values for the ProximityPlacementGroupType const type.
func PossibleProximityPlacementGroupTypeValues() []ProximityPlacementGroupType {
	return []ProximityPlacementGroupType{Standard, Ultra}
}

// PublicIPAddressSkuName enumerates the values for public ip address sku name.
type PublicIPAddressSkuName string

const (
	// PublicIPAddressSkuNameBasic ...
	PublicIPAddressSkuNameBasic PublicIPAddressSkuName = "Basic"
	// PublicIPAddressSkuNameStandard ...
	PublicIPAddressSkuNameStandard PublicIPAddressSkuName = "Standard"
)

// PossiblePublicIPAddressSkuNameValues returns an array of possible values for the PublicIPAddressSkuName const type.
func PossiblePublicIPAddressSkuNameValues() []PublicIPAddressSkuName {
	return []PublicIPAddressSkuName{PublicIPAddressSkuNameBasic, PublicIPAddressSkuNameStandard}
}

// PublicIPAddressSkuTier enumerates the values for public ip address sku tier.
type PublicIPAddressSkuTier string

const (
	// Global ...
	Global PublicIPAddressSkuTier = "Global"
	// Regional ...
	Regional PublicIPAddressSkuTier = "Regional"
)

// PossiblePublicIPAddressSkuTierValues returns an array of possible values for the PublicIPAddressSkuTier const type.
func PossiblePublicIPAddressSkuTierValues() []PublicIPAddressSkuTier {
	return []PublicIPAddressSkuTier{Global, Regional}
}

// PublicIPAllocationMethod enumerates the values for public ip allocation method.
type PublicIPAllocationMethod string

const (
	// Dynamic ...
	Dynamic PublicIPAllocationMethod = "Dynamic"
	// Static ...
	Static PublicIPAllocationMethod = "Static"
)

// PossiblePublicIPAllocationMethodValues returns an array of possible values for the PublicIPAllocationMethod const type.
func PossiblePublicIPAllocationMethodValues() []PublicIPAllocationMethod {
	return []PublicIPAllocationMethod{Dynamic, Static}
}

// PublicNetworkAccess enumerates the values for public network access.
type PublicNetworkAccess string

const (
	// Disabled You cannot access the underlying data of the disk publicly on the internet even when
	// NetworkAccessPolicy is set to AllowAll. You can access the data via the SAS URI only from your trusted
	// Azure VNET when NetworkAccessPolicy is set to AllowPrivate.
	Disabled PublicNetworkAccess = "Disabled"
	// Enabled You can generate a SAS URI to access the underlying data of the disk publicly on the internet
	// when NetworkAccessPolicy is set to AllowAll. You can access the data via the SAS URI only from your
	// trusted Azure VNET when NetworkAccessPolicy is set to AllowPrivate.
	Enabled PublicNetworkAccess = "Enabled"
)

// PossiblePublicNetworkAccessValues returns an array of possible values for the PublicNetworkAccess const type.
func PossiblePublicNetworkAccessValues() []PublicNetworkAccess {
	return []PublicNetworkAccess{Disabled, Enabled}
}

// RepairAction enumerates the values for repair action.
type RepairAction string

const (
	// Reimage ...
	Reimage RepairAction = "Reimage"
	// Replace ...
	Replace RepairAction = "Replace"
	// Restart ...
	Restart RepairAction = "Restart"
)

// PossibleRepairActionValues returns an array of possible values for the RepairAction const type.
func PossibleRepairActionValues() []RepairAction {
	return []RepairAction{Reimage, Replace, Restart}
}

// ReplicationMode enumerates the values for replication mode.
type ReplicationMode string

const (
	// Full ...
	Full ReplicationMode = "Full"
	// Shallow ...
	Shallow ReplicationMode = "Shallow"
)

// PossibleReplicationModeValues returns an array of possible values for the ReplicationMode const type.
func PossibleReplicationModeValues() []ReplicationMode {
	return []ReplicationMode{Full, Shallow}
}

// ReplicationState enumerates the values for replication state.
type ReplicationState string

const (
	// ReplicationStateCompleted ...
	ReplicationStateCompleted ReplicationState = "Completed"
	// ReplicationStateFailed ...
	ReplicationStateFailed ReplicationState = "Failed"
	// ReplicationStateReplicating ...
	ReplicationStateReplicating ReplicationState = "Replicating"
	// ReplicationStateUnknown ...
	ReplicationStateUnknown ReplicationState = "Unknown"
)

// PossibleReplicationStateValues returns an array of possible values for the ReplicationState const type.
func PossibleReplicationStateValues() []ReplicationState {
	return []ReplicationState{ReplicationStateCompleted, ReplicationStateFailed, ReplicationStateReplicating, ReplicationStateUnknown}
}

// ReplicationStatusTypes enumerates the values for replication status types.
type ReplicationStatusTypes string

const (
	// ReplicationStatusTypesReplicationStatus ...
	ReplicationStatusTypesReplicationStatus ReplicationStatusTypes = "ReplicationStatus"
)

// PossibleReplicationStatusTypesValues returns an array of possible values for the ReplicationStatusTypes const type.
func PossibleReplicationStatusTypesValues() []ReplicationStatusTypes {
	return []ReplicationStatusTypes{ReplicationStatusTypesReplicationStatus}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// ResourceIdentityTypeNone ...
	ResourceIdentityTypeNone ResourceIdentityType = "None"
	// ResourceIdentityTypeSystemAssigned ...
	ResourceIdentityTypeSystemAssigned ResourceIdentityType = "SystemAssigned"
	// ResourceIdentityTypeSystemAssignedUserAssigned ...
	ResourceIdentityTypeSystemAssignedUserAssigned ResourceIdentityType = "SystemAssigned, UserAssigned"
	// ResourceIdentityTypeUserAssigned ...
	ResourceIdentityTypeUserAssigned ResourceIdentityType = "UserAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{ResourceIdentityTypeNone, ResourceIdentityTypeSystemAssigned, ResourceIdentityTypeSystemAssignedUserAssigned, ResourceIdentityTypeUserAssigned}
}

// ResourceSkuCapacityScaleType enumerates the values for resource sku capacity scale type.
type ResourceSkuCapacityScaleType string

const (
	// ResourceSkuCapacityScaleTypeAutomatic ...
	ResourceSkuCapacityScaleTypeAutomatic ResourceSkuCapacityScaleType = "Automatic"
	// ResourceSkuCapacityScaleTypeManual ...
	ResourceSkuCapacityScaleTypeManual ResourceSkuCapacityScaleType = "Manual"
	// ResourceSkuCapacityScaleTypeNone ...
	ResourceSkuCapacityScaleTypeNone ResourceSkuCapacityScaleType = "None"
)

// PossibleResourceSkuCapacityScaleTypeValues returns an array of possible values for the ResourceSkuCapacityScaleType const type.
func PossibleResourceSkuCapacityScaleTypeValues() []ResourceSkuCapacityScaleType {
	return []ResourceSkuCapacityScaleType{ResourceSkuCapacityScaleTypeAutomatic, ResourceSkuCapacityScaleTypeManual, ResourceSkuCapacityScaleTypeNone}
}

// ResourceSkuRestrictionsReasonCode enumerates the values for resource sku restrictions reason code.
type ResourceSkuRestrictionsReasonCode string

const (
	// NotAvailableForSubscription ...
	NotAvailableForSubscription ResourceSkuRestrictionsReasonCode = "NotAvailableForSubscription"
	// QuotaID ...
	QuotaID ResourceSkuRestrictionsReasonCode = "QuotaId"
)

// PossibleResourceSkuRestrictionsReasonCodeValues returns an array of possible values for the ResourceSkuRestrictionsReasonCode const type.
func PossibleResourceSkuRestrictionsReasonCodeValues() []ResourceSkuRestrictionsReasonCode {
	return []ResourceSkuRestrictionsReasonCode{NotAvailableForSubscription, QuotaID}
}

// ResourceSkuRestrictionsType enumerates the values for resource sku restrictions type.
type ResourceSkuRestrictionsType string

const (
	// Location ...
	Location ResourceSkuRestrictionsType = "Location"
	// Zone ...
	Zone ResourceSkuRestrictionsType = "Zone"
)

// PossibleResourceSkuRestrictionsTypeValues returns an array of possible values for the ResourceSkuRestrictionsType const type.
func PossibleResourceSkuRestrictionsTypeValues() []ResourceSkuRestrictionsType {
	return []ResourceSkuRestrictionsType{Location, Zone}
}

// RestorePointCollectionExpandOptions enumerates the values for restore point collection expand options.
type RestorePointCollectionExpandOptions string

const (
	// RestorePoints ...
	RestorePoints RestorePointCollectionExpandOptions = "restorePoints"
)

// PossibleRestorePointCollectionExpandOptionsValues returns an array of possible values for the RestorePointCollectionExpandOptions const type.
func PossibleRestorePointCollectionExpandOptionsValues() []RestorePointCollectionExpandOptions {
	return []RestorePointCollectionExpandOptions{RestorePoints}
}

// RestorePointExpandOptions enumerates the values for restore point expand options.
type RestorePointExpandOptions string

const (
	// RestorePointExpandOptionsInstanceView ...
	RestorePointExpandOptionsInstanceView RestorePointExpandOptions = "instanceView"
)

// PossibleRestorePointExpandOptionsValues returns an array of possible values for the RestorePointExpandOptions const type.
func PossibleRestorePointExpandOptionsValues() []RestorePointExpandOptions {
	return []RestorePointExpandOptions{RestorePointExpandOptionsInstanceView}
}

// RollingUpgradeActionType enumerates the values for rolling upgrade action type.
type RollingUpgradeActionType string

const (
	// Cancel ...
	Cancel RollingUpgradeActionType = "Cancel"
	// Start ...
	Start RollingUpgradeActionType = "Start"
)

// PossibleRollingUpgradeActionTypeValues returns an array of possible values for the RollingUpgradeActionType const type.
func PossibleRollingUpgradeActionTypeValues() []RollingUpgradeActionType {
	return []RollingUpgradeActionType{Cancel, Start}
}

// RollingUpgradeStatusCode enumerates the values for rolling upgrade status code.
type RollingUpgradeStatusCode string

const (
	// RollingUpgradeStatusCodeCancelled ...
	RollingUpgradeStatusCodeCancelled RollingUpgradeStatusCode = "Cancelled"
	// RollingUpgradeStatusCodeCompleted ...
	RollingUpgradeStatusCodeCompleted RollingUpgradeStatusCode = "Completed"
	// RollingUpgradeStatusCodeFaulted ...
	RollingUpgradeStatusCodeFaulted RollingUpgradeStatusCode = "Faulted"
	// RollingUpgradeStatusCodeRollingForward ...
	RollingUpgradeStatusCodeRollingForward RollingUpgradeStatusCode = "RollingForward"
)

// PossibleRollingUpgradeStatusCodeValues returns an array of possible values for the RollingUpgradeStatusCode const type.
func PossibleRollingUpgradeStatusCodeValues() []RollingUpgradeStatusCode {
	return []RollingUpgradeStatusCode{RollingUpgradeStatusCodeCancelled, RollingUpgradeStatusCodeCompleted, RollingUpgradeStatusCodeFaulted, RollingUpgradeStatusCodeRollingForward}
}

// SecurityEncryptionTypes enumerates the values for security encryption types.
type SecurityEncryptionTypes string

const (
	// DiskWithVMGuestState ...
	DiskWithVMGuestState SecurityEncryptionTypes = "DiskWithVMGuestState"
	// VMGuestStateOnly ...
	VMGuestStateOnly SecurityEncryptionTypes = "VMGuestStateOnly"
)

// PossibleSecurityEncryptionTypesValues returns an array of possible values for the SecurityEncryptionTypes const type.
func PossibleSecurityEncryptionTypesValues() []SecurityEncryptionTypes {
	return []SecurityEncryptionTypes{DiskWithVMGuestState, VMGuestStateOnly}
}

// SecurityTypes enumerates the values for security types.
type SecurityTypes string

const (
	// SecurityTypesConfidentialVM ...
	SecurityTypesConfidentialVM SecurityTypes = "ConfidentialVM"
	// SecurityTypesTrustedLaunch ...
	SecurityTypesTrustedLaunch SecurityTypes = "TrustedLaunch"
)

// PossibleSecurityTypesValues returns an array of possible values for the SecurityTypes const type.
func PossibleSecurityTypesValues() []SecurityTypes {
	return []SecurityTypes{SecurityTypesConfidentialVM, SecurityTypesTrustedLaunch}
}

// SelectPermissions enumerates the values for select permissions.
type SelectPermissions string

const (
	// Permissions ...
	Permissions SelectPermissions = "Permissions"
)

// PossibleSelectPermissionsValues returns an array of possible values for the SelectPermissions const type.
func PossibleSelectPermissionsValues() []SelectPermissions {
	return []SelectPermissions{Permissions}
}

// SettingNames enumerates the values for setting names.
type SettingNames string

const (
	// AutoLogon ...
	AutoLogon SettingNames = "AutoLogon"
	// FirstLogonCommands ...
	FirstLogonCommands SettingNames = "FirstLogonCommands"
)

// PossibleSettingNamesValues returns an array of possible values for the SettingNames const type.
func PossibleSettingNamesValues() []SettingNames {
	return []SettingNames{AutoLogon, FirstLogonCommands}
}

// SharedGalleryHostCaching enumerates the values for shared gallery host caching.
type SharedGalleryHostCaching string

const (
	// SharedGalleryHostCachingNone ...
	SharedGalleryHostCachingNone SharedGalleryHostCaching = "None"
	// SharedGalleryHostCachingReadOnly ...
	SharedGalleryHostCachingReadOnly SharedGalleryHostCaching = "ReadOnly"
	// SharedGalleryHostCachingReadWrite ...
	SharedGalleryHostCachingReadWrite SharedGalleryHostCaching = "ReadWrite"
)

// PossibleSharedGalleryHostCachingValues returns an array of possible values for the SharedGalleryHostCaching const type.
func PossibleSharedGalleryHostCachingValues() []SharedGalleryHostCaching {
	return []SharedGalleryHostCaching{SharedGalleryHostCachingNone, SharedGalleryHostCachingReadOnly, SharedGalleryHostCachingReadWrite}
}

// SharedToValues enumerates the values for shared to values.
type SharedToValues string

const (
	// Tenant ...
	Tenant SharedToValues = "tenant"
)

// PossibleSharedToValuesValues returns an array of possible values for the SharedToValues const type.
func PossibleSharedToValuesValues() []SharedToValues {
	return []SharedToValues{Tenant}
}

// SharingProfileGroupTypes enumerates the values for sharing profile group types.
type SharingProfileGroupTypes string

const (
	// AADTenants ...
	AADTenants SharingProfileGroupTypes = "AADTenants"
	// Subscriptions ...
	Subscriptions SharingProfileGroupTypes = "Subscriptions"
)

// PossibleSharingProfileGroupTypesValues returns an array of possible values for the SharingProfileGroupTypes const type.
func PossibleSharingProfileGroupTypesValues() []SharingProfileGroupTypes {
	return []SharingProfileGroupTypes{AADTenants, Subscriptions}
}

// SharingState enumerates the values for sharing state.
type SharingState string

const (
	// SharingStateFailed ...
	SharingStateFailed SharingState = "Failed"
	// SharingStateInProgress ...
	SharingStateInProgress SharingState = "InProgress"
	// SharingStateSucceeded ...
	SharingStateSucceeded SharingState = "Succeeded"
	// SharingStateUnknown ...
	SharingStateUnknown SharingState = "Unknown"
)

// PossibleSharingStateValues returns an array of possible values for the SharingState const type.
func PossibleSharingStateValues() []SharingState {
	return []SharingState{SharingStateFailed, SharingStateInProgress, SharingStateSucceeded, SharingStateUnknown}
}

// SharingUpdateOperationTypes enumerates the values for sharing update operation types.
type SharingUpdateOperationTypes string

const (
	// Add ...
	Add SharingUpdateOperationTypes = "Add"
	// EnableCommunity ...
	EnableCommunity SharingUpdateOperationTypes = "EnableCommunity"
	// Remove ...
	Remove SharingUpdateOperationTypes = "Remove"
	// Reset ...
	Reset SharingUpdateOperationTypes = "Reset"
)

// PossibleSharingUpdateOperationTypesValues returns an array of possible values for the SharingUpdateOperationTypes const type.
func PossibleSharingUpdateOperationTypesValues() []SharingUpdateOperationTypes {
	return []SharingUpdateOperationTypes{Add, EnableCommunity, Remove, Reset}
}

// SnapshotStorageAccountTypes enumerates the values for snapshot storage account types.
type SnapshotStorageAccountTypes string

const (
	// SnapshotStorageAccountTypesPremiumLRS Premium SSD locally redundant storage
	SnapshotStorageAccountTypesPremiumLRS SnapshotStorageAccountTypes = "Premium_LRS"
	// SnapshotStorageAccountTypesStandardLRS Standard HDD locally redundant storage
	SnapshotStorageAccountTypesStandardLRS SnapshotStorageAccountTypes = "Standard_LRS"
	// SnapshotStorageAccountTypesStandardZRS Standard zone redundant storage
	SnapshotStorageAccountTypesStandardZRS SnapshotStorageAccountTypes = "Standard_ZRS"
)

// PossibleSnapshotStorageAccountTypesValues returns an array of possible values for the SnapshotStorageAccountTypes const type.
func PossibleSnapshotStorageAccountTypesValues() []SnapshotStorageAccountTypes {
	return []SnapshotStorageAccountTypes{SnapshotStorageAccountTypesPremiumLRS, SnapshotStorageAccountTypesStandardLRS, SnapshotStorageAccountTypesStandardZRS}
}

// StatusLevelTypes enumerates the values for status level types.
type StatusLevelTypes string

const (
	// Error ...
	Error StatusLevelTypes = "Error"
	// Info ...
	Info StatusLevelTypes = "Info"
	// Warning ...
	Warning StatusLevelTypes = "Warning"
)

// PossibleStatusLevelTypesValues returns an array of possible values for the StatusLevelTypes const type.
func PossibleStatusLevelTypesValues() []StatusLevelTypes {
	return []StatusLevelTypes{Error, Info, Warning}
}

// StorageAccountType enumerates the values for storage account type.
type StorageAccountType string

const (
	// StorageAccountTypePremiumLRS ...
	StorageAccountTypePremiumLRS StorageAccountType = "Premium_LRS"
	// StorageAccountTypeStandardLRS ...
	StorageAccountTypeStandardLRS StorageAccountType = "Standard_LRS"
	// StorageAccountTypeStandardZRS ...
	StorageAccountTypeStandardZRS StorageAccountType = "Standard_ZRS"
)

// PossibleStorageAccountTypeValues returns an array of possible values for the StorageAccountType const type.
func PossibleStorageAccountTypeValues() []StorageAccountType {
	return []StorageAccountType{StorageAccountTypePremiumLRS, StorageAccountTypeStandardLRS, StorageAccountTypeStandardZRS}
}

// StorageAccountTypes enumerates the values for storage account types.
type StorageAccountTypes string

const (
	// StorageAccountTypesPremiumLRS ...
	StorageAccountTypesPremiumLRS StorageAccountTypes = "Premium_LRS"
	// StorageAccountTypesPremiumV2LRS ...
	StorageAccountTypesPremiumV2LRS StorageAccountTypes = "PremiumV2_LRS"
	// StorageAccountTypesPremiumZRS ...
	StorageAccountTypesPremiumZRS StorageAccountTypes = "Premium_ZRS"
	// StorageAccountTypesStandardLRS ...
	StorageAccountTypesStandardLRS StorageAccountTypes = "Standard_LRS"
	// StorageAccountTypesStandardSSDLRS ...
	StorageAccountTypesStandardSSDLRS StorageAccountTypes = "StandardSSD_LRS"
	// StorageAccountTypesStandardSSDZRS ...
	StorageAccountTypesStandardSSDZRS StorageAccountTypes = "StandardSSD_ZRS"
	// StorageAccountTypesUltraSSDLRS ...
	StorageAccountTypesUltraSSDLRS StorageAccountTypes = "UltraSSD_LRS"
)

// PossibleStorageAccountTypesValues returns an array of possible values for the StorageAccountTypes const type.
func PossibleStorageAccountTypesValues() []StorageAccountTypes {
	return []StorageAccountTypes{StorageAccountTypesPremiumLRS, StorageAccountTypesPremiumV2LRS, StorageAccountTypesPremiumZRS, StorageAccountTypesStandardLRS, StorageAccountTypesStandardSSDLRS, StorageAccountTypesStandardSSDZRS, StorageAccountTypesUltraSSDLRS}
}

// UpgradeMode enumerates the values for upgrade mode.
type UpgradeMode string

const (
	// UpgradeModeAutomatic ...
	UpgradeModeAutomatic UpgradeMode = "Automatic"
	// UpgradeModeManual ...
	UpgradeModeManual UpgradeMode = "Manual"
	// UpgradeModeRolling ...
	UpgradeModeRolling UpgradeMode = "Rolling"
)

// PossibleUpgradeModeValues returns an array of possible values for the UpgradeMode const type.
func PossibleUpgradeModeValues() []UpgradeMode {
	return []UpgradeMode{UpgradeModeAutomatic, UpgradeModeManual, UpgradeModeRolling}
}

// UpgradeOperationInvoker enumerates the values for upgrade operation invoker.
type UpgradeOperationInvoker string

const (
	// UpgradeOperationInvokerPlatform ...
	UpgradeOperationInvokerPlatform UpgradeOperationInvoker = "Platform"
	// UpgradeOperationInvokerUnknown ...
	UpgradeOperationInvokerUnknown UpgradeOperationInvoker = "Unknown"
	// UpgradeOperationInvokerUser ...
	UpgradeOperationInvokerUser UpgradeOperationInvoker = "User"
)

// PossibleUpgradeOperationInvokerValues returns an array of possible values for the UpgradeOperationInvoker const type.
func PossibleUpgradeOperationInvokerValues() []UpgradeOperationInvoker {
	return []UpgradeOperationInvoker{UpgradeOperationInvokerPlatform, UpgradeOperationInvokerUnknown, UpgradeOperationInvokerUser}
}

// UpgradeState enumerates the values for upgrade state.
type UpgradeState string

const (
	// UpgradeStateCancelled ...
	UpgradeStateCancelled UpgradeState = "Cancelled"
	// UpgradeStateCompleted ...
	UpgradeStateCompleted UpgradeState = "Completed"
	// UpgradeStateFaulted ...
	UpgradeStateFaulted UpgradeState = "Faulted"
	// UpgradeStateRollingForward ...
	UpgradeStateRollingForward UpgradeState = "RollingForward"
)

// PossibleUpgradeStateValues returns an array of possible values for the UpgradeState const type.
func PossibleUpgradeStateValues() []UpgradeState {
	return []UpgradeState{UpgradeStateCancelled, UpgradeStateCompleted, UpgradeStateFaulted, UpgradeStateRollingForward}
}

// VirtualMachineEvictionPolicyTypes enumerates the values for virtual machine eviction policy types.
type VirtualMachineEvictionPolicyTypes string

const (
	// VirtualMachineEvictionPolicyTypesDeallocate ...
	VirtualMachineEvictionPolicyTypesDeallocate VirtualMachineEvictionPolicyTypes = "Deallocate"
	// VirtualMachineEvictionPolicyTypesDelete ...
	VirtualMachineEvictionPolicyTypesDelete VirtualMachineEvictionPolicyTypes = "Delete"
)

// PossibleVirtualMachineEvictionPolicyTypesValues returns an array of possible values for the VirtualMachineEvictionPolicyTypes const type.
func PossibleVirtualMachineEvictionPolicyTypesValues() []VirtualMachineEvictionPolicyTypes {
	return []VirtualMachineEvictionPolicyTypes{VirtualMachineEvictionPolicyTypesDeallocate, VirtualMachineEvictionPolicyTypesDelete}
}

// VirtualMachinePriorityTypes enumerates the values for virtual machine priority types.
type VirtualMachinePriorityTypes string

const (
	// Low ...
	Low VirtualMachinePriorityTypes = "Low"
	// Regular ...
	Regular VirtualMachinePriorityTypes = "Regular"
	// Spot ...
	Spot VirtualMachinePriorityTypes = "Spot"
)

// PossibleVirtualMachinePriorityTypesValues returns an array of possible values for the VirtualMachinePriorityTypes const type.
func PossibleVirtualMachinePriorityTypesValues() []VirtualMachinePriorityTypes {
	return []VirtualMachinePriorityTypes{Low, Regular, Spot}
}

// VirtualMachineScaleSetScaleInRules enumerates the values for virtual machine scale set scale in rules.
type VirtualMachineScaleSetScaleInRules string

const (
	// Default ...
	Default VirtualMachineScaleSetScaleInRules = "Default"
	// NewestVM ...
	NewestVM VirtualMachineScaleSetScaleInRules = "NewestVM"
	// OldestVM ...
	OldestVM VirtualMachineScaleSetScaleInRules = "OldestVM"
)

// PossibleVirtualMachineScaleSetScaleInRulesValues returns an array of possible values for the VirtualMachineScaleSetScaleInRules const type.
func PossibleVirtualMachineScaleSetScaleInRulesValues() []VirtualMachineScaleSetScaleInRules {
	return []VirtualMachineScaleSetScaleInRules{Default, NewestVM, OldestVM}
}

// VirtualMachineScaleSetSkuScaleType enumerates the values for virtual machine scale set sku scale type.
type VirtualMachineScaleSetSkuScaleType string

const (
	// VirtualMachineScaleSetSkuScaleTypeAutomatic ...
	VirtualMachineScaleSetSkuScaleTypeAutomatic VirtualMachineScaleSetSkuScaleType = "Automatic"
	// VirtualMachineScaleSetSkuScaleTypeNone ...
	VirtualMachineScaleSetSkuScaleTypeNone VirtualMachineScaleSetSkuScaleType = "None"
)

// PossibleVirtualMachineScaleSetSkuScaleTypeValues returns an array of possible values for the VirtualMachineScaleSetSkuScaleType const type.
func PossibleVirtualMachineScaleSetSkuScaleTypeValues() []VirtualMachineScaleSetSkuScaleType {
	return []VirtualMachineScaleSetSkuScaleType{VirtualMachineScaleSetSkuScaleTypeAutomatic, VirtualMachineScaleSetSkuScaleTypeNone}
}

// VirtualMachineSizeTypes enumerates the values for virtual machine size types.
type VirtualMachineSizeTypes string

const (
	// BasicA0 ...
	BasicA0 VirtualMachineSizeTypes = "Basic_A0"
	// BasicA1 ...
	BasicA1 VirtualMachineSizeTypes = "Basic_A1"
	// BasicA2 ...
	BasicA2 VirtualMachineSizeTypes = "Basic_A2"
	// BasicA3 ...
	BasicA3 VirtualMachineSizeTypes = "Basic_A3"
	// BasicA4 ...
	BasicA4 VirtualMachineSizeTypes = "Basic_A4"
	// StandardA0 ...
	StandardA0 VirtualMachineSizeTypes = "Standard_A0"
	// StandardA1 ...
	StandardA1 VirtualMachineSizeTypes = "Standard_A1"
	// StandardA10 ...
	StandardA10 VirtualMachineSizeTypes = "Standard_A10"
	// StandardA11 ...
	StandardA11 VirtualMachineSizeTypes = "Standard_A11"
	// StandardA1V2 ...
	StandardA1V2 VirtualMachineSizeTypes = "Standard_A1_v2"
	// StandardA2 ...
	StandardA2 VirtualMachineSizeTypes = "Standard_A2"
	// StandardA2mV2 ...
	StandardA2mV2 VirtualMachineSizeTypes = "Standard_A2m_v2"
	// StandardA2V2 ...
	StandardA2V2 VirtualMachineSizeTypes = "Standard_A2_v2"
	// StandardA3 ...
	StandardA3 VirtualMachineSizeTypes = "Standard_A3"
	// StandardA4 ...
	StandardA4 VirtualMachineSizeTypes = "Standard_A4"
	// StandardA4mV2 ...
	StandardA4mV2 VirtualMachineSizeTypes = "Standard_A4m_v2"
	// StandardA4V2 ...
	StandardA4V2 VirtualMachineSizeTypes = "Standard_A4_v2"
	// StandardA5 ...
	StandardA5 VirtualMachineSizeTypes = "Standard_A5"
	// StandardA6 ...
	StandardA6 VirtualMachineSizeTypes = "Standard_A6"
	// StandardA7 ...
	StandardA7 VirtualMachineSizeTypes = "Standard_A7"
	// StandardA8 ...
	StandardA8 VirtualMachineSizeTypes = "Standard_A8"
	// StandardA8mV2 ...
	StandardA8mV2 VirtualMachineSizeTypes = "Standard_A8m_v2"
	// StandardA8V2 ...
	StandardA8V2 VirtualMachineSizeTypes = "Standard_A8_v2"
	// StandardA9 ...
	StandardA9 VirtualMachineSizeTypes = "Standard_A9"
	// StandardB1ms ...
	StandardB1ms VirtualMachineSizeTypes = "Standard_B1ms"
	// StandardB1s ...
	StandardB1s VirtualMachineSizeTypes = "Standard_B1s"
	// StandardB2ms ...
	StandardB2ms VirtualMachineSizeTypes = "Standard_B2ms"
	// StandardB2s ...
	StandardB2s VirtualMachineSizeTypes = "Standard_B2s"
	// StandardB4ms ...
	StandardB4ms VirtualMachineSizeTypes = "Standard_B4ms"
	// StandardB8ms ...
	StandardB8ms VirtualMachineSizeTypes = "Standard_B8ms"
	// StandardD1 ...
	StandardD1 VirtualMachineSizeTypes = "Standard_D1"
	// StandardD11 ...
	StandardD11 VirtualMachineSizeTypes = "Standard_D11"
	// StandardD11V2 ...
	StandardD11V2 VirtualMachineSizeTypes = "Standard_D11_v2"
	// StandardD12 ...
	StandardD12 VirtualMachineSizeTypes = "Standard_D12"
	// StandardD12V2 ...
	StandardD12V2 VirtualMachineSizeTypes = "Standard_D12_v2"
	// StandardD13 ...
	StandardD13 VirtualMachineSizeTypes = "Standard_D13"
	// StandardD13V2 ...
	StandardD13V2 VirtualMachineSizeTypes = "Standard_D13_v2"
	// StandardD14 ...
	StandardD14 VirtualMachineSizeTypes = "Standard_D14"
	// StandardD14V2 ...
	StandardD14V2 VirtualMachineSizeTypes = "Standard_D14_v2"
	// StandardD15V2 ...
	StandardD15V2 VirtualMachineSizeTypes = "Standard_D15_v2"
	// StandardD16sV3 ...
	StandardD16sV3 VirtualMachineSizeTypes = "Standard_D16s_v3"
	// StandardD16V3 ...
	StandardD16V3 VirtualMachineSizeTypes = "Standard_D16_v3"
	// StandardD1V2 ...
	StandardD1V2 VirtualMachineSizeTypes = "Standard_D1_v2"
	// StandardD2 ...
	StandardD2 VirtualMachineSizeTypes = "Standard_D2"
	// StandardD2sV3 ...
	StandardD2sV3 VirtualMachineSizeTypes = "Standard_D2s_v3"
	// StandardD2V2 ...
	StandardD2V2 VirtualMachineSizeTypes = "Standard_D2_v2"
	// StandardD2V3 ...
	StandardD2V3 VirtualMachineSizeTypes = "Standard_D2_v3"
	// StandardD3 ...
	StandardD3 VirtualMachineSizeTypes = "Standard_D3"
	// StandardD32sV3 ...
	StandardD32sV3 VirtualMachineSizeTypes = "Standard_D32s_v3"
	// StandardD32V3 ...
	StandardD32V3 VirtualMachineSizeTypes = "Standard_D32_v3"
	// StandardD3V2 ...
	StandardD3V2 VirtualMachineSizeTypes = "Standard_D3_v2"
	// StandardD4 ...
	StandardD4 VirtualMachineSizeTypes = "Standard_D4"
	// StandardD4sV3 ...
	StandardD4sV3 VirtualMachineSizeTypes = "Standard_D4s_v3"
	// StandardD4V2 ...
	StandardD4V2 VirtualMachineSizeTypes = "Standard_D4_v2"
	// StandardD4V3 ...
	StandardD4V3 VirtualMachineSizeTypes = "Standard_D4_v3"
	// StandardD5V2 ...
	StandardD5V2 VirtualMachineSizeTypes = "Standard_D5_v2"
	// StandardD64sV3 ...
	StandardD64sV3 VirtualMachineSizeTypes = "Standard_D64s_v3"
	// StandardD64V3 ...
	StandardD64V3 VirtualMachineSizeTypes = "Standard_D64_v3"
	// StandardD8sV3 ...
	StandardD8sV3 VirtualMachineSizeTypes = "Standard_D8s_v3"
	// StandardD8V3 ...
	StandardD8V3 VirtualMachineSizeTypes = "Standard_D8_v3"
	// StandardDS1 ...
	StandardDS1 VirtualMachineSizeTypes = "Standard_DS1"
	// StandardDS11 ...
	StandardDS11 VirtualMachineSizeTypes = "Standard_DS11"
	// StandardDS11V2 ...
	StandardDS11V2 VirtualMachineSizeTypes = "Standard_DS11_v2"
	// StandardDS12 ...
	StandardDS12 VirtualMachineSizeTypes = "Standard_DS12"
	// StandardDS12V2 ...
	StandardDS12V2 VirtualMachineSizeTypes = "Standard_DS12_v2"
	// StandardDS13 ...
	StandardDS13 VirtualMachineSizeTypes = "Standard_DS13"
	// StandardDS132V2 ...
	StandardDS132V2 VirtualMachineSizeTypes = "Standard_DS13-2_v2"
	// StandardDS134V2 ...
	StandardDS134V2 VirtualMachineSizeTypes = "Standard_DS13-4_v2"
	// StandardDS13V2 ...
	StandardDS13V2 VirtualMachineSizeTypes = "Standard_DS13_v2"
	// StandardDS14 ...
	StandardDS14 VirtualMachineSizeTypes = "Standard_DS14"
	// StandardDS144V2 ...
	StandardDS144V2 VirtualMachineSizeTypes = "Standard_DS14-4_v2"
	// StandardDS148V2 ...
	StandardDS148V2 VirtualMachineSizeTypes = "Standard_DS14-8_v2"
	// StandardDS14V2 ...
	StandardDS14V2 VirtualMachineSizeTypes = "Standard_DS14_v2"
	// StandardDS15V2 ...
	StandardDS15V2 VirtualMachineSizeTypes = "Standard_DS15_v2"
	// StandardDS1V2 ...
	StandardDS1V2 VirtualMachineSizeTypes = "Standard_DS1_v2"
	// StandardDS2 ...
	StandardDS2 VirtualMachineSizeTypes = "Standard_DS2"
	// StandardDS2V2 ...
	StandardDS2V2 VirtualMachineSizeTypes = "Standard_DS2_v2"
	// StandardDS3 ...
	StandardDS3 VirtualMachineSizeTypes = "Standard_DS3"
	// StandardDS3V2 ...
	StandardDS3V2 VirtualMachineSizeTypes = "Standard_DS3_v2"
	// StandardDS4 ...
	StandardDS4 VirtualMachineSizeTypes = "Standard_DS4"
	// StandardDS4V2 ...
	StandardDS4V2 VirtualMachineSizeTypes = "Standard_DS4_v2"
	// StandardDS5V2 ...
	StandardDS5V2 VirtualMachineSizeTypes = "Standard_DS5_v2"
	// StandardE16sV3 ...
	StandardE16sV3 VirtualMachineSizeTypes = "Standard_E16s_v3"
	// StandardE16V3 ...
	StandardE16V3 VirtualMachineSizeTypes = "Standard_E16_v3"
	// StandardE2sV3 ...
	StandardE2sV3 VirtualMachineSizeTypes = "Standard_E2s_v3"
	// StandardE2V3 ...
	StandardE2V3 VirtualMachineSizeTypes = "Standard_E2_v3"
	// StandardE3216V3 ...
	StandardE3216V3 VirtualMachineSizeTypes = "Standard_E32-16_v3"
	// StandardE328sV3 ...
	StandardE328sV3 VirtualMachineSizeTypes = "Standard_E32-8s_v3"
	// StandardE32sV3 ...
	StandardE32sV3 VirtualMachineSizeTypes = "Standard_E32s_v3"
	// StandardE32V3 ...
	StandardE32V3 VirtualMachineSizeTypes = "Standard_E32_v3"
	// StandardE4sV3 ...
	StandardE4sV3 VirtualMachineSizeTypes = "Standard_E4s_v3"
	// StandardE4V3 ...
	StandardE4V3 VirtualMachineSizeTypes = "Standard_E4_v3"
	// StandardE6416sV3 ...
	StandardE6416sV3 VirtualMachineSizeTypes = "Standard_E64-16s_v3"
	// StandardE6432sV3 ...
	StandardE6432sV3 VirtualMachineSizeTypes = "Standard_E64-32s_v3"
	// StandardE64sV3 ...
	StandardE64sV3 VirtualMachineSizeTypes = "Standard_E64s_v3"
	// StandardE64V3 ...
	StandardE64V3 VirtualMachineSizeTypes = "Standard_E64_v3"
	// StandardE8sV3 ...
	StandardE8sV3 VirtualMachineSizeTypes = "Standard_E8s_v3"
	// StandardE8V3 ...
	StandardE8V3 VirtualMachineSizeTypes = "Standard_E8_v3"
	// StandardF1 ...
	StandardF1 VirtualMachineSizeTypes = "Standard_F1"
	// StandardF16 ...
	StandardF16 VirtualMachineSizeTypes = "Standard_F16"
	// StandardF16s ...
	StandardF16s VirtualMachineSizeTypes = "Standard_F16s"
	// StandardF16sV2 ...
	StandardF16sV2 VirtualMachineSizeTypes = "Standard_F16s_v2"
	// StandardF1s ...
	StandardF1s VirtualMachineSizeTypes = "Standard_F1s"
	// StandardF2 ...
	StandardF2 VirtualMachineSizeTypes = "Standard_F2"
	// StandardF2s ...
	StandardF2s VirtualMachineSizeTypes = "Standard_F2s"
	// StandardF2sV2 ...
	StandardF2sV2 VirtualMachineSizeTypes = "Standard_F2s_v2"
	// StandardF32sV2 ...
	StandardF32sV2 VirtualMachineSizeTypes = "Standard_F32s_v2"
	// StandardF4 ...
	StandardF4 VirtualMachineSizeTypes = "Standard_F4"
	// StandardF4s ...
	StandardF4s VirtualMachineSizeTypes = "Standard_F4s"
	// StandardF4sV2 ...
	StandardF4sV2 VirtualMachineSizeTypes = "Standard_F4s_v2"
	// StandardF64sV2 ...
	StandardF64sV2 VirtualMachineSizeTypes = "Standard_F64s_v2"
	// StandardF72sV2 ...
	StandardF72sV2 VirtualMachineSizeTypes = "Standard_F72s_v2"
	// StandardF8 ...
	StandardF8 VirtualMachineSizeTypes = "Standard_F8"
	// StandardF8s ...
	StandardF8s VirtualMachineSizeTypes = "Standard_F8s"
	// StandardF8sV2 ...
	StandardF8sV2 VirtualMachineSizeTypes = "Standard_F8s_v2"
	// StandardG1 ...
	StandardG1 VirtualMachineSizeTypes = "Standard_G1"
	// StandardG2 ...
	StandardG2 VirtualMachineSizeTypes = "Standard_G2"
	// StandardG3 ...
	StandardG3 VirtualMachineSizeTypes = "Standard_G3"
	// StandardG4 ...
	StandardG4 VirtualMachineSizeTypes = "Standard_G4"
	// StandardG5 ...
	StandardG5 VirtualMachineSizeTypes = "Standard_G5"
	// StandardGS1 ...
	StandardGS1 VirtualMachineSizeTypes = "Standard_GS1"
	// StandardGS2 ...
	StandardGS2 VirtualMachineSizeTypes = "Standard_GS2"
	// StandardGS3 ...
	StandardGS3 VirtualMachineSizeTypes = "Standard_GS3"
	// StandardGS4 ...
	StandardGS4 VirtualMachineSizeTypes = "Standard_GS4"
	// StandardGS44 ...
	StandardGS44 VirtualMachineSizeTypes = "Standard_GS4-4"
	// StandardGS48 ...
	StandardGS48 VirtualMachineSizeTypes = "Standard_GS4-8"
	// StandardGS5 ...
	StandardGS5 VirtualMachineSizeTypes = "Standard_GS5"
	// StandardGS516 ...
	StandardGS516 VirtualMachineSizeTypes = "Standard_GS5-16"
	// StandardGS58 ...
	StandardGS58 VirtualMachineSizeTypes = "Standard_GS5-8"
	// StandardH16 ...
	StandardH16 VirtualMachineSizeTypes = "Standard_H16"
	// StandardH16m ...
	StandardH16m VirtualMachineSizeTypes = "Standard_H16m"
	// StandardH16mr ...
	StandardH16mr VirtualMachineSizeTypes = "Standard_H16mr"
	// StandardH16r ...
	StandardH16r VirtualMachineSizeTypes = "Standard_H16r"
	// StandardH8 ...
	StandardH8 VirtualMachineSizeTypes = "Standard_H8"
	// StandardH8m ...
	StandardH8m VirtualMachineSizeTypes = "Standard_H8m"
	// StandardL16s ...
	StandardL16s VirtualMachineSizeTypes = "Standard_L16s"
	// StandardL32s ...
	StandardL32s VirtualMachineSizeTypes = "Standard_L32s"
	// StandardL4s ...
	StandardL4s VirtualMachineSizeTypes = "Standard_L4s"
	// StandardL8s ...
	StandardL8s VirtualMachineSizeTypes = "Standard_L8s"
	// StandardM12832ms ...
	StandardM12832ms VirtualMachineSizeTypes = "Standard_M128-32ms"
	// StandardM12864ms ...
	StandardM12864ms VirtualMachineSizeTypes = "Standard_M128-64ms"
	// StandardM128ms ...
	StandardM128ms VirtualMachineSizeTypes = "Standard_M128ms"
	// StandardM128s ...
	StandardM128s VirtualMachineSizeTypes = "Standard_M128s"
	// StandardM6416ms ...
	StandardM6416ms VirtualMachineSizeTypes = "Standard_M64-16ms"
	// StandardM6432ms ...
	StandardM6432ms VirtualMachineSizeTypes = "Standard_M64-32ms"
	// StandardM64ms ...
	StandardM64ms VirtualMachineSizeTypes = "Standard_M64ms"
	// StandardM64s ...
	StandardM64s VirtualMachineSizeTypes = "Standard_M64s"
	// StandardNC12 ...
	StandardNC12 VirtualMachineSizeTypes = "Standard_NC12"
	// StandardNC12sV2 ...
	StandardNC12sV2 VirtualMachineSizeTypes = "Standard_NC12s_v2"
	// StandardNC12sV3 ...
	StandardNC12sV3 VirtualMachineSizeTypes = "Standard_NC12s_v3"
	// StandardNC24 ...
	StandardNC24 VirtualMachineSizeTypes = "Standard_NC24"
	// StandardNC24r ...
	StandardNC24r VirtualMachineSizeTypes = "Standard_NC24r"
	// StandardNC24rsV2 ...
	StandardNC24rsV2 VirtualMachineSizeTypes = "Standard_NC24rs_v2"
	// StandardNC24rsV3 ...
	StandardNC24rsV3 VirtualMachineSizeTypes = "Standard_NC24rs_v3"
	// StandardNC24sV2 ...
	StandardNC24sV2 VirtualMachineSizeTypes = "Standard_NC24s_v2"
	// StandardNC24sV3 ...
	StandardNC24sV3 VirtualMachineSizeTypes = "Standard_NC24s_v3"
	// StandardNC6 ...
	StandardNC6 VirtualMachineSizeTypes = "Standard_NC6"
	// StandardNC6sV2 ...
	StandardNC6sV2 VirtualMachineSizeTypes = "Standard_NC6s_v2"
	// StandardNC6sV3 ...
	StandardNC6sV3 VirtualMachineSizeTypes = "Standard_NC6s_v3"
	// StandardND12s ...
	StandardND12s VirtualMachineSizeTypes = "Standard_ND12s"
	// StandardND24rs ...
	StandardND24rs VirtualMachineSizeTypes = "Standard_ND24rs"
	// StandardND24s ...
	StandardND24s VirtualMachineSizeTypes = "Standard_ND24s"
	// StandardND6s ...
	StandardND6s VirtualMachineSizeTypes = "Standard_ND6s"
	// StandardNV12 ...
	StandardNV12 VirtualMachineSizeTypes = "Standard_NV12"
	// StandardNV24 ...
	StandardNV24 VirtualMachineSizeTypes = "Standard_NV24"
	// StandardNV6 ...
	StandardNV6 VirtualMachineSizeTypes = "Standard_NV6"
)

// PossibleVirtualMachineSizeTypesValues returns an array of possible values for the VirtualMachineSizeTypes const type.
func PossibleVirtualMachineSizeTypesValues() []VirtualMachineSizeTypes {
	return []VirtualMachineSizeTypes{BasicA0, BasicA1, BasicA2, BasicA3, BasicA4, StandardA0, StandardA1, StandardA10, StandardA11, StandardA1V2, StandardA2, StandardA2mV2, StandardA2V2, StandardA3, StandardA4, StandardA4mV2, StandardA4V2, StandardA5, StandardA6, StandardA7, StandardA8, StandardA8mV2, StandardA8V2, StandardA9, StandardB1ms, StandardB1s, StandardB2ms, StandardB2s, StandardB4ms, StandardB8ms, StandardD1, StandardD11, StandardD11V2, StandardD12, StandardD12V2, StandardD13, StandardD13V2, StandardD14, StandardD14V2, StandardD15V2, StandardD16sV3, StandardD16V3, StandardD1V2, StandardD2, StandardD2sV3, StandardD2V2, StandardD2V3, StandardD3, StandardD32sV3, StandardD32V3, StandardD3V2, StandardD4, StandardD4sV3, StandardD4V2, StandardD4V3, StandardD5V2, StandardD64sV3, StandardD64V3, StandardD8sV3, StandardD8V3, StandardDS1, StandardDS11, StandardDS11V2, StandardDS12, StandardDS12V2, StandardDS13, StandardDS132V2, StandardDS134V2, StandardDS13V2, StandardDS14, StandardDS144V2, StandardDS148V2, StandardDS14V2, StandardDS15V2, StandardDS1V2, StandardDS2, StandardDS2V2, StandardDS3, StandardDS3V2, StandardDS4, StandardDS4V2, StandardDS5V2, StandardE16sV3, StandardE16V3, StandardE2sV3, StandardE2V3, StandardE3216V3, StandardE328sV3, StandardE32sV3, StandardE32V3, StandardE4sV3, StandardE4V3, StandardE6416sV3, StandardE6432sV3, StandardE64sV3, StandardE64V3, StandardE8sV3, StandardE8V3, StandardF1, StandardF16, StandardF16s, StandardF16sV2, StandardF1s, StandardF2, StandardF2s, StandardF2sV2, StandardF32sV2, StandardF4, StandardF4s, StandardF4sV2, StandardF64sV2, StandardF72sV2, StandardF8, StandardF8s, StandardF8sV2, StandardG1, StandardG2, StandardG3, StandardG4, StandardG5, StandardGS1, StandardGS2, StandardGS3, StandardGS4, StandardGS44, StandardGS48, StandardGS5, StandardGS516, StandardGS58, StandardH16, StandardH16m, StandardH16mr, StandardH16r, StandardH8, StandardH8m, StandardL16s, StandardL32s, StandardL4s, StandardL8s, StandardM12832ms, StandardM12864ms, StandardM128ms, StandardM128s, StandardM6416ms, StandardM6432ms, StandardM64ms, StandardM64s, StandardNC12, StandardNC12sV2, StandardNC12sV3, StandardNC24, StandardNC24r, StandardNC24rsV2, StandardNC24rsV3, StandardNC24sV2, StandardNC24sV3, StandardNC6, StandardNC6sV2, StandardNC6sV3, StandardND12s, StandardND24rs, StandardND24s, StandardND6s, StandardNV12, StandardNV24, StandardNV6}
}

// VMDiskTypes enumerates the values for vm disk types.
type VMDiskTypes string

const (
	// VMDiskTypesNone ...
	VMDiskTypesNone VMDiskTypes = "None"
	// VMDiskTypesUnmanaged ...
	VMDiskTypesUnmanaged VMDiskTypes = "Unmanaged"
)

// PossibleVMDiskTypesValues returns an array of possible values for the VMDiskTypes const type.
func PossibleVMDiskTypesValues() []VMDiskTypes {
	return []VMDiskTypes{VMDiskTypesNone, VMDiskTypesUnmanaged}
}

// VMGuestPatchClassificationLinux enumerates the values for vm guest patch classification linux.
type VMGuestPatchClassificationLinux string

const (
	// VMGuestPatchClassificationLinuxCritical ...
	VMGuestPatchClassificationLinuxCritical VMGuestPatchClassificationLinux = "Critical"
	// VMGuestPatchClassificationLinuxOther ...
	VMGuestPatchClassificationLinuxOther VMGuestPatchClassificationLinux = "Other"
	// VMGuestPatchClassificationLinuxSecurity ...
	VMGuestPatchClassificationLinuxSecurity VMGuestPatchClassificationLinux = "Security"
)

// PossibleVMGuestPatchClassificationLinuxValues returns an array of possible values for the VMGuestPatchClassificationLinux const type.
func PossibleVMGuestPatchClassificationLinuxValues() []VMGuestPatchClassificationLinux {
	return []VMGuestPatchClassificationLinux{VMGuestPatchClassificationLinuxCritical, VMGuestPatchClassificationLinuxOther, VMGuestPatchClassificationLinuxSecurity}
}

// VMGuestPatchClassificationWindows enumerates the values for vm guest patch classification windows.
type VMGuestPatchClassificationWindows string

const (
	// Critical ...
	Critical VMGuestPatchClassificationWindows = "Critical"
	// Definition ...
	Definition VMGuestPatchClassificationWindows = "Definition"
	// FeaturePack ...
	FeaturePack VMGuestPatchClassificationWindows = "FeaturePack"
	// Security ...
	Security VMGuestPatchClassificationWindows = "Security"
	// ServicePack ...
	ServicePack VMGuestPatchClassificationWindows = "ServicePack"
	// Tools ...
	Tools VMGuestPatchClassificationWindows = "Tools"
	// UpdateRollUp ...
	UpdateRollUp VMGuestPatchClassificationWindows = "UpdateRollUp"
	// Updates ...
	Updates VMGuestPatchClassificationWindows = "Updates"
)

// PossibleVMGuestPatchClassificationWindowsValues returns an array of possible values for the VMGuestPatchClassificationWindows const type.
func PossibleVMGuestPatchClassificationWindowsValues() []VMGuestPatchClassificationWindows {
	return []VMGuestPatchClassificationWindows{Critical, Definition, FeaturePack, Security, ServicePack, Tools, UpdateRollUp, Updates}
}

// VMGuestPatchRebootBehavior enumerates the values for vm guest patch reboot behavior.
type VMGuestPatchRebootBehavior string

const (
	// VMGuestPatchRebootBehaviorAlwaysRequiresReboot ...
	VMGuestPatchRebootBehaviorAlwaysRequiresReboot VMGuestPatchRebootBehavior = "AlwaysRequiresReboot"
	// VMGuestPatchRebootBehaviorCanRequestReboot ...
	VMGuestPatchRebootBehaviorCanRequestReboot VMGuestPatchRebootBehavior = "CanRequestReboot"
	// VMGuestPatchRebootBehaviorNeverReboots ...
	VMGuestPatchRebootBehaviorNeverReboots VMGuestPatchRebootBehavior = "NeverReboots"
	// VMGuestPatchRebootBehaviorUnknown ...
	VMGuestPatchRebootBehaviorUnknown VMGuestPatchRebootBehavior = "Unknown"
)

// PossibleVMGuestPatchRebootBehaviorValues returns an array of possible values for the VMGuestPatchRebootBehavior const type.
func PossibleVMGuestPatchRebootBehaviorValues() []VMGuestPatchRebootBehavior {
	return []VMGuestPatchRebootBehavior{VMGuestPatchRebootBehaviorAlwaysRequiresReboot, VMGuestPatchRebootBehaviorCanRequestReboot, VMGuestPatchRebootBehaviorNeverReboots, VMGuestPatchRebootBehaviorUnknown}
}

// VMGuestPatchRebootSetting enumerates the values for vm guest patch reboot setting.
type VMGuestPatchRebootSetting string

const (
	// Always ...
	Always VMGuestPatchRebootSetting = "Always"
	// IfRequired ...
	IfRequired VMGuestPatchRebootSetting = "IfRequired"
	// Never ...
	Never VMGuestPatchRebootSetting = "Never"
)

// PossibleVMGuestPatchRebootSettingValues returns an array of possible values for the VMGuestPatchRebootSetting const type.
func PossibleVMGuestPatchRebootSettingValues() []VMGuestPatchRebootSetting {
	return []VMGuestPatchRebootSetting{Always, IfRequired, Never}
}

// VMGuestPatchRebootStatus enumerates the values for vm guest patch reboot status.
type VMGuestPatchRebootStatus string

const (
	// VMGuestPatchRebootStatusCompleted ...
	VMGuestPatchRebootStatusCompleted VMGuestPatchRebootStatus = "Completed"
	// VMGuestPatchRebootStatusFailed ...
	VMGuestPatchRebootStatusFailed VMGuestPatchRebootStatus = "Failed"
	// VMGuestPatchRebootStatusNotNeeded ...
	VMGuestPatchRebootStatusNotNeeded VMGuestPatchRebootStatus = "NotNeeded"
	// VMGuestPatchRebootStatusRequired ...
	VMGuestPatchRebootStatusRequired VMGuestPatchRebootStatus = "Required"
	// VMGuestPatchRebootStatusStarted ...
	VMGuestPatchRebootStatusStarted VMGuestPatchRebootStatus = "Started"
	// VMGuestPatchRebootStatusUnknown ...
	VMGuestPatchRebootStatusUnknown VMGuestPatchRebootStatus = "Unknown"
)

// PossibleVMGuestPatchRebootStatusValues returns an array of possible values for the VMGuestPatchRebootStatus const type.
func PossibleVMGuestPatchRebootStatusValues() []VMGuestPatchRebootStatus {
	return []VMGuestPatchRebootStatus{VMGuestPatchRebootStatusCompleted, VMGuestPatchRebootStatusFailed, VMGuestPatchRebootStatusNotNeeded, VMGuestPatchRebootStatusRequired, VMGuestPatchRebootStatusStarted, VMGuestPatchRebootStatusUnknown}
}

// WindowsPatchAssessmentMode enumerates the values for windows patch assessment mode.
type WindowsPatchAssessmentMode string

const (
	// WindowsPatchAssessmentModeAutomaticByPlatform ...
	WindowsPatchAssessmentModeAutomaticByPlatform WindowsPatchAssessmentMode = "AutomaticByPlatform"
	// WindowsPatchAssessmentModeImageDefault ...
	WindowsPatchAssessmentModeImageDefault WindowsPatchAssessmentMode = "ImageDefault"
)

// PossibleWindowsPatchAssessmentModeValues returns an array of possible values for the WindowsPatchAssessmentMode const type.
func PossibleWindowsPatchAssessmentModeValues() []WindowsPatchAssessmentMode {
	return []WindowsPatchAssessmentMode{WindowsPatchAssessmentModeAutomaticByPlatform, WindowsPatchAssessmentModeImageDefault}
}

// WindowsVMGuestPatchAutomaticByPlatformRebootSetting enumerates the values for windows vm guest patch
// automatic by platform reboot setting.
type WindowsVMGuestPatchAutomaticByPlatformRebootSetting string

const (
	// WindowsVMGuestPatchAutomaticByPlatformRebootSettingAlways ...
	WindowsVMGuestPatchAutomaticByPlatformRebootSettingAlways WindowsVMGuestPatchAutomaticByPlatformRebootSetting = "Always"
	// WindowsVMGuestPatchAutomaticByPlatformRebootSettingIfRequired ...
	WindowsVMGuestPatchAutomaticByPlatformRebootSettingIfRequired WindowsVMGuestPatchAutomaticByPlatformRebootSetting = "IfRequired"
	// WindowsVMGuestPatchAutomaticByPlatformRebootSettingNever ...
	WindowsVMGuestPatchAutomaticByPlatformRebootSettingNever WindowsVMGuestPatchAutomaticByPlatformRebootSetting = "Never"
	// WindowsVMGuestPatchAutomaticByPlatformRebootSettingUnknown ...
	WindowsVMGuestPatchAutomaticByPlatformRebootSettingUnknown WindowsVMGuestPatchAutomaticByPlatformRebootSetting = "Unknown"
)

// PossibleWindowsVMGuestPatchAutomaticByPlatformRebootSettingValues returns an array of possible values for the WindowsVMGuestPatchAutomaticByPlatformRebootSetting const type.
func PossibleWindowsVMGuestPatchAutomaticByPlatformRebootSettingValues() []WindowsVMGuestPatchAutomaticByPlatformRebootSetting {
	return []WindowsVMGuestPatchAutomaticByPlatformRebootSetting{WindowsVMGuestPatchAutomaticByPlatformRebootSettingAlways, WindowsVMGuestPatchAutomaticByPlatformRebootSettingIfRequired, WindowsVMGuestPatchAutomaticByPlatformRebootSettingNever, WindowsVMGuestPatchAutomaticByPlatformRebootSettingUnknown}
}

// WindowsVMGuestPatchMode enumerates the values for windows vm guest patch mode.
type WindowsVMGuestPatchMode string

const (
	// WindowsVMGuestPatchModeAutomaticByOS ...
	WindowsVMGuestPatchModeAutomaticByOS WindowsVMGuestPatchMode = "AutomaticByOS"
	// WindowsVMGuestPatchModeAutomaticByPlatform ...
	WindowsVMGuestPatchModeAutomaticByPlatform WindowsVMGuestPatchMode = "AutomaticByPlatform"
	// WindowsVMGuestPatchModeManual ...
	WindowsVMGuestPatchModeManual WindowsVMGuestPatchMode = "Manual"
)

// PossibleWindowsVMGuestPatchModeValues returns an array of possible values for the WindowsVMGuestPatchMode const type.
func PossibleWindowsVMGuestPatchModeValues() []WindowsVMGuestPatchMode {
	return []WindowsVMGuestPatchMode{WindowsVMGuestPatchModeAutomaticByOS, WindowsVMGuestPatchModeAutomaticByPlatform, WindowsVMGuestPatchModeManual}
}
