package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchDeleteWhiteList invokes the aegis.BatchDeleteWhiteList API synchronously
// api document: https://help.aliyun.com/api/aegis/batchdeletewhitelist.html
func (client *Client) BatchDeleteWhiteList(request *BatchDeleteWhiteListRequest) (response *BatchDeleteWhiteListResponse, err error) {
	response = CreateBatchDeleteWhiteListResponse()
	err = client.DoAction(request, response)
	return
}

// BatchDeleteWhiteListWithChan invokes the aegis.BatchDeleteWhiteList API asynchronously
// api document: https://help.aliyun.com/api/aegis/batchdeletewhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchDeleteWhiteListWithChan(request *BatchDeleteWhiteListRequest) (<-chan *BatchDeleteWhiteListResponse, <-chan error) {
	responseChan := make(chan *BatchDeleteWhiteListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchDeleteWhiteList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchDeleteWhiteListWithCallback invokes the aegis.BatchDeleteWhiteList API asynchronously
// api document: https://help.aliyun.com/api/aegis/batchdeletewhitelist.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BatchDeleteWhiteListWithCallback(request *BatchDeleteWhiteListRequest, callback func(response *BatchDeleteWhiteListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchDeleteWhiteListResponse
		var err error
		defer close(result)
		response, err = client.BatchDeleteWhiteList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchDeleteWhiteListRequest is the request struct for api BatchDeleteWhiteList
type BatchDeleteWhiteListRequest struct {
	*requests.RpcRequest
	RiskIdList string `position:"Query" name:"RiskIdList"`
	SourceIp   string `position:"Query" name:"SourceIp"`
}

// BatchDeleteWhiteListResponse is the response struct for api BatchDeleteWhiteList
type BatchDeleteWhiteListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBatchDeleteWhiteListRequest creates a request to invoke BatchDeleteWhiteList API
func CreateBatchDeleteWhiteListRequest() (request *BatchDeleteWhiteListRequest) {
	request = &BatchDeleteWhiteListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "BatchDeleteWhiteList", "vipaegis", "openAPI")
	return
}

// CreateBatchDeleteWhiteListResponse creates a response to parse from BatchDeleteWhiteList response
func CreateBatchDeleteWhiteListResponse() (response *BatchDeleteWhiteListResponse) {
	response = &BatchDeleteWhiteListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
