package cas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSSLCertificatePublicKeyDetail invokes the cas.DescribeSSLCertificatePublicKeyDetail API synchronously
func (client *Client) DescribeSSLCertificatePublicKeyDetail(request *DescribeSSLCertificatePublicKeyDetailRequest) (response *DescribeSSLCertificatePublicKeyDetailResponse, err error) {
	response = CreateDescribeSSLCertificatePublicKeyDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSSLCertificatePublicKeyDetailWithChan invokes the cas.DescribeSSLCertificatePublicKeyDetail API asynchronously
func (client *Client) DescribeSSLCertificatePublicKeyDetailWithChan(request *DescribeSSLCertificatePublicKeyDetailRequest) (<-chan *DescribeSSLCertificatePublicKeyDetailResponse, <-chan error) {
	responseChan := make(chan *DescribeSSLCertificatePublicKeyDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSSLCertificatePublicKeyDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSSLCertificatePublicKeyDetailWithCallback invokes the cas.DescribeSSLCertificatePublicKeyDetail API asynchronously
func (client *Client) DescribeSSLCertificatePublicKeyDetailWithCallback(request *DescribeSSLCertificatePublicKeyDetailRequest, callback func(response *DescribeSSLCertificatePublicKeyDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSSLCertificatePublicKeyDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribeSSLCertificatePublicKeyDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSSLCertificatePublicKeyDetailRequest is the request struct for api DescribeSSLCertificatePublicKeyDetail
type DescribeSSLCertificatePublicKeyDetailRequest struct {
	*requests.RpcRequest
	SourceIp       string `position:"Query" name:"SourceIp"`
	CertIdentifier string `position:"Query" name:"CertIdentifier"`
}

// DescribeSSLCertificatePublicKeyDetailResponse is the response struct for api DescribeSSLCertificatePublicKeyDetail
type DescribeSSLCertificatePublicKeyDetailResponse struct {
	*responses.BaseResponse
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	X509Certificate string          `json:"X509Certificate" xml:"X509Certificate"`
	CertificateInfo CertificateInfo `json:"CertificateInfo" xml:"CertificateInfo"`
}

// CreateDescribeSSLCertificatePublicKeyDetailRequest creates a request to invoke DescribeSSLCertificatePublicKeyDetail API
func CreateDescribeSSLCertificatePublicKeyDetailRequest() (request *DescribeSSLCertificatePublicKeyDetailRequest) {
	request = &DescribeSSLCertificatePublicKeyDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cas", "2020-06-19", "DescribeSSLCertificatePublicKeyDetail", "cas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSSLCertificatePublicKeyDetailResponse creates a response to parse from DescribeSSLCertificatePublicKeyDetail response
func CreateDescribeSSLCertificatePublicKeyDetailResponse() (response *DescribeSSLCertificatePublicKeyDetailResponse) {
	response = &DescribeSSLCertificatePublicKeyDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
