package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddLiveAudioAuditNotifyConfig invokes the live.AddLiveAudioAuditNotifyConfig API synchronously
func (client *Client) AddLiveAudioAuditNotifyConfig(request *AddLiveAudioAuditNotifyConfigRequest) (response *AddLiveAudioAuditNotifyConfigResponse, err error) {
	response = CreateAddLiveAudioAuditNotifyConfigResponse()
	err = client.DoAction(request, response)
	return
}

// AddLiveAudioAuditNotifyConfigWithChan invokes the live.AddLiveAudioAuditNotifyConfig API asynchronously
func (client *Client) AddLiveAudioAuditNotifyConfigWithChan(request *AddLiveAudioAuditNotifyConfigRequest) (<-chan *AddLiveAudioAuditNotifyConfigResponse, <-chan error) {
	responseChan := make(chan *AddLiveAudioAuditNotifyConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddLiveAudioAuditNotifyConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddLiveAudioAuditNotifyConfigWithCallback invokes the live.AddLiveAudioAuditNotifyConfig API asynchronously
func (client *Client) AddLiveAudioAuditNotifyConfigWithCallback(request *AddLiveAudioAuditNotifyConfigRequest, callback func(response *AddLiveAudioAuditNotifyConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddLiveAudioAuditNotifyConfigResponse
		var err error
		defer close(result)
		response, err = client.AddLiveAudioAuditNotifyConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddLiveAudioAuditNotifyConfigRequest is the request struct for api AddLiveAudioAuditNotifyConfig
type AddLiveAudioAuditNotifyConfigRequest struct {
	*requests.RpcRequest
	DomainName       string           `position:"Query" name:"DomainName"`
	OwnerId          requests.Integer `position:"Query" name:"OwnerId"`
	CallbackTemplate string           `position:"Query" name:"CallbackTemplate"`
	Callback         string           `position:"Query" name:"Callback"`
}

// AddLiveAudioAuditNotifyConfigResponse is the response struct for api AddLiveAudioAuditNotifyConfig
type AddLiveAudioAuditNotifyConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddLiveAudioAuditNotifyConfigRequest creates a request to invoke AddLiveAudioAuditNotifyConfig API
func CreateAddLiveAudioAuditNotifyConfigRequest() (request *AddLiveAudioAuditNotifyConfigRequest) {
	request = &AddLiveAudioAuditNotifyConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "AddLiveAudioAuditNotifyConfig", "live", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddLiveAudioAuditNotifyConfigResponse creates a response to parse from AddLiveAudioAuditNotifyConfig response
func CreateAddLiveAudioAuditNotifyConfigResponse() (response *AddLiveAudioAuditNotifyConfigResponse) {
	response = &AddLiveAudioAuditNotifyConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
