package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryJobsWithResult invokes the outboundbot.QueryJobsWithResult API synchronously
func (client *Client) QueryJobsWithResult(request *QueryJobsWithResultRequest) (response *QueryJobsWithResultResponse, err error) {
	response = CreateQueryJobsWithResultResponse()
	err = client.DoAction(request, response)
	return
}

// QueryJobsWithResultWithChan invokes the outboundbot.QueryJobsWithResult API asynchronously
func (client *Client) QueryJobsWithResultWithChan(request *QueryJobsWithResultRequest) (<-chan *QueryJobsWithResultResponse, <-chan error) {
	responseChan := make(chan *QueryJobsWithResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryJobsWithResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryJobsWithResultWithCallback invokes the outboundbot.QueryJobsWithResult API asynchronously
func (client *Client) QueryJobsWithResultWithCallback(request *QueryJobsWithResultRequest, callback func(response *QueryJobsWithResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryJobsWithResultResponse
		var err error
		defer close(result)
		response, err = client.QueryJobsWithResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryJobsWithResultRequest is the request struct for api QueryJobsWithResult
type QueryJobsWithResultRequest struct {
	*requests.RpcRequest
	HasReachedEndOfFlowFilter  requests.Boolean `position:"Query" name:"HasReachedEndOfFlowFilter"`
	HasAnsweredFilter          requests.Boolean `position:"Query" name:"HasAnsweredFilter"`
	PageNumber                 requests.Integer `position:"Query" name:"PageNumber"`
	QueryText                  string           `position:"Query" name:"QueryText"`
	HasHangUpByRejectionFilter requests.Boolean `position:"Query" name:"HasHangUpByRejectionFilter"`
	InstanceId                 string           `position:"Query" name:"InstanceId"`
	JobStatusFilter            string           `position:"Query" name:"JobStatusFilter"`
	PageSize                   requests.Integer `position:"Query" name:"PageSize"`
	JobGroupId                 string           `position:"Query" name:"JobGroupId"`
}

// QueryJobsWithResultResponse is the response struct for api QueryJobsWithResult
type QueryJobsWithResultResponse struct {
	*responses.BaseResponse
	HttpStatusCode int      `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string   `json:"Code" xml:"Code"`
	Message        string   `json:"Message" xml:"Message"`
	RequestId      string   `json:"RequestId" xml:"RequestId"`
	Success        bool     `json:"Success" xml:"Success"`
	VariableNames  []string `json:"VariableNames" xml:"VariableNames"`
	Jobs           Jobs     `json:"Jobs" xml:"Jobs"`
}

// CreateQueryJobsWithResultRequest creates a request to invoke QueryJobsWithResult API
func CreateQueryJobsWithResultRequest() (request *QueryJobsWithResultRequest) {
	request = &QueryJobsWithResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "QueryJobsWithResult", "outboundbot", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryJobsWithResultResponse creates a response to parse from QueryJobsWithResult response
func CreateQueryJobsWithResultResponse() (response *QueryJobsWithResultResponse) {
	response = &QueryJobsWithResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
