package sgw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGatewayStatistics invokes the sgw.DescribeGatewayStatistics API synchronously
func (client *Client) DescribeGatewayStatistics(request *DescribeGatewayStatisticsRequest) (response *DescribeGatewayStatisticsResponse, err error) {
	response = CreateDescribeGatewayStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGatewayStatisticsWithChan invokes the sgw.DescribeGatewayStatistics API asynchronously
func (client *Client) DescribeGatewayStatisticsWithChan(request *DescribeGatewayStatisticsRequest) (<-chan *DescribeGatewayStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeGatewayStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGatewayStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGatewayStatisticsWithCallback invokes the sgw.DescribeGatewayStatistics API asynchronously
func (client *Client) DescribeGatewayStatisticsWithCallback(request *DescribeGatewayStatisticsRequest, callback func(response *DescribeGatewayStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGatewayStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeGatewayStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGatewayStatisticsRequest is the request struct for api DescribeGatewayStatistics
type DescribeGatewayStatisticsRequest struct {
	*requests.RpcRequest
	GatewayCategory string           `position:"Query" name:"GatewayCategory"`
	GatewayLocation string           `position:"Query" name:"GatewayLocation"`
	StartTimestamp  requests.Integer `position:"Query" name:"StartTimestamp"`
	EndTimestamp    requests.Integer `position:"Query" name:"EndTimestamp"`
	TargetAccountId string           `position:"Query" name:"TargetAccountId"`
	SecurityToken   string           `position:"Query" name:"SecurityToken"`
}

// DescribeGatewayStatisticsResponse is the response struct for api DescribeGatewayStatistics
type DescribeGatewayStatisticsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateDescribeGatewayStatisticsRequest creates a request to invoke DescribeGatewayStatistics API
func CreateDescribeGatewayStatisticsRequest() (request *DescribeGatewayStatisticsRequest) {
	request = &DescribeGatewayStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sgw", "2018-05-11", "DescribeGatewayStatistics", "hcs_sgw", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGatewayStatisticsResponse creates a response to parse from DescribeGatewayStatistics response
func CreateDescribeGatewayStatisticsResponse() (response *DescribeGatewayStatisticsResponse) {
	response = &DescribeGatewayStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
