# Mysql


## Fields

| Field                                                                                                                                                                                           | Type                                                                                                                                                                                            | Required                                                                                                                                                                                        | Description                                                                                                                                                                                     |
| ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `AuthPluginData`                                                                                                                                                                                | **string*                                                                                                                                                                                       | :heavy_minus_sign:                                                                                                                                                                              | Optional plugin-specific data, whose meaning depends on the value of auth_plugin_name. Returned in the initial HandshakePacket.                                                                 |
| `AuthPluginName`                                                                                                                                                                                | **string*                                                                                                                                                                                       | :heavy_minus_sign:                                                                                                                                                                              | The name of the authentication plugin, returned in the initial HandshakePacket.                                                                                                                 |
| `CapabilityFlags`                                                                                                                                                                               | map[string]*bool*                                                                                                                                                                               | :heavy_minus_sign:                                                                                                                                                                              | The set of capability flags the server returned in the initial HandshakePacket. Each entry corresponds to a bit being set in the flags; key names correspond to the #defines in the MySQL docs. |
| `CharacterSet`                                                                                                                                                                                  | **int*                                                                                                                                                                                          | :heavy_minus_sign:                                                                                                                                                                              | The identifier for the character set the server is using. Returned in the initial HandshakePacket.                                                                                              |
| `ConnectionID`                                                                                                                                                                                  | **int*                                                                                                                                                                                          | :heavy_minus_sign:                                                                                                                                                                              | The server's internal identifier for this client's connection, sent in the initial HandshakePacket.                                                                                             |
| `ErrorCode`                                                                                                                                                                                     | **int64*                                                                                                                                                                                        | :heavy_minus_sign:                                                                                                                                                                              | Only set if there is an error returned by the server, for example if the scanner is not on the allowed hosts list.                                                                              |
| `ErrorID`                                                                                                                                                                                       | **string*                                                                                                                                                                                       | :heavy_minus_sign:                                                                                                                                                                              | The friendly name for the error code as defined at https://dev.mysql.com/doc/refman/8.0/en/error-messages-server.html, or UNKNOWN                                                               |
| `ErrorMessage`                                                                                                                                                                                  | **string*                                                                                                                                                                                       | :heavy_minus_sign:                                                                                                                                                                              | Optional string describing the error. Only set if there is an error.                                                                                                                            |
| `ProtocolVersion`                                                                                                                                                                               | **int*                                                                                                                                                                                          | :heavy_minus_sign:                                                                                                                                                                              | 8-bit unsigned integer representing the server's protocol version sent in the initial HandshakePacket from the server.                                                                          |
| `ServerVersion`                                                                                                                                                                                 | **string*                                                                                                                                                                                       | :heavy_minus_sign:                                                                                                                                                                              | The specific server version returned in the initial HandshakePacket. Often in the form x.y.z, but not always.                                                                                   |
| `StatusFlags`                                                                                                                                                                                   | map[string]*bool*                                                                                                                                                                               | :heavy_minus_sign:                                                                                                                                                                              | The set of status flags the server returned in the initial HandshakePacket. Each entry corresponds to a bit being set in the flags; key names correspond to the #defines in the MySQL docs.     |