// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

type Version string

const (
	VersionUnknown Version = ""
	VersionSsLv2   Version = "ss_lv_2"
	VersionSsLv3   Version = "ss_lv_3"
	VersionTlsv10  Version = "tlsv1_0"
	VersionTlsv11  Version = "tlsv1_1"
	VersionTlsv12  Version = "tlsv1_2"
	VersionTlsv13  Version = "tlsv1_3"
	VersionDtlsv10 Version = "dtlsv1_0"
	VersionDtlsv12 Version = "dtlsv1_2"
	VersionDtlsv13 Version = "dtlsv1_3"
)

func (e Version) ToPointer() *Version {
	return &e
}
func (e *Version) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "ss_lv_2":
		fallthrough
	case "ss_lv_3":
		fallthrough
	case "tlsv1_0":
		fallthrough
	case "tlsv1_1":
		fallthrough
	case "tlsv1_2":
		fallthrough
	case "tlsv1_3":
		fallthrough
	case "dtlsv1_0":
		fallthrough
	case "dtlsv1_2":
		fallthrough
	case "dtlsv1_3":
		*e = Version(v)
		return nil
	default:
		return fmt.Errorf("invalid value for Version: %v", v)
	}
}

type TLSVersionData struct {
	Ja3s    *string  `json:"ja3s,omitempty"`
	Ja4s    *string  `json:"ja4s,omitempty"`
	Version *Version `json:"version,omitempty"`
}

func (o *TLSVersionData) GetJa3s() *string {
	if o == nil {
		return nil
	}
	return o.Ja3s
}

func (o *TLSVersionData) GetJa4s() *string {
	if o == nil {
		return nil
	}
	return o.Ja4s
}

func (o *TLSVersionData) GetVersion() *Version {
	if o == nil {
		return nil
	}
	return o.Version
}
