//go:build none
// +build none

package main

import (
	"bytes"
	"compress/zlib"
	"encoding/binary"
	"fmt"
	"go/format"
	"io/ioutil"
	"strconv"
	"strings"
)

func main() {
	data, err := ioutil.ReadFile("table.txt")
	if err != nil {
		panic(err)
	}
	var buf bytes.Buffer
	previousVal := int64(-1)
	for _, line := range strings.Split(string(data), "\n") {
		if strings.HasPrefix(line, "/*") || line == "" {
			continue
		}
		sep := strings.IndexByte(line, ':')
		if sep == -1 {
			panic(line)
		}
		val, err := strconv.ParseInt(line[:sep], 0, 32)
		if err != nil {
			panic(err)
		}

		if previousVal+1 != val {
			rangechars := 0
			for i := previousVal + 1; i <= val-1; i++ {
				if err := binary.Write(&buf, binary.LittleEndian, uint8(0xff)); err != nil {
					panic(err)
				}
				rangechars++
			}
			fmt.Printf("Filled dummy range: 0x%04x - 0x%04x (%4d chars)\n", previousVal+1, val-1, rangechars)
		}

		s, err := strconv.Unquote(line[sep+2:])
		if err != nil {
			panic(err)
		}
		if err := binary.Write(&buf, binary.LittleEndian, uint8(len(s))); err != nil {
			panic(err)
		}
		previousVal = val
		buf.WriteString(s)
	}
	var cbuf bytes.Buffer
	w, err := zlib.NewWriterLevel(&cbuf, zlib.BestCompression)
	if err != nil {
		panic(err)
	}
	if _, err := w.Write(buf.Bytes()); err != nil {
		panic(err)
	}
	if err := w.Close(); err != nil {
		panic(err)
	}
	buf.Reset()
	buf.WriteString("package unidecode\n")
	buf.WriteString("// AUTOGENERATED - DO NOT EDIT!\n\n")
	fmt.Fprintf(&buf, "const tableData = %q;\n", cbuf.String())
	dst, err := format.Source(buf.Bytes())
	if err != nil {
		panic(err)
	}
	if err := ioutil.WriteFile("table.go", dst, 0644); err != nil {
		panic(err)
	}
}
