// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.cloud.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// HostScanAgentSettings Agent scan settings for a host scan
type HostScanAgentSettings struct {

	// The scan level
	ScanLevel HostAgentScanLevelEnum `mandatory:"true" json:"scanLevel"`

	AgentConfiguration HostScanAgentConfiguration `mandatory:"false" json:"agentConfiguration"`
}

func (m HostScanAgentSettings) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m HostScanAgentSettings) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingHostAgentScanLevelEnum(string(m.ScanLevel)); !ok && m.ScanLevel != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for ScanLevel: %s. Supported values are: %s.", m.ScanLevel, strings.Join(GetHostAgentScanLevelEnumStringValues(), ",")))
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// UnmarshalJSON unmarshals from json
func (m *HostScanAgentSettings) UnmarshalJSON(data []byte) (e error) {
	model := struct {
		AgentConfiguration hostscanagentconfiguration `json:"agentConfiguration"`
		ScanLevel          HostAgentScanLevelEnum     `json:"scanLevel"`
	}{}

	e = json.Unmarshal(data, &model)
	if e != nil {
		return
	}
	var nn interface{}
	nn, e = model.AgentConfiguration.UnmarshalPolymorphicJSON(model.AgentConfiguration.JsonData)
	if e != nil {
		return
	}
	if nn != nil {
		m.AgentConfiguration = nn.(HostScanAgentConfiguration)
	} else {
		m.AgentConfiguration = nil
	}

	m.ScanLevel = model.ScanLevel

	return
}
