#!/bin/sh
# check_license_headers.sh checks that all Go files have a
# correct-looking license header.

check_file() {
    got=$1

    for year in `seq 2019 2025`; do
        want=$(cat <<EOF
// Copyright (c) $year The Inet.Af AUTHORS. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.
EOF
        )
        if [ "$got" = "$want" ]; then
            return 0
        fi
    done
    return 1
}

if [ $# != 1 ]; then
    echo "Usage: $0 rootdir" >&2
    exit 1
fi

fail=0
for file in $(find . -name '*.go' -not -path '*/.git/*'); do
    case $file in
        */z*.go)
            # No copyright header in autogenerated files.
            ;;
        *)
            header="$(head -3 $file)"
            if ! check_file "$header"; then
                fail=1
                echo "${file#*/} doesn't have the right copyright header:"
                echo "$header" | sed -e 's/^/    /g'
            fi
            ;;
    esac
done

if [ $fail -ne 0 ]; then
    exit 1
fi
