// Package bindata Code generated by go-bindata. (@generated) DO NOT EDIT.
// sources:
// templates/default.bra.toml
package bindata

import (
	"bytes"
	"compress/gzip"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

// Name return file name
func (fi bindataFileInfo) Name() string {
	return fi.name
}

// Size return file size
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}

// Mode return file mode
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}

// ModTime return file modify time
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}

// IsDir return file whether a directory
func (fi bindataFileInfo) IsDir() bool {
	return fi.mode&os.ModeDir != 0
}

// Sys return file is sys mode
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _templatesDefaultBraToml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xa4\x93\xc1\x6e\xdb\x30\x0c\x86\xef\x7e\x0a\xc2\xd9\xb1\x6b\xb3\x43\x2e\x03\x72\x28\xb6\xde\xd6\xa1\x18\x0a\xec\x10\x18\x86\x62\xd1\x1e\x51\x8a\x0c\x24\x2a\x4d\xde\x7e\x90\x9c\x6d\x41\x96\xf5\x32\x5f\x0c\xd3\xfa\x7e\xfe\x24\xc5\x4d\xcc\xd2\x35\x24\x64\xfd\x10\x7c\x82\x35\x6c\xe0\xea\xb3\x80\x4f\x1a\x82\x13\x9f\x20\x66\x01\x12\x48\xe6\xa2\x35\x00\x9b\x76\xd2\xf6\x06\x5a\x92\x64\x8e\xb9\xed\x6e\xce\x82\xdb\x4c\xec\x7f\x85\x6e\xef\xde\xdd\x3f\x3d\xf5\x5f\xef\x1f\x1f\xda\xae\xe9\x9a\x57\x67\xc3\x8f\xde\x31\xc3\x1a\x2c\x66\xbc\x9a\xf6\x7b\x39\x04\xe5\x50\xca\xdb\xf7\x9e\x22\x0e\xa6\x91\x30\x9d\x70\x4f\xb1\xda\xee\xae\xbb\xfe\xfc\x07\x00\x53\xa8\xcc\x89\xc4\x83\x55\xb2\xbd\x9d\xb4\xbd\xc4\x17\xf0\x70\x30\x94\x44\x2a\x67\x20\xca\xbe\x1f\x89\xf1\xdf\x19\x61\x01\x5f\xd4\x79\x40\xd9\xc3\xde\xc5\x04\x63\xd4\x00\x95\x69\x68\x12\x8d\x78\x4a\x49\x56\xfa\x23\xea\xb1\x0f\xea\x33\x63\x2a\x1e\xfe\x32\x8c\x87\x81\xb3\xc7\x59\xa6\x9a\x20\x99\x4e\x4a\x6f\x5a\x59\xc0\x37\x9c\xf0\xb0\x4b\x30\x6a\x84\x0a\x90\x4c\x90\x76\x38\xd0\x48\x03\x88\x1a\x8d\xa5\x8d\xa3\x32\xeb\x6b\x9f\x8e\x81\x49\x5e\x8a\xdc\xe8\x38\xe1\x45\x33\xc4\x6d\x19\xef\x3c\xa5\xf2\x86\x99\xa9\x7a\xc7\xb0\x55\xa6\x01\x66\x58\xc7\x32\x26\x38\x1f\x53\xbd\x02\xbd\x47\x76\x47\x58\xc3\x87\xd5\x72\x79\xc5\xeb\x23\x09\x05\xc7\x40\x62\x18\xf7\x8e\x4b\xe9\xcf\x91\xa6\x09\x23\x54\x01\xc0\x3d\x8a\x35\xf5\x7f\xcc\x3b\xeb\x8d\x82\x66\xab\x8a\x97\x62\xcf\x14\x70\x9e\x19\x19\x64\x31\xe2\xd2\x83\x01\xe1\x85\x98\x9b\x29\xba\x01\xc7\xcc\x7d\xf9\xba\x56\xed\x7c\xeb\xc8\x6a\xe3\xf0\x40\x06\x4e\x3c\x6c\x71\x2c\xc3\x9b\x2b\xe3\xe3\xac\xf5\xf6\xce\x9c\xb4\x7e\x2f\x8e\x69\xd9\x9d\xff\x5a\x99\x66\x93\x8e\x32\x74\x0d\x53\x32\x94\xde\x79\x1f\x61\x0d\xed\xc7\xd5\x72\xb5\x6c\x9b\x88\x41\x0d\x2f\xa3\x3f\x03\x00\x00\xff\xff\x3f\xd4\x53\x40\xe4\x03\x00\x00")

func templatesDefaultBraTomlBytes() ([]byte, error) {
	return bindataRead(
		_templatesDefaultBraToml,
		"templates/default.bra.toml",
	)
}

func templatesDefaultBraToml() (*asset, error) {
	bytes, err := templatesDefaultBraTomlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "templates/default.bra.toml", size: 996, mode: os.FileMode(420), modTime: time.Unix(1571606074, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"templates/default.bra.toml": templatesDefaultBraToml,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"templates": &bintree{nil, map[string]*bintree{
		"default.bra.toml": &bintree{templatesDefaultBraToml, map[string]*bintree{}},
	}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}
