/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.properties.annotations;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.DocLink;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.properties.annotations.TypeAnnotationHandler;
import org.gradle.internal.reflect.validation.TypeAwareProblemBuilder;
import org.gradle.internal.reflect.validation.TypeValidationContext;

public abstract class AbstractTypeAnnotationHandler
implements TypeAnnotationHandler {
    private final Class<? extends Annotation> annotationType;

    protected AbstractTypeAnnotationHandler(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
    }

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    protected static void reportInvalidUseOfTypeAnnotation(Class<?> classWithAnnotationAttached, TypeValidationContext visitor, Class<? extends Annotation> annotationType, Class<?> ... appliesOnlyTo) {
        visitor.visitTypeProblem((Action<? super TypeAwareProblemBuilder>)((Action)problem -> problem.withAnnotationType(classWithAnnotationAttached).id("invalid-use-of-type-annotation", "Incorrect use of type annotation", GradleCoreProblemGroup.validation().type()).contextualLabel("is incorrectly annotated with @" + annotationType.getSimpleName()).documentedAt((DocLink)Documentation.userManual((String)"validation_problems", (String)"invalid_use_of_cacheable_annotation")).severity(Severity.ERROR).details(String.format("This annotation only makes sense on %s types", Arrays.stream(appliesOnlyTo).map(Class::getSimpleName).collect(Collectors.joining(", ")))).solution("Remove the annotation")));
    }
}

