/*--------------------------------------------------------------------
This source distribution is placed in the public domain by its author,
Jason Papadopoulos. You may use it for any purpose, free of charge,
without having to notify anyone. I disclaim any responsibility for any
errors, inconsistencies, and inaccuracies with real-world hardware
implementations of the IA64 instruction set. If you build a mission-
critical system based only on this simulator and something goes wrong,
it's your own damned fault.

Optionally, please be nice and tell me if you find this source to be
useful. Again optionally, if you add to the functionality present here
please consider making those additions public too, so that others may 
benefit from your work.	
       				   --jasonp@glue.umd.edu  12/5/99
--------------------------------------------------------------------*/
#include "ia64.h"
#include "ia64asm.h"
#include "asmfunc.h"

lookup jumptable[] = {

{"add \\r=\\i22,\\r",       add_r_i22_r},
{"add \\r=\\r,\\r",       add_r_r_r},
{"add \\r=\\r,\\r,1",       add_r_r_r_1},
{"addl \\r=\\i22,\\r2",       addl_r_i22_r2},
{"addp4 \\r=\\i14,\\r",       addp4_r_i14_r},
{"addp4 \\r=\\r,\\r",       addp4_r_r_r},
{"adds \\r=\\i14,\\r",       adds_r_i14_r},
{"alloc \\r=ar.pfs,\\u7,\\u7,\\u7,\\u7",       alloc_r_ar_pfs_u7_u7_u7_u7},
{"and \\r=\\i8,\\r",       and_r_i8_r},
{"and \\r=\\r,\\r",       and_r_r_r},
{"andcm \\r=\\i8,\\r",       andcm_r_i8_r},
{"andcm \\r=\\r,\\r",       andcm_r_r_r},
{"br \\b",       br_b},
{"br \\i25",       br_i25},
{"br.call.dpnt \\b=\\b",       br_call_dpnt_b_b},
{"br.call.dpnt \\b=\\i25",       br_call_dpnt_b_i25},
{"br.call.dpnt.clr \\b=\\b",       br_call_dpnt_clr_b_b},
{"br.call.dpnt.clr \\b=\\i25",       br_call_dpnt_clr_b_i25},
{"br.call.dpnt.few \\b=\\b",       br_call_dpnt_few_b_b},
{"br.call.dpnt.few \\b=\\i25",       br_call_dpnt_few_b_i25},
{"br.call.dpnt.few.clr \\b=\\b",       br_call_dpnt_few_clr_b_b},
{"br.call.dpnt.few.clr \\b=\\i25",       br_call_dpnt_few_clr_b_i25},
{"br.call.dpnt.many \\b=\\b",       br_call_dpnt_many_b_b},
{"br.call.dpnt.many \\b=\\i25",       br_call_dpnt_many_b_i25},
{"br.call.dpnt.many.clr \\b=\\b",       br_call_dpnt_many_clr_b_b},
{"br.call.dpnt.many.clr \\b=\\i25",       br_call_dpnt_many_clr_b_i25},
{"br.call.dptk \\b=\\b",       br_call_dptk_b_b},
{"br.call.dptk \\b=\\i25",       br_call_dptk_b_i25},
{"br.call.dptk.clr \\b=\\b",       br_call_dptk_clr_b_b},
{"br.call.dptk.clr \\b=\\i25",       br_call_dptk_clr_b_i25},
{"br.call.dptk.few \\b=\\b",       br_call_dptk_few_b_b},
{"br.call.dptk.few \\b=\\i25",       br_call_dptk_few_b_i25},
{"br.call.dptk.few.clr \\b=\\b",       br_call_dptk_few_clr_b_b},
{"br.call.dptk.few.clr \\b=\\i25",       br_call_dptk_few_clr_b_i25},
{"br.call.dptk.many \\b=\\b",       br_call_dptk_many_b_b},
{"br.call.dptk.many \\b=\\i25",       br_call_dptk_many_b_i25},
{"br.call.dptk.many.clr \\b=\\b",       br_call_dptk_many_clr_b_b},
{"br.call.dptk.many.clr \\b=\\i25",       br_call_dptk_many_clr_b_i25},
{"br.call.spnt \\b=\\b",       br_call_spnt_b_b},
{"br.call.spnt \\b=\\i25",       br_call_spnt_b_i25},
{"br.call.spnt.clr \\b=\\b",       br_call_spnt_clr_b_b},
{"br.call.spnt.clr \\b=\\i25",       br_call_spnt_clr_b_i25},
{"br.call.spnt.few \\b=\\b",       br_call_spnt_few_b_b},
{"br.call.spnt.few \\b=\\i25",       br_call_spnt_few_b_i25},
{"br.call.spnt.few.clr \\b=\\b",       br_call_spnt_few_clr_b_b},
{"br.call.spnt.few.clr \\b=\\i25",       br_call_spnt_few_clr_b_i25},
{"br.call.spnt.many \\b=\\b",       br_call_spnt_many_b_b},
{"br.call.spnt.many \\b=\\i25",       br_call_spnt_many_b_i25},
{"br.call.spnt.many.clr \\b=\\b",       br_call_spnt_many_clr_b_b},
{"br.call.spnt.many.clr \\b=\\i25",       br_call_spnt_many_clr_b_i25},
{"br.call.sptk \\b=\\b",       br_call_sptk_b_b},
{"br.call.sptk \\b=\\i25",       br_call_sptk_b_i25},
{"br.call.sptk.clr \\b=\\b",       br_call_sptk_clr_b_b},
{"br.call.sptk.clr \\b=\\i25",       br_call_sptk_clr_b_i25},
{"br.call.sptk.few \\b=\\b",       br_call_sptk_few_b_b},
{"br.call.sptk.few \\b=\\i25",       br_call_sptk_few_b_i25},
{"br.call.sptk.few.clr \\b=\\b",       br_call_sptk_few_clr_b_b},
{"br.call.sptk.few.clr \\b=\\i25",       br_call_sptk_few_clr_b_i25},
{"br.call.sptk.many \\b=\\b",       br_call_sptk_many_b_b},
{"br.call.sptk.many \\b=\\i25",       br_call_sptk_many_b_i25},
{"br.call.sptk.many.clr \\b=\\b",       br_call_sptk_many_clr_b_b},
{"br.call.sptk.many.clr \\b=\\i25",       br_call_sptk_many_clr_b_i25},
{"br.cexit.dpnt \\i25",       br_cexit_dpnt_i25},
{"br.cexit.dpnt.clr \\i25",       br_cexit_dpnt_clr_i25},
{"br.cexit.dpnt.few \\i25",       br_cexit_dpnt_few_i25},
{"br.cexit.dpnt.few.clr \\i25",       br_cexit_dpnt_few_clr_i25},
{"br.cexit.dpnt.many \\i25",       br_cexit_dpnt_many_i25},
{"br.cexit.dpnt.many.clr \\i25",       br_cexit_dpnt_many_clr_i25},
{"br.cexit.dptk \\i25",       br_cexit_dptk_i25},
{"br.cexit.dptk.clr \\i25",       br_cexit_dptk_clr_i25},
{"br.cexit.dptk.few \\i25",       br_cexit_dptk_few_i25},
{"br.cexit.dptk.few.clr \\i25",       br_cexit_dptk_few_clr_i25},
{"br.cexit.dptk.many \\i25",       br_cexit_dptk_many_i25},
{"br.cexit.dptk.many.clr \\i25",       br_cexit_dptk_many_clr_i25},
{"br.cexit.spnt \\i25",       br_cexit_spnt_i25},
{"br.cexit.spnt.clr \\i25",       br_cexit_spnt_clr_i25},
{"br.cexit.spnt.few \\i25",       br_cexit_spnt_few_i25},
{"br.cexit.spnt.few.clr \\i25",       br_cexit_spnt_few_clr_i25},
{"br.cexit.spnt.many \\i25",       br_cexit_spnt_many_i25},
{"br.cexit.spnt.many.clr \\i25",       br_cexit_spnt_many_clr_i25},
{"br.cexit.sptk \\i25",       br_cexit_sptk_i25},
{"br.cexit.sptk.clr \\i25",       br_cexit_sptk_clr_i25},
{"br.cexit.sptk.few \\i25",       br_cexit_sptk_few_i25},
{"br.cexit.sptk.few.clr \\i25",       br_cexit_sptk_few_clr_i25},
{"br.cexit.sptk.many \\i25",       br_cexit_sptk_many_i25},
{"br.cexit.sptk.many.clr \\i25",       br_cexit_sptk_many_clr_i25},
{"br.cloop.dpnt \\i25",       br_cloop_dpnt_i25},
{"br.cloop.dpnt.clr \\i25",       br_cloop_dpnt_clr_i25},
{"br.cloop.dpnt.few \\i25",       br_cloop_dpnt_few_i25},
{"br.cloop.dpnt.few.clr \\i25",       br_cloop_dpnt_few_clr_i25},
{"br.cloop.dpnt.many \\i25",       br_cloop_dpnt_many_i25},
{"br.cloop.dpnt.many.clr \\i25",       br_cloop_dpnt_many_clr_i25},
{"br.cloop.dptk \\i25",       br_cloop_dptk_i25},
{"br.cloop.dptk.clr \\i25",       br_cloop_dptk_clr_i25},
{"br.cloop.dptk.few \\i25",       br_cloop_dptk_few_i25},
{"br.cloop.dptk.few.clr \\i25",       br_cloop_dptk_few_clr_i25},
{"br.cloop.dptk.many \\i25",       br_cloop_dptk_many_i25},
{"br.cloop.dptk.many.clr \\i25",       br_cloop_dptk_many_clr_i25},
{"br.cloop.spnt \\i25",       br_cloop_spnt_i25},
{"br.cloop.spnt.clr \\i25",       br_cloop_spnt_clr_i25},
{"br.cloop.spnt.few \\i25",       br_cloop_spnt_few_i25},
{"br.cloop.spnt.few.clr \\i25",       br_cloop_spnt_few_clr_i25},
{"br.cloop.spnt.many \\i25",       br_cloop_spnt_many_i25},
{"br.cloop.spnt.many.clr \\i25",       br_cloop_spnt_many_clr_i25},
{"br.cloop.sptk \\i25",       br_cloop_sptk_i25},
{"br.cloop.sptk.clr \\i25",       br_cloop_sptk_clr_i25},
{"br.cloop.sptk.few \\i25",       br_cloop_sptk_few_i25},
{"br.cloop.sptk.few.clr \\i25",       br_cloop_sptk_few_clr_i25},
{"br.cloop.sptk.many \\i25",       br_cloop_sptk_many_i25},
{"br.cloop.sptk.many.clr \\i25",       br_cloop_sptk_many_clr_i25},
{"br.clr \\b",       br_clr_b},
{"br.clr \\i25",       br_clr_i25},
{"br.cond.dpnt \\b",       br_cond_dpnt_b},
{"br.cond.dpnt \\i25",       br_cond_dpnt_i25},
{"br.cond.dpnt.clr \\b",       br_cond_dpnt_clr_b},
{"br.cond.dpnt.clr \\i25",       br_cond_dpnt_clr_i25},
{"br.cond.dpnt.few \\b",       br_cond_dpnt_few_b},
{"br.cond.dpnt.few \\i25",       br_cond_dpnt_few_i25},
{"br.cond.dpnt.few.clr \\b",       br_cond_dpnt_few_clr_b},
{"br.cond.dpnt.few.clr \\i25",       br_cond_dpnt_few_clr_i25},
{"br.cond.dpnt.many \\b",       br_cond_dpnt_many_b},
{"br.cond.dpnt.many \\i25",       br_cond_dpnt_many_i25},
{"br.cond.dpnt.many.clr \\b",       br_cond_dpnt_many_clr_b},
{"br.cond.dpnt.many.clr \\i25",       br_cond_dpnt_many_clr_i25},
{"br.cond.dptk \\b",       br_cond_dptk_b},
{"br.cond.dptk \\i25",       br_cond_dptk_i25},
{"br.cond.dptk.clr \\b",       br_cond_dptk_clr_b},
{"br.cond.dptk.clr \\i25",       br_cond_dptk_clr_i25},
{"br.cond.dptk.few \\b",       br_cond_dptk_few_b},
{"br.cond.dptk.few \\i25",       br_cond_dptk_few_i25},
{"br.cond.dptk.few.clr \\b",       br_cond_dptk_few_clr_b},
{"br.cond.dptk.few.clr \\i25",       br_cond_dptk_few_clr_i25},
{"br.cond.dptk.many \\b",       br_cond_dptk_many_b},
{"br.cond.dptk.many \\i25",       br_cond_dptk_many_i25},
{"br.cond.dptk.many.clr \\b",       br_cond_dptk_many_clr_b},
{"br.cond.dptk.many.clr \\i25",       br_cond_dptk_many_clr_i25},
{"br.cond.spnt \\b",       br_cond_spnt_b},
{"br.cond.spnt \\i25",       br_cond_spnt_i25},
{"br.cond.spnt.clr \\b",       br_cond_spnt_clr_b},
{"br.cond.spnt.clr \\i25",       br_cond_spnt_clr_i25},
{"br.cond.spnt.few \\b",       br_cond_spnt_few_b},
{"br.cond.spnt.few \\i25",       br_cond_spnt_few_i25},
{"br.cond.spnt.few.clr \\b",       br_cond_spnt_few_clr_b},
{"br.cond.spnt.few.clr \\i25",       br_cond_spnt_few_clr_i25},
{"br.cond.spnt.many \\b",       br_cond_spnt_many_b},
{"br.cond.spnt.many \\i25",       br_cond_spnt_many_i25},
{"br.cond.spnt.many.clr \\b",       br_cond_spnt_many_clr_b},
{"br.cond.spnt.many.clr \\i25",       br_cond_spnt_many_clr_i25},
{"br.cond.sptk \\b",       br_cond_sptk_b},
{"br.cond.sptk \\i25",       br_cond_sptk_i25},
{"br.cond.sptk.clr \\b",       br_cond_sptk_clr_b},
{"br.cond.sptk.clr \\i25",       br_cond_sptk_clr_i25},
{"br.cond.sptk.few \\b",       br_cond_sptk_few_b},
{"br.cond.sptk.few \\i25",       br_cond_sptk_few_i25},
{"br.cond.sptk.few.clr \\b",       br_cond_sptk_few_clr_b},
{"br.cond.sptk.few.clr \\i25",       br_cond_sptk_few_clr_i25},
{"br.cond.sptk.many \\b",       br_cond_sptk_many_b},
{"br.cond.sptk.many \\i25",       br_cond_sptk_many_i25},
{"br.cond.sptk.many.clr \\b",       br_cond_sptk_many_clr_b},
{"br.cond.sptk.many.clr \\i25",       br_cond_sptk_many_clr_i25},
{"br.ctop.dpnt \\i25",       br_ctop_dpnt_i25},
{"br.ctop.dpnt.clr \\i25",       br_ctop_dpnt_clr_i25},
{"br.ctop.dpnt.few \\i25",       br_ctop_dpnt_few_i25},
{"br.ctop.dpnt.few.clr \\i25",       br_ctop_dpnt_few_clr_i25},
{"br.ctop.dpnt.many \\i25",       br_ctop_dpnt_many_i25},
{"br.ctop.dpnt.many.clr \\i25",       br_ctop_dpnt_many_clr_i25},
{"br.ctop.dptk \\i25",       br_ctop_dptk_i25},
{"br.ctop.dptk.clr \\i25",       br_ctop_dptk_clr_i25},
{"br.ctop.dptk.few \\i25",       br_ctop_dptk_few_i25},
{"br.ctop.dptk.few.clr \\i25",       br_ctop_dptk_few_clr_i25},
{"br.ctop.dptk.many \\i25",       br_ctop_dptk_many_i25},
{"br.ctop.dptk.many.clr \\i25",       br_ctop_dptk_many_clr_i25},
{"br.ctop.spnt \\i25",       br_ctop_spnt_i25},
{"br.ctop.spnt.clr \\i25",       br_ctop_spnt_clr_i25},
{"br.ctop.spnt.few \\i25",       br_ctop_spnt_few_i25},
{"br.ctop.spnt.few.clr \\i25",       br_ctop_spnt_few_clr_i25},
{"br.ctop.spnt.many \\i25",       br_ctop_spnt_many_i25},
{"br.ctop.spnt.many.clr \\i25",       br_ctop_spnt_many_clr_i25},
{"br.ctop.sptk \\i25",       br_ctop_sptk_i25},
{"br.ctop.sptk.clr \\i25",       br_ctop_sptk_clr_i25},
{"br.ctop.sptk.few \\i25",       br_ctop_sptk_few_i25},
{"br.ctop.sptk.few.clr \\i25",       br_ctop_sptk_few_clr_i25},
{"br.ctop.sptk.many \\i25",       br_ctop_sptk_many_i25},
{"br.ctop.sptk.many.clr \\i25",       br_ctop_sptk_many_clr_i25},
{"break \\i21",       break_i21},
{"break.b \\i21",       break_b_i21},
{"break.f \\i21",       break_f_i21},
{"break.i \\i21",       break_i_i21},
{"break.m \\i21",       break_m_i21},
{"break.x \\i62",       break_x_i62},
{"br.few \\b",       br_few_b},
{"br.few \\i25",       br_few_i25},
{"br.few.clr \\b",       br_few_clr_b},
{"br.few.clr \\i25",       br_few_clr_i25},
{"br.ia.dpnt \\b",       br_ia_dpnt_b},
{"br.ia.dpnt.clr \\b",       br_ia_dpnt_clr_b},
{"br.ia.dpnt.few \\b",       br_ia_dpnt_few_b},
{"br.ia.dpnt.few.clr \\b",       br_ia_dpnt_few_clr_b},
{"br.ia.dpnt.many \\b",       br_ia_dpnt_many_b},
{"br.ia.dpnt.many.clr \\b",       br_ia_dpnt_many_clr_b},
{"br.ia.dptk \\b",       br_ia_dptk_b},
{"br.ia.dptk.clr \\b",       br_ia_dptk_clr_b},
{"br.ia.dptk.few \\b",       br_ia_dptk_few_b},
{"br.ia.dptk.few.clr \\b",       br_ia_dptk_few_clr_b},
{"br.ia.dptk.many \\b",       br_ia_dptk_many_b},
{"br.ia.dptk.many.clr \\b",       br_ia_dptk_many_clr_b},
{"br.ia.spnt \\b",       br_ia_spnt_b},
{"br.ia.spnt.clr \\b",       br_ia_spnt_clr_b},
{"br.ia.spnt.few \\b",       br_ia_spnt_few_b},
{"br.ia.spnt.few.clr \\b",       br_ia_spnt_few_clr_b},
{"br.ia.spnt.many \\b",       br_ia_spnt_many_b},
{"br.ia.spnt.many.clr \\b",       br_ia_spnt_many_clr_b},
{"br.ia.sptk \\b",       br_ia_sptk_b},
{"br.ia.sptk.clr \\b",       br_ia_sptk_clr_b},
{"br.ia.sptk.few \\b",       br_ia_sptk_few_b},
{"br.ia.sptk.few.clr \\b",       br_ia_sptk_few_clr_b},
{"br.ia.sptk.many \\b",       br_ia_sptk_many_b},
{"br.ia.sptk.many.clr \\b",       br_ia_sptk_many_clr_b},
{"br.many \\b",       br_many_b},
{"br.many \\i25",       br_many_i25},
{"br.many.clr \\b",       br_many_clr_b},
{"br.many.clr \\i25",       br_many_clr_i25},
{"br.ret.dpnt \\b",       br_ret_dpnt_b},
{"br.ret.dpnt.clr \\b",       br_ret_dpnt_clr_b},
{"br.ret.dpnt.few \\b",       br_ret_dpnt_few_b},
{"br.ret.dpnt.few.clr \\b",       br_ret_dpnt_few_clr_b},
{"br.ret.dpnt.many \\b",       br_ret_dpnt_many_b},
{"br.ret.dpnt.many.clr \\b",       br_ret_dpnt_many_clr_b},
{"br.ret.dptk \\b",       br_ret_dptk_b},
{"br.ret.dptk.clr \\b",       br_ret_dptk_clr_b},
{"br.ret.dptk.few \\b",       br_ret_dptk_few_b},
{"br.ret.dptk.few.clr \\b",       br_ret_dptk_few_clr_b},
{"br.ret.dptk.many \\b",       br_ret_dptk_many_b},
{"br.ret.dptk.many.clr \\b",       br_ret_dptk_many_clr_b},
{"br.ret.spnt \\b",       br_ret_spnt_b},
{"br.ret.spnt.clr \\b",       br_ret_spnt_clr_b},
{"br.ret.spnt.few \\b",       br_ret_spnt_few_b},
{"br.ret.spnt.few.clr \\b",       br_ret_spnt_few_clr_b},
{"br.ret.spnt.many \\b",       br_ret_spnt_many_b},
{"br.ret.spnt.many.clr \\b",       br_ret_spnt_many_clr_b},
{"br.ret.sptk \\b",       br_ret_sptk_b},
{"br.ret.sptk.clr \\b",       br_ret_sptk_clr_b},
{"br.ret.sptk.few \\b",       br_ret_sptk_few_b},
{"br.ret.sptk.few.clr \\b",       br_ret_sptk_few_clr_b},
{"br.ret.sptk.many \\b",       br_ret_sptk_many_b},
{"br.ret.sptk.many.clr \\b",       br_ret_sptk_many_clr_b},
{"br.wexit.dpnt \\i25",       br_wexit_dpnt_i25},
{"br.wexit.dpnt.clr \\i25",       br_wexit_dpnt_clr_i25},
{"br.wexit.dpnt.few \\i25",       br_wexit_dpnt_few_i25},
{"br.wexit.dpnt.few.clr \\i25",       br_wexit_dpnt_few_clr_i25},
{"br.wexit.dpnt.many \\i25",       br_wexit_dpnt_many_i25},
{"br.wexit.dpnt.many.clr \\i25",       br_wexit_dpnt_many_clr_i25},
{"br.wexit.dptk \\i25",       br_wexit_dptk_i25},
{"br.wexit.dptk.clr \\i25",       br_wexit_dptk_clr_i25},
{"br.wexit.dptk.few \\i25",       br_wexit_dptk_few_i25},
{"br.wexit.dptk.few.clr \\i25",       br_wexit_dptk_few_clr_i25},
{"br.wexit.dptk.many \\i25",       br_wexit_dptk_many_i25},
{"br.wexit.dptk.many.clr \\i25",       br_wexit_dptk_many_clr_i25},
{"br.wexit.spnt \\i25",       br_wexit_spnt_i25},
{"br.wexit.spnt.clr \\i25",       br_wexit_spnt_clr_i25},
{"br.wexit.spnt.few \\i25",       br_wexit_spnt_few_i25},
{"br.wexit.spnt.few.clr \\i25",       br_wexit_spnt_few_clr_i25},
{"br.wexit.spnt.many \\i25",       br_wexit_spnt_many_i25},
{"br.wexit.spnt.many.clr \\i25",       br_wexit_spnt_many_clr_i25},
{"br.wexit.sptk \\i25",       br_wexit_sptk_i25},
{"br.wexit.sptk.clr \\i25",       br_wexit_sptk_clr_i25},
{"br.wexit.sptk.few \\i25",       br_wexit_sptk_few_i25},
{"br.wexit.sptk.few.clr \\i25",       br_wexit_sptk_few_clr_i25},
{"br.wexit.sptk.many \\i25",       br_wexit_sptk_many_i25},
{"br.wexit.sptk.many.clr \\i25",       br_wexit_sptk_many_clr_i25},
{"br.wtop.dpnt \\i25",       br_wtop_dpnt_i25},
{"br.wtop.dpnt.clr \\i25",       br_wtop_dpnt_clr_i25},
{"br.wtop.dpnt.few \\i25",       br_wtop_dpnt_few_i25},
{"br.wtop.dpnt.few.clr \\i25",       br_wtop_dpnt_few_clr_i25},
{"br.wtop.dpnt.many \\i25",       br_wtop_dpnt_many_i25},
{"br.wtop.dpnt.many.clr \\i25",       br_wtop_dpnt_many_clr_i25},
{"br.wtop.dptk \\i25",       br_wtop_dptk_i25},
{"br.wtop.dptk.clr \\i25",       br_wtop_dptk_clr_i25},
{"br.wtop.dptk.few \\i25",       br_wtop_dptk_few_i25},
{"br.wtop.dptk.few.clr \\i25",       br_wtop_dptk_few_clr_i25},
{"br.wtop.dptk.many \\i25",       br_wtop_dptk_many_i25},
{"br.wtop.dptk.many.clr \\i25",       br_wtop_dptk_many_clr_i25},
{"br.wtop.spnt \\i25",       br_wtop_spnt_i25},
{"br.wtop.spnt.clr \\i25",       br_wtop_spnt_clr_i25},
{"br.wtop.spnt.few \\i25",       br_wtop_spnt_few_i25},
{"br.wtop.spnt.few.clr \\i25",       br_wtop_spnt_few_clr_i25},
{"br.wtop.spnt.many \\i25",       br_wtop_spnt_many_i25},
{"br.wtop.spnt.many.clr \\i25",       br_wtop_spnt_many_clr_i25},
{"br.wtop.sptk \\i25",       br_wtop_sptk_i25},
{"br.wtop.sptk.clr \\i25",       br_wtop_sptk_clr_i25},
{"br.wtop.sptk.few \\i25",       br_wtop_sptk_few_i25},
{"br.wtop.sptk.few.clr \\i25",       br_wtop_sptk_few_clr_i25},
{"br.wtop.sptk.many \\i25",       br_wtop_sptk_many_i25},
{"br.wtop.sptk.many.clr \\i25",       br_wtop_sptk_many_clr_i25},
{"chk.a.clr \\f,\\i25",       chk_a_clr_f_i25},
{"chk.a.clr \\r,\\i25",       chk_a_clr_r_i25},
{"chk.a.nc \\f,\\i25",       chk_a_nc_f_i25},
{"chk.a.nc \\r,\\i25",       chk_a_nc_r_i25},
{"chk.s \\f,\\i25",       chk_s_f_i25},
{"chk.s \\r,\\i25",       chk_s_r_i25},
{"chk.s.i \\r,\\i25",       chk_s_i_r_i25},
{"chk.s.m \\r,\\i25",       chk_s_m_r_i25},
{"clrrrb",       clrrrb},
{"clrrrb.pr",       clrrrb_pr},
{"cmp4.eq \\p,\\p=\\i8,\\r",       cmp4_eq_p_p_i8_r},
{"cmp4.eq \\p,\\p=\\r,\\r",       cmp4_eq_p_p_r_r},
{"cmp4.eq.and \\p,\\p=\\i8,\\r",       cmp4_eq_and_p_p_i8_r},
{"cmp4.eq.and \\p,\\p=\\r,\\r",       cmp4_eq_and_p_p_r_r},
{"cmp4.eq.andcm \\p,\\p=\\i8,\\r",       cmp4_eq_andcm_p_p_i8_r},
{"cmp4.eq.andcm \\p,\\p=\\r,\\r",       cmp4_eq_andcm_p_p_r_r},
{"cmp4.eq.and.orcm \\p,\\p=\\i8,\\r",       cmp4_eq_and_orcm_p_p_i8_r},
{"cmp4.eq.and.orcm \\p,\\p=\\r,\\r",       cmp4_eq_and_orcm_p_p_r_r},
{"cmp4.eq.or \\p,\\p=\\i8,\\r",       cmp4_eq_or_p_p_i8_r},
{"cmp4.eq.or \\p,\\p=\\r,\\r",       cmp4_eq_or_p_p_r_r},
{"cmp4.eq.or.andcm \\p,\\p=\\i8,\\r",       cmp4_eq_or_andcm_p_p_i8_r},
{"cmp4.eq.or.andcm \\p,\\p=\\r,\\r",       cmp4_eq_or_andcm_p_p_r_r},
{"cmp4.eq.orcm \\p,\\p=\\i8,\\r",       cmp4_eq_orcm_p_p_i8_r},
{"cmp4.eq.orcm \\p,\\p=\\r,\\r",       cmp4_eq_orcm_p_p_r_r},
{"cmp4.eq.unc \\p,\\p=\\i8,\\r",       cmp4_eq_unc_p_p_i8_r},
{"cmp4.eq.unc \\p,\\p=\\r,\\r",       cmp4_eq_unc_p_p_r_r},
{"cmp4.ge \\p,\\p=\\i8,\\r",       cmp4_ge_p_p_i8_r},
{"cmp4.ge \\p,\\p=\\r,\\r",       cmp4_ge_p_p_r_r},
{"cmp4.ge.and \\p,\\p=\\r0,\\r",       cmp4_ge_and_p_p_r0_r},
{"cmp4.ge.and \\p,\\p=\\r,\\r0",       cmp4_ge_and_p_p_r_r0},
{"cmp4.ge.andcm \\p,\\p=\\r0,\\r",       cmp4_ge_andcm_p_p_r0_r},
{"cmp4.ge.andcm \\p,\\p=\\r,\\r0",       cmp4_ge_andcm_p_p_r_r0},
{"cmp4.ge.and.orcm \\p,\\p=\\r0,\\r",       cmp4_ge_and_orcm_p_p_r0_r},
{"cmp4.ge.and.orcm \\p,\\p=\\r,\\r0",       cmp4_ge_and_orcm_p_p_r_r0},
{"cmp4.ge.or \\p,\\p=\\r0,\\r",       cmp4_ge_or_p_p_r0_r},
{"cmp4.ge.or \\p,\\p=\\r,\\r0",       cmp4_ge_or_p_p_r_r0},
{"cmp4.ge.or.andcm \\p,\\p=\\r0,\\r",       cmp4_ge_or_andcm_p_p_r0_r},
{"cmp4.ge.or.andcm \\p,\\p=\\r,\\r0",       cmp4_ge_or_andcm_p_p_r_r0},
{"cmp4.ge.orcm \\p,\\p=\\r0,\\r",       cmp4_ge_orcm_p_p_r0_r},
{"cmp4.ge.orcm \\p,\\p=\\r,\\r0",       cmp4_ge_orcm_p_p_r_r0},
{"cmp4.geu \\p,\\p=\\i8,\\r",       cmp4_geu_p_p_i8_r},
{"cmp4.geu \\p,\\p=\\r,\\r",       cmp4_geu_p_p_r_r},
{"cmp4.ge.unc \\p,\\p=\\i8,\\r",       cmp4_ge_unc_p_p_i8_r},
{"cmp4.ge.unc \\p,\\p=\\r,\\r",       cmp4_ge_unc_p_p_r_r},
{"cmp4.geu.unc \\p,\\p=\\i8,\\r",       cmp4_geu_unc_p_p_i8_r},
{"cmp4.geu.unc \\p,\\p=\\r,\\r",       cmp4_geu_unc_p_p_r_r},
{"cmp4.gt \\p,\\p=\\i8,\\r",       cmp4_gt_p_p_i8_r},
{"cmp4.gt \\p,\\p=\\r,\\r",       cmp4_gt_p_p_r_r},
{"cmp4.gt.and \\p,\\p=\\r0,\\r",       cmp4_gt_and_p_p_r0_r},
{"cmp4.gt.and \\p,\\p=\\r,\\r0",       cmp4_gt_and_p_p_r_r0},
{"cmp4.gt.andcm \\p,\\p=\\r0,\\r",       cmp4_gt_andcm_p_p_r0_r},
{"cmp4.gt.andcm \\p,\\p=\\r,\\r0",       cmp4_gt_andcm_p_p_r_r0},
{"cmp4.gt.and.orcm \\p,\\p=\\r0,\\r",       cmp4_gt_and_orcm_p_p_r0_r},
{"cmp4.gt.and.orcm \\p,\\p=\\r,\\r0",       cmp4_gt_and_orcm_p_p_r_r0},
{"cmp4.gt.or \\p,\\p=\\r0,\\r",       cmp4_gt_or_p_p_r0_r},
{"cmp4.gt.or \\p,\\p=\\r,\\r0",       cmp4_gt_or_p_p_r_r0},
{"cmp4.gt.or.andcm \\p,\\p=\\r0,\\r",       cmp4_gt_or_andcm_p_p_r0_r},
{"cmp4.gt.or.andcm \\p,\\p=\\r,\\r0",       cmp4_gt_or_andcm_p_p_r_r0},
{"cmp4.gt.orcm \\p,\\p=\\r0,\\r",       cmp4_gt_orcm_p_p_r0_r},
{"cmp4.gt.orcm \\p,\\p=\\r,\\r0",       cmp4_gt_orcm_p_p_r_r0},
{"cmp4.gtu \\p,\\p=\\i8,\\r",       cmp4_gtu_p_p_i8_r},
{"cmp4.gtu \\p,\\p=\\r,\\r",       cmp4_gtu_p_p_r_r},
{"cmp4.gt.unc \\p,\\p=\\i8,\\r",       cmp4_gt_unc_p_p_i8_r},
{"cmp4.gt.unc \\p,\\p=\\r,\\r",       cmp4_gt_unc_p_p_r_r},
{"cmp4.gtu.unc \\p,\\p=\\i8,\\r",       cmp4_gtu_unc_p_p_i8_r},
{"cmp4.gtu.unc \\p,\\p=\\r,\\r",       cmp4_gtu_unc_p_p_r_r},
{"cmp4.le \\p,\\p=\\i8,\\r",       cmp4_le_p_p_i8_r},
{"cmp4.le \\p,\\p=\\r,\\r",       cmp4_le_p_p_r_r},
{"cmp4.le.and \\p,\\p=\\r0,\\r",       cmp4_le_and_p_p_r0_r},
{"cmp4.le.and \\p,\\p=\\r,\\r0",       cmp4_le_and_p_p_r_r0},
{"cmp4.le.andcm \\p,\\p=\\r0,\\r",       cmp4_le_andcm_p_p_r0_r},
{"cmp4.le.andcm \\p,\\p=\\r,\\r0",       cmp4_le_andcm_p_p_r_r0},
{"cmp4.le.and.orcm \\p,\\p=\\r0,\\r",       cmp4_le_and_orcm_p_p_r0_r},
{"cmp4.le.and.orcm \\p,\\p=\\r,\\r0",       cmp4_le_and_orcm_p_p_r_r0},
{"cmp4.le.or \\p,\\p=\\r0,\\r",       cmp4_le_or_p_p_r0_r},
{"cmp4.le.or \\p,\\p=\\r,\\r0",       cmp4_le_or_p_p_r_r0},
{"cmp4.le.or.andcm \\p,\\p=\\r0,\\r",       cmp4_le_or_andcm_p_p_r0_r},
{"cmp4.le.or.andcm \\p,\\p=\\r,\\r0",       cmp4_le_or_andcm_p_p_r_r0},
{"cmp4.le.orcm \\p,\\p=\\r0,\\r",       cmp4_le_orcm_p_p_r0_r},
{"cmp4.le.orcm \\p,\\p=\\r,\\r0",       cmp4_le_orcm_p_p_r_r0},
{"cmp4.leu \\p,\\p=\\i8,\\r",       cmp4_leu_p_p_i8_r},
{"cmp4.leu \\p,\\p=\\r,\\r",       cmp4_leu_p_p_r_r},
{"cmp4.le.unc \\p,\\p=\\i8,\\r",       cmp4_le_unc_p_p_i8_r},
{"cmp4.le.unc \\p,\\p=\\r,\\r",       cmp4_le_unc_p_p_r_r},
{"cmp4.leu.unc \\p,\\p=\\i8,\\r",       cmp4_leu_unc_p_p_i8_r},
{"cmp4.leu.unc \\p,\\p=\\r,\\r",       cmp4_leu_unc_p_p_r_r},
{"cmp4.lt \\p,\\p=\\i8,\\r",       cmp4_lt_p_p_i8_r},
{"cmp4.lt \\p,\\p=\\r,\\r",       cmp4_lt_p_p_r_r},
{"cmp4.lt.and \\p,\\p=\\r0,\\r",       cmp4_lt_and_p_p_r0_r},
{"cmp4.lt.and \\p,\\p=\\r,\\r0",       cmp4_lt_and_p_p_r_r0},
{"cmp4.lt.andcm \\p,\\p=\\r0,\\r",       cmp4_lt_andcm_p_p_r0_r},
{"cmp4.lt.andcm \\p,\\p=\\r,\\r0",       cmp4_lt_andcm_p_p_r_r0},
{"cmp4.lt.and.orcm \\p,\\p=\\r0,\\r",       cmp4_lt_and_orcm_p_p_r0_r},
{"cmp4.lt.and.orcm \\p,\\p=\\r,\\r0",       cmp4_lt_and_orcm_p_p_r_r0},
{"cmp4.lt.or \\p,\\p=\\r0,\\r",       cmp4_lt_or_p_p_r0_r},
{"cmp4.lt.or \\p,\\p=\\r,\\r0",       cmp4_lt_or_p_p_r_r0},
{"cmp4.lt.or.andcm \\p,\\p=\\r0,\\r",       cmp4_lt_or_andcm_p_p_r0_r},
{"cmp4.lt.or.andcm \\p,\\p=\\r,\\r0",       cmp4_lt_or_andcm_p_p_r_r0},
{"cmp4.lt.orcm \\p,\\p=\\r0,\\r",       cmp4_lt_orcm_p_p_r0_r},
{"cmp4.lt.orcm \\p,\\p=\\r,\\r0",       cmp4_lt_orcm_p_p_r_r0},
{"cmp4.ltu \\p,\\p=\\i8,\\r",       cmp4_ltu_p_p_i8_r},
{"cmp4.ltu \\p,\\p=\\r,\\r",       cmp4_ltu_p_p_r_r},
{"cmp4.lt.unc \\p,\\p=\\i8,\\r",       cmp4_lt_unc_p_p_i8_r},
{"cmp4.lt.unc \\p,\\p=\\r,\\r",       cmp4_lt_unc_p_p_r_r},
{"cmp4.ltu.unc \\p,\\p=\\i8,\\r",       cmp4_ltu_unc_p_p_i8_r},
{"cmp4.ltu.unc \\p,\\p=\\r,\\r",       cmp4_ltu_unc_p_p_r_r},
{"cmp4.ne \\p,\\p=\\i8,\\r",       cmp4_ne_p_p_i8_r},
{"cmp4.ne \\p,\\p=\\r,\\r",       cmp4_ne_p_p_r_r},
{"cmp4.ne.and \\p,\\p=\\i8,\\r",       cmp4_ne_and_p_p_i8_r},
{"cmp4.ne.and \\p,\\p=\\r,\\r",       cmp4_ne_and_p_p_r_r},
{"cmp4.ne.andcm \\p,\\p=\\i8,\\r",       cmp4_ne_andcm_p_p_i8_r},
{"cmp4.ne.andcm \\p,\\p=\\r,\\r",       cmp4_ne_andcm_p_p_r_r},
{"cmp4.ne.and.orcm \\p,\\p=\\i8,\\r",       cmp4_ne_and_orcm_p_p_i8_r},
{"cmp4.ne.and.orcm \\p,\\p=\\r,\\r",       cmp4_ne_and_orcm_p_p_r_r},
{"cmp4.ne.or \\p,\\p=\\i8,\\r",       cmp4_ne_or_p_p_i8_r},
{"cmp4.ne.or \\p,\\p=\\r,\\r",       cmp4_ne_or_p_p_r_r},
{"cmp4.ne.or.andcm \\p,\\p=\\i8,\\r",       cmp4_ne_or_andcm_p_p_i8_r},
{"cmp4.ne.or.andcm \\p,\\p=\\r,\\r",       cmp4_ne_or_andcm_p_p_r_r},
{"cmp4.ne.orcm \\p,\\p=\\i8,\\r",       cmp4_ne_orcm_p_p_i8_r},
{"cmp4.ne.orcm \\p,\\p=\\r,\\r",       cmp4_ne_orcm_p_p_r_r},
{"cmp4.ne.unc \\p,\\p=\\i8,\\r",       cmp4_ne_unc_p_p_i8_r},
{"cmp4.ne.unc \\p,\\p=\\r,\\r",       cmp4_ne_unc_p_p_r_r},
{"cmp.eq \\p,\\p=\\i8,\\r",       cmp_eq_p_p_i8_r},
{"cmp.eq \\p,\\p=\\r,\\r",       cmp_eq_p_p_r_r},
{"cmp.eq.and \\p,\\p=\\i8,\\r",       cmp_eq_and_p_p_i8_r},
{"cmp.eq.and \\p,\\p=\\r,\\r",       cmp_eq_and_p_p_r_r},
{"cmp.eq.andcm \\p,\\p=\\i8,\\r",       cmp_eq_andcm_p_p_i8_r},
{"cmp.eq.andcm \\p,\\p=\\r,\\r",       cmp_eq_andcm_p_p_r_r},
{"cmp.eq.and.orcm \\p,\\p=\\i8,\\r",       cmp_eq_and_orcm_p_p_i8_r},
{"cmp.eq.and.orcm \\p,\\p=\\r,\\r",       cmp_eq_and_orcm_p_p_r_r},
{"cmp.eq.or \\p,\\p=\\i8,\\r",       cmp_eq_or_p_p_i8_r},
{"cmp.eq.or \\p,\\p=\\r,\\r",       cmp_eq_or_p_p_r_r},
{"cmp.eq.or.andcm \\p,\\p=\\i8,\\r",       cmp_eq_or_andcm_p_p_i8_r},
{"cmp.eq.or.andcm \\p,\\p=\\r,\\r",       cmp_eq_or_andcm_p_p_r_r},
{"cmp.eq.orcm \\p,\\p=\\i8,\\r",       cmp_eq_orcm_p_p_i8_r},
{"cmp.eq.orcm \\p,\\p=\\r,\\r",       cmp_eq_orcm_p_p_r_r},
{"cmp.eq.unc \\p,\\p=\\i8,\\r",       cmp_eq_unc_p_p_i8_r},
{"cmp.eq.unc \\p,\\p=\\r,\\r",       cmp_eq_unc_p_p_r_r},
{"cmp.ge \\p,\\p=\\i8,\\r",       cmp_ge_p_p_i8_r},
{"cmp.ge \\p,\\p=\\r,\\r",       cmp_ge_p_p_r_r},
{"cmp.ge.and \\p,\\p=\\r0,\\r",       cmp_ge_and_p_p_r0_r},
{"cmp.ge.and \\p,\\p=\\r,\\r0",       cmp_ge_and_p_p_r_r0},
{"cmp.ge.andcm \\p,\\p=\\r0,\\r",       cmp_ge_andcm_p_p_r0_r},
{"cmp.ge.andcm \\p,\\p=\\r,\\r0",       cmp_ge_andcm_p_p_r_r0},
{"cmp.ge.and.orcm \\p,\\p=\\r0,\\r",       cmp_ge_and_orcm_p_p_r0_r},
{"cmp.ge.and.orcm \\p,\\p=\\r,\\r0",       cmp_ge_and_orcm_p_p_r_r0},
{"cmp.ge.or \\p,\\p=\\r0,\\r",       cmp_ge_or_p_p_r0_r},
{"cmp.ge.or \\p,\\p=\\r,\\r0",       cmp_ge_or_p_p_r_r0},
{"cmp.ge.or.andcm \\p,\\p=\\r0,\\r",       cmp_ge_or_andcm_p_p_r0_r},
{"cmp.ge.or.andcm \\p,\\p=\\r,\\r0",       cmp_ge_or_andcm_p_p_r_r0},
{"cmp.ge.orcm \\p,\\p=\\r0,\\r",       cmp_ge_orcm_p_p_r0_r},
{"cmp.ge.orcm \\p,\\p=\\r,\\r0",       cmp_ge_orcm_p_p_r_r0},
{"cmp.geu \\p,\\p=\\i8,\\r",       cmp_geu_p_p_i8_r},
{"cmp.geu \\p,\\p=\\r,\\r",       cmp_geu_p_p_r_r},
{"cmp.ge.unc \\p,\\p=\\i8,\\r",       cmp_ge_unc_p_p_i8_r},
{"cmp.ge.unc \\p,\\p=\\r,\\r",       cmp_ge_unc_p_p_r_r},
{"cmp.geu.unc \\p,\\p=\\i8,\\r",       cmp_geu_unc_p_p_i8_r},
{"cmp.geu.unc \\p,\\p=\\r,\\r",       cmp_geu_unc_p_p_r_r},
{"cmp.gt \\p,\\p=\\i8,\\r",       cmp_gt_p_p_i8_r},
{"cmp.gt \\p,\\p=\\r,\\r",       cmp_gt_p_p_r_r},
{"cmp.gt.and \\p,\\p=\\r0,\\r",       cmp_gt_and_p_p_r0_r},
{"cmp.gt.and \\p,\\p=\\r,\\r0",       cmp_gt_and_p_p_r_r0},
{"cmp.gt.andcm \\p,\\p=\\r0,\\r",       cmp_gt_andcm_p_p_r0_r},
{"cmp.gt.andcm \\p,\\p=\\r,\\r0",       cmp_gt_andcm_p_p_r_r0},
{"cmp.gt.and.orcm \\p,\\p=\\r0,\\r",       cmp_gt_and_orcm_p_p_r0_r},
{"cmp.gt.and.orcm \\p,\\p=\\r,\\r0",       cmp_gt_and_orcm_p_p_r_r0},
{"cmp.gt.or \\p,\\p=\\r0,\\r",       cmp_gt_or_p_p_r0_r},
{"cmp.gt.or \\p,\\p=\\r,\\r0",       cmp_gt_or_p_p_r_r0},
{"cmp.gt.or.andcm \\p,\\p=\\r0,\\r",       cmp_gt_or_andcm_p_p_r0_r},
{"cmp.gt.or.andcm \\p,\\p=\\r,\\r0",       cmp_gt_or_andcm_p_p_r_r0},
{"cmp.gt.orcm \\p,\\p=\\r0,\\r",       cmp_gt_orcm_p_p_r0_r},
{"cmp.gt.orcm \\p,\\p=\\r,\\r0",       cmp_gt_orcm_p_p_r_r0},
{"cmp.gtu \\p,\\p=\\i8,\\r",       cmp_gtu_p_p_i8_r},
{"cmp.gtu \\p,\\p=\\r,\\r",       cmp_gtu_p_p_r_r},
{"cmp.gt.unc \\p,\\p=\\i8,\\r",       cmp_gt_unc_p_p_i8_r},
{"cmp.gt.unc \\p,\\p=\\r,\\r",       cmp_gt_unc_p_p_r_r},
{"cmp.gtu.unc \\p,\\p=\\i8,\\r",       cmp_gtu_unc_p_p_i8_r},
{"cmp.gtu.unc \\p,\\p=\\r,\\r",       cmp_gtu_unc_p_p_r_r},
{"cmp.le \\p,\\p=\\i8,\\r",       cmp_le_p_p_i8_r},
{"cmp.le \\p,\\p=\\r,\\r",       cmp_le_p_p_r_r},
{"cmp.le.and \\p,\\p=\\r0,\\r",       cmp_le_and_p_p_r0_r},
{"cmp.le.and \\p,\\p=\\r,\\r0",       cmp_le_and_p_p_r_r0},
{"cmp.le.andcm \\p,\\p=\\r0,\\r",       cmp_le_andcm_p_p_r0_r},
{"cmp.le.andcm \\p,\\p=\\r,\\r0",       cmp_le_andcm_p_p_r_r0},
{"cmp.le.and.orcm \\p,\\p=\\r0,\\r",       cmp_le_and_orcm_p_p_r0_r},
{"cmp.le.and.orcm \\p,\\p=\\r,\\r0",       cmp_le_and_orcm_p_p_r_r0},
{"cmp.le.or \\p,\\p=\\r0,\\r",       cmp_le_or_p_p_r0_r},
{"cmp.le.or \\p,\\p=\\r,\\r0",       cmp_le_or_p_p_r_r0},
{"cmp.le.or.andcm \\p,\\p=\\r0,\\r",       cmp_le_or_andcm_p_p_r0_r},
{"cmp.le.or.andcm \\p,\\p=\\r,\\r0",       cmp_le_or_andcm_p_p_r_r0},
{"cmp.le.orcm \\p,\\p=\\r0,\\r",       cmp_le_orcm_p_p_r0_r},
{"cmp.le.orcm \\p,\\p=\\r,\\r0",       cmp_le_orcm_p_p_r_r0},
{"cmp.leu \\p,\\p=\\i8,\\r",       cmp_leu_p_p_i8_r},
{"cmp.leu \\p,\\p=\\r,\\r",       cmp_leu_p_p_r_r},
{"cmp.le.unc \\p,\\p=\\i8,\\r",       cmp_le_unc_p_p_i8_r},
{"cmp.le.unc \\p,\\p=\\r,\\r",       cmp_le_unc_p_p_r_r},
{"cmp.leu.unc \\p,\\p=\\i8,\\r",       cmp_leu_unc_p_p_i8_r},
{"cmp.leu.unc \\p,\\p=\\r,\\r",       cmp_leu_unc_p_p_r_r},
{"cmp.lt \\p,\\p=\\i8,\\r",       cmp_lt_p_p_i8_r},
{"cmp.lt \\p,\\p=\\r,\\r",       cmp_lt_p_p_r_r},
{"cmp.lt.and \\p,\\p=\\r0,\\r",       cmp_lt_and_p_p_r0_r},
{"cmp.lt.and \\p,\\p=\\r,\\r0",       cmp_lt_and_p_p_r_r0},
{"cmp.lt.andcm \\p,\\p=\\r0,\\r",       cmp_lt_andcm_p_p_r0_r},
{"cmp.lt.andcm \\p,\\p=\\r,\\r0",       cmp_lt_andcm_p_p_r_r0},
{"cmp.lt.and.orcm \\p,\\p=\\r0,\\r",       cmp_lt_and_orcm_p_p_r0_r},
{"cmp.lt.and.orcm \\p,\\p=\\r,\\r0",       cmp_lt_and_orcm_p_p_r_r0},
{"cmp.lt.or \\p,\\p=\\r0,\\r",       cmp_lt_or_p_p_r0_r},
{"cmp.lt.or \\p,\\p=\\r,\\r0",       cmp_lt_or_p_p_r_r0},
{"cmp.lt.or.andcm \\p,\\p=\\r0,\\r",       cmp_lt_or_andcm_p_p_r0_r},
{"cmp.lt.or.andcm \\p,\\p=\\r,\\r0",       cmp_lt_or_andcm_p_p_r_r0},
{"cmp.lt.orcm \\p,\\p=\\r0,\\r",       cmp_lt_orcm_p_p_r0_r},
{"cmp.lt.orcm \\p,\\p=\\r,\\r0",       cmp_lt_orcm_p_p_r_r0},
{"cmp.ltu \\p,\\p=\\i8,\\r",       cmp_ltu_p_p_i8_r},
{"cmp.ltu \\p,\\p=\\r,\\r",       cmp_ltu_p_p_r_r},
{"cmp.lt.unc \\p,\\p=\\i8,\\r",       cmp_lt_unc_p_p_i8_r},
{"cmp.lt.unc \\p,\\p=\\r,\\r",       cmp_lt_unc_p_p_r_r},
{"cmp.ltu.unc \\p,\\p=\\i8,\\r",       cmp_ltu_unc_p_p_i8_r},
{"cmp.ltu.unc \\p,\\p=\\r,\\r",       cmp_ltu_unc_p_p_r_r},
{"cmp.ne \\p,\\p=\\i8,\\r",       cmp_ne_p_p_i8_r},
{"cmp.ne \\p,\\p=\\r,\\r",       cmp_ne_p_p_r_r},
{"cmp.ne.and \\p,\\p=\\i8,\\r",       cmp_ne_and_p_p_i8_r},
{"cmp.ne.and \\p,\\p=\\r,\\r",       cmp_ne_and_p_p_r_r},
{"cmp.ne.andcm \\p,\\p=\\i8,\\r",       cmp_ne_andcm_p_p_i8_r},
{"cmp.ne.andcm \\p,\\p=\\r,\\r",       cmp_ne_andcm_p_p_r_r},
{"cmp.ne.and.orcm \\p,\\p=\\i8,\\r",       cmp_ne_and_orcm_p_p_i8_r},
{"cmp.ne.and.orcm \\p,\\p=\\r,\\r",       cmp_ne_and_orcm_p_p_r_r},
{"cmp.ne.or \\p,\\p=\\i8,\\r",       cmp_ne_or_p_p_i8_r},
{"cmp.ne.or \\p,\\p=\\r,\\r",       cmp_ne_or_p_p_r_r},
{"cmp.ne.or.andcm \\p,\\p=\\i8,\\r",       cmp_ne_or_andcm_p_p_i8_r},
{"cmp.ne.or.andcm \\p,\\p=\\r,\\r",       cmp_ne_or_andcm_p_p_r_r},
{"cmp.ne.orcm \\p,\\p=\\i8,\\r",       cmp_ne_orcm_p_p_i8_r},
{"cmp.ne.orcm \\p,\\p=\\r,\\r",       cmp_ne_orcm_p_p_r_r},
{"cmp.ne.unc \\p,\\p=\\i8,\\r",       cmp_ne_unc_p_p_i8_r},
{"cmp.ne.unc \\p,\\p=\\r,\\r",       cmp_ne_unc_p_p_r_r},
{"cmpxchg.1.acq \\r=[\\r],\\r,ar.ccv",       cmpxchg_1_acq_r_r_r_ar_ccv},
{"cmpxchg.1.acq.nt1 \\r=[\\r],\\r,ar.ccv",       cmpxchg_1_acq_nt1_r_r_r_ar_ccv},
{"cmpxchg.1.acq.nta \\r=[\\r],\\r,ar.ccv",       cmpxchg_1_acq_nta_r_r_r_ar_ccv},
{"cmpxchg.1.rel \\r=[\\r],\\r,ar.ccv",       cmpxchg_1_rel_r_r_r_ar_ccv},
{"cmpxchg.1.rel.nt1 \\r=[\\r],\\r,ar.ccv",       cmpxchg_1_rel_nt1_r_r_r_ar_ccv},
{"cmpxchg.1.rel.nta \\r=[\\r],\\r,ar.ccv",       cmpxchg_1_rel_nta_r_r_r_ar_ccv},
{"cmpxchg.2.acq \\r=[\\r],\\r,ar.ccv",       cmpxchg_2_acq_r_r_r_ar_ccv},
{"cmpxchg.2.acq.nt1 \\r=[\\r],\\r,ar.ccv",       cmpxchg_2_acq_nt1_r_r_r_ar_ccv},
{"cmpxchg.2.acq.nta \\r=[\\r],\\r,ar.ccv",       cmpxchg_2_acq_nta_r_r_r_ar_ccv},
{"cmpxchg.2.rel \\r=[\\r],\\r,ar.ccv",       cmpxchg_2_rel_r_r_r_ar_ccv},
{"cmpxchg.2.rel.nt1 \\r=[\\r],\\r,ar.ccv",       cmpxchg_2_rel_nt1_r_r_r_ar_ccv},
{"cmpxchg.2.rel.nta \\r=[\\r],\\r,ar.ccv",       cmpxchg_2_rel_nta_r_r_r_ar_ccv},
{"cmpxchg.4.acq \\r=[\\r],\\r,ar.ccv",       cmpxchg_4_acq_r_r_r_ar_ccv},
{"cmpxchg.4.acq.nt1 \\r=[\\r],\\r,ar.ccv",       cmpxchg_4_acq_nt1_r_r_r_ar_ccv},
{"cmpxchg.4.acq.nta \\r=[\\r],\\r,ar.ccv",       cmpxchg_4_acq_nta_r_r_r_ar_ccv},
{"cmpxchg.4.rel \\r=[\\r],\\r,ar.ccv",       cmpxchg_4_rel_r_r_r_ar_ccv},
{"cmpxchg.4.rel.nt1 \\r=[\\r],\\r,ar.ccv",       cmpxchg_4_rel_nt1_r_r_r_ar_ccv},
{"cmpxchg.4.rel.nta \\r=[\\r],\\r,ar.ccv",       cmpxchg_4_rel_nta_r_r_r_ar_ccv},
{"cmpxchg.8.acq \\r=[\\r],\\r,ar.ccv",       cmpxchg_8_acq_r_r_r_ar_ccv},
{"cmpxchg.8.acq.nt1 \\r=[\\r],\\r,ar.ccv",       cmpxchg_8_acq_nt1_r_r_r_ar_ccv},
{"cmpxchg.8.acq.nta \\r=[\\r],\\r,ar.ccv",       cmpxchg_8_acq_nta_r_r_r_ar_ccv},
{"cmpxchg.8.rel \\r=[\\r],\\r,ar.ccv",       cmpxchg_8_rel_r_r_r_ar_ccv},
{"cmpxchg.8.rel.nt1 \\r=[\\r],\\r,ar.ccv",       cmpxchg_8_rel_nt1_r_r_r_ar_ccv},
{"cmpxchg.8.rel.nta \\r=[\\r],\\r,ar.ccv",       cmpxchg_8_rel_nta_r_r_r_ar_ccv},
{"czx1.l \\r=\\r",       czx1_l_r_r},
{"czx1.r \\r=\\r",       czx1_r_r_r},
{"czx2.l \\r=\\r",       czx2_l_r_r},
{"czx2.r \\r=\\r",       czx2_r_r_r},
{"dep \\r=\\u1,\\r,\\u6,\\u6",       dep_r_u1_r_u6_u6},
{"dep \\r=\\r,\\r,\\u6,\\u4",       dep_r_r_r_u6_u4},
{"dep.z \\r=\\i8,\\u6,\\u6",       dep_z_r_i8_u6_u6},
{"dep.z \\r=\\r,\\u6,\\u6",       dep_z_r_r_u6_u6},
{"extr \\r=\\r,\\u6,\\u6",       extr_r_r_u6_u6},
{"extr.u \\r=\\r,\\u6,\\u6",       extr_u_r_r_u6_u6},
{"fabs \\f=\\f",       fabs_f_f},
{"fadd \\f=\\f,\\f",       fadd_f_f_f},
{"fadd.d \\f=\\f,\\f",       fadd_d_f_f_f},
{"fadd.d.s0 \\f=\\f,\\f",       fadd_d_s0_f_f_f},
{"fadd.d.s1 \\f=\\f,\\f",       fadd_d_s1_f_f_f},
{"fadd.d.s2 \\f=\\f,\\f",       fadd_d_s2_f_f_f},
{"fadd.d.s3 \\f=\\f,\\f",       fadd_d_s3_f_f_f},
{"fadd.s \\f=\\f,\\f",       fadd_s_f_f_f},
{"fadd.s0 \\f=\\f,\\f",       fadd_s0_f_f_f},
{"fadd.s1 \\f=\\f,\\f",       fadd_s1_f_f_f},
{"fadd.s2 \\f=\\f,\\f",       fadd_s2_f_f_f},
{"fadd.s3 \\f=\\f,\\f",       fadd_s3_f_f_f},
{"fadd.s.s0 \\f=\\f,\\f",       fadd_s_s0_f_f_f},
{"fadd.s.s1 \\f=\\f,\\f",       fadd_s_s1_f_f_f},
{"fadd.s.s2 \\f=\\f,\\f",       fadd_s_s2_f_f_f},
{"fadd.s.s3 \\f=\\f,\\f",       fadd_s_s3_f_f_f},
{"famax \\f=\\f,\\f",       famax_f_f_f},
{"famax.s0 \\f=\\f,\\f",       famax_s0_f_f_f},
{"famax.s1 \\f=\\f,\\f",       famax_s1_f_f_f},
{"famax.s2 \\f=\\f,\\f",       famax_s2_f_f_f},
{"famax.s3 \\f=\\f,\\f",       famax_s3_f_f_f},
{"famin \\f=\\f,\\f",       famin_f_f_f},
{"famin.s0 \\f=\\f,\\f",       famin_s0_f_f_f},
{"famin.s1 \\f=\\f,\\f",       famin_s1_f_f_f},
{"famin.s2 \\f=\\f,\\f",       famin_s2_f_f_f},
{"famin.s3 \\f=\\f,\\f",       famin_s3_f_f_f},
{"fand \\f=\\f,\\f",       fand_f_f_f},
{"fandcm \\f=\\f,\\f",       fandcm_f_f_f},
{"fc \\r",       fc_r},
{"fchkf \\i25",       fchkf_i25},
{"fchkf.s0 \\i25",       fchkf_s0_i25},
{"fchkf.s1 \\i25",       fchkf_s1_i25},
{"fchkf.s2 \\i25",       fchkf_s2_i25},
{"fchkf.s3 \\i25",       fchkf_s3_i25},
{"fclass.eq \\p,\\p=\\f,\\i9",       fclass_eq_p_p_f_i9},
{"fclass.ge \\p,\\p=\\f,\\i9",       fclass_ge_p_p_f_i9},
{"fclass.gt \\p,\\p=\\f,\\i9",       fclass_gt_p_p_f_i9},
{"fclass.le \\p,\\p=\\f,\\i9",       fclass_le_p_p_f_i9},
{"fclass.lt \\p,\\p=\\f,\\i9",       fclass_lt_p_p_f_i9},
{"fclass.m.eq \\p,\\p=\\f,\\i9",       fclass_m_eq_p_p_f_i9},
{"fclass.m.ge \\p,\\p=\\f,\\i9",       fclass_m_ge_p_p_f_i9},
{"fclass.m.gt \\p,\\p=\\f,\\i9",       fclass_m_gt_p_p_f_i9},
{"fclass.m.le \\p,\\p=\\f,\\i9",       fclass_m_le_p_p_f_i9},
{"fclass.m.lt \\p,\\p=\\f,\\i9",       fclass_m_lt_p_p_f_i9},
{"fclass.m.neq \\p,\\p=\\f,\\i9",       fclass_m_neq_p_p_f_i9},
{"fclass.m.nge \\p,\\p=\\f,\\i9",       fclass_m_nge_p_p_f_i9},
{"fclass.m.ngt \\p,\\p=\\f,\\i9",       fclass_m_ngt_p_p_f_i9},
{"fclass.m.nlt \\p,\\p=\\f,\\i9",       fclass_m_nlt_p_p_f_i9},
{"fclass.m.ord \\p,\\p=\\f,\\i9",       fclass_m_ord_p_p_f_i9},
{"fclass.m.unord \\p,\\p=\\f,\\i9",       fclass_m_unord_p_p_f_i9},
{"fclass.neq \\p,\\p=\\f,\\i9",       fclass_neq_p_p_f_i9},
{"fclass.nge \\p,\\p=\\f,\\i9",       fclass_nge_p_p_f_i9},
{"fclass.ngt \\p,\\p=\\f,\\i9",       fclass_ngt_p_p_f_i9},
{"fclass.nlt \\p,\\p=\\f,\\i9",       fclass_nlt_p_p_f_i9},
{"fclass.nm.eq \\p,\\p=\\f,\\i9",       fclass_nm_eq_p_p_f_i9},
{"fclass.nm.ge \\p,\\p=\\f,\\i9",       fclass_nm_ge_p_p_f_i9},
{"fclass.nm.gt \\p,\\p=\\f,\\i9",       fclass_nm_gt_p_p_f_i9},
{"fclass.nm.le \\p,\\p=\\f,\\i9",       fclass_nm_le_p_p_f_i9},
{"fclass.nm.lt \\p,\\p=\\f,\\i9",       fclass_nm_lt_p_p_f_i9},
{"fclass.nm.neq \\p,\\p=\\f,\\i9",       fclass_nm_neq_p_p_f_i9},
{"fclass.nm.nge \\p,\\p=\\f,\\i9",       fclass_nm_nge_p_p_f_i9},
{"fclass.nm.ngt \\p,\\p=\\f,\\i9",       fclass_nm_ngt_p_p_f_i9},
{"fclass.nm.nlt \\p,\\p=\\f,\\i9",       fclass_nm_nlt_p_p_f_i9},
{"fclass.nm.ord \\p,\\p=\\f,\\i9",       fclass_nm_ord_p_p_f_i9},
{"fclass.nm.unord \\p,\\p=\\f,\\i9",       fclass_nm_unord_p_p_f_i9},
{"fclass.ord \\p,\\p=\\f,\\i9",       fclass_ord_p_p_f_i9},
{"fclass.unc.eq \\p,\\p=\\f,\\i9",       fclass_unc_eq_p_p_f_i9},
{"fclass.unc.ge \\p,\\p=\\f,\\i9",       fclass_unc_ge_p_p_f_i9},
{"fclass.unc.gt \\p,\\p=\\f,\\i9",       fclass_unc_gt_p_p_f_i9},
{"fclass.unc.le \\p,\\p=\\f,\\i9",       fclass_unc_le_p_p_f_i9},
{"fclass.unc.lt \\p,\\p=\\f,\\i9",       fclass_unc_lt_p_p_f_i9},
{"fclass.unc.neq \\p,\\p=\\f,\\i9",       fclass_unc_neq_p_p_f_i9},
{"fclass.unc.nge \\p,\\p=\\f,\\i9",       fclass_unc_nge_p_p_f_i9},
{"fclass.unc.ngt \\p,\\p=\\f,\\i9",       fclass_unc_ngt_p_p_f_i9},
{"fclass.unc.nlt \\p,\\p=\\f,\\i9",       fclass_unc_nlt_p_p_f_i9},
{"fclass.unc.ord \\p,\\p=\\f,\\i9",       fclass_unc_ord_p_p_f_i9},
{"fclass.unc.unord \\p,\\p=\\f,\\i9",       fclass_unc_unord_p_p_f_i9},
{"fclass.unord \\p,\\p=\\f,\\i9",       fclass_unord_p_p_f_i9},
{"fclrf",       fclrf},
{"fclrf.s0",       fclrf_s0},
{"fclrf.s1",       fclrf_s1},
{"fclrf.s2",       fclrf_s2},
{"fclrf.s3",       fclrf_s3},
{"fcmp.eq \\p,\\p=\\f,\\f",       fcmp_eq_p_p_f_f},
{"fcmp.eq.s0 \\p,\\p=\\f,\\f",       fcmp_eq_s0_p_p_f_f},
{"fcmp.eq.s1 \\p,\\p=\\f,\\f",       fcmp_eq_s1_p_p_f_f},
{"fcmp.eq.s2 \\p,\\p=\\f,\\f",       fcmp_eq_s2_p_p_f_f},
{"fcmp.eq.s3 \\p,\\p=\\f,\\f",       fcmp_eq_s3_p_p_f_f},
{"fcmp.eq.unc \\p,\\p=\\f,\\f",       fcmp_eq_unc_p_p_f_f},
{"fcmp.eq.unc.s0 \\p,\\p=\\f,\\f",       fcmp_eq_unc_s0_p_p_f_f},
{"fcmp.eq.unc.s1 \\p,\\p=\\f,\\f",       fcmp_eq_unc_s1_p_p_f_f},
{"fcmp.eq.unc.s2 \\p,\\p=\\f,\\f",       fcmp_eq_unc_s2_p_p_f_f},
{"fcmp.eq.unc.s3 \\p,\\p=\\f,\\f",       fcmp_eq_unc_s3_p_p_f_f},
{"fcmp.ge \\p,\\p=\\f,\\f",       fcmp_ge_p_p_f_f},
{"fcmp.ge.s0 \\p,\\p=\\f,\\f",       fcmp_ge_s0_p_p_f_f},
{"fcmp.ge.s1 \\p,\\p=\\f,\\f",       fcmp_ge_s1_p_p_f_f},
{"fcmp.ge.s2 \\p,\\p=\\f,\\f",       fcmp_ge_s2_p_p_f_f},
{"fcmp.ge.s3 \\p,\\p=\\f,\\f",       fcmp_ge_s3_p_p_f_f},
{"fcmp.ge.unc \\p,\\p=\\f,\\f",       fcmp_ge_unc_p_p_f_f},
{"fcmp.ge.unc.s0 \\p,\\p=\\f,\\f",       fcmp_ge_unc_s0_p_p_f_f},
{"fcmp.ge.unc.s1 \\p,\\p=\\f,\\f",       fcmp_ge_unc_s1_p_p_f_f},
{"fcmp.ge.unc.s2 \\p,\\p=\\f,\\f",       fcmp_ge_unc_s2_p_p_f_f},
{"fcmp.ge.unc.s3 \\p,\\p=\\f,\\f",       fcmp_ge_unc_s3_p_p_f_f},
{"fcmp.gt \\p,\\p=\\f,\\f",       fcmp_gt_p_p_f_f},
{"fcmp.gt.s0 \\p,\\p=\\f,\\f",       fcmp_gt_s0_p_p_f_f},
{"fcmp.gt.s1 \\p,\\p=\\f,\\f",       fcmp_gt_s1_p_p_f_f},
{"fcmp.gt.s2 \\p,\\p=\\f,\\f",       fcmp_gt_s2_p_p_f_f},
{"fcmp.gt.s3 \\p,\\p=\\f,\\f",       fcmp_gt_s3_p_p_f_f},
{"fcmp.gt.unc \\p,\\p=\\f,\\f",       fcmp_gt_unc_p_p_f_f},
{"fcmp.gt.unc.s0 \\p,\\p=\\f,\\f",       fcmp_gt_unc_s0_p_p_f_f},
{"fcmp.gt.unc.s1 \\p,\\p=\\f,\\f",       fcmp_gt_unc_s1_p_p_f_f},
{"fcmp.gt.unc.s2 \\p,\\p=\\f,\\f",       fcmp_gt_unc_s2_p_p_f_f},
{"fcmp.gt.unc.s3 \\p,\\p=\\f,\\f",       fcmp_gt_unc_s3_p_p_f_f},
{"fcmp.le \\p,\\p=\\f,\\f",       fcmp_le_p_p_f_f},
{"fcmp.le.s0 \\p,\\p=\\f,\\f",       fcmp_le_s0_p_p_f_f},
{"fcmp.le.s1 \\p,\\p=\\f,\\f",       fcmp_le_s1_p_p_f_f},
{"fcmp.le.s2 \\p,\\p=\\f,\\f",       fcmp_le_s2_p_p_f_f},
{"fcmp.le.s3 \\p,\\p=\\f,\\f",       fcmp_le_s3_p_p_f_f},
{"fcmp.le.unc \\p,\\p=\\f,\\f",       fcmp_le_unc_p_p_f_f},
{"fcmp.le.unc.s0 \\p,\\p=\\f,\\f",       fcmp_le_unc_s0_p_p_f_f},
{"fcmp.le.unc.s1 \\p,\\p=\\f,\\f",       fcmp_le_unc_s1_p_p_f_f},
{"fcmp.le.unc.s2 \\p,\\p=\\f,\\f",       fcmp_le_unc_s2_p_p_f_f},
{"fcmp.le.unc.s3 \\p,\\p=\\f,\\f",       fcmp_le_unc_s3_p_p_f_f},
{"fcmp.lt \\p,\\p=\\f,\\f",       fcmp_lt_p_p_f_f},
{"fcmp.lt.s0 \\p,\\p=\\f,\\f",       fcmp_lt_s0_p_p_f_f},
{"fcmp.lt.s1 \\p,\\p=\\f,\\f",       fcmp_lt_s1_p_p_f_f},
{"fcmp.lt.s2 \\p,\\p=\\f,\\f",       fcmp_lt_s2_p_p_f_f},
{"fcmp.lt.s3 \\p,\\p=\\f,\\f",       fcmp_lt_s3_p_p_f_f},
{"fcmp.lt.unc \\p,\\p=\\f,\\f",       fcmp_lt_unc_p_p_f_f},
{"fcmp.lt.unc.s0 \\p,\\p=\\f,\\f",       fcmp_lt_unc_s0_p_p_f_f},
{"fcmp.lt.unc.s1 \\p,\\p=\\f,\\f",       fcmp_lt_unc_s1_p_p_f_f},
{"fcmp.lt.unc.s2 \\p,\\p=\\f,\\f",       fcmp_lt_unc_s2_p_p_f_f},
{"fcmp.lt.unc.s3 \\p,\\p=\\f,\\f",       fcmp_lt_unc_s3_p_p_f_f},
{"fcmp.neq \\p,\\p=\\f,\\f",       fcmp_neq_p_p_f_f},
{"fcmp.neq.s0 \\p,\\p=\\f,\\f",       fcmp_neq_s0_p_p_f_f},
{"fcmp.neq.s1 \\p,\\p=\\f,\\f",       fcmp_neq_s1_p_p_f_f},
{"fcmp.neq.s2 \\p,\\p=\\f,\\f",       fcmp_neq_s2_p_p_f_f},
{"fcmp.neq.s3 \\p,\\p=\\f,\\f",       fcmp_neq_s3_p_p_f_f},
{"fcmp.neq.unc \\p,\\p=\\f,\\f",       fcmp_neq_unc_p_p_f_f},
{"fcmp.neq.unc.s0 \\p,\\p=\\f,\\f",       fcmp_neq_unc_s0_p_p_f_f},
{"fcmp.neq.unc.s1 \\p,\\p=\\f,\\f",       fcmp_neq_unc_s1_p_p_f_f},
{"fcmp.neq.unc.s2 \\p,\\p=\\f,\\f",       fcmp_neq_unc_s2_p_p_f_f},
{"fcmp.neq.unc.s3 \\p,\\p=\\f,\\f",       fcmp_neq_unc_s3_p_p_f_f},
{"fcmp.nge \\p,\\p=\\f,\\f",       fcmp_nge_p_p_f_f},
{"fcmp.nge.s0 \\p,\\p=\\f,\\f",       fcmp_nge_s0_p_p_f_f},
{"fcmp.nge.s1 \\p,\\p=\\f,\\f",       fcmp_nge_s1_p_p_f_f},
{"fcmp.nge.s2 \\p,\\p=\\f,\\f",       fcmp_nge_s2_p_p_f_f},
{"fcmp.nge.s3 \\p,\\p=\\f,\\f",       fcmp_nge_s3_p_p_f_f},
{"fcmp.nge.unc \\p,\\p=\\f,\\f",       fcmp_nge_unc_p_p_f_f},
{"fcmp.nge.unc.s0 \\p,\\p=\\f,\\f",       fcmp_nge_unc_s0_p_p_f_f},
{"fcmp.nge.unc.s1 \\p,\\p=\\f,\\f",       fcmp_nge_unc_s1_p_p_f_f},
{"fcmp.nge.unc.s2 \\p,\\p=\\f,\\f",       fcmp_nge_unc_s2_p_p_f_f},
{"fcmp.nge.unc.s3 \\p,\\p=\\f,\\f",       fcmp_nge_unc_s3_p_p_f_f},
{"fcmp.ngt \\p,\\p=\\f,\\f",       fcmp_ngt_p_p_f_f},
{"fcmp.ngt.s0 \\p,\\p=\\f,\\f",       fcmp_ngt_s0_p_p_f_f},
{"fcmp.ngt.s1 \\p,\\p=\\f,\\f",       fcmp_ngt_s1_p_p_f_f},
{"fcmp.ngt.s2 \\p,\\p=\\f,\\f",       fcmp_ngt_s2_p_p_f_f},
{"fcmp.ngt.s3 \\p,\\p=\\f,\\f",       fcmp_ngt_s3_p_p_f_f},
{"fcmp.ngt.unc \\p,\\p=\\f,\\f",       fcmp_ngt_unc_p_p_f_f},
{"fcmp.ngt.unc.s0 \\p,\\p=\\f,\\f",       fcmp_ngt_unc_s0_p_p_f_f},
{"fcmp.ngt.unc.s1 \\p,\\p=\\f,\\f",       fcmp_ngt_unc_s1_p_p_f_f},
{"fcmp.ngt.unc.s2 \\p,\\p=\\f,\\f",       fcmp_ngt_unc_s2_p_p_f_f},
{"fcmp.ngt.unc.s3 \\p,\\p=\\f,\\f",       fcmp_ngt_unc_s3_p_p_f_f},
{"fcmp.nlt \\p,\\p=\\f,\\f",       fcmp_nlt_p_p_f_f},
{"fcmp.nlt.s0 \\p,\\p=\\f,\\f",       fcmp_nlt_s0_p_p_f_f},
{"fcmp.nlt.s1 \\p,\\p=\\f,\\f",       fcmp_nlt_s1_p_p_f_f},
{"fcmp.nlt.s2 \\p,\\p=\\f,\\f",       fcmp_nlt_s2_p_p_f_f},
{"fcmp.nlt.s3 \\p,\\p=\\f,\\f",       fcmp_nlt_s3_p_p_f_f},
{"fcmp.nlt.unc \\p,\\p=\\f,\\f",       fcmp_nlt_unc_p_p_f_f},
{"fcmp.nlt.unc.s0 \\p,\\p=\\f,\\f",       fcmp_nlt_unc_s0_p_p_f_f},
{"fcmp.nlt.unc.s1 \\p,\\p=\\f,\\f",       fcmp_nlt_unc_s1_p_p_f_f},
{"fcmp.nlt.unc.s2 \\p,\\p=\\f,\\f",       fcmp_nlt_unc_s2_p_p_f_f},
{"fcmp.nlt.unc.s3 \\p,\\p=\\f,\\f",       fcmp_nlt_unc_s3_p_p_f_f},
{"fcmp.ord \\p,\\p=\\f,\\f",       fcmp_ord_p_p_f_f},
{"fcmp.ord.s0 \\p,\\p=\\f,\\f",       fcmp_ord_s0_p_p_f_f},
{"fcmp.ord.s1 \\p,\\p=\\f,\\f",       fcmp_ord_s1_p_p_f_f},
{"fcmp.ord.s2 \\p,\\p=\\f,\\f",       fcmp_ord_s2_p_p_f_f},
{"fcmp.ord.s3 \\p,\\p=\\f,\\f",       fcmp_ord_s3_p_p_f_f},
{"fcmp.ord.unc \\p,\\p=\\f,\\f",       fcmp_ord_unc_p_p_f_f},
{"fcmp.ord.unc.s0 \\p,\\p=\\f,\\f",       fcmp_ord_unc_s0_p_p_f_f},
{"fcmp.ord.unc.s1 \\p,\\p=\\f,\\f",       fcmp_ord_unc_s1_p_p_f_f},
{"fcmp.ord.unc.s2 \\p,\\p=\\f,\\f",       fcmp_ord_unc_s2_p_p_f_f},
{"fcmp.ord.unc.s3 \\p,\\p=\\f,\\f",       fcmp_ord_unc_s3_p_p_f_f},
{"fcmp.unord \\p,\\p=\\f,\\f",       fcmp_unord_p_p_f_f},
{"fcmp.unord.s0 \\p,\\p=\\f,\\f",       fcmp_unord_s0_p_p_f_f},
{"fcmp.unord.s1 \\p,\\p=\\f,\\f",       fcmp_unord_s1_p_p_f_f},
{"fcmp.unord.s2 \\p,\\p=\\f,\\f",       fcmp_unord_s2_p_p_f_f},
{"fcmp.unord.s3 \\p,\\p=\\f,\\f",       fcmp_unord_s3_p_p_f_f},
{"fcmp.unord.unc \\p,\\p=\\f,\\f",       fcmp_unord_unc_p_p_f_f},
{"fcmp.unord.unc.s0 \\p,\\p=\\f,\\f",       fcmp_unord_unc_s0_p_p_f_f},
{"fcmp.unord.unc.s1 \\p,\\p=\\f,\\f",       fcmp_unord_unc_s1_p_p_f_f},
{"fcmp.unord.unc.s2 \\p,\\p=\\f,\\f",       fcmp_unord_unc_s2_p_p_f_f},
{"fcmp.unord.unc.s3 \\p,\\p=\\f,\\f",       fcmp_unord_unc_s3_p_p_f_f},
{"fcvt.fx \\f=\\f",       fcvt_fx_f_f},
{"fcvt.fx.s0 \\f=\\f",       fcvt_fx_s0_f_f},
{"fcvt.fx.s1 \\f=\\f",       fcvt_fx_s1_f_f},
{"fcvt.fx.s2 \\f=\\f",       fcvt_fx_s2_f_f},
{"fcvt.fx.s3 \\f=\\f",       fcvt_fx_s3_f_f},
{"fcvt.fx.trunc \\f=\\f",       fcvt_fx_trunc_f_f},
{"fcvt.fx.trunc.s0 \\f=\\f",       fcvt_fx_trunc_s0_f_f},
{"fcvt.fx.trunc.s1 \\f=\\f",       fcvt_fx_trunc_s1_f_f},
{"fcvt.fx.trunc.s2 \\f=\\f",       fcvt_fx_trunc_s2_f_f},
{"fcvt.fx.trunc.s3 \\f=\\f",       fcvt_fx_trunc_s3_f_f},
{"fcvt.fxu \\f=\\f",       fcvt_fxu_f_f},
{"fcvt.fxu.s0 \\f=\\f",       fcvt_fxu_s0_f_f},
{"fcvt.fxu.s1 \\f=\\f",       fcvt_fxu_s1_f_f},
{"fcvt.fxu.s2 \\f=\\f",       fcvt_fxu_s2_f_f},
{"fcvt.fxu.s3 \\f=\\f",       fcvt_fxu_s3_f_f},
{"fcvt.fxu.trunc \\f=\\f",       fcvt_fxu_trunc_f_f},
{"fcvt.fxu.trunc.s0 \\f=\\f",       fcvt_fxu_trunc_s0_f_f},
{"fcvt.fxu.trunc.s1 \\f=\\f",       fcvt_fxu_trunc_s1_f_f},
{"fcvt.fxu.trunc.s2 \\f=\\f",       fcvt_fxu_trunc_s2_f_f},
{"fcvt.fxu.trunc.s3 \\f=\\f",       fcvt_fxu_trunc_s3_f_f},
{"fcvt.xf \\f=\\f",       fcvt_xf_f_f},
{"fcvt.xuf \\f=\\f",       fcvt_xuf_f_f},
{"fcvt.xuf.d \\f=\\f",       fcvt_xuf_d_f_f},
{"fcvt.xuf.d.s0 \\f=\\f",       fcvt_xuf_d_s0_f_f},
{"fcvt.xuf.d.s1 \\f=\\f",       fcvt_xuf_d_s1_f_f},
{"fcvt.xuf.d.s2 \\f=\\f",       fcvt_xuf_d_s2_f_f},
{"fcvt.xuf.d.s3 \\f=\\f",       fcvt_xuf_d_s3_f_f},
{"fcvt.xuf.s \\f=\\f",       fcvt_xuf_s_f_f},
{"fcvt.xuf.s0 \\f=\\f",       fcvt_xuf_s0_f_f},
{"fcvt.xuf.s1 \\f=\\f",       fcvt_xuf_s1_f_f},
{"fcvt.xuf.s2 \\f=\\f",       fcvt_xuf_s2_f_f},
{"fcvt.xuf.s3 \\f=\\f",       fcvt_xuf_s3_f_f},
{"fcvt.xuf.s.s0 \\f=\\f",       fcvt_xuf_s_s0_f_f},
{"fcvt.xuf.s.s1 \\f=\\f",       fcvt_xuf_s_s1_f_f},
{"fcvt.xuf.s.s2 \\f=\\f",       fcvt_xuf_s_s2_f_f},
{"fcvt.xuf.s.s3 \\f=\\f",       fcvt_xuf_s_s3_f_f},
{"fetchadd4.acq \\r=[\\r],\\u3",       fetchadd4_acq_r_r_u3},
{"fetchadd4.acq.nt1 \\r=[\\r],\\u3",       fetchadd4_acq_nt1_r_r_u3},
{"fetchadd4.acq.nta \\r=[\\r],\\u3",       fetchadd4_acq_nta_r_r_u3},
{"fetchadd4.rel \\r=[\\r],\\u3",       fetchadd4_rel_r_r_u3},
{"fetchadd4.rel.nt1 \\r=[\\r],\\u3",       fetchadd4_rel_nt1_r_r_u3},
{"fetchadd4.rel.nta \\r=[\\r],\\u3",       fetchadd4_rel_nta_r_r_u3},
{"fetchadd8.acq \\r=[\\r],\\u3",       fetchadd8_acq_r_r_u3},
{"fetchadd8.acq.nt1 \\r=[\\r],\\u3",       fetchadd8_acq_nt1_r_r_u3},
{"fetchadd8.acq.nta \\r=[\\r],\\u3",       fetchadd8_acq_nta_r_r_u3},
{"fetchadd8.rel \\r=[\\r],\\u3",       fetchadd8_rel_r_r_u3},
{"fetchadd8.rel.nt1 \\r=[\\r],\\u3",       fetchadd8_rel_nt1_r_r_u3},
{"fetchadd8.rel.nta \\r=[\\r],\\u3",       fetchadd8_rel_nta_r_r_u3},
{"flushrs",       flushrs},
{"fma \\f=\\f,\\f,\\f",       fma_f_f_f_f},
{"fma.d \\f=\\f,\\f,\\f",       fma_d_f_f_f_f},
{"fma.d.s0 \\f=\\f,\\f,\\f",       fma_d_s0_f_f_f_f},
{"fma.d.s1 \\f=\\f,\\f,\\f",       fma_d_s1_f_f_f_f},
{"fma.d.s2 \\f=\\f,\\f,\\f",       fma_d_s2_f_f_f_f},
{"fma.d.s3 \\f=\\f,\\f,\\f",       fma_d_s3_f_f_f_f},
{"fma.s \\f=\\f,\\f,\\f",       fma_s_f_f_f_f},
{"fma.s0 \\f=\\f,\\f,\\f",       fma_s0_f_f_f_f},
{"fma.s1 \\f=\\f,\\f,\\f",       fma_s1_f_f_f_f},
{"fma.s2 \\f=\\f,\\f,\\f",       fma_s2_f_f_f_f},
{"fma.s3 \\f=\\f,\\f,\\f",       fma_s3_f_f_f_f},
{"fma.s.s0 \\f=\\f,\\f,\\f",       fma_s_s0_f_f_f_f},
{"fma.s.s1 \\f=\\f,\\f,\\f",       fma_s_s1_f_f_f_f},
{"fma.s.s2 \\f=\\f,\\f,\\f",       fma_s_s2_f_f_f_f},
{"fma.s.s3 \\f=\\f,\\f,\\f",       fma_s_s3_f_f_f_f},
{"fmax \\f=\\f,\\f",       fmax_f_f_f},
{"fmax.s0 \\f=\\f,\\f",       fmax_s0_f_f_f},
{"fmax.s1 \\f=\\f,\\f",       fmax_s1_f_f_f},
{"fmax.s2 \\f=\\f,\\f",       fmax_s2_f_f_f},
{"fmax.s3 \\f=\\f,\\f",       fmax_s3_f_f_f},
{"fmerge.ns \\f=\\f,\\f",       fmerge_ns_f_f_f},
{"fmerge.s \\f=\\f,\\f",       fmerge_s_f_f_f},
{"fmerge.se \\f=\\f,\\f",       fmerge_se_f_f_f},
{"fmin \\f=\\f,\\f",       fmin_f_f_f},
{"fmin.s0 \\f=\\f,\\f",       fmin_s0_f_f_f},
{"fmin.s1 \\f=\\f,\\f",       fmin_s1_f_f_f},
{"fmin.s2 \\f=\\f,\\f",       fmin_s2_f_f_f},
{"fmin.s3 \\f=\\f,\\f",       fmin_s3_f_f_f},
{"fmix.l \\f=\\f,\\f",       fmix_l_f_f_f},
{"fmix.lr \\f=\\f,\\f",       fmix_lr_f_f_f},
{"fmix.r \\f=\\f,\\f",       fmix_r_f_f_f},
{"fmpy \\f=\\f,\\f",       fmpy_f_f_f},
{"fmpy.d \\f=\\f,\\f",       fmpy_d_f_f_f},
{"fmpy.d.s0 \\f=\\f,\\f",       fmpy_d_s0_f_f_f},
{"fmpy.d.s1 \\f=\\f,\\f",       fmpy_d_s1_f_f_f},
{"fmpy.d.s2 \\f=\\f,\\f",       fmpy_d_s2_f_f_f},
{"fmpy.d.s3 \\f=\\f,\\f",       fmpy_d_s3_f_f_f},
{"fmpy.s \\f=\\f,\\f",       fmpy_s_f_f_f},
{"fmpy.s0 \\f=\\f,\\f",       fmpy_s0_f_f_f},
{"fmpy.s1 \\f=\\f,\\f",       fmpy_s1_f_f_f},
{"fmpy.s2 \\f=\\f,\\f",       fmpy_s2_f_f_f},
{"fmpy.s3 \\f=\\f,\\f",       fmpy_s3_f_f_f},
{"fmpy.s.s0 \\f=\\f,\\f",       fmpy_s_s0_f_f_f},
{"fmpy.s.s1 \\f=\\f,\\f",       fmpy_s_s1_f_f_f},
{"fmpy.s.s2 \\f=\\f,\\f",       fmpy_s_s2_f_f_f},
{"fmpy.s.s3 \\f=\\f,\\f",       fmpy_s_s3_f_f_f},
{"fms \\f=\\f,\\f,\\f",       fms_f_f_f_f},
{"fms.d \\f=\\f,\\f,\\f",       fms_d_f_f_f_f},
{"fms.d.s0 \\f=\\f,\\f,\\f",       fms_d_s0_f_f_f_f},
{"fms.d.s1 \\f=\\f,\\f,\\f",       fms_d_s1_f_f_f_f},
{"fms.d.s2 \\f=\\f,\\f,\\f",       fms_d_s2_f_f_f_f},
{"fms.d.s3 \\f=\\f,\\f,\\f",       fms_d_s3_f_f_f_f},
{"fms.s \\f=\\f,\\f,\\f",       fms_s_f_f_f_f},
{"fms.s0 \\f=\\f,\\f,\\f",       fms_s0_f_f_f_f},
{"fms.s1 \\f=\\f,\\f,\\f",       fms_s1_f_f_f_f},
{"fms.s2 \\f=\\f,\\f,\\f",       fms_s2_f_f_f_f},
{"fms.s3 \\f=\\f,\\f,\\f",       fms_s3_f_f_f_f},
{"fms.s.s0 \\f=\\f,\\f,\\f",       fms_s_s0_f_f_f_f},
{"fms.s.s1 \\f=\\f,\\f,\\f",       fms_s_s1_f_f_f_f},
{"fms.s.s2 \\f=\\f,\\f,\\f",       fms_s_s2_f_f_f_f},
{"fms.s.s3 \\f=\\f,\\f,\\f",       fms_s_s3_f_f_f_f},
{"fneg \\f=\\f",       fneg_f_f},
{"fnegabs \\f=\\f",       fnegabs_f_f},
{"fnma \\f=\\f,\\f,\\f",       fnma_f_f_f_f},
{"fnma \\f=\\f,\\f,\\f",       fnma_f_f_f_f},
{"fnma.d \\f=\\f,\\f,\\f",       fnma_d_f_f_f_f},
{"fnma.d.s0 \\f=\\f,\\f,\\f",       fnma_d_s0_f_f_f_f},
{"fnma.d.s1 \\f=\\f,\\f,\\f",       fnma_d_s1_f_f_f_f},
{"fnma.d.s2 \\f=\\f,\\f,\\f",       fnma_d_s2_f_f_f_f},
{"fnma.d.s3 \\f=\\f,\\f,\\f",       fnma_d_s3_f_f_f_f},
{"fnma.s \\f=\\f,\\f,\\f",       fnma_s_f_f_f_f},
{"fnma.s0 \\f=\\f,\\f,\\f",       fnma_s0_f_f_f_f},
{"fnma.s0 \\f=\\f,\\f,\\f",       fnma_s0_f_f_f_f},
{"fnma.s1 \\f=\\f,\\f,\\f",       fnma_s1_f_f_f_f},
{"fnma.s1 \\f=\\f,\\f,\\f",       fnma_s1_f_f_f_f},
{"fnma.s2 \\f=\\f,\\f,\\f",       fnma_s2_f_f_f_f},
{"fnma.s2 \\f=\\f,\\f,\\f",       fnma_s2_f_f_f_f},
{"fnma.s3 \\f=\\f,\\f,\\f",       fnma_s3_f_f_f_f},
{"fnma.s3 \\f=\\f,\\f,\\f",       fnma_s3_f_f_f_f},
{"fnma.s.s0 \\f=\\f,\\f,\\f",       fnma_s_s0_f_f_f_f},
{"fnma.s.s1 \\f=\\f,\\f,\\f",       fnma_s_s1_f_f_f_f},
{"fnma.s.s2 \\f=\\f,\\f,\\f",       fnma_s_s2_f_f_f_f},
{"fnma.s.s3 \\f=\\f,\\f,\\f",       fnma_s_s3_f_f_f_f},
{"fnmpy \\f=\\f,\\f",       fnmpy_f_f_f},
{"fnmpy \\f=\\f,\\f",       fnmpy_f_f_f},
{"fnmpy.d \\f=\\f,\\f",       fnmpy_d_f_f_f},
{"fnmpy.d.s0 \\f=\\f,\\f",       fnmpy_d_s0_f_f_f},
{"fnmpy.d.s1 \\f=\\f,\\f",       fnmpy_d_s1_f_f_f},
{"fnmpy.d.s2 \\f=\\f,\\f",       fnmpy_d_s2_f_f_f},
{"fnmpy.d.s3 \\f=\\f,\\f",       fnmpy_d_s3_f_f_f},
{"fnmpy.s \\f=\\f,\\f",       fnmpy_s_f_f_f},
{"fnmpy.s0 \\f=\\f,\\f",       fnmpy_s0_f_f_f},
{"fnmpy.s0 \\f=\\f,\\f",       fnmpy_s0_f_f_f},
{"fnmpy.s1 \\f=\\f,\\f",       fnmpy_s1_f_f_f},
{"fnmpy.s1 \\f=\\f,\\f",       fnmpy_s1_f_f_f},
{"fnmpy.s2 \\f=\\f,\\f",       fnmpy_s2_f_f_f},
{"fnmpy.s2 \\f=\\f,\\f",       fnmpy_s2_f_f_f},
{"fnmpy.s3 \\f=\\f,\\f",       fnmpy_s3_f_f_f},
{"fnmpy.s3 \\f=\\f,\\f",       fnmpy_s3_f_f_f},
{"fnmpy.s.s0 \\f=\\f,\\f",       fnmpy_s_s0_f_f_f},
{"fnmpy.s.s1 \\f=\\f,\\f",       fnmpy_s_s1_f_f_f},
{"fnmpy.s.s2 \\f=\\f,\\f",       fnmpy_s_s2_f_f_f},
{"fnmpy.s.s3 \\f=\\f,\\f",       fnmpy_s_s3_f_f_f},
{"fnorm \\f=\\f",       fnorm_f_f},
{"fnorm.d \\f=\\f",       fnorm_d_f_f},
{"fnorm.d.s0 \\f=\\f",       fnorm_d_s0_f_f},
{"fnorm.d.s1 \\f=\\f",       fnorm_d_s1_f_f},
{"fnorm.d.s2 \\f=\\f",       fnorm_d_s2_f_f},
{"fnorm.d.s3 \\f=\\f",       fnorm_d_s3_f_f},
{"fnorm.s \\f=\\f",       fnorm_s_f_f},
{"fnorm.s0 \\f=\\f",       fnorm_s0_f_f},
{"fnorm.s1 \\f=\\f",       fnorm_s1_f_f},
{"fnorm.s2 \\f=\\f",       fnorm_s2_f_f},
{"fnorm.s3 \\f=\\f",       fnorm_s3_f_f},
{"fnorm.s.s0 \\f=\\f",       fnorm_s_s0_f_f},
{"fnorm.s.s1 \\f=\\f",       fnorm_s_s1_f_f},
{"fnorm.s.s2 \\f=\\f",       fnorm_s_s2_f_f},
{"fnorm.s.s3 \\f=\\f",       fnorm_s_s3_f_f},
{"for \\f=\\f,\\f",       for_f_f_f},
{"fpabs \\f=\\f",       fpabs_f_f},
{"fpack \\f=\\f,\\f",       fpack_f_f_f},
{"fpamax \\f=\\f,\\f",       fpamax_f_f_f},
{"fpamax.s0 \\f=\\f,\\f",       fpamax_s0_f_f_f},
{"fpamax.s1 \\f=\\f,\\f",       fpamax_s1_f_f_f},
{"fpamax.s2 \\f=\\f,\\f",       fpamax_s2_f_f_f},
{"fpamax.s3 \\f=\\f,\\f",       fpamax_s3_f_f_f},
{"fpamin \\f=\\f,\\f",       fpamin_f_f_f},
{"fpamin.s0 \\f=\\f,\\f",       fpamin_s0_f_f_f},
{"fpamin.s1 \\f=\\f,\\f",       fpamin_s1_f_f_f},
{"fpamin.s2 \\f=\\f,\\f",       fpamin_s2_f_f_f},
{"fpamin.s3 \\f=\\f,\\f",       fpamin_s3_f_f_f},
{"fpcmp.eq \\f=\\f,\\f",       fpcmp_eq_f_f_f},
{"fpcmp.eq.s0 \\f=\\f,\\f",       fpcmp_eq_s0_f_f_f},
{"fpcmp.eq.s1 \\f=\\f,\\f",       fpcmp_eq_s1_f_f_f},
{"fpcmp.eq.s2 \\f=\\f,\\f",       fpcmp_eq_s2_f_f_f},
{"fpcmp.eq.s3 \\f=\\f,\\f",       fpcmp_eq_s3_f_f_f},
{"fpcmp.ge \\f=\\f,\\f",       fpcmp_ge_f_f_f},
{"fpcmp.ge.s0 \\f=\\f,\\f",       fpcmp_ge_s0_f_f_f},
{"fpcmp.ge.s1 \\f=\\f,\\f",       fpcmp_ge_s1_f_f_f},
{"fpcmp.ge.s2 \\f=\\f,\\f",       fpcmp_ge_s2_f_f_f},
{"fpcmp.ge.s3 \\f=\\f,\\f",       fpcmp_ge_s3_f_f_f},
{"fpcmp.gt \\f=\\f,\\f",       fpcmp_gt_f_f_f},
{"fpcmp.gt.s0 \\f=\\f,\\f",       fpcmp_gt_s0_f_f_f},
{"fpcmp.gt.s1 \\f=\\f,\\f",       fpcmp_gt_s1_f_f_f},
{"fpcmp.gt.s2 \\f=\\f,\\f",       fpcmp_gt_s2_f_f_f},
{"fpcmp.gt.s3 \\f=\\f,\\f",       fpcmp_gt_s3_f_f_f},
{"fpcmp.le \\f=\\f,\\f",       fpcmp_le_f_f_f},
{"fpcmp.le.s0 \\f=\\f,\\f",       fpcmp_le_s0_f_f_f},
{"fpcmp.le.s1 \\f=\\f,\\f",       fpcmp_le_s1_f_f_f},
{"fpcmp.le.s2 \\f=\\f,\\f",       fpcmp_le_s2_f_f_f},
{"fpcmp.le.s3 \\f=\\f,\\f",       fpcmp_le_s3_f_f_f},
{"fpcmp.lt \\f=\\f,\\f",       fpcmp_lt_f_f_f},
{"fpcmp.lt.s0 \\f=\\f,\\f",       fpcmp_lt_s0_f_f_f},
{"fpcmp.lt.s1 \\f=\\f,\\f",       fpcmp_lt_s1_f_f_f},
{"fpcmp.lt.s2 \\f=\\f,\\f",       fpcmp_lt_s2_f_f_f},
{"fpcmp.lt.s3 \\f=\\f,\\f",       fpcmp_lt_s3_f_f_f},
{"fpcmp.neq \\f=\\f,\\f",       fpcmp_neq_f_f_f},
{"fpcmp.neq.s0 \\f=\\f,\\f",       fpcmp_neq_s0_f_f_f},
{"fpcmp.neq.s1 \\f=\\f,\\f",       fpcmp_neq_s1_f_f_f},
{"fpcmp.neq.s2 \\f=\\f,\\f",       fpcmp_neq_s2_f_f_f},
{"fpcmp.neq.s3 \\f=\\f,\\f",       fpcmp_neq_s3_f_f_f},
{"fpcmp.nge \\f=\\f,\\f",       fpcmp_nge_f_f_f},
{"fpcmp.nge.s0 \\f=\\f,\\f",       fpcmp_nge_s0_f_f_f},
{"fpcmp.nge.s1 \\f=\\f,\\f",       fpcmp_nge_s1_f_f_f},
{"fpcmp.nge.s2 \\f=\\f,\\f",       fpcmp_nge_s2_f_f_f},
{"fpcmp.nge.s3 \\f=\\f,\\f",       fpcmp_nge_s3_f_f_f},
{"fpcmp.ngt \\f=\\f,\\f",       fpcmp_ngt_f_f_f},
{"fpcmp.ngt.s0 \\f=\\f,\\f",       fpcmp_ngt_s0_f_f_f},
{"fpcmp.ngt.s1 \\f=\\f,\\f",       fpcmp_ngt_s1_f_f_f},
{"fpcmp.ngt.s2 \\f=\\f,\\f",       fpcmp_ngt_s2_f_f_f},
{"fpcmp.ngt.s3 \\f=\\f,\\f",       fpcmp_ngt_s3_f_f_f},
{"fpcmp.nlt \\f=\\f,\\f",       fpcmp_nlt_f_f_f},
{"fpcmp.nlt.s0 \\f=\\f,\\f",       fpcmp_nlt_s0_f_f_f},
{"fpcmp.nlt.s1 \\f=\\f,\\f",       fpcmp_nlt_s1_f_f_f},
{"fpcmp.nlt.s2 \\f=\\f,\\f",       fpcmp_nlt_s2_f_f_f},
{"fpcmp.nlt.s3 \\f=\\f,\\f",       fpcmp_nlt_s3_f_f_f},
{"fpcmp.ord \\f=\\f,\\f",       fpcmp_ord_f_f_f},
{"fpcmp.ord.s0 \\f=\\f,\\f",       fpcmp_ord_s0_f_f_f},
{"fpcmp.ord.s1 \\f=\\f,\\f",       fpcmp_ord_s1_f_f_f},
{"fpcmp.ord.s2 \\f=\\f,\\f",       fpcmp_ord_s2_f_f_f},
{"fpcmp.ord.s3 \\f=\\f,\\f",       fpcmp_ord_s3_f_f_f},
{"fpcmp.unord \\f=\\f,\\f",       fpcmp_unord_f_f_f},
{"fpcmp.unord.s0 \\f=\\f,\\f",       fpcmp_unord_s0_f_f_f},
{"fpcmp.unord.s1 \\f=\\f,\\f",       fpcmp_unord_s1_f_f_f},
{"fpcmp.unord.s2 \\f=\\f,\\f",       fpcmp_unord_s2_f_f_f},
{"fpcmp.unord.s3 \\f=\\f,\\f",       fpcmp_unord_s3_f_f_f},
{"fpcvt.fx \\f=\\f",       fpcvt_fx_f_f},
{"fpcvt.fx.s0 \\f=\\f",       fpcvt_fx_s0_f_f},
{"fpcvt.fx.s1 \\f=\\f",       fpcvt_fx_s1_f_f},
{"fpcvt.fx.s2 \\f=\\f",       fpcvt_fx_s2_f_f},
{"fpcvt.fx.s3 \\f=\\f",       fpcvt_fx_s3_f_f},
{"fpcvt.fx.trunc \\f=\\f",       fpcvt_fx_trunc_f_f},
{"fpcvt.fx.trunc.s0 \\f=\\f",       fpcvt_fx_trunc_s0_f_f},
{"fpcvt.fx.trunc.s1 \\f=\\f",       fpcvt_fx_trunc_s1_f_f},
{"fpcvt.fx.trunc.s2 \\f=\\f",       fpcvt_fx_trunc_s2_f_f},
{"fpcvt.fx.trunc.s3 \\f=\\f",       fpcvt_fx_trunc_s3_f_f},
{"fpcvt.fxu \\f=\\f",       fpcvt_fxu_f_f},
{"fpcvt.fxu.s0 \\f=\\f",       fpcvt_fxu_s0_f_f},
{"fpcvt.fxu.s1 \\f=\\f",       fpcvt_fxu_s1_f_f},
{"fpcvt.fxu.s2 \\f=\\f",       fpcvt_fxu_s2_f_f},
{"fpcvt.fxu.s3 \\f=\\f",       fpcvt_fxu_s3_f_f},
{"fpcvt.fxu.trunc \\f=\\f",       fpcvt_fxu_trunc_f_f},
{"fpcvt.fxu.trunc.s0 \\f=\\f",       fpcvt_fxu_trunc_s0_f_f},
{"fpcvt.fxu.trunc.s1 \\f=\\f",       fpcvt_fxu_trunc_s1_f_f},
{"fpcvt.fxu.trunc.s2 \\f=\\f",       fpcvt_fxu_trunc_s2_f_f},
{"fpcvt.fxu.trunc.s3 \\f=\\f",       fpcvt_fxu_trunc_s3_f_f},
{"fpma \\f=\\f,\\f,\\f",       fpma_f_f_f_f},
{"fpma.s0 \\f=\\f,\\f,\\f",       fpma_s0_f_f_f_f},
{"fpma.s1 \\f=\\f,\\f,\\f",       fpma_s1_f_f_f_f},
{"fpma.s2 \\f=\\f,\\f,\\f",       fpma_s2_f_f_f_f},
{"fpma.s3 \\f=\\f,\\f,\\f",       fpma_s3_f_f_f_f},
{"fpmax \\f=\\f,\\f",       fpmax_f_f_f},
{"fpmax.s0 \\f=\\f,\\f",       fpmax_s0_f_f_f},
{"fpmax.s1 \\f=\\f,\\f",       fpmax_s1_f_f_f},
{"fpmax.s2 \\f=\\f,\\f",       fpmax_s2_f_f_f},
{"fpmax.s3 \\f=\\f,\\f",       fpmax_s3_f_f_f},
{"fpmerge.ns \\f=\\f,\\f",       fpmerge_ns_f_f_f},
{"fpmerge.s \\f=\\f,\\f",       fpmerge_s_f_f_f},
{"fpmerge.se \\f=\\f,\\f",       fpmerge_se_f_f_f},
{"fpmin \\f=\\f,\\f",       fpmin_f_f_f},
{"fpmin.s0 \\f=\\f,\\f",       fpmin_s0_f_f_f},
{"fpmin.s1 \\f=\\f,\\f",       fpmin_s1_f_f_f},
{"fpmin.s2 \\f=\\f,\\f",       fpmin_s2_f_f_f},
{"fpmin.s3 \\f=\\f,\\f",       fpmin_s3_f_f_f},
{"fpmpy \\f=\\f,\\f",       fpmpy_f_f_f},
{"fpmpy.s0 \\f=\\f,\\f",       fpmpy_s0_f_f_f},
{"fpmpy.s1 \\f=\\f,\\f",       fpmpy_s1_f_f_f},
{"fpmpy.s2 \\f=\\f,\\f",       fpmpy_s2_f_f_f},
{"fpmpy.s3 \\f=\\f,\\f",       fpmpy_s3_f_f_f},
{"fpms \\f=\\f,\\f,\\f",       fpms_f_f_f_f},
{"fpms.s0 \\f=\\f,\\f,\\f",       fpms_s0_f_f_f_f},
{"fpms.s1 \\f=\\f,\\f,\\f",       fpms_s1_f_f_f_f},
{"fpms.s2 \\f=\\f,\\f,\\f",       fpms_s2_f_f_f_f},
{"fpms.s3 \\f=\\f,\\f,\\f",       fpms_s3_f_f_f_f},
{"fpneg \\f=\\f",       fpneg_f_f},
{"fpnegabs \\f=\\f",       fpnegabs_f_f},
{"fprcpa \\f,\\p=\\f,\\f",       fprcpa_f_p_f_f},
{"fprcpa.s0 \\f,\\p=\\f,\\f",       fprcpa_s0_f_p_f_f},
{"fprcpa.s1 \\f,\\p=\\f,\\f",       fprcpa_s1_f_p_f_f},
{"fprcpa.s2 \\f,\\p=\\f,\\f",       fprcpa_s2_f_p_f_f},
{"fprcpa.s3 \\f,\\p=\\f,\\f",       fprcpa_s3_f_p_f_f},
{"fprsqrta \\f,\\p=\\f",       fprsqrta_f_p_f},
{"fprsqrta.s0 \\f,\\p=\\f",       fprsqrta_s0_f_p_f},
{"fprsqrta.s1 \\f,\\p=\\f",       fprsqrta_s1_f_p_f},
{"fprsqrta.s2 \\f,\\p=\\f",       fprsqrta_s2_f_p_f},
{"fprsqrta.s3 \\f,\\p=\\f",       fprsqrta_s3_f_p_f},
{"frcpa \\f,\\p=\\f,\\f",       frcpa_f_p_f_f},
{"frcpa.s0 \\f,\\p=\\f,\\f",       frcpa_s0_f_p_f_f},
{"frcpa.s1 \\f,\\p=\\f,\\f",       frcpa_s1_f_p_f_f},
{"frcpa.s2 \\f,\\p=\\f,\\f",       frcpa_s2_f_p_f_f},
{"frcpa.s3 \\f,\\p=\\f,\\f",       frcpa_s3_f_p_f_f},
{"frsqrta \\f,\\p=\\f",       frsqrta_f_p_f},
{"frsqrta.s0 \\f,\\p=\\f",       frsqrta_s0_f_p_f},
{"frsqrta.s1 \\f,\\p=\\f",       frsqrta_s1_f_p_f},
{"frsqrta.s2 \\f,\\p=\\f",       frsqrta_s2_f_p_f},
{"frsqrta.s3 \\f,\\p=\\f",       frsqrta_s3_f_p_f},
{"fselect \\f=\\f,\\f,\\f",       fselect_f_f_f_f},
{"fsetc \\u7,\\u7",       fsetc_u7_u7},
{"fsetc.s0 \\u7,\\u7",       fsetc_s0_u7_u7},
{"fsetc.s1 \\u7,\\u7",       fsetc_s1_u7_u7},
{"fsetc.s2 \\u7,\\u7",       fsetc_s2_u7_u7},
{"fsetc.s3 \\u7,\\u7",       fsetc_s3_u7_u7},
{"fsub \\f=\\f,\\f",       fsub_f_f_f},
{"fsub.d \\f=\\f,\\f",       fsub_d_f_f_f},
{"fsub.d.s0 \\f=\\f,\\f",       fsub_d_s0_f_f_f},
{"fsub.d.s1 \\f=\\f,\\f",       fsub_d_s1_f_f_f},
{"fsub.d.s2 \\f=\\f,\\f",       fsub_d_s2_f_f_f},
{"fsub.d.s3 \\f=\\f,\\f",       fsub_d_s3_f_f_f},
{"fsub.s \\f=\\f,\\f",       fsub_s_f_f_f},
{"fsub.s0 \\f=\\f,\\f",       fsub_s0_f_f_f},
{"fsub.s1 \\f=\\f,\\f",       fsub_s1_f_f_f},
{"fsub.s2 \\f=\\f,\\f",       fsub_s2_f_f_f},
{"fsub.s3 \\f=\\f,\\f",       fsub_s3_f_f_f},
{"fsub.s.s0 \\f=\\f,\\f",       fsub_s_s0_f_f_f},
{"fsub.s.s1 \\f=\\f,\\f",       fsub_s_s1_f_f_f},
{"fsub.s.s2 \\f=\\f,\\f",       fsub_s_s2_f_f_f},
{"fsub.s.s3 \\f=\\f,\\f",       fsub_s_s3_f_f_f},
{"fswap \\f=\\f,\\f",       fswap_f_f_f},
{"fswap.nl \\f=\\f,\\f",       fswap_nl_f_f_f},
{"fswap.nr \\f=\\f,\\f",       fswap_nr_f_f_f},
{"fsxt.l \\f=\\f,\\f",       fsxt_l_f_f_f},
{"fsxt.r \\f=\\f,\\f",       fsxt_r_f_f_f},
{"fxor \\f=\\f,\\f",       fxor_f_f_f},
{"getf.d \\r=\\f",       getf_d_r_f},
{"getf.exp \\r=\\f",       getf_exp_r_f},
{"getf.s \\r=\\f",       getf_s_r_f},
{"getf.sig \\r=\\f",       getf_sig_r_f},
{"invala",       invala},
{"invala.e \\f",       invala_e_f},
{"invala.e \\r",       invala_e_r},
{"ld1 \\r=[\\r]",       ld1_r_r_},
{"ld1 \\r=[\\r],\\i9",       ld1_r_r_i9},
{"ld1 \\r=[\\r],\\r",       ld1_r_r_r},
{"ld1.a \\r=[\\r]",       ld1_a_r_r_},
{"ld1.a \\r=[\\r],\\i9",       ld1_a_r_r_i9},
{"ld1.a \\r=[\\r],\\r",       ld1_a_r_r_r},
{"ld1.acq \\r=[\\r]",       ld1_acq_r_r_},
{"ld1.acq \\r=[\\r],\\i9",       ld1_acq_r_r_i9},
{"ld1.acq \\r=[\\r],\\r",       ld1_acq_r_r_r},
{"ld1.acq.nt1 \\r=[\\r]",       ld1_acq_nt1_r_r_},
{"ld1.acq.nt1 \\r=[\\r],\\i9",       ld1_acq_nt1_r_r_i9},
{"ld1.acq.nt1 \\r=[\\r],\\r",       ld1_acq_nt1_r_r_r},
{"ld1.acq.nta \\r=[\\r]",       ld1_acq_nta_r_r_},
{"ld1.acq.nta \\r=[\\r],\\i9",       ld1_acq_nta_r_r_i9},
{"ld1.acq.nta \\r=[\\r],\\r",       ld1_acq_nta_r_r_r},
{"ld1.a.nt1 \\r=[\\r]",       ld1_a_nt1_r_r_},
{"ld1.a.nt1 \\r=[\\r],\\i9",       ld1_a_nt1_r_r_i9},
{"ld1.a.nt1 \\r=[\\r],\\r",       ld1_a_nt1_r_r_r},
{"ld1.a.nta \\r=[\\r]",       ld1_a_nta_r_r_},
{"ld1.a.nta \\r=[\\r],\\i9",       ld1_a_nta_r_r_i9},
{"ld1.a.nta \\r=[\\r],\\r",       ld1_a_nta_r_r_r},
{"ld1.bias \\r=[\\r]",       ld1_bias_r_r_},
{"ld1.bias \\r=[\\r],\\i9",       ld1_bias_r_r_i9},
{"ld1.bias \\r=[\\r],\\r",       ld1_bias_r_r_r},
{"ld1.bias.nt1 \\r=[\\r]",       ld1_bias_nt1_r_r_},
{"ld1.bias.nt1 \\r=[\\r],\\i9",       ld1_bias_nt1_r_r_i9},
{"ld1.bias.nt1 \\r=[\\r],\\r",       ld1_bias_nt1_r_r_r},
{"ld1.bias.nta \\r=[\\r]",       ld1_bias_nta_r_r_},
{"ld1.bias.nta \\r=[\\r],\\i9",       ld1_bias_nta_r_r_i9},
{"ld1.bias.nta \\r=[\\r],\\r",       ld1_bias_nta_r_r_r},
{"ld1.c.clr \\r=[\\r]",       ld1_c_clr_r_r_},
{"ld1.c.clr \\r=[\\r],\\i9",       ld1_c_clr_r_r_i9},
{"ld1.c.clr \\r=[\\r],\\r",       ld1_c_clr_r_r_r},
{"ld1.c.clr.acq \\r=[\\r]",       ld1_c_clr_acq_r_r_},
{"ld1.c.clr.acq \\r=[\\r],\\i9",       ld1_c_clr_acq_r_r_i9},
{"ld1.c.clr.acq \\r=[\\r],\\r",       ld1_c_clr_acq_r_r_r},
{"ld1.c.clr.acq.nt1 \\r=[\\r]",       ld1_c_clr_acq_nt1_r_r_},
{"ld1.c.clr.acq.nt1 \\r=[\\r],\\i9",       ld1_c_clr_acq_nt1_r_r_i9},
{"ld1.c.clr.acq.nt1 \\r=[\\r],\\r",       ld1_c_clr_acq_nt1_r_r_r},
{"ld1.c.clr.acq.nta \\r=[\\r]",       ld1_c_clr_acq_nta_r_r_},
{"ld1.c.clr.acq.nta \\r=[\\r],\\i9",       ld1_c_clr_acq_nta_r_r_i9},
{"ld1.c.clr.acq.nta \\r=[\\r],\\r",       ld1_c_clr_acq_nta_r_r_r},
{"ld1.c.clr.nt1 \\r=[\\r]",       ld1_c_clr_nt1_r_r_},
{"ld1.c.clr.nt1 \\r=[\\r],\\i9",       ld1_c_clr_nt1_r_r_i9},
{"ld1.c.clr.nt1 \\r=[\\r],\\r",       ld1_c_clr_nt1_r_r_r},
{"ld1.c.clr.nta \\r=[\\r]",       ld1_c_clr_nta_r_r_},
{"ld1.c.clr.nta \\r=[\\r],\\i9",       ld1_c_clr_nta_r_r_i9},
{"ld1.c.clr.nta \\r=[\\r],\\r",       ld1_c_clr_nta_r_r_r},
{"ld1.c.nc \\r=[\\r]",       ld1_c_nc_r_r_},
{"ld1.c.nc \\r=[\\r],\\i9",       ld1_c_nc_r_r_i9},
{"ld1.c.nc \\r=[\\r],\\r",       ld1_c_nc_r_r_r},
{"ld1.c.nc.nt1 \\r=[\\r]",       ld1_c_nc_nt1_r_r_},
{"ld1.c.nc.nt1 \\r=[\\r],\\i9",       ld1_c_nc_nt1_r_r_i9},
{"ld1.c.nc.nt1 \\r=[\\r],\\r",       ld1_c_nc_nt1_r_r_r},
{"ld1.c.nc.nta \\r=[\\r]",       ld1_c_nc_nta_r_r_},
{"ld1.c.nc.nta \\r=[\\r],\\i9",       ld1_c_nc_nta_r_r_i9},
{"ld1.c.nc.nta \\r=[\\r],\\r",       ld1_c_nc_nta_r_r_r},
{"ld1.nt1 \\r=[\\r]",       ld1_nt1_r_r_},
{"ld1.nt1 \\r=[\\r],\\i9",       ld1_nt1_r_r_i9},
{"ld1.nt1 \\r=[\\r],\\r",       ld1_nt1_r_r_r},
{"ld1.nta \\r=[\\r]",       ld1_nta_r_r_},
{"ld1.nta \\r=[\\r],\\i9",       ld1_nta_r_r_i9},
{"ld1.nta \\r=[\\r],\\r",       ld1_nta_r_r_r},
{"ld1.s \\r=[\\r]",       ld1_s_r_r_},
{"ld1.s \\r=[\\r],\\i9",       ld1_s_r_r_i9},
{"ld1.s \\r=[\\r],\\r",       ld1_s_r_r_r},
{"ld1.sa \\r=[\\r]",       ld1_sa_r_r_},
{"ld1.sa \\r=[\\r],\\i9",       ld1_sa_r_r_i9},
{"ld1.sa \\r=[\\r],\\r",       ld1_sa_r_r_r},
{"ld1.sa.nt1 \\r=[\\r]",       ld1_sa_nt1_r_r_},
{"ld1.sa.nt1 \\r=[\\r],\\i9",       ld1_sa_nt1_r_r_i9},
{"ld1.sa.nt1 \\r=[\\r],\\r",       ld1_sa_nt1_r_r_r},
{"ld1.sa.nta \\r=[\\r]",       ld1_sa_nta_r_r_},
{"ld1.sa.nta \\r=[\\r],\\i9",       ld1_sa_nta_r_r_i9},
{"ld1.sa.nta \\r=[\\r],\\r",       ld1_sa_nta_r_r_r},
{"ld1.s.nt1 \\r=[\\r]",       ld1_s_nt1_r_r_},
{"ld1.s.nt1 \\r=[\\r],\\i9",       ld1_s_nt1_r_r_i9},
{"ld1.s.nt1 \\r=[\\r],\\r",       ld1_s_nt1_r_r_r},
{"ld1.s.nta \\r=[\\r]",       ld1_s_nta_r_r_},
{"ld1.s.nta \\r=[\\r],\\i9",       ld1_s_nta_r_r_i9},
{"ld1.s.nta \\r=[\\r],\\r",       ld1_s_nta_r_r_r},
{"ld2 \\r=[\\r]",       ld2_r_r_},
{"ld2 \\r=[\\r],\\i9",       ld2_r_r_i9},
{"ld2 \\r=[\\r],\\r",       ld2_r_r_r},
{"ld2.a \\r=[\\r]",       ld2_a_r_r_},
{"ld2.a \\r=[\\r],\\i9",       ld2_a_r_r_i9},
{"ld2.a \\r=[\\r],\\r",       ld2_a_r_r_r},
{"ld2.acq \\r=[\\r]",       ld2_acq_r_r_},
{"ld2.acq \\r=[\\r],\\i9",       ld2_acq_r_r_i9},
{"ld2.acq \\r=[\\r],\\r",       ld2_acq_r_r_r},
{"ld2.acq.nt1 \\r=[\\r]",       ld2_acq_nt1_r_r_},
{"ld2.acq.nt1 \\r=[\\r],\\i9",       ld2_acq_nt1_r_r_i9},
{"ld2.acq.nt1 \\r=[\\r],\\r",       ld2_acq_nt1_r_r_r},
{"ld2.acq.nta \\r=[\\r]",       ld2_acq_nta_r_r_},
{"ld2.acq.nta \\r=[\\r],\\i9",       ld2_acq_nta_r_r_i9},
{"ld2.acq.nta \\r=[\\r],\\r",       ld2_acq_nta_r_r_r},
{"ld2.a.nt1 \\r=[\\r]",       ld2_a_nt1_r_r_},
{"ld2.a.nt1 \\r=[\\r],\\i9",       ld2_a_nt1_r_r_i9},
{"ld2.a.nt1 \\r=[\\r],\\r",       ld2_a_nt1_r_r_r},
{"ld2.a.nta \\r=[\\r]",       ld2_a_nta_r_r_},
{"ld2.a.nta \\r=[\\r],\\i9",       ld2_a_nta_r_r_i9},
{"ld2.a.nta \\r=[\\r],\\r",       ld2_a_nta_r_r_r},
{"ld2.bias \\r=[\\r]",       ld2_bias_r_r_},
{"ld2.bias \\r=[\\r],\\i9",       ld2_bias_r_r_i9},
{"ld2.bias \\r=[\\r],\\r",       ld2_bias_r_r_r},
{"ld2.bias.nt1 \\r=[\\r]",       ld2_bias_nt1_r_r_},
{"ld2.bias.nt1 \\r=[\\r],\\i9",       ld2_bias_nt1_r_r_i9},
{"ld2.bias.nt1 \\r=[\\r],\\r",       ld2_bias_nt1_r_r_r},
{"ld2.bias.nta \\r=[\\r]",       ld2_bias_nta_r_r_},
{"ld2.bias.nta \\r=[\\r],\\i9",       ld2_bias_nta_r_r_i9},
{"ld2.bias.nta \\r=[\\r],\\r",       ld2_bias_nta_r_r_r},
{"ld2.c.clr \\r=[\\r]",       ld2_c_clr_r_r_},
{"ld2.c.clr \\r=[\\r],\\i9",       ld2_c_clr_r_r_i9},
{"ld2.c.clr \\r=[\\r],\\r",       ld2_c_clr_r_r_r},
{"ld2.c.clr.acq \\r=[\\r]",       ld2_c_clr_acq_r_r_},
{"ld2.c.clr.acq \\r=[\\r],\\i9",       ld2_c_clr_acq_r_r_i9},
{"ld2.c.clr.acq \\r=[\\r],\\r",       ld2_c_clr_acq_r_r_r},
{"ld2.c.clr.acq.nt1 \\r=[\\r]",       ld2_c_clr_acq_nt1_r_r_},
{"ld2.c.clr.acq.nt1 \\r=[\\r],\\i9",       ld2_c_clr_acq_nt1_r_r_i9},
{"ld2.c.clr.acq.nt1 \\r=[\\r],\\r",       ld2_c_clr_acq_nt1_r_r_r},
{"ld2.c.clr.acq.nta \\r=[\\r]",       ld2_c_clr_acq_nta_r_r_},
{"ld2.c.clr.acq.nta \\r=[\\r],\\i9",       ld2_c_clr_acq_nta_r_r_i9},
{"ld2.c.clr.acq.nta \\r=[\\r],\\r",       ld2_c_clr_acq_nta_r_r_r},
{"ld2.c.clr.nt1 \\r=[\\r]",       ld2_c_clr_nt1_r_r_},
{"ld2.c.clr.nt1 \\r=[\\r],\\i9",       ld2_c_clr_nt1_r_r_i9},
{"ld2.c.clr.nt1 \\r=[\\r],\\r",       ld2_c_clr_nt1_r_r_r},
{"ld2.c.clr.nta \\r=[\\r]",       ld2_c_clr_nta_r_r_},
{"ld2.c.clr.nta \\r=[\\r],\\i9",       ld2_c_clr_nta_r_r_i9},
{"ld2.c.clr.nta \\r=[\\r],\\r",       ld2_c_clr_nta_r_r_r},
{"ld2.c.nc \\r=[\\r]",       ld2_c_nc_r_r_},
{"ld2.c.nc \\r=[\\r],\\i9",       ld2_c_nc_r_r_i9},
{"ld2.c.nc \\r=[\\r],\\r",       ld2_c_nc_r_r_r},
{"ld2.c.nc.nt1 \\r=[\\r]",       ld2_c_nc_nt1_r_r_},
{"ld2.c.nc.nt1 \\r=[\\r],\\i9",       ld2_c_nc_nt1_r_r_i9},
{"ld2.c.nc.nt1 \\r=[\\r],\\r",       ld2_c_nc_nt1_r_r_r},
{"ld2.c.nc.nta \\r=[\\r]",       ld2_c_nc_nta_r_r_},
{"ld2.c.nc.nta \\r=[\\r],\\i9",       ld2_c_nc_nta_r_r_i9},
{"ld2.c.nc.nta \\r=[\\r],\\r",       ld2_c_nc_nta_r_r_r},
{"ld2.nt1 \\r=[\\r]",       ld2_nt1_r_r_},
{"ld2.nt1 \\r=[\\r],\\i9",       ld2_nt1_r_r_i9},
{"ld2.nt1 \\r=[\\r],\\r",       ld2_nt1_r_r_r},
{"ld2.nta \\r=[\\r]",       ld2_nta_r_r_},
{"ld2.nta \\r=[\\r],\\i9",       ld2_nta_r_r_i9},
{"ld2.nta \\r=[\\r],\\r",       ld2_nta_r_r_r},
{"ld2.s \\r=[\\r]",       ld2_s_r_r_},
{"ld2.s \\r=[\\r],\\i9",       ld2_s_r_r_i9},
{"ld2.s \\r=[\\r],\\r",       ld2_s_r_r_r},
{"ld2.sa \\r=[\\r]",       ld2_sa_r_r_},
{"ld2.sa \\r=[\\r],\\i9",       ld2_sa_r_r_i9},
{"ld2.sa \\r=[\\r],\\r",       ld2_sa_r_r_r},
{"ld2.sa.nt1 \\r=[\\r]",       ld2_sa_nt1_r_r_},
{"ld2.sa.nt1 \\r=[\\r],\\i9",       ld2_sa_nt1_r_r_i9},
{"ld2.sa.nt1 \\r=[\\r],\\r",       ld2_sa_nt1_r_r_r},
{"ld2.sa.nta \\r=[\\r]",       ld2_sa_nta_r_r_},
{"ld2.sa.nta \\r=[\\r],\\i9",       ld2_sa_nta_r_r_i9},
{"ld2.sa.nta \\r=[\\r],\\r",       ld2_sa_nta_r_r_r},
{"ld2.s.nt1 \\r=[\\r]",       ld2_s_nt1_r_r_},
{"ld2.s.nt1 \\r=[\\r],\\i9",       ld2_s_nt1_r_r_i9},
{"ld2.s.nt1 \\r=[\\r],\\r",       ld2_s_nt1_r_r_r},
{"ld2.s.nta \\r=[\\r]",       ld2_s_nta_r_r_},
{"ld2.s.nta \\r=[\\r],\\i9",       ld2_s_nta_r_r_i9},
{"ld2.s.nta \\r=[\\r],\\r",       ld2_s_nta_r_r_r},
{"ld4 \\r=[\\r]",       ld4_r_r_},
{"ld4 \\r=[\\r],\\i9",       ld4_r_r_i9},
{"ld4 \\r=[\\r],\\r",       ld4_r_r_r},
{"ld4.a \\r=[\\r]",       ld4_a_r_r_},
{"ld4.a \\r=[\\r],\\i9",       ld4_a_r_r_i9},
{"ld4.a \\r=[\\r],\\r",       ld4_a_r_r_r},
{"ld4.acq \\r=[\\r]",       ld4_acq_r_r_},
{"ld4.acq \\r=[\\r],\\i9",       ld4_acq_r_r_i9},
{"ld4.acq \\r=[\\r],\\r",       ld4_acq_r_r_r},
{"ld4.acq.nt1 \\r=[\\r]",       ld4_acq_nt1_r_r_},
{"ld4.acq.nt1 \\r=[\\r],\\i9",       ld4_acq_nt1_r_r_i9},
{"ld4.acq.nt1 \\r=[\\r],\\r",       ld4_acq_nt1_r_r_r},
{"ld4.acq.nta \\r=[\\r]",       ld4_acq_nta_r_r_},
{"ld4.acq.nta \\r=[\\r],\\i9",       ld4_acq_nta_r_r_i9},
{"ld4.acq.nta \\r=[\\r],\\r",       ld4_acq_nta_r_r_r},
{"ld4.a.nt1 \\r=[\\r]",       ld4_a_nt1_r_r_},
{"ld4.a.nt1 \\r=[\\r],\\i9",       ld4_a_nt1_r_r_i9},
{"ld4.a.nt1 \\r=[\\r],\\r",       ld4_a_nt1_r_r_r},
{"ld4.a.nta \\r=[\\r]",       ld4_a_nta_r_r_},
{"ld4.a.nta \\r=[\\r],\\i9",       ld4_a_nta_r_r_i9},
{"ld4.a.nta \\r=[\\r],\\r",       ld4_a_nta_r_r_r},
{"ld4.bias \\r=[\\r]",       ld4_bias_r_r_},
{"ld4.bias \\r=[\\r],\\i9",       ld4_bias_r_r_i9},
{"ld4.bias \\r=[\\r],\\r",       ld4_bias_r_r_r},
{"ld4.bias.nt1 \\r=[\\r]",       ld4_bias_nt1_r_r_},
{"ld4.bias.nt1 \\r=[\\r],\\i9",       ld4_bias_nt1_r_r_i9},
{"ld4.bias.nt1 \\r=[\\r],\\r",       ld4_bias_nt1_r_r_r},
{"ld4.bias.nta \\r=[\\r]",       ld4_bias_nta_r_r_},
{"ld4.bias.nta \\r=[\\r],\\i9",       ld4_bias_nta_r_r_i9},
{"ld4.bias.nta \\r=[\\r],\\r",       ld4_bias_nta_r_r_r},
{"ld4.c.clr \\r=[\\r]",       ld4_c_clr_r_r_},
{"ld4.c.clr \\r=[\\r],\\i9",       ld4_c_clr_r_r_i9},
{"ld4.c.clr \\r=[\\r],\\r",       ld4_c_clr_r_r_r},
{"ld4.c.clr.acq \\r=[\\r]",       ld4_c_clr_acq_r_r_},
{"ld4.c.clr.acq \\r=[\\r],\\i9",       ld4_c_clr_acq_r_r_i9},
{"ld4.c.clr.acq \\r=[\\r],\\r",       ld4_c_clr_acq_r_r_r},
{"ld4.c.clr.acq.nt1 \\r=[\\r]",       ld4_c_clr_acq_nt1_r_r_},
{"ld4.c.clr.acq.nt1 \\r=[\\r],\\i9",       ld4_c_clr_acq_nt1_r_r_i9},
{"ld4.c.clr.acq.nt1 \\r=[\\r],\\r",       ld4_c_clr_acq_nt1_r_r_r},
{"ld4.c.clr.acq.nta \\r=[\\r]",       ld4_c_clr_acq_nta_r_r_},
{"ld4.c.clr.acq.nta \\r=[\\r],\\i9",       ld4_c_clr_acq_nta_r_r_i9},
{"ld4.c.clr.acq.nta \\r=[\\r],\\r",       ld4_c_clr_acq_nta_r_r_r},
{"ld4.c.clr.nt1 \\r=[\\r]",       ld4_c_clr_nt1_r_r_},
{"ld4.c.clr.nt1 \\r=[\\r],\\i9",       ld4_c_clr_nt1_r_r_i9},
{"ld4.c.clr.nt1 \\r=[\\r],\\r",       ld4_c_clr_nt1_r_r_r},
{"ld4.c.clr.nta \\r=[\\r]",       ld4_c_clr_nta_r_r_},
{"ld4.c.clr.nta \\r=[\\r],\\i9",       ld4_c_clr_nta_r_r_i9},
{"ld4.c.clr.nta \\r=[\\r],\\r",       ld4_c_clr_nta_r_r_r},
{"ld4.c.nc \\r=[\\r]",       ld4_c_nc_r_r_},
{"ld4.c.nc \\r=[\\r],\\i9",       ld4_c_nc_r_r_i9},
{"ld4.c.nc \\r=[\\r],\\r",       ld4_c_nc_r_r_r},
{"ld4.c.nc.nt1 \\r=[\\r]",       ld4_c_nc_nt1_r_r_},
{"ld4.c.nc.nt1 \\r=[\\r],\\i9",       ld4_c_nc_nt1_r_r_i9},
{"ld4.c.nc.nt1 \\r=[\\r],\\r",       ld4_c_nc_nt1_r_r_r},
{"ld4.c.nc.nta \\r=[\\r]",       ld4_c_nc_nta_r_r_},
{"ld4.c.nc.nta \\r=[\\r],\\i9",       ld4_c_nc_nta_r_r_i9},
{"ld4.c.nc.nta \\r=[\\r],\\r",       ld4_c_nc_nta_r_r_r},
{"ld4.nt1 \\r=[\\r]",       ld4_nt1_r_r_},
{"ld4.nt1 \\r=[\\r],\\i9",       ld4_nt1_r_r_i9},
{"ld4.nt1 \\r=[\\r],\\r",       ld4_nt1_r_r_r},
{"ld4.nta \\r=[\\r]",       ld4_nta_r_r_},
{"ld4.nta \\r=[\\r],\\i9",       ld4_nta_r_r_i9},
{"ld4.nta \\r=[\\r],\\r",       ld4_nta_r_r_r},
{"ld4.s \\r=[\\r]",       ld4_s_r_r_},
{"ld4.s \\r=[\\r],\\i9",       ld4_s_r_r_i9},
{"ld4.s \\r=[\\r],\\r",       ld4_s_r_r_r},
{"ld4.sa \\r=[\\r]",       ld4_sa_r_r_},
{"ld4.sa \\r=[\\r],\\i9",       ld4_sa_r_r_i9},
{"ld4.sa \\r=[\\r],\\r",       ld4_sa_r_r_r},
{"ld4.sa.nt1 \\r=[\\r]",       ld4_sa_nt1_r_r_},
{"ld4.sa.nt1 \\r=[\\r],\\i9",       ld4_sa_nt1_r_r_i9},
{"ld4.sa.nt1 \\r=[\\r],\\r",       ld4_sa_nt1_r_r_r},
{"ld4.sa.nta \\r=[\\r]",       ld4_sa_nta_r_r_},
{"ld4.sa.nta \\r=[\\r],\\i9",       ld4_sa_nta_r_r_i9},
{"ld4.sa.nta \\r=[\\r],\\r",       ld4_sa_nta_r_r_r},
{"ld4.s.nt1 \\r=[\\r]",       ld4_s_nt1_r_r_},
{"ld4.s.nt1 \\r=[\\r],\\i9",       ld4_s_nt1_r_r_i9},
{"ld4.s.nt1 \\r=[\\r],\\r",       ld4_s_nt1_r_r_r},
{"ld4.s.nta \\r=[\\r]",       ld4_s_nta_r_r_},
{"ld4.s.nta \\r=[\\r],\\i9",       ld4_s_nta_r_r_i9},
{"ld4.s.nta \\r=[\\r],\\r",       ld4_s_nta_r_r_r},
{"ld8 \\r=[\\r]",       ld8_r_r_},
{"ld8 \\r=[\\r],\\i9",       ld8_r_r_i9},
{"ld8 \\r=[\\r],\\r",       ld8_r_r_r},
{"ld8.a \\r=[\\r]",       ld8_a_r_r_},
{"ld8.a \\r=[\\r],\\i9",       ld8_a_r_r_i9},
{"ld8.a \\r=[\\r],\\r",       ld8_a_r_r_r},
{"ld8.acq \\r=[\\r]",       ld8_acq_r_r_},
{"ld8.acq \\r=[\\r],\\i9",       ld8_acq_r_r_i9},
{"ld8.acq \\r=[\\r],\\r",       ld8_acq_r_r_r},
{"ld8.acq.nt1 \\r=[\\r]",       ld8_acq_nt1_r_r_},
{"ld8.acq.nt1 \\r=[\\r],\\i9",       ld8_acq_nt1_r_r_i9},
{"ld8.acq.nt1 \\r=[\\r],\\r",       ld8_acq_nt1_r_r_r},
{"ld8.acq.nta \\r=[\\r]",       ld8_acq_nta_r_r_},
{"ld8.acq.nta \\r=[\\r],\\i9",       ld8_acq_nta_r_r_i9},
{"ld8.acq.nta \\r=[\\r],\\r",       ld8_acq_nta_r_r_r},
{"ld8.a.nt1 \\r=[\\r]",       ld8_a_nt1_r_r_},
{"ld8.a.nt1 \\r=[\\r],\\i9",       ld8_a_nt1_r_r_i9},
{"ld8.a.nt1 \\r=[\\r],\\r",       ld8_a_nt1_r_r_r},
{"ld8.a.nta \\r=[\\r]",       ld8_a_nta_r_r_},
{"ld8.a.nta \\r=[\\r],\\i9",       ld8_a_nta_r_r_i9},
{"ld8.a.nta \\r=[\\r],\\r",       ld8_a_nta_r_r_r},
{"ld8.bias \\r=[\\r]",       ld8_bias_r_r_},
{"ld8.bias \\r=[\\r],\\i9",       ld8_bias_r_r_i9},
{"ld8.bias \\r=[\\r],\\r",       ld8_bias_r_r_r},
{"ld8.bias.nt1 \\r=[\\r]",       ld8_bias_nt1_r_r_},
{"ld8.bias.nt1 \\r=[\\r],\\i9",       ld8_bias_nt1_r_r_i9},
{"ld8.bias.nt1 \\r=[\\r],\\r",       ld8_bias_nt1_r_r_r},
{"ld8.bias.nta \\r=[\\r]",       ld8_bias_nta_r_r_},
{"ld8.bias.nta \\r=[\\r],\\i9",       ld8_bias_nta_r_r_i9},
{"ld8.bias.nta \\r=[\\r],\\r",       ld8_bias_nta_r_r_r},
{"ld8.c.clr \\r=[\\r]",       ld8_c_clr_r_r_},
{"ld8.c.clr \\r=[\\r],\\i9",       ld8_c_clr_r_r_i9},
{"ld8.c.clr \\r=[\\r],\\r",       ld8_c_clr_r_r_r},
{"ld8.c.clr.acq \\r=[\\r]",       ld8_c_clr_acq_r_r_},
{"ld8.c.clr.acq \\r=[\\r],\\i9",       ld8_c_clr_acq_r_r_i9},
{"ld8.c.clr.acq \\r=[\\r],\\r",       ld8_c_clr_acq_r_r_r},
{"ld8.c.clr.acq.nt1 \\r=[\\r]",       ld8_c_clr_acq_nt1_r_r_},
{"ld8.c.clr.acq.nt1 \\r=[\\r],\\i9",       ld8_c_clr_acq_nt1_r_r_i9},
{"ld8.c.clr.acq.nt1 \\r=[\\r],\\r",       ld8_c_clr_acq_nt1_r_r_r},
{"ld8.c.clr.acq.nta \\r=[\\r]",       ld8_c_clr_acq_nta_r_r_},
{"ld8.c.clr.acq.nta \\r=[\\r],\\i9",       ld8_c_clr_acq_nta_r_r_i9},
{"ld8.c.clr.acq.nta \\r=[\\r],\\r",       ld8_c_clr_acq_nta_r_r_r},
{"ld8.c.clr.nt1 \\r=[\\r]",       ld8_c_clr_nt1_r_r_},
{"ld8.c.clr.nt1 \\r=[\\r],\\i9",       ld8_c_clr_nt1_r_r_i9},
{"ld8.c.clr.nt1 \\r=[\\r],\\r",       ld8_c_clr_nt1_r_r_r},
{"ld8.c.clr.nta \\r=[\\r]",       ld8_c_clr_nta_r_r_},
{"ld8.c.clr.nta \\r=[\\r],\\i9",       ld8_c_clr_nta_r_r_i9},
{"ld8.c.clr.nta \\r=[\\r],\\r",       ld8_c_clr_nta_r_r_r},
{"ld8.c.nc \\r=[\\r]",       ld8_c_nc_r_r_},
{"ld8.c.nc \\r=[\\r],\\i9",       ld8_c_nc_r_r_i9},
{"ld8.c.nc \\r=[\\r],\\r",       ld8_c_nc_r_r_r},
{"ld8.c.nc.nt1 \\r=[\\r]",       ld8_c_nc_nt1_r_r_},
{"ld8.c.nc.nt1 \\r=[\\r],\\i9",       ld8_c_nc_nt1_r_r_i9},
{"ld8.c.nc.nt1 \\r=[\\r],\\r",       ld8_c_nc_nt1_r_r_r},
{"ld8.c.nc.nta \\r=[\\r]",       ld8_c_nc_nta_r_r_},
{"ld8.c.nc.nta \\r=[\\r],\\i9",       ld8_c_nc_nta_r_r_i9},
{"ld8.c.nc.nta \\r=[\\r],\\r",       ld8_c_nc_nta_r_r_r},
{"ld8.fill \\r=[\\r]",       ld8_fill_r_r_},
{"ld8.fill \\r=[\\r],\\i9",       ld8_fill_r_r_i9},
{"ld8.fill \\r=[\\r],\\r",       ld8_fill_r_r_r},
{"ld8.fill.a \\r=[\\r]",       ld8_fill_a_r_r_},
{"ld8.fill.a \\r=[\\r],\\i9",       ld8_fill_a_r_r_i9},
{"ld8.fill.a \\r=[\\r],\\r",       ld8_fill_a_r_r_r},
{"ld8.fill.acq \\r=[\\r]",       ld8_fill_acq_r_r_},
{"ld8.fill.acq \\r=[\\r],\\i9",       ld8_fill_acq_r_r_i9},
{"ld8.fill.acq \\r=[\\r],\\r",       ld8_fill_acq_r_r_r},
{"ld8.fill.acq.nt1 \\r=[\\r]",       ld8_fill_acq_nt1_r_r_},
{"ld8.fill.acq.nt1 \\r=[\\r],\\i9",       ld8_fill_acq_nt1_r_r_i9},
{"ld8.fill.acq.nt1 \\r=[\\r],\\r",       ld8_fill_acq_nt1_r_r_r},
{"ld8.fill.acq.nta \\r=[\\r]",       ld8_fill_acq_nta_r_r_},
{"ld8.fill.acq.nta \\r=[\\r],\\i9",       ld8_fill_acq_nta_r_r_i9},
{"ld8.fill.acq.nta \\r=[\\r],\\r",       ld8_fill_acq_nta_r_r_r},
{"ld8.fill.a.nt1 \\r=[\\r]",       ld8_fill_a_nt1_r_r_},
{"ld8.fill.a.nt1 \\r=[\\r],\\i9",       ld8_fill_a_nt1_r_r_i9},
{"ld8.fill.a.nt1 \\r=[\\r],\\r",       ld8_fill_a_nt1_r_r_r},
{"ld8.fill.a.nta \\r=[\\r]",       ld8_fill_a_nta_r_r_},
{"ld8.fill.a.nta \\r=[\\r],\\i9",       ld8_fill_a_nta_r_r_i9},
{"ld8.fill.a.nta \\r=[\\r],\\r",       ld8_fill_a_nta_r_r_r},
{"ld8.fill.bias \\r=[\\r]",       ld8_fill_bias_r_r_},
{"ld8.fill.bias \\r=[\\r],\\i9",       ld8_fill_bias_r_r_i9},
{"ld8.fill.bias \\r=[\\r],\\r",       ld8_fill_bias_r_r_r},
{"ld8.fill.bias.nt1 \\r=[\\r]",       ld8_fill_bias_nt1_r_r_},
{"ld8.fill.bias.nt1 \\r=[\\r],\\i9",       ld8_fill_bias_nt1_r_r_i9},
{"ld8.fill.bias.nt1 \\r=[\\r],\\r",       ld8_fill_bias_nt1_r_r_r},
{"ld8.fill.bias.nta \\r=[\\r]",       ld8_fill_bias_nta_r_r_},
{"ld8.fill.bias.nta \\r=[\\r],\\i9",       ld8_fill_bias_nta_r_r_i9},
{"ld8.fill.bias.nta \\r=[\\r],\\r",       ld8_fill_bias_nta_r_r_r},
{"ld8.fill.c.clr \\r=[\\r]",       ld8_fill_c_clr_r_r_},
{"ld8.fill.c.clr \\r=[\\r],\\i9",       ld8_fill_c_clr_r_r_i9},
{"ld8.fill.c.clr \\r=[\\r],\\r",       ld8_fill_c_clr_r_r_r},
{"ld8.fill.c.clr.acq \\r=[\\r]",       ld8_fill_c_clr_acq_r_r_},
{"ld8.fill.c.clr.acq \\r=[\\r],\\i9",       ld8_fill_c_clr_acq_r_r_i9},
{"ld8.fill.c.clr.acq \\r=[\\r],\\r",       ld8_fill_c_clr_acq_r_r_r},
{"ld8.fill.c.clr.acq.nt1 \\r=[\\r]",       ld8_fill_c_clr_acq_nt1_r_r_},
{"ld8.fill.c.clr.acq.nt1 \\r=[\\r],\\i9",       ld8_fill_c_clr_acq_nt1_r_r_i9},
{"ld8.fill.c.clr.acq.nt1 \\r=[\\r],\\r",       ld8_fill_c_clr_acq_nt1_r_r_r},
{"ld8.fill.c.clr.acq.nta \\r=[\\r]",       ld8_fill_c_clr_acq_nta_r_r_},
{"ld8.fill.c.clr.acq.nta \\r=[\\r],\\i9",       ld8_fill_c_clr_acq_nta_r_r_i9},
{"ld8.fill.c.clr.acq.nta \\r=[\\r],\\r",       ld8_fill_c_clr_acq_nta_r_r_r},
{"ld8.fill.c.clr.nt1 \\r=[\\r]",       ld8_fill_c_clr_nt1_r_r_},
{"ld8.fill.c.clr.nt1 \\r=[\\r],\\i9",       ld8_fill_c_clr_nt1_r_r_i9},
{"ld8.fill.c.clr.nt1 \\r=[\\r],\\r",       ld8_fill_c_clr_nt1_r_r_r},
{"ld8.fill.c.clr.nta \\r=[\\r]",       ld8_fill_c_clr_nta_r_r_},
{"ld8.fill.c.clr.nta \\r=[\\r],\\i9",       ld8_fill_c_clr_nta_r_r_i9},
{"ld8.fill.c.clr.nta \\r=[\\r],\\r",       ld8_fill_c_clr_nta_r_r_r},
{"ld8.fill.c.nc \\r=[\\r]",       ld8_fill_c_nc_r_r_},
{"ld8.fill.c.nc \\r=[\\r],\\i9",       ld8_fill_c_nc_r_r_i9},
{"ld8.fill.c.nc \\r=[\\r],\\r",       ld8_fill_c_nc_r_r_r},
{"ld8.fill.c.nc.nt1 \\r=[\\r]",       ld8_fill_c_nc_nt1_r_r_},
{"ld8.fill.c.nc.nt1 \\r=[\\r],\\i9",       ld8_fill_c_nc_nt1_r_r_i9},
{"ld8.fill.c.nc.nt1 \\r=[\\r],\\r",       ld8_fill_c_nc_nt1_r_r_r},
{"ld8.fill.c.nc.nta \\r=[\\r]",       ld8_fill_c_nc_nta_r_r_},
{"ld8.fill.c.nc.nta \\r=[\\r],\\i9",       ld8_fill_c_nc_nta_r_r_i9},
{"ld8.fill.c.nc.nta \\r=[\\r],\\r",       ld8_fill_c_nc_nta_r_r_r},
{"ld8.fill.nt1 \\r=[\\r]",       ld8_fill_nt1_r_r_},
{"ld8.fill.nt1 \\r=[\\r],\\i9",       ld8_fill_nt1_r_r_i9},
{"ld8.fill.nt1 \\r=[\\r],\\r",       ld8_fill_nt1_r_r_r},
{"ld8.fill.nta \\r=[\\r]",       ld8_fill_nta_r_r_},
{"ld8.fill.nta \\r=[\\r],\\i9",       ld8_fill_nta_r_r_i9},
{"ld8.fill.nta \\r=[\\r],\\r",       ld8_fill_nta_r_r_r},
{"ld8.fill.s \\r=[\\r]",       ld8_fill_s_r_r_},
{"ld8.fill.s \\r=[\\r],\\i9",       ld8_fill_s_r_r_i9},
{"ld8.fill.s \\r=[\\r],\\r",       ld8_fill_s_r_r_r},
{"ld8.fill.sa \\r=[\\r]",       ld8_fill_sa_r_r_},
{"ld8.fill.sa \\r=[\\r],\\i9",       ld8_fill_sa_r_r_i9},
{"ld8.fill.sa \\r=[\\r],\\r",       ld8_fill_sa_r_r_r},
{"ld8.fill.sa.nt1 \\r=[\\r]",       ld8_fill_sa_nt1_r_r_},
{"ld8.fill.sa.nt1 \\r=[\\r],\\i9",       ld8_fill_sa_nt1_r_r_i9},
{"ld8.fill.sa.nt1 \\r=[\\r],\\r",       ld8_fill_sa_nt1_r_r_r},
{"ld8.fill.sa.nta \\r=[\\r]",       ld8_fill_sa_nta_r_r_},
{"ld8.fill.sa.nta \\r=[\\r],\\i9",       ld8_fill_sa_nta_r_r_i9},
{"ld8.fill.sa.nta \\r=[\\r],\\r",       ld8_fill_sa_nta_r_r_r},
{"ld8.fill.s.nt1 \\r=[\\r]",       ld8_fill_s_nt1_r_r_},
{"ld8.fill.s.nt1 \\r=[\\r],\\i9",       ld8_fill_s_nt1_r_r_i9},
{"ld8.fill.s.nt1 \\r=[\\r],\\r",       ld8_fill_s_nt1_r_r_r},
{"ld8.fill.s.nta \\r=[\\r]",       ld8_fill_s_nta_r_r_},
{"ld8.fill.s.nta \\r=[\\r],\\i9",       ld8_fill_s_nta_r_r_i9},
{"ld8.fill.s.nta \\r=[\\r],\\r",       ld8_fill_s_nta_r_r_r},
{"ld8.nt1 \\r=[\\r]",       ld8_nt1_r_r_},
{"ld8.nt1 \\r=[\\r],\\i9",       ld8_nt1_r_r_i9},
{"ld8.nt1 \\r=[\\r],\\r",       ld8_nt1_r_r_r},
{"ld8.nta \\r=[\\r]",       ld8_nta_r_r_},
{"ld8.nta \\r=[\\r],\\i9",       ld8_nta_r_r_i9},
{"ld8.nta \\r=[\\r],\\r",       ld8_nta_r_r_r},
{"ld8.s \\r=[\\r]",       ld8_s_r_r_},
{"ld8.s \\r=[\\r],\\i9",       ld8_s_r_r_i9},
{"ld8.s \\r=[\\r],\\r",       ld8_s_r_r_r},
{"ld8.sa \\r=[\\r]",       ld8_sa_r_r_},
{"ld8.sa \\r=[\\r],\\i9",       ld8_sa_r_r_i9},
{"ld8.sa \\r=[\\r],\\r",       ld8_sa_r_r_r},
{"ld8.sa.nt1 \\r=[\\r]",       ld8_sa_nt1_r_r_},
{"ld8.sa.nt1 \\r=[\\r],\\i9",       ld8_sa_nt1_r_r_i9},
{"ld8.sa.nt1 \\r=[\\r],\\r",       ld8_sa_nt1_r_r_r},
{"ld8.sa.nta \\r=[\\r]",       ld8_sa_nta_r_r_},
{"ld8.sa.nta \\r=[\\r],\\i9",       ld8_sa_nta_r_r_i9},
{"ld8.sa.nta \\r=[\\r],\\r",       ld8_sa_nta_r_r_r},
{"ld8.s.nt1 \\r=[\\r]",       ld8_s_nt1_r_r_},
{"ld8.s.nt1 \\r=[\\r],\\i9",       ld8_s_nt1_r_r_i9},
{"ld8.s.nt1 \\r=[\\r],\\r",       ld8_s_nt1_r_r_r},
{"ld8.s.nta \\r=[\\r]",       ld8_s_nta_r_r_},
{"ld8.s.nta \\r=[\\r],\\i9",       ld8_s_nta_r_r_i9},
{"ld8.s.nta \\r=[\\r],\\r",       ld8_s_nta_r_r_r},
{"ldf8 \\f=[\\r]",       ldf8_f_r_},
{"ldf8 \\f=[\\r],\\i9",       ldf8_f_r_i9},
{"ldf8 \\f=[\\r],\\r",       ldf8_f_r_r},
{"ldf8.a \\f=[\\r]",       ldf8_a_f_r_},
{"ldf8.a \\f=[\\r],\\i9",       ldf8_a_f_r_i9},
{"ldf8.a \\f=[\\r],\\r",       ldf8_a_f_r_r},
{"ldf8.a.nt1 \\f=[\\r]",       ldf8_a_nt1_f_r_},
{"ldf8.a.nt1 \\f=[\\r],\\i9",       ldf8_a_nt1_f_r_i9},
{"ldf8.a.nt1 \\f=[\\r],\\r",       ldf8_a_nt1_f_r_r},
{"ldf8.a.nta \\f=[\\r]",       ldf8_a_nta_f_r_},
{"ldf8.a.nta \\f=[\\r],\\i9",       ldf8_a_nta_f_r_i9},
{"ldf8.a.nta \\f=[\\r],\\r",       ldf8_a_nta_f_r_r},
{"ldf8.c.clr \\f=[\\r]",       ldf8_c_clr_f_r_},
{"ldf8.c.clr \\f=[\\r],\\i9",       ldf8_c_clr_f_r_i9},
{"ldf8.c.clr \\f=[\\r],\\r",       ldf8_c_clr_f_r_r},
{"ldf8.c.clr.nt1 \\f=[\\r]",       ldf8_c_clr_nt1_f_r_},
{"ldf8.c.clr.nt1 \\f=[\\r],\\i9",       ldf8_c_clr_nt1_f_r_i9},
{"ldf8.c.clr.nt1 \\f=[\\r],\\r",       ldf8_c_clr_nt1_f_r_r},
{"ldf8.c.clr.nta \\f=[\\r]",       ldf8_c_clr_nta_f_r_},
{"ldf8.c.clr.nta \\f=[\\r],\\i9",       ldf8_c_clr_nta_f_r_i9},
{"ldf8.c.clr.nta \\f=[\\r],\\r",       ldf8_c_clr_nta_f_r_r},
{"ldf8.c.nc \\f=[\\r]",       ldf8_c_nc_f_r_},
{"ldf8.c.nc \\f=[\\r],\\i9",       ldf8_c_nc_f_r_i9},
{"ldf8.c.nc \\f=[\\r],\\r",       ldf8_c_nc_f_r_r},
{"ldf8.c.nc.nt1 \\f=[\\r]",       ldf8_c_nc_nt1_f_r_},
{"ldf8.c.nc.nt1 \\f=[\\r],\\i9",       ldf8_c_nc_nt1_f_r_i9},
{"ldf8.c.nc.nt1 \\f=[\\r],\\r",       ldf8_c_nc_nt1_f_r_r},
{"ldf8.c.nc.nta \\f=[\\r]",       ldf8_c_nc_nta_f_r_},
{"ldf8.c.nc.nta \\f=[\\r],\\i9",       ldf8_c_nc_nta_f_r_i9},
{"ldf8.c.nc.nta \\f=[\\r],\\r",       ldf8_c_nc_nta_f_r_r},
{"ldf8.nt1 \\f=[\\r]",       ldf8_nt1_f_r_},
{"ldf8.nt1 \\f=[\\r],\\i9",       ldf8_nt1_f_r_i9},
{"ldf8.nt1 \\f=[\\r],\\r",       ldf8_nt1_f_r_r},
{"ldf8.nta \\f=[\\r]",       ldf8_nta_f_r_},
{"ldf8.nta \\f=[\\r],\\i9",       ldf8_nta_f_r_i9},
{"ldf8.nta \\f=[\\r],\\r",       ldf8_nta_f_r_r},
{"ldf8.s \\f=[\\r]",       ldf8_s_f_r_},
{"ldf8.s \\f=[\\r],\\i9",       ldf8_s_f_r_i9},
{"ldf8.s \\f=[\\r],\\r",       ldf8_s_f_r_r},
{"ldf8.sa \\f=[\\r]",       ldf8_sa_f_r_},
{"ldf8.sa \\f=[\\r],\\i9",       ldf8_sa_f_r_i9},
{"ldf8.sa \\f=[\\r],\\r",       ldf8_sa_f_r_r},
{"ldf8.sa.nt1 \\f=[\\r]",       ldf8_sa_nt1_f_r_},
{"ldf8.sa.nt1 \\f=[\\r],\\i9",       ldf8_sa_nt1_f_r_i9},
{"ldf8.sa.nt1 \\f=[\\r],\\r",       ldf8_sa_nt1_f_r_r},
{"ldf8.sa.nta \\f=[\\r]",       ldf8_sa_nta_f_r_},
{"ldf8.sa.nta \\f=[\\r],\\i9",       ldf8_sa_nta_f_r_i9},
{"ldf8.sa.nta \\f=[\\r],\\r",       ldf8_sa_nta_f_r_r},
{"ldf8.s.nt1 \\f=[\\r]",       ldf8_s_nt1_f_r_},
{"ldf8.s.nt1 \\f=[\\r],\\i9",       ldf8_s_nt1_f_r_i9},
{"ldf8.s.nt1 \\f=[\\r],\\r",       ldf8_s_nt1_f_r_r},
{"ldf8.s.nta \\f=[\\r]",       ldf8_s_nta_f_r_},
{"ldf8.s.nta \\f=[\\r],\\i9",       ldf8_s_nta_f_r_i9},
{"ldf8.s.nta \\f=[\\r],\\r",       ldf8_s_nta_f_r_r},
{"ldfd \\f=[\\r]",       ldfd_f_r_},
{"ldfd \\f=[\\r],\\i9",       ldfd_f_r_i9},
{"ldfd \\f=[\\r],\\r",       ldfd_f_r_r},
{"ldfd.a \\f=[\\r]",       ldfd_a_f_r_},
{"ldfd.a \\f=[\\r],\\i9",       ldfd_a_f_r_i9},
{"ldfd.a \\f=[\\r],\\r",       ldfd_a_f_r_r},
{"ldfd.a.nt1 \\f=[\\r]",       ldfd_a_nt1_f_r_},
{"ldfd.a.nt1 \\f=[\\r],\\i9",       ldfd_a_nt1_f_r_i9},
{"ldfd.a.nt1 \\f=[\\r],\\r",       ldfd_a_nt1_f_r_r},
{"ldfd.a.nta \\f=[\\r]",       ldfd_a_nta_f_r_},
{"ldfd.a.nta \\f=[\\r],\\i9",       ldfd_a_nta_f_r_i9},
{"ldfd.a.nta \\f=[\\r],\\r",       ldfd_a_nta_f_r_r},
{"ldfd.c.clr \\f=[\\r]",       ldfd_c_clr_f_r_},
{"ldfd.c.clr \\f=[\\r],\\i9",       ldfd_c_clr_f_r_i9},
{"ldfd.c.clr \\f=[\\r],\\r",       ldfd_c_clr_f_r_r},
{"ldfd.c.clr.nt1 \\f=[\\r]",       ldfd_c_clr_nt1_f_r_},
{"ldfd.c.clr.nt1 \\f=[\\r],\\i9",       ldfd_c_clr_nt1_f_r_i9},
{"ldfd.c.clr.nt1 \\f=[\\r],\\r",       ldfd_c_clr_nt1_f_r_r},
{"ldfd.c.clr.nta \\f=[\\r]",       ldfd_c_clr_nta_f_r_},
{"ldfd.c.clr.nta \\f=[\\r],\\i9",       ldfd_c_clr_nta_f_r_i9},
{"ldfd.c.clr.nta \\f=[\\r],\\r",       ldfd_c_clr_nta_f_r_r},
{"ldfd.c.nc \\f=[\\r]",       ldfd_c_nc_f_r_},
{"ldfd.c.nc \\f=[\\r],\\i9",       ldfd_c_nc_f_r_i9},
{"ldfd.c.nc \\f=[\\r],\\r",       ldfd_c_nc_f_r_r},
{"ldfd.c.nc.nt1 \\f=[\\r]",       ldfd_c_nc_nt1_f_r_},
{"ldfd.c.nc.nt1 \\f=[\\r],\\i9",       ldfd_c_nc_nt1_f_r_i9},
{"ldfd.c.nc.nt1 \\f=[\\r],\\r",       ldfd_c_nc_nt1_f_r_r},
{"ldfd.c.nc.nta \\f=[\\r]",       ldfd_c_nc_nta_f_r_},
{"ldfd.c.nc.nta \\f=[\\r],\\i9",       ldfd_c_nc_nta_f_r_i9},
{"ldfd.c.nc.nta \\f=[\\r],\\r",       ldfd_c_nc_nta_f_r_r},
{"ldfd.nt1 \\f=[\\r]",       ldfd_nt1_f_r_},
{"ldfd.nt1 \\f=[\\r],\\i9",       ldfd_nt1_f_r_i9},
{"ldfd.nt1 \\f=[\\r],\\r",       ldfd_nt1_f_r_r},
{"ldfd.nta \\f=[\\r]",       ldfd_nta_f_r_},
{"ldfd.nta \\f=[\\r],\\i9",       ldfd_nta_f_r_i9},
{"ldfd.nta \\f=[\\r],\\r",       ldfd_nta_f_r_r},
{"ldfd.s \\f=[\\r]",       ldfd_s_f_r_},
{"ldfd.s \\f=[\\r],\\i9",       ldfd_s_f_r_i9},
{"ldfd.s \\f=[\\r],\\r",       ldfd_s_f_r_r},
{"ldfd.sa \\f=[\\r]",       ldfd_sa_f_r_},
{"ldfd.sa \\f=[\\r],\\i9",       ldfd_sa_f_r_i9},
{"ldfd.sa \\f=[\\r],\\r",       ldfd_sa_f_r_r},
{"ldfd.sa.nt1 \\f=[\\r]",       ldfd_sa_nt1_f_r_},
{"ldfd.sa.nt1 \\f=[\\r],\\i9",       ldfd_sa_nt1_f_r_i9},
{"ldfd.sa.nt1 \\f=[\\r],\\r",       ldfd_sa_nt1_f_r_r},
{"ldfd.sa.nta \\f=[\\r]",       ldfd_sa_nta_f_r_},
{"ldfd.sa.nta \\f=[\\r],\\i9",       ldfd_sa_nta_f_r_i9},
{"ldfd.sa.nta \\f=[\\r],\\r",       ldfd_sa_nta_f_r_r},
{"ldfd.s.nt1 \\f=[\\r]",       ldfd_s_nt1_f_r_},
{"ldfd.s.nt1 \\f=[\\r],\\i9",       ldfd_s_nt1_f_r_i9},
{"ldfd.s.nt1 \\f=[\\r],\\r",       ldfd_s_nt1_f_r_r},
{"ldfd.s.nta \\f=[\\r]",       ldfd_s_nta_f_r_},
{"ldfd.s.nta \\f=[\\r],\\i9",       ldfd_s_nta_f_r_i9},
{"ldfd.s.nta \\f=[\\r],\\r",       ldfd_s_nta_f_r_r},
{"ldfe \\f=[\\r]",       ldfe_f_r_},
{"ldfe \\f=[\\r],\\i9",       ldfe_f_r_i9},
{"ldfe \\f=[\\r],\\r",       ldfe_f_r_r},
{"ldfe.a \\f=[\\r]",       ldfe_a_f_r_},
{"ldfe.a \\f=[\\r],\\i9",       ldfe_a_f_r_i9},
{"ldfe.a \\f=[\\r],\\r",       ldfe_a_f_r_r},
{"ldfe.a.nt1 \\f=[\\r]",       ldfe_a_nt1_f_r_},
{"ldfe.a.nt1 \\f=[\\r],\\i9",       ldfe_a_nt1_f_r_i9},
{"ldfe.a.nt1 \\f=[\\r],\\r",       ldfe_a_nt1_f_r_r},
{"ldfe.a.nta \\f=[\\r]",       ldfe_a_nta_f_r_},
{"ldfe.a.nta \\f=[\\r],\\i9",       ldfe_a_nta_f_r_i9},
{"ldfe.a.nta \\f=[\\r],\\r",       ldfe_a_nta_f_r_r},
{"ldfe.c.clr \\f=[\\r]",       ldfe_c_clr_f_r_},
{"ldfe.c.clr \\f=[\\r],\\i9",       ldfe_c_clr_f_r_i9},
{"ldfe.c.clr \\f=[\\r],\\r",       ldfe_c_clr_f_r_r},
{"ldfe.c.clr.nt1 \\f=[\\r]",       ldfe_c_clr_nt1_f_r_},
{"ldfe.c.clr.nt1 \\f=[\\r],\\i9",       ldfe_c_clr_nt1_f_r_i9},
{"ldfe.c.clr.nt1 \\f=[\\r],\\r",       ldfe_c_clr_nt1_f_r_r},
{"ldfe.c.clr.nta \\f=[\\r]",       ldfe_c_clr_nta_f_r_},
{"ldfe.c.clr.nta \\f=[\\r],\\i9",       ldfe_c_clr_nta_f_r_i9},
{"ldfe.c.clr.nta \\f=[\\r],\\r",       ldfe_c_clr_nta_f_r_r},
{"ldfe.c.nc \\f=[\\r]",       ldfe_c_nc_f_r_},
{"ldfe.c.nc \\f=[\\r],\\i9",       ldfe_c_nc_f_r_i9},
{"ldfe.c.nc \\f=[\\r],\\r",       ldfe_c_nc_f_r_r},
{"ldfe.c.nc.nt1 \\f=[\\r]",       ldfe_c_nc_nt1_f_r_},
{"ldfe.c.nc.nt1 \\f=[\\r],\\i9",       ldfe_c_nc_nt1_f_r_i9},
{"ldfe.c.nc.nt1 \\f=[\\r],\\r",       ldfe_c_nc_nt1_f_r_r},
{"ldfe.c.nc.nta \\f=[\\r]",       ldfe_c_nc_nta_f_r_},
{"ldfe.c.nc.nta \\f=[\\r],\\i9",       ldfe_c_nc_nta_f_r_i9},
{"ldfe.c.nc.nta \\f=[\\r],\\r",       ldfe_c_nc_nta_f_r_r},
{"ldfe.nt1 \\f=[\\r]",       ldfe_nt1_f_r_},
{"ldfe.nt1 \\f=[\\r],\\i9",       ldfe_nt1_f_r_i9},
{"ldfe.nt1 \\f=[\\r],\\r",       ldfe_nt1_f_r_r},
{"ldfe.nta \\f=[\\r]",       ldfe_nta_f_r_},
{"ldfe.nta \\f=[\\r],\\i9",       ldfe_nta_f_r_i9},
{"ldfe.nta \\f=[\\r],\\r",       ldfe_nta_f_r_r},
{"ldfe.s \\f=[\\r]",       ldfe_s_f_r_},
{"ldfe.s \\f=[\\r],\\i9",       ldfe_s_f_r_i9},
{"ldfe.s \\f=[\\r],\\r",       ldfe_s_f_r_r},
{"ldfe.sa \\f=[\\r]",       ldfe_sa_f_r_},
{"ldfe.sa \\f=[\\r],\\i9",       ldfe_sa_f_r_i9},
{"ldfe.sa \\f=[\\r],\\r",       ldfe_sa_f_r_r},
{"ldfe.sa.nt1 \\f=[\\r]",       ldfe_sa_nt1_f_r_},
{"ldfe.sa.nt1 \\f=[\\r],\\i9",       ldfe_sa_nt1_f_r_i9},
{"ldfe.sa.nt1 \\f=[\\r],\\r",       ldfe_sa_nt1_f_r_r},
{"ldfe.sa.nta \\f=[\\r]",       ldfe_sa_nta_f_r_},
{"ldfe.sa.nta \\f=[\\r],\\i9",       ldfe_sa_nta_f_r_i9},
{"ldfe.sa.nta \\f=[\\r],\\r",       ldfe_sa_nta_f_r_r},
{"ldfe.s.nt1 \\f=[\\r]",       ldfe_s_nt1_f_r_},
{"ldfe.s.nt1 \\f=[\\r],\\i9",       ldfe_s_nt1_f_r_i9},
{"ldfe.s.nt1 \\f=[\\r],\\r",       ldfe_s_nt1_f_r_r},
{"ldfe.s.nta \\f=[\\r]",       ldfe_s_nta_f_r_},
{"ldfe.s.nta \\f=[\\r],\\i9",       ldfe_s_nta_f_r_i9},
{"ldfe.s.nta \\f=[\\r],\\r",       ldfe_s_nta_f_r_r},
{"ldf.fill \\f=[\\r]",       ldf_fill_f_r_},
{"ldf.fill \\f=[\\r],\\i9",       ldf_fill_f_r_i9},
{"ldf.fill \\f=[\\r],\\r",       ldf_fill_f_r_r},
{"ldf.fill.nt1 \\f=[\\r]",       ldf_fill_nt1_f_r_},
{"ldf.fill.nt1 \\f=[\\r],\\i9",       ldf_fill_nt1_f_r_i9},
{"ldf.fill.nt1 \\f=[\\r],\\r",       ldf_fill_nt1_f_r_r},
{"ldf.fill.nta \\f=[\\r]",       ldf_fill_nta_f_r_},
{"ldf.fill.nta \\f=[\\r],\\i9",       ldf_fill_nta_f_r_i9},
{"ldf.fill.nta \\f=[\\r],\\r",       ldf_fill_nta_f_r_r},
{"ldfp8 \\f,\\f=[\\r]",       ldfp8_f_f_r_},
{"ldfp8 \\f,\\f=[\\r],16",       ldfp8_f_f_r_16},
{"ldfp8.a \\f,\\f=[\\r]",       ldfp8_a_f_f_r_},
{"ldfp8.a \\f,\\f=[\\r],16",       ldfp8_a_f_f_r_16},
{"ldfp8.a.nt1 \\f,\\f=[\\r]",       ldfp8_a_nt1_f_f_r_},
{"ldfp8.a.nt1 \\f,\\f=[\\r],16",       ldfp8_a_nt1_f_f_r_16},
{"ldfp8.a.nta \\f,\\f=[\\r]",       ldfp8_a_nta_f_f_r_},
{"ldfp8.a.nta \\f,\\f=[\\r],16",       ldfp8_a_nta_f_f_r_16},
{"ldfp8.c.clr \\f,\\f=[\\r]",       ldfp8_c_clr_f_f_r_},
{"ldfp8.c.clr \\f,\\f=[\\r],16",       ldfp8_c_clr_f_f_r_16},
{"ldfp8.c.clr.nt1 \\f,\\f=[\\r]",       ldfp8_c_clr_nt1_f_f_r_},
{"ldfp8.c.clr.nt1 \\f,\\f=[\\r],16",       ldfp8_c_clr_nt1_f_f_r_16},
{"ldfp8.c.clr.nta \\f,\\f=[\\r]",       ldfp8_c_clr_nta_f_f_r_},
{"ldfp8.c.clr.nta \\f,\\f=[\\r],16",       ldfp8_c_clr_nta_f_f_r_16},
{"ldfp8.c.nc \\f,\\f=[\\r]",       ldfp8_c_nc_f_f_r_},
{"ldfp8.c.nc \\f,\\f=[\\r],16",       ldfp8_c_nc_f_f_r_16},
{"ldfp8.c.nc.nt1 \\f,\\f=[\\r]",       ldfp8_c_nc_nt1_f_f_r_},
{"ldfp8.c.nc.nt1 \\f,\\f=[\\r],16",       ldfp8_c_nc_nt1_f_f_r_16},
{"ldfp8.c.nc.nta \\f,\\f=[\\r]",       ldfp8_c_nc_nta_f_f_r_},
{"ldfp8.c.nc.nta \\f,\\f=[\\r],16",       ldfp8_c_nc_nta_f_f_r_16},
{"ldfp8.nt1 \\f,\\f=[\\r]",       ldfp8_nt1_f_f_r_},
{"ldfp8.nt1 \\f,\\f=[\\r],16",       ldfp8_nt1_f_f_r_16},
{"ldfp8.nta \\f,\\f=[\\r]",       ldfp8_nta_f_f_r_},
{"ldfp8.nta \\f,\\f=[\\r],16",       ldfp8_nta_f_f_r_16},
{"ldfp8.s \\f,\\f=[\\r]",       ldfp8_s_f_f_r_},
{"ldfp8.s \\f,\\f=[\\r],16",       ldfp8_s_f_f_r_16},
{"ldfp8.sa \\f,\\f=[\\r]",       ldfp8_sa_f_f_r_},
{"ldfp8.sa \\f,\\f=[\\r],16",       ldfp8_sa_f_f_r_16},
{"ldfp8.sa.nt1 \\f,\\f=[\\r]",       ldfp8_sa_nt1_f_f_r_},
{"ldfp8.sa.nt1 \\f,\\f=[\\r],16",       ldfp8_sa_nt1_f_f_r_16},
{"ldfp8.sa.nta \\f,\\f=[\\r]",       ldfp8_sa_nta_f_f_r_},
{"ldfp8.sa.nta \\f,\\f=[\\r],16",       ldfp8_sa_nta_f_f_r_16},
{"ldfp8.s.nt1 \\f,\\f=[\\r]",       ldfp8_s_nt1_f_f_r_},
{"ldfp8.s.nt1 \\f,\\f=[\\r],16",       ldfp8_s_nt1_f_f_r_16},
{"ldfp8.s.nta \\f,\\f=[\\r]",       ldfp8_s_nta_f_f_r_},
{"ldfp8.s.nta \\f,\\f=[\\r],16",       ldfp8_s_nta_f_f_r_16},
{"ldfpd \\f,\\f=[\\r]",       ldfpd_f_f_r_},
{"ldfpd \\f,\\f=[\\r],16",       ldfpd_f_f_r_16},
{"ldfpd.a \\f,\\f=[\\r]",       ldfpd_a_f_f_r_},
{"ldfpd.a \\f,\\f=[\\r],16",       ldfpd_a_f_f_r_16},
{"ldfpd.a.nt1 \\f,\\f=[\\r]",       ldfpd_a_nt1_f_f_r_},
{"ldfpd.a.nt1 \\f,\\f=[\\r],16",       ldfpd_a_nt1_f_f_r_16},
{"ldfpd.a.nta \\f,\\f=[\\r]",       ldfpd_a_nta_f_f_r_},
{"ldfpd.a.nta \\f,\\f=[\\r],16",       ldfpd_a_nta_f_f_r_16},
{"ldfpd.c.clr \\f,\\f=[\\r]",       ldfpd_c_clr_f_f_r_},
{"ldfpd.c.clr \\f,\\f=[\\r],16",       ldfpd_c_clr_f_f_r_16},
{"ldfpd.c.clr.nt1 \\f,\\f=[\\r]",       ldfpd_c_clr_nt1_f_f_r_},
{"ldfpd.c.clr.nt1 \\f,\\f=[\\r],16",       ldfpd_c_clr_nt1_f_f_r_16},
{"ldfpd.c.clr.nta \\f,\\f=[\\r]",       ldfpd_c_clr_nta_f_f_r_},
{"ldfpd.c.clr.nta \\f,\\f=[\\r],16",       ldfpd_c_clr_nta_f_f_r_16},
{"ldfpd.c.nc \\f,\\f=[\\r]",       ldfpd_c_nc_f_f_r_},
{"ldfpd.c.nc \\f,\\f=[\\r],16",       ldfpd_c_nc_f_f_r_16},
{"ldfpd.c.nc.nt1 \\f,\\f=[\\r]",       ldfpd_c_nc_nt1_f_f_r_},
{"ldfpd.c.nc.nt1 \\f,\\f=[\\r],16",       ldfpd_c_nc_nt1_f_f_r_16},
{"ldfpd.c.nc.nta \\f,\\f=[\\r]",       ldfpd_c_nc_nta_f_f_r_},
{"ldfpd.c.nc.nta \\f,\\f=[\\r],16",       ldfpd_c_nc_nta_f_f_r_16},
{"ldfpd.nt1 \\f,\\f=[\\r]",       ldfpd_nt1_f_f_r_},
{"ldfpd.nt1 \\f,\\f=[\\r],16",       ldfpd_nt1_f_f_r_16},
{"ldfpd.nta \\f,\\f=[\\r]",       ldfpd_nta_f_f_r_},
{"ldfpd.nta \\f,\\f=[\\r],16",       ldfpd_nta_f_f_r_16},
{"ldfpd.s \\f,\\f=[\\r]",       ldfpd_s_f_f_r_},
{"ldfpd.s \\f,\\f=[\\r],16",       ldfpd_s_f_f_r_16},
{"ldfpd.sa \\f,\\f=[\\r]",       ldfpd_sa_f_f_r_},
{"ldfpd.sa \\f,\\f=[\\r],16",       ldfpd_sa_f_f_r_16},
{"ldfpd.sa.nt1 \\f,\\f=[\\r]",       ldfpd_sa_nt1_f_f_r_},
{"ldfpd.sa.nt1 \\f,\\f=[\\r],16",       ldfpd_sa_nt1_f_f_r_16},
{"ldfpd.sa.nta \\f,\\f=[\\r]",       ldfpd_sa_nta_f_f_r_},
{"ldfpd.sa.nta \\f,\\f=[\\r],16",       ldfpd_sa_nta_f_f_r_16},
{"ldfpd.s.nt1 \\f,\\f=[\\r]",       ldfpd_s_nt1_f_f_r_},
{"ldfpd.s.nt1 \\f,\\f=[\\r],16",       ldfpd_s_nt1_f_f_r_16},
{"ldfpd.s.nta \\f,\\f=[\\r]",       ldfpd_s_nta_f_f_r_},
{"ldfpd.s.nta \\f,\\f=[\\r],16",       ldfpd_s_nta_f_f_r_16},
{"ldfps \\f,\\f=[\\r]",       ldfps_f_f_r_},
{"ldfps \\f,\\f=[\\r],8",       ldfps_f_f_r_8},
{"ldfps.a \\f,\\f=[\\r]",       ldfps_a_f_f_r_},
{"ldfps.a \\f,\\f=[\\r],8",       ldfps_a_f_f_r_8},
{"ldfps.a.nt1 \\f,\\f=[\\r]",       ldfps_a_nt1_f_f_r_},
{"ldfps.a.nt1 \\f,\\f=[\\r],8",       ldfps_a_nt1_f_f_r_8},
{"ldfps.a.nta \\f,\\f=[\\r]",       ldfps_a_nta_f_f_r_},
{"ldfps.a.nta \\f,\\f=[\\r],8",       ldfps_a_nta_f_f_r_8},
{"ldfps.c.clr \\f,\\f=[\\r]",       ldfps_c_clr_f_f_r_},
{"ldfps.c.clr \\f,\\f=[\\r],8",       ldfps_c_clr_f_f_r_8},
{"ldfps.c.clr.nt1 \\f,\\f=[\\r]",       ldfps_c_clr_nt1_f_f_r_},
{"ldfps.c.clr.nt1 \\f,\\f=[\\r],8",       ldfps_c_clr_nt1_f_f_r_8},
{"ldfps.c.clr.nta \\f,\\f=[\\r]",       ldfps_c_clr_nta_f_f_r_},
{"ldfps.c.clr.nta \\f,\\f=[\\r],8",       ldfps_c_clr_nta_f_f_r_8},
{"ldfps.c.nc \\f,\\f=[\\r]",       ldfps_c_nc_f_f_r_},
{"ldfps.c.nc \\f,\\f=[\\r],8",       ldfps_c_nc_f_f_r_8},
{"ldfps.c.nc.nt1 \\f,\\f=[\\r]",       ldfps_c_nc_nt1_f_f_r_},
{"ldfps.c.nc.nt1 \\f,\\f=[\\r],8",       ldfps_c_nc_nt1_f_f_r_8},
{"ldfps.c.nc.nta \\f,\\f=[\\r]",       ldfps_c_nc_nta_f_f_r_},
{"ldfps.c.nc.nta \\f,\\f=[\\r],8",       ldfps_c_nc_nta_f_f_r_8},
{"ldfps.nt1 \\f,\\f=[\\r]",       ldfps_nt1_f_f_r_},
{"ldfps.nt1 \\f,\\f=[\\r],8",       ldfps_nt1_f_f_r_8},
{"ldfps.nta \\f,\\f=[\\r]",       ldfps_nta_f_f_r_},
{"ldfps.nta \\f,\\f=[\\r],8",       ldfps_nta_f_f_r_8},
{"ldfps.s \\f,\\f=[\\r]",       ldfps_s_f_f_r_},
{"ldfps.s \\f,\\f=[\\r],8",       ldfps_s_f_f_r_8},
{"ldfps.sa \\f,\\f=[\\r]",       ldfps_sa_f_f_r_},
{"ldfps.sa \\f,\\f=[\\r],8",       ldfps_sa_f_f_r_8},
{"ldfps.sa.nt1 \\f,\\f=[\\r]",       ldfps_sa_nt1_f_f_r_},
{"ldfps.sa.nt1 \\f,\\f=[\\r],8",       ldfps_sa_nt1_f_f_r_8},
{"ldfps.sa.nta \\f,\\f=[\\r]",       ldfps_sa_nta_f_f_r_},
{"ldfps.sa.nta \\f,\\f=[\\r],8",       ldfps_sa_nta_f_f_r_8},
{"ldfps.s.nt1 \\f,\\f=[\\r]",       ldfps_s_nt1_f_f_r_},
{"ldfps.s.nt1 \\f,\\f=[\\r],8",       ldfps_s_nt1_f_f_r_8},
{"ldfps.s.nta \\f,\\f=[\\r]",       ldfps_s_nta_f_f_r_},
{"ldfps.s.nta \\f,\\f=[\\r],8",       ldfps_s_nta_f_f_r_8},
{"ldfs \\f=[\\r]",       ldfs_f_r_},
{"ldfs \\f=[\\r],\\i9",       ldfs_f_r_i9},
{"ldfs \\f=[\\r],\\r",       ldfs_f_r_r},
{"ldfs.a \\f=[\\r]",       ldfs_a_f_r_},
{"ldfs.a \\f=[\\r],\\i9",       ldfs_a_f_r_i9},
{"ldfs.a \\f=[\\r],\\r",       ldfs_a_f_r_r},
{"ldfs.a.nt1 \\f=[\\r]",       ldfs_a_nt1_f_r_},
{"ldfs.a.nt1 \\f=[\\r],\\i9",       ldfs_a_nt1_f_r_i9},
{"ldfs.a.nt1 \\f=[\\r],\\r",       ldfs_a_nt1_f_r_r},
{"ldfs.a.nta \\f=[\\r]",       ldfs_a_nta_f_r_},
{"ldfs.a.nta \\f=[\\r],\\i9",       ldfs_a_nta_f_r_i9},
{"ldfs.a.nta \\f=[\\r],\\r",       ldfs_a_nta_f_r_r},
{"ldfs.c.clr \\f=[\\r]",       ldfs_c_clr_f_r_},
{"ldfs.c.clr \\f=[\\r],\\i9",       ldfs_c_clr_f_r_i9},
{"ldfs.c.clr \\f=[\\r],\\r",       ldfs_c_clr_f_r_r},
{"ldfs.c.clr.nt1 \\f=[\\r]",       ldfs_c_clr_nt1_f_r_},
{"ldfs.c.clr.nt1 \\f=[\\r],\\i9",       ldfs_c_clr_nt1_f_r_i9},
{"ldfs.c.clr.nt1 \\f=[\\r],\\r",       ldfs_c_clr_nt1_f_r_r},
{"ldfs.c.clr.nta \\f=[\\r]",       ldfs_c_clr_nta_f_r_},
{"ldfs.c.clr.nta \\f=[\\r],\\i9",       ldfs_c_clr_nta_f_r_i9},
{"ldfs.c.clr.nta \\f=[\\r],\\r",       ldfs_c_clr_nta_f_r_r},
{"ldfs.c.nc \\f=[\\r]",       ldfs_c_nc_f_r_},
{"ldfs.c.nc \\f=[\\r],\\i9",       ldfs_c_nc_f_r_i9},
{"ldfs.c.nc \\f=[\\r],\\r",       ldfs_c_nc_f_r_r},
{"ldfs.c.nc.nt1 \\f=[\\r]",       ldfs_c_nc_nt1_f_r_},
{"ldfs.c.nc.nt1 \\f=[\\r],\\i9",       ldfs_c_nc_nt1_f_r_i9},
{"ldfs.c.nc.nt1 \\f=[\\r],\\r",       ldfs_c_nc_nt1_f_r_r},
{"ldfs.c.nc.nta \\f=[\\r]",       ldfs_c_nc_nta_f_r_},
{"ldfs.c.nc.nta \\f=[\\r],\\i9",       ldfs_c_nc_nta_f_r_i9},
{"ldfs.c.nc.nta \\f=[\\r],\\r",       ldfs_c_nc_nta_f_r_r},
{"ldfs.nt1 \\f=[\\r]",       ldfs_nt1_f_r_},
{"ldfs.nt1 \\f=[\\r],\\i9",       ldfs_nt1_f_r_i9},
{"ldfs.nt1 \\f=[\\r],\\r",       ldfs_nt1_f_r_r},
{"ldfs.nta \\f=[\\r]",       ldfs_nta_f_r_},
{"ldfs.nta \\f=[\\r],\\i9",       ldfs_nta_f_r_i9},
{"ldfs.nta \\f=[\\r],\\r",       ldfs_nta_f_r_r},
{"ldfs.s \\f=[\\r]",       ldfs_s_f_r_},
{"ldfs.s \\f=[\\r],\\i9",       ldfs_s_f_r_i9},
{"ldfs.s \\f=[\\r],\\r",       ldfs_s_f_r_r},
{"ldfs.sa \\f=[\\r]",       ldfs_sa_f_r_},
{"ldfs.sa \\f=[\\r],\\i9",       ldfs_sa_f_r_i9},
{"ldfs.sa \\f=[\\r],\\r",       ldfs_sa_f_r_r},
{"ldfs.sa.nt1 \\f=[\\r]",       ldfs_sa_nt1_f_r_},
{"ldfs.sa.nt1 \\f=[\\r],\\i9",       ldfs_sa_nt1_f_r_i9},
{"ldfs.sa.nt1 \\f=[\\r],\\r",       ldfs_sa_nt1_f_r_r},
{"ldfs.sa.nta \\f=[\\r]",       ldfs_sa_nta_f_r_},
{"ldfs.sa.nta \\f=[\\r],\\i9",       ldfs_sa_nta_f_r_i9},
{"ldfs.sa.nta \\f=[\\r],\\r",       ldfs_sa_nta_f_r_r},
{"ldfs.s.nt1 \\f=[\\r]",       ldfs_s_nt1_f_r_},
{"ldfs.s.nt1 \\f=[\\r],\\i9",       ldfs_s_nt1_f_r_i9},
{"ldfs.s.nt1 \\f=[\\r],\\r",       ldfs_s_nt1_f_r_r},
{"ldfs.s.nta \\f=[\\r]",       ldfs_s_nta_f_r_},
{"ldfs.s.nta \\f=[\\r],\\i9",       ldfs_s_nta_f_r_i9},
{"ldfs.s.nta \\f=[\\r],\\r",       ldfs_s_nta_f_r_r},
{"lfetch [\\r]",       lfetch_r_},
{"lfetch [\\r],\\i9",       lfetch_r_i9},
{"lfetch [\\r],\\r",       lfetch_r_r},
{"lfetch.excl [\\r]",       lfetch_excl_r_},
{"lfetch.excl [\\r],\\i9",       lfetch_excl_r_i9},
{"lfetch.excl [\\r],\\r",       lfetch_excl_r_r},
{"lfetch.excl.nt1 [\\r]",       lfetch_excl_nt1_r_},
{"lfetch.excl.nt1 [\\r],\\i9",       lfetch_excl_nt1_r_i9},
{"lfetch.excl.nt1 [\\r],\\r",       lfetch_excl_nt1_r_r},
{"lfetch.excl.nt2 [\\r]",       lfetch_excl_nt2_r_},
{"lfetch.excl.nt2 [\\r],\\i9",       lfetch_excl_nt2_r_i9},
{"lfetch.excl.nt2 [\\r],\\r",       lfetch_excl_nt2_r_r},
{"lfetch.excl.nta [\\r]",       lfetch_excl_nta_r_},
{"lfetch.excl.nta [\\r],\\i9",       lfetch_excl_nta_r_i9},
{"lfetch.excl.nta [\\r],\\r",       lfetch_excl_nta_r_r},
{"lfetch.fault [\\r]",       lfetch_fault_r_},
{"lfetch.fault [\\r],\\i9",       lfetch_fault_r_i9},
{"lfetch.fault [\\r],\\r",       lfetch_fault_r_r},
{"lfetch.fault.excl [\\r]",       lfetch_fault_excl_r_},
{"lfetch.fault.excl [\\r],\\i9",       lfetch_fault_excl_r_i9},
{"lfetch.fault.excl [\\r],\\r",       lfetch_fault_excl_r_r},
{"lfetch.fault.excl.nt1 [\\r]",       lfetch_fault_excl_nt1_r_},
{"lfetch.fault.excl.nt1 [\\r],\\i9",       lfetch_fault_excl_nt1_r_i9},
{"lfetch.fault.excl.nt1 [\\r],\\r",       lfetch_fault_excl_nt1_r_r},
{"lfetch.fault.excl.nt2 [\\r]",       lfetch_fault_excl_nt2_r_},
{"lfetch.fault.excl.nt2 [\\r],\\i9",       lfetch_fault_excl_nt2_r_i9},
{"lfetch.fault.excl.nt2 [\\r],\\r",       lfetch_fault_excl_nt2_r_r},
{"lfetch.fault.excl.nta [\\r]",       lfetch_fault_excl_nta_r_},
{"lfetch.fault.excl.nta [\\r],\\i9",       lfetch_fault_excl_nta_r_i9},
{"lfetch.fault.excl.nta [\\r],\\r",       lfetch_fault_excl_nta_r_r},
{"lfetch.fault.nt1 [\\r]",       lfetch_fault_nt1_r_},
{"lfetch.fault.nt1 [\\r],\\i9",       lfetch_fault_nt1_r_i9},
{"lfetch.fault.nt1 [\\r],\\r",       lfetch_fault_nt1_r_r},
{"lfetch.fault.nt2 [\\r]",       lfetch_fault_nt2_r_},
{"lfetch.fault.nt2 [\\r],\\i9",       lfetch_fault_nt2_r_i9},
{"lfetch.fault.nt2 [\\r],\\r",       lfetch_fault_nt2_r_r},
{"lfetch.fault.nta [\\r]",       lfetch_fault_nta_r_},
{"lfetch.fault.nta [\\r],\\i9",       lfetch_fault_nta_r_i9},
{"lfetch.fault.nta [\\r],\\r",       lfetch_fault_nta_r_r},
{"lfetch.nt1 [\\r]",       lfetch_nt1_r_},
{"lfetch.nt1 [\\r],\\i9",       lfetch_nt1_r_i9},
{"lfetch.nt1 [\\r],\\r",       lfetch_nt1_r_r},
{"lfetch.nt2 [\\r]",       lfetch_nt2_r_},
{"lfetch.nt2 [\\r],\\i9",       lfetch_nt2_r_i9},
{"lfetch.nt2 [\\r],\\r",       lfetch_nt2_r_r},
{"lfetch.nta [\\r]",       lfetch_nta_r_},
{"lfetch.nta [\\r],\\i9",       lfetch_nta_r_i9},
{"lfetch.nta [\\r],\\r",       lfetch_nta_r_r},
{"mf",       mf},
{"mf.a",       mf_a},
{"mix1.l \\r=\\r,\\r",       mix1_l_r_r_r},
{"mix1.r \\r=\\r,\\r",       mix1_r_r_r_r},
{"mix2.l \\r=\\r,\\r",       mix2_l_r_r_r},
{"mix2.r \\r=\\r,\\r",       mix2_r_r_r_r},
{"mix4.l \\r=\\r,\\r",       mix4_l_r_r_r},
{"mix4.r \\r=\\r,\\r",       mix4_r_r_r_r},
{"mov \\ar=\\r",       mov_ar_r},
{"mov \\b=\\r",       mov_b_r},
{"mov \\f=\\f",       mov_f_f},
{"mov pr=\\r,\\i17",       mov_pr_r_i17},
{"mov pr.rot=\\i44",       mov_pr_rot_i44},
{"mov psr.um=\\r",       mov_psr_um_r},
{"mov \\r=\\ar",       mov_r_ar},
{"mov \\r=\\b",       mov_r_b},
{"mov \\r=cpuid[\\r]",       mov_r_cpuid_r_},
{"mov \\r=\\i22",       mov_r_i22},
{"mov \\r=\\i8",       mov_r_i8},
{"mov \\r=ip",       mov_r_ip},
{"mov \\r=pmd[\\r]",       mov_r_pmd_r_},
{"mov \\r=pr",       mov_r_pr},
{"mov \\r=psr.um",       mov_r_psr_um},
{"mov \\r=\\r",       mov_r_r},
{"mov.i \\ar=\\r",       mov_i_ar_r},
{"mov.i \\r=\\ar",       mov_i_r_ar},
{"mov.i \\r=\\i8",       mov_i_r_i8},
{"movl \\r=\\i64",       movl_r_i64},
{"mov.m \\ar=\\r",       mov_m_ar_r},
{"mov.m \\r=\\ar",       mov_m_r_ar},
{"mov.m \\r=\\i8",       mov_m_r_i8},
{"mov.ret \\b=\\r",       mov_ret_b_r},
{"mov.ret \\r=\\b",       mov_ret_r_b},
{"mux1 \\r=\\r,@alt",       mux1_r_r_alt},
{"mux1 \\r=\\r,@brcst",       mux1_r_r_brcst},
{"mux1 \\r=\\r,@mix",       mux1_r_r_mix},
{"mux1 \\r=\\r,@rev",       mux1_r_r_rev},
{"mux1 \\r=\\r,@shuf",       mux1_r_r_shuf},
{"mux2 \\r=\\r,\\u8",       mux2_r_r_u8},
{"nop \\i21",       nop_i21},
{"nop.b \\i21",       nop_b_i21},
{"nop.f \\i21",       nop_f_i21},
{"nop.i \\i21",       nop_i_i21},
{"nop.m \\i21",       nop_m_i21},
{"nop.x \\i62",       nop_x_i62},
{"or \\r=\\i8,\\r",       or_r_i8_r},
{"or \\r=\\r,\\r",       or_r_r_r},
{"pack2.sss \\r=\\r,\\r",       pack2_sss_r_r_r},
{"pack2.uss \\r=\\r,\\r",       pack2_uss_r_r_r},
{"pack4.sss \\r=\\r,\\r",       pack4_sss_r_r_r},
{"padd1 \\r=\\r,\\r",       padd1_r_r_r},
{"padd1.sss \\r=\\r,\\r",       padd1_sss_r_r_r},
{"padd1.uus \\r=\\r,\\r",       padd1_uus_r_r_r},
{"padd1.uuu \\r=\\r,\\r",       padd1_uuu_r_r_r},
{"padd2 \\r=\\r,\\r",       padd2_r_r_r},
{"padd2.sss \\r=\\r,\\r",       padd2_sss_r_r_r},
{"padd2.uus \\r=\\r,\\r",       padd2_uus_r_r_r},
{"padd2.uuu \\r=\\r,\\r",       padd2_uuu_r_r_r},
{"padd4 \\r=\\r,\\r",       padd4_r_r_r},
{"pavg1 \\r=\\r,\\r",       pavg1_r_r_r},
{"pavg1.raz \\r=\\r,\\r",       pavg1_raz_r_r_r},
{"pavg2 \\r=\\r,\\r",       pavg2_r_r_r},
{"pavg2.raz \\r=\\r,\\r",       pavg2_raz_r_r_r},
{"pavgsub1 \\r=\\r,\\r",       pavgsub1_r_r_r},
{"pavgsub2 \\r=\\r,\\r",       pavgsub2_r_r_r},
{"pcmp1.eq \\r=\\r,\\r",       pcmp1_eq_r_r_r},
{"pcmp1.gt \\r=\\r,\\r",       pcmp1_gt_r_r_r},
{"pcmp2.eq \\r=\\r,\\r",       pcmp2_eq_r_r_r},
{"pcmp2.gt \\r=\\r,\\r",       pcmp2_gt_r_r_r},
{"pcmp4.eq \\r=\\r,\\r",       pcmp4_eq_r_r_r},
{"pcmp4.gt \\r=\\r,\\r",       pcmp4_gt_r_r_r},
{"pmax1.u \\r=\\r,\\r",       pmax1_u_r_r_r},
{"pmax2 \\r=\\r,\\r",       pmax2_r_r_r},
{"pmin1.u \\r=\\r,\\r",       pmin1_u_r_r_r},
{"pmin2 \\r=\\r,\\r",       pmin2_r_r_r},
{"pmpy2.l \\r=\\r,\\r",       pmpy2_l_r_r_r},
{"pmpy2.r \\r=\\r,\\r",       pmpy2_r_r_r_r},
{"pmpyshr2 \\r=\\r,\\r,\\u2",       pmpyshr2_r_r_r_u2},
{"pmpyshr2.u \\r=\\r,\\r,\\u2",       pmpyshr2_u_r_r_r_u2},
{"popcnt \\r=\\r",       popcnt_r_r},
{"psad1 \\r=\\r,\\r",       psad1_r_r_r},
{"pshl2 \\r=\\r,\\u5",       pshl2_r_r_u5},
{"pshl2 \\r=\\r,\\r",       pshl2_r_r_r},
{"pshl4 \\r=\\r,\\u5",       pshl4_r_r_u5},
{"pshl4 \\r=\\r,\\r",       pshl4_r_r_r},
{"pshladd2 \\r=\\r,\\u2,\\r",       pshladd2_r_r_u2_r},
{"pshr2 \\r=\\r,\\u5",       pshr2_r_r_u5},
{"pshr2 \\r=\\r,\\r",       pshr2_r_r_r},
{"pshr2u \\r=\\r,\\u5",       pshr2u_r_r_u5},
{"pshr2u \\r=\\r,\\r",       pshr2u_r_r_r},
{"pshr4 \\r=\\r,\\u5",       pshr4_r_r_u5},
{"pshr4 \\r=\\r,\\r",       pshr4_r_r_r},
{"pshr4u \\r=\\r,\\u5",       pshr4u_r_r_u5},
{"pshr4u \\r=\\r,\\r",       pshr4u_r_r_r},
{"pshradd2 \\r=\\r,\\u2,\\r",       pshradd2_r_r_u2_r},
{"psub1 \\r=\\r,\\r",       psub1_r_r_r},
{"psub1.sss \\r=\\r,\\r",       psub1_sss_r_r_r},
{"psub1.uus \\r=\\r,\\r",       psub1_uus_r_r_r},
{"psub1.uuu \\r=\\r,\\r",       psub1_uuu_r_r_r},
{"psub2 \\r=\\r,\\r",       psub2_r_r_r},
{"psub2.sss \\r=\\r,\\r",       psub2_sss_r_r_r},
{"psub2.uus \\r=\\r,\\r",       psub2_uus_r_r_r},
{"psub2.uuu \\r=\\r,\\r",       psub2_uuu_r_r_r},
{"psub4 \\r=\\r,\\r",       psub4_r_r_r},
{"rum \\i24",       rum_i24},
{"setf.d \\f=\\r",       setf_d_f_r},
{"setf.exp \\f=\\r",       setf_exp_f_r},
{"setf.s \\f=\\r",       setf_s_f_r},
{"setf.sig \\f=\\r",       setf_sig_f_r},
{"shl \\r=\\r,\\u6",       shl_r_r_u6},
{"shl \\r=\\r,\\r",       shl_r_r_r},
{"shladd \\r=\\r,\\u2,\\r",       shladd_r_r_u2_r},
{"shladdp4 \\r=\\r,\\u2,\\r",       shladdp4_r_r_u2_r},
{"shr \\r=\\r,\\u6",       shr_r_r_u6},
{"shr \\r=\\r,\\r",       shr_r_r_r},
{"shrp \\r=\\r,\\r,\\u6",       shrp_r_r_r_u6},
{"shr.u \\r=\\r,\\u6",       shr_u_r_r_u6},
{"shr.u \\r=\\r,\\r",       shr_u_r_r_r},
{"srlz.i",       srlz_i},
{"st1 [\\r]=\\r",       st1_r_r},
{"st1 [\\r]=\\r,\\i9",       st1_r_r_i9},
{"st1.nta [\\r]=\\r",       st1_nta_r_r},
{"st1.nta [\\r]=\\r,\\i9",       st1_nta_r_r_i9},
{"st1.rel [\\r]=\\r",       st1_rel_r_r},
{"st1.rel [\\r]=\\r,\\i9",       st1_rel_r_r_i9},
{"st1.rel.nta [\\r]=\\r",       st1_rel_nta_r_r},
{"st1.rel.nta [\\r]=\\r,\\i9",       st1_rel_nta_r_r_i9},
{"st2 [\\r]=\\r",       st2_r_r},
{"st2 [\\r]=\\r,\\i9",       st2_r_r_i9},
{"st2.nta [\\r]=\\r",       st2_nta_r_r},
{"st2.nta [\\r]=\\r,\\i9",       st2_nta_r_r_i9},
{"st2.rel [\\r]=\\r",       st2_rel_r_r},
{"st2.rel [\\r]=\\r,\\i9",       st2_rel_r_r_i9},
{"st2.rel.nta [\\r]=\\r",       st2_rel_nta_r_r},
{"st2.rel.nta [\\r]=\\r,\\i9",       st2_rel_nta_r_r_i9},
{"st4 [\\r]=\\r",       st4_r_r},
{"st4 [\\r]=\\r,\\i9",       st4_r_r_i9},
{"st4.nta [\\r]=\\r",       st4_nta_r_r},
{"st4.nta [\\r]=\\r,\\i9",       st4_nta_r_r_i9},
{"st4.rel [\\r]=\\r",       st4_rel_r_r},
{"st4.rel [\\r]=\\r,\\i9",       st4_rel_r_r_i9},
{"st4.rel.nta [\\r]=\\r",       st4_rel_nta_r_r},
{"st4.rel.nta [\\r]=\\r,\\i9",       st4_rel_nta_r_r_i9},
{"st8 [\\r]=\\r",       st8_r_r},
{"st8 [\\r]=\\r,\\i9",       st8_r_r_i9},
{"st8.nta [\\r]=\\r",       st8_nta_r_r},
{"st8.nta [\\r]=\\r,\\i9",       st8_nta_r_r_i9},
{"st8.rel [\\r]=\\r",       st8_rel_r_r},
{"st8.rel [\\r]=\\r,\\i9",       st8_rel_r_r_i9},
{"st8.rel.nta [\\r]=\\r",       st8_rel_nta_r_r},
{"st8.rel.nta [\\r]=\\r,\\i9",       st8_rel_nta_r_r_i9},
{"st8.spill [\\r]=\\r",       st8_spill_r_r},
{"st8.spill [\\r]=\\r,\\i9",       st8_spill_r_r_i9},
{"st8.spill.nta [\\r]=\\r",       st8_spill_nta_r_r},
{"st8.spill.nta [\\r]=\\r,\\i9",       st8_spill_nta_r_r_i9},
{"stf8 [\\r]=\\f",       stf8_r_f},
{"stf8 [\\r]=\\f,\\i9",       stf8_r_f_i9},
{"stf8.nta [\\r]=\\f",       stf8_nta_r_f},
{"stf8.nta [\\r]=\\f,\\i9",       stf8_nta_r_f_i9},
{"stfd [\\r]=\\f",       stfd_r_f},
{"stfd [\\r]=\\f,\\i9",       stfd_r_f_i9},
{"stfd.nta [\\r]=\\f",       stfd_nta_r_f},
{"stfd.nta [\\r]=\\f,\\i9",       stfd_nta_r_f_i9},
{"stfe [\\r]=\\f",       stfe_r_f},
{"stfe [\\r]=\\f,\\i9",       stfe_r_f_i9},
{"stfe.nta [\\r]=\\f",       stfe_nta_r_f},
{"stfe.nta [\\r]=\\f,\\i9",       stfe_nta_r_f_i9},
{"stfs [\\r]=\\f",       stfs_r_f},
{"stfs [\\r]=\\f,\\i9",       stfs_r_f_i9},
{"stfs.nta [\\r]=\\f",       stfs_nta_r_f},
{"stfs.nta [\\r]=\\f,\\i9",       stfs_nta_r_f_i9},
{"stf.spill [\\r]=\\f",       stf_spill_r_f},
{"stf.spill [\\r]=\\f,\\i9",       stf_spill_r_f_i9},
{"stf.spill.nta [\\r]=\\f",       stf_spill_nta_r_f},
{"stf.spill.nta [\\r]=\\f,\\i9",       stf_spill_nta_r_f_i9},
{"sub \\r=\\i8,\\r",       sub_r_i8_r},
{"sub \\r=\\r,\\r",       sub_r_r_r},
{"sub \\r=\\r,\\r,1",       sub_r_r_r_1},
{"sum \\i24",       sum_i24},
{"sxt1 \\r=\\r",       sxt1_r_r},
{"sxt2 \\r=\\r",       sxt2_r_r},
{"sxt4 \\r=\\r",       sxt4_r_r},
{"sync.i",       sync_i},
{"tbit.nz \\p,\\p=\\r,\\u6",       tbit_nz_p_p_r_u6},
{"tbit.nz.and \\p,\\p=\\r,\\u6",       tbit_nz_and_p_p_r_u6},
{"tbit.nz.andcm \\p,\\p=\\r,\\u6",       tbit_nz_andcm_p_p_r_u6},
{"tbit.nz.and.orcm \\p,\\p=\\r,\\u6",       tbit_nz_and_orcm_p_p_r_u6},
{"tbit.nz.or \\p,\\p=\\r,\\u6",       tbit_nz_or_p_p_r_u6},
{"tbit.nz.or.andcm \\p,\\p=\\r,\\u6",       tbit_nz_or_andcm_p_p_r_u6},
{"tbit.nz.orcm \\p,\\p=\\r,\\u6",       tbit_nz_orcm_p_p_r_u6},
{"tbit.nz.unc \\p,\\p=\\r,\\u6",       tbit_nz_unc_p_p_r_u6},
{"tbit.z \\p,\\p=\\r,\\u6",       tbit_z_p_p_r_u6},
{"tbit.z.and \\p,\\p=\\r,\\u6",       tbit_z_and_p_p_r_u6},
{"tbit.z.andcm \\p,\\p=\\r,\\u6",       tbit_z_andcm_p_p_r_u6},
{"tbit.z.and.orcm \\p,\\p=\\r,\\u6",       tbit_z_and_orcm_p_p_r_u6},
{"tbit.z.or \\p,\\p=\\r,\\u6",       tbit_z_or_p_p_r_u6},
{"tbit.z.or.andcm \\p,\\p=\\r,\\u6",       tbit_z_or_andcm_p_p_r_u6},
{"tbit.z.orcm \\p,\\p=\\r,\\u6",       tbit_z_orcm_p_p_r_u6},
{"tbit.z.unc \\p,\\p=\\r,\\u6",       tbit_z_unc_p_p_r_u6},
{"tnat.nz \\p,\\p=\\r",       tnat_nz_p_p_r},
{"tnat.nz.and \\p,\\p=\\r",       tnat_nz_and_p_p_r},
{"tnat.nz.andcm \\p,\\p=\\r",       tnat_nz_andcm_p_p_r},
{"tnat.nz.and.orcm \\p,\\p=\\r",       tnat_nz_and_orcm_p_p_r},
{"tnat.nz.or \\p,\\p=\\r",       tnat_nz_or_p_p_r},
{"tnat.nz.or.andcm \\p,\\p=\\r",       tnat_nz_or_andcm_p_p_r},
{"tnat.nz.orcm \\p,\\p=\\r",       tnat_nz_orcm_p_p_r},
{"tnat.nz.unc \\p,\\p=\\r",       tnat_nz_unc_p_p_r},
{"tnat.z \\p,\\p=\\r",       tnat_z_p_p_r},
{"tnat.z.and \\p,\\p=\\r",       tnat_z_and_p_p_r},
{"tnat.z.andcm \\p,\\p=\\r",       tnat_z_andcm_p_p_r},
{"tnat.z.and.orcm \\p,\\p=\\r",       tnat_z_and_orcm_p_p_r},
{"tnat.z.or \\p,\\p=\\r",       tnat_z_or_p_p_r},
{"tnat.z.or.andcm \\p,\\p=\\r",       tnat_z_or_andcm_p_p_r},
{"tnat.z.orcm \\p,\\p=\\r",       tnat_z_orcm_p_p_r},
{"tnat.z.unc \\p,\\p=\\r",       tnat_z_unc_p_p_r},
{"unpack1h \\r=\\r,\\r",       unpack1h_r_r_r},
{"unpack1l \\r=\\r,\\r",       unpack1l_r_r_r},
{"unpack2h \\r=\\r,\\r",       unpack2h_r_r_r},
{"unpack2l \\r=\\r,\\r",       unpack2l_r_r_r},
{"unpack4h \\r=\\r,\\r",       unpack4h_r_r_r},
{"unpack4l \\r=\\r,\\r",       unpack4l_r_r_r},
{"xchg1 \\r=[\\r],\\r",       xchg1_r_r_r},
{"xchg1.nt1 \\r=[\\r],\\r",       xchg1_nt1_r_r_r},
{"xchg1.nta \\r=[\\r],\\r",       xchg1_nta_r_r_r},
{"xchg2 \\r=[\\r],\\r",       xchg2_r_r_r},
{"xchg2.nt1 \\r=[\\r],\\r",       xchg2_nt1_r_r_r},
{"xchg2.nta \\r=[\\r],\\r",       xchg2_nta_r_r_r},
{"xchg4 \\r=[\\r],\\r",       xchg4_r_r_r},
{"xchg4.nt1 \\r=[\\r],\\r",       xchg4_nt1_r_r_r},
{"xchg4.nta \\r=[\\r],\\r",       xchg4_nta_r_r_r},
{"xchg8 \\r=[\\r],\\r",       xchg8_r_r_r},
{"xchg8.nt1 \\r=[\\r],\\r",       xchg8_nt1_r_r_r},
{"xchg8.nta \\r=[\\r],\\r",       xchg8_nta_r_r_r},
{"xma.h \\f=\\f,\\f,\\f",       xma_h_f_f_f_f},
{"xma.hu \\f=\\f,\\f,\\f",       xma_hu_f_f_f_f},
{"xma.l \\f=\\f,\\f,\\f",       xma_l_f_f_f_f},
{"xma.lu \\f=\\f,\\f,\\f",       xma_lu_f_f_f_f},
{"xmpy.h \\f=\\f,\\f",       xmpy_h_f_f_f},
{"xmpy.hu \\f=\\f,\\f",       xmpy_hu_f_f_f},
{"xmpy.l \\f=\\f,\\f",       xmpy_l_f_f_f},
{"xmpy.lu \\f=\\f,\\f",       xmpy_lu_f_f_f},
{"xor \\r=\\i8,\\r",       xor_r_i8_r},
{"xor \\r=\\r,\\r",       xor_r_r_r},
{"zxt1 \\r=\\r",       zxt1_r_r},
{"zxt2 \\r=\\r",       zxt2_r_r},
{"zxt4 \\r=\\r",       zxt4_r_r}

};
