/*
 * Decompiled with CFR 0.152.
 */
package lts;

import java.util.LinkedList;
import lts.MyHashQueueEntry;
import lts.StackCheck;
import lts.StateCodec;

public class MyHashQueue
implements StackCheck {
    private MyHashQueueEntry[] table;
    private int count = 0;
    private MyHashQueueEntry head = null;
    private MyHashQueueEntry tail = null;

    public MyHashQueue(int n) {
        this.table = new MyHashQueueEntry[n];
    }

    public void addPut(byte[] byArray, int n, MyHashQueueEntry myHashQueueEntry) {
        MyHashQueueEntry myHashQueueEntry2 = new MyHashQueueEntry(byArray, n, myHashQueueEntry);
        if (myHashQueueEntry != null) {
            myHashQueueEntry2.level = myHashQueueEntry.level + 1;
        }
        int n2 = StateCodec.hash(byArray) % this.table.length;
        myHashQueueEntry2.next = this.table[n2];
        this.table[n2] = myHashQueueEntry2;
        ++this.count;
        if (this.head == null) {
            this.head = this.tail = myHashQueueEntry2;
        } else {
            this.tail.link = myHashQueueEntry2;
            this.tail = myHashQueueEntry2;
        }
    }

    public MyHashQueueEntry peek() {
        return this.head;
    }

    public void pop() {
        this.head = this.head.link;
        if (this.head == null) {
            this.tail = this.head;
        }
    }

    public boolean empty() {
        return this.head == null;
    }

    public boolean containsKey(byte[] byArray) {
        int n = StateCodec.hash(byArray) % this.table.length;
        MyHashQueueEntry myHashQueueEntry = this.table[n];
        while (myHashQueueEntry != null) {
            if (StateCodec.equals(myHashQueueEntry.key, byArray)) {
                return true;
            }
            myHashQueueEntry = myHashQueueEntry.next;
        }
        return false;
    }

    public boolean onStack(byte[] byArray) {
        int n = StateCodec.hash(byArray) % this.table.length;
        MyHashQueueEntry myHashQueueEntry = this.table[n];
        while (myHashQueueEntry != null) {
            if (StateCodec.equals(myHashQueueEntry.key, byArray)) {
                return myHashQueueEntry.level <= this.head.level;
            }
            myHashQueueEntry = myHashQueueEntry.next;
        }
        return false;
    }

    public int size() {
        return this.count;
    }

    public LinkedList getPath(MyHashQueueEntry myHashQueueEntry, String[] stringArray) {
        LinkedList<String> linkedList = new LinkedList<String>();
        while (myHashQueueEntry != null) {
            if (myHashQueueEntry.parent != null) {
                linkedList.addFirst(stringArray[myHashQueueEntry.action]);
            }
            myHashQueueEntry = myHashQueueEntry.parent;
        }
        return linkedList;
    }

    public int depth(MyHashQueueEntry myHashQueueEntry) {
        int n = 0;
        while (myHashQueueEntry != null) {
            ++n;
            myHashQueueEntry = myHashQueueEntry.parent;
        }
        return n;
    }
}

