/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.fonts;

import java.awt.Font;
import java.lang.reflect.Field;
import javax.swing.plaf.UIResource;

public class PatchedFontUIResource
extends Font
implements UIResource {
    private static final Field font2DHandleField;
    private static final Field createdFontField;

    public PatchedFontUIResource(Font font) {
        super(font.getAttributes());
        PatchedFontUIResource.workaround6313541(font, this);
    }

    public static Font wrapIfPossible(Font font) {
        return PatchedFontUIResource.doesPatchWork() ? new PatchedFontUIResource(font) : font;
    }

    public static boolean doesPatchWork() {
        return font2DHandleField != null;
    }

    public PatchedFontUIResource(String name, int style, int size) {
        super(name, style, size);
    }

    protected static void workaround6313541(Font src, Font dst) {
        if (PatchedFontUIResource.doesPatchWork() && !dst.getFontName().equals(src.getFontName())) {
            try {
                font2DHandleField.set(dst, font2DHandleField.get(src));
                createdFontField.set(dst, createdFontField.get(src));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        Field fField = null;
        Field cField = null;
        try {
            fField = Font.class.getDeclaredField("font2DHandle");
            fField.setAccessible(true);
            cField = Font.class.getDeclaredField("createdFont");
            cField.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        font2DHandleField = fField;
        createdFontField = cField;
    }
}

