package storagepool

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// DiskPoolZonesClient is the client for the DiskPoolZones methods of the Storagepool service.
type DiskPoolZonesClient struct {
	BaseClient
}

// NewDiskPoolZonesClient creates an instance of the DiskPoolZonesClient client.
func NewDiskPoolZonesClient(subscriptionID string) DiskPoolZonesClient {
	return NewDiskPoolZonesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewDiskPoolZonesClientWithBaseURI creates an instance of the DiskPoolZonesClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewDiskPoolZonesClientWithBaseURI(baseURI string, subscriptionID string) DiskPoolZonesClient {
	return DiskPoolZonesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// List lists available Disk Pool Skus in an Azure location.
// Parameters:
// location - the location of the resource.
func (client DiskPoolZonesClient) List(ctx context.Context, location string) (result DiskPoolZoneListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiskPoolZonesClient.List")
		defer func() {
			sc := -1
			if result.dpzlr.Response.Response != nil {
				sc = result.dpzlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.MinLength, Rule: 1, Chain: nil}}}}); err != nil {
		return result, validation.NewError("storagepool.DiskPoolZonesClient", "List", err.Error())
	}

	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, location)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagepool.DiskPoolZonesClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.dpzlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "storagepool.DiskPoolZonesClient", "List", resp, "Failure sending request")
		return
	}

	result.dpzlr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagepool.DiskPoolZonesClient", "List", resp, "Failure responding to request")
		return
	}
	if result.dpzlr.hasNextLink() && result.dpzlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client DiskPoolZonesClient) ListPreparer(ctx context.Context, location string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.StoragePool/locations/{location}/diskPoolZones", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client DiskPoolZonesClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client DiskPoolZonesClient) ListResponder(resp *http.Response) (result DiskPoolZoneListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client DiskPoolZonesClient) listNextResults(ctx context.Context, lastResults DiskPoolZoneListResult) (result DiskPoolZoneListResult, err error) {
	req, err := lastResults.diskPoolZoneListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "storagepool.DiskPoolZonesClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "storagepool.DiskPoolZonesClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "storagepool.DiskPoolZonesClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client DiskPoolZonesClient) ListComplete(ctx context.Context, location string) (result DiskPoolZoneListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/DiskPoolZonesClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, location)
	return
}
