# Grafeas Versioning Explained: API vs Server vs Client

Grafeas project uses a mix of [Google Cloud](https://cloud.google.com/apis/design/versioning) and [semantic versioning](https://semver.org/).
This document clarifies the rationale behind this mix in versioning approaches.

## API

Grafeas API follows Google Cloud versioning scheme: v1alpha1, v1beta1, v1, etc.
This allows us to keep it in sync with GCP implementation, [Container
Analysis](https://cloud.google.com/container-registry/docs/get-image-vulnerabilities).

## Server

Grafeas server uses semantic versioning. The current `0.1.0` release supports
`v1beta1` of the API, with the plan of stable versions supporting stable API
versions. This allows to communicate to the open source community the production
readiness aspect of the Grafeas server, as well as differentiate between bug
fixes, minor and major feature releases.

## Client Library

Grafeas client libraries are currently maintained by the Grafeas team from the
code generated by Swagger. This may change in the future, as the community
contributions increase. Client libraries will use semantic versioning, to make
it easier for the community to follow and contribute. The plan is to let the
community to take over maintenance of these libraries in long-term.

Google also produces a set of Grafeas client libraries that are supported by an
internal team.
