/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.openoffice.xmerge.Document;
import writer2latex.latex.LaTeXDocumentPortion;

public class LaTeXDocument
implements Document {
    private static final String FILE_EXTENSION = ".tex";
    private String sName;
    private String sEncoding = "ASCII";
    private LaTeXDocumentPortion contents;

    public LaTeXDocument(String sName) {
        this.sName = this.trimDocumentName(sName);
        this.contents = new LaTeXDocumentPortion(true);
    }

    public void read(InputStream docData) throws IOException {
    }

    public String getName() {
        return this.sName;
    }

    public String getFileName() {
        return new String(this.sName + FILE_EXTENSION);
    }

    public void write(OutputStream os) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(os, this.sEncoding);
        this.contents.write(osw, 72, "\n");
        osw.flush();
        osw.close();
    }

    public void setEncoding(String sEncoding) {
        this.sEncoding = sEncoding;
    }

    public LaTeXDocumentPortion getContents() {
        return this.contents;
    }

    private String trimDocumentName(String name) {
        String temp = name.toLowerCase();
        if (temp.endsWith(FILE_EXTENSION)) {
            int nlen = name.length();
            int endIndex = nlen - FILE_EXTENSION.length();
            name = name.substring(0, endIndex);
        }
        return name;
    }

    static {
        FILE_EXTENSION = FILE_EXTENSION;
    }
}

