/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2002;

import finanze.IDTE.resources.Controlli;
import finanze.IDTE.resources.ResourceLoader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class BaseTelem {
    private static BaseTelem self = null;
    private Controlli[] controlli = new Controlli[3];
    private Controlli recordAcontrolli;
    private Controlli recordBcontrolli;
    private Controlli recordZcontrolli;
    private RepDescrizioni descrizioni;
    public static final int CTRL_AZ = 1;
    public static final int CTRL_B = 2;
    public static final int CTRL_VAR = 4;
    public static final int POS_ALTRI = 0;
    public static final int POS_770 = 1;
    public static final int POS_IVA = 2;
    public static final int VALUE_INTERNET = 0;
    public static final int VALUE_NO_INTERNET = 1;
    public static final int ASSISTENZA = 0;
    public static final int CONTROLLI = 1;
    public static final int SERVER = 2;
    public static final int IMPORT = 3;
    public static final int RICEVUTE = 4;
    public static int currentSystem = 1;

    private BaseTelem() {
    }

    public Controlli getControlli(String tipoModello) {
        return this.controlli[this.getControlliIndex(tipoModello)];
    }

    public int getControlliIndex(String tipoModello) {
        if (tipoModello.equals("770")) {
            return 1;
        }
        if (tipoModello.equals("IVA")) {
            return 2;
        }
        return 0;
    }

    public String getDescrizione(String codice) {
        return this.descrizioni.getDescrizione(codice);
    }

    public static BaseTelem getInstance() {
        if (self == null) {
            self = new BaseTelem();
        }
        return self;
    }

    public Controlli getRecordAcontrolli() {
        return this.recordAcontrolli;
    }

    public Controlli getRecordBcontrolli() {
        return this.recordBcontrolli;
    }

    public Controlli getRecordZcontrolli() {
        return this.recordZcontrolli;
    }

    public void riempiControlli(int recMask, String tipoModello, String anno) throws FileNotFoundException, IOException {
        int pos = this.getControlliIndex(tipoModello);
        this.controlli[pos] = new Controlli(new Hashtable());
        String controlliPath = String.valueOf(tipoModello) + anno + "_controlli";
        if ((recMask & 4) != 0) {
            this.controlli[pos].load(String.valueOf(controlliPath) + ".res");
        }
        if ((recMask & 1) != 0) {
            this.recordAcontrolli = new Controlli(new Vector());
            this.recordAcontrolli.load(String.valueOf(controlliPath) + "_reca" + ".res");
            this.recordZcontrolli = new Controlli(new Vector());
            this.recordZcontrolli.load(String.valueOf(controlliPath) + "_recz" + ".res");
        }
        if ((recMask & 2) != 0) {
            this.recordBcontrolli = new Controlli(new Vector());
            this.recordBcontrolli.load(String.valueOf(controlliPath) + "_recb" + ".res");
        }
    }

    public void riempiControlli(String tipoModello, String anno) throws FileNotFoundException, IOException {
        this.riempiControlli(7, tipoModello, anno);
    }

    public void riempiDescrizioni(String modello, boolean isModUnico) throws IOException {
        this.descrizioni = new RepDescrizioni(this);
        String anno = modello.substring(3);
        this.descrizioni.load("generale" + anno + "_descrizioni" + ".res");
        this.descrizioni.load(String.valueOf(isModUnico ? "U" + anno : modello) + "_descrizioni" + ".res");
    }

    private class RepDescrizioni
    extends ResourceLoader {
        /* synthetic */ BaseTelem this$0;

        public /* synthetic */ RepDescrizioni(BaseTelem this$0) {
            super(new Hashtable());
            this.this$0 = this$0;
        }

        protected Object createValue(String value) {
            return value;
        }

        public String getDescrizione(String codErrore) {
            String retDescrizione = (String)this.getValue(codErrore);
            return retDescrizione == null ? new String() : retDescrizione;
        }
    }
}

