/*
 * Decompiled with CFR 0.152.
 */
package javafx.stage;

import com.sun.javafx.WeakReferenceQueue;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.stage.WindowBoundsAccessor;
import com.sun.javafx.stage.WindowEventDispatcher;
import com.sun.javafx.stage.WindowPeerListener;
import com.sun.javafx.tk.TKPulseListener;
import com.sun.javafx.tk.TKScene;
import com.sun.javafx.tk.TKStage;
import com.sun.javafx.tk.Toolkit;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Iterator;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.DoublePropertyBase;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyDoubleWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.Event;
import javafx.event.EventDispatchChain;
import javafx.event.EventDispatcher;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.geometry.Rectangle2D;
import javafx.scene.Scene;
import javafx.stage.Screen;
import javafx.stage.WindowEvent;

public class Window
implements EventTarget {
    private static WeakReferenceQueue<Window> windowQueue = new WeakReferenceQueue();
    private static final WindowBoundsAccessor BOUNDS_ACCESSOR = new WindowBoundsAccessor(){

        @Override
        public void setLocation(Window window, double d, double d2) {
            window.x.set(d);
            window.y.set(d2);
        }

        @Override
        public void setSize(Window window, double d, double d2) {
            window.width.set(d);
            window.height.set(d2);
        }
    };
    private final AccessControlContext acc = AccessController.getContext();
    @Deprecated
    protected WindowPeerListener peerListener;
    @Deprecated
    protected TKStage impl_peer;
    private TKBoundsConfigurator peerBoundsConfigurator = new TKBoundsConfigurator();
    private static final float CENTER_ON_SCREEN_X_FRACTION = 0.5f;
    private static final float CENTER_ON_SCREEN_Y_FRACTION = 0.33333334f;
    private boolean xExplicit = false;
    private ReadOnlyDoubleWrapper x = new ReadOnlyDoubleWrapper(this, "x", Double.NaN);
    private boolean yExplicit = false;
    private ReadOnlyDoubleWrapper y = new ReadOnlyDoubleWrapper(this, "y", Double.NaN);
    private boolean widthExplicit = false;
    private ReadOnlyDoubleWrapper width = new ReadOnlyDoubleWrapper(this, "width", Double.NaN);
    private boolean heightExplicit = false;
    private ReadOnlyDoubleWrapper height = new ReadOnlyDoubleWrapper(this, "height", Double.NaN);
    private ReadOnlyBooleanWrapper focused = new ReadOnlyBooleanWrapper(){

        @Override
        protected void invalidated() {
            Window.this.focusChanged(this.get());
        }

        @Override
        public Object getBean() {
            return Window.this;
        }

        @Override
        public String getName() {
            return "focused";
        }
    };
    private SceneModel scene = new SceneModel();
    private DoubleProperty opacity;
    private ObjectProperty<EventHandler<WindowEvent>> onCloseRequest;
    private ObjectProperty<EventHandler<WindowEvent>> onShowing;
    private ObjectProperty<EventHandler<WindowEvent>> onShown;
    private ObjectProperty<EventHandler<WindowEvent>> onHiding;
    private ObjectProperty<EventHandler<WindowEvent>> onHidden;
    private ReadOnlyBooleanWrapper showing = new ReadOnlyBooleanWrapper(){
        private boolean oldVisible;

        @Override
        protected void invalidated() {
            boolean bl = this.get();
            if (this.oldVisible == bl) {
                return;
            }
            if (!this.oldVisible && bl) {
                Window.this.fireEvent(new WindowEvent(Window.this, WindowEvent.WINDOW_SHOWING));
            } else {
                Window.this.fireEvent(new WindowEvent(Window.this, WindowEvent.WINDOW_HIDING));
            }
            this.oldVisible = bl;
            Window.this.impl_visibleChanging(bl);
            if (bl) {
                Window.this.hasBeenVisible = true;
                windowQueue.add(Window.this);
            } else {
                windowQueue.remove(Window.this);
            }
            Toolkit toolkit = Toolkit.getToolkit();
            if (Window.this.impl_peer != null) {
                if (bl) {
                    Window.this.impl_peer.setSecurityContext(Window.this.acc);
                    if (Window.this.peerListener == null) {
                        Window.this.peerListener = new WindowPeerListener(Window.this);
                    }
                    Window.this.peerListener.setBoundsAccessor(BOUNDS_ACCESSOR);
                    Window.this.impl_peer.setTKStageListener(Window.this.peerListener);
                    toolkit.addStageTkPulseListener(Window.this.peerBoundsConfigurator);
                    if (Window.this.getScene() != null) {
                        Window.this.getScene().impl_initPeer();
                        Window.this.impl_peer.setScene(Window.this.getScene().impl_getPeer());
                        Window.this.getScene().impl_preferredSize();
                    }
                    if (!(Window.this.getScene() == null || Window.this.widthExplicit && Window.this.heightExplicit)) {
                        Window.this.adjustSize(true);
                    } else {
                        Window.this.peerBoundsConfigurator.setSize(Window.this.getWidth(), Window.this.getHeight(), -1.0, -1.0);
                    }
                    if (!Window.this.xExplicit && !Window.this.yExplicit) {
                        Window.this.centerOnScreen();
                    } else {
                        Window.this.peerBoundsConfigurator.setLocation(Window.this.getX(), Window.this.getY(), 0.0f, 0.0f);
                    }
                    Window.this.applyBounds();
                    Window.this.impl_peer.setOpacity((float)Window.this.getOpacity());
                    Window.this.impl_peer.setVisible(true);
                    Window.this.fireEvent(new WindowEvent(Window.this, WindowEvent.WINDOW_SHOWN));
                } else {
                    Window.this.impl_peer.setVisible(false);
                    Window.this.fireEvent(new WindowEvent(Window.this, WindowEvent.WINDOW_HIDDEN));
                    if (Window.this.getScene() != null) {
                        Window.this.impl_peer.setScene(null);
                        Window.this.getScene().impl_disposePeer();
                    }
                    toolkit.removeStageTkPulseListener(Window.this.peerBoundsConfigurator);
                    Window.this.impl_peer.setTKStageListener(null);
                    Window.this.impl_peer.close();
                }
            }
            if (bl) {
                toolkit.requestNextPulse();
            }
            Window.this.impl_visibleChanged(bl);
        }

        @Override
        public Object getBean() {
            return Window.this;
        }

        @Override
        public String getName() {
            return "showing";
        }
    };
    boolean hasBeenVisible = false;
    private ObjectProperty<EventDispatcher> eventDispatcher;
    private WindowEventDispatcher internalEventDispatcher;
    private int focusGrabCounter;

    @Deprecated
    public static Iterator<Window> impl_getWindows() {
        Iterator iterator = AccessController.doPrivileged(new PrivilegedAction<Iterator>(){

            @Override
            public Iterator run() {
                return windowQueue.iterator();
            }
        });
        return iterator;
    }

    protected Window() {
        this.initializeInternalEventDispatcher();
    }

    @Deprecated
    public TKStage impl_getPeer() {
        return this.impl_peer;
    }

    @Deprecated
    public String impl_getMXWindowType() {
        return this.getClass().getSimpleName();
    }

    public void sizeToScene() {
        if (this.getScene() != null && this.impl_peer != null) {
            this.getScene().impl_preferredSize();
            this.adjustSize(false);
        }
    }

    private void adjustSize(boolean bl) {
        if (this.getScene() == null) {
            return;
        }
        if (this.impl_peer != null) {
            double d = this.getScene().getWidth();
            double d2 = d > 0.0 ? d : -1.0;
            double d3 = -1.0;
            if (bl && this.widthExplicit) {
                d3 = this.getWidth();
            } else if (d2 <= 0.0) {
                d3 = this.widthExplicit ? this.getWidth() : -1.0;
            } else {
                this.widthExplicit = false;
            }
            double d4 = this.getScene().getHeight();
            double d5 = d4 > 0.0 ? d4 : -1.0;
            double d6 = -1.0;
            if (bl && this.heightExplicit) {
                d6 = this.getHeight();
            } else if (d5 <= 0.0) {
                d6 = this.heightExplicit ? this.getHeight() : -1.0;
            } else {
                this.heightExplicit = false;
            }
            this.peerBoundsConfigurator.setSize(d3, d6, d2, d5);
            this.applyBounds();
        }
    }

    public void centerOnScreen() {
        this.xExplicit = false;
        this.yExplicit = false;
        if (this.impl_peer != null) {
            Rectangle2D rectangle2D = Screen.getPrimary().getVisualBounds();
            double d = rectangle2D.getMinX() + (rectangle2D.getWidth() - this.getWidth()) * 0.5;
            double d2 = rectangle2D.getMinY() + (rectangle2D.getHeight() - this.getHeight()) * 0.3333333432674408;
            this.x.set(d);
            this.y.set(d2);
            this.peerBoundsConfigurator.setLocation(d, d2, 0.5f, 0.33333334f);
            this.applyBounds();
        }
    }

    public final void setX(double d) {
        this.x.set(d);
        this.peerBoundsConfigurator.setX(d, 0.0f);
        this.xExplicit = true;
    }

    public final double getX() {
        return this.x.get();
    }

    public final ReadOnlyDoubleProperty xProperty() {
        return this.x.getReadOnlyProperty();
    }

    public final void setY(double d) {
        this.y.set(d);
        this.peerBoundsConfigurator.setY(d, 0.0f);
        this.yExplicit = true;
    }

    public final double getY() {
        return this.y.get();
    }

    public final ReadOnlyDoubleProperty yProperty() {
        return this.y.getReadOnlyProperty();
    }

    public final void setWidth(double d) {
        this.width.set(d);
        this.peerBoundsConfigurator.setWindowWidth(d);
        this.widthExplicit = true;
    }

    public final double getWidth() {
        return this.width.get();
    }

    public final ReadOnlyDoubleProperty widthProperty() {
        return this.width.getReadOnlyProperty();
    }

    public final void setHeight(double d) {
        this.height.set(d);
        this.peerBoundsConfigurator.setWindowHeight(d);
        this.heightExplicit = true;
    }

    public final double getHeight() {
        return this.height.get();
    }

    public final ReadOnlyDoubleProperty heightProperty() {
        return this.height.getReadOnlyProperty();
    }

    @Deprecated
    public final void setFocused(boolean bl) {
        this.focused.set(bl);
    }

    public final void requestFocus() {
        this.setFocused(true);
    }

    public final boolean isFocused() {
        return this.focused.get();
    }

    public final ReadOnlyBooleanProperty focusedProperty() {
        return this.focused.getReadOnlyProperty();
    }

    protected void setScene(Scene scene) {
        this.scene.set(scene);
    }

    public final Scene getScene() {
        return (Scene)this.scene.get();
    }

    public final ReadOnlyObjectProperty<Scene> sceneProperty() {
        return this.scene.getReadOnlyProperty();
    }

    public final void setOpacity(double d) {
        this.opacityProperty().set(d);
    }

    public final double getOpacity() {
        return this.opacity == null ? 1.0 : this.opacity.get();
    }

    public final DoubleProperty opacityProperty() {
        if (this.opacity == null) {
            this.opacity = new DoublePropertyBase(1.0){

                @Override
                protected void invalidated() {
                    if (Window.this.impl_peer != null) {
                        Window.this.impl_peer.setOpacity((float)this.get());
                    }
                }

                @Override
                public Object getBean() {
                    return Window.this;
                }

                @Override
                public String getName() {
                    return "opacity";
                }
            };
        }
        return this.opacity;
    }

    public final void setOnCloseRequest(EventHandler<WindowEvent> eventHandler) {
        this.onCloseRequestProperty().set(eventHandler);
    }

    public final EventHandler<WindowEvent> getOnCloseRequest() {
        return this.onCloseRequest != null ? (EventHandler)this.onCloseRequest.get() : null;
    }

    public final ObjectProperty<EventHandler<WindowEvent>> onCloseRequestProperty() {
        if (this.onCloseRequest == null) {
            this.onCloseRequest = new ObjectPropertyBase<EventHandler<WindowEvent>>(){

                @Override
                protected void invalidated() {
                    Window.this.setEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Window.this;
                }

                @Override
                public String getName() {
                    return "onCloseRequest";
                }
            };
        }
        return this.onCloseRequest;
    }

    public final void setOnShowing(EventHandler<WindowEvent> eventHandler) {
        this.onShowingProperty().set(eventHandler);
    }

    public final EventHandler<WindowEvent> getOnShowing() {
        return this.onShowing == null ? null : (EventHandler)this.onShowing.get();
    }

    public final ObjectProperty<EventHandler<WindowEvent>> onShowingProperty() {
        if (this.onShowing == null) {
            this.onShowing = new ObjectPropertyBase<EventHandler<WindowEvent>>(){

                @Override
                protected void invalidated() {
                    Window.this.setEventHandler(WindowEvent.WINDOW_SHOWING, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Window.this;
                }

                @Override
                public String getName() {
                    return "onShowing";
                }
            };
        }
        return this.onShowing;
    }

    public final void setOnShown(EventHandler<WindowEvent> eventHandler) {
        this.onShownProperty().set(eventHandler);
    }

    public final EventHandler<WindowEvent> getOnShown() {
        return this.onShown == null ? null : (EventHandler)this.onShown.get();
    }

    public final ObjectProperty<EventHandler<WindowEvent>> onShownProperty() {
        if (this.onShown == null) {
            this.onShown = new ObjectPropertyBase<EventHandler<WindowEvent>>(){

                @Override
                protected void invalidated() {
                    Window.this.setEventHandler(WindowEvent.WINDOW_SHOWN, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Window.this;
                }

                @Override
                public String getName() {
                    return "onShown";
                }
            };
        }
        return this.onShown;
    }

    public final void setOnHiding(EventHandler<WindowEvent> eventHandler) {
        this.onHidingProperty().set(eventHandler);
    }

    public final EventHandler<WindowEvent> getOnHiding() {
        return this.onHiding == null ? null : (EventHandler)this.onHiding.get();
    }

    public final ObjectProperty<EventHandler<WindowEvent>> onHidingProperty() {
        if (this.onHiding == null) {
            this.onHiding = new ObjectPropertyBase<EventHandler<WindowEvent>>(){

                @Override
                protected void invalidated() {
                    Window.this.setEventHandler(WindowEvent.WINDOW_HIDING, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Window.this;
                }

                @Override
                public String getName() {
                    return "onHiding";
                }
            };
        }
        return this.onHiding;
    }

    public final void setOnHidden(EventHandler<WindowEvent> eventHandler) {
        this.onHiddenProperty().set(eventHandler);
    }

    public final EventHandler<WindowEvent> getOnHidden() {
        return this.onHidden == null ? null : (EventHandler)this.onHidden.get();
    }

    public final ObjectProperty<EventHandler<WindowEvent>> onHiddenProperty() {
        if (this.onHidden == null) {
            this.onHidden = new ObjectPropertyBase<EventHandler<WindowEvent>>(){

                @Override
                protected void invalidated() {
                    Window.this.setEventHandler(WindowEvent.WINDOW_HIDDEN, (EventHandler)this.get());
                }

                @Override
                public Object getBean() {
                    return Window.this;
                }

                @Override
                public String getName() {
                    return "onHidden";
                }
            };
        }
        return this.onHidden;
    }

    private void setShowing(boolean bl) {
        Toolkit.getToolkit().checkFxUserThread();
        this.showing.set(bl);
    }

    public final boolean isShowing() {
        return this.showing.get();
    }

    public final ReadOnlyBooleanProperty showingProperty() {
        return this.showing.getReadOnlyProperty();
    }

    protected void show() {
        this.setShowing(true);
    }

    public void hide() {
        this.setShowing(false);
    }

    @Deprecated
    protected void impl_visibleChanging(boolean bl) {
        if (bl && this.getScene() != null) {
            StyleManager.getInstance().updateStylesheets(this.getScene());
            this.getScene().getRoot().impl_reapplyCSS();
        }
    }

    @Deprecated
    protected void impl_visibleChanged(boolean bl) {
    }

    public final void setEventDispatcher(EventDispatcher eventDispatcher) {
        this.eventDispatcherProperty().set(eventDispatcher);
    }

    public final EventDispatcher getEventDispatcher() {
        return (EventDispatcher)this.eventDispatcherProperty().get();
    }

    public final ObjectProperty<EventDispatcher> eventDispatcherProperty() {
        this.initializeInternalEventDispatcher();
        return this.eventDispatcher;
    }

    public final <T extends Event> void addEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventHandler(eventType, eventHandler);
    }

    public final <T extends Event> void addEventFilter(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().addEventFilter(eventType, eventHandler);
    }

    public final <T extends Event> void removeEventFilter(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().removeEventFilter(eventType, eventHandler);
    }

    protected final <T extends Event> void setEventHandler(EventType<T> eventType, EventHandler<? super T> eventHandler) {
        this.getInternalEventDispatcher().getEventHandlerManager().setEventHandler(eventType, eventHandler);
    }

    WindowEventDispatcher getInternalEventDispatcher() {
        this.initializeInternalEventDispatcher();
        return this.internalEventDispatcher;
    }

    private void initializeInternalEventDispatcher() {
        if (this.internalEventDispatcher == null) {
            this.internalEventDispatcher = this.createInternalEventDispatcher();
            this.eventDispatcher = new SimpleObjectProperty<WindowEventDispatcher>(this, "eventDispatcher", this.internalEventDispatcher);
        }
    }

    WindowEventDispatcher createInternalEventDispatcher() {
        return new WindowEventDispatcher(this);
    }

    public final void fireEvent(Event event) {
        Event.fireEvent(this, event);
    }

    @Override
    public EventDispatchChain buildEventDispatchChain(EventDispatchChain eventDispatchChain) {
        return this.eventDispatcher != null ? eventDispatchChain.prepend((EventDispatcher)this.eventDispatcher.get()) : eventDispatchChain;
    }

    void increaseFocusGrabCounter() {
        if (++this.focusGrabCounter == 1 && this.impl_peer != null && this.isFocused()) {
            this.impl_peer.grabFocus();
        }
    }

    void decreaseFocusGrabCounter() {
        if (--this.focusGrabCounter == 0 && this.impl_peer != null) {
            this.impl_peer.ungrabFocus();
        }
    }

    private void focusChanged(boolean bl) {
        if (this.focusGrabCounter > 0 && this.impl_peer != null && bl) {
            this.impl_peer.grabFocus();
        }
    }

    final void applyBounds() {
        this.peerBoundsConfigurator.apply();
    }

    private final class TKBoundsConfigurator
    implements TKPulseListener {
        private double x;
        private double y;
        private float xGravity;
        private float yGravity;
        private double windowWidth;
        private double windowHeight;
        private double clientWidth;
        private double clientHeight;
        private boolean dirty;

        public TKBoundsConfigurator() {
            this.reset();
        }

        public void setX(double d, float f) {
            this.x = d;
            this.xGravity = f;
            this.setDirty();
        }

        public void setY(double d, float f) {
            this.y = d;
            this.yGravity = f;
            this.setDirty();
        }

        public void setWindowWidth(double d) {
            this.windowWidth = d;
            this.setDirty();
        }

        public void setWindowHeight(double d) {
            this.windowHeight = d;
            this.setDirty();
        }

        public void setClientWidth(double d) {
            this.clientWidth = d;
            this.setDirty();
        }

        public void setClientHeight(double d) {
            this.clientHeight = d;
            this.setDirty();
        }

        public void setLocation(double d, double d2, float f, float f2) {
            this.x = d;
            this.y = d2;
            this.xGravity = f;
            this.yGravity = f2;
            this.setDirty();
        }

        public void setSize(double d, double d2, double d3, double d4) {
            this.windowWidth = d;
            this.windowHeight = d2;
            this.clientWidth = d3;
            this.clientHeight = d4;
            this.setDirty();
        }

        public void apply() {
            if (this.dirty) {
                Window.this.impl_peer.setBounds((float)(Double.isNaN(this.x) ? 0.0 : this.x), (float)(Double.isNaN(this.y) ? 0.0 : this.y), !Double.isNaN(this.x), !Double.isNaN(this.y), (float)this.windowWidth, (float)this.windowHeight, (float)this.clientWidth, (float)this.clientHeight, this.xGravity, this.yGravity);
                this.reset();
            }
        }

        @Override
        public void pulse() {
            this.apply();
        }

        private void reset() {
            this.x = Double.NaN;
            this.y = Double.NaN;
            this.xGravity = 0.0f;
            this.yGravity = 0.0f;
            this.windowWidth = -1.0;
            this.windowHeight = -1.0;
            this.clientWidth = -1.0;
            this.clientHeight = -1.0;
            this.dirty = false;
        }

        private void setDirty() {
            if (!this.dirty) {
                Toolkit.getToolkit().requestNextPulse();
                this.dirty = true;
            }
        }
    }

    private final class SceneModel
    extends ReadOnlyObjectWrapper<Scene> {
        private Scene oldScene;

        private SceneModel() {
        }

        @Override
        protected void invalidated() {
            Scene scene = (Scene)this.get();
            if (this.oldScene != scene) {
                Toolkit.getToolkit().checkFxUserThread();
                if (this.oldScene != null) {
                    this.oldScene.impl_setWindow(null);
                }
                if (scene != null) {
                    Window window = scene.getWindow();
                    if (window != null) {
                        window.scene.notifySceneLost();
                    }
                    scene.impl_setWindow(Window.this);
                    this.updatePeerStage(scene.impl_getPeer());
                    if (Window.this.isShowing()) {
                        StyleManager.getInstance().updateStylesheets(scene);
                        scene.getRoot().impl_reapplyCSS();
                        Window.this.getScene().impl_preferredSize();
                        if (!Window.this.widthExplicit || !Window.this.heightExplicit) {
                            Window.this.adjustSize(true);
                        }
                    }
                } else {
                    this.updatePeerStage(null);
                }
                this.oldScene = scene;
            }
        }

        @Override
        public Object getBean() {
            return Window.this;
        }

        @Override
        public String getName() {
            return "scene";
        }

        public void notifySceneLost() {
            if (this.isBound()) {
                this.unbind();
            }
            this.oldScene = null;
            this.set(null);
            this.updatePeerStage(null);
        }

        private void updatePeerStage(TKScene tKScene) {
            if (Window.this.impl_peer != null) {
                Window.this.impl_peer.setScene(tKScene);
            }
        }
    }
}

