/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions.priv;

import iaik.asn1.ASN;
import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1String;
import iaik.asn1.BOOLEAN;
import iaik.asn1.ObjectID;
import iaik.asn1.UTF8String;
import iaik.x509.V3Extension;
import iaik.x509.X509ExtensionException;

public class PublicAuthorityIdentifier
extends V3Extension {
    protected ASN1String code_;
    public static final ObjectID oid = new ObjectID("1.2.40.0.10.1.1.1", "PublicAuthorityIdentifier");

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.code_ != null) {
            stringBuffer.append("code: ");
            stringBuffer.append(this.code_.toString());
        } else {
            stringBuffer.append("isPublicAuthority: true");
        }
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        ASN1Object aSN1Object = this.code_ != null ? this.code_ : BOOLEAN.TRUE;
        return aSN1Object;
    }

    public void init(ASN1Object aSN1Object) throws X509ExtensionException {
        if (aSN1Object.isA(ASN.BOOLEAN)) {
            boolean bl = (Boolean)aSN1Object.getValue();
            if (!bl) {
                throw new X509ExtensionException("Boolean value in PublicAuthorityIdentifier extension must be true but is false!");
            }
        } else {
            if (aSN1Object.isStringType()) {
                this.code_ = (ASN1String)aSN1Object;
                return;
            }
            throw new X509ExtensionException("Value in PublicAuthorityIdentifier extension must be of type BOOLEAN, TeletexString, PrintableString, UniversalString, UTF8String or BMPString!");
        }
    }

    public int hashCode() {
        return oid.hashCode();
    }

    public ObjectID getObjectID() {
        return oid;
    }

    public String getCodeString() {
        String string = null;
        if (this.code_ != null) {
            string = (String)this.code_.getValue();
        }
        return string;
    }

    public ASN1String getCode() {
        return this.code_;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (this == object) {
            bl = true;
        } else if (object instanceof PublicAuthorityIdentifier) {
            PublicAuthorityIdentifier publicAuthorityIdentifier = (PublicAuthorityIdentifier)object;
            bl = this.code_ != null && publicAuthorityIdentifier.code_ != null ? this.code_.equals(publicAuthorityIdentifier.code_) : this.code_ == null && publicAuthorityIdentifier.code_ == null;
        }
        return bl;
    }

    public PublicAuthorityIdentifier(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("code must not be null!");
        }
        this.code_ = new UTF8String(string);
    }

    public PublicAuthorityIdentifier(ASN1String aSN1String) {
        if (aSN1String == null) {
            throw new IllegalArgumentException("code must not be null!");
        }
        if (aSN1String.isA(ASN.T61String) || aSN1String.isA(ASN.PrintableString) || aSN1String.isA(ASN.UNIString) || aSN1String.isA(ASN.UTF8String) || aSN1String.isA(ASN.BMPString)) {
            this.code_ = aSN1String;
            return;
        }
        throw new IllegalArgumentException("PublicAuthorityIdentifier code must be TeletexString, PrintableString, UniversalString, UTF8String or BMPString!");
    }

    public PublicAuthorityIdentifier() {
        this.code_ = null;
    }
}

