/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2004;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class CheckedBufferedReader
extends BufferedReader {
    private Checksum cksum;
    private char commentChar;
    public static final char DEFAULT_COMMENT_CHAR = '#';

    public CheckedBufferedReader(InputStream inputStream) throws FileNotFoundException {
        this((Reader)new InputStreamReader(inputStream), new CRC32());
    }

    public CheckedBufferedReader(Reader reader) {
        this(reader, new CRC32());
    }

    public CheckedBufferedReader(Reader reader, Checksum checksum) {
        super(reader);
        this.cksum = checksum;
        this.commentChar = (char)35;
    }

    public long getCheckValue() {
        return this.cksum.getValue();
    }

    public boolean isCommentLine(String string) {
        if (string.length() == 0) {
            return true;
        }
        return string.charAt(0) == this.commentChar;
    }

    public void readAll() throws IOException {
        while (this.readLine() != null) {
        }
    }

    public String readLine() throws IOException {
        String string = super.readLine();
        if (string != null && !this.isCommentLine(string)) {
            this.cksum.update(string.getBytes(), 0, string.getBytes().length);
        }
        return string;
    }

    public void setCommentChar(char c) {
        this.commentChar = c;
    }
}

