/*
 * Decompiled with CFR 0.152.
 */
package it.sogei.rcp.filesystemutil;

import it.sogei.rcp.filesystemutil.IWorkSpaceUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public class WorkSpaceUtil
implements IWorkSpaceUtil {
    public void SwitchWorkspace(String newWsRoot) throws IllegalStateException, MalformedURLException, IOException {
        this.CreateWorkspace(newWsRoot);
    }

    public void CopyWorkspace(String sourcePath, String destinationPath) throws IOException {
        File src = new File(sourcePath);
        File dest = new File(destinationPath);
        this.copyFiles(src, dest);
    }

    public void CreateWorkspace(String wsRoot) throws IllegalStateException, IOException {
        File workspaceDirectory = new File(wsRoot);
        Integer ind1 = wsRoot.indexOf("/");
        Integer ind2 = wsRoot.lastIndexOf("/");
        Integer diff = ind2 - ind1;
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null) {
            throw new IllegalStateException("Location \u00e8 null");
        }
        if (instanceLoc.isSet() && instanceLoc.getURL().toString().indexOf("runtime-") == -1) {
            throw new IllegalStateException("Il workspace \u00e8 gi\u00e0 impostato su: " + instanceLoc.getURL().toString() + "  riavviare l'applicazione.");
        }
        String pathWorkSpace = workspaceDirectory.getAbsolutePath();
        URL userWsURL = new URL("file", null, pathWorkSpace);
        if (!workspaceDirectory.exists()) {
            if (diff > 1) {
                workspaceDirectory.mkdirs();
            } else if (!workspaceDirectory.exists()) {
                workspaceDirectory.mkdir();
            }
        }
        if (!instanceLoc.isSet()) {
            instanceLoc.set(userWsURL, false);
        }
    }

    private void copyFiles(File src, File dest) throws IOException {
        if (!src.exists()) {
            throw new IOException("Impossibile trovare il sorgente: " + src.getAbsolutePath());
        }
        if (!src.canRead()) {
            throw new IOException("Impossibile la lettura: " + src.getAbsolutePath() + ". Controllare i permessi sul file.");
        }
        if (src.isDirectory()) {
            if (!dest.exists() && !dest.mkdirs()) {
                throw new IOException("Impossibile creare la direcotry: " + dest.getAbsolutePath());
            }
            String[] list = src.list();
            int i = 0;
            while (i < list.length) {
                File dest1 = new File(dest, list[i]);
                File src1 = new File(src, list[i]);
                this.copyFiles(src1, dest1);
                ++i;
            }
        } else {
            FileInputStream fin = null;
            FileOutputStream fout = null;
            byte[] buffer = new byte[4096];
            try {
                try {
                    int bytesRead;
                    fin = new FileInputStream(src);
                    fout = new FileOutputStream(dest);
                    while ((bytesRead = fin.read(buffer)) >= 0) {
                        fout.write(buffer, 0, bytesRead);
                    }
                }
                catch (IOException e) {
                    IOException wrapper = new IOException("Impossibile copiare il file: " + src.getAbsolutePath() + "to" + dest.getAbsolutePath());
                    wrapper.initCause(e);
                    wrapper.setStackTrace(e.getStackTrace());
                    throw wrapper;
                }
            }
            finally {
                if (fin != null) {
                    fin.close();
                }
                if (fout != null) {
                    fin.close();
                }
            }
        }
    }
}

