/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.ModelDirectedPlayer;
import com.sun.media.sound.ModelDirector;
import com.sun.media.sound.ModelPerformer;

public class ModelStandardIndexedDirector
implements ModelDirector {
    ModelPerformer[] performers;
    ModelDirectedPlayer player;
    boolean noteOnUsed = false;
    boolean noteOffUsed = false;
    byte[][] trantables;
    int[] counters;
    int[][] mat;

    public ModelStandardIndexedDirector(ModelPerformer[] modelPerformerArray, ModelDirectedPlayer modelDirectedPlayer) {
        this.performers = modelPerformerArray;
        this.player = modelDirectedPlayer;
        for (int i = 0; i < modelPerformerArray.length; ++i) {
            ModelPerformer modelPerformer = modelPerformerArray[i];
            if (modelPerformer.isReleaseTriggered()) {
                this.noteOffUsed = true;
                continue;
            }
            this.noteOnUsed = true;
        }
        this.buildindex();
    }

    private int[] lookupIndex(int n, int n2) {
        if (n >= 0 && n < 128 && n2 >= 0 && n2 < 128) {
            byte by = this.trantables[0][n];
            byte by2 = this.trantables[1][n2];
            if (by != -1 && by2 != -1) {
                return this.mat[by + by2 * this.counters[0]];
            }
        }
        return null;
    }

    private int restrict(int n) {
        if (n < 0) {
            return 0;
        }
        if (n > 127) {
            return 127;
        }
        return n;
    }

    private void buildindex() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.trantables = new byte[2][129];
        this.counters = new int[this.trantables.length];
        for (ModelPerformer modelPerformer : this.performers) {
            n5 = modelPerformer.getKeyFrom();
            n4 = modelPerformer.getKeyTo();
            n3 = modelPerformer.getVelFrom();
            n2 = modelPerformer.getVelTo();
            if (n5 > n4 || n3 > n2) continue;
            n5 = this.restrict(n5);
            n4 = this.restrict(n4);
            n3 = this.restrict(n3);
            n2 = this.restrict(n2);
            this.trantables[0][n5] = 1;
            this.trantables[0][n4 + 1] = 1;
            this.trantables[1][n3] = 1;
            this.trantables[1][n2 + 1] = 1;
        }
        for (n = 0; n < this.trantables.length; ++n) {
            int n6;
            byte[] byArray = this.trantables[n];
            int n7 = byArray.length;
            for (n6 = n7 - 1; n6 >= 0; --n6) {
                if (byArray[n6] == 1) {
                    byArray[n6] = -1;
                    break;
                }
                byArray[n6] = -1;
            }
            n6 = -1;
            for (n5 = 0; n5 < n7; ++n5) {
                if (byArray[n5] != 0) {
                    ++n6;
                    if (byArray[n5] == -1) break;
                }
                byArray[n5] = (byte)n6;
            }
            this.counters[n] = n6;
        }
        this.mat = new int[this.counters[0] * this.counters[1]][];
        n = 0;
        for (ModelPerformer modelPerformer : this.performers) {
            n4 = modelPerformer.getKeyFrom();
            n3 = modelPerformer.getKeyTo();
            n2 = modelPerformer.getVelFrom();
            int n8 = modelPerformer.getVelTo();
            if (n4 > n3 || n2 > n8) continue;
            n4 = this.restrict(n4);
            n3 = this.restrict(n3);
            n2 = this.restrict(n2);
            n8 = this.restrict(n8);
            int n9 = this.trantables[0][n4];
            int n10 = this.trantables[0][n3 + 1];
            int n11 = this.trantables[1][n2];
            int n12 = this.trantables[1][n8 + 1];
            if (n10 == -1) {
                n10 = this.counters[0];
            }
            if (n12 == -1) {
                n12 = this.counters[1];
            }
            for (int i = n11; i < n12; ++i) {
                int n13 = n9 + i * this.counters[0];
                for (int j = n9; j < n10; ++j) {
                    int[] nArray = this.mat[n13];
                    if (nArray == null) {
                        this.mat[n13] = new int[]{n};
                    } else {
                        int[] nArray2 = new int[nArray.length + 1];
                        nArray2[nArray2.length - 1] = n;
                        for (int k = 0; k < nArray.length; ++k) {
                            nArray2[k] = nArray[k];
                        }
                        this.mat[n13] = nArray2;
                    }
                    ++n13;
                }
            }
            ++n;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public void noteOff(int n, int n2) {
        if (!this.noteOffUsed) {
            return;
        }
        int[] nArray = this.lookupIndex(n, n2);
        if (nArray == null) {
            return;
        }
        for (int n3 : nArray) {
            ModelPerformer modelPerformer = this.performers[n3];
            if (!modelPerformer.isReleaseTriggered()) continue;
            this.player.play(n3, null);
        }
    }

    @Override
    public void noteOn(int n, int n2) {
        if (!this.noteOnUsed) {
            return;
        }
        int[] nArray = this.lookupIndex(n, n2);
        if (nArray == null) {
            return;
        }
        for (int n3 : nArray) {
            ModelPerformer modelPerformer = this.performers[n3];
            if (modelPerformer.isReleaseTriggered()) continue;
            this.player.play(n3, null);
        }
    }
}

