/*
 * Decompiled with CFR 0.152.
 */
package demo.smime;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import demo.smime.SMimeStream$Writer;
import iaik.asn1.structures.AlgorithmID;
import iaik.cms.IssuerAndSerialNumber;
import iaik.smime.SMimeEncrypted;
import iaik.smime.SMimeSigned;
import iaik.utils.CryptoUtils;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.util.Random;

public class SMimeStream {
    static final int a = 10000;
    byte[] buffer;
    X509Certificate[] signerCertificates;
    X509Certificate[] recipientCertificates;
    PrivateKey[] recipientPrivateKeys;
    X509Certificate dsaSignerCertificate;
    X509Certificate rsaSignerCertificate;
    PrivateKey[] signerPrivateKeys;

    public void testSMimeSignedAndEncrypted(AlgorithmID algorithmID, AlgorithmID algorithmID2, int n, int n2) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(this.buffer));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        PipedOutputStream pipedOutputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(pipedOutputStream);
        SMimeSigned sMimeSigned = new SMimeSigned((InputStream)bufferedInputStream, 1);
        sMimeSigned.setCertificates((Certificate[])this.signerCertificates);
        sMimeSigned.addSigner(this.signerPrivateKeys[0], new IssuerAndSerialNumber(this.rsaSignerCertificate));
        sMimeSigned.addSigner(this.signerPrivateKeys[1], new IssuerAndSerialNumber(this.dsaSignerCertificate), AlgorithmID.sha1, AlgorithmID.dsa);
        SMimeStream$Writer sMimeStream$Writer = new SMimeStream$Writer(this, sMimeSigned, pipedOutputStream);
        sMimeStream$Writer.start();
        SMimeEncrypted sMimeEncrypted = new SMimeEncrypted((InputStream)pipedInputStream, algorithmID, n);
        sMimeEncrypted.addRecipient(this.recipientCertificates[0], AlgorithmID.rsaEncryption);
        sMimeEncrypted.addRecipient(this.recipientCertificates[1], (AlgorithmID)AlgorithmID.esdhKeyAgreement.clone(), algorithmID2, n);
        sMimeEncrypted.writeTo((OutputStream)bufferedOutputStream);
        ((OutputStream)bufferedOutputStream).close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
        sMimeEncrypted = new SMimeEncrypted((InputStream)bufferedInputStream);
        sMimeEncrypted.decryptSymmetricKey((Key)this.recipientPrivateKeys[n2], n2);
        InputStream inputStream = sMimeEncrypted.getInputStream();
        sMimeSigned = new SMimeSigned(inputStream);
        InputStream inputStream2 = sMimeSigned.getInputStream();
        byteArrayOutputStream.reset();
        bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        StreamCopier streamCopier = new StreamCopier(inputStream2, (OutputStream)bufferedOutputStream);
        streamCopier.copyStream();
        ((OutputStream)bufferedOutputStream).close();
        X509Certificate x509Certificate = sMimeSigned.verify();
        System.out.println("Signature OK from: " + x509Certificate.getSubjectDN());
        x509Certificate = sMimeSigned.verify(1);
        System.out.println("Signature OK from: " + x509Certificate.getSubjectDN());
        if (!CryptoUtils.equalsBlock((byte[])this.buffer, (byte[])byteArrayOutputStream.toByteArray())) {
            throw new RuntimeException("Error: messages are not equal!");
        }
    }

    public void testSMimeSigned(int n) throws Exception {
        StreamCopier streamCopier;
        BufferedOutputStream bufferedOutputStream;
        Closeable closeable;
        byte[] byArray = null;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(this.buffer));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream2 = new BufferedOutputStream(byteArrayOutputStream);
        SMimeSigned sMimeSigned = new SMimeSigned((InputStream)bufferedInputStream, n);
        sMimeSigned.setCertificates((Certificate[])this.signerCertificates);
        sMimeSigned.addSigner(this.signerPrivateKeys[0], new IssuerAndSerialNumber(this.rsaSignerCertificate));
        sMimeSigned.addSigner(this.signerPrivateKeys[1], new IssuerAndSerialNumber(this.dsaSignerCertificate), AlgorithmID.sha1, AlgorithmID.dsa);
        if (n == 2) {
            closeable = new ByteArrayOutputStream();
            bufferedOutputStream = new BufferedOutputStream((OutputStream)closeable);
            streamCopier = new StreamCopier(sMimeSigned.getInputStream(), (OutputStream)bufferedOutputStream);
            streamCopier.copyStream();
            ((OutputStream)bufferedOutputStream).close();
            byArray = closeable.toByteArray();
        }
        sMimeSigned.writeTo((OutputStream)bufferedOutputStream2);
        ((OutputStream)bufferedOutputStream2).close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray2));
        sMimeSigned = n == 1 ? new SMimeSigned((InputStream)bufferedInputStream) : new SMimeSigned((InputStream)new BufferedInputStream(new ByteArrayInputStream(byArray)), new AlgorithmID[]{AlgorithmID.sha1});
        closeable = sMimeSigned.getInputStream();
        byteArrayOutputStream.reset();
        bufferedOutputStream2 = new BufferedOutputStream(byteArrayOutputStream);
        bufferedOutputStream = new StreamCopier((InputStream)closeable, (OutputStream)bufferedOutputStream2);
        bufferedOutputStream.copyStream();
        ((OutputStream)bufferedOutputStream2).close();
        if (n == 2) {
            sMimeSigned.decode((InputStream)bufferedInputStream);
        }
        streamCopier = sMimeSigned.verify();
        System.out.println("Signature OK from: " + streamCopier.getSubjectDN());
        streamCopier = sMimeSigned.verify(1);
        System.out.println("Signature OK from: " + streamCopier.getSubjectDN());
        if (!CryptoUtils.equalsBlock((byte[])this.buffer, (byte[])byteArrayOutputStream.toByteArray())) {
            throw new RuntimeException("Error: messages are not equal!");
        }
    }

    public void testSMimeEncrypted(AlgorithmID algorithmID, AlgorithmID algorithmID2, int n, int n2) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(this.buffer));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        SMimeEncrypted sMimeEncrypted = new SMimeEncrypted((InputStream)bufferedInputStream, algorithmID, n);
        sMimeEncrypted.addRecipient(this.recipientCertificates[0], AlgorithmID.rsaEncryption);
        sMimeEncrypted.addRecipient(this.recipientCertificates[1], (AlgorithmID)AlgorithmID.esdhKeyAgreement.clone(), algorithmID2, n);
        sMimeEncrypted.writeTo((OutputStream)bufferedOutputStream);
        ((OutputStream)bufferedOutputStream).close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
        sMimeEncrypted = new SMimeEncrypted((InputStream)bufferedInputStream);
        sMimeEncrypted.decryptSymmetricKey((Key)this.recipientPrivateKeys[n2], n2);
        InputStream inputStream = sMimeEncrypted.getInputStream();
        byteArrayOutputStream.reset();
        bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)bufferedOutputStream);
        streamCopier.copyStream();
        ((OutputStream)bufferedOutputStream).close();
        if (!CryptoUtils.equalsBlock((byte[])this.buffer, (byte[])byteArrayOutputStream.toByteArray())) {
            throw new RuntimeException("Error: messages are not equal!");
        }
    }

    public void start() {
        try {
            this.setupCertificates();
            System.out.println("testing an implicit S/MIME signed message...");
            this.testSMimeSigned(1);
            System.out.println("testing an explicit S/MIME signed message...");
            this.testSMimeSigned(2);
            AlgorithmID algorithmID = (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone();
            AlgorithmID algorithmID2 = (AlgorithmID)AlgorithmID.cms_3DES_wrap.clone();
            System.out.println("testing a S/MIME encrypted message for 3DES CBC; decrypting for RSA user...");
            this.testSMimeEncrypted(algorithmID, algorithmID2, -1, 0);
            System.out.println("testing a S/MIME encrypted message for 3DES CBC; decrypting for ESDH user...");
            this.testSMimeEncrypted(algorithmID, algorithmID2, -1, 1);
            algorithmID = (AlgorithmID)AlgorithmID.rc2_CBC.clone();
            algorithmID2 = (AlgorithmID)AlgorithmID.cms_rc2_wrap.clone();
            System.out.println("testing a S/MIME encrypted message for RC2 CBC; decrypting for RSA user...");
            this.testSMimeEncrypted(algorithmID, algorithmID2, 128, 0);
            System.out.println("testing a S/MIME encrypted message for RC2 CBC; decrypting for ESDH user...");
            this.testSMimeEncrypted(algorithmID, algorithmID2, 128, 1);
            algorithmID = (AlgorithmID)AlgorithmID.des_EDE3_CBC.clone();
            algorithmID2 = (AlgorithmID)AlgorithmID.cms_3DES_wrap.clone();
            System.out.println("testing a S/MIME signed and encrypted message for 3DES CBC; decrypting for RSA user...");
            this.testSMimeSignedAndEncrypted(algorithmID, algorithmID2, -1, 0);
            System.out.println("testing a S/MIME signed and encrypted message for 3DES CBC; decrypting for ESDH user...");
            this.testSMimeSignedAndEncrypted(algorithmID, algorithmID2, -1, 1);
            algorithmID = (AlgorithmID)AlgorithmID.rc2_CBC.clone();
            algorithmID2 = (AlgorithmID)AlgorithmID.cms_rc2_wrap.clone();
            System.out.println("testing a S/MIME signed and encrypted message for RC2 CBC; decrypting for RSA user...");
            this.testSMimeSignedAndEncrypted(algorithmID, algorithmID2, 128, 0);
            System.out.println("testing a S/MIME signed and encrypted message for RC2 CBC; decrypting for ESDH user...");
            this.testSMimeSignedAndEncrypted(algorithmID, algorithmID2, 128, 1);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public void setupCertificates() throws Exception {
        this.signerPrivateKeys = new PrivateKey[2];
        X509Certificate[] x509CertificateArray = CMSKeyStore.getCertificateChain(0, 1);
        this.rsaSignerCertificate = x509CertificateArray[0];
        this.signerPrivateKeys[0] = CMSKeyStore.getPrivateKey(0, 1);
        X509Certificate[] x509CertificateArray2 = CMSKeyStore.getCertificateChain(1, 1);
        this.dsaSignerCertificate = x509CertificateArray2[0];
        this.signerPrivateKeys[1] = CMSKeyStore.getPrivateKey(1, 1);
        this.signerCertificates = new X509Certificate[x509CertificateArray.length + x509CertificateArray2.length];
        System.arraycopy(x509CertificateArray, 0, this.signerCertificates, 0, x509CertificateArray2.length);
        System.arraycopy(x509CertificateArray2, 0, this.signerCertificates, x509CertificateArray.length, x509CertificateArray2.length);
        this.recipientPrivateKeys = new PrivateKey[2];
        this.recipientPrivateKeys[0] = CMSKeyStore.getPrivateKey(0, 4);
        this.recipientPrivateKeys[1] = CMSKeyStore.getPrivateKey(2, 4);
        this.recipientCertificates = new X509Certificate[2];
        this.recipientCertificates[0] = CMSKeyStore.getCertificateChain(0, 4)[0];
        this.recipientCertificates[1] = CMSKeyStore.getCertificateChain(2, 4)[0];
    }

    public static void main(String[] stringArray) throws IOException {
        DemoUtil.initDemos();
        new SMimeStream().start();
        System.out.println("ready...");
        System.in.read();
    }

    public SMimeStream() {
        System.out.println();
        System.out.println("******************************************************************************************");
        System.out.println("*                                 SMimeStream demo                                       *");
        System.out.println("*       (shows the usage of the IAIK-CMS SMimeSigned and SMimeEncrypted classes)         *");
        System.out.println("******************************************************************************************");
        System.out.println();
        this.buffer = new byte[10000];
        Random random = new Random();
        random.nextBytes(this.buffer);
    }
}

