/*
 * Decompiled with CFR 0.152.
 */
package demo.smime.ess;

import demo.DemoUtil;
import demo.keystore.CMSKeyStore;
import iaik.asn1.ASN1Object;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.UTF8String;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.AttributeValue;
import iaik.asn1.structures.GeneralName;
import iaik.asn1.structures.GeneralNames;
import iaik.asn1.structures.Name;
import iaik.asn1.structures.PolicyInformation;
import iaik.asn1.structures.PolicyQualifierInfo;
import iaik.cms.CMSException;
import iaik.cms.CertificateIdentifier;
import iaik.cms.IssuerAndSerialNumber;
import iaik.cms.SignedData;
import iaik.cms.SignedDataStream;
import iaik.cms.SignerInfo;
import iaik.cms.Utils;
import iaik.cms.attributes.CMSContentType;
import iaik.cms.attributes.SigningTime;
import iaik.smime.ess.SigningCertificate;
import iaik.utils.StreamCopier;
import iaik.x509.X509Certificate;
import iaik.x509.attr.AttCertIssuer;
import iaik.x509.attr.AttributeCertificate;
import iaik.x509.attr.Holder;
import iaik.x509.attr.V1Form;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.GregorianCalendar;

public class SigningCertificateDemo {
    PrivateKey issuer1_pk;
    Certificate[] user1Certs;
    Certificate[] certs;
    PrivateKey user1_pk;
    X509Certificate user1;

    public void start() {
        String string = "This is the test message.";
        System.out.println("Test message: \"" + string + "\"");
        System.out.println();
        byte[] byArray = string.getBytes();
        try {
            byte[] byArray2 = null;
            System.out.println("Stream implementation demos");
            System.out.println("===========================");
            System.out.println("\nImplicit SignedDataStream demo [create]:\n");
            byte[] byArray3 = this.createSignedDataStream(byArray, 1);
            System.out.println("\nImplicit SignedDataStream demo [parse]:\n");
            byArray2 = this.getSignedDataStream(byArray3, null);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit SignedDataStream demo [create]:\n");
            byArray3 = this.createSignedDataStream(byArray, 2);
            System.out.println("\nExplicit SignedDataStream demo [parse]:\n");
            byArray2 = this.getSignedDataStream(byArray3, byArray);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nNon-stream implementation demos");
            System.out.println("===============================");
            System.out.println("\nImplicit CMS SignedData demo [create]:\n");
            byArray3 = this.createSignedData(byArray, 1);
            System.out.println("\nImplicit CMS SignedData demo [parse]:\n");
            byArray2 = this.getSignedData(byArray3, null);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            System.out.println("\nExplicit CMS SignedData demo [create]:\n");
            byArray3 = this.createSignedData(byArray, 2);
            System.out.println("\nExplicit CMS SignedData demo [parse]:\n");
            byArray2 = this.getSignedData(byArray3, byArray);
            System.out.print("\nSigned content: ");
            System.out.println(new String(byArray2));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static void main(String[] stringArray) throws Exception {
        DemoUtil.initDemos();
        new SigningCertificateDemo().start();
        System.in.read();
    }

    public byte[] getSignedDataStream(byte[] byArray, byte[] byArray2) throws IOException, CMSException {
        AttributeCertificate[] attributeCertificateArray;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SignedDataStream signedDataStream = new SignedDataStream((InputStream)byteArrayInputStream);
        if (signedDataStream.getMode() == 2) {
            signedDataStream.setInputStream((InputStream)new ByteArrayInputStream(byArray2));
        }
        InputStream inputStream = signedDataStream.getInputStream();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopier streamCopier = new StreamCopier(inputStream, (OutputStream)byteArrayOutputStream);
        streamCopier.copyStream();
        System.out.println("SignedData contains the following signer information:");
        SignerInfo[] signerInfoArray = signedDataStream.getSignerInfos();
        int n = 0;
        while (n < signerInfoArray.length) {
            try {
                CMSContentType cMSContentType;
                attributeCertificateArray = signedDataStream.verify(n);
                System.out.println("Signature OK from signer: " + attributeCertificateArray.getSubjectDN());
                SigningTime signingTime = (SigningTime)signerInfoArray[n].getSignedAttributeValue(ObjectID.signingTime);
                if (signingTime != null) {
                    System.out.println("This message has been signed at " + signingTime.get());
                }
                if ((cMSContentType = (CMSContentType)signerInfoArray[n].getSignedAttributeValue(ObjectID.contentType)) != null) {
                    System.out.println("The content has CMS content type " + cMSContentType.get().getName());
                }
                try {
                    SigningCertificate signingCertificate = signerInfoArray[n].getSigningCertificateAttribute();
                    if (signingCertificate != null) {
                        this.a(signingCertificate, (X509Certificate)attributeCertificateArray, signedDataStream, n);
                    }
                }
                catch (CMSException cMSException) {
                    throw new CMSException("Error parsing SigningCertificate attribute: " + cMSException.getMessage());
                }
            }
            catch (SignatureException signatureException) {
                System.out.println("Signature ERROR from signer: " + signedDataStream.getCertificate(signerInfoArray[n].getSignerIdentifier()).getSubjectDN());
                throw new CMSException(signatureException.toString());
            }
            ++n;
        }
        System.out.println("Now check the signature assuming that no certs have been included:");
        try {
            signedDataStream.verify(this.user1);
            System.out.println("Signature OK from signer: " + this.user1.getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.user1.getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        System.out.println("Included attribute certificates:");
        attributeCertificateArray = signedDataStream.getAttributeCertificates();
        if (attributeCertificateArray == null) {
            System.out.println("No attribute certificates");
        } else {
            int n2 = 0;
            while (n2 < attributeCertificateArray.length) {
                System.out.println(attributeCertificateArray[n2].getHolder());
                ++n2;
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getSignedData(byte[] byArray, byte[] byArray2) throws IOException, CMSException {
        X509Certificate x509Certificate;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SignedData signedData = new SignedData((InputStream)byteArrayInputStream);
        if (signedData.getMode() == 2) {
            signedData.setContent(byArray2);
        }
        System.out.println("SignedData contains the following signer information:");
        SignerInfo[] signerInfoArray = signedData.getSignerInfos();
        int n = 0;
        while (n < signerInfoArray.length) {
            try {
                SigningCertificate signingCertificate;
                CMSContentType cMSContentType;
                x509Certificate = signedData.verify(n);
                System.out.println("Signature OK from signer: " + x509Certificate.getSubjectDN());
                SigningTime signingTime = (SigningTime)signerInfoArray[n].getSignedAttributeValue(ObjectID.signingTime);
                if (signingTime != null) {
                    System.out.println("This message has been signed at " + signingTime.get());
                }
                if ((cMSContentType = (CMSContentType)signerInfoArray[n].getSignedAttributeValue(ObjectID.contentType)) != null) {
                    System.out.println("The content has CMS content type " + cMSContentType.get().getName());
                }
                if ((signingCertificate = signerInfoArray[n].getSigningCertificateAttribute()) != null) {
                    this.a(signingCertificate, x509Certificate, (SignedDataStream)signedData, n);
                }
            }
            catch (SignatureException signatureException) {
                System.out.println("Signature ERROR from signer: " + signedData.getCertificate(signerInfoArray[n].getSignerIdentifier()).getSubjectDN());
                throw new CMSException(signatureException.toString());
            }
            ++n;
        }
        System.out.println("Now check the signature assuming that no certs have been included:");
        try {
            x509Certificate = signedData.verify(this.user1);
            System.out.println("Signature OK from signer: " + signedData.getCertificate(x509Certificate.getSignerIdentifier()).getSubjectDN());
        }
        catch (SignatureException signatureException) {
            System.out.println("Signature ERROR from signer: " + this.user1.getSubjectDN());
            throw new CMSException(signatureException.toString());
        }
        return signedData.getContent();
    }

    public byte[] createSignedDataStream(byte[] byArray, int n) throws IOException, CMSException {
        Object object;
        Object object2;
        System.out.print("Create a new message signed by user 1 :");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        SignedDataStream signedDataStream = new SignedDataStream((InputStream)byteArrayInputStream, n);
        signedDataStream.setCertificates(this.certs);
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(this.user1);
        SignerInfo signerInfo = new SignerInfo((CertificateIdentifier)issuerAndSerialNumber, AlgorithmID.md5, this.user1_pk);
        Attribute[] attributeArray = new Attribute[3];
        try {
            object2 = new CMSContentType(ObjectID.cms_data);
            attributeArray[0] = new Attribute((AttributeValue)object2);
            object = new SigningTime();
            attributeArray[1] = new Attribute((AttributeValue)object);
            SigningCertificate signingCertificate = new SigningCertificate(this.certs, true);
            String string = "This certificate only may be used for test purposes";
            PolicyQualifierInfo policyQualifierInfo = new PolicyQualifierInfo(null, null, string);
            PolicyInformation[] policyInformationArray = new PolicyInformation[]{new PolicyInformation(new ObjectID("1.3.6.1.4.1.2706.17.0.11.1.1"), new PolicyQualifierInfo[]{policyQualifierInfo})};
            signingCertificate.setPolicies(policyInformationArray);
            System.out.println("Include signingCertificate attribute:");
            System.out.println(signingCertificate);
            attributeArray[2] = new Attribute((AttributeValue)signingCertificate);
        }
        catch (Exception exception) {
            throw new CMSException("Error creating attribute: " + exception.toString());
        }
        signerInfo.setSignedAttributes(attributeArray);
        try {
            signedDataStream.addSignerInfo(signerInfo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for signature algorithm: " + noSuchAlgorithmException.getMessage());
        }
        if (n == 2) {
            int n2;
            object2 = signedDataStream.getInputStream();
            object = new byte[1024];
            while ((n2 = ((InputStream)object2).read((byte[])object)) > 0) {
            }
        }
        object2 = new ByteArrayOutputStream();
        signedDataStream.writeTo((OutputStream)object2, 2048);
        return ((ByteArrayOutputStream)object2).toByteArray();
    }

    public byte[] createSignedData(byte[] byArray, int n) throws CMSException {
        System.out.println("Create a new message signed by user 1 :");
        SignedData signedData = new SignedData(byArray, n);
        signedData.setCertificates(this.certs);
        IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(this.user1);
        SignerInfo signerInfo = new SignerInfo((CertificateIdentifier)issuerAndSerialNumber, AlgorithmID.md5, this.user1_pk);
        Attribute[] attributeArray = new Attribute[3];
        try {
            CMSContentType cMSContentType = new CMSContentType(ObjectID.cms_data);
            attributeArray[0] = new Attribute((AttributeValue)cMSContentType);
            SigningTime signingTime = new SigningTime();
            attributeArray[1] = new Attribute((AttributeValue)signingTime);
            SigningCertificate signingCertificate = Utils.makeSigningCertificate((Certificate[])this.certs, null, (boolean)true);
            System.out.println("Include signingCertificate attribute:");
            System.out.println(signingCertificate);
            attributeArray[2] = new Attribute((AttributeValue)signingCertificate);
        }
        catch (Exception exception) {
            throw new CMSException("Error creating attribute: " + exception.toString());
        }
        signerInfo.setSignedAttributes(attributeArray);
        try {
            signedData.addSignerInfo(signerInfo);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("No implementation for signature algorithm: " + noSuchAlgorithmException.getMessage());
        }
        return signedData.getEncoded();
    }

    public AttributeCertificate createAttributeCertificate() throws CMSException {
        try {
            Name name = (Name)this.user1.getIssuerDN();
            GeneralName generalName = new GeneralName(4, (Object)name);
            GeneralNames generalNames = new GeneralNames(generalName);
            V1Form v1Form = new V1Form(generalNames);
            Name name2 = (Name)this.user1.getSubjectDN();
            GeneralName generalName2 = new GeneralName(4, (Object)name2);
            GeneralNames generalNames2 = new GeneralNames(generalName2);
            Holder holder = new Holder();
            holder.setEntityName(generalNames2);
            AttributeCertificate attributeCertificate = new AttributeCertificate();
            attributeCertificate.setHolder(holder);
            attributeCertificate.setIssuer((AttCertIssuer)v1Form);
            attributeCertificate.setSerialNumber(new BigInteger("27"));
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            Date date = gregorianCalendar.getTime();
            gregorianCalendar.add(2, 1);
            Date date2 = gregorianCalendar.getTime();
            attributeCertificate.setNotBeforeTime(date);
            attributeCertificate.setNotAfterTime(date2);
            Attribute[] attributeArray = new Attribute[1];
            SEQUENCE sEQUENCE = new SEQUENCE();
            sEQUENCE.addComponent((ASN1Object)new UTF8String("A-8010 Graz, Austria"));
            sEQUENCE.addComponent((ASN1Object)new UTF8String("Inffeldgasse 16A"));
            attributeArray[0] = new Attribute(ObjectID.postalAddress, new ASN1Object[]{sEQUENCE});
            attributeCertificate.setAttributes(attributeArray);
            attributeCertificate.sign(AlgorithmID.sha1WithRSAEncryption_, this.issuer1_pk);
            attributeCertificate.verify(this.user1Certs[1].getPublicKey());
            return attributeCertificate;
        }
        catch (Exception exception) {
            throw new CMSException("Error creating attribute certificate: " + exception.toString());
        }
    }

    private void a(SigningCertificate signingCertificate, X509Certificate x509Certificate, SignedDataStream signedDataStream, int n) throws CMSException {
        try {
            if (signingCertificate != null) {
                Certificate[] certificateArray;
                System.out.println("SigningCertificate attribute included!");
                if (!signingCertificate.isSignerCertificate(x509Certificate)) {
                    System.out.println("Cert ERROR!!! The certificate used for signing is not the one identified by the SignerCertificate attribute!");
                } else {
                    System.out.println("SigningCertificate attribute: Signer cert ok!");
                }
                Certificate[] certificateArray2 = signingCertificate.getAuthorizedCertificates(signedDataStream.getCertificates());
                if (certificateArray2 != null) {
                    System.out.println("SignedData contains the following authorization certs for SignerInfo No " + (n + 1) + ":");
                    int n2 = 0;
                    while (n2 < certificateArray2.length) {
                        if (certificateArray2[n2].getType().equalsIgnoreCase("X.509")) {
                            System.out.println("X.509 public key cert: " + ((X509Certificate)certificateArray2[n2]).getSubjectDN());
                        } else {
                            System.out.println("X.509 attribute cert: " + ((AttributeCertificate)certificateArray2[n2]).getHolder());
                        }
                        ++n2;
                    }
                }
                if (signingCertificate.countPolicies() > 0 && (certificateArray = signingCertificate.getPolicyInformationCerts(signedDataStream.getCertificates())) != null) {
                    System.out.println("SignedData contains the following certs corresponding to policy informations of SignerInfo No " + (n + 1) + ":");
                    int n3 = 0;
                    while (n3 < certificateArray.length) {
                        if (certificateArray[n3].getType().equalsIgnoreCase("X.509")) {
                            System.out.println("X.509 public key cert: " + ((X509Certificate)certificateArray[n3]).getSubjectDN());
                        } else {
                            System.out.println("X.509 attribute cert: " + ((AttributeCertificate)certificateArray[n3]).getHolder());
                        }
                        ++n3;
                    }
                    return;
                }
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("Cannot check SigningCertificate attribute: Algorithm SHA not implemented!");
        }
    }

    public SigningCertificateDemo() throws IOException {
        System.out.println();
        System.out.println("**********************************************************************************");
        System.out.println("*                       SigningCertificateDemo demo                              *");
        System.out.println("*          (shows the usage of the ESS SigningCertificate attribute)             *");
        System.out.println("**********************************************************************************");
        System.out.println();
        this.user1Certs = CMSKeyStore.getCertificateChain(0, 1);
        this.user1 = (X509Certificate)this.user1Certs[0];
        this.user1_pk = CMSKeyStore.getPrivateKey(0, 1);
        this.certs = this.user1Certs;
        try {
            this.issuer1_pk = CMSKeyStore.getCaPrivateKey(0);
            AttributeCertificate attributeCertificate = this.createAttributeCertificate();
            this.certs = new Certificate[this.user1Certs.length + 1];
            System.arraycopy(this.user1Certs, 0, this.certs, 0, this.user1Certs.length);
            this.certs[this.user1Certs.length] = attributeCertificate;
            return;
        }
        catch (CMSException cMSException) {
            System.out.println("No attribute certificates!");
            return;
        }
    }
}

