/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.base.AbstractHelpDisplay;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.DisplayUtils;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.internal.server.WebappManager;
import org.eclipse.osgi.util.NLS;

public class HelpDisplay {
    private String hrefOpenedFromHelpDisplay;
    private static AbstractHelpDisplay helpDisplay;
    private static final String HELP_DISPLAY_EXTENSION_ID = "org.eclipse.help.base.display";
    private static final String HELP_DISPLAY_CLASS_ATTRIBUTE = "class";

    public void displayHelp(boolean forceExternal) {
        this.displayHelpURL(null, forceExternal);
    }

    public void displayHelpResource(String href, boolean forceExternal) {
        this.setHrefOpenedFromHelpDisplay(href);
        if (href.startsWith("/file")) {
            this.displayHelpResource(href.substring(1), forceExternal);
            return;
        }
        if (href != null && (href.startsWith("tab=") || href.startsWith("toc=") || href.startsWith("topic=") || href.startsWith("contextId="))) {
            this.displayHelpURL(href, forceExternal);
        } else if (this.getNoframesURL(href) == null) {
            try {
                this.displayHelpURL("topic=" + URLEncoder.encode(href, "UTF-8"), forceExternal);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else if (href.startsWith("jar:") || href.startsWith("platform:")) {
            this.displayHelpURL(String.valueOf(HelpDisplay.getBaseURL()) + "nftopic/" + this.getNoframesURL(href), true);
        } else {
            this.displayHelpURL(this.getNoframesURL(href), true);
        }
    }

    public void displayHelp(IContext context, IHelpResource topic, boolean forceExternal) {
        if (context == null || topic == null || topic.getHref() == null) {
            return;
        }
        String topicURL = this.getTopicURL(topic.getHref());
        this.displayHelpResource(topicURL, false);
    }

    public void displaySearch(String searchQuery, String topic, boolean forceExternal) {
        if (searchQuery == null || topic == null) {
            return;
        }
        if (this.getNoframesURL(topic) == null) {
            try {
                String url = "tab=search&" + searchQuery + "&topic=" + URLEncoder.encode(this.getTopicURL(topic), "UTF-8");
                this.displayHelpURL(url, forceExternal);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        } else {
            this.displayHelpURL(this.getNoframesURL(topic), true);
        }
    }

    private void displayHelpURL(String helpURL, boolean forceExternal) {
        if (!BaseHelpSystem.ensureWebappRunning()) {
            return;
        }
        if (BaseHelpSystem.getMode() == 2) {
            DisplayUtils.waitForDisplay();
        }
        try {
            if (helpURL == null || helpURL.length() == 0) {
                helpURL = HelpDisplay.getHelpDisplay().getHelpHome(WebappManager.getHost(), WebappManager.getPort(), null);
            } else if (helpURL.startsWith("tab=")) {
                String tab = helpURL.substring("tab=".length());
                helpURL = HelpDisplay.getHelpDisplay().getHelpHome(WebappManager.getHost(), WebappManager.getPort(), tab);
            } else if (helpURL.startsWith("topic=")) {
                String topic = helpURL.substring("topic=".length());
                helpURL = HelpDisplay.getHelpDisplay().getHelpForTopic(topic, WebappManager.getHost(), WebappManager.getPort());
            }
            BaseHelpSystem.getHelpBrowser(forceExternal).displayURL(helpURL);
        }
        catch (Exception e) {
            HelpBasePlugin.logError("An exception occurred while launching help.  Check the log at " + Platform.getLogFileLocation().toOSString(), e);
            BaseHelpSystem.getDefaultErrorUtil().displayError(NLS.bind((String)HelpBaseResources.HelpDisplay_exceptionMessage, (Object)Platform.getLogFileLocation().toOSString()));
        }
    }

    private static String getBaseURL() {
        return "http://" + WebappManager.getHost() + ":" + WebappManager.getPort() + "/help/";
    }

    private static String getFramesetURL() {
        return String.valueOf(HelpDisplay.getBaseURL()) + "index.jsp";
    }

    private String getTopicURL(String topic) {
        if (topic == null) {
            return null;
        }
        if (topic.startsWith("../")) {
            topic = topic.substring(2);
        }
        return topic;
    }

    private String getNoframesURL(String href) {
        if (href == null) {
            return null;
        }
        int ix = href.indexOf("?noframes=true&");
        if (ix >= 0) {
            return String.valueOf(href.substring(0, ix + 1)) + href.substring(ix + "?noframes=true&".length());
        }
        ix = href.indexOf("noframes=true");
        if (ix > 0) {
            return String.valueOf(href.substring(0, ix - 1)) + href.substring(ix + "noframes=true".length());
        }
        return null;
    }

    public String getHrefOpenedFromHelpDisplay() {
        return this.hrefOpenedFromHelpDisplay;
    }

    public void setHrefOpenedFromHelpDisplay(String hrefOpenedFromHelpDisplay) {
        this.hrefOpenedFromHelpDisplay = hrefOpenedFromHelpDisplay;
    }

    private static void createHelpDisplay() {
        IExtension[] extensions;
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint(HELP_DISPLAY_EXTENSION_ID);
        if (point != null && (extensions = point.getExtensions()).length != 0) {
            IConfigurationElement[] elements = extensions[0].getConfigurationElements();
            if (elements.length == 0) {
                return;
            }
            IConfigurationElement displayElement = elements[0];
            try {
                helpDisplay = (AbstractHelpDisplay)displayElement.createExecutableExtension(HELP_DISPLAY_CLASS_ATTRIBUTE);
            }
            catch (CoreException e) {
                HelpBasePlugin.logStatus(e.getStatus());
            }
        }
    }

    private static AbstractHelpDisplay getHelpDisplay() {
        if (helpDisplay == null) {
            HelpDisplay.createHelpDisplay();
        }
        if (helpDisplay == null) {
            helpDisplay = new DefaultDisplay();
        }
        return helpDisplay;
    }

    private static class DefaultDisplay
    extends AbstractHelpDisplay {
        private DefaultDisplay() {
        }

        public String getHelpHome(String hostname, int port, String tab) {
            String helpURL = HelpDisplay.getFramesetURL();
            if (tab != null) {
                helpURL = String.valueOf(helpURL) + "?tab=" + tab;
            }
            return helpURL;
        }

        public String getHelpForTopic(String topic, String hostname, int port) {
            return String.valueOf(HelpDisplay.getFramesetURL()) + "?topic=" + topic;
        }
    }
}

