/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.generale2006;

import finanze.IDTE.generale2006.Util;
import finanze.IDTE.resources.ResourceLoader;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ComuniProvincia {
    public static final String fileResProvince = "province_range_06.res";
    public static final String fileResComCCatAliq = "comuni_ccat_aliq_06.res";
    private static String[] comuni = null;
    private static String[] codCatastali = null;
    private static double[] aliquote = null;
    public static int[] aliqIncerte = null;
    public static int[] comuniSoppressi = null;
    private static Hashtable provinceRange = null;
    private static Hashtable ricercaCodCat = null;
    public static final Object lock = new Object();

    public static final boolean esisteCodCat(String codCat) {
        ComuniProvincia.loadRicercaCodCat();
        return ricercaCodCat.containsKey(codCat);
    }

    public static boolean esisteComune(String comune) {
        ComuniProvincia.load();
        int i = 0;
        while (i < comuni.length) {
            if (comune.equals(comuni[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final double getAliquota(String codiceCatastale) {
        ComuniProvincia.load();
        int lenCodCat = codCatastali.length;
        int i = 0;
        while (i < lenCodCat) {
            if (codCatastali[i].equals(codiceCatastale)) {
                return aliquote[i];
            }
            ++i;
        }
        return -1.0;
    }

    public static final boolean getAliquotaIncerta(String codiceCatastale, double[] refValue) {
        ComuniProvincia.load();
        boolean found = false;
        refValue[0] = -1.0;
        int i = 0;
        while (i < codCatastali.length) {
            if (codCatastali[i].equals(codiceCatastale)) {
                refValue[0] = aliquote[i];
                if (aliqIncerte.length == 0) {
                    return false;
                }
                int j = 0;
                while (!found && j < aliqIncerte.length) {
                    if (aliqIncerte[j] == i) {
                        found = true;
                    }
                    ++j;
                }
                return found;
            }
            ++i;
        }
        return false;
    }

    public static final String[] getCodCatastaleEAliquota(String prov, String com) {
        String[] codici = new String[2];
        ComuniProvincia.load();
        ProvComIn pci = (ProvComIn)provinceRange.get(prov);
        int da = pci.primo;
        while (da <= pci.ultimo) {
            if (comuni[da].equalsIgnoreCase(com)) {
                codici[0] = codCatastali[da];
                if (aliquote[da] == 0.0) {
                    codici[1] = "0";
                    break;
                }
                codici[1] = String.valueOf(aliquote[da]).replace('.', ',');
                break;
            }
            ++da;
        }
        return codici;
    }

    public static final String[] getComDaProv(String prov) {
        ComuniProvincia.load();
        ProvComIn pci = (ProvComIn)provinceRange.get(prov);
        int range = pci.ultimo - pci.primo + 1;
        String[] comDaProv = new String[range];
        System.arraycopy(comuni, pci.primo, comDaProv, 0, range);
        return comDaProv;
    }

    public static String[] getComProvDaCodCat(String codcat) {
        ComuniProvincia.load();
        String[] retComProv = new String[2];
        int index = -1;
        int len = codCatastali.length;
        int i = 0;
        while (i < len) {
            if (codCatastali[i].equals(codcat)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return null;
        }
        retComProv[0] = comuni[index];
        Enumeration codProvs = provinceRange.keys();
        while (codProvs.hasMoreElements()) {
            String prov = (String)codProvs.nextElement();
            ProvComIn range = (ProvComIn)provinceRange.get(prov);
            if (index < range.primo || index > range.ultimo) continue;
            retComProv[1] = prov;
            return retComProv;
        }
        return null;
    }

    public static final int[] getComSoppDaProv(String prov) {
        ComuniProvincia.load();
        ProvComIn pci = (ProvComIn)provinceRange.get(prov);
        int range = pci.ultimo - pci.primo + 1;
        int[] comSoppDaProv = new int[range];
        System.arraycopy(comuniSoppressi, pci.primo, comSoppDaProv, 0, range);
        return comSoppDaProv;
    }

    public static String[] getProvDaCom(String com) {
        ComuniProvincia.load();
        Vector<String> vecindex = new Vector<String>();
        int index = -1;
        int len = comuni.length;
        int i = 0;
        while (i < len) {
            if (comuni[i].equals(com)) {
                index = i;
                vecindex.addElement(Integer.toString(index));
            }
            ++i;
        }
        if (index == -1) {
            return null;
        }
        String[] provincie = new String[vecindex.size()];
        int i2 = 0;
        while (i2 < provincie.length) {
            Enumeration codProvs = provinceRange.keys();
            index = Integer.parseInt((String)vecindex.elementAt(i2));
            while (codProvs.hasMoreElements()) {
                String prov = (String)codProvs.nextElement();
                ProvComIn range = (ProvComIn)provinceRange.get(prov);
                if (index < range.primo || index > range.ultimo) continue;
                provincie[i2] = prov;
            }
            ++i2;
        }
        return provincie;
    }

    public static final String getRegDaProv(String prov) {
        ComuniProvincia.load();
        ProvComIn pci = (ProvComIn)provinceRange.get(prov);
        return Util.formNum(2, pci.codRegione);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        Object object = lock;
        synchronized (object) {
            if (provinceRange == null || comuni == null) {
                System.out.println("Caricamento delle province dal file di risorse province_range_06.res");
                provinceRange = new Hashtable();
                ProvLoad provLoader = new ProvLoad(provinceRange);
                try {
                    provLoader.load(fileResProvince);
                }
                catch (IOException ex) {
                    System.out.println("Errore nel caricamento del file di risorse province_range_06.res");
                }
                System.out.println("OK, province caricate.");
                System.out.println("Caricamento di comuni, cod.catastali e aliquote dal file di risorse province_range_06.res");
                Vector v = new Vector();
                Vector<Integer> valiqinc = new Vector<Integer>();
                ComCatAli comccaLoader = new ComCatAli(v);
                try {
                    comccaLoader.load(fileResComCCatAliq);
                    comuni = new String[v.size()];
                    codCatastali = new String[v.size()];
                    aliquote = new double[v.size()];
                    comuniSoppressi = new int[v.size()];
                    int i = 0;
                    while (i < v.size()) {
                        String[] elemento = (String[])v.elementAt(i);
                        ComuniProvincia.comuni[i] = elemento[0];
                        ComuniProvincia.codCatastali[i] = elemento[1];
                        if (elemento[2].endsWith("?")) {
                            valiqinc.addElement(new Integer(i));
                            ComuniProvincia.aliquote[i] = Double.valueOf(elemento[2].substring(0, elemento[2].length() - 1));
                        } else {
                            ComuniProvincia.aliquote[i] = Double.valueOf(elemento[2]);
                        }
                        ComuniProvincia.comuniSoppressi[i] = Integer.parseInt(elemento[3]);
                        ++i;
                    }
                    aliqIncerte = new int[valiqinc.size()];
                    i = 0;
                    while (i < valiqinc.size()) {
                        ComuniProvincia.aliqIncerte[i] = (Integer)valiqinc.elementAt(i);
                        ++i;
                    }
                    comccaLoader.resetData();
                    System.out.println("OK, comuni, cod.catastali e aliquote caricati.");
                }
                catch (IOException ex) {
                    System.out.println("Errore nel caricamento del file di risorse comuni_ccat_aliq_06.res");
                }
            }
        }
    }

    public static void loadRicercaCodCat() {
        if (ricercaCodCat == null) {
            System.out.println("Caricamento dei codici catastali dal file di risorse comuni_ccat_aliq_06.res");
            ricercaCodCat = new Hashtable();
            CodCatL codCatLoader = new CodCatL();
            try {
                codCatLoader.load(fileResComCCatAliq);
            }
            catch (IOException ex) {
                System.out.println("Errore nel caricamento del file di risorse comuni_ccat_aliq_06.res");
            }
            System.out.println("OK, codici catastali caricati.");
        }
    }

    public static void unload() {
        ComuniProvincia.unload(true);
    }

    public static void unload(boolean invokeGC) {
        provinceRange = null;
        comuni = null;
        codCatastali = null;
        aliquote = null;
        System.out.println("OK, province, comuni, cod.catastali e aliquote scaricati" + (invokeGC ? " ed eliminati dalla memoria." : "."));
        if (invokeGC) {
            System.gc();
        }
    }

    public static void unloadRicercaCodCat() {
        ComuniProvincia.unloadRicercaCodCat(true);
    }

    public static void unloadRicercaCodCat(boolean invokeGC) {
        ricercaCodCat = null;
        System.out.println("OK, codici catastali scaricati" + (invokeGC ? " ed eliminati dalla memoria." : "."));
        if (invokeGC) {
            System.gc();
        }
    }

    static final class ProvComIn {
        int primo = 0;
        int ultimo = 0;
        int codRegione = 0;

        public ProvComIn(int primo, int ultimo, int codRegione) {
            this.primo = primo;
            this.ultimo = ultimo;
            this.codRegione = codRegione;
        }
    }

    static class ProvLoad
    extends ResourceLoader {
        public ProvLoad(Object resourceData) {
            super(resourceData);
        }

        protected Object createValue(String value) {
            int sepPos = value.indexOf(",");
            int sepPos2 = value.indexOf("*");
            String da = value.substring(0, sepPos);
            String a = value.substring(sepPos + 1, sepPos2);
            String codReg = value.substring(sepPos2 + 1);
            return new ProvComIn(Integer.parseInt(da), Integer.parseInt(a), Integer.parseInt(codReg));
        }
    }

    static class ComCatAli
    extends ResourceLoader {
        public ComCatAli(Object resourceData) {
            super(resourceData);
        }

        public void resetData() {
            this.resourceData = null;
        }

        protected Object createValue(String value) {
            String[] valTkns = new String[4];
            int i = 0;
            int j = 0;
            int currIndex = 0;
            while (i < 4 && j >= 0) {
                j = value.indexOf("*", currIndex);
                valTkns[i] = j == -1 ? value.substring(currIndex) : value.substring(currIndex, j);
                currIndex = j + 1;
                ++i;
            }
            if (i < 4) {
                throw new RuntimeException("Impossibile costruire la tabella Comuni/Cod.Catastali/Aliquote: parametri insufficienti");
            }
            return new String[]{valTkns[0], valTkns[1], valTkns[2], valTkns[3]};
        }
    }

    static class CodCatL
    extends ResourceLoader {
        private String sep = "*";
        private Integer dummyInt = new Integer(0);

        public CodCatL() {
            super(new Vector());
        }

        protected void loadData(String line) {
            int init = line.indexOf(this.sep);
            int end = line.indexOf(this.sep, init + 1);
            String codCat = line.substring(init + 1, end);
            ricercaCodCat.put(codCat, this.dummyInt);
        }

        protected Object createValue(String value) {
            return null;
        }
    }
}

