/*
 * Decompiled with CFR 0.152.
 */
package finanze.IDTE.studi2002.calcolo;

import finanze.IDTE.studi2002.campi.ControlloFormaleException;
import finanze.IDTE.studi2002.campi.GericoModel;
import finanze.IDTE.studi2002.campi.NumericModel;
import finanze.IDTE.studi2002.campi.ValutaNumericModel;
import finanze.IDTE.studi2002.generale.Arrays;
import finanze.IDTE.studi2002.generale.Comparator;
import finanze.IDTE.studi2002.posizione.ModelloN;
import finanze.IDTE.studi2002.posizione.Posizione;
import finanze.IDTE.studi2002.risorse.CalcoloAsSet;
import java.text.Collator;
import java.util.Hashtable;
import java.util.Vector;

public class CalcoloAS {
    private String[] codici = null;
    private Hashtable spalmoResti = null;
    private Hashtable codiciResti = null;
    private static Vector ricaviTotaliPerPuntoMinori20Percento = null;
    StringBuffer sb = new StringBuffer();
    private double ricavoDichiaratoTotale = 0.0;
    private boolean flagCongruo;
    private boolean studioCoerente = true;
    private final int INDICE_ARRAY = 0;
    private final int CODICE_STUDIO_ARRAY = 1;
    private final int PROGRESSIVO_ARRAY = 2;
    private Vector listaStudi = null;
    private Vector listaStudiTotale = null;
    private Vector messaggioErrore = null;
    private ModelloN modelloN = null;
    private double[][] listaStudiMinori20Perc = null;
    private double ricaviRicagNO = 0.0;
    private double ricavoTotale = 0.0;
    private double ricavoTotaleAll = 0.0;
    private double ricavoTotale_N08 = 0.0;
    private double ricavoTotale_N10 = 0.0;
    private double ricavoTotale_F12 = 0.0;
    private double ricavoMinimo = 0.0;
    private double ricavoStimato = 0.0;
    private double[] CV = null;
    private double coeff_sc = 0.0;
    private String[] listaCvCvProd = null;
    private Vector listaCalcoliTotale = null;
    private double[] listaCoefficentiPersonale = null;
    private double[] listaCoefficentiCostoDelVenduto = null;
    private double[] listaPercentualiRicavi = null;
    private double[] listaPercentualiRicavi_N08 = null;
    private double[] listaPercentualiRicavi_N10 = null;
    private double[] listaPercentualiRicavi_F12 = null;
    private double[] listaCoefficentiContabileMagazzino = null;
    private Boolean[] listaMultiattivita = null;
    private Vector fattoriCorrettivi = null;
    private double[][] listaCoefficentiContabile = null;
    private double[][] valore = null;
    private static String DATI = "dati" + System.getProperty("file.separator");
    private int indiceStudio = 0;
    private final int RICAVO = 0;
    private final int ANNOTAZIONE_DISTINTA = 1;
    private final int POSIZIONE = 2;
    private final int CODICE_STUDIO = 3;
    private final int CODICE_QUADRO_A = 0;
    private final int CODICE_QUADRO_N = 1;
    private final int CODICE_QUADRO_F = 0;
    private final int ROTAZIONE_MEDIANA = 0;
    private final int INCIDENZA_MEDIANA = 1;
    private int NUMERO_COEFFICENTI_CONTABILE = 4;
    private int NUMERO_COEFFICENTI_CONTABILE_MAGAZZINO = 1;
    private double aliquotaMedia = Double.NaN;
    private boolean ivaForzata;
    private double ivaRicavoStimato = Double.NaN;
    private double ivaRicavoMinimo = Double.NaN;
    private String fieldMessaggioAggi = new String();

    public CalcoloAS(Vector param, ModelloN modelloN, double[][] listaStudiMinori20Perc, double ricaviRicagNO) {
        this.listaStudiTotale = param;
        this.caricaStudiIndivisi();
        this.ricaviRicagNO = ricaviRicagNO;
        this.modelloN = modelloN;
        this.listaStudiMinori20Perc = listaStudiMinori20Perc;
        this.listaCalcoliTotale = new Vector();
        this.ripartisceRicaviStudiMinori20PerCento();
        this.calcolaCorrettivi();
    }

    public CalcoloAS(Vector param, ModelloN modelloN, double ricaviRicagNO) {
        this.listaStudiTotale = param;
        this.caricaStudiIndivisi();
        this.ricaviRicagNO = ricaviRicagNO;
        this.modelloN = modelloN;
        this.listaCalcoliTotale = new Vector();
        this.calcolaCorrettivi();
    }

    private boolean aggiCalcolabili() {
        double costoProduzioneServizi = 0.0;
        double acquisti = 0.0;
        double esistenze = 0.0;
        double rimanenze = 0.0;
        double CVProd = 0.0;
        double ricavi = 0.0;
        int i = 0;
        while (i < this.listaStudi.size()) {
            costoProduzioneServizi += this.getVal("F01001", i);
            ricavi += this.getVal("F01401", i);
            acquisti += this.getVal("F00901", i);
            esistenze += this.getVal("F00101", i);
            rimanenze += this.getVal("F00501", i);
            ++i;
        }
        CVProd = this.max(0.0, acquisti + costoProduzioneServizi + esistenze - rimanenze);
        if (!(ricavi > CVProd)) {
            if (this.messaggioErrore == null) {
                this.messaggioErrore = new Vector();
            }
            this.messaggioErrore.addElement("Costo del venduto uguale o maggiore dei ricavi dichiarati. Aggi non calcolati");
            return false;
        }
        this.coeff_sc = this.ricaviRicagNO / (ricavi - CVProd + this.ricaviRicagNO);
        return true;
    }

    private void calcolaCorrettivi() {
        this.correttivoF16();
        this.calcolaRicavoTotale();
        this.calcolaRicavoTotale_N08();
        this.calcolaRicavoTotale_N10();
        this.calcolaPercentualeRicavoPerStudio();
        this.calcolaPercentualeRicavoPerStudio_N08();
        this.calcolaPercentualeRicavoPerStudio_N10();
        this.recuperaCoefficenti();
        if (this.ricaviRicagNO > 0.0 && this.aggiCalcolabili()) {
            this.scorporaValoriQuadroN(1.0 - this.coeff_sc);
        }
        this.correttivoRibaltamentoPersonaleGiornate();
        this.correttivoRibaltamentoPersonaleNumero();
        this.calcolaRicavoTotale_F12();
        this.calcolaPercentualeRicavoPerStudio_F12();
        this.correttivoRibaltamentoContabile();
        this.correttivoRibaltamentoContabileMagazzino();
        this.correttivoRibaltamentoCostoDelVenduto();
        this.correttivoEsistenzeInizialiEFinaliProdottiFiniti();
    }

    private double calcolaCorrettivo(double campoAF, double campoN, double percentualeRicavo, double coefficente, double denominatore) {
        return campoAF + campoN * (percentualeRicavo * coefficente) / denominatore;
    }

    private void calcolaPercentualeRicavoPerStudio() {
        this.listaPercentualiRicavi = new double[this.listaStudi.size()];
        int i = 0;
        while (i < this.listaStudi.size()) {
            this.listaPercentualiRicavi[i] = this.ricavoTotale > 0.0 ? this.getRicavo(i) / this.ricavoTotale : 0.0;
            String cfr_ignored_0 = String.valueOf(((Posizione)((Object[])this.listaStudi.elementAt(i))[2]).getChiave().getCodiceStudio()) + " (" + ((Posizione)((Object[])this.listaStudi.elementAt(i))[2]).getChiave().getProgressivo() + ")";
            ++i;
        }
    }

    private void calcolaPercentualeRicavoPerStudio_F12() {
        this.listaPercentualiRicavi_F12 = new double[this.listaStudi.size()];
        if (this.ricavoTotale_F12 > 0.0) {
            this.indiceStudio = 0;
            while (this.indiceStudio < this.listaStudi.size()) {
                if (this.getValoreCampiPersonale(this.getPosizione(this.indiceStudio)) > 0.0) {
                    this.listaPercentualiRicavi_F12[this.indiceStudio] = this.getRicavo(this.indiceStudio) / this.ricavoTotale_F12;
                    String cfr_ignored_0 = String.valueOf(((Posizione)((Object[])this.listaStudi.elementAt(this.indiceStudio))[2]).getChiave().getCodiceStudio()) + " (" + ((Posizione)((Object[])this.listaStudi.elementAt(this.indiceStudio))[2]).getChiave().getProgressivo() + ")";
                }
                ++this.indiceStudio;
            }
        } else {
            this.listaPercentualiRicavi_F12 = this.listaPercentualiRicavi;
        }
    }

    private void calcolaPercentualeRicavoPerStudio_N08() {
        this.listaPercentualiRicavi_N08 = new double[this.listaStudi.size()];
        int i = 0;
        while (i < this.listaStudi.size()) {
            String cod = this.getPosizione(i).getChiave().getCodiceStudio();
            this.listaPercentualiRicavi_N08[i] = cod.equalsIgnoreCase("SK16U") || cod.equalsIgnoreCase("SK19U") || cod.equalsIgnoreCase("SK21U") ? 0.0 : (this.ricavoTotale_N08 > 0.0 ? this.getRicavo(i) / this.ricavoTotale_N08 : 0.0);
            String cfr_ignored_0 = String.valueOf(((Posizione)((Object[])this.listaStudi.elementAt(i))[2]).getChiave().getCodiceStudio()) + " (" + ((Posizione)((Object[])this.listaStudi.elementAt(i))[2]).getChiave().getProgressivo() + ")";
            ++i;
        }
    }

    private void calcolaPercentualeRicavoPerStudio_N10() {
        this.listaPercentualiRicavi_N10 = new double[this.listaStudi.size()];
        int i = 0;
        while (i < this.listaStudi.size()) {
            String cod = this.getPosizione(i).getChiave().getCodiceStudio();
            this.listaPercentualiRicavi_N10[i] = cod.equalsIgnoreCase("SK16U") || cod.equalsIgnoreCase("SK19U") || cod.equalsIgnoreCase("SK21U") || cod.equalsIgnoreCase("SG56U") || cod.equalsIgnoreCase("SG74U") || cod.equalsIgnoreCase("SG73A") || cod.equalsIgnoreCase("SG73B") || cod.equalsIgnoreCase("SK08U") ? 0.0 : (this.ricavoTotale_N10 > 0.0 ? this.getRicavo(i) / this.ricavoTotale_N10 : 0.0);
            String cfr_ignored_0 = String.valueOf(((Posizione)((Object[])this.listaStudi.elementAt(i))[2]).getChiave().getCodiceStudio()) + " (" + ((Posizione)((Object[])this.listaStudi.elementAt(i))[2]).getChiave().getProgressivo() + ")";
            ++i;
        }
    }

    private void calcolaPercentualeRicavoPerStudioTotale() {
        this.listaPercentualiRicavi = new double[this.listaStudiTotale.size()];
        this.calcolaRicavoTotaleAll();
        int i = 0;
        while (i < this.listaStudiTotale.size()) {
            this.listaPercentualiRicavi[i] = this.ricavoTotaleAll > 0.0 ? this.getRicavoAll(i) / this.ricavoTotaleAll : 0.0;
            String cfr_ignored_0 = String.valueOf(((Posizione)((Object[])this.listaStudiTotale.elementAt(i))[2]).getChiave().getCodiceStudio()) + " (" + ((Posizione)((Object[])this.listaStudiTotale.elementAt(i))[2]).getChiave().getProgressivo() + ")";
            ++i;
        }
    }

    private Vector calcolaRicaviPerPunto() {
        double ricaviTot = 0.0;
        double punto = 0.0;
        Object[] listaStudiObj = new Object[this.listaStudiTotale.size()];
        this.listaStudiTotale.copyInto(listaStudiObj);
        Arrays.sort(listaStudiObj, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                int s1 = Integer.parseInt(((Posizione)((Object[])obj1)[2]).getChiave().getProgressivo());
                int s2 = Integer.parseInt(((Posizione)((Object[])obj2)[2]).getChiave().getProgressivo());
                return s1 - s2;
            }
        });
        Vector<double[]> totaliRicavi = new Vector<double[]>();
        double[] totali = null;
        int j = 0;
        int i = 1;
        while (j < listaStudiObj.length) {
            punto = Double.valueOf(((Posizione)((Object[])listaStudiObj[j])[2]).getChiave().getProgressivo());
            ricaviTot = this.getRicavo((Posizione)((Object[])listaStudiObj[j])[2]);
            while (i < listaStudiObj.length) {
                if (punto == 99.0 || punto != Double.valueOf(((Posizione)((Object[])listaStudiObj[i])[2]).getChiave().getProgressivo())) break;
                ricaviTot += this.getRicavo((Posizione)((Object[])listaStudiObj[i])[2]);
                j = i++;
            }
            totali = new double[]{punto, ricaviTot};
            totaliRicavi.addElement(totali);
            i = ++j + 1;
        }
        return totaliRicavi;
    }

    private void calcolaRicavoTotale() {
        this.ricavoTotale = 0.0;
        int i = 0;
        while (i < this.listaStudi.size()) {
            this.ricavoTotale += this.getRicavo(i);
            ++i;
        }
    }

    private void calcolaRicavoTotale_F12() {
        this.indiceStudio = 0;
        while (this.indiceStudio < this.listaStudi.size()) {
            if (this.getValoreCampiPersonale(this.getPosizione(this.indiceStudio)) > 0.0) {
                this.ricavoTotale_F12 += this.getRicavo(this.indiceStudio);
            }
            ++this.indiceStudio;
        }
    }

    private void calcolaRicavoTotale_N08() {
        int i = 0;
        while (i < this.listaStudi.size()) {
            String cod = this.getPosizione(i).getChiave().getCodiceStudio();
            if (!(cod.equalsIgnoreCase("SK16U") || cod.equalsIgnoreCase("SK19U") || cod.equalsIgnoreCase("SK21U"))) {
                this.ricavoTotale_N08 += this.getRicavo(i);
            }
            ++i;
        }
    }

    private void calcolaRicavoTotale_N10() {
        int i = 0;
        while (i < this.listaStudi.size()) {
            String cod = this.getPosizione(i).getChiave().getCodiceStudio();
            if (!(cod.equalsIgnoreCase("SK16U") || cod.equalsIgnoreCase("SK19U") || cod.equalsIgnoreCase("SK21U") || cod.equalsIgnoreCase("SG56U") || cod.equalsIgnoreCase("SG74U") || cod.equalsIgnoreCase("SG73A") || cod.equalsIgnoreCase("SG73B") || cod.equalsIgnoreCase("SK08U"))) {
                this.ricavoTotale_N10 += this.getRicavo(i);
            }
            ++i;
        }
    }

    private void calcolaRicavoTotaleAll() {
        int i = 0;
        while (i < this.listaStudiTotale.size()) {
            this.ricavoTotaleAll += this.getRicavoAll(i);
            ++i;
        }
    }

    private String[][] caricaCampiContabile() {
        return new String[][]{{"F01001", "N02501"}, {"F01101", "N02601"}, {"F01201", "N02701"}, {"F01301", "N02801"}};
    }

    private String[][] caricaCampiContabileMagazzino() {
        return new String[][]{{"F00101", "N02001"}, {"F00501", "N02201"}};
    }

    private String[][] caricaCampiEsistenzeRimanenzeProdottiFiniti() {
        return new String[][]{{"F00201", "N02101"}, {"F00601", "N02301"}};
    }

    private String[] caricaCampiPersonale_F12() {
        String[] app = null;
        Posizione p = this.getPosizione(this.indiceStudio);
        app = p.getCampi().get("A01801") != null ? new String[]{"A00101", "A00201", "A00301", "A00401", "A00501", "A00601", "A00701", "A00801", "A00901", "A01001", "A01101"} : (p.getCampi().get("A01701") != null ? new String[]{"A00101", "A00201", "A00301", "A00401", "A00501", "A00601", "A00701", "A00801", "A00901", "A01001"} : (p.getCampi().get("A01301") != null ? new String[]{"A00101", "A00201", "A00301", "A00401", "A00501", "A00601"} : new String[]{"A00101", "A00201", "A00301", "A00401"}));
        return app;
    }

    private String[][] caricaCampiPersonaleGiornate() {
        String[][] app = null;
        Posizione p = this.getPosizione(this.indiceStudio);
        app = p.getCampi().get("A01801") != null ? new String[][]{{"A00101", "N00101"}, {"A00101", "N00201"}, {"A00201", "N00301"}, {"A00301", "N00401"}, {"A00401", "N00501"}, {"A00501", "N00601"}, {"A00601", "N00701"}, {"A00701", "N00801"}, {"A00801", "N00901"}, {"A00901", "N01001"}} : (p.getCampi().get("A01701") != null ? new String[][]{{"A00101", "N00101"}, {"A00101", "N00201"}, {"A00201", "N00301"}, {"A00301", "N00401"}, {"A00401", "N00501"}, {"A00501", "N00601"}, {"A00601", "N00701"}, {"A00701", "N00801"}, {"A00801", "N00901"}, {"A00801", "N01001"}} : (p.getCampi().get("A01301") != null ? (p.getChiave().getCodiceStudio().trim().equalsIgnoreCase("SG56U") || p.getChiave().getCodiceStudio().trim().equalsIgnoreCase("SG74U") || p.getChiave().getCodiceStudio().trim().equalsIgnoreCase("SK08U") || p.getChiave().getCodiceStudio().trim().equalsIgnoreCase("SG73A") || p.getChiave().getCodiceStudio().trim().equalsIgnoreCase("SG73B") ? new String[][]{{"A00101", "N00101"}, {"A00101", "N00201"}, {"A00101", "N00301"}, {"A00101", "N00401"}, {"A00101", "N00501"}, {"A00101", "N00601"}, {"A00301", "N00701"}, {"A00201", "N00801"}, {"A00301", "N00901"}} : new String[][]{{"A00101", "N00101"}, {"A00101", "N00201"}, {"A00101", "N00301"}, {"A00101", "N00401"}, {"A00101", "N00501"}, {"A00101", "N00601"}, {"A00201", "N00701"}, {"A00301", "N00801"}, {"A00401", "N00901"}, {"A00401", "N01001"}}) : new String[][]{{"A00101", "N00101"}, {"A00101", "N00201"}, {"A00101", "N00301"}, {"A00101", "N00401"}, {"A00101", "N00501"}, {"A00101", "N00601"}, {"A00201", "N00701"}, {"A00201", "N00901"}}));
        return app;
    }

    private Vector caricaCampiPersonaleNumero() {
        String[][] app = null;
        Vector<String[][]> app1 = new Vector<String[][]>();
        int i = 0;
        while (i < this.listaStudi.size()) {
            Posizione p = this.getPosizione(i);
            app = p.getCampi().get("A01801") != null ? new String[][]{{"A01001", "N01101"}, {"A01101", "N01201"}, {"A01201", "N01301"}, {"A01301", "N01401"}, {"A01401", "N01501"}, {"A01501", "N01601"}, {"A01601", "N01701"}, {"A01701", "N01801"}, {"A01801", "N01901"}} : (p.getCampi().get("A01701") != null ? new String[][]{{"A00901", "N01101"}, {"A01001", "N01201"}, {"A01101", "N01301"}, {"A01201", "N01401"}, {"A01301", "N01501"}, {"A01401", "N01601"}, {"A01501", "N01701"}, {"A01601", "N01801"}, {"A01701", "N01901"}} : (p.getCampi().get("A01301") != null ? (p.getChiave().getCodiceStudio().trim().equalsIgnoreCase("SG56U") || p.getChiave().getCodiceStudio().trim().equalsIgnoreCase("SG74U") || p.getChiave().getCodiceStudio().trim().equalsIgnoreCase("SK08U") || p.getChiave().getCodiceStudio().trim().equalsIgnoreCase("SG73A") || p.getChiave().getCodiceStudio().trim().equalsIgnoreCase("SG73B") ? new String[][]{{"A00401", "N01101"}, {"A00501", "N01201"}, {"A00701", "N01301"}, {"A00801", "N01401"}, {"A00901", "N01501"}, {"A01001", "N01601"}, {"A01101", "N01701"}, {"A01201", "N01801"}, {"A01301", "N01901"}} : new String[][]{{"A00501", "N01101"}, {"A00601", "N01201"}, {"A00701", "N01301"}, {"A00801", "N01401"}, {"A00901", "N01501"}, {"A01001", "N01601"}, {"A01101", "N01701"}, {"A01201", "N01801"}, {"A01301", "N01901"}}) : new String[][]{{"A00301", "N01101"}, {"A00401", "N01201"}, {"A00601", "N01301"}, {"A00701", "N01401"}, {"A00801", "N01501"}, {"A00901", "N01601"}, {"A01001", "N01701"}, {"A01101", "N01801"}, {"A01201", "N01901"}}));
            app1.addElement(app);
            ++i;
        }
        return app1;
    }

    private void caricaHashtablePerSpalmoResti(String[] codici) {
        this.spalmoResti = new Hashtable(codici.length);
        this.codiciResti = new Hashtable(codici.length);
        int i = 0;
        while (i < codici.length) {
            this.spalmoResti.put(codici[i], new double[this.listaStudi.size()]);
            this.codiciResti.put(codici[i], new String[this.listaStudi.size()]);
            ++i;
        }
    }

    private void caricaListaMultiattivita() {
        this.listaMultiattivita = new Boolean[this.listaStudiTotale.size()];
        String[][] appoggio = new String[this.listaStudiTotale.size()][3];
        int i = 0;
        while (i < this.listaStudiTotale.size()) {
            appoggio[i] = new String[]{String.valueOf(i), ((Posizione)((Object[])this.listaStudiTotale.elementAt(i))[2]).getChiave().getCodiceStudio(), ((Posizione)((Object[])this.listaStudiTotale.elementAt(i))[2]).getChiave().getProgressivo()};
            ++i;
        }
        Collator collator = Collator.getInstance();
        Arrays.sort((Object[])appoggio, new Comparator(collator){
            /* synthetic */ Collator val$collator;

            public int compare(Object obj1, Object obj2) {
                String s1 = ((String[])obj1)[2];
                String s2 = ((String[])obj2)[2];
                return this.val$collator.compare(s1, s2);
            }
            {
                this.val$collator = val$collator;
            }
        });
        if (appoggio.length > 0) {
            String progressivo = appoggio[0][2];
            Vector<String[]> app = new Vector<String[]>();
            app.addElement(appoggio[0]);
            int i2 = 1;
            while (i2 < this.listaStudiTotale.size()) {
                if (!appoggio[i2][2].equals(progressivo)) {
                    this.settaMultiattivita(app);
                    app.removeAllElements();
                    progressivo = appoggio[i2][2];
                    app.addElement(appoggio[i2]);
                } else {
                    app.addElement(appoggio[i2]);
                }
                ++i2;
            }
            this.settaMultiattivita(app);
        }
    }

    private void caricaStudiIndivisi() {
        this.listaStudi = new Vector();
        if (!this.tuttiDistinti()) {
            int i = 0;
            while (i < this.listaStudiTotale.size()) {
                if (!this.getQuadro_M_AnnotazioneDistinta(i)) {
                    this.listaStudi.addElement(this.listaStudiTotale.elementAt(i));
                }
                ++i;
            }
        } else {
            this.listaStudi = this.listaStudiTotale;
        }
    }

    private int[] correggeDifferenze(Vector gericoModel, double differenza) {
        GericoModel gm = null;
        int i = 0;
        if (differenza < 0.0) {
            gm = (GericoModel)gericoModel.elementAt(i);
            double max = new Double(gm.getValue());
            i = 1;
            while (i < gericoModel.size()) {
                Double d = new Double(((GericoModel)gericoModel.elementAt(i)).getValue());
                if (d > max) {
                    max = new Double(((GericoModel)gericoModel.elementAt(i)).getValue());
                    gm = (GericoModel)gericoModel.elementAt(i);
                }
                ++i;
            }
            try {
                long ris = new Double(new Double(gm.getValue()) + differenza).longValue();
                gm.setValore(String.valueOf(ris));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            gm = (GericoModel)gericoModel.elementAt(i);
            double min = new Double(gm.getValue());
            i = 1;
            while (i < gericoModel.size()) {
                Double d = new Double(((GericoModel)gericoModel.elementAt(i)).getValue());
                if (d < min) {
                    min = new Double(((GericoModel)gericoModel.elementAt(i)).getValue());
                    gm = (GericoModel)gericoModel.elementAt(i);
                }
                ++i;
            }
            try {
                long ris = new Double(new Double(gm.getValue()) + differenza).longValue();
                gm.setValore(String.valueOf(ris));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (i > 0) {
            return new int[]{i / 2 - 1, Integer.parseInt(gm.getCode().substring(2, 4))};
        }
        return new int[]{0, 0};
    }

    private void correggeValoriCampiSpalmati() {
        String cod = null;
        String codice = null;
        double diff = 0.0;
        int indice = 0;
        int i = 0;
        while (i < this.codici.length) {
            indice = 0;
            double somma = 0.0;
            codice = this.codici[i];
            double[] arr = (double[])this.spalmoResti.get(codice);
            double app = 0.0;
            int w = 0;
            while (w < arr.length) {
                app += arr[w];
                ++w;
            }
            if (app != 0.0) {
                int j = 0;
                while (j < arr.length) {
                    somma += (double)Math.round(arr[j]);
                    ++j;
                }
                if (this.getValN(codice) != somma) {
                    diff = this.getValN(codice) - somma;
                    int x = 0;
                    while ((double)x < Math.abs(diff)) {
                        double par;
                        if (diff > 0.0) {
                            par = arr[0] - (double)Math.round(arr[0]) - 0.5;
                            indice = 0;
                            int j2 = 1;
                            while (j2 < arr.length) {
                                if (arr[j2] - (double)Math.round(arr[j2]) - 0.5 > par) {
                                    par = arr[j2] - (double)Math.round(arr[j2]) - 0.5;
                                    indice = j2;
                                }
                                ++j2;
                            }
                            cod = ((String[])this.codiciResti.get(codice))[indice];
                            this.indiceStudio = indice;
                            this.setVal(cod, this.getVal(cod) + 1.0);
                            arr[indice] = 0.0;
                        } else if (diff < 0.0) {
                            par = arr[0] - (double)Math.round(arr[0]) - 0.5;
                            indice = 0;
                            int k = 1;
                            while (k < arr.length) {
                                if (arr[k] - (double)Math.round(arr[k]) - 0.5 < par) {
                                    par = arr[k] - (double)Math.round(arr[k]) - 0.5;
                                    indice = k;
                                }
                                ++k;
                            }
                            cod = ((String[])this.codiciResti.get(codice))[indice];
                            this.indiceStudio = indice;
                            this.setVal(cod, this.getVal(cod) - 1.0);
                            arr[indice] = 0.0;
                        }
                        ++x;
                    }
                }
            }
            ++i;
        }
    }

    private void correttivoAcquisti() {
        this.indiceStudio = 0;
        while (this.indiceStudio < this.listaStudi.size()) {
            this.getPosizione(this.indiceStudio);
            double acquistiMerci = 0.0;
            acquistiMerci = this.CV[this.indiceStudio] + this.getVal("F00501") - this.getVal("F00101");
            if (this.listaCvCvProd[this.indiceStudio].trim().equalsIgnoreCase("CVPROD")) {
                acquistiMerci -= this.getVal("F01001");
            }
            this.setVal("F00901", acquistiMerci);
            ++this.indiceStudio;
        }
        this.correggeValoriCampiSpalmati();
    }

    private void correttivoEsistenzeInizialiEFinaliProdottiFiniti() {
        try {
            if (this.getValN("N02101") != 0.0 || this.getValN("N02301") != 0.0) {
                this.codici = new String[]{"N02101", "N02301"};
                this.caricaHashtablePerSpalmoResti(this.codici);
                String campoAF = "";
                String campoN = "";
                double valoreCalcolato = 0.0;
                String[][] campiEsRimProdFin = this.caricaCampiEsistenzeRimanenzeProdottiFiniti();
                this.indiceStudio = 0;
                while (this.indiceStudio < this.listaStudi.size()) {
                    this.getPosizione(this.indiceStudio);
                    double denominatore = this.getDenominatore(this.listaPercentualiRicavi, this.listaCoefficentiContabileMagazzino);
                    int i = 0;
                    while (i < campiEsRimProdFin.length) {
                        campoAF = campiEsRimProdFin[i][0];
                        campoN = campiEsRimProdFin[i][1];
                        valoreCalcolato = this.calcolaCorrettivo(this.getVal(campoAF), this.getValN(campoN), this.listaPercentualiRicavi[this.indiceStudio], this.listaCoefficentiContabileMagazzino[this.indiceStudio], denominatore);
                        ((double[])this.spalmoResti.get((Object)campoN))[this.indiceStudio] = valoreCalcolato - this.getVal(campoAF) > 0.0 ? valoreCalcolato - this.getVal(campoAF) : 0.0;
                        ((String[])this.codiciResti.get((Object)campoN))[this.indiceStudio] = campoAF;
                        this.setVal(campoAF, valoreCalcolato);
                        ++i;
                    }
                    ++this.indiceStudio;
                }
                this.correggeValoriCampiSpalmati();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void correttivoF16() {
        try {
            if (this.getValN("N02901") != 0.0 || this.getValN("N02902") != 0.0) {
                this.calcolaRicavoTotale();
                this.calcolaPercentualeRicavoPerStudio();
                this.codici = new String[]{"N02901", "N02902"};
                this.caricaHashtablePerSpalmoResti(this.codici);
                String campoAF = "";
                String campoN = "";
                double valoreCalcolato = 0.0;
                String[] campiF16 = new String[]{"F01601", "F01602"};
                this.indiceStudio = 0;
                while (this.indiceStudio < this.listaStudi.size()) {
                    this.getPosizione(this.indiceStudio);
                    int i = 0;
                    while (i < campiF16.length) {
                        campoAF = campiF16[i];
                        campoN = this.codici[i];
                        valoreCalcolato = this.getVal(campoAF) + this.getValN(campoN) * this.listaPercentualiRicavi[this.indiceStudio];
                        ((double[])this.spalmoResti.get((Object)campoN))[this.indiceStudio] = valoreCalcolato - this.getVal(campoAF) > 0.0 ? valoreCalcolato - this.getVal(campoAF) : 0.0;
                        ((String[])this.codiciResti.get((Object)campoN))[this.indiceStudio] = campoAF;
                        ++i;
                    }
                    ++this.indiceStudio;
                }
                this.correggeValoriCampiSpalmati();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void correttivoRibaltamentoContabile() {
        try {
            if (this.getValN("N02501") != 0.0 || this.getValN("N02601") != 0.0 || this.getValN("N02701") != 0.0 || this.getValN("N02801") != 0.0) {
                this.codici = new String[]{"N02501", "N02601", "N02701", "N02801"};
                this.caricaHashtablePerSpalmoResti(this.codici);
                String campoAF = "";
                String campoN = "";
                double valoreCalcolato = 0.0;
                String[][] campiContabile = this.caricaCampiContabile();
                this.indiceStudio = 0;
                while (this.indiceStudio < this.listaStudi.size()) {
                    this.getPosizione(this.indiceStudio);
                    int i = 0;
                    while (i < campiContabile.length) {
                        campoAF = campiContabile[i][0];
                        campoN = campiContabile[i][1];
                        valoreCalcolato = 0.0;
                        if (campoAF.trim().equalsIgnoreCase("F01201")) {
                            double denominatore_F12 = this.getDenominatoreContabile_F12(i);
                            if (denominatore_F12 > 0.0) {
                                valoreCalcolato = this.calcolaCorrettivo(this.getVal(campoAF), this.getValN(campoN), this.listaPercentualiRicavi_F12[this.indiceStudio], this.listaCoefficentiContabile[this.indiceStudio][i], denominatore_F12);
                                ((double[])this.spalmoResti.get((Object)campoN))[this.indiceStudio] = valoreCalcolato - this.getVal(campoAF) > 0.0 ? valoreCalcolato - this.getVal(campoAF) : 0.0;
                                ((String[])this.codiciResti.get((Object)campoN))[this.indiceStudio] = campoAF;
                                this.setVal(campoAF, valoreCalcolato);
                            }
                        } else {
                            double denominatore = this.getDenominatoreContabile(i);
                            valoreCalcolato = this.calcolaCorrettivo(this.getVal(campoAF), this.getValN(campoN), this.listaPercentualiRicavi[this.indiceStudio], this.listaCoefficentiContabile[this.indiceStudio][i], denominatore);
                            ((double[])this.spalmoResti.get((Object)campoN))[this.indiceStudio] = valoreCalcolato - this.getVal(campoAF) > 0.0 ? valoreCalcolato - this.getVal(campoAF) : 0.0;
                            ((String[])this.codiciResti.get((Object)campoN))[this.indiceStudio] = campoAF;
                            this.setVal(campoAF, valoreCalcolato);
                        }
                        ++i;
                    }
                    ++this.indiceStudio;
                }
                this.correggeValoriCampiSpalmati();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void correttivoRibaltamentoContabileMagazzino() {
        try {
            if (this.getValN("N02001") != 0.0 || this.getValN("N02201") != 0.0) {
                this.codici = new String[]{"N02001", "N02201"};
                this.caricaHashtablePerSpalmoResti(this.codici);
                String campoAF = "";
                String campoN = "";
                double valoreCalcolato = 0.0;
                String[][] campiContabileMagazzino = this.caricaCampiContabileMagazzino();
                this.indiceStudio = 0;
                while (this.indiceStudio < this.listaStudi.size()) {
                    this.getPosizione(this.indiceStudio);
                    double denominatore = this.getDenominatore(this.listaPercentualiRicavi, this.listaCoefficentiContabileMagazzino);
                    int i = 0;
                    while (i < campiContabileMagazzino.length) {
                        campoAF = campiContabileMagazzino[i][0];
                        campoN = campiContabileMagazzino[i][1];
                        valoreCalcolato = this.calcolaCorrettivo(this.getVal(campoAF), this.getValN(campoN), this.listaPercentualiRicavi[this.indiceStudio], this.listaCoefficentiContabileMagazzino[this.indiceStudio], denominatore);
                        ((double[])this.spalmoResti.get((Object)campoN))[this.indiceStudio] = valoreCalcolato - this.getVal(campoAF) > 0.0 ? valoreCalcolato - this.getVal(campoAF) : 0.0;
                        ((String[])this.codiciResti.get((Object)campoN))[this.indiceStudio] = campoAF;
                        this.setVal(campoAF, valoreCalcolato);
                        ++i;
                    }
                    ++this.indiceStudio;
                }
                this.correggeValoriCampiSpalmati();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void correttivoRibaltamentoCostoDelVenduto() {
        try {
            if (this.getValN("N02401") > 0.0) {
                double app;
                this.codici = new String[]{"N02401"};
                this.caricaHashtablePerSpalmoResti(this.codici);
                this.CV = new double[this.listaStudi.size()];
                double CVR = this.getValN("N02401");
                this.indiceStudio = 0;
                while (this.indiceStudio < this.listaStudi.size()) {
                    this.CV[this.indiceStudio] = this.getVal("F00101") + this.getVal("F00901") - this.getVal("F00501");
                    if (this.listaCvCvProd[this.indiceStudio].trim().equalsIgnoreCase("CVPROD")) {
                        int n = this.indiceStudio;
                        this.CV[n] = this.CV[n] + this.getVal("F01001");
                        this.getPosizione(this.indiceStudio);
                    }
                    if (CVR > 0.0 && (app = this.CV[this.indiceStudio]) < 0.0 && CVR > 0.0) {
                        this.getPosizione(this.indiceStudio);
                        if (app * -1.0 > CVR) {
                            app += CVR;
                            CVR = 0.0;
                        } else {
                            CVR += app;
                            app = 0.0;
                        }
                        this.CV[this.indiceStudio] = app;
                    }
                    ++this.indiceStudio;
                }
                this.setValN("N02401", CVR);
                if (this.getValN("N02401") > 0.0) {
                    this.indiceStudio = 0;
                    while (this.indiceStudio < this.listaStudi.size()) {
                        app = this.CV[this.indiceStudio];
                        this.getPosizione(this.indiceStudio);
                        double denominatore = this.getDenominatore(this.listaPercentualiRicavi, this.listaCoefficentiCostoDelVenduto);
                        this.CV[this.indiceStudio] = this.calcolaCorrettivo(this.CV[this.indiceStudio], CVR, this.listaPercentualiRicavi[this.indiceStudio], this.listaCoefficentiCostoDelVenduto[this.indiceStudio], denominatore);
                        ((double[])this.spalmoResti.get((Object)"N02401"))[this.indiceStudio] = this.CV[this.indiceStudio] - app > 0.0 ? this.CV[this.indiceStudio] - app : 0.0;
                        ((String[])this.codiciResti.get((Object)"N02401"))[this.indiceStudio] = "F00901";
                        ++this.indiceStudio;
                    }
                }
                this.correttivoAcquisti();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void correttivoRibaltamentoPersonaleGiornate() {
        try {
            if (this.getValN("N00101") != 0.0 || this.getValN("N00201") != 0.0 || this.getValN("N00301") != 0.0 || this.getValN("N00401") != 0.0 || this.getValN("N00501") != 0.0 || this.getValN("N00601") != 0.0 || this.getValN("N00701") != 0.0 || this.getValN("N00801") != 0.0 || this.getValN("N00901") != 0.0 || this.getValN("N01001") != 0.0) {
                this.codici = new String[]{"N00101", "N00201", "N00301", "N00401", "N00501", "N00601", "N00701", "N00801", "N00901", "N01001"};
                this.caricaHashtablePerSpalmoResti(this.codici);
                String campoAF = "";
                String campoN = "";
                double valoreCalcolato = 0.0;
                this.indiceStudio = 0;
                while (this.indiceStudio < this.listaStudi.size()) {
                    this.getPosizione(this.indiceStudio);
                    String[][] campiPersonaleGiornate = this.caricaCampiPersonaleGiornate();
                    double denominatore = 0.0;
                    double percRic = 0.0;
                    int i = 0;
                    while (i < campiPersonaleGiornate.length) {
                        campoAF = campiPersonaleGiornate[i][0];
                        campoN = campiPersonaleGiornate[i][1];
                        if (campoN.equalsIgnoreCase("N00801")) {
                            denominatore = this.getDenominatore(this.listaPercentualiRicavi_N08, this.listaCoefficentiPersonale);
                            percRic = this.listaPercentualiRicavi_N08[this.indiceStudio];
                        } else if (campoN.equalsIgnoreCase("N01001")) {
                            denominatore = this.getDenominatore(this.listaPercentualiRicavi_N10, this.listaCoefficentiPersonale);
                            percRic = this.listaPercentualiRicavi_N10[this.indiceStudio];
                        } else {
                            denominatore = this.getDenominatore(this.listaPercentualiRicavi, this.listaCoefficentiPersonale);
                            percRic = this.listaPercentualiRicavi[this.indiceStudio];
                        }
                        valoreCalcolato = this.calcolaCorrettivo(this.getVal(campoAF), this.getValN(campoN), percRic, this.listaCoefficentiPersonale[this.indiceStudio], denominatore);
                        ((double[])this.spalmoResti.get((Object)campoN))[this.indiceStudio] = valoreCalcolato - this.getVal(campoAF) > 0.0 ? valoreCalcolato - this.getVal(campoAF) : 0.0;
                        ((String[])this.codiciResti.get((Object)campoN))[this.indiceStudio] = campoAF;
                        this.setVal(campoAF, valoreCalcolato);
                        ++i;
                    }
                    ++this.indiceStudio;
                }
                this.correggeValoriCampiSpalmati();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void correttivoRibaltamentoPersonaleNumero() {
        if (this.getValN("N01101") != 0.0 || this.getValN("N01201") != 0.0 || this.getValN("N01301") != 0.0 || this.getValN("N01401") != 0.0 || this.getValN("N01501") != 0.0 || this.getValN("N01601") != 0.0 || this.getValN("N01701") != 0.0 || this.getValN("N01801") != 0.0 || this.getValN("N01901") != 0.0) {
            int numeroCampiPersonaleNumero = 9;
            Vector campiPersonaleNumero = this.caricaCampiPersonaleNumero();
            double[][] appoggio = new double[numeroCampiPersonaleNumero][this.listaStudi.size()];
            this.valore = new double[numeroCampiPersonaleNumero][this.listaStudi.size()];
            int i = 0;
            while (i < numeroCampiPersonaleNumero) {
                double totValorePrima = 0.0;
                double totValoreDopo = 0.0;
                double valoreCampoQuadroN = 0.0;
                int j = 0;
                while (j < this.listaStudi.size()) {
                    try {
                        totValorePrima += Double.valueOf(this.getPosizione(j).getCampo(((String[][])campiPersonaleNumero.elementAt(j))[i][0]).getValue()).doubleValue();
                        valoreCampoQuadroN = this.getValN(((String[][])campiPersonaleNumero.elementAt(j))[i][1]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    double valoreCampoQuadroA = Double.valueOf(this.getPosizione(j).getCampo(((String[][])campiPersonaleNumero.elementAt(j))[i][0]).getValue());
                    int variabileQuadroNRicalcolata = (int)(valoreCampoQuadroN * this.listaPercentualiRicavi[j]);
                    appoggio[i][j] = variabileQuadroNRicalcolata;
                    this.valore[i][j] = (double)variabileQuadroNRicalcolata + valoreCampoQuadroA;
                    ++j;
                }
                j = 0;
                while (j < this.listaStudi.size()) {
                    totValoreDopo += this.valore[i][j];
                    ++j;
                }
                this.indiceStudio = 0;
                while (this.indiceStudio < this.listaStudi.size()) {
                    this.getPosizione(this.indiceStudio);
                    ++this.indiceStudio;
                }
                if (totValorePrima + valoreCampoQuadroN > totValoreDopo) {
                    int unitaDaSpalmare = new Double(totValorePrima + valoreCampoQuadroN - totValoreDopo).intValue();
                    this.spalmaResti(unitaDaSpalmare, appoggio, i, valoreCampoQuadroN);
                }
                ++i;
            }
            try {
                this.indiceStudio = 0;
                while (this.indiceStudio < this.listaStudi.size()) {
                    this.getPosizione(this.indiceStudio);
                    int j = 0;
                    while (j < numeroCampiPersonaleNumero) {
                        this.setVal(((String[][])campiPersonaleNumero.elementAt(this.indiceStudio))[j][0], this.valore[j][this.indiceStudio]);
                        ++j;
                    }
                    ++this.indiceStudio;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private double getDenominatore(double[] ricavi, double[] coefficenti) {
        double denominatore = 0.0;
        int i = 0;
        while (i < this.listaStudi.size()) {
            denominatore += ricavi[i] * coefficenti[i];
            ++i;
        }
        return denominatore;
    }

    private double getDenominatoreContabile(int indiceVariabile) {
        double denominatore = 0.0;
        int i = 0;
        while (i < this.listaStudi.size()) {
            denominatore += this.listaPercentualiRicavi[i] * this.listaCoefficentiContabile[i][indiceVariabile];
            ++i;
        }
        return denominatore;
    }

    private double getDenominatoreContabile_F12(int indiceVariabile) {
        double denominatore_F12 = 0.0;
        int i = 0;
        while (i < this.listaStudi.size()) {
            denominatore_F12 += this.listaPercentualiRicavi_F12[i] * this.listaCoefficentiContabile[i][indiceVariabile];
            ++i;
        }
        return denominatore_F12;
    }

    protected double getDoubleValue(String code, int indice) throws Exception {
        return 0.0;
    }

    public static double[][] getMarginali(Object[][] listaStudiObj) {
        double ricavi;
        double punto;
        ricaviTotaliPerPuntoMinori20Percento = null;
        Arrays.sort((Object[])listaStudiObj, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                double s1 = (Double)((Object[])obj1)[0];
                double s2 = (Double)((Object[])obj2)[0];
                return (int)(s1 - s2);
            }
        });
        Vector<double[]> totaliRicavi = new Vector<double[]>();
        double[] totali = null;
        int i = 0;
        while (i < listaStudiObj.length) {
            punto = (Double)listaStudiObj[i][0];
            ricavi = (Double)listaStudiObj[i][1];
            ++i;
            while (i < listaStudiObj.length && punto == (Double)listaStudiObj[i][0] && punto != 99.0) {
                ricavi += ((Double)listaStudiObj[i][1]).doubleValue();
                ++i;
            }
            totali = new double[]{punto, ricavi};
            totaliRicavi.addElement(totali);
        }
        Vector<double[]> appo = new Vector<double[]>();
        int cont = 0;
        double perc = 0.0;
        int x = 0;
        while (x < totaliRicavi.size()) {
            int k = 0;
            while (k < listaStudiObj.length) {
                if (!((String)listaStudiObj[k][2]).equalsIgnoreCase("RICAG") && (Double)listaStudiObj[k][0] != 99.0 && ((double[])totaliRicavi.elementAt(x))[0] == (Double)listaStudiObj[k][0] && (perc = (Double)listaStudiObj[k][1] / ((double[])totaliRicavi.elementAt(x))[1] * 100.0) <= 20.0) {
                    double puntoAppo = ((double[])totaliRicavi.elementAt(x))[0];
                    double puntoPerc = (Double)listaStudiObj[k][1];
                    appo.addElement(new double[]{puntoAppo, puntoPerc});
                    ++cont;
                }
                ++k;
            }
            ++x;
        }
        if (cont > 0) {
            double[][] minori20perc = new double[cont][2];
            i = 0;
            while (i < cont) {
                minori20perc[i][0] = ((double[])appo.elementAt(i))[0];
                minori20perc[i][1] = ((double[])appo.elementAt(i))[1];
                ++i;
            }
            appo = null;
            ricaviTotaliPerPuntoMinori20Percento = new Vector();
            ricaviTotaliPerPuntoMinori20Percento.addElement(new double[]{0.0, 0.0});
            punto = minori20perc[0][0];
            ricavi = minori20perc[0][1];
            int contatore = 0;
            if (minori20perc.length == 1) {
                ricaviTotaliPerPuntoMinori20Percento.setElementAt(new double[]{punto, ricavi}, contatore);
            }
            int j = 1;
            while (j < minori20perc.length) {
                if (punto == minori20perc[j][0]) {
                    ricaviTotaliPerPuntoMinori20Percento.setElementAt(new double[]{punto, ricavi += minori20perc[j][1]}, contatore);
                } else {
                    ++contatore;
                    ricavi = minori20perc[j][1];
                    punto = minori20perc[j][0];
                    ricaviTotaliPerPuntoMinori20Percento.addElement(new double[]{punto, ricavi});
                }
                ++j;
            }
            return minori20perc;
        }
        return null;
    }

    public Vector getMessaggioErrore() {
        return this.messaggioErrore;
    }

    public ModelloN getModelloN() {
        return this.modelloN;
    }

    private double getPercentuale(double ricavo, double ricavoTotale) {
        return ricavo * 100.0 / ricavoTotale;
    }

    private Posizione getPosizione(int indice) {
        return (Posizione)this.getValore(indice, 2);
    }

    private Posizione getPosizioneAll(int indice) {
        return (Posizione)this.getValoreAll(indice, 2);
    }

    private boolean getQuadro_M_AnnotazioneDistinta(int indice) {
        return (Boolean)this.getValoreAll(indice, 1);
    }

    private String getQuadro_M_CodiceStudio(int indice) {
        return (String)this.getValoreAll(indice, 3);
    }

    private double getRicavo(int i) {
        double esistenze = this.getVal("F00301", i) - this.getVal("F00401", i);
        double rimanenze = this.getVal("F00701", i) - this.getVal("F00801", i);
        return this.max(0.0, this.getVal("F01401", i) + this.getVal("F01601", i) - this.getVal("F01602", i) + rimanenze - esistenze);
    }

    private double getRicavo(Posizione posizione) {
        double esistenze = ((NumericModel)posizione.getCampo("F00301")).doubleValue() - ((NumericModel)posizione.getCampo("F00401")).doubleValue();
        double rimanenze = ((NumericModel)posizione.getCampo("F00701")).doubleValue() - ((NumericModel)posizione.getCampo("F00801")).doubleValue();
        return this.max(0.0, ((NumericModel)posizione.getCampo("F01401")).doubleValue() + ((NumericModel)posizione.getCampo("F01601")).doubleValue() - ((NumericModel)posizione.getCampo("F01602")).doubleValue() + rimanenze - esistenze);
    }

    private double getRicavoAll(int i) {
        double esistenze = this.getValAll("F00301", i) - this.getValAll("F00401", i);
        double rimanenze = this.getValAll("F00701", i) - this.getValAll("F00801", i);
        return this.max(0.0, this.getValAll("F01401", i) + this.getValAll("F01601", i) - this.getValAll("F01602", i) + rimanenze - esistenze);
    }

    private double getVal(String code) {
        return Double.valueOf(this.getPosizione(this.indiceStudio).getCampo(code).getValue());
    }

    private double getVal(String code, int indexStudio) {
        return Double.valueOf(this.getPosizione(indexStudio).getCampo(code).getValue());
    }

    private double getValAll(String code, int indice) {
        return Double.valueOf(((Posizione)((Object[])this.listaStudiTotale.elementAt(indice))[2]).getCampo(code).getValue());
    }

    private double getValN(String code) {
        return Double.valueOf(this.modelloN.getCampo(code).getValue());
    }

    private Object getValore(int indice, int tipo) {
        return ((Object[])this.listaStudi.elementAt(indice))[tipo];
    }

    private Object getValoreAll(int indice, int tipo) {
        return ((Object[])this.listaStudiTotale.elementAt(indice))[tipo];
    }

    private double getValoreCampiPersonale(Posizione pos) {
        double valoreCampiPosizione = 0.0;
        String[] campiPersonale = this.caricaCampiPersonale_F12();
        int i = 0;
        while (i < campiPersonale.length) {
            valoreCampiPosizione += new Double(pos.getCampo(campiPersonale[i]).getValue()).doubleValue();
            ++i;
        }
        return valoreCampiPosizione;
    }

    protected double getValutaValue(String code) throws Exception {
        GericoModel gm = this.modelloN.getCampo(code);
        if (gm == null) {
            throw new Exception();
        }
        if (gm instanceof ValutaNumericModel) {
            return new Double(((ValutaNumericModel)gm).getValue());
        }
        throw new Exception();
    }

    protected double max(double a, double b) {
        return Math.max(a, b);
    }

    private void ordinaStudi20Percento() {
        Arrays.sort((Object[])this.listaStudiMinori20Perc, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                double s1 = ((double[])obj1)[0];
                double s2 = ((double[])obj2)[0];
                return (int)(s1 - s2);
            }
        });
    }

    private void recuperaCoefficenti() {
        try {
            String[] codiciStudio = new String[this.listaStudi.size()];
            int i = 0;
            while (i < this.listaStudi.size()) {
                codiciStudio[i] = ((Posizione)((Object[])this.listaStudi.elementAt(i))[2]).getChiave().getCodiceStudio();
                ++i;
            }
            this.listaCoefficentiContabile = new double[this.listaStudi.size()][this.NUMERO_COEFFICENTI_CONTABILE];
            this.listaCoefficentiPersonale = new double[this.listaStudi.size()];
            this.listaCoefficentiContabileMagazzino = new double[this.listaStudi.size()];
            this.listaCoefficentiCostoDelVenduto = new double[this.listaStudi.size()];
            this.listaCvCvProd = new String[this.listaStudi.size()];
            CalcoloAsSet cs = new CalcoloAsSet(codiciStudio);
            String[] coeffStudio = null;
            int i2 = 0;
            while (i2 < codiciStudio.length) {
                coeffStudio = cs.getRigaCoefficenti(i2);
                int j = 0;
                while (j < this.NUMERO_COEFFICENTI_CONTABILE) {
                    this.listaCoefficentiContabile[i2][j] = new Double(coeffStudio[j + 1]);
                    ++j;
                }
                this.listaCoefficentiPersonale[i2] = new Double(coeffStudio[3]);
                this.listaCoefficentiContabileMagazzino[i2] = new Double(coeffStudio[5]);
                this.listaCoefficentiCostoDelVenduto[i2] = new Double(coeffStudio[6]);
                this.listaCvCvProd[i2] = coeffStudio[7];
                ++i2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Vector recuperoPercInciRicaviStudi() {
        Vector<Object[]> listaIncidenzaStudi = new Vector<Object[]>();
        Object[] obj = null;
        double ricaviTot = 0.0;
        double punto = 0.0;
        Object[] listaStudiObj = new Object[this.listaStudiTotale.size()];
        this.listaStudiTotale.copyInto(listaStudiObj);
        Arrays.sort(listaStudiObj, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                int s1 = Integer.parseInt(((Posizione)((Object[])obj1)[2]).getChiave().getProgressivo());
                int s2 = Integer.parseInt(((Posizione)((Object[])obj2)[2]).getChiave().getProgressivo());
                return s1 - s2;
            }
        });
        Vector<double[]> totaliRicavi = new Vector<double[]>();
        double[] totali = null;
        int j = 0;
        int i = 1;
        while (j < listaStudiObj.length) {
            punto = Double.valueOf(((Posizione)((Object[])listaStudiObj[j])[2]).getChiave().getProgressivo());
            ricaviTot = (Double)((Object[])listaStudiObj[j])[0];
            while (i < listaStudiObj.length) {
                if (punto == Double.valueOf(((Posizione)((Object[])listaStudiObj[i])[2]).getChiave().getProgressivo())) {
                    ricaviTot += ((Double)((Object[])listaStudiObj[i])[0]).doubleValue();
                    j = i;
                }
                ++i;
            }
            totali = new double[]{punto, ricaviTot};
            totaliRicavi.addElement(totali);
            i = ++j + 1;
        }
        double perc = 0.0;
        int x = 0;
        while (x < totaliRicavi.size()) {
            int k = 0;
            while (k < listaStudiObj.length) {
                if (((double[])totaliRicavi.elementAt(x))[0] == Double.valueOf(((Posizione)((Object[])listaStudiObj[k])[2]).getChiave().getProgressivo())) {
                    perc = (Double)((Object[])listaStudiObj[k])[0] / ((double[])totaliRicavi.elementAt(x))[1] * 100.0;
                    obj = new Object[]{new Double(Double.valueOf(((Posizione)((Object[])listaStudiObj[k])[2]).getChiave().getProgressivo())), new Double(perc), (Posizione)((Object[])listaStudiObj[k])[2]};
                    listaIncidenzaStudi.addElement(obj);
                }
                ++k;
            }
            ++x;
        }
        return listaIncidenzaStudi;
    }

    private void ripartisceRicaviStudiMinori20PerCento() {
        if (this.listaStudiMinori20Perc.length == 0) {
            return;
        }
        this.ordinaStudi20Percento();
        Vector totStudiMinori20Perc = this.sommaStudiMinori20Perc();
        Vector puntiPercentualiProgressivi = this.recuperoPercInciRicaviStudi();
        this.spalmaStudiMinori20Perc(totStudiMinori20Perc, puntiPercentualiProgressivi);
    }

    private void scorporaValoriQuadroN(double coeff_sc) {
        try {
            this.modelloN.getCampo("N00101").setValore(String.valueOf(Math.round(this.getValN("N00101") * coeff_sc)));
            this.modelloN.getCampo("N00201").setValore(String.valueOf(Math.round(this.getValN("N00201") * coeff_sc)));
            this.modelloN.getCampo("N00301").setValore(String.valueOf(Math.round(this.getValN("N00301") * coeff_sc)));
            this.modelloN.getCampo("N00401").setValore(String.valueOf(Math.round(this.getValN("N00401") * coeff_sc)));
            this.modelloN.getCampo("N00501").setValore(String.valueOf(Math.round(this.getValN("N00501") * coeff_sc)));
            this.modelloN.getCampo("N00601").setValore(String.valueOf(Math.round(this.getValN("N00601") * coeff_sc)));
            this.modelloN.getCampo("N00701").setValore(String.valueOf(Math.round(this.getValN("N00701") * coeff_sc)));
            this.modelloN.getCampo("N00801").setValore(String.valueOf(Math.round(this.getValN("N00801") * coeff_sc)));
            this.modelloN.getCampo("N00901").setValore(String.valueOf(Math.round(this.getValN("N00901") * coeff_sc)));
            this.modelloN.getCampo("N01001").setValore(String.valueOf(Math.round(this.getValN("N01001") * coeff_sc)));
            this.modelloN.getCampo("N01101").setValore(String.valueOf(Math.round(this.getValN("N01101") * coeff_sc)));
            this.modelloN.getCampo("N01201").setValore(String.valueOf(Math.round(this.getValN("N01201") * coeff_sc)));
            this.modelloN.getCampo("N01301").setValore(String.valueOf(Math.round(this.getValN("N01301") * coeff_sc)));
            this.modelloN.getCampo("N01401").setValore(String.valueOf(Math.round(this.getValN("N01401") * coeff_sc)));
            this.modelloN.getCampo("N01501").setValore(String.valueOf(Math.round(this.getValN("N01501") * coeff_sc)));
            this.modelloN.getCampo("N01601").setValore(String.valueOf(Math.round(this.getValN("N01601") * coeff_sc)));
            this.modelloN.getCampo("N01701").setValore(String.valueOf(Math.round(this.getValN("N01701") * coeff_sc)));
            this.modelloN.getCampo("N01801").setValore(String.valueOf(Math.round(this.getValN("N01801") * coeff_sc)));
            this.modelloN.getCampo("N01901").setValore(String.valueOf(Math.round(this.getValN("N01901") * coeff_sc)));
            this.modelloN.getCampo("N02601").setValore(String.valueOf(Math.round(this.getValN("N02601") * coeff_sc)));
            this.modelloN.getCampo("N02701").setValore(String.valueOf(Math.round(this.getValN("N02701") * coeff_sc)));
            this.modelloN.getCampo("N02801").setValore(String.valueOf(Math.round(this.getValN("N02801") * coeff_sc)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void settaMultiattivita(Vector param) {
        Boolean multiAttivita = new Boolean(false);
        String app = ((String[])param.elementAt(0))[1];
        int i = 1;
        while (i < param.size()) {
            if (((String[])param.elementAt(i))[2].equals("99")) break;
            if (!((String[])param.elementAt(i))[1].equals(app)) {
                multiAttivita = new Boolean(true);
                break;
            }
            ++i;
        }
        i = 0;
        while (i < param.size()) {
            this.listaMultiattivita[Integer.parseInt((String)((String[])param.elementAt((int)i))[0])] = multiAttivita;
            ++i;
        }
    }

    private void setVal(String code, double valore) {
        try {
            this.getPosizione(this.indiceStudio).getCampo(code).setValore(String.valueOf(Math.round(valore)));
        }
        catch (ControlloFormaleException cfe) {
            cfe.printStackTrace();
        }
    }

    private void setValN(String code, double valore) {
        try {
            this.modelloN.getCampo(code).setValore(String.valueOf(Math.round(valore)));
        }
        catch (ControlloFormaleException cfe) {
            cfe.printStackTrace();
        }
    }

    private Vector sommaStudiMinori20Perc() {
        Vector<double[]> totaliRicavi = new Vector<double[]>();
        double punto = 0.0;
        double totale = 0.0;
        int i = 0;
        while (i < this.listaStudiMinori20Perc.length) {
            punto = this.listaStudiMinori20Perc[i][0];
            totale = this.listaStudiMinori20Perc[i][1];
            ++i;
            while (i < this.listaStudiMinori20Perc.length && punto == this.listaStudiMinori20Perc[i][0]) {
                totale += this.listaStudiMinori20Perc[i][1];
                ++i;
            }
            totaliRicavi.addElement(new double[]{punto, totale});
        }
        return totaliRicavi;
    }

    private void spalmaResti(int unitaDaSpalmare, double[][] appoggio, int i, double valoreCampoQuadroN) {
        double[] percentualiScopertura = new double[this.listaStudi.size()];
        int j = 0;
        while (j < this.listaStudi.size()) {
            percentualiScopertura[j] = this.listaPercentualiRicavi[j] - appoggio[i][j] / valoreCampoQuadroN;
            ++j;
        }
        int indiceValoreMax = 0;
        double valoreDaConfrontare = 0.0;
        int h = 0;
        while (h < unitaDaSpalmare) {
            int j2 = 0;
            while (j2 < this.listaStudi.size()) {
                if (percentualiScopertura[j2] > valoreDaConfrontare) {
                    indiceValoreMax = j2;
                    valoreDaConfrontare = percentualiScopertura[j2];
                }
                ++j2;
            }
            this.valore[i][indiceValoreMax] = this.valore[i][indiceValoreMax] + 1.0;
            percentualiScopertura[indiceValoreMax] = 0.0;
            valoreDaConfrontare = 0.0;
            indiceValoreMax = 0;
            ++h;
        }
    }

    private void spalmaStudiMinori20Perc(Vector totStudiMinori20Perc, Vector listaIncidenzaRicavi) {
        double punto = 0.0;
        double totale = 0.0;
        double puntoIncidenza = 0.0;
        double totaleNuovoValore = 0.0;
        Vector<GericoModel> gericoModel = new Vector<GericoModel>();
        int i = 0;
        while (i < totStudiMinori20Perc.size()) {
            punto = ((double[])totStudiMinori20Perc.elementAt(i))[0];
            totale = ((double[])totStudiMinori20Perc.elementAt(i))[1];
            int j = 0;
            while (j < listaIncidenzaRicavi.size()) {
                puntoIncidenza = (Double)((Object[])listaIncidenzaRicavi.elementAt(j))[0];
                if (punto == puntoIncidenza) {
                    GericoModel gm = ((Posizione)((Object[])listaIncidenzaRicavi.elementAt(j))[2]).getCampo("F01401");
                    double percentuale = (Double)((Object[])listaIncidenzaRicavi.elementAt(j))[1];
                    double nuovoValore = Math.round(Double.valueOf(gm.getValue()) + percentuale * totale / 100.0);
                    totaleNuovoValore += nuovoValore - Double.valueOf(gm.getValue());
                    try {
                        gm.setValore(String.valueOf((int)nuovoValore));
                    }
                    catch (ControlloFormaleException cfe) {
                        cfe.printStackTrace();
                        System.out.println("Eccezzione verificatasi in: spalmaStudiMinori20Perc()");
                    }
                    gericoModel.addElement(gm);
                }
                ++j;
            }
            if (totaleNuovoValore != totale) {
                this.correggeDifferenze(gericoModel, totale - totaleNuovoValore);
            }
            gericoModel.removeAllElements();
            totaleNuovoValore = 0.0;
            ++i;
        }
    }

    private boolean tuttiDistinti() {
        int i = 0;
        while (i < this.listaStudiTotale.size()) {
            if (!this.getQuadro_M_AnnotazioneDistinta(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

