/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.actions;

import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.actions.ProfileModificationAction;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.viewers.ISelectionProvider;

public abstract class ExistingIUInProfileAction
extends ProfileModificationAction {
    public ExistingIUInProfileAction(ProvisioningUI ui, String label, ISelectionProvider selectionProvider, String profileId) {
        super(ui, label, selectionProvider, profileId);
    }

    protected boolean isEnabledFor(Object[] selectionArray) {
        Object parent = null;
        IProfile profile = this.getProfile();
        if (selectionArray.length > 0) {
            int i = 0;
            while (i < selectionArray.length) {
                if (selectionArray[i] instanceof InstalledIUElement) {
                    InstalledIUElement element = (InstalledIUElement)selectionArray[i];
                    if (parent == null) {
                        parent = element.getParent(element);
                    } else if (parent != element.getParent(element)) {
                        return false;
                    }
                    if (!this.isSelectable(element.getIU(), profile)) {
                        return false;
                    }
                } else {
                    IInstallableUnit iu = ProvUI.getAdapter(selectionArray[i], IInstallableUnit.class);
                    if (iu == null || !this.isSelectable(iu)) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected boolean isSelectable(IIUElement element) {
        IProfile profile;
        if (!super.isSelectable(element)) {
            return false;
        }
        Object parent = element.getParent(element);
        if (parent != null && (profile = ProvUI.getAdapter(parent, IProfile.class)) != null) {
            return this.isSelectable(element.getIU(), profile);
        }
        return false;
    }

    protected boolean isSelectable(IInstallableUnit iu) {
        if (!super.isSelectable(iu)) {
            return false;
        }
        return this.isSelectable(iu, this.getProfile());
    }

    private boolean isSelectable(IInstallableUnit iu, IProfile profile) {
        int lock = this.getLock(profile, iu);
        if ((lock & this.getLockConstant()) == this.getLockConstant()) {
            return false;
        }
        return !profile.query(QueryUtil.createPipeQuery((IQuery)QueryUtil.createIUQuery((IVersionedId)iu), this.getPolicy().getVisibleInstalledIUQuery()), null).isEmpty();
    }

    protected abstract int getLockConstant();
}

